/* Do not touch this file manually.
 * It is generated from 'snapshot-rev4.json' using 'snapshot-json2c.py`.
 */


typedef struct TestVector_tag TestVector;
struct TestVector_tag {
    const char hex_str[8];
    double rgb_r;
    double rgb_g;
    double rgb_b;
    double xyz_x;
    double xyz_y;
    double xyz_z;
    double luv_l;
    double luv_u;
    double luv_v;
    double lch_l;
    double lch_c;
    double lch_h;
    double hsluv_h;
    double hsluv_s;
    double hsluv_l;
    double hpluv_h;
    double hpluv_s;
    double hpluv_l;
};

static const TestVector snapshot[] = {
    {
        "#000000",
        0.0, 0.0, 0.0,  /* rgb */
        0.0, 0.0, 0.0,  /* xyz */
        0.0, 0.0, 0.0,  /* luv */
        0.0, 0.0, 0.0,  /* lch */
        0.0, 0.0, 0.0,  /* hsluv */
        0.0, 0.0, 0.0,  /* hpluv */
    },
    {
        "#000011",
        0.0, 0.0, 0.06666666666666667,  /* rgb */
        0.0010116654996371217, 0.0004046661998548544, 0.0053281049647556315,  /* xyz */
        0.36553347952621895, -0.10640253083479542, -1.4751207214237791,  /* luv */
        0.36553347952621895, 1.478953224866108, 265.8743202181779,  /* lch */
        265.8743202181779, 100.00000000000087, 0.36553347952621895,  /* hsluv */
        265.8743202181779, 513.4126968442804, 0.36553347952621895,  /* hpluv */
    },
    {
        "#000022",
        0.0, 0.0, 0.13333333333333333,  /* rgb */
        0.002887023638114141, 0.0011548094552456725, 0.015204991160734828,  /* xyz */
        1.0431351037401557, -0.3036444573679825, -4.20960128950726,  /* luv */
        1.0431351037401557, 4.22053823263236, 265.8743202181779,  /* lch */
        265.8743202181779, 100.00000000000084, 1.0431351037401557,  /* hsluv */
        265.8743202181779, 513.4126968442804, 1.0431351037401557,  /* hpluv */
    },
    {
        "#000033",
        0.0, 0.0, 0.2,  /* rgb */
        0.005974774370571881, 0.0023899097482287857, 0.03146714501834597,  /* xyz */
        2.1587966238273366, -0.6284005082942454, -8.711884988688109,  /* luv */
        2.1587966238273366, 8.73451929157831, 265.8743202181779,  /* lch */
        265.8743202181779, 100.00000000000084, 2.1587966238273366,  /* hsluv */
        265.8743202181779, 513.4126968442803, 2.1587966238273366,  /* hpluv */
    },
    {
        "#000044",
        0.0, 0.0, 0.26666666666666666,  /* rgb */
        0.01043276961479076, 0.004173107845916362, 0.05494591997123261,  /* xyz */
        3.76955286085941, -1.0972728545435857, -15.212137456637967,  /* luv */
        3.76955286085941, 15.251660031516769, 265.87432021817796,  /* lch */
        265.87432021817796, 100.00000000000098, 3.76955286085941,  /* hsluv */
        265.87432021817796, 513.4126968442804, 3.76955286085941,  /* hpluv */
    },
    {
        "#000055",
        0.0, 0.0, 0.3333333333333333,  /* rgb */
        0.016395183654152753, 0.006558073461661194, 0.08634796724520652,  /* xyz */
        5.9238834681260695, -1.724373357526631, -23.905999708860417,  /* luv */
        5.9238834681260695, 23.968109761851935, 265.8743202181779,  /* lch */
        265.8743202181779, 100.00000000000084, 5.9238834681260695,  /* hsluv */
        265.8743202181779, 513.4126968442804, 5.9238834681260695,  /* hpluv */
    },
    {
        "#000066",
        0.0, 0.0, 0.4,  /* rgb */
        0.02398017942766093, 0.009592071771064506, 0.12629561165235048,  /* xyz */
        8.64689012997685, -2.517008824670342, -34.894770304312715,  /* luv */
        8.64689012997685, 34.98543022479805, 265.8743202181779,  /* lch */
        265.8743202181779, 100.00000000000084, 8.64689012997685,  /* hsluv */
        265.8743202181779, 513.4126968442803, 8.64689012997685,  /* hpluv */
    },
    {
        "#000077",
        0.0, 0.0, 0.4666666666666667,  /* rgb */
        0.033294192447862844, 0.013317676979145323, 0.1753494135587484,  /* xyz */
        11.495870994862386, -3.3463139124467958, -46.39191336814267,  /* luv */
        11.495870994862386, 46.51244395597687, 265.87432021817796,  /* lch */
        265.87432021817796, 100.000000000001, 11.495870994862386,  /* hsluv */
        265.87432021817796, 513.4126968442803, 11.495870994862386,  /* hpluv */
    },
    {
        "#000088",
        0.0, 0.0, 0.5333333333333333,  /* rgb */
        0.04443460954980667, 0.017773843819922915, 0.23402227696232056,  /* xyz */
        14.272743126274555, -4.154628989275958, -57.59805959337917,  /* luv */
        14.272743126274555, 57.74770481119565, 265.87432021817796,  /* lch */
        265.87432021817796, 100.00000000000095, 14.272743126274555,  /* hsluv */
        265.87432021817796, 513.4126968442804, 14.272743126274555,  /* hpluv */
    },
    {
        "#000099",
        0.0, 0.0, 0.6,  /* rgb */
        0.057491573658879386, 0.022996629463552076, 0.30278895460343846,  /* xyz */
        16.987245436181382, -4.944788938797809, -68.55251063541856,  /* luv */
        16.987245436181382, 68.73061655527637, 265.87432021817796,  /* lch */
        265.87432021817796, 100.00000000000095, 16.987245436181382,  /* hsluv */
        265.87432021817796, 513.4126968442802, 16.987245436181382,  /* hpluv */
    },
    {
        "#0000aa",
        0.0, 0.0, 0.6666666666666666,  /* rgb */
        0.07254926662413193, 0.029019706649653178, 0.38209280422043707,  /* xyz */
        19.64694602625233, -5.718996747103513, -79.28580778314341,  /* luv */
        19.64694602625233, 79.49179982626475, 265.8743202181779,  /* lch */
        265.8743202181779, 100.00000000000082, 19.64694602625233,  /* hsluv */
        265.8743202181779, 513.4126968442804, 19.64694602625233,  /* hpluv */
    },
    {
        "#0000bb",
        0.0, 0.0, 0.7333333333333333,  /* rgb */
        0.08968685873146857, 0.035874743492587936, 0.4723507893190788,  /* xyz */
        22.257882065655274, -6.479009763695939, -89.82231420391616,  /* luv */
        22.257882065655274, 90.05568108934109, 265.8743202181779,  /* lch */
        265.8743202181779, 100.0000000000008, 22.257882065655274,  /* hsluv */
        265.8743202181779, 513.4126968442804, 22.257882065655274,  /* hpluv */
    },
    {
        "#0000cc",
        0.0, 0.0, 0.8,  /* rgb */
        0.10897923417519031, 0.04359169367007674, 0.573957299989349,  /* xyz */
        24.824972753654627, -7.226259910083615, -100.18188146585355,  /* luv */
        24.824972753654627, 100.44216348887758, 265.87432021817796,  /* lch */
        265.87432021817796, 100.000000000001, 24.824972753654627,  /* hsluv */
        265.87432021817796, 513.4126968442804, 24.824972753654627,  /* hpluv */
    },
    {
        "#0000dd",
        0.0, 0.0, 0.8666666666666667,  /* rgb */
        0.13049755972582386, 0.05219902389033027, 0.687287147889355,  /* xyz */
        27.352297321178654, -7.961934602793193, -110.38097142103416,  /* luv */
        27.352297321178654, 110.66775164640472, 265.8743202181779,  /* lch */
        265.8743202181779, 100.00000000000082, 27.352297321178654,  /* hsluv */
        265.8743202181779, 513.4126968442803, 27.352297321178654,  /* hpluv */
    },
    {
        "#0000ee",
        0.0, 0.0, 0.9333333333333333,  /* rgb */
        0.1543097399919986, 0.0617238959968003, 0.8126979639578782,  /* xyz */
        29.843288776647974, -8.68703315051946, -120.43343807228331,  /* luv */
        29.843288776647974, 120.74633555876022, 265.8743202181779,  /* lch */
        265.8743202181779, 100.00000000000084, 29.843288776647974,  /* hsluv */
        265.8743202181779, 513.4126968442804, 29.843288776647974,  /* hpluv */
    },
    {
        "#0000ff",
        0.0, 0.0, 1.0,  /* rgb */
        0.18048078840183, 0.072192315360733, 0.95053215224966,  /* xyz */
        32.30087290398002, -9.40240721482262, -130.3510885035611,  /* luv */
        32.30087290398002, 130.68975298582734, 265.8743202181779,  /* lch */
        265.8743202181779, 100.00000000000082, 32.30087290398002,  /* hsluv */
        265.8743202181779, 513.4126968442804, 32.30087290398002,  /* hpluv */
    },
    {
        "#001100",
        0.0, 0.06666666666666667, 0.0,  /* rgb */
        0.002004400260928409, 0.0040088005218568735, 0.0006681334203094509,  /* xyz */
        3.621134663597941, -3.428454400857531, 4.433500252284744,  /* luv */
        3.621134663597941, 5.604482497587824, 127.71501294924047,  /* lch */
        127.71501294924047, 100.00000000000222, 3.621134663597941,  /* hsluv */
        127.71501294924047, 196.39488290021447, 3.621134663597941,  /* hpluv */
    },
    {
        "#001111",
        0.0, 0.06666666666666667, 0.06666666666666667,  /* rgb */
        0.0030160657605655308, 0.004413466721711728, 0.005996238385065082,  /* xyz */
        3.9866681431241604, -3.083124210781181, -0.6653025129698942,  /* luv */
        3.9866681431241604, 3.154089778821956, 192.17705063006116,  /* lch */
        192.17705063006116, 99.9999999999914, 3.9866681431241604,  /* hsluv */
        192.17705063006116, 100.39296752732076, 3.9866681431241604,  /* hpluv */
    },
    {
        "#001122",
        0.0, 0.06666666666666667, 0.13333333333333333,  /* rgb */
        0.004891423899042549, 0.005163609977102546, 0.015873124581044278,  /* xyz */
        4.664269767338097, -2.8670931483799724, -6.7149511879403105,  /* luv */
        4.664269767338097, 7.301424010281034, 246.87889630792742,  /* lch */
        246.87889630792742, 99.99999999999214, 4.664269767338097,  /* hsluv */
        246.87889630792742, 198.63841235121018, 4.664269767338097,  /* hpluv */
    },
    {
        "#001133",
        0.0, 0.06666666666666667, 0.2,  /* rgb */
        0.00797917463150029, 0.006398710270085659, 0.03213527843865542,  /* xyz */
        5.779931287425278, -2.8956922029252143, -13.59292905374293,  /* luv */
        5.779931287425278, 13.897940624213737, 257.9740872639393,  /* lch */
        257.9740872639393, 99.9999999999925, 5.779931287425278,  /* hsluv */
        257.9740872639393, 305.11748991257946, 5.779931287425278,  /* hpluv */
    },
    {
        "#001144",
        0.0, 0.06666666666666667, 0.26666666666666666,  /* rgb */
        0.012437169875719169, 0.008181908367773235, 0.05561405339154206,  /* xyz */
        7.390687524457351, -3.1805605696034065, -21.569213444774455,  /* luv */
        7.390687524457351, 21.80245248047006, 261.61170870202864,  /* lch */
        261.61170870202864, 99.99999999999297, 7.390687524457351,  /* hsluv */
        261.61170870202864, 374.3344820488026, 7.390687524457351,  /* hpluv */
    },
    {
        "#001155",
        0.0, 0.06666666666666667, 0.3333333333333333,  /* rgb */
        0.01839958391508116, 0.010566873983518067, 0.08701610066551597,  /* xyz */
        9.455023284445971, -3.660230253230338, -30.87240942375629,  /* luv */
        9.455023284445971, 31.088630544536677, 263.2385798661289,  /* lch */
        263.2385798661289, 99.99999999999295, 9.455023284445971,  /* hsluv */
        263.2385798661289, 417.2326782035226, 9.455023284445971,  /* hpluv */
    },
    {
        "#001166",
        0.0, 0.06666666666666667, 0.4,  /* rgb */
        0.02598457968858934, 0.01360087229292138, 0.12696374507265992,  /* xyz */
        11.689402019298768, -4.207416789339907, -40.71727231239558,  /* luv */
        11.689402019298768, 40.93407652068133, 264.1004232423591,  /* lch */
        264.1004232423591, 99.99999999999282, 11.689402019298768,  /* hsluv */
        264.1004232423591, 444.35700256730837, 11.689402019298768,  /* hpluv */
    },
    {
        "#001177",
        0.0, 0.06666666666666667, 0.4666666666666667,  /* rgb */
        0.03529859270879125, 0.017326477501002198, 0.17601754697905783,  /* xyz */
        14.016594310160396, -4.796131955590923, -50.82027797109726,  /* luv */
        14.016594310160396, 51.04609225783139, 264.6087146649775,  /* lch */
        264.6087146649775, 99.99999999999315, 14.016594310160396,  /* hsluv */
        264.6087146649775, 462.1248515515596, 14.016594310160396,  /* hpluv */
    },
    {
        "#001188",
        0.0, 0.06666666666666667, 0.5333333333333333,  /* rgb */
        0.04643900981073508, 0.02178264434177979, 0.23469041038263,  /* xyz */
        16.396258529535338, -5.412890851956304, -61.03259986985979,  /* luv */
        16.396258529535338, 61.27216035239496, 264.9317827306522,  /* lch */
        264.9317827306522, 99.99999999999332, 16.396258529535338,  /* hsluv */
        264.9317827306522, 474.19586448532954, 16.396258529535338,  /* hpluv */
    },
    {
        "#001199",
        0.0, 0.06666666666666667, 0.6,  /* rgb */
        0.05949597391980779, 0.02700542998540895, 0.30345708802374793,  /* xyz */
        18.802332726248494, -6.048269664487052, -71.26380408345658,  /* luv */
        18.802332726248494, 71.52000656026001, 265.1488438888598,  /* lch */
        265.1488438888598, 99.99999999999307, 18.802332726248494,  /* hsluv */
        265.1488438888598, 482.6753703102129, 18.802332726248494,  /* hpluv */
    },
    {
        "#0011aa",
        0.0, 0.06666666666666667, 0.6666666666666666,  /* rgb */
        0.07455366688506034, 0.033028507171510055, 0.38276093764074653,  /* xyz */
        21.218109060333212, -6.695690868054439, -81.46021545518805,  /* luv */
        21.218109060333212, 81.73493119961749, 265.3010884471613,  /* lch */
        265.3010884471613, 99.99999999999318, 21.218109060333212,  /* hsluv */
        265.3010884471613, 488.81030222212587, 21.218109060333212,  /* hpluv */
    },
    {
        "#0011bb",
        0.0, 0.06666666666666667, 0.7333333333333333,  /* rgb */
        0.09169125899239698, 0.03988354401444481, 0.4730189227393883,  /* xyz */
        23.63290473230642, -7.350545037170704, -91.59075414653972,  /* luv */
        23.63290473230642, 91.8852368853417, 265.41160561446134,  /* lch */
        265.41160561446134, 99.999999999993, 23.63290473230642,  /* hsluv */
        265.41160561446134, 493.36457372496125, 23.63290473230642,  /* hpluv */
    },
    {
        "#0011cc",
        0.0, 0.06666666666666667, 0.8,  /* rgb */
        0.11098363443611872, 0.047600494191933615, 0.5746254334096584,  /* xyz */
        26.039913112906135, -8.00958293333115, -101.63812264051379,  /* luv */
        26.039913112906135, 101.95323139878417, 265.4941234385924,  /* lch */
        265.4941234385924, 99.99999999999274, 26.039913112906135,  /* hsluv */
        265.4941234385924, 496.82196819453566, 26.039913112906135,  /* hpluv */
    },
    {
        "#0011dd",
        0.0, 0.06666666666666667, 0.8666666666666667,  /* rgb */
        0.13250195998675227, 0.05620782441218715, 0.6879552813096644,  /* xyz */
        28.43483595206839, -8.670500709494025, -111.59341952417508,  /* luv */
        28.43483595206839, 111.92974968100249, 265.5572019010858,  /* lch */
        265.5572019010858, 99.99999999999322, 28.43483595206839,  /* hsluv */
        265.5572019010858, 499.49843514930103, 28.43483595206839,  /* hpluv */
    },
    {
        "#0011ee",
        0.0, 0.06666666666666667, 0.9333333333333333,  /* rgb */
        0.156314140252927, 0.06573269651865718, 0.8133660973781877,  /* xyz */
        30.815011965413902, -9.331657217294298, -121.45285578173454,  /* luv */
        30.815011965413902, 121.81082055367615, 265.60639254385444,  /* lch */
        265.60639254385444, 99.99999999999336, 30.815011965413902,  /* hsluv */
        265.60639254385444, 501.6061522895639, 30.815011965413902,  /* hpluv */
    },
    {
        "#0011ff",
        0.0, 0.06666666666666667, 1.0,  /* rgb */
        0.1824851886627584, 0.07620111588258988, 0.9512002856699695,  /* xyz */
        33.17885724526697, -9.991880308657503, -131.21574369560415,  /* luv */
        33.17885724526697, 131.59562707663585, 265.64541693935166,  /* lch */
        265.64541693935166, 99.9999999999995, 33.17885724526697,  /* hsluv */
        265.64541693935166, 503.291227463659, 33.17885724526697,  /* hpluv */
    },
    {
        "#002200",
        0.0, 0.13333333333333333, 0.0,  /* rgb */
        0.005720023995696344, 0.011440047991392848, 0.0019066746652320612,  /* xyz */
        10.137694124520397, -9.598268295613591, 12.411985091432419,  /* luv */
        10.137694124520397, 15.690255835534412, 127.71501294924047,  /* lch */
        127.71501294924047, 100.00000000000233, 10.137694124520397,  /* hsluv */
        127.71501294924047, 196.39488290021458, 10.137694124520397,  /* hpluv */
    },
    {
        "#002211",
        0.0, 0.13333333333333333, 0.06666666666666667,  /* rgb */
        0.006731689495333466, 0.011844714191247703, 0.007234779629987692,  /* xyz */
        10.44231763493256, -9.120411029532386, 6.638115491427698,  /* luv */
        10.44231763493256, 11.280357912103161, 143.95172096742098,  /* lch */
        143.95172096742098, 99.9999999999911, 10.44231763493256,  /* hsluv */
        143.95172096742098, 137.07722581842046, 10.44231763493256,  /* hpluv */
    },
    {
        "#002222",
        0.0, 0.13333333333333333, 0.13333333333333333,  /* rgb */
        0.008607047633810485, 0.01259485744663852, 0.01711166582596689,  /* xyz */
        10.98914177426709, -8.49854762011842, -1.8338881931800342,  /* luv */
        10.98914177426709, 8.694162268816104, 192.17705063006116,  /* lch */
        192.17705063006116, 99.9999999999915, 10.98914177426709,  /* hsluv */
        192.17705063006116, 100.39296752732085, 10.98914177426709,  /* hpluv */
    },
    {
        "#002233",
        0.0, 0.13333333333333333, 0.2,  /* rgb */
        0.011694798366268225, 0.013829957739621633, 0.03337381968357803,  /* xyz */
        11.843998834137128, -7.900113402437388, -12.080292145633354,  /* luv */
        11.843998834137128, 14.43416953257865, 236.81663495428262,  /* lch */
        236.81663495428262, 99.99999999999186, 11.843998834137128,  /* hsluv */
        236.81663495428262, 154.64389241452866, 11.843998834137128,  /* hpluv */
    },
    {
        "#002244",
        0.0, 0.13333333333333333, 0.26666666666666666,  /* rgb */
        0.016152793610487104, 0.01561315583730921, 0.05685259463646467,  /* xyz */
        12.99267055906661, -7.486821119471744, -22.713300635140282,  /* luv */
        12.99267055906661, 23.91540332541419, 251.75660324105968,  /* lch */
        251.75660324105968, 99.99999999999226, 12.99267055906661,  /* hsluv */
        251.75660324105968, 233.57083287386916, 12.99267055906661,  /* hpluv */
    },
    {
        "#002255",
        0.0, 0.13333333333333333, 0.3333333333333333,  /* rgb */
        0.022115207649849096, 0.01799812145305404, 0.08825464191043858,  /* xyz */
        14.399542562796793, -7.295125665017621, -33.213598321623216,  /* luv */
        14.399542562796793, 34.00532270010875, 257.61210756428466,  /* lch */
        257.61210756428466, 99.99999999999226, 14.399542562796793,  /* hsluv */
        257.61210756428466, 299.66604162686406, 14.399542562796793,  /* hpluv */
    },
    {
        "#002266",
        0.0, 0.13333333333333333, 0.4,  /* rgb */
        0.029700203423357274, 0.021032119762457356, 0.12820228631758254,  /* xyz */
        16.01982872910437, -7.297785992543047, -43.51439299825879,  /* luv */
        16.01982872910437, 44.12210419279515, 260.47954115799024,  /* lch */
        260.47954115799024, 99.99999999999267, 16.01982872910437,  /* hsluv */
        260.47954115799024, 349.4923498109161, 16.01982872910437,  /* hpluv */
    },
    {
        "#002277",
        0.0, 0.13333333333333333, 0.4666666666666667,  /* rgb */
        0.03901421644355919, 0.024757724970538172, 0.17725608822398045,  /* xyz */
        17.808681486590814, -7.45254493353373, -53.66895636745027,  /* luv */
        17.808681486590814, 54.18392107957508, 262.09438404774465,  /* lch */
        262.09438404774465, 99.99999999999262, 17.808681486590814,  /* hsluv */
        262.09438404774465, 386.0806093889042, 17.808681486590814,  /* hpluv */
    },
    {
        "#002288",
        0.0, 0.13333333333333333, 0.5333333333333333,  /* rgb */
        0.050154633545503015, 0.029213891811315763, 0.23592895162755262,  /* xyz */
        19.726279763806957, -7.7213996360385595, -63.72845474864098,  /* luv */
        19.726279763806957, 64.19451656480479, 263.09166276861595,  /* lch */
        263.09166276861595, 99.99999999999281, 19.726279763806957,  /* hsluv */
        263.09166276861595, 412.9448659742926, 19.726279763806957,  /* hpluv */
    },
    {
        "#002299",
        0.0, 0.13333333333333333, 0.6,  /* rgb */
        0.06321159765457574, 0.03443667745494493, 0.30469562926867055,  /* xyz */
        21.739696521146193, -8.074802554434081, -73.72014706394921,  /* luv */
        21.739696521146193, 74.16105797130591, 263.7491295780799,  /* lch */
        263.7491295780799, 99.99999999999287, 21.739696521146193,  /* hsluv */
        263.7491295780799, 432.874263951475, 21.739696521146193,  /* hpluv */
    },
    {
        "#0022aa",
        0.0, 0.13333333333333333, 0.6666666666666666,  /* rgb */
        0.07826929061982828, 0.04045975464104602, 0.38399947888566915,  /* xyz */
        23.822856071330392, -8.490879612512115, -83.65338463738686,  /* luv */
        23.822856071330392, 84.08319569262794, 264.20428541614814,  /* lch */
        264.20428541614814, 99.99999999999253, 23.822856071330392,  /* hsluv */
        264.20428541614814, 447.87282165818834, 23.822856071330392,  /* hpluv */
    },
    {
        "#0022bb",
        0.0, 0.13333333333333333, 0.7333333333333333,  /* rgb */
        0.09540688272716492, 0.04731479148398078, 0.4742574639843109,  /* xyz */
        25.955635082486133, -8.95364890679069, -93.52817317565727,  /* luv */
        25.955635082486133, 93.95577154343319, 264.53161902146724,  /* lch */
        264.53161902146724, 99.99999999999328, 25.955635082486133,  /* hsluv */
        264.53161902146724, 459.3366831805053, 25.955635082486133,  /* hpluv */
    },
    {
        "#0022cc",
        0.0, 0.13333333333333333, 0.8,  /* rgb */
        0.11469925817088666, 0.05503174166146958, 0.5758639746545811,  /* xyz */
        28.122733334265547, -9.451412862385991, -103.34087655501835,  /* luv */
        28.122733334265547, 103.77218303695271, 264.77434562752615,  /* lch */
        264.77434562752615, 99.9999999999932, 28.122733334265547,  /* hsluv */
        264.77434562752615, 468.23378940708807, 28.122733334265547,  /* hpluv */
    },
    {
        "#0022dd",
        0.0, 0.13333333333333333, 0.8666666666666667,  /* rgb */
        0.1362175837215202, 0.06363907188172312, 0.689193822554587,  /* xyz */
        30.31261122190041, -9.975541230695026, -113.08721059901252,  /* luv */
        30.31261122190041, 113.52633449517653, 264.95892746812797,  /* lch */
        264.95892746812797, 99.99999999999307, 30.31261122190041,  /* hsluv */
        264.95892746812797, 475.2395683831163, 30.31261122190041,  /* hpluv */
    },
    {
        "#0022ee",
        0.0, 0.13333333333333333, 0.9333333333333333,  /* rgb */
        0.16002976398769495, 0.07316394398819315, 0.8146046386231103,  /* xyz */
        32.51660005194877, -10.519601137712538, -122.76355368691101,  /* luv */
        32.51660005194877, 123.21344132007532, 265.1022924730507,  /* lch */
        265.1022924730507, 99.99999999999315, 32.51660005194877,  /* hsluv */
        265.1022924730507, 480.83080634361215, 32.51660005194877,  /* hpluv */
    },
    {
        "#0022ff",
        0.0, 0.13333333333333333, 1.0,  /* rgb */
        0.18620081239752634, 0.08363236335212586, 0.9524388269148921,  /* xyz */
        34.728199222084136, -11.078745829152567, -132.36737272044766,  /* luv */
        34.728199222084136, 132.83019223828924, 265.2156687184063,  /* lch */
        265.2156687184063, 99.99999999999956, 34.728199222084136,  /* hsluv */
        265.2156687184063, 485.3486919201421, 34.728199222084136,  /* hpluv */
    },
    {
        "#003300",
        0.0, 0.2, 0.0,  /* rgb */
        0.011837746084707156, 0.023675492169414645, 0.003945915361568942,  /* xyz */
        17.308698327783638, -16.38770398448624, 21.191732849477287,  /* luv */
        17.308698327783638, 26.788922767568707, 127.71501294924046,  /* lch */
        127.71501294924046, 100.0000000000024, 17.308698327783638,  /* hsluv */
        127.71501294924046, 196.3948829002146, 17.308698327783638,  /* hpluv */
    },
    {
        "#003311",
        0.0, 0.2, 0.06666666666666667,  /* rgb */
        0.012849411584344278, 0.024080158369269498, 0.009274020326324572,  /* xyz */
        17.497400222384513, -15.90785576790496, 16.14037832264148,  /* luv */
        17.497400222384513, 22.662120102286597, 134.58430385811792,  /* lch */
        134.58430385811792, 99.99999999999093, 17.497400222384513,  /* hsluv */
        134.58430385811792, 164.3487244252561, 17.497400222384513,  /* hpluv */
    },
    {
        "#003322",
        0.0, 0.2, 0.13333333333333333,  /* rgb */
        0.014724769722821296, 0.024830301624660316, 0.01915090652230377,  /* xyz */
        17.841685693139723, -15.160415682176987, 7.951316651590826,  /* luv */
        17.841685693139723, 17.119043201950962, 152.32394227336937,  /* lch */
        152.32394227336937, 99.99999999999122, 17.841685693139723,  /* hsluv */
        152.32394227336937, 121.7539136551524, 17.841685693139723,  /* hpluv */
    },
    {
        "#003333",
        0.0, 0.2, 0.2,  /* rgb */
        0.017812520455279035, 0.026065401917643432, 0.035413060379914915,  /* xyz */
        18.393744804041354, -14.224961269996609, -3.0695819671275255,  /* luv */
        18.393744804041354, 14.552383192653293, 192.17705063006116,  /* lch */
        192.17705063006116, 99.9999999999915, 18.393744804041354,  /* hsluv */
        192.17705063006116, 100.39296752732085, 18.393744804041354,  /* hpluv */
    },
    {
        "#003344",
        0.0, 0.2, 0.26666666666666666,  /* rgb */
        0.022270515699497916, 0.02784860001533101, 0.058891835332801554,  /* xyz */
        19.16082946051238, -13.295112124692926, -15.41535038578591,  /* luv */
        19.16082946051238, 20.3566459399555, 229.22356780548324,  /* lch */
        229.22356780548324, 99.99999999999176, 19.16082946051238,  /* hsluv */
        229.22356780548324, 134.8128357685947, 19.16082946051238,  /* hpluv */
    },
    {
        "#003355",
        0.0, 0.2, 0.3333333333333333,  /* rgb */
        0.028232929738859908, 0.030233565631075838, 0.09029388260677546,  /* xyz */
        20.13719553357673, -12.507539801869436, -27.95305170315549,  /* luv */
        20.13719553357673, 30.62371060819757, 245.89396178418255,  /* lch */
        245.89396178418255, 99.99999999999204, 20.13719553357673,  /* hsluv */
        245.89396178418255, 192.97371224273138, 20.13719553357673,  /* hpluv */
    },
    {
        "#003366",
        0.0, 0.2, 0.4,  /* rgb */
        0.035817925512368086, 0.03326756394047915, 0.13024152701391942,  /* xyz */
        21.307686840292384, -11.920614069721276, -40.11790544712263,  /* luv */
        21.307686840292384, 41.85149193593352, 253.45123627813126,  /* lch */
        253.45123627813126, 99.99999999999208, 21.307686840292384,  /* hsluv */
        253.45123627813126, 249.23783245668628, 21.307686840292384,  /* hpluv */
    },
    {
        "#003377",
        0.0, 0.2, 0.4666666666666667,  /* rgb */
        0.04513193853257, 0.03699316914855997, 0.17929532892031733,  /* xyz */
        22.65139461031289, -11.537919031496369, -51.74796023729024,  /* luv */
        22.65139461031289, 53.018628464885225, 257.4307118536419,  /* lch */
        257.4307118536419, 99.99999999999224, 22.65139461031289,  /* hsluv */
        257.4307118536419, 297.01122933304276, 22.65139461031289,  /* hpluv */
    },
    {
        "#003388",
        0.0, 0.2, 0.5333333333333333,  /* rgb */
        0.056272355634513826, 0.04144933598933756, 0.2379681923238895,  /* xyz */
        24.14491244816481, -11.336916889963401, -62.874896486228764,  /* luv */
        24.14491244816481, 63.888796300477594, 259.77887209070224,  /* lch */
        259.77887209070224, 99.99999999999257, 24.14491244816481,  /* hsluv */
        259.77887209070224, 335.76729924907335, 24.14491244816481,  /* hpluv */
    },
    {
        "#003399",
        0.0, 0.2, 0.6,  /* rgb */
        0.06932931974358654, 0.04667212163296672, 0.30673486996500743,  /* xyz */
        25.764809398314533, -11.287437310946299, -73.59146436537246,  /* luv */
        25.764809398314533, 74.45206423255455, 261.2799470200554,  /* lch */
        261.2799470200554, 99.99999999999287, 25.764809398314533,  /* hsluv */
        261.2799470200554, 366.68161533200424, 25.764809398314533,  /* hpluv */
    },
    {
        "#0033aa",
        0.0, 0.2, 0.6666666666666666,  /* rgb */
        0.08438701270883908, 0.052695198819067826, 0.38603871958200603,  /* xyz */
        27.48922533261856, -11.360446037840406, -83.9913077831251,  /* luv */
        27.48922533261856, 84.75611787533884, 262.2970686778698,  /* lch */
        262.2970686778698, 99.99999999999258, 27.48922533261856,  /* hsluv */
        262.2970686778698, 391.2441722050976, 27.48922533261856,  /* hpluv */
    },
    {
        "#0033bb",
        0.0, 0.2, 0.7333333333333333,  /* rgb */
        0.10152460481617573, 0.059550235662002585, 0.4762967046806478,  /* xyz */
        29.29870821408118, -11.531133966499155, -94.14951847349572,  /* luv */
        29.29870821408118, 94.85303832426487, 263.0173708209007,  /* lch */
        263.0173708209007, 99.99999999999292, 29.29870821408118,  /* hsluv */
        263.0173708209007, 410.81103473497143, 29.29870821408118,  /* hpluv */
    },
    {
        "#0033cc",
        0.0, 0.2, 0.8,  /* rgb */
        0.12081698025989747, 0.06726718583949139, 0.5779032153509179,  /* xyz */
        31.176502672285828, -11.779387917305923, -104.12069797331976,  /* luv */
        31.176502672285828, 104.78489264277388, 263.54545464035294,  /* lch */
        263.54545464035294, 99.99999999999285, 31.176502672285828,  /* hsluv */
        263.54545464035294, 426.49172002965906, 31.176502672285828,  /* hpluv */
    },
    {
        "#0033dd",
        0.0, 0.2, 0.8666666666666667,  /* rgb */
        0.14233530581053103, 0.07587451605974492, 0.6912330632509239,  /* xyz */
        33.108496036114694, -12.089279872881512, -113.94271102216665,  /* luv */
        33.108496036114694, 114.58225029613372, 263.9435968844814,  /* lch */
        263.9435968844814, 99.99999999999272, 33.108496036114694,  /* hsluv */
        263.9435968844814, 439.15438182752337, 33.108496036114694,  /* hpluv */
    },
    {
        "#0033ee",
        0.0, 0.2, 0.9333333333333333,  /* rgb */
        0.16614748607670576, 0.08539938816621495, 0.8166438793194472,  /* xyz */
        35.08298209117961, -12.448307728459072, -123.64127106659264,  /* luv */
        35.08298209117961, 124.26634410114852, 264.2507861229273,  /* lch */
        264.2507861229273, 99.99999999999322, 35.08298209117961,  /* hsluv */
        264.2507861229273, 449.4654840136506, 35.08298209117961,  /* hpluv */
    },
    {
        "#0033ff",
        0.0, 0.2, 1.0,  /* rgb */
        0.19231853448653716, 0.09586780753014765, 0.954478067611229,  /* xyz */
        37.09034990285455, -12.846669987258633, -133.23377609215493,  /* luv */
        37.09034990285455, 133.85169413024255, 264.49245129145913,  /* lch */
        264.49245129145913, 99.99999999999953, 37.09034990285455,  /* hsluv */
        264.49245129145913, 457.933345064777, 37.09034990285455,  /* hpluv */
    },
    {
        "#004400",
        0.0, 0.26666666666666666, 0.0,  /* rgb */
        0.02067031656767319, 0.04134063313534696, 0.006890105522557537,  /* xyz */
        24.10978774442944, -22.826908020592697, 29.518579113336173,  /* luv */
        24.10978774442944, 37.31506723363748, 127.71501294924043,  /* lch */
        127.71501294924043, 100.00000000000246, 24.10978774442944,  /* hsluv */
        127.71501294924043, 196.39488290021464, 24.10978774442944,  /* hpluv */
    },
    {
        "#004411",
        0.0, 0.26666666666666666, 0.06666666666666667,  /* rgb */
        0.021681982067310313, 0.04174529933520181, 0.01221821048731317,  /* xyz */
        24.24023568834123, -22.41482626967938, 25.381939959806555,  /* luv */
        24.24023568834123, 33.86247647209421, 131.44776766906375,  /* lch */
        131.44776766906375, 99.99999999999093, 24.24023568834123,  /* hsluv */
        131.44776766906375, 177.26426923078134, 24.24023568834123,  /* hpluv */
    },
    {
        "#004422",
        0.0, 0.26666666666666666, 0.13333333333333333,  /* rgb */
        0.02355734020578733, 0.04249544259059263, 0.022095096683292365,  /* xyz */
        24.47983884157803, -21.724482000841586, 18.31777133793454,  /* luv */
        24.47983884157803, 28.416436528772326, 139.86289398405617,  /* lch */
        139.86289398405617, 99.99999999999115, 24.47983884157803,  /* hsluv */
        139.86289398405617, 147.29919989838237, 24.47983884157803,  /* hpluv */
    },
    {
        "#004433",
        0.0, 0.26666666666666666, 0.2,  /* rgb */
        0.02664509093824507, 0.043730542883575745, 0.03835725054090351,  /* xyz */
        24.868272344439575, -20.760308528761005, 8.108883160042694,  /* luv */
        24.868272344439575, 22.287763376179562, 158.6646070162696,  /* lch */
        158.6646070162696, 99.99999999999132, 24.868272344439575,  /* hsluv */
        158.6646070162696, 113.72611407662583, 24.868272344439575,  /* hpluv */
    },
    {
        "#004444",
        0.0, 0.26666666666666666, 0.26666666666666666,  /* rgb */
        0.03110308618246395, 0.04551374098126332, 0.06183602549379015,  /* xyz */
        25.416382899462455, -19.655979041789283, -4.241532730227751,  /* luv */
        25.416382899462455, 20.10840898710917, 192.17705063006116,  /* lch */
        192.17705063006116, 99.99999999999142, 25.416382899462455,  /* hsluv */
        192.17705063006116, 100.39296752732079, 25.416382899462455,  /* hpluv */
    },
    {
        "#004455",
        0.0, 0.26666666666666666, 0.3333333333333333,  /* rgb */
        0.03706550022182595, 0.04789870659700815, 0.09323807276776405,  /* xyz */
        26.12752238320944, -18.551332958817884, -17.633074335250704,  /* luv */
        26.12752238320944, 25.594477237509654, 223.5463060533821,  /* lch */
        223.5463060533821, 99.99999999999164, 26.12752238320944,  /* hsluv */
        223.5463060533821, 124.30464615528736, 26.12752238320944,  /* hpluv */
    },
    {
        "#004466",
        0.0, 0.26666666666666666, 0.4,  /* rgb */
        0.04465049599533412, 0.05093270490641146, 0.133185717174908,  /* xyz */
        26.998856172493873, -17.550989964093162, -31.20845169444965,  /* luv */
        26.998856172493873, 35.80509329529105, 240.64749629188998,  /* lch */
        240.64749629188998, 99.99999999999201, 26.998856172493873,  /* hsluv */
        240.64749629188998, 168.2824285526648, 26.998856172493873,  /* hpluv */
    },
    {
        "#004477",
        0.0, 0.26666666666666666, 0.4666666666666667,  /* rgb */
        0.05396450901553604, 0.05465831011449228, 0.18223951908130592,  /* xyz */
        28.022704815018514, -16.71276412090254, -44.45497303925727,  /* luv */
        28.022704815018514, 47.49274799884734, 249.39634309039513,  /* lch */
        249.39634309039513, 99.99999999999217, 28.022704815018514,  /* hsluv */
        249.39634309039513, 215.05848085050232, 28.022704815018514,  /* hpluv */
    },
    {
        "#004488",
        0.0, 0.26666666666666666, 0.5333333333333333,  /* rgb */
        0.06510492611747987, 0.059114476955269876, 0.2409123824848781,  /* xyz */
        29.187946544131933, -16.056004095215396, -57.146576503418196,  /* luv */
        29.187946544131933, 59.3592998069098, 254.3066663738383,  /* lch */
        254.3066663738383, 99.9999999999923, 29.187946544131933,  /* hsluv */
        254.3066663738383, 258.06229412425995, 29.187946544131933,  /* hpluv */
    },
    {
        "#004499",
        0.0, 0.26666666666666666, 0.6,  /* rgb */
        0.07816189022655258, 0.06433726259889903, 0.309679060125996,  /* xyz */
        30.48136237579382, -15.575844220536982, -69.23808082338321,  /* luv */
        30.48136237579382, 70.9684349502494, 257.3217620402887,  /* lch */
        257.3217620402887, 99.99999999999267, 30.48136237579382,  /* hsluv */
        257.3217620402887, 295.4406025638689, 30.48136237579382,  /* hpluv */
    },
    {
        "#0044aa",
        0.0, 0.26666666666666666, 0.6666666666666666,  /* rgb */
        0.09321958319180512, 0.07036033978500014, 0.3889829097429946,  /* xyz */
        31.888801174521923, -15.255328334591898, -80.77535320920931,  /* luv */
        31.888801174521923, 82.2033012029853, 259.3050223100131,  /* lch */
        259.3050223100131, 99.99999999999251, 31.888801174521923,  /* hsluv */
        259.3050223100131, 327.10741766303414, 31.888801174521923,  /* hpluv */
    },
    {
        "#0044bb",
        0.0, 0.26666666666666666, 0.7333333333333333,  /* rgb */
        0.11035717529914177, 0.0772153766279349, 0.47924089484163634,  /* xyz */
        33.39609159485326, -15.073278732780341, -91.8379962332527,  /* luv */
        33.39609159485326, 93.0667571364503, 260.67920351801274,  /* lch */
        260.67920351801274, 99.99999999999297, 33.39609159485326,  /* hsluv */
        260.67920351801274, 353.621176249907, 33.39609159485326,  /* hpluv */
    },
    {
        "#0044cc",
        0.0, 0.26666666666666666, 0.8,  /* rgb */
        0.1296495507428635, 0.0849323268054237, 0.5808474055119065,  /* xyz */
        34.98968510875791, -15.008567937754883, -102.50917725565925,  /* luv */
        34.98968510875791, 103.60206818965716, 261.6703961286033,  /* lch */
        261.6703961286033, 99.99999999999292, 34.98968510875791,  /* hsluv */
        261.6703961286033, 375.72294494295704, 34.98968510875791,  /* hpluv */
    },
    {
        "#0044dd",
        0.0, 0.26666666666666666, 0.8666666666666667,  /* rgb */
        0.15116787629349704, 0.09353965702567724, 0.6941772534119125,  /* xyz */
        36.65705670101395, -15.042060266111099, -112.86260633800624,  /* luv */
        36.65705670101395, 113.86057915915009, 262.4084926829313,  /* lch */
        262.4084926829313, 99.99999999999291, 36.65705670101395,  /* hsluv */
        262.4084926829313, 394.14418516759554, 36.65705670101395,  /* hpluv */
    },
    {
        "#0044ee",
        0.0, 0.26666666666666666, 0.9333333333333333,  /* rgb */
        0.17498005655967178, 0.10306452913214725, 0.8195880694804357,  /* xyz */
        38.386911506645724, -15.157256616501726, -122.95868031807825,  /* luv */
        38.386911506645724, 123.8893841041348, 262.9725367878653,  /* lch */
        262.9725367878653, 99.9999999999931, 38.386911506645724,  /* hsluv */
        262.9725367878653, 409.53426939906257, 38.386911506645724,  /* hpluv */
    },
    {
        "#0044ff",
        0.0, 0.26666666666666666, 1.0,  /* rgb */
        0.20115110496950317, 0.11353294849607996, 0.9574222577722176,  /* xyz */
        40.16925040919119, -15.340300841302811, -132.8448495959191,  /* luv */
        40.16925040919119, 133.72762950887915, 263.41292697558447,  /* lch */
        263.41292697558447, 99.99999999999942, 40.16925040919119,  /* hsluv */
        263.41292697558447, 422.44166459550104, 40.16925040919119,  /* hpluv */
    },
    {
        "#005500",
        0.0, 0.3333333333333333, 0.0,  /* rgb */
        0.03248357328201915, 0.06496714656403922, 0.010827857760672747,  /* xyz */
        30.632559536838137, -29.002603689213107, 37.504669958824415,  /* luv */
        30.632559536838137, 47.410455486885006, 127.71501294924047,  /* lch */
        127.71501294924047, 100.00000000000233, 30.632559536838137,  /* hsluv */
        127.71501294924047, 196.39488290021464, 30.632559536838137,  /* hpluv */
    },
    {
        "#005511",
        0.0, 0.3333333333333333, 0.06666666666666667,  /* rgb */
        0.03349523878165628, 0.06537181276389407, 0.01615596272542838,  /* xyz */
        30.729180554001793, -28.65667856083101, 34.11421854155341,  /* luv */
        30.729180554001793, 44.55317197281983, 130.03098301498366,  /* lch */
        130.03098301498366, 99.99999999999093, 30.729180554001793,  /* hsluv */
        130.03098301498366, 183.97845882149218, 30.729180554001793,  /* hpluv */
    },
    {
        "#005522",
        0.0, 0.3333333333333333, 0.13333333333333333,  /* rgb */
        0.03537059692013329, 0.06612195601928489, 0.026032848921407573,  /* xyz */
        30.90724072080554, -28.05576659484753, 28.159515996415376,  /* luv */
        30.90724072080554, 39.750275223914315, 134.89425658266407,  /* lch */
        134.89425658266407, 99.99999999999099, 30.90724072080554,  /* hsluv */
        134.89425658266407, 163.19965331248974, 30.90724072080554,  /* hpluv */
    },
    {
        "#005533",
        0.0, 0.3333333333333333, 0.2,  /* rgb */
        0.038458347652591034, 0.067357056312268, 0.04229500277901872,  /* xyz */
        31.19750294555768, -27.167279305515503, 19.183168946088024,  /* luv */
        31.19750294555768, 33.2574057268159, 144.77358795395492,  /* lch */
        144.77358795395492, 99.99999999999122, 31.19750294555768,  /* hsluv */
        144.77358795395492, 135.27198432619028, 31.19750294555768,  /* hpluv */
    },
    {
        "#005544",
        0.0, 0.3333333333333333, 0.26666666666666666,  /* rgb */
        0.042916342896809914, 0.06914025440995558, 0.06577377773190536,  /* xyz */
        31.610379910894878, -26.068605846890016, 7.739638345000763,  /* luv */
        31.610379910894878, 27.193275133972268, 163.4641098311233,  /* lch */
        163.4641098311233, 99.99999999999137, 31.610379910894878,  /* hsluv */
        163.4641098311233, 109.16191048912313, 31.610379910894878,  /* hpluv */
    },
    {
        "#005555",
        0.0, 0.3333333333333333, 0.3333333333333333,  /* rgb */
        0.048878756936171906, 0.07152522002570041, 0.09717582500587926,  /* xyz */
        32.15163704345205, -24.864745954809944, -5.3655243308869744,  /* luv */
        32.15163704345205, 25.43706828120288, 192.17705063006116,  /* lch */
        192.17705063006116, 99.9999999999915, 32.15163704345205,  /* hsluv */
        192.17705063006116, 100.39296752732088, 32.15163704345205,  /* hpluv */
    },
    {
        "#005566",
        0.0, 0.3333333333333333, 0.4,  /* rgb */
        0.056463752709680085, 0.07455921833510373, 0.13712346941302322,  /* xyz */
        32.823072275179904, -23.65818480190488, -19.32166360079772,  /* luv */
        32.823072275179904, 30.54564441002145, 219.23854779268927,  /* lch */
        219.23854779268927, 99.99999999999163, 32.823072275179904,  /* hsluv */
        219.23854779268927, 118.08898483952031, 32.823072275179904,  /* hpluv */
    },
    {
        "#005577",
        0.0, 0.3333333333333333, 0.4666666666666667,  /* rgb */
        0.065777765729882, 0.07828482354318454, 0.18617727131942113,  /* xyz */
        33.62309504934721, -22.528996727992453, -33.476311257782214,  /* luv */
        33.62309504934721, 40.35119711976103, 236.06010686830695,  /* lch */
        236.06010686830695, 99.9999999999918, 33.62309504934721,  /* hsluv */
        236.06010686830695, 152.2853275943003, 33.62309504934721,  /* hpluv */
    },
    {
        "#005588",
        0.0, 0.3333333333333333, 0.5333333333333333,  /* rgb */
        0.07691818283182583, 0.08274099038396214, 0.2448501347229933,  /* xyz */
        34.54733084060393, -21.528183854733946, -47.392473397357676,  /* luv */
        34.54733084060393, 52.05294645649257, 245.5699232524689,  /* lch */
        245.5699232524689, 99.99999999999197, 34.54733084060393,  /* hsluv */
        245.5699232524689, 191.1921888819033, 34.54733084060393,  /* hpluv */
    },
    {
        "#005599",
        0.0, 0.3333333333333333, 0.6,  /* rgb */
        0.08997514694089853, 0.0879637760275913, 0.3136168123641112,  /* xyz */
        35.58925749196938, -20.680552342163917, -60.82961166283901,  /* luv */
        35.58925749196938, 64.24894474019617, 251.2232464346984,  /* lch */
        251.2232464346984, 99.99999999999221, 35.58925749196938,  /* hsluv */
        251.2232464346984, 229.07959054661458, 35.58925749196938,  /* hpluv */
    },
    {
        "#0055aa",
        0.0, 0.3333333333333333, 0.6666666666666666,  /* rgb */
        0.10503283990615109, 0.0939868532136924, 0.3929206619811098,  /* xyz */
        36.7408379507026, -19.99169279829201, -73.69167910422433,  /* luv */
        36.7408379507026, 76.35529680474862, 254.82164670852154,  /* lch */
        254.82164670852154, 99.99999999999216, 36.7408379507026,  /* hsluv */
        254.82164670852154, 263.71172471868596, 36.7408379507026,  /* hpluv */
    },
    {
        "#0055bb",
        0.0, 0.3333333333333333, 0.7333333333333333,  /* rgb */
        0.12217043201348773, 0.10084189005662716, 0.48317864707975156,  /* xyz */
        37.993106438468665, -19.455175832054895, -85.9731335635018,  /* luv */
        37.993106438468665, 88.14694300645878, 257.24908591133465,  /* lch */
        257.24908591133465, 99.99999999999241, 37.993106438468665,  /* hsluv */
        257.24908591133465, 294.40269242922466, 37.993106438468665,  /* hpluv */
    },
    {
        "#0055cc",
        0.0, 0.3333333333333333, 0.8,  /* rgb */
        0.14146280745720946, 0.10855884023411597, 0.5847851577500217,  /* xyz */
        39.33667423145034, -19.05821215187867, -97.71675594460129,  /* luv */
        39.33667423145034, 99.5579220492412, 258.9638451900767,  /* lch */
        258.9638451900767, 99.9999999999926, 39.33667423145034,  /* hsluv */
        258.9638451900767, 321.1570876063159, 39.33667423145034,  /* hpluv */
    },
    {
        "#0055dd",
        0.0, 0.3333333333333333, 0.8666666666666667,  /* rgb */
        0.162981133007843, 0.1171661704543695, 0.6981150056500277,  /* xyz */
        40.762136580024354, -18.785462446021157, -108.98568065461352,  /* luv */
        40.762136580024354, 110.59282158919841, 260.2202335876808,  /* lch */
        260.2202335876808, 99.99999999999267, 40.762136580024354,  /* hsluv */
        260.2202335876808, 344.2780426604708, 40.762136580024354,  /* hpluv */
    },
    {
        "#0055ee",
        0.0, 0.3333333333333333, 0.9333333333333333,  /* rgb */
        0.18679331327401774, 0.12669104256083952, 0.8235258217185509,  /* xyz */
        42.26037726483711, -18.621316558040668, -119.8470528464183,  /* luv */
        42.26037726483711, 121.2850753651369, 261.1682486955326,  /* lch */
        261.1682486955326, 99.99999999999243, 42.26037726483711,  /* hsluv */
        261.1682486955326, 364.1776751980169, 42.26037726483711,  /* hpluv */
    },
    {
        "#0055ff",
        0.0, 0.3333333333333333, 1.0,  /* rgb */
        0.21296436168384913, 0.13715946192477224, 0.9613600100103328,  /* xyz */
        43.8227784910393, -18.55110483508429, -130.36364844317038,  /* luv */
        43.8227784910393, 131.67696961130602, 261.90102950371454,  /* lch */
        261.90102950371454, 99.99999999999933, 43.8227784910393,  /* hsluv */
        261.90102950371454, 381.2845785204507, 43.8227784910393,  /* hpluv */
    },
    {
        "#006600",
        0.0, 0.4, 0.0,  /* rgb */
        0.04751163098786562, 0.09502326197573256, 0.015837210329288094,  /* xyz */
        36.933990388840755, -34.96873594975211, 45.219764222772625,  /* luv */
        36.933990388840755, 57.16327116502897, 127.71501294924046,  /* lch */
        127.71501294924046, 100.00000000000233, 36.933990388840755,  /* hsluv */
        127.71501294924046, 196.39488290021455, 36.933990388840755,  /* hpluv */
    },
    {
        "#006611",
        0.0, 0.4, 0.06666666666666667,  /* rgb */
        0.04852329648750274, 0.09542792817558741, 0.021165315294043724,  /* xyz */
        37.00902556361214, -34.67712110587408, 42.40248970915469,  /* luv */
        37.00902556361214, 54.77658132565802, 129.27659568717885,  /* lch */
        129.27659568717885, 99.99999999999089, 37.00902556361214,  /* hsluv */
        129.27659568717885, 187.81341089669158, 37.00902556361214,  /* hpluv */
    },
    {
        "#006622",
        0.0, 0.4, 0.13333333333333333,  /* rgb */
        0.05039865462597976, 0.09617807143097823, 0.031042201490022923,  /* xyz */
        37.147561604054495, -34.160143827310165, 37.372880268217045,  /* luv */
        37.147561604054495, 50.632475802048276, 132.4284238476378,  /* lch */
        132.4284238476378, 99.99999999999096, 37.147561604054495,  /* hsluv */
        132.4284238476378, 172.95701396532996, 37.147561604054495,  /* hpluv */
    },
    {
        "#006633",
        0.0, 0.4, 0.2,  /* rgb */
        0.0534864053584375, 0.09741317172396134, 0.04730435534763407,  /* xyz */
        37.37409822812259, -33.370233172084546, 29.593257216080797,  /* luv */
        37.37409822812259, 44.60194317085759, 138.43287464041342,  /* lch */
        138.43287464041342, 99.99999999999102, 37.37409822812259,  /* hsluv */
        138.43287464041342, 151.43364776149042, 37.37409822812259,  /* hpluv */
    },
    {
        "#006644",
        0.0, 0.4, 0.26666666666666666,  /* rgb */
        0.05794440060265638, 0.09919636982164892, 0.0707831303005207,  /* xyz */
        37.69781103345833, -32.347816118142084, 19.329461500643465,  /* luv */
        37.69781103345833, 37.68301062173762, 149.13954040564053,  /* lch */
        149.13954040564053, 99.99999999999119, 37.69781103345833,  /* hsluv */
        149.13954040564053, 126.84366621536749, 37.69781103345833,  /* hpluv */
    },
    {
        "#006655",
        0.0, 0.4, 0.3333333333333333,  /* rgb */
        0.06390681464201838, 0.10158133543739375, 0.1021851775744946,  /* xyz */
        38.12475729163942, -31.162782637718884, 7.10354401671241,  /* luv */
        38.12475729163942, 31.962155110741268, 167.15886187992768,  /* lch */
        167.15886187992768, 99.99999999999125, 38.12475729163942,  /* hsluv */
        167.15886187992768, 106.38203499229262, 38.12475729163942,  /* hpluv */
    },
    {
        "#006666",
        0.0, 0.4, 0.4,  /* rgb */
        0.07149181041552655, 0.10461533374679707, 0.14213282198163857,  /* xyz */
        38.65833996205007, -29.89676080542887, -6.451374882646054,  /* luv */
        38.65833996205007, 30.584907136256998, 192.17705063006113,  /* lch */
        192.17705063006113, 99.99999999999149, 38.65833996205007,  /* hsluv */
        192.17705063006113, 100.39296752732085, 38.65833996205007,  /* hpluv */
    },
    {
        "#006677",
        0.0, 0.4, 0.4666666666666667,  /* rgb */
        0.08080582343572847, 0.10834093895487788, 0.19118662388803648,  /* xyz */
        39.299625172095965, -28.627012592082487, -20.722311654709983,  /* luv */
        39.299625172095965, 35.340062963472185, 215.89975111348804,  /* lch */
        215.89975111348804, 99.99999999999164, 39.299625172095965,  /* hsluv */
        215.89975111348804, 114.10856326421792, 39.299625172095965,  /* hpluv */
    },
    {
        "#006688",
        0.0, 0.4, 0.5333333333333333,  /* rgb */
        0.0919462405376723, 0.11279710579565548, 0.24985948729160865,  /* xyz */
        40.04763710656187, -27.41592103273122, -35.20262937380891,  /* luv */
        40.04763710656187, 44.619030030948764, 232.0884266568936,  /* lch */
        232.0884266568936, 99.99999999999181, 40.04763710656187,  /* hsluv */
        232.0884266568936, 141.37823469203877, 40.04763710656187,  /* hpluv */
    },
    {
        "#006699",
        0.0, 0.4, 0.6,  /* rgb */
        0.10500320464674501, 0.11801989143928464, 0.31862616493272655,  /* xyz */
        40.89966718753507, -26.306942955317304, -49.526473536471286,  /* luv */
        40.89966718753507, 56.079647186952855, 242.0241311697273,  /* lch */
        242.0241311697273, 99.9999999999919, 40.89966718753507,  /* hsluv */
        242.0241311697273, 173.9902151608489, 40.89966718753507,  /* hpluv */
    },
    {
        "#0066aa",
        0.0, 0.4, 0.6666666666666666,  /* rgb */
        0.12006089761199755, 0.12404296862538575, 0.39793001454972515,  /* xyz */
        41.85159977074651, -25.325485343454723, -63.463816976877986,  /* luv */
        41.85159977074651, 68.33034664888073, 248.24533508852056,  /* lch */
        248.24533508852056, 99.9999999999921, 41.85159977074651,  /* hsluv */
        248.24533508852056, 207.17668847310654, 41.85159977074651,  /* hpluv */
    },
    {
        "#0066bb",
        0.0, 0.4, 0.7333333333333333,  /* rgb */
        0.13719848971933418, 0.1308980054683205, 0.4881879996483669,  /* xyz */
        42.89824202026734, -24.48238874355704, -76.8946183711398,  /* luv */
        42.89824202026734, 80.69801542190415, 252.3391051333116,  /* lch */
        252.3391051333116, 99.99999999999221, 42.89824202026734,  /* hsluv */
        252.3391051333116, 238.70564300468735, 42.89824202026734,  /* hpluv */
    },
    {
        "#0066cc",
        0.0, 0.4, 0.8,  /* rgb */
        0.15649086516305594, 0.1386149556458093, 0.589794510318637,  /* xyz */
        44.03364130157012, -23.778110315569702, -89.77728886805177,  /* luv */
        44.03364130157012, 92.87281694164884, 255.16544861873695,  /* lch */
        255.16544861873695, 99.99999999999228, 44.03364130157012,  /* hsluv */
        255.16544861873695, 267.6352692234782, 44.03364130157012,  /* hpluv */
    },
    {
        "#0066dd",
        0.0, 0.4, 0.8666666666666667,  /* rgb */
        0.17800919071368948, 0.14722228586606284, 0.703124358218643,  /* xyz */
        45.25137486241698, -23.206494335863617, -102.1202915288435,  /* luv */
        45.25137486241698, 104.72390043011411, 257.1971545746481,  /* lch */
        257.1971545746481, 99.99999999999231, 45.25137486241698,  /* hsluv */
        257.1971545746481, 293.66578971725386, 45.25137486241698,  /* hpluv */
    },
    {
        "#0066ee",
        0.0, 0.4, 0.9333333333333333,  /* rgb */
        0.20182137097986422, 0.15674715797253286, 0.8285351742871663,  /* xyz */
        46.54480089307904, -22.75769365056844, -113.96030558560756,  /* luv */
        46.54480089307904, 116.21042926285998, 258.7066828334389,  /* lch */
        258.7066828334389, 99.99999999999231, 46.54480089307904,  /* hsluv */
        258.7066828334389, 316.82048544727013, 46.54480089307904,  /* hpluv */
    },
    {
        "#0066ff",
        0.0, 0.4, 1.0,  /* rgb */
        0.2279924193896956, 0.16721557733646558, 0.9663693625789481,  /* xyz */
        47.907265254796876, -22.420212023661207, -125.34716023440295,  /* luv */
        47.907265254796876, 127.3364695835997, 259.8590320104013,  /* lch */
        259.8590320104013, 99.99999999999923, 47.907265254796876,  /* hsluv */
        259.8590320104013, 337.280125749862, 47.907265254796876,  /* hpluv */
    },
    {
        "#007700",
        0.0, 0.4666666666666667, 0.0,  /* rgb */
        0.06596536904128325, 0.13193073808256833, 0.021988456347093798,  /* xyz */
        43.05273092464659, -40.76189883004264, 52.71118341296816,  /* luv */
        43.05273092464659, 66.63333439822895, 127.7150129492405,  /* lch */
        127.7150129492405, 100.00000000000222, 43.05273092464659,  /* hsluv */
        127.7150129492405, 196.39488290021444, 43.05273092464659,  /* hpluv */
    },
    {
        "#007711",
        0.0, 0.4666666666666667, 0.06666666666666667,  /* rgb */
        0.06697703454092037, 0.13233540428242319, 0.02731656131184943,  /* xyz */
        43.1130460407029, -40.51344140687822, 50.333881531534,  /* luv */
        43.1130460407029, 64.61299068035045, 128.8303810279207,  /* lch */
        128.8303810279207, 99.99999999999089, 43.1130460407029,  /* hsluv */
        128.8303810279207, 190.1737025165262, 43.1130460407029,  /* hpluv */
    },
    {
        "#007722",
        0.0, 0.4666666666666667, 0.13333333333333333,  /* rgb */
        0.0688523926793974, 0.13308554753781401, 0.037193447507828624,  /* xyz */
        43.224529759717186, -40.06747885015288, 46.04627218205294,  /* luv */
        43.224529759717186, 61.03820150750799, 131.02838358141568,  /* lch */
        131.02838358141568, 99.99999999999092, 43.224529759717186,  /* hsluv */
        131.02838358141568, 179.18876567347343, 43.224529759717186,  /* hpluv */
    },
    {
        "#007733",
        0.0, 0.4666666666666667, 0.2,  /* rgb */
        0.07194014341185513, 0.1343206478307971, 0.05345560136543977,  /* xyz */
        43.407176963920925, -39.37204974647397, 39.30415580414334,  /* luv */
        43.407176963920925, 55.63249917732616, 135.049443606961,  /* lch */
        135.049443606961, 99.99999999999092, 43.407176963920925,  /* hsluv */
        135.049443606961, 162.6321317874121, 43.407176963920925,  /* hpluv */
    },
    {
        "#007744",
        0.0, 0.4666666666666667, 0.26666666666666666,  /* rgb */
        0.076398138656074, 0.1361038459284847, 0.0769343763183264,  /* xyz */
        43.668912367052386, -38.44544863920467, 30.20380156390291,  /* luv */
        43.668912367052386, 48.89092093611398, 141.84584812017238,  /* lch */
        141.84584812017238, 99.99999999999106, 43.668912367052386,  /* hsluv */
        141.84584812017238, 142.0676409789078, 43.668912367052386,  /* hpluv */
    },
    {
        "#007755",
        0.0, 0.4666666666666667, 0.3333333333333333,  /* rgb */
        0.082360552695436, 0.13848881154422954, 0.10833642359230032,  /* xyz */
        44.0154249216106, -37.33138546569752, 19.05959734577903,  /* luv */
        44.0154249216106, 41.9153980271179, 152.9533446822198,  /* lch */
        152.9533446822198, 99.99999999999125, 44.0154249216106,  /* hsluv */
        152.9533446822198, 120.83925030518903, 44.0154249216106,  /* hpluv */
    },
    {
        "#007766",
        0.0, 0.4666666666666667, 0.4,  /* rgb */
        0.08994554846894418, 0.14152280985363283, 0.14828406799944427,  /* xyz */
        44.450533325006255, -36.08914704483659, 6.322799292230854,  /* luv */
        44.450533325006255, 36.63883629857357, 170.06266590607584,  /* lch */
        170.06266590607584, 99.99999999999133, 44.450533325006255,  /* hsluv */
        170.06266590607584, 104.59333764362559, 44.450533325006255,  /* hpluv */
    },
    {
        "#007777",
        0.0, 0.4666666666666667, 0.4666666666666667,  /* rgb */
        0.0992595614891461, 0.14524841506171365, 0.19733786990584218,  /* xyz */
        44.97640134168407, -34.78288809403886, -7.50574458738768,  /* luv */
        44.97640134168407, 35.58350047386471, 192.17705063006116,  /* lch */
        192.17705063006116, 99.99999999999145, 44.97640134168407,  /* hsluv */
        192.17705063006116, 100.39296752732083, 44.97640134168407,  /* hpluv */
    },
    {
        "#007788",
        0.0, 0.4666666666666667, 0.5333333333333333,  /* rgb */
        0.11039997859108992, 0.14970458190249125, 0.2560107333094144,  /* xyz */
        45.59370851593016, -33.4724811425817, -21.950081561832658,  /* luv */
        45.59370851593016, 40.0276538709377, 213.25546015720218,  /* lch */
        213.25546015720218, 99.99999999999162, 45.59370851593016,  /* hsluv */
        213.25546015720218, 111.40239912738691, 45.59370851593016,  /* hpluv */
    },
    {
        "#007799",
        0.0, 0.4666666666666667, 0.6,  /* rgb */
        0.12345694270016264, 0.1549273675461204, 0.32477741095053225,  /* xyz */
        46.301815605736024, -32.20751606254526, -36.608342282266236,  /* luv */
        46.301815605736024, 48.75956127340229, 228.65912564754316,  /* lch */
        228.65912564754316, 99.99999999999176, 46.301815605736024,  /* hsluv */
        228.65912564754316, 133.62911578541167, 46.301815605736024,  /* hpluv */
    },
    {
        "#0077aa",
        0.0, 0.4666666666666667, 0.6666666666666666,  /* rgb */
        0.13851463566541516, 0.1609504447322215, 0.40408126056753085,  /* xyz */
        47.09893796456138, -31.024720761612503, -51.17453585119916,  /* luv */
        47.09893796456138, 59.8445186957143, 238.7735318475252,  /* lch */
        238.7735318475252, 99.99999999999191, 47.09893796456138,  /* hsluv */
        238.7735318475252, 161.23250098913041, 47.09893796456138,  /* hpluv */
    },
    {
        "#0077bb",
        0.0, 0.4666666666666667, 0.7333333333333333,  /* rgb */
        0.15565222777275184, 0.16780548157515626, 0.4943392456661726,  /* xyz */
        47.982327881830415, -29.9480972873728, -65.43861964089345,  /* luv */
        47.982327881830415, 71.96597440207054, 245.40871703904992,  /* lch */
        245.40871703904992, 99.99999999999206, 47.982327881830415,  /* hsluv */
        245.40871703904992, 190.32034768447943, 47.982327881830415,  /* hpluv */
    },
    {
        "#0077cc",
        0.0, 0.4666666666666667, 0.8,  /* rgb */
        0.17494460321647357, 0.17552243175264506, 0.5959457563364428,  /* xyz */
        48.94846104919171, -28.990699304460225, -79.27342873051055,  /* luv */
        48.94846104919171, 84.40815807049083, 249.9122747909542,  /* lch */
        249.9122747909542, 99.99999999999221, 48.94846104919171,  /* hsluv */
        249.9122747909542, 218.8188381780674, 48.94846104919171,  /* hpluv */
    },
    {
        "#0077dd",
        0.0, 0.4666666666666667, 0.8666666666666667,  /* rgb */
        0.1964629287671071, 0.1841297619728986, 0.7092756042364488,  /* xyz */
        49.9932200675849, -28.15707849035525, -92.61622060051087,  /* luv */
        49.9932200675849, 96.80178400956524, 253.08973862409607,  /* lch */
        253.08973862409607, 99.99999999999213, 49.9932200675849,  /* hsluv */
        253.08973862409607, 245.70363248193695, 49.9932200675849,  /* hpluv */
    },
    {
        "#0077ee",
        0.0, 0.4666666666666667, 0.9333333333333333,  /* rgb */
        0.22027510903328185, 0.19365463407936864, 0.834686420304972,  /* xyz */
        51.112067862782155, -27.44573530773488, -105.4501204308288,  /* luv */
        51.112067862782155, 108.96327952782325, 255.41117614555068,  /* lch */
        255.41117614555068, 99.99999999999226, 51.112067862782155,  /* hsluv */
        255.41117614555068, 270.51792077177504, 51.112067862782155,  /* hpluv */
    },
    {
        "#0077ff",
        0.0, 0.4666666666666667, 1.0,  /* rgb */
        0.24644615744311324, 0.20412305344330134, 0.9725206085967538,  /* xyz */
        52.300205122294, -26.851223719183885, -117.7882405902455,  /* luv */
        52.300205122294, 120.81000718716649, 257.158195690943,  /* lch */
        257.158195690943, 99.99999999999912, 52.300205122294,  /* hsluv */
        257.158195690943, 293.1155404176239, 52.300205122294,  /* hpluv */
    },
    {
        "#008800",
        0.0, 0.5333333333333333, 0.0,  /* rgb */
        0.0880377387662537, 0.17607547753250988, 0.029345912922083744,  /* xyz */
        49.01660393012705, -46.408434667922535, 60.01299208089562,  /* luv */
        49.01660393012705, 75.86370691462733, 127.71501294924046,  /* lch */
        127.71501294924046, 100.00000000000236, 49.01660393012705,  /* hsluv */
        127.71501294924046, 196.39488290021458, 49.01660393012705,  /* hpluv */
    },
    {
        "#008811",
        0.0, 0.5333333333333333, 0.06666666666666667,  /* rgb */
        0.08904940426589082, 0.17648014373236473, 0.034674017886839374,  /* xyz */
        49.06637404840808, -46.194279078767806, 57.978028136437146,  /* luv */
        49.06637404840808, 74.13071675221131, 128.54625702181343,  /* lch */
        128.54625702181343, 99.99999999999089, 49.06637404840808,  /* hsluv */
        128.54625702181343, 191.71388164520974, 49.06637404840808,  /* hpluv */
    },
    {
        "#008822",
        0.0, 0.5333333333333333, 0.13333333333333333,  /* rgb */
        0.09092476240436785, 0.17723028698775556, 0.044550904082818574,  /* xyz */
        49.15843371353435, -45.80678154524008, 54.28315211066561,  /* luv */
        49.15843371353435, 71.0276132120671, 130.15931159606515,  /* lch */
        130.15931159606515, 99.99999999999093, 49.15843371353435,  /* hsluv */
        130.15931159606515, 183.34476349874473, 49.15843371353435,  /* hpluv */
    },
    {
        "#008833",
        0.0, 0.5333333333333333, 0.2,  /* rgb */
        0.09401251313682558, 0.17846538728073866, 0.06081305794042972,  /* xyz */
        49.30944434964772, -45.19439051997845, 48.408688286412165,  /* luv */
        49.30944434964772, 66.22638474266383, 133.03325532135008,  /* lch */
        133.03325532135008, 99.99999999999099, 49.30944434964772,  /* hsluv */
        133.03325532135008, 170.42773243795347, 49.30944434964772,  /* hpluv */
    },
    {
        "#008844",
        0.0, 0.5333333333333333, 0.26666666666666666,  /* rgb */
        0.09847050838104446, 0.18024858537842625, 0.08429183289331635,  /* xyz */
        49.52624443497004, -44.36250730142752, 40.3543995143041,  /* luv */
        49.52624443497004, 59.97090639826346, 137.70874551833822,  /* lch */
        137.70874551833822, 99.99999999999108, 49.52624443497004,  /* hsluv */
        137.70874551833822, 153.65423776567317, 49.52624443497004,  /* hpluv */
    },
    {
        "#008855",
        0.0, 0.5333333333333333, 0.3333333333333333,  /* rgb */
        0.10443292242040646, 0.18263355099417108, 0.11569388016729026,  /* xyz */
        49.813983349765635, -43.33708117930541, 30.295639775601387,  /* luv */
        49.813983349765635, 52.87653916960439, 145.0437692700716,  /* lch */
        145.0437692700716, 99.99999999999119, 49.813983349765635,  /* hsluv */
        145.0437692700716, 134.69487686385023, 49.813983349765635,  /* hpluv */
    },
    {
        "#008866",
        0.0, 0.5333333333333333, 0.4,  /* rgb */
        0.11201791819391463, 0.18566754930357438, 0.15564152457443423,  /* xyz */
        50.17642840553846, -42.15913978784919, 18.537522153947283,  /* luv */
        50.17642840553846, 46.05467180709786, 156.26473885498027,  /* lch */
        156.26473885498027, 99.99999999999125, 50.17642840553846,  /* hsluv */
        156.26473885498027, 116.46978496164118, 50.17642840553846,  /* hpluv */
    },
    {
        "#008877",
        0.0, 0.5333333333333333, 0.4666666666666667,  /* rgb */
        0.12133193121411655, 0.1893931545116552, 0.20469532648083213,  /* xyz */
        50.61613244635868, -40.878146882521634, 5.460568938051061,  /* luv */
        50.61613244635868, 41.24125004987387, 172.39137999323276,  /* lch */
        172.39137999323276, 99.99999999999135, 50.61613244635868,  /* hsluv */
        172.39137999323276, 103.39086986547092, 50.61613244635868,  /* hpluv */
    },
    {
        "#008888",
        0.0, 0.5333333333333333, 0.5333333333333333,  /* rgb */
        0.13247234831606036, 0.1938493213524328, 0.2633681898844043,  /* xyz */
        51.13455030852947, -39.54534573828099, -8.53342781453345,  /* luv */
        51.13455030852947, 40.45557761083176, 192.17705063006113,  /* lch */
        192.17705063006113, 99.99999999999149, 51.13455030852947,  /* hsluv */
        192.17705063006113, 100.39296752732085, 51.13455030852947,  /* hpluv */
    },
    {
        "#008899",
        0.0, 0.5333333333333333, 0.6,  /* rgb */
        0.1455293124251331, 0.19907210699606195, 0.33213486752552224,  /* xyz */
        51.73213940917867, -38.208266400248, -23.066108485628412,  /* luv */
        51.73213940917867, 44.63089716757999, 211.1191364215863,  /* lch */
        211.1191364215863, 99.99999999999157, 51.73213940917867,  /* hsluv */
        211.1191364215863, 109.47488668983283, 51.73213940917867,  /* hpluv */
    },
    {
        "#0088aa",
        0.0, 0.5333333333333333, 0.6666666666666666,  /* rgb */
        0.16058700539038562, 0.20509518418216305, 0.4114387171425208,  /* xyz */
        52.40845943510149, -36.907080512481635, -37.81242158313336,  /* luv */
        52.40845943510149, 52.83854481281076, 225.6941920473008,  /* lch */
        225.6941920473008, 99.9999999999917, 52.40845943510149,  /* hsluv */
        225.6941920473008, 127.93482558548848, 52.40845943510149,  /* hpluv */
    },
    {
        "#0088bb",
        0.0, 0.5333333333333333, 0.7333333333333333,  /* rgb */
        0.1777245974977223, 0.2119502210250978, 0.5016967022411626,  /* xyz */
        53.162276611930295, -35.67288939821133, -52.515020568130986,  /* luv */
        53.162276611930295, 63.4852929684367, 235.81215339949136,  /* lch */
        235.81215339949136, 99.99999999999186, 53.162276611930295,  /* hsluv */
        235.81215339949136, 151.53358005979854, 53.162276611930295,  /* hpluv */
    },
    {
        "#0088cc",
        0.0, 0.5333333333333333, 0.8,  /* rgb */
        0.19701697294144402, 0.2196671712025866, 0.6033032129114327,  /* xyz */
        53.991673081708896, -34.527596126723346, -66.98598689768126,  /* luv */
        53.991673081708896, 75.36098018833384, 242.73138159803148,  /* lch */
        242.73138159803148, 99.99999999999193, 53.991673081708896,  /* hsluv */
        242.73138159803148, 177.11652365406002, 53.991673081708896,  /* hpluv */
    },
    {
        "#0088dd",
        0.0, 0.5333333333333333, 0.8666666666666667,  /* rgb */
        0.21853529849207756, 0.22827450142284014, 0.7166330608114387,  /* xyz */
        54.89415931224342, -33.4848266090853, -81.10015734605805,  /* luv */
        54.89415931224342, 87.7409205251226, 247.56513173145166,  /* lch */
        247.56513173145166, 99.99999999999214, 54.89415931224342,  /* hsluv */
        247.56513173145166, 202.82214648885395, 54.89415931224342,  /* hpluv */
    },
    {
        "#0088ee",
        0.0, 0.5333333333333333, 0.9333333333333333,  /* rgb */
        0.2423474787582523, 0.2377993735293102, 0.842043876879962,  /* xyz */
        55.86678627796577, -32.55138155566918, -94.78419143553191,  /* luv */
        55.86678627796577, 100.2179394483359, 251.0461819445536,  /* lch */
        251.0461819445536, 99.99999999999233, 55.86678627796577,  /* hsluv */
        251.0461819445536, 227.63084272006577, 55.86678627796577,  /* hpluv */
    },
    {
        "#0088ff",
        0.0, 0.5333333333333333, 1.0,  /* rgb */
        0.26851852716808366, 0.24826779289324288, 0.9798780651717438,  /* xyz */
        56.90625389598118, -31.728824885135996, -108.00452043253614,  /* luv */
        56.90625389598118, 112.56862245960791, 253.62862968213113,  /* lch */
        253.62862968213113, 99.9999999999989, 56.90625389598118,  /* hsluv */
        253.62862968213113, 251.01326967554832, 56.90625389598118,  /* hpluv */
    },
    {
        "#009900",
        0.0, 0.6, 0.0,  /* rgb */
        0.11390733921872119, 0.22781467843744557, 0.037969113072906,  /* xyz */
        54.84652561295758, -51.92814672146309, 67.15079877763637,  /* luv */
        54.84652561295758, 84.88676103139056, 127.71501294924046,  /* lch */
        127.71501294924046, 100.00000000000236, 54.84652561295758,  /* hsluv */
        127.71501294924046, 196.3948829002146, 54.84652561295758,  /* hpluv */
    },
    {
        "#009911",
        0.0, 0.6, 0.06666666666666667,  /* rgb */
        0.11491900471835831, 0.22821934463730043, 0.04329721803766163,  /* xyz */
        54.888448922777414, -51.74152195784559, 65.38666852147712,  /* luv */
        54.888448922777414, 83.38226139204755, 128.35513501511429,  /* lch */
        128.35513501511429, 99.99999999999089, 54.888448922777414,  /* hsluv */
        128.35513501511429, 192.7667110258916, 54.888448922777414,  /* hpluv */
    },
    {
        "#009922",
        0.0, 0.6, 0.13333333333333333,  /* rgb */
        0.11679436285683534, 0.22896948789269125, 0.05317410423364083,  /* xyz */
        54.96603266930477, -51.401984855674215, 62.16873831631094,  /* luv */
        54.96603266930477, 80.66669740943229, 129.58441992503032,  /* lch */
        129.58441992503032, 99.99999999999088, 54.96603266930477,  /* hsluv */
        129.58441992503032, 186.22552686388718, 54.96603266930477,  /* hpluv */
    },
    {
        "#009933",
        0.0, 0.6, 0.2,  /* rgb */
        0.11988211358929307, 0.23020458818567435, 0.06943625809125198,  /* xyz */
        55.09340486371448, -50.860444582136495, 57.01321092210807,  /* luv */
        55.09340486371448, 76.40216647936995, 131.735569901926,  /* lch */
        131.735569901926, 99.99999999999099, 55.09340486371448,  /* hsluv */
        131.735569901926, 175.97273619131636, 55.09340486371448,  /* hpluv */
    },
    {
        "#009944",
        0.0, 0.6, 0.26666666666666666,  /* rgb */
        0.12434010883351194, 0.23198778628336195, 0.09291503304413862,  /* xyz */
        55.27649952039013, -50.114873994686974, 49.86602211760728,  /* luv */
        55.27649952039013, 70.69738861752286, 135.14260857215288,  /* lch */
        135.14260857215288, 99.99999999999105, 55.27649952039013,  /* hsluv */
        135.14260857215288, 162.29388856446602, 55.27649952039013,  /* hpluv */
    },
    {
        "#009955",
        0.0, 0.6, 0.3333333333333333,  /* rgb */
        0.13030252287287394, 0.23437275189910678, 0.12431708031811252,  /* xyz */
        55.51992148354448, -49.1795700812718, 40.81252316021732,  /* luv */
        55.51992148354448, 63.908467045314104, 140.3118247549942,  /* lch */
        140.3118247549942, 99.99999999999103, 55.51992148354448,  /* hsluv */
        140.3118247549942, 146.06591500859358, 55.51992148354448,  /* hpluv */
    },
    {
        "#009966",
        0.0, 0.6, 0.4,  /* rgb */
        0.13788751864638213, 0.23740675020851007, 0.1642647247252565,  /* xyz */
        55.827212134291685, -48.08200942182918, 30.050563414838717,  /* luv */
        55.827212134291685, 56.70022920227142, 147.99521017635234,  /* lch */
        147.99521017635234, 99.99999999999119, 55.827212134291685,  /* hsluv */
        147.99521017635234, 128.8778255949112, 55.827212134291685,  /* hpluv */
    },
    {
        "#009977",
        0.0, 0.6, 0.4666666666666667,  /* rgb */
        0.14720153166658403, 0.2411323554165909, 0.2133185266316544,  /* xyz */
        56.20098991644224, -46.85880632633, 17.8571723631952,  /* luv */
        56.20098991644224, 50.14605004521658, 159.13892363926047,  /* lch */
        159.13892363926047, 99.99999999999129, 56.20098991644224,  /* hsluv */
        159.13892363926047, 113.22233079697332, 56.20098991644224,  /* hpluv */
    },
    {
        "#009988",
        0.0, 0.6, 0.5333333333333333,  /* rgb */
        0.15834194876852786, 0.2455885222573685, 0.27199139003522654,  /* xyz */
        56.64304012410611, -45.55121093388854, 4.551874531721927,  /* luv */
        56.64304012410611, 45.77807749672485, 174.29345008882663,  /* lch */
        174.29345008882663, 99.99999999999135, 56.64304012410611,  /* hsluv */
        174.29345008882663, 102.55346107327222, 56.64304012410611,  /* hpluv */
    },
    {
        "#009999",
        0.0, 0.6, 0.6,  /* rgb */
        0.17139891287760056, 0.25081130790099765, 0.3407580676763445,  /* xyz */
        57.15438442554051, -44.20083639983849, -9.538028805116733,  /* luv */
        57.15438442554051, 45.21822566103765, 192.17705063006113,  /* lch */
        192.17705063006113, 99.99999999999149, 57.15438442554051,  /* hsluv */
        192.17705063006113, 100.39296752732085, 57.15438442554051,  /* hpluv */
    },
    {
        "#0099aa",
        0.0, 0.6, 0.6666666666666666,  /* rgb */
        0.18645660584285312, 0.25683438508709877, 0.4200619172933431,  /* xyz */
        57.7353441317496, -42.846200766745014, -24.105602890047983,  /* luv */
        57.7353441317496, 49.16174336653361, 209.36244133349683,  /* lch */
        209.36244133349683, 99.99999999999159, 57.7353441317496,  /* hsluv */
        209.36244133349683, 108.05001788849357, 57.7353441317496,  /* hpluv */
    },
    {
        "#0099bb",
        0.0, 0.6, 0.7333333333333333,  /* rgb */
        0.20359419795018976, 0.26368942193003353, 0.5103199023919848,  /* xyz */
        58.38560368713337, -41.52039736476365, -38.883371394771466,  /* luv */
        58.38560368713337, 56.88461978735205, 223.12152686740976,  /* lch */
        223.12152686740976, 99.99999999999172, 58.38560368713337,  /* hsluv */
        223.12152686740976, 123.63129293990379, 58.38560368713337,  /* hpluv */
    },
    {
        "#0099cc",
        0.0, 0.6, 0.8,  /* rgb */
        0.2228865733939115, 0.27140637210752233, 0.6119264130622549,  /* xyz */
        59.10427691179525, -40.249918656197686, -53.65317323289072,  /* luv */
        59.10427691179525, 67.07249026082982, 233.12324199221086,  /* lch */
        233.12324199221086, 99.99999999999186, 59.10427691179525,  /* hsluv */
        233.12324199221086, 144.0007815211091, 59.10427691179525,  /* hpluv */
    },
    {
        "#0099dd",
        0.0, 0.6, 0.8666666666666667,  /* rgb */
        0.24440489894454503, 0.28001370232777584, 0.7252562609622609,  /* xyz */
        59.88997629566825, -39.054448989631034, -68.24826647479219,  /* luv */
        59.88997629566825, 78.63253692141654, 240.2200449992876,  /* lch */
        240.2200449992876, 99.99999999999183, 59.88997629566825,  /* hsluv */
        240.2200449992876, 166.60478591483178, 59.88997629566825,  /* hpluv */
    },
    {
        "#0099ee",
        0.0, 0.6, 0.9333333333333333,  /* rgb */
        0.2682170792107198, 0.28953857443424585, 0.8506670770307841,  /* xyz */
        60.740884383473485, -37.94734304732613, -82.54994512981065,  /* luv */
        60.740884383473485, 90.85424748071055, 245.31225482090636,  /* lch */
        245.31225482090636, 99.99999999999194, 60.740884383473485,  /* hsluv */
        245.31225482090636, 189.8031654814909, 60.740884383473485,  /* hpluv */
    },
    {
        "#0099ff",
        0.0, 0.6, 1.0,  /* rgb */
        0.29438812762055117, 0.3000069937981786, 0.988501265322566,  /* xyz */
        61.654825647017844, -36.93650173324242, -96.48097086803641,  /* luv */
        61.654825647017844, 103.3096457255019, 249.05129665917667,  /* lch */
        249.05129665917667, 99.99999999999869, 61.654825647017844,  /* hsluv */
        249.05129665917667, 212.6244116079962, 61.654825647017844,  /* hpluv */
    },
    {
        "#00aa00",
        0.0, 0.6666666666666666, 0.0,  /* rgb */
        0.1437409588482905, 0.287481917696585, 0.047913652949428814,  /* xyz */
        60.55874994347363, -57.33642408864184, 74.14450389030046,  /* luv */
        60.55874994347363, 93.72765325351621, 127.71501294924046,  /* lch */
        127.71501294924046, 100.00000000000236, 60.55874994347363,  /* hsluv */
        127.71501294924046, 196.39488290021455, 60.55874994347363,  /* hpluv */
    },
    {
        "#00aa11",
        0.0, 0.6666666666666666, 0.06666666666666667,  /* rgb */
        0.14475262434792763, 0.28788658389643984, 0.053241757914184444,  /* xyz */
        60.594655057795194, -57.17217036459677, 72.59816757134585,  /* luv */
        60.594655057795194, 92.40752674385182, 128.2209744164032,  /* lch */
        128.2209744164032, 99.99999999999078, 60.594655057795194,  /* hsluv */
        128.2209744164032, 193.51398466598548, 60.594655057795194,  /* hpluv */
    },
    {
        "#00aa22",
        0.0, 0.6666666666666666, 0.13333333333333333,  /* rgb */
        0.14662798248640463, 0.28863672715183064, 0.06311864411016364,  /* xyz */
        60.661124672570665, -56.87217357286377, 69.76822269837092,  /* luv */
        60.661124672570665, 90.01138275457957, 129.18549729971198,  /* lch */
        129.18549729971198, 99.99999999999086, 60.661124672570665,  /* hsluv */
        129.18549729971198, 188.28958659972653, 60.661124672570665,  /* hpluv */
    },
    {
        "#00aa33",
        0.0, 0.6666666666666666, 0.2,  /* rgb */
        0.1497157332188624, 0.28987182744481377, 0.07938079796777478,  /* xyz */
        60.770315493882435, -56.390563907722935, 65.20926859373508,  /* luv */
        60.770315493882435, 86.20988579252885, 130.85203774548182,  /* lch */
        130.85203774548182, 99.9999999999908, 60.770315493882435,  /* hsluv */
        130.85203774548182, 180.01342923681946, 60.770315493882435,  /* hpluv */
    },
    {
        "#00aa44",
        0.0, 0.6666666666666666, 0.26666666666666666,  /* rgb */
        0.15417372846308125, 0.29165502554250133, 0.10285957292066142,  /* xyz */
        60.927415872173384, -55.721092886080704, 58.838128842643044,  /* luv */
        60.927415872173384, 81.03558229643751, 133.4414266318045,  /* lch */
        133.4414266318045, 99.99999999999089, 60.927415872173384,  /* hsluv */
        133.4414266318045, 168.77274926729055, 60.927415872173384,  /* hpluv */
    },
    {
        "#00aa55",
        0.0, 0.6666666666666666, 0.3333333333333333,  /* rgb */
        0.16013614250244324, 0.2940399911582462, 0.13426162019463533,  /* xyz */
        61.13653439448329, -54.870497850082764, 50.68267463356767,  /* luv */
        61.13653439448329, 74.69608451805236, 137.2720190150518,  /* lch */
        137.2720190150518, 99.99999999999106, 61.13653439448329,  /* hsluv */
        137.2720190150518, 155.03735380682758, 61.13653439448329,  /* hpluv */
    },
    {
        "#00aa66",
        0.0, 0.6666666666666666, 0.4,  /* rgb */
        0.16772113827595142, 0.2970739894676495, 0.1742092646017793,  /* xyz */
        61.400933529954926, -53.85658985315937, 40.864997825495614,  /* luv */
        61.400933529954926, 67.60532758510375, 142.80970662058607,  /* lch */
        142.80970662058607, 99.99999999999119, 61.400933529954926,  /* hsluv */
        142.80970662058607, 139.7157202439704, 61.400933529954926,  /* hpluv */
    },
    {
        "#00aa77",
        0.0, 0.6666666666666666, 0.4666666666666667,  /* rgb */
        0.17703515129615333, 0.3007995946757303, 0.2232630665081772,  /* xyz */
        61.72315200878448, -52.705778615444686, 29.580777163150138,  /* luv */
        61.72315200878448, 60.43940334778472, 150.69696297282547,  /* lch */
        150.69696297282547, 99.99999999999119, 61.72315200878448,  /* hsluv */
        150.69696297282547, 124.25429193577784, 61.72315200878448,  /* hpluv */
    },
    {
        "#00aa88",
        0.0, 0.6666666666666666, 0.5333333333333333,  /* rgb */
        0.18817556839809718, 0.3052557615165079, 0.28193592991174937,  /* xyz */
        62.10507956424196, -51.45011405898551, 17.075070095456834,  /* luv */
        62.10507956424196, 54.20952181533594, 161.64022106818837,  /* lch */
        161.64022106818837, 99.99999999999115, 62.10507956424196,  /* hsluv */
        161.64022106818837, 110.76123266585557, 62.10507956424196,  /* hpluv */
    },
    {
        "#00aa99",
        0.0, 0.6666666666666666, 0.6,  /* rgb */
        0.20123253250716988, 0.31047854716013706, 0.3507026075528673,  /* xyz */
        62.54801029994563, -50.12419524681738, 3.617177111591469,  /* luv */
        62.54801029994563, 50.25454128133786, 175.8724456583218,  /* lch */
        175.8724456583218, 99.99999999999133, 62.54801029994563,  /* hsluv */
        175.8724456583218, 101.95326553071466, 62.54801029994563,  /* hpluv */
    },
    {
        "#00aaaa",
        0.0, 0.6666666666666666, 0.6666666666666666,  /* rgb */
        0.21629022547242244, 0.3165016243462382, 0.43000645716986585,  /* xyz */
        63.05268714376258, -48.76233970540733, -10.52234841232014,  /* luv */
        63.05268714376258, 49.88472300871079, 192.17705063006116,  /* lch */
        192.17705063006116, 99.99999999999145, 63.05268714376258,  /* hsluv */
        192.17705063006116, 100.3929675273208, 63.05268714376258,  /* hpluv */
    },
    {
        "#00aabb",
        0.0, 0.6666666666666666, 0.7333333333333333,  /* rgb */
        0.23342781757975906, 0.32335666118917294, 0.5202644422685077,  /* xyz */
        63.61934366465616, -47.396315575024914, -25.090158708177253,  /* luv */
        63.61934366465616, 53.6276681768737, 207.89537465888966,  /* lch */
        207.89537465888966, 99.9999999999916, 63.61934366465616,  /* hsluv */
        207.89537465888966, 106.96434982124536, 63.61934366465616,  /* hpluv */
    },
    {
        "#00aacc",
        0.0, 0.6666666666666666, 0.8,  /* rgb */
        0.2527201930234808, 0.33107361136666175, 0.6218709529387778,  /* xyz */
        64.24774633864303, -46.0537892020538, -39.8628338833449,  /* luv */
        64.24774633864303, 60.90974491063279, 220.8785206847217,  /* lch */
        220.8785206847217, 99.99999999999163, 64.24774633864303,  /* hsluv */
        220.8785206847217, 120.30071511637779, 64.24774633864303,  /* hpluv */
    },
    {
        "#00aadd",
        0.0, 0.6666666666666666, 0.8666666666666667,  /* rgb */
        0.27423851857411435, 0.33968094158691525, 0.7352008008387838,  /* xyz */
        64.93723853422149, -44.75749284691985, -54.65383856248116,  /* luv */
        64.93723853422149, 70.64188018134735, 230.68503431688296,  /* lch */
        230.68503431688296, 99.99999999999181, 64.93723853422149,  /* hsluv */
        230.68503431688296, 138.0408929729001, 64.93723853422149,  /* hpluv */
    },
    {
        "#00aaee",
        0.0, 0.6666666666666666, 0.9333333333333333,  /* rgb */
        0.2980506988402891, 0.34920581369338527, 0.860611616907307,  /* xyz */
        65.68678639791686, -43.52500947747031, -69.31554053566383,  /* luv */
        65.68678639791686, 81.8478503674051, 237.8742320575352,  /* lch */
        237.8742320575352, 99.99999999999184, 65.68678639791686,  /* hsluv */
        237.8742320575352, 158.1133676752189, 65.68678639791686,  /* hpluv */
    },
    {
        "#00aaff",
        0.0, 0.6666666666666666, 1.0,  /* rgb */
        0.3242217472501205, 0.359674233057318, 0.9984458051990889,  /* xyz */
        66.4950261675888, -42.369016683119284, -83.7375555551541,  /* luv */
        66.4950261675888, 93.8462134827344, 243.1617807226753,  /* lch */
        243.1617807226753, 99.99999999999828, 66.4950261675888,  /* hsluv */
        243.1617807226753, 179.08817863217504, 66.4950261675888,  /* hpluv */
    },
    {
        "#00bb00",
        0.0, 0.7333333333333333, 0.0,  /* rgb */
        0.17769545675688928, 0.35539091351378355, 0.05923181891896143,  /* xyz */
        66.16624291669618, -62.645542845004435, 81.00998220608491,  /* luv */
        66.16624291669618, 102.40645123904783, 127.71501294924046,  /* lch */
        127.71501294924046, 100.00000000000237, 66.16624291669618,  /* hsluv */
        127.71501294924046, 196.39488290021464, 66.16624291669618,  /* hpluv */
    },
    {
        "#00bb11",
        0.0, 0.7333333333333333, 0.06666666666666667,  /* rgb */
        0.1787071222565264, 0.3557955797136384, 0.06455992388371706,  /* xyz */
        66.19741731084476, -62.499696751934096, 79.64144445180244,  /* luv */
        66.19741731084476, 101.23720545556982, 128.12352783498358,  /* lch */
        128.12352783498358, 99.99999999999093, 66.19741731084476,  /* hsluv */
        128.12352783498358, 194.06107335643887, 66.19741731084476,  /* hpluv */
    },
    {
        "#00bb22",
        0.0, 0.7333333333333333, 0.13333333333333333,  /* rgb */
        0.1805824803950034, 0.3565457229690292, 0.07443681007969626,  /* xyz */
        66.25514386208519, -62.23256467643804, 77.13082999629877,  /* luv */
        66.25514386208519, 99.10629163743837, 128.89812411948307,  /* lch */
        128.89812411948307, 99.99999999999086, 66.25514386208519,  /* hsluv */
        128.89812411948307, 189.8108138046309, 66.25514386208519,  /* hpluv */
    },
    {
        "#00bb33",
        0.0, 0.7333333333333333, 0.2,  /* rgb */
        0.18367023112746117, 0.3577808232620123, 0.0906989639373074,  /* xyz */
        66.35001366612173, -61.80165711047162, 73.06982784764232,  /* luv */
        66.35001366612173, 95.70080753726371, 130.22417426856393,  /* lch */
        130.22417426856393, 99.99999999999093, 66.35001366612173,  /* hsluv */
        130.22417426856393, 183.02647365261987, 66.35001366612173,  /* hpluv */
    },
    {
        "#00bb44",
        0.0, 0.7333333333333333, 0.26666666666666666,  /* rgb */
        0.18812822637168003, 0.3595640213596999, 0.11417773889019404,  /* xyz */
        66.4865992404304, -61.1983980271068, 67.36051384430809,  /* luv */
        66.4865992404304, 91.00924538997899, 132.25578562619089,  /* lch */
        132.25578562619089, 99.99999999999096, 66.4865992404304,  /* hsluv */
        132.25578562619089, 173.69636117663484, 66.4865992404304,  /* hpluv */
    },
    {
        "#00bb55",
        0.0, 0.7333333333333333, 0.3333333333333333,  /* rgb */
        0.19409064041104201, 0.36194898697544475, 0.14557978616416795,  /* xyz */
        66.66857363739342, -60.4246386982598, 59.994338994997875,  /* luv */
        66.66857363739342, 85.1496193371524, 135.2047372636746,  /* lch */
        135.2047372636746, 99.99999999999095, 66.66857363739342,  /* hsluv */
        135.2047372636746, 162.06934380512766, 66.66857363739342,  /* hpluv */
    },
    {
        "#00bb66",
        0.0, 0.7333333333333333, 0.4,  /* rgb */
        0.2016756361845502, 0.36498298528484807, 0.1855274305713119,  /* xyz */
        66.89891801701924, -59.4914065933894, 51.04077111527656,  /* luv */
        66.89891801701924, 78.38614529687007, 139.37199067559027,  /* lch */
        139.37199067559027, 99.99999999999112, 66.89891801701924,  /* hsluv */
        139.37199067559027, 148.6823925109077, 66.89891801701924,  /* hpluv */
    },
    {
        "#00bb77",
        0.0, 0.7333333333333333, 0.4666666666666667,  /* rgb */
        0.2109896492047521, 0.36870859049292887, 0.23458123247770982,  /* xyz */
        67.18003038212674, -58.417355962563306, 40.63417310478666,  /* luv */
        67.18003038212674, 71.15984472697083, 145.17814649708947,  /* lch */
        145.17814649708947, 99.99999999999109, 67.18003038212674,  /* hsluv */
        145.17814649708947, 134.41078650346333, 67.18003038212674,  /* hpluv */
    },
    {
        "#00bb88",
        0.0, 0.7333333333333333, 0.5333333333333333,  /* rgb */
        0.22213006630669596, 0.37316475733370646, 0.293254095881282,  /* xyz */
        67.5137905946342, -57.22683597541855, 28.957891871582095,  /* luv */
        67.5137905946342, 64.1363411600919, 153.15970256881354,  /* lch */
        153.15970256881354, 99.99999999999116, 67.5137905946342,  /* hsluv */
        153.15970256881354, 120.5455033954561, 67.5137905946342,  /* hpluv */
    },
    {
        "#00bb99",
        0.0, 0.7333333333333333, 0.6,  /* rgb */
        0.23518703041576866, 0.3783875429773356, 0.3620207735223999,  /* xyz */
        67.90160447148608, -55.947728223056714, 16.226630420585142,  /* luv */
        67.90160447148608, 58.25334177647902, 163.82615079736487,  /* lch */
        163.82615079736487, 99.99999999999125, 67.90160447148608,  /* hsluv */
        163.82615079736487, 108.86295889847526, 67.90160447148608,  /* hpluv */
    },
    {
        "#00bbaa",
        0.0, 0.7333333333333333, 0.6666666666666666,  /* rgb */
        0.2502447233810212, 0.38441062016343674, 0.4413246231393985,  /* xyz */
        68.34443791867284, -54.60928728768909, 2.668908013682504,  /* luv */
        68.34443791867284, 54.674466874902954, 177.20202191220852,  /* lch */
        177.20202191220852, 99.99999999999136, 68.34443791867284,  /* hsluv */
        177.20202191220852, 101.51277672003371, 68.34443791867284,  /* hpluv */
    },
    {
        "#00bbbb",
        0.0, 0.7333333333333333, 0.7333333333333333,  /* rgb */
        0.26738231548835784, 0.3912656570063715, 0.5315826082380403,  /* xyz */
        68.84284683158803, -53.24020966521651, -11.488620911688109,  /* luv */
        68.84284683158803, 54.465661986692965, 192.17705063006113,  /* lch */
        192.17705063006113, 99.99999999999145, 68.84284683158803,  /* hsluv */
        192.17705063006113, 100.3929675273208, 68.84284683158803,  /* hpluv */
    },
    {
        "#00bbcc",
        0.0, 0.7333333333333333, 0.8,  /* rgb */
        0.2866746909320796, 0.3989826071838603, 0.6331891189083104,  /* xyz */
        69.39700583953794, -51.86709359188894, -26.03370472999983,  /* luv */
        69.39700583953794, 58.03403466620757, 206.65349558753124,  /* lch */
        206.65349558753124, 99.99999999999152, 69.39700583953794,  /* hsluv */
        206.65349558753124, 106.11611904615519, 69.39700583953794,  /* hpluv */
    },
    {
        "#00bbdd",
        0.0, 0.7333333333333333, 0.8666666666666667,  /* rgb */
        0.30819301648271313, 0.4075899374041138, 0.7465189668083164,  /* xyz */
        70.00673748073125, -50.51336776491331, -40.777274012568284,  /* luv */
        70.00673748073125, 64.91830557592719, 218.91244904401708,  /* lch */
        218.91244904401708, 99.99999999999164, 70.00673748073125,  /* hsluv */
        218.91244904401708, 117.67024660805951, 70.00673748073125,  /* hpluv */
    },
    {
        "#00bbee",
        0.0, 0.7333333333333333, 0.9333333333333333,  /* rgb */
        0.33200519674888784, 0.41711480951058383, 0.8719297828768396,  /* xyz */
        70.67154249040642, -49.198687196144434, -55.55848078406248,  /* luv */
        70.67154249040642, 74.2108860535778, 228.47415504325846,  /* lch */
        228.47415504325846, 99.99999999999183, 70.67154249040642,  /* hsluv */
        228.47415504325846, 133.24851357857867, 70.67154249040642,  /* hpluv */
    },
    {
        "#00bbff",
        0.0, 0.7333333333333333, 1.0,  /* rgb */
        0.35817624515871926, 0.42758322887451655, 1.0097639711686215,  /* xyz */
        71.39063131556502, -47.938735910286915, -70.246481992653,  /* luv */
        71.39063131556502, 85.0452269855302, 235.68896091452348,  /* lch */
        235.68896091452348, 99.9999999999978, 71.39063131556502,  /* hsluv */
        235.68896091452348, 151.16388626377628, 71.39063131556502,  /* hpluv */
    },
    {
        "#00cc00",
        0.0, 0.8, 0.0,  /* rgb */
        0.2159192000665062, 0.43183840013301844, 0.07197306668883338,  /* xyz */
        71.67956946983271, -67.86550576836186, 87.76016880090552,  /* luv */
        71.67956946983271, 110.93950649412042, 127.71501294924046,  /* lch */
        127.71501294924046, 100.00000000000236, 71.67956946983271,  /* hsluv */
        127.71501294924046, 196.3948829002146, 71.67956946983271,  /* hpluv */
    },
    {
        "#00cc11",
        0.0, 0.8, 0.06666666666666667,  /* rgb */
        0.21693086556614333, 0.4322430663328733, 0.07730117165358902,  /* xyz */
        71.70694844703867, -67.73498686167807, 86.53876068023285,  /* luv */
        71.70694844703867, 109.8953390514007, 128.0507378418876,  /* lch */
        128.0507378418876, 99.99999999999088, 71.70694844703867,  /* hsluv */
        128.0507378418876, 194.4721245036983, 71.70694844703867,  /* hpluv */
    },
    {
        "#00cc22",
        0.0, 0.8, 0.13333333333333333,  /* rgb */
        0.21880622370462033, 0.4329932095882641, 0.08717805784956821,  /* xyz */
        71.7576566073484, -67.49541975359523, 84.29397630416763,  /* luv */
        71.7576566073484, 107.98660161743024, 128.68476606632143,  /* lch */
        128.68476606632143, 99.99999999999092, 71.7576566073484,  /* hsluv */
        128.68476606632143, 190.959361108477, 71.7576566073484,  /* hpluv */
    },
    {
        "#00cc33",
        0.0, 0.8, 0.2,  /* rgb */
        0.2218939744370781, 0.4342283098812472, 0.10344021170717935,  /* xyz */
        71.8410194320707, -67.10758226588354, 80.65177702446879,  /* luv */
        71.8410194320707, 104.91966800737103, 129.76268281316857,  /* lch */
        129.76268281316857, 99.99999999999098, 71.8410194320707,  /* hsluv */
        129.76268281316857, 185.32062142529492, 71.8410194320707,  /* hpluv */
    },
    {
        "#00cc44",
        0.0, 0.8, 0.26666666666666666,  /* rgb */
        0.22635196968129695, 0.4360115079789348, 0.12691898666006599,  /* xyz */
        71.96109759298737, -66.56169932330826, 75.50788097214165,  /* luv */
        71.96109759298737, 100.65733905537941, 131.39681800421843,  /* lch */
        131.39681800421843, 99.99999999999099, 71.96109759298737,  /* hsluv */
        131.39681800421843, 177.49535534321674, 71.96109759298737,  /* hpluv */
    },
    {
        "#00cc55",
        0.0, 0.8, 0.3333333333333333,  /* rgb */
        0.23231438372065893, 0.43839647359467965, 0.1583210339340399,  /* xyz */
        72.12118728777288, -65.85647498982696, 68.8308938513177,  /* luv */
        72.12118728777288, 95.26157276917628, 133.73489287004782,  /* lch */
        133.73489287004782, 99.99999999999103, 72.12118728777288,  /* hsluv */
        133.73489287004782, 167.60779255103014, 72.12118728777288,  /* hpluv */
    },
    {
        "#00cc66",
        0.0, 0.8, 0.4,  /* rgb */
        0.23989937949416712, 0.44143047190408297, 0.19826867834118386,  /* xyz */
        72.3240060759138, -64.99820326650132, 60.65399211263555,  /* luv */
        72.3240060759138, 88.90260506347988, 136.98011552142265,  /* lch */
        136.98011552142265, 99.99999999999106, 72.3240060759138,  /* hsluv */
        136.98011552142265, 155.98087044053696, 72.3240060759138,  /* hpluv */
    },
    {
        "#00cc77",
        0.0, 0.8, 0.4666666666666667,  /* rgb */
        0.24921339251436903, 0.44515607711216376, 0.24732248024758177,  /* xyz */
        72.57179062683915, -63.999764477770746, 51.066249515114805,  /* luv */
        72.57179062683915, 81.87631948707812, 141.4131754070985,  /* lch */
        141.4131754070985, 99.99999999999108, 72.57179062683915,  /* hsluv */
        141.4131754070985, 143.16267333657103, 72.57179062683915,  /* hpluv */
    },
    {
        "#00cc88",
        0.0, 0.8, 0.5333333333333333,  /* rgb */
        0.2603538096163129, 0.44961224395294136, 0.30599534365115394,  /* xyz */
        72.8663546950801, -62.87935527758287, 40.20208023222977,  /* luv */
        72.8663546950801, 74.63257047109612, 147.40707881161012,  /* lch */
        147.40707881161012, 99.99999999999116, 72.8663546950801,  /* hsluv */
        147.40707881161012, 129.96927092453217, 72.8663546950801,  /* hpluv */
    },
    {
        "#00cc99",
        0.0, 0.8, 0.6,  /* rgb */
        0.2734107737253856, 0.4548350295965705, 0.3747620212922719,  /* xyz */
        73.20912730596767, -61.65899565582228, 28.229019182563942,  /* luv */
        73.20912730596767, 67.81378377066328, 155.40051707617576,  /* lch */
        155.40051707617576, 99.99999999999119, 73.20912730596767,  /* hsluv */
        155.40051707617576, 117.54172874884354, 73.20912730596767,  /* hpluv */
    },
    {
        "#00ccaa",
        0.0, 0.8, 0.6666666666666666,  /* rgb */
        0.28846846669063814, 0.46085810678267164, 0.4540658709092704,  /* xyz */
        73.60118080481104, -60.36293938692594, 15.334792374208941,  /* luv */
        73.60118080481104, 62.28033645212421, 165.74593517157427,  /* lch */
        165.74593517157427, 99.99999999999129, 73.60118080481104,  /* hsluv */
        165.74593517157427, 107.375573062224, 73.60118080481104,  /* hpluv */
    },
    {
        "#00ccbb",
        0.0, 0.8, 0.7333333333333333,  /* rgb */
        0.30560605879797476, 0.4677131436256064, 0.5443238560079122,  /* xyz */
        74.043253901593, -59.01613699651864, 1.7148404163965667,  /* luv */
        74.043253901593, 59.041045922693165, 178.33561657681375,  /* lch */
        178.33561657681375, 99.99999999999139, 74.043253901593,  /* hsluv */
        178.33561657681375, 101.18307484552274, 74.043253901593,  /* hpluv */
    },
    {
        "#00cccc",
        0.0, 0.8, 0.8,  /* rgb */
        0.3248984342416965, 0.4754300938030952, 0.6459303666781824,  /* xyz */
        74.53577258401087, -57.64288292201784, -12.438666833059896,  /* luv */
        74.53577258401087, 58.96967342749424, 192.17705063006113,  /* lch */
        192.17705063006113, 99.99999999999149, 74.53577258401087,  /* hsluv */
        192.17705063006113, 100.39296752732083, 74.53577258401087,  /* hpluv */
    },
    {
        "#00ccdd",
        0.0, 0.8, 0.8666666666666667,  /* rgb */
        0.34641675979233005, 0.4840374240233487, 0.7592602145781884,  /* xyz */
        75.0788705190671, -56.265737580062066, -26.945607131275025,  /* luv */
        75.0788705190671, 62.385086111196706, 205.58971515357635,  /* lch */
        205.58971515357635, 99.99999999999156, 75.0788705190671,  /* hsluv */
        205.58971515357635, 105.43926622206176, 75.0788705190671,  /* hpluv */
    },
    {
        "#00ccee",
        0.0, 0.8, 0.9333333333333333,  /* rgb */
        0.3702289400585048, 0.4935622961298187, 0.8846710306467116,  /* xyz */
        75.67240981031678, -54.90476592596323, -41.64414616308078,  /* luv */
        75.67240981031678, 68.9113069897593, 217.17957599130284,  /* lch */
        217.17957599130284, 99.9999999999916, 75.67240981031678,  /* hsluv */
        217.17957599130284, 115.55593316351818, 75.67240981031678,  /* hpluv */
    },
    {
        "#00ccff",
        0.0, 0.8, 1.0,  /* rgb */
        0.3963999884683362, 0.5040307154937514, 1.0225052189384933,  /* xyz */
        76.31600249859223, -53.57708911100315, -56.39447100095517,  /* luv */
        76.31600249859223, 77.78715084823422, 226.46755023570978,  /* lch */
        226.46755023570978, 99.99999999999697, 76.31600249859223,  /* hsluv */
        226.46755023570978, 131.60054787646197, 76.31600249859223,  /* hpluv */
    },
    {
        "#00dd00",
        0.0, 0.8666666666666667, 0.0,  /* rgb */
        0.25855319061368137, 0.51710638122737, 0.0861843968712247,  /* xyz */
        77.10749054471454, -73.00460763158716, 94.4057900468603,  /* luv */
        77.10749054471454, 119.34037845513086, 127.7150129492405,  /* lch */
        127.7150129492405, 100.0000000000022, 77.10749054471454,  /* hsluv */
        127.7150129492405, 210.3859957251565, 77.10749054471454,  /* hpluv */
    },
    {
        "#00dd11",
        0.0, 0.8666666666666667, 0.06666666666666667,  /* rgb */
        0.2595648561133185, 0.5175110474272249, 0.09151250183598034,  /* xyz */
        77.13177157710243, -72.88699111417704, 93.30761717979063,  /* luv */
        77.13177157710243, 118.40111864948102, 127.99507742152491,  /* lch */
        127.99507742152491, 99.99999999999092, 77.13177157710243,  /* hsluv */
        127.99507742152491, 208.99772501957847, 77.13177157710243,  /* hpluv */
    },
    {
        "#00dd22",
        0.0, 0.8666666666666667, 0.13333333333333333,  /* rgb */
        0.26144021425179553, 0.5182611906826157, 0.10138938803195953,  /* xyz */
        77.17674867936171, -72.67075427059714, 91.28649216588386,  /* luv */
        77.17674867936171, 116.68017045843517, 128.5223661209483,  /* lch */
        128.5223661209483, 99.99999999999093, 77.17674867936171,  /* hsluv */
        128.5223661209483, 206.4498645259905, 77.17674867936171,  /* hpluv */
    },
    {
        "#00dd33",
        0.0, 0.8666666666666667, 0.2,  /* rgb */
        0.26452796498425324, 0.5194962909755988, 0.11765154188957067,  /* xyz */
        77.25070838174713, -72.31971550874967, 87.99938584881575,  /* luv */
        77.25070838174713, 113.90361346785816, 129.4140729153326,  /* lch */
        129.4140729153326, 99.99999999999093, 77.25070838174713,  /* hsluv */
        129.4140729153326, 202.32767679597768, 77.25070838174713,  /* hpluv */
    },
    {
        "#00dd44",
        0.0, 0.8666666666666667, 0.26666666666666666,  /* rgb */
        0.26898596022847215, 0.5212794890732864, 0.1411303168424573,  /* xyz */
        77.3572825066044, -71.82357779629076, 83.34056136818269,  /* luv */
        77.3572825066044, 110.01943235912307, 130.75503248419133,  /* lch */
        130.75503248419133, 99.99999999999092, 77.3572825066044,  /* hsluv */
        130.75503248419133, 196.53734405993407, 77.3572825066044,  /* hpluv */
    },
    {
        "#00dd55",
        0.0, 0.8666666666666667, 0.3333333333333333,  /* rgb */
        0.27494837426783414, 0.5236644546890311, 0.17253236411643122,  /* xyz */
        77.49944246157442, -71.17903356768697, 77.2645567564888,  /* luv */
        77.49944246157442, 105.05363654061, 132.6524438721974,  /* lch */
        132.6524438721974, 99.99999999999095, 77.49944246157442,  /* hsluv */
        132.6524438721974, 189.09497282950824, 77.49944246157442,  /* hpluv */
    },
    {
        "#00dd66",
        0.0, 0.8666666666666667, 0.4,  /* rgb */
        0.2825333700413423, 0.5266984529984344, 0.21248000852357518,  /* xyz */
        77.6796666807438, -70.38907923325324, 69.77961941507323,  /* luv */
        77.6796666807438, 99.1151742217995, 135.24912306133317,  /* lch */
        135.24912306133317, 99.99999999999099, 77.6796666807438,  /* hsluv */
        135.24912306133317, 180.13924732842386, 77.6796666807438,  /* hpluv */
    },
    {
        "#00dd77",
        0.0, 0.8666666666666667, 0.4666666666666667,  /* rgb */
        0.29184738306154423, 0.5304240582065153, 0.2615338104299731,  /* xyz */
        77.90002917620113, -69.46233564525919, 60.941690947213615,  /* luv */
        77.90002917620113, 92.40619983962301, 138.73841210181584,  /* lch */
        138.73841210181584, 99.99999999999102, 77.90002917620113,  /* hsluv */
        138.73841210181584, 169.95791091759202, 77.90002917620113,  /* hpluv */
    },
    {
        "#00dd88",
        0.0, 0.8666666666666667, 0.5333333333333333,  /* rgb */
        0.30298780016348803, 0.5348802250472928, 0.3202066738335453,  /* xyz */
        78.1622519856154, -68.4122000424903, 50.84727015802551,  /* luv */
        78.1622519856154, 85.23892301746274, 143.3784757437721,  /* lch */
        143.3784757437721, 99.99999999999116, 78.1622519856154,  /* hsluv */
        143.3784757437721, 159.03315840930588, 78.1622519856154,  /* hpluv */
    },
    {
        "#00dd99",
        0.0, 0.8666666666666667, 0.6,  /* rgb */
        0.3160447642725608, 0.540103010690922, 0.38897335147466316,  /* xyz */
        78.46773919930358, -67.25581679640878, 39.624939877086454,  /* luv */
        78.46773919930358, 78.06075040130486, 149.49479122630092,  /* lch */
        149.49479122630092, 99.99999999999115, 78.46773919930358,  /* hsluv */
        149.49479122630092, 148.11309006332863, 78.46773919930358,  /* hpluv */
    },
    {
        "#00ddaa",
        0.0, 0.8666666666666667, 0.6666666666666666,  /* rgb */
        0.3311024572378133, 0.5461260878770231, 0.46827720109166177,  /* xyz */
        78.81760112155834, -66.0129273361177, 27.42598743525736,  /* luv */
        78.81760112155834, 71.48350412705332, 157.43887986881134,  /* lch */
        157.43887986881134, 99.99999999999123, 78.81760112155834,  /* hsluv */
        157.43887986881134, 138.30703630441377, 78.81760112155834,  /* hpluv */
    },
    {
        "#00ddbb",
        0.0, 0.8666666666666667, 0.7333333333333333,  /* rgb */
        0.34824004934514996, 0.5529811247199579, 0.5585351861903035,  /* xyz */
        79.21267314937, -64.70469059622009, 14.41482233702962,  /* luv */
        79.21267314937, 66.29090501841637, 167.44081627252646,  /* lch */
        167.44081627252646, 99.99999999999123, 79.21267314937,  /* hsluv */
        167.44081627252646, 131.16095136406983, 79.21267314937,  /* hpluv */
    },
    {
        "#00ddcc",
        0.0, 0.8666666666666667, 0.8,  /* rgb */
        0.3675324247888717, 0.5606980748974467, 0.6601416968605737,  /* xyz */
        79.65353198643157, -63.35256853649984, 0.7599328977980953,  /* luv */
        79.65353198643157, 63.3571261830985, 179.31275304829333,  /* lch */
        179.31275304829333, 99.99999999999133, 79.65353198643157,  /* hsluv */
        179.31275304829333, 128.5773629796804, 79.65353198643157,  /* hpluv */
    },
    {
        "#00dddd",
        0.0, 0.8666666666666667, 0.8666666666666667,  /* rgb */
        0.3890507503395052, 0.5693054051177002, 0.7734715447605797,  /* xyz */
        80.14051073465313, -61.977355535981765, -13.373995845230663,  /* luv */
        80.14051073465313, 63.40391442254758, 192.17705063006125,  /* lch */
        192.17705063006125, 99.9999999999915, 80.14051073465313,  /* hsluv */
        192.17705063006125, 132.39985796219108, 80.14051073465313,  /* hpluv */
    },
    {
        "#00ddee",
        0.0, 0.8666666666666667, 0.9333333333333333,  /* rgb */
        0.41286293060567997, 0.5788302772241702, 0.8988823608291029,  /* xyz */
        80.6737137665329, -60.59840405426975, -27.832388421158228,  /* luv */
        80.6737137665329, 66.68439411999451, 204.66896084513579,  /* lch */
        204.66896084513579, 99.99999999999147, 80.6737137665329,  /* hsluv */
        204.66896084513579, 143.76981107713456, 80.6737137665329,  /* hpluv */
    },
    {
        "#00ddff",
        0.0, 0.8666666666666667, 1.0,  /* rgb */
        0.43903397901551133, 0.589298696588103, 1.0367165491208847,  /* xyz */
        81.2530318771427, -59.23306955334963, -42.47532814457029,  /* luv */
        81.2530318771427, 72.88833946318766, 215.64385617885665,  /* lch */
        215.64385617885665, 99.99999999999606, 81.2530318771427,  /* hsluv */
        215.64385617885665, 162.8318624608554, 81.2530318771427,  /* hpluv */
    },
    {
        "#00ee00",
        0.0, 0.9333333333333333, 0.0,  /* rgb */
        0.3057319669541962, 0.6114639339084009, 0.10191065565139588,  /* xyz */
        82.45737919464707, -78.06982916845612, 100.95587306851861,  /* luv */
        82.45737919464707, 127.62047850332941, 127.7150129492405,  /* lch */
        127.7150129492405, 100.00000000000222, 82.45737919464707,  /* hsluv */
        127.7150129492405, 307.90847517418996, 82.45737919464707,  /* hpluv */
    },
    {
        "#00ee11",
        0.0, 0.9333333333333333, 0.06666666666666667,  /* rgb */
        0.3067436324538333, 0.6118686001082558, 0.10723876061615152,  /* xyz */
        82.47909406900766, -77.96318233956765, 99.9620440525398,  /* luv */
        82.47909406900766, 126.77013864343046, 127.95166068268804,  /* lch */
        127.95166068268804, 99.99999999999092, 82.47909406900766,  /* hsluv */
        127.95166068268804, 306.2939219483957, 82.47909406900766,  /* hpluv */
    },
    {
        "#00ee22",
        0.0, 0.9333333333333333, 0.13333333333333333,  /* rgb */
        0.30861899059231035, 0.6126187433636466, 0.11711564681213071,  /* xyz */
        82.51932234647617, -77.76686323238158, 98.1309466116455,  /* luv */
        82.51932234647617, 125.20929558104527, 128.39613888407584,  /* lch */
        128.39613888407584, 99.99999999999079, 82.51932234647617,  /* hsluv */
        128.39613888407584, 303.32524669832077, 82.51932234647617,  /* hpluv */
    },
    {
        "#00ee33",
        0.0, 0.9333333333333333, 0.2,  /* rgb */
        0.31170674132476806, 0.6138538436566298, 0.13337780066974186,  /* xyz */
        82.58548615164416, -77.44746683104573, 95.14733131057959,  /* luv */
        82.58548615164416, 122.68302561508307, 129.14469800344756,  /* lch */
        129.14469800344756, 99.99999999999102, 82.58548615164416,  /* hsluv */
        129.14469800344756, 298.5064490042869, 82.58548615164416,  /* hpluv */
    },
    {
        "#00ee44",
        0.0, 0.9333333333333333, 0.26666666666666666,  /* rgb */
        0.31616473656898697, 0.6156370417543173, 0.1568565756226285,  /* xyz */
        82.68085494415222, -76.99458095606388, 90.90684606297019,  /* luv */
        82.68085494415222, 119.13110491268195, 130.26330830544163,  /* lch */
        130.26330830544163, 99.99999999999086, 82.68085494415222,  /* hsluv */
        130.26330830544163, 291.7023399810247, 82.68085494415222,  /* hpluv */
    },
    {
        "#00ee55",
        0.0, 0.9333333333333333, 0.3333333333333333,  /* rgb */
        0.32212715060834896, 0.6180220073700621, 0.1882586228966024,  /* xyz */
        82.80811996565309, -76.40363330621756, 85.35566833667042,  /* luv */
        82.80811996565309, 114.55612292492548, 131.8323852425426,  /* lch */
        131.8323852425426, 99.99999999999089, 82.80811996565309,  /* hsluv */
        131.8323852425426, 282.88952666371137, 82.80811996565309,  /* hpluv */
    },
    {
        "#00ee66",
        0.0, 0.9333333333333333, 0.4,  /* rgb */
        0.32971214638185714, 0.6210560056794654, 0.22820626730374638,  /* xyz */
        82.96954595166918, -75.67532486627341, 78.48499360824763,  /* luv */
        82.96954595166918, 109.0259098347851, 133.9558639913452,  /* lch */
        133.9558639913452, 99.99999999999092, 82.96954595166918,  /* hsluv */
        133.9558639913452, 272.16636440640104, 82.96954595166918,  /* hpluv */
    },
    {
        "#00ee77",
        0.0, 0.9333333333333333, 0.4666666666666667,  /* rgb */
        0.33902615940205905, 0.6247816108875462, 0.2772600692101443,  /* xyz */
        83.16705181350659, -74.81514509581903, 70.32663234507761,  /* luv */
        83.16705181350659, 102.67979914622045, 136.7713087536592,  /* lch */
        136.7713087536592, 99.99999999999109, 83.16705181350659,  /* hsluv */
        136.7713087536592, 259.7764443069117, 83.16705181350659,  /* hpluv */
    },
    {
        "#00ee88",
        0.0, 0.9333333333333333, 0.5333333333333333,  /* rgb */
        0.35016657650400285, 0.6292377777283238, 0.33593293261371643,  /* xyz */
        83.40225851365518, -73.83279257132467, 60.9480575538504,  /* luv */
        83.40225851365518, 95.73895225281984, 140.46074817536558,  /* lch */
        140.46074817536558, 99.99999999999103, 83.40225851365518,  /* hsluv */
        140.46074817536558, 246.14948879488296, 83.40225851365518,  /* hpluv */
    },
    {
        "#00ee99",
        0.0, 0.9333333333333333, 0.6,  /* rgb */
        0.3632235406130756, 0.634460563371953, 0.40469961025483436,  /* xyz */
        83.67651991883011, -72.7414610621927, 50.4464813176313,  /* luv */
        83.67651991883011, 88.52213076283591, 145.25854393841843,  /* lch */
        145.25854393841843, 99.9999999999911, 83.67651991883011,  /* hsluv */
        145.25854393841843, 231.96752956627526, 83.67651991883011,  /* hpluv */
    },
    {
        "#00eeaa",
        0.0, 0.9333333333333333, 0.6666666666666666,  /* rgb */
        0.3782812335783281, 0.6404836405580541, 0.48400345987183296,  /* xyz */
        83.99094426704524, -71.55701270435156, 38.942085452783736,  /* luv */
        83.99094426704524, 81.46712273415972, 151.44449867601764,  /* lch */
        151.44449867601764, 99.99999999999119, 83.99094426704524,  /* hsluv */
        151.44449867601764, 218.26350731657672, 83.99094426704524,  /* hpluv */
    },
    {
        "#00eebb",
        0.0, 0.9333333333333333, 0.7333333333333333,  /* rgb */
        0.3954188256856648, 0.6473386774009888, 0.5742614449704747,  /* xyz */
        84.34641035304654, -70.29709034766263, 26.57079788110358,  /* luv */
        84.34641035304654, 75.15110252941004, 159.29447922017087,  /* lch */
        159.29447922017087, 99.9999999999912, 84.34641035304654,  /* hsluv */
        159.29447922017087, 206.54360831077207, 84.34641035304654,  /* hpluv */
    },
    {
        "#00eecc",
        0.0, 0.9333333333333333, 0.8,  /* rgb */
        0.41471120112938653, 0.6550556275784777, 0.6758679556407449,  /* xyz */
        84.74358080025775, -68.98023226259905, 13.47710648797704,  /* luv */
        84.74358080025775, 70.28445661944312, 168.94501871748872,  /* lch */
        168.94501871748872, 99.9999999999913, 84.74358080025775,  /* hsluv */
        168.94501871748872, 198.87185470791837, 84.74358080025775,  /* hpluv */
    },
    {
        "#00eedd",
        0.0, 0.9333333333333333, 0.8666666666666667,  /* rgb */
        0.43622952668002, 0.6636629577987312, 0.7891978035407509,  /* xyz */
        85.18291384640021, -67.62504964926684, -0.19261376672141892,  /* luv */
        85.18291384640021, 67.62532395581506, 180.16319287192022,  /* lch */
        180.16319287192022, 99.99999999999139, 85.18291384640021,  /* hsluv */
        180.16319287192022, 197.7606244864312, 85.18291384640021,  /* hpluv */
    },
    {
        "#00eeee",
        0.0, 0.9333333333333333, 0.9333333333333333,  /* rgb */
        0.4600417069461948, 0.6731878299052012, 0.9146086196092741,  /* xyz */
        85.66467451749105, -66.24951526730094, -14.295878458690188,  /* luv */
        85.66467451749105, 67.77440825310083, 192.17705063006122,  /* lch */
        192.17705063006122, 99.99999999999143, 85.66467451749105,  /* hsluv */
        192.17705063006122, 205.6967147276875, 85.66467451749105,  /* hpluv */
    },
    {
        "#00eeff",
        0.0, 0.9333333333333333, 1.0,  /* rgb */
        0.48621275535602615, 0.6836562492691339, 1.052442807901056,  /* xyz */
        86.1889457184888, -64.87039439957672, -28.698729013518363,  /* luv */
        86.1889457184888, 70.93507677128429, 203.8646476384185,  /* lch */
        203.8646476384185, 99.99999999999399, 86.1889457184888,  /* hsluv */
        203.8646476384185, 224.45361973369958, 86.1889457184888,  /* hpluv */
    },
    {
        "#00ff00",
        0.0, 1.0, 0.0,  /* rgb */
        0.35758433938387, 0.71516867876775, 0.11919477979462,  /* xyz */
        87.73551910965973, -83.06711971439427, 107.41811123934433,  /* luv */
        87.73551910965973, 135.78953199666628, 127.71501294924047,  /* lch */
        127.71501294924047, 100.00000000000222, 87.73551910965973,  /* hsluv */
        127.71501294924047, 490.1453750637022, 87.73551910965973,  /* hpluv */
    },
    {
        "#00ff11",
        0.0, 1.0, 0.06666666666666667,  /* rgb */
        0.3585960048835071, 0.7155733449676049, 0.12452288475937563,  /* xyz */
        87.75508108828922, -82.96988377217029, 106.51348905910083,  /* luv */
        87.75508108828922, 135.01527678270574, 127.91721007215305,  /* lch */
        127.91721007215305, 99.99999999999177, 87.75508108828922,  /* hsluv */
        127.91721007215305, 488.2084035701352, 87.75508108828922,  /* hpluv */
    },
    {
        "#00ff22",
        0.0, 1.0, 0.13333333333333333,  /* rgb */
        0.3604713630219842, 0.7163234882229957, 0.13439977095535482,  /* xyz */
        87.79132428338119, -82.79070719859999, 104.84529176931913,  /* luv */
        87.79132428338119, 133.59205217616042, 128.29625894977266,  /* lch */
        128.29625894977266, 99.9999999999919, 87.79132428338119,  /* hsluv */
        128.29625894977266, 484.6417578873429, 87.79132428338119,  /* hpluv */
    },
    {
        "#00ff33",
        0.0, 1.0, 0.2,  /* rgb */
        0.3635591137544419, 0.7175585885159789, 0.15066192481296597,  /* xyz */
        87.85094310555812, -82.49869662301286, 102.12305364487946,  /* luv */
        87.85094310555812, 131.28272175062048, 128.93253169713134,  /* lch */
        128.93253169713134, 99.99999999999184, 87.85094310555812,  /* hsluv */
        128.93253169713134, 478.83772787806055, 87.85094310555812,  /* hpluv */
    },
    {
        "#00ff44",
        0.0, 1.0, 0.26666666666666666,  /* rgb */
        0.3680171089986608, 0.7193417866136664, 0.1741406997658526,  /* xyz */
        87.93689827660278, -82.08356732145715, 98.24541184851637,  /* luv */
        87.93689827660278, 128.0229392472333, 129.87859363490517,  /* lch */
        129.87859363490517, 99.99999999999167, 87.93689827660278,  /* hsluv */
        129.87859363490517, 470.61016907127964, 87.93689827660278,  /* hpluv */
    },
    {
        "#00ff55",
        0.0, 1.0, 0.3333333333333333,  /* rgb */
        0.3739795230380228, 0.7217267522294112, 0.2055427470398265,  /* xyz */
        88.05163857707342, -81.53997715017184, 93.15391298571711,  /* luv */
        88.05163857707342, 123.7999167132236, 131.1964797904311,  /* lch */
        131.1964797904311, 99.99999999999177, 88.05163857707342,  /* hsluv */
        131.1964797904311, 459.89295346755273, 88.05163857707342,  /* hpluv */
    },
    {
        "#00ff66",
        0.0, 1.0, 0.4,  /* rgb */
        0.381564518811531, 0.7247607505388145, 0.2454903914469705,  /* xyz */
        88.197238997611, -80.86703270432226, 86.82817153731925,  /* luv */
        88.197238997611, 118.65331158849322, 132.96413770939492,  /* lch */
        132.96413770939492, 99.99999999999177, 88.197238997611,  /* hsluv */
        132.96413770939492, 446.74883419420786, 88.197238997611,  /* hpluv */
    },
    {
        "#00ff77",
        0.0, 1.0, 0.4666666666666667,  /* rgb */
        0.3908785318317329, 0.7284863557468954, 0.2945441933533684,  /* xyz */
        88.37547459564232, -80.06792330996495, 79.28246332975255,  /* luv */
        88.37547459564232, 112.67910780088732, 135.2824164931273,  /* lch */
        135.2824164931273, 99.99999999999154, 88.37547459564232,  /* hsluv */
        135.2824164931273, 431.3936933951166, 88.37547459564232,  /* hpluv */
    },
    {
        "#00ff88",
        0.0, 1.0, 0.5333333333333333,  /* rgb */
        0.4020189489336767, 0.7329425225876729, 0.35321705675694054,  /* xyz */
        88.58786446547086, -79.14951354232164, 70.56217670869563,  /* luv */
        88.58786446547086, 106.03615551242578, 138.2828406903445,  /* lch */
        138.2828406903445, 99.9999999999914, 88.58786446547086,  /* hsluv */
        138.2828406903445, 414.23988815708447, 88.58786446547086,  /* hpluv */
    },
    {
        "#00ff99",
        0.0, 1.0, 0.6,  /* rgb */
        0.4150759130427494, 0.7381653082313021, 0.4219837343980585,  /* xyz */
        88.8357000190422, -78.12184220275357, 60.73961329866892,  /* luv */
        88.8357000190422, 98.95616632036513, 142.1349886621461,  /* lch */
        142.1349886621461, 99.99999999999153, 88.8357000190422,  /* hsluv */
        142.1349886621461, 395.96795814728137, 88.8357000190422,  /* hpluv */
    },
    {
        "#00ffaa",
        0.0, 1.0, 0.6666666666666666,  /* rgb */
        0.43013360600800193, 0.7441883854174032, 0.501287584015057,  /* xyz */
        89.12006444264627, -76.99752754955492, 49.90909296946828,  /* luv */
        89.12006444264627, 91.75803403397163, 147.04906197751953,  /* lch */
        147.04906197751953, 99.9999999999913, 89.12006444264627,  /* hsluv */
        147.04906197751953, 377.63975015606667, 89.12006444264627,  /* hpluv */
    },
    {
        "#00ffbb",
        0.0, 1.0, 0.7333333333333333,  /* rgb */
        0.4472711981153386, 0.7510434222603379, 0.5915455691136988,  /* xyz */
        89.44184702348242, -75.79110560866114, 38.18155466899644,  /* luv */
        89.44184702348242, 84.86532157674765, 153.2622430371542,  /* lch */
        153.2622430371542, 99.9999999999912, 89.44184702348242,  /* hsluv */
        153.2622430371542, 360.86343344614914, 89.44184702348242,  /* hpluv */
    },
    {
        "#00ffcc",
        0.0, 1.0, 0.8,  /* rgb */
        0.4665635735590603, 0.7587603724378268, 0.693152079783969,  /* xyz */
        89.80175448795563, -74.51834150324072, 25.678959857570224,  /* luv */
        89.80175448795563, 78.81873000601006, 160.9860904431144,  /* lch */
        160.9860904431144, 99.99999999999125, 89.80175448795563,  /* hsluv */
        160.9860904431144, 347.9971534515541, 89.80175448795563,  /* hpluv */
    },
    {
        "#00ffdd",
        0.0, 1.0, 0.8666666666666667,  /* rgb */
        0.4880818991096939, 0.7673677026580803, 0.806481927683975,  /* xyz */
        90.20032065827743, -73.19555698671316, 12.528836635233692,  /* luv */
        90.20032065827743, 74.260092310928, 170.28684980047865,  /* lch */
        170.28684980047865, 99.99999999999133, 90.20032065827743,  /* hsluv */
        170.28684980047865, 342.3082089721665, 90.20032065827743,  /* hpluv */
    },
    {
        "#00ffee",
        0.0, 1.0, 0.9333333333333333,  /* rgb */
        0.5118940793758686, 0.7768925747645503, 0.9318927437524982,  /* xyz */
        90.63791524814295, -71.83901334009299, -1.1407265281820043,  /* luv */
        90.63791524814295, 71.84806952653743, 180.909719109957,  /* lch */
        180.909719109957, 99.99999999999137, 90.63791524814295,  /* hsluv */
        180.909719109957, 347.89528398060514, 90.63791524814295,  /* hpluv */
    },
    {
        "#00ffff",
        0.0, 1.0, 1.0,  /* rgb */
        0.5380651277857, 0.787360994128483, 1.06972693204428,  /* xyz */
        91.11475231670507, -70.46437996387182, -15.205397466925735,  /* luv */
        91.11475231670507, 72.0862882649682, 192.17705063006116,  /* lch */
        192.17705063006116, 99.99999999999149, 91.11475231670507,  /* hsluv */
        192.17705063006116, 369.19053391705137, 91.11475231670507,  /* hpluv */
    },
    {
        "#110000",
        0.06666666666666667, 0.0, 0.0,  /* rgb */
        0.0023116119321036225, 0.0011919249024909557, 0.00010835680931735503,  /* xyz */
        1.0766613497686264, 3.539378669283785, 0.7637569432955262,  /* luv */
        1.0766613497686264, 3.6208460382917664, 12.177050630061782,  /* lch */
        12.177050630061782, 100.0000000000022, 1.0766613497686264,  /* hsluv */
        12.177050630061782, 426.74678918312514, 1.0766613497686264,  /* hpluv */
    },
    {
        "#110011",
        0.06666666666666667, 0.0, 0.06666666666666667,  /* rgb */
        0.003323277431740744, 0.00159659110234581, 0.005436461774072986,  /* xyz */
        1.4421948292948454, 2.009599894447431, -2.598710846728662,  /* luv */
        1.4421948292948454, 3.285085965491364, 307.7150129492436,  /* lch */
        307.7150129492436, 99.99999999999883, 1.4421948292948454,  /* hsluv */
        307.7150129492436, 289.0427837304834, 1.4421948292948454,  /* hpluv */
    },
    {
        "#110022",
        0.06666666666666667, 0.0, 0.13333333333333333,  /* rgb */
        0.005198635570217764, 0.002346734357736628, 0.015313347970052182,  /* xyz */
        2.119796453508782, 1.1853980586255333, -6.164518305304162,  /* luv */
        2.119796453508782, 6.277456052719388, 280.8847541676847,  /* lch */
        280.8847541676847, 99.99999999999987, 2.119796453508782,  /* hsluv */
        280.8847541676847, 375.77583306469006, 2.119796453508782,  /* hpluv */
    },
    {
        "#110033",
        0.06666666666666667, 0.0, 0.2,  /* rgb */
        0.008286386302675502, 0.0035818346507197414, 0.031575501827663326,  /* xyz */
        3.235457973595963, 0.5736173089570297, -11.047386706576248,  /* luv */
        3.235457973595963, 11.062268748397532, 272.9723194813983,  /* lch */
        272.9723194813983, 100.00000000000036, 3.235457973595963,  /* hsluv */
        272.9723194813983, 433.8581585194352, 3.235457973595963,  /* hpluv */
    },
    {
        "#110044",
        0.06666666666666667, 0.0, 0.26666666666666666,  /* rgb */
        0.012744381546894383, 0.0053650327484073175, 0.055054276780549964,  /* xyz */
        4.846214210628037, -0.033727593455624975, -17.731248936216183,  /* luv */
        4.846214210628037, 17.731281013751595, 269.89101464682847,  /* lch */
        269.89101464682847, 100.00000000000071, 4.846214210628037,  /* hsluv */
        269.89101464682847, 464.27663974694553, 4.846214210628037,  /* hpluv */
    },
    {
        "#110055",
        0.06666666666666667, 0.0, 0.3333333333333333,  /* rgb */
        0.018706795586256375, 0.0077499983641521495, 0.08645632405452387,  /* xyz */
        7.000544817894696, -0.7344440753361153, -26.522723399236554,  /* luv */
        7.000544817894696, 26.532890242342738, 268.4138206943611,  /* lch */
        268.4138206943611, 100.00000000000068, 7.000544817894696,  /* hsluv */
        268.4138206943611, 480.9412709024037, 7.000544817894696,  /* hpluv */
    },
    {
        "#110066",
        0.06666666666666667, 0.0, 0.4,  /* rgb */
        0.02629179135976455, 0.010783996673555462, 0.12640396846166785,  /* xyz */
        9.62818818466394, -1.5565952740950795, -37.20259719127408,  /* luv */
        9.62818818466394, 37.2351477319955, 267.6040826289064,  /* lch */
        267.6040826289064, 100.00000000000075, 9.62818818466394,  /* hsluv */
        267.6040826289064, 490.73590857145774, 9.62818818466394,  /* hpluv */
    },
    {
        "#110077",
        0.06666666666666667, 0.0, 0.4666666666666667,  /* rgb */
        0.035605804379966466, 0.014509601881636278, 0.17545777036806576,  /* xyz */
        12.292836378759056, -2.420734586626206, -48.073196920263314,  /* luv */
        12.292836378759056, 48.134106598889964, 267.117295446388,  /* lch */
        267.117295446388, 100.00000000000074, 12.292836378759056,  /* hsluv */
        267.117295446388, 496.86698552110533, 12.292836378759056,  /* hpluv */
    },
    {
        "#110088",
        0.06666666666666667, 0.0, 0.5333333333333333,  /* rgb */
        0.046746221481910294, 0.018965768722413873, 0.23413063377163792,  /* xyz */
        14.93485888979681, -3.2866037546064337, -58.86351669283488,  /* luv */
        14.93485888979681, 58.95519791916098, 266.8042478977243,  /* lch */
        266.8042478977243, 100.00000000000075, 14.93485888979681,  /* hsluv */
        266.8042478977243, 500.9106951827508, 14.93485888979681,  /* hpluv */
    },
    {
        "#110099",
        0.06666666666666667, 0.0, 0.6,  /* rgb */
        0.05980318559098301, 0.02418855436604303, 0.30289731141275583,  /* xyz */
        17.547587453513962, -4.140260961410653, -69.5307339482636,  /* luv */
        17.547587453513962, 69.65389238379143, 266.59230255326986,  /* lch */
        266.59230255326986, 100.0000000000008, 17.547587453513962,  /* hsluv */
        266.59230255326986, 503.69460774399283, 17.547587453513962,  /* hpluv */
    },
    {
        "#1100aa",
        0.06666666666666667, 0.0, 0.6666666666666666,  /* rgb */
        0.07486087855623555, 0.03021163155214413, 0.38220116102975443,  /* xyz */
        20.128454389503673, -4.976753340809858, -80.05891046738472,  /* luv */
        20.128454389503673, 80.2134478690449, 266.442863009455,  /* lch */
        266.442863009455, 100.00000000000078, 20.128454389503673,  /* hsluv */
        266.442863009455, 505.6803559050965, 20.128454389503673,  /* hpluv */
    },
    {
        "#1100bb",
        0.06666666666666667, 0.0, 0.7333333333333333,  /* rgb */
        0.0919984706635722, 0.03706666839507889, 0.4724591461283962,  /* xyz */
        22.67697563053642, -5.794948061223888, -90.44477752500214,  /* luv */
        22.67697563053642, 90.63023339139879, 266.3339747285724,  /* lch */
        266.3339747285724, 100.000000000001, 22.67697563053642,  /* hsluv */
        266.3339747285724, 507.13932884688546, 22.67697563053642,  /* hpluv */
    },
    {
        "#1100cc",
        0.06666666666666667, 0.0, 0.8,  /* rgb */
        0.11129084610729394, 0.04478361857256769, 0.5740656567986663,  /* xyz */
        25.193723533986933, -6.595318648052104, -100.69105184917565,  /* luv */
        25.193723533986933, 100.90681914797793, 266.25244856860127,  /* lch */
        266.25244856860127, 100.00000000000082, 25.193723533986933,  /* hsluv */
        266.25244856860127, 508.2384098317264, 25.193723533986933,  /* hpluv */
    },
    {
        "#1100dd",
        0.06666666666666667, 0.0, 0.8666666666666667,  /* rgb */
        0.1328091716579275, 0.053390948792821226, 0.6873955046986723,  /* xyz */
        27.67978936630123, -7.378966699920844, -110.80317675848819,  /* luv */
        27.67978936630123, 111.04860705714106, 266.1899982101446,  /* lch */
        266.1899982101446, 100.00000000000094, 27.67978936630123,  /* hsluv */
        266.1899982101446, 509.08424976046194, 27.67978936630123,  /* hpluv */
    },
    {
        "#1100ee",
        0.06666666666666667, 0.0, 0.9333333333333333,  /* rgb */
        0.15662135192410223, 0.06291582089929126, 0.8128063207671955,  /* xyz */
        30.136496458449685, -8.147183712958588, -120.78769430130463,  /* luv */
        30.136496458449685, 121.06214807725046, 266.14121902282534,  /* lch */
        266.14121902282534, 100.00000000000095, 30.136496458449685,  /* hsluv */
        266.14121902282534, 509.7473074190758, 30.136496458449685,  /* hpluv */
    },
    {
        "#1100ff",
        0.06666666666666667, 0.0, 1.0,  /* rgb */
        0.18279240033393362, 0.07338424026322396, 0.9506405090589773,  /* xyz */
        32.565245675264826, -8.901257250835025, -130.65142427581378,  /* luv */
        32.565245675264826, 130.9542937285534, 266.10247209374984,  /* lch */
        266.10247209374984, 100.00000000000111, 32.565245675264826,  /* hsluv */
        266.10247209374984, 510.27549218106066, 32.565245675264826,  /* hpluv */
    },
    {
        "#111100",
        0.06666666666666667, 0.06666666666666667, 0.0,  /* rgb */
        0.0043160121930320315, 0.005200725424347829, 0.0007764902296268059,  /* xyz */
        4.697796013366568, 0.37258994144389895, 5.165432992105157,  /* luv */
        4.697796013366568, 5.178853276584847, 85.87432021817473,  /* lch */
        85.87432021817473, 100.00000000000236, 4.697796013366568,  /* hsluv */
        85.87432021817473, 139.88745807479762, 4.697796013366568,  /* hpluv */
    },
    {
        "#111111",
        0.06666666666666667, 0.06666666666666667, 0.06666666666666667,  /* rgb */
        0.005327677692669153, 0.005605391624202684, 0.006104595194382437,  /* xyz */
        5.0633294928927866, 2.5212091054465253e-13, 9.134815599443933e-14,  /* luv */
        5.0633294928927866, 2.681593539995372e-13, 0.0,  /* lch */
        0.0, 1.9241939994479228e-12, 5.0633294928927866,  /* hsluv */
        0.0, 6.72041492281092e-12, 5.0633294928927866,  /* hpluv */
    },
    {
        "#111122",
        0.06666666666666667, 0.06666666666666667, 0.13333333333333333,  /* rgb */
        0.007203035831146173, 0.006355534879593502, 0.015981481390361634,  /* xyz */
        5.740931117106723, -0.4748385423952974, -6.582965346057432,  /* luv */
        5.740931117106723, 6.6000685139426505, 265.8743202181797,  /* lch */
        265.8743202181797, 28.41442223352254, 5.740931117106723,  /* hsluv */
        265.8743202181797, 145.88325148184043, 5.740931117106723,  /* hpluv */
    },
    {
        "#111133",
        0.06666666666666667, 0.06666666666666667, 0.2,  /* rgb */
        0.010290786563603913, 0.0075906351725766145, 0.03224363524797278,  /* xyz */
        6.856592637193904, -1.0224992597651805, -14.175507235464098,  /* luv */
        6.856592637193904, 14.212336546779186, 265.8743202181786,  /* lch */
        265.8743202181786, 51.230648902839896, 6.856592637193904,  /* hsluv */
        265.8743202181786, 263.0246561428878, 6.856592637193904,  /* hpluv */
    },
    {
        "#111144",
        0.06666666666666667, 0.06666666666666667, 0.26666666666666666,  /* rgb */
        0.01474878180782279, 0.009373833270264191, 0.05572241020085942,  /* xyz */
        8.458532578547771, -1.6398159057334576, -22.733730136773218,  /* luv */
        8.458532578547771, 22.79279452231181, 265.87432021817824,  /* lch */
        265.87432021817824, 66.60015973726746, 8.458532578547771,  /* hsluv */
        265.87432021817824, 341.93367620969724, 8.458532578547771,  /* hpluv */
    },
    {
        "#111155",
        0.06666666666666667, 0.06666666666666667, 0.3333333333333333,  /* rgb */
        0.020711195847184786, 0.011758798886009024, 0.08712445747483333,  /* xyz */
        10.378229558504533, -2.311164879433966, -32.041034903327954,  /* luv */
        10.378229558504533, 32.12428054877197, 265.8743202181781,  /* lch */
        265.8743202181781, 76.50377388014815, 10.378229558504533,  /* hsluv */
        265.8743202181781, 392.78008866571327, 10.378229558504533,  /* hpluv */
    },
    {
        "#111166",
        0.06666666666666667, 0.06666666666666667, 0.4,  /* rgb */
        0.02829619162069296, 0.014792797195412336, 0.1270721018819773,  /* xyz */
        12.475722824804848, -3.011969827457129, -41.756705126532864,  /* luv */
        12.475722824804848, 41.86519300404249, 265.87432021817807,  /* lch */
        265.87432021817807, 82.93924967553453, 12.475722824804848,  /* hsluv */
        265.87432021817807, 425.820638501567, 12.475722824804848,  /* hpluv */
    },
    {
        "#111177",
        0.06666666666666667, 0.06666666666666667, 0.4666666666666667,  /* rgb */
        0.03761020464089487, 0.018518402403493152, 0.1761259037883752,  /* xyz */
        14.68968952750366, -3.730085755214226, -51.71236761978372,  /* luv */
        14.68968952750366, 51.84672125202237, 265.874320218178,  /* lch */
        265.874320218178, 87.23311924193332, 14.68968952750366,  /* hsluv */
        265.874320218178, 447.86591004139166, 14.68968952750366,  /* hpluv */
    },
    {
        "#111188",
        0.06666666666666667, 0.06666666666666667, 0.5333333333333333,  /* rgb */
        0.0487506217428387, 0.022974569244270743, 0.23479876719194737,  /* xyz */
        16.97669405393915, -4.4567930553088875, -61.78713734912365,  /* luv */
        16.97669405393915, 61.94766618797935, 265.874320218178,  /* lch */
        265.874320218178, 90.18712636082735, 16.97669405393915,  /* hsluv */
        265.874320218178, 463.0321576554776, 16.97669405393915,  /* hpluv */
    },
    {
        "#111199",
        0.06666666666666667, 0.06666666666666667, 0.6,  /* rgb */
        0.061807585851911415, 0.028197354887899907, 0.30356544483306525,  /* xyz */
        19.306996891682047, -5.186204528347375, -71.8993966147786,  /* luv */
        19.306996891682047, 72.08619806161985, 265.874320218178,  /* lch */
        265.874320218178, 92.28053759689543, 19.306996891682047,  /* hsluv */
        265.874320218178, 473.7799967386157, 19.306996891682047,  /* hpluv */
    },
    {
        "#1111aa",
        0.06666666666666667, 0.06666666666666667, 0.6666666666666666,  /* rgb */
        0.07686527881716396, 0.03422043207400101, 0.38286929445006385,  /* xyz */
        21.660535019249124, -5.914508357527227, -81.99629996366163,  /* luv */
        21.660535019249124, 82.20933412236128, 265.87432021817796,  /* lch */
        265.87432021817796, 93.80471596528476, 21.660535019249124,  /* hsluv */
        265.87432021817796, 481.605322004481, 21.660535019249124,  /* hpluv */
    },
    {
        "#1111bb",
        0.06666666666666667, 0.06666666666666667, 0.7333333333333333,  /* rgb */
        0.0940028709245006, 0.04107546891693577, 0.4731272795487056,  /* xyz */
        24.023847265408243, -6.639315197895261, -92.04472250463122,  /* luv */
        24.023847265408243, 92.28386341745542, 265.87432021817796,  /* lch */
        265.87432021817796, 94.94146557069757, 24.023847265408243,  /* hsluv */
        265.87432021817796, 487.4415388099975, 24.023847265408243,  /* hpluv */
    },
    {
        "#1111cc",
        0.06666666666666667, 0.06666666666666667, 0.8,  /* rgb */
        0.11329524636822234, 0.04879241909442457, 0.5747337902189757,  /* xyz */
        26.3879200105999, -7.359177787015586, -102.0245999892926,  /* luv */
        26.3879200105999, 102.28966956968854, 265.87432021817796,  /* lch */
        265.87432021817796, 95.80746265982597, 26.3879200105999,  /* hsluv */
        265.87432021817796, 491.8876778198845, 26.3879200105999,  /* hpluv */
    },
    {
        "#1111dd",
        0.06666666666666667, 0.06666666666666667, 0.8666666666666667,  /* rgb */
        0.1348135719188559, 0.0573997493146781, 0.6880636381189817,  /* xyz */
        28.746731820254404, -8.073262110707358, -111.92436998966132,  /* luv */
        28.746731820254404, 112.21516011079244, 265.87432021817796,  /* lch */
        265.87432021817796, 96.47966300387831, 28.746731820254404,  /* hsluv */
        265.87432021817796, 495.3388397344802, 28.746731820254404,  /* hpluv */
    },
    {
        "#1111ee",
        0.06666666666666667, 0.06666666666666667, 0.9333333333333333,  /* rgb */
        0.15862575218503064, 0.06692462142114813, 0.813474454187505,  /* xyz */
        31.096282761883856, -8.781129673537864, -121.7379533862467,  /* luv */
        31.096282761883856, 122.05424012714782, 265.87432021817796,  /* lch */
        265.87432021817796, 97.01013665586945, 31.096282761883856,  /* hsluv */
        265.87432021817796, 498.0623588172162, 31.096282761883856,  /* hpluv */
    },
    {
        "#1111ff",
        0.06666666666666667, 0.06666666666666667, 1.0,  /* rgb */
        0.18479680059486203, 0.07739304078508083, 0.9513086424792868,  /* xyz */
        33.43394758133966, -9.482595351371549, -131.46278369452807,  /* luv */
        33.43394758133966, 131.80433646626398, 265.87432021817796,  /* lch */
        265.87432021817796, 99.99999999999952, 33.43394758133966,  /* hsluv */
        265.87432021817796, 500.24340111250376, 33.43394758133966,  /* hpluv */
    },
    {
        "#112200",
        0.06666666666666667, 0.13333333333333333, 0.0,  /* rgb */
        0.008031635927799968, 0.012631972893883804, 0.0020150314745494163,  /* xyz */
        11.015626967528249, -5.728655214592081, 12.915150733510083,  /* luv */
        11.015626967528249, 14.128644982338509, 113.92019951657474,  /* lch */
        113.92019951657474, 100.0000000000023, 11.015626967528249,  /* hsluv */
        113.92019951657474, 162.7536055533309, 11.015626967528249,  /* hpluv */
    },
    {
        "#112211",
        0.06666666666666667, 0.13333333333333333, 0.06666666666666667,  /* rgb */
        0.00904330142743709, 0.013036639093738658, 0.007343136439305047,  /* xyz */
        11.301082674241883, -5.613746835015641, 7.2594076220120956,  /* luv */
        11.301082674241883, 9.17677244733547, 127.71501294923874,  /* lch */
        127.71501294923874, 52.46613462448928, 11.301082674241883,  /* hsluv */
        127.71501294923874, 103.0408036580292, 11.301082674241883,  /* hpluv */
    },
    {
        "#112222",
        0.06666666666666667, 0.13333333333333333, 0.13333333333333333,  /* rgb */
        0.010918659565914108, 0.013786782349129476, 0.017220022635284243,  /* xyz */
        11.814993474104362, -5.483348703043223, -1.1832431722562533,  /* luv */
        11.814993474104362, 5.609561248783797, 192.17705063006088,  /* lch */
        192.17705063006088, 60.01108003316419, 11.814993474104362,  /* hsluv */
        192.17705063006088, 60.246904090494155, 11.814993474104362,  /* hpluv */
    },
    {
        "#112233",
        0.06666666666666667, 0.13333333333333333, 0.2,  /* rgb */
        0.014006410298371848, 0.015021882642112589, 0.03348217649289539,  /* xyz */
        12.621964857006773, -5.40540262923445, -11.555862915490067,  /* luv */
        12.621964857006773, 12.757599511888328, 244.93155638428982,  /* lch */
        244.93155638428982, 68.29655549894483, 12.621964857006773,  /* hsluv */
        244.93155638428982, 128.25707299056486, 12.621964857006773,  /* hpluv */
    },
    {
        "#112244",
        0.06666666666666667, 0.13333333333333333, 0.26666666666666666,  /* rgb */
        0.018464405542590726, 0.016805080739800166, 0.056960951445782025,  /* xyz */
        13.712431284516718, -5.439309188705111, -22.40537624723054,  /* luv */
        13.712431284516718, 23.05616987338301, 256.3544020608671,  /* lch */
        256.3544020608671, 75.59659947386045, 13.712431284516718,  /* hsluv */
        256.3544020608671, 213.3595199491015, 13.712431284516718,  /* hpluv */
    },
    {
        "#112255",
        0.06666666666666667, 0.13333333333333333, 0.3333333333333333,  /* rgb */
        0.02442681958195272, 0.019190046355545, 0.08836299871975593,  /* xyz */
        15.056320299603339, -5.598095891197816, -33.114983835502386,  /* luv */
        15.056320299603339, 33.584830385646285, 260.40485184836416,  /* lch */
        260.40485184836416, 81.3424686793067, 15.056320299603339,  /* hsluv */
        260.40485184836416, 283.0503138113369, 15.056320299603339,  /* hpluv */
    },
    {
        "#112266",
        0.06666666666666667, 0.13333333333333333, 0.4,  /* rgb */
        0.032011815355460896, 0.02222404466494831, 0.1283106431268999,  /* xyz */
        16.613621223111828, -5.868009350487344, -43.571141916086596,  /* luv */
        16.613621223111828, 43.96450774896911, 262.32975584824334,  /* lch */
        262.32975584824334, 85.64284901875584, 16.613621223111828,  /* hsluv */
        262.32975584824334, 335.7973285373636, 16.613621223111828,  /* hpluv */
    },
    {
        "#112277",
        0.06666666666666667, 0.13333333333333333, 0.4666666666666667,  /* rgb */
        0.041325828375662815, 0.025949649873029126, 0.17736444503329782,  /* xyz */
        18.342756984026977, -6.227404690492469, -53.82311572323418,  /* luv */
        18.342756984026977, 54.18217746949477, 263.40014945367113,  /* lch */
        263.40014945367113, 88.80997445275256, 18.342756984026977,  /* hsluv */
        263.40014945367113, 374.8272603721816, 18.342756984026977,  /* hpluv */
    },
    {
        "#112288",
        0.06666666666666667, 0.13333333333333333, 0.5333333333333333,  /* rgb */
        0.05246624547760664, 0.030405816713806717, 0.23603730843686999,  /* xyz */
        20.205694312280237, -6.655651324383493, -63.93486442427951,  /* luv */
        20.205694312280237, 64.2803592359499, 264.05688737440346,  /* lch */
        264.05688737440346, 91.14610017382228, 20.205694312280237,  /* hsluv */
        264.05688737440346, 403.6861442578909, 20.205694312280237,  /* hpluv */
    },
    {
        "#112299",
        0.06666666666666667, 0.13333333333333333, 0.6,  /* rgb */
        0.06552320958667936, 0.03562860235743588, 0.30480398607798787,  /* xyz */
        22.17018380613613, -7.1357932121593315, -73.94840201851247,  /* luv */
        22.17018380613613, 74.29189529052438, 264.4881993319916,  /* lch */
        264.4881993319916, 92.88662942424261, 22.17018380613613,  /* hsluv */
        264.4881993319916, 425.21783382653126, 22.17018380613613,  /* hpluv */
    },
    {
        "#1122aa",
        0.06666666666666667, 0.13333333333333333, 0.6666666666666666,  /* rgb */
        0.0805809025519319, 0.04165167954353698, 0.38410783569498647,  /* xyz */
        24.21013168239225, -7.654680153315589, -83.88477255106255,  /* luv */
        24.21013168239225, 84.23330216840048, 264.78606728082394,  /* lch */
        264.78606728082394, 94.20124237370102, 24.21013168239225,  /* hsluv */
        264.78606728082394, 441.4952154223815, 24.21013168239225,  /* hpluv */
    },
    {
        "#1122bb",
        0.06666666666666667, 0.13333333333333333, 0.7333333333333333,  /* rgb */
        0.09771849465926855, 0.04850671638647174, 0.4743658207936282,  /* xyz */
        26.305024223265015, -8.202348041169493, -93.75201349358849,  /* luv */
        26.305024223265015, 94.11014051360499, 264.99993348050043,  /* lch */
        264.99993348050043, 95.20896916025066, 26.305024223265015,  /* hsluv */
        264.99993348050043, 453.98033637772636, 26.305024223265015,  /* hpluv */
    },
    {
        "#1122cc",
        0.06666666666666667, 0.13333333333333333, 0.8,  /* rgb */
        0.11701087010299029, 0.05622366656396054, 0.5759723314638984,  /* xyz */
        28.43901020655762, -8.771305202414016, -103.55161056570812,  /* luv */
        28.43901020655762, 103.92243186966887, 265.15833717263416,  /* lch */
        265.15833717263416, 95.99289423283895, 28.43901020655762,  /* hsluv */
        265.15833717263416, 463.69685512523705, 28.43901020655762,  /* hpluv */
    },
    {
        "#1122dd",
        0.06666666666666667, 0.13333333333333333, 0.8666666666666667,  /* rgb */
        0.13852919565362382, 0.06483099678421407, 0.6893021793639044,  /* xyz */
        30.59996125002037, -9.355920920970377, -113.2823928885914,  /* luv */
        30.59996125002037, 113.66808608771697, 265.27869316622997,  /* lch */
        265.27869316622997, 96.6113336559982, 30.59996125002037,  /* hsluv */
        265.27869316622997, 471.3646370155489, 30.59996125002037,  /* hpluv */
    },
    {
        "#1122ee",
        0.06666666666666667, 0.13333333333333333, 0.9333333333333333,  /* rgb */
        0.16234137591979855, 0.0743558688906841, 0.8147129954324276,  /* xyz */
        32.778645914485146, -9.951949540386932, -122.94255653106796,  /* luv */
        32.778645914485146, 123.3446938706698, 265.37211393361406,  /* lch */
        265.37211393361406, 97.10565303865671, 32.778645914485146,  /* hsluv */
        265.37211393361406, 477.49495683813154, 32.778645914485146,  /* hpluv */
    },
    {
        "#1122ff",
        0.06666666666666667, 0.13333333333333333, 1.0,  /* rgb */
        0.18851242432962995, 0.08482428825461681, 0.9525471837242094,  /* xyz */
        34.9680553815075, -10.55617421544366, -132.53058177093075,  /* luv */
        34.9680553815075, 132.95032124296714, 265.445956583698,  /* lch */
        265.445956583698, 99.99999999999956, 34.9680553815075,  /* hsluv */
        265.445956583698, 482.4554716934249, 34.9680553815075,  /* hpluv */
    },
    {
        "#113300",
        0.06666666666666667, 0.2, 0.0,  /* rgb */
        0.01414935801681078, 0.024867417071905602, 0.004054272170886297,  /* xyz */
        17.858539079319115, -13.023465356909725, 21.39244651136443,  /* luv */
        17.858539079319115, 25.044908018282197, 121.33255464899105,  /* lch */
        121.33255464899105, 100.00000000000229, 17.858539079319115,  /* hsluv */
        121.33255464899105, 177.9560834693095, 17.858539079319115,  /* hpluv */
    },
    {
        "#113311",
        0.06666666666666667, 0.2, 0.06666666666666667,  /* rgb */
        0.015161023516447901, 0.025272083271760455, 0.009382377135641929,  /* xyz */
        18.041211184449395, -12.724996405605609, 16.455308479665174,  /* luv */
        18.041211184449395, 20.801507413733656, 127.71501294923979,  /* lch */
        127.71501294923979, 74.49691289156893, 18.041211184449395,  /* hsluv */
        127.71501294923979, 146.30812483766658, 18.041211184449395,  /* hpluv */
    },
    {
        "#113322",
        0.06666666666666667, 0.2, 0.13333333333333333,  /* rgb */
        0.01703638165492492, 0.026022226527151276, 0.019259263331621125,  /* xyz */
        18.374744086375813, -12.260561669039353, 8.402601541805167,  /* luv */
        18.374744086375813, 14.863548873356713, 145.57576432722593,  /* lch */
        145.57576432722593, 76.8412554017051, 18.374744086375813,  /* hsluv */
        145.57576432722593, 102.6456484904797, 18.374744086375813,  /* hpluv */
    },
    {
        "#113333",
        0.06666666666666667, 0.2, 0.2,  /* rgb */
        0.02012413238738266, 0.02725732682013439, 0.03552141718923227,  /* xyz */
        18.910205854271, -11.682766064603904, -2.5210056714682163,  /* luv */
        18.910205854271, 11.95167320988302, 192.17705063006107,  /* lch */
        192.17705063006107, 79.88559754494534, 18.910205854271,  /* hsluv */
        192.17705063006107, 80.19952200231, 18.910205854271,  /* hpluv */
    },
    {
        "#113344",
        0.06666666666666667, 0.2, 0.26666666666666666,  /* rgb */
        0.024582127631601537, 0.029040524917821962, 0.05900019214211891,  /* xyz */
        19.655468169529414, -11.118822707946157, -14.855235523620712,  /* luv */
        19.655468169529414, 18.555490855080656, 233.1859396382372,  /* lch */
        233.1859396382372, 83.09417286009462, 19.655468169529414,  /* hsluv */
        233.1859396382372, 119.79215597403514, 19.655468169529414,  /* hpluv */
    },
    {
        "#113355",
        0.06666666666666667, 0.2, 0.3333333333333333,  /* rgb */
        0.030544541670963533, 0.031425490533566795, 0.09040223941609282,  /* xyz */
        20.605977721084756, -10.661582798422282, -27.456883704577233,  /* luv */
        20.605977721084756, 29.454198521336355, 248.7786729863713,  /* lch */
        248.7786729863713, 86.06678908513321, 20.605977721084756,  /* hsluv */
        248.7786729863713, 181.381634101163, 20.605977721084756,  /* hpluv */
    },
    {
        "#113366",
        0.06666666666666667, 0.2, 0.4,  /* rgb */
        0.03812953744447171, 0.03445948884297011, 0.13034988382323678,  /* xyz */
        21.748027801482593, -10.352782329675335, -39.72449464452882,  /* luv */
        21.748027801482593, 41.051377281753126, 255.3928057773225,  /* lch */
        255.3928057773225, 88.61372156499905, 21.748027801482593,  /* hsluv */
        255.3928057773225, 239.52297620119123, 21.748027801482593,  /* hpluv */
    },
    {
        "#113377",
        0.06666666666666667, 0.2, 0.4666666666666667,  /* rgb */
        0.04744355046467362, 0.03818509405105092, 0.1794036857296347,  /* xyz */
        23.06213207492241, -10.196454055079275, -51.46351585147113,  /* luv */
        23.06213207492241, 52.46390320107686, 258.7931399156127,  /* lch */
        258.7931399156127, 90.70101405037249, 23.06213207492241,  /* hsluv */
        258.7931399156127, 288.669213908808, 23.06213207492241,  /* hpluv */
    },
    {
        "#113388",
        0.06666666666666667, 0.2, 0.5333333333333333,  /* rgb */
        0.05858396756661745, 0.042641260891828514, 0.23807654913320686,  /* xyz */
        24.52608664551557, -10.177529995229872, -62.68711574444333,  /* luv */
        24.52608664551557, 63.50792546730714, 260.77824075954175,  /* lch */
        260.77824075954175, 92.3732755032704, 24.52608664551557,  /* hsluv */
        260.77824075954175, 328.5783880762134, 24.52608664551557,  /* hpluv */
    },
    {
        "#113399",
        0.06666666666666667, 0.2, 0.6,  /* rgb */
        0.07164093167569016, 0.04786404653545768, 0.30684322677432474,  /* xyz */
        26.117358609444445, -10.274639816074279, -73.48126539689144,  /* luv */
        26.117358609444445, 74.19612245716387, 262.0401306436455,  /* lch */
        262.0401306436455, 93.70093179353228, 26.117358609444445,  /* hsluv */
        262.0401306436455, 360.4883911017238, 26.117358609444445,  /* hpluv */
    },
    {
        "#1133aa",
        0.06666666666666667, 0.2, 0.6666666666666666,  /* rgb */
        0.0866986246409427, 0.05388712372155878, 0.38614707639132334,  /* xyz */
        27.814681293710038, -10.466575341337267, -83.93951132407928,  /* luv */
        27.814681293710038, 84.58954285667421, 262.8923667744152,  /* lch */
        262.8923667744152, 94.75407191560475, 27.814681293710038,  /* hsluv */
        262.8923667744152, 385.9063424732101, 27.814681293710038,  /* hpluv */
    },
    {
        "#1133bb",
        0.06666666666666667, 0.2, 0.7333333333333333,  /* rgb */
        0.10383621674827935, 0.06074216056449354, 0.4764050614899651,  /* xyz */
        29.59893866420129, -10.734795769033445, -94.1396974912241,  /* luv */
        29.59893866420129, 94.74976772500312, 263.4946334413523,  /* lch */
        263.4946334413523, 95.59270717643426, 29.59893866420129,  /* hsluv */
        263.4946334413523, 406.2013306606183, 29.59893866420129,  /* hpluv */
    },
    {
        "#1133cc",
        0.06666666666666667, 0.2, 0.8,  /* rgb */
        0.12312859219200109, 0.06845911074198234, 0.5780115721602352,  /* xyz */
        31.453517167571093, -11.063990058024993, -104.13989138484484,  /* luv */
        31.453517167571093, 104.72597029224106, 263.9355527196958,  /* lch */
        263.9355527196958, 96.26489350853943, 31.453517167571093,  /* hsluv */
        263.9355527196958, 422.4978502717015, 31.453517167571093,  /* hpluv */
    },
    {
        "#1133dd",
        0.06666666666666667, 0.2, 0.8666666666666667,  /* rgb */
        0.14464691774263463, 0.07706644096223587, 0.6913414200602412,  /* xyz */
        33.364312195365684, -11.441847262507356, -113.98117565824276,  /* luv */
        33.364312195365684, 114.55402338291633, 264.2676433958718,  /* lch */
        264.2676433958718, 96.80791282972899, 33.364312195365684,  /* hsluv */
        264.2676433958718, 435.6798729570868, 33.364312195365684,  /* hpluv */
    },
    {
        "#1133ee",
        0.06666666666666667, 0.2, 0.9333333333333333,  /* rgb */
        0.16845909800880937, 0.0865913130687059, 0.8167522361287645,  /* xyz */
        35.31954110967344, -11.858582166050047, -123.69190928123479,  /* luv */
        35.31954110967344, 124.25906161172382, 264.5236804613673,  /* lch */
        264.5236804613673, 97.25028751580678, 35.31954110967344,  /* hsluv */
        264.5236804613673, 446.42894359321036, 35.31954110967344,  /* hpluv */
    },
    {
        "#1133ff",
        0.06666666666666667, 0.2, 1.0,  /* rgb */
        0.19463014641864076, 0.0970597324326386, 0.9545864244205463,  /* xyz */
        37.30946848569015, -12.306443876006231, -133.291532760957,  /* luv */
        37.30946848569015, 133.85843741295716, 264.72499157154994,  /* lch */
        264.72499157154994, 99.99999999999952, 37.30946848569015,  /* hsluv */
        264.72499157154994, 455.266836240216, 37.30946848569015,  /* hpluv */
    },
    {
        "#114400",
        0.06666666666666667, 0.26666666666666666, 0.0,  /* rgb */
        0.022981928499776812, 0.04253255803783791, 0.006998462331874892,  /* xyz */
        24.49162041969364, -20.06877945525279, 29.606655999168524,  /* luv */
        24.49162041969364, 35.767443133059956, 124.13126003814016,  /* lch */
        124.13126003814016, 100.00000000000242, 24.49162041969364,  /* hsluv */
        124.13126003814016, 185.314627891622, 24.49162041969364,  /* hpluv */
    },
    {
        "#114411",
        0.06666666666666667, 0.26666666666666666, 0.06666666666666667,  /* rgb */
        0.023993593999413934, 0.042937224237692764, 0.012326567296630522,  /* xyz */
        24.61963135392007, -19.74812741650884, 25.537258964665067,  /* luv */
        24.61963135392007, 32.282195276762614, 127.7150129492401,  /* lch */
        127.7150129492401, 84.7209219338948, 24.61963135392007,  /* hsluv */
        127.7150129492401, 166.38755542404994, 24.61963135392007,  /* hpluv */
    },
    {
        "#114422",
        0.06666666666666667, 0.26666666666666666, 0.13333333333333333,  /* rgb */
        0.025868952137890953, 0.043687367493083586, 0.02220345349260972,  /* xyz */
        24.85481809697528, -19.210494705791824, 18.57183210428942,  /* luv */
        24.85481809697528, 26.719956110577183, 135.9684206876447,  /* lch */
        135.9684206876447, 85.59457028755423, 24.85481809697528,  /* hsluv */
        135.9684206876447, 136.41573832993853, 24.85481809697528,  /* hpluv */
    },
    {
        "#114433",
        0.06666666666666667, 0.26666666666666666, 0.2,  /* rgb */
        0.028956702870348693, 0.0449224677860667, 0.038465607350220865,  /* xyz */
        25.23625258986509, -18.45906630049953, 8.4714180143512,  /* luv */
        25.23625258986509, 20.310146524831165, 155.34819321953802,  /* lch */
        155.34819321953802, 86.83407688708749, 25.23625258986509,  /* hsluv */
        155.34819321953802, 102.1239295817215, 25.23625258986509,  /* hpluv */
    },
    {
        "#114444",
        0.06666666666666667, 0.26666666666666666, 0.26666666666666666,  /* rgb */
        0.03341469811456757, 0.04670566588375427, 0.061944382303107504,  /* xyz */
        25.77481275570785, -17.59878438865295, -3.797613939147628,  /* luv */
        25.77481275570785, 18.00386301850531, 192.17705063006113,  /* lch */
        192.17705063006113, 88.28892231920167, 25.77481275570785,  /* hsluv */
        192.17705063006113, 88.63586911414522, 25.77481275570785,  /* hpluv */
    },
    {
        "#114455",
        0.06666666666666667, 0.26666666666666666, 0.3333333333333333,  /* rgb */
        0.03937711215392957, 0.049090631499499104, 0.0933464295770814,  /* xyz */
        26.474101008682972, -16.741003567166235, -17.154859385792516,  /* luv */
        26.474101008682972, 23.96978099570762, 225.69952529529598,  /* lch */
        225.69952529529598, 89.79685553011214, 26.474101008682972,  /* hsluv */
        225.69952529529598, 114.88998454954921, 26.474101008682972,  /* hpluv */
    },
    {
        "#114466",
        0.06666666666666667, 0.26666666666666666, 0.4,  /* rgb */
        0.04696210792743774, 0.052124629808902416, 0.13329407398422538,  /* xyz */
        27.331692288907973, -15.97050480528823, -30.741954403780753,  /* luv */
        27.331692288907973, 34.64281721078512, 242.54803596438094,  /* lch */
        242.54803596438094, 91.23291854830745, 27.331692288907973,  /* hsluv */
        242.54803596438094, 160.83701568765937, 27.331692288907973,  /* hpluv */
    },
    {
        "#114477",
        0.06666666666666667, 0.26666666666666666, 0.4666666666666667,  /* rgb */
        0.05627612094763966, 0.05585023501698323, 0.1823478758906233,  /* xyz */
        28.34040519972085, -15.335286706255355, -44.032714224271984,  /* luv */
        28.34040519972085, 46.6267191674415, 250.79829031707783,  /* lch */
        250.79829031707783, 92.52485355242467, 28.34040519972085,  /* hsluv */
        250.79829031707783, 208.77001822073458, 28.34040519972085,  /* hpluv */
    },
    {
        "#114488",
        0.06666666666666667, 0.26666666666666666, 0.5333333333333333,  /* rgb */
        0.06741653804958349, 0.06030640185776083, 0.24102073929419546,  /* xyz */
        29.48963599782197, -14.85231827428441, -56.785266792671806,  /* luv */
        29.48963599782197, 58.69546731082016, 255.34250568902095,  /* lch */
        255.34250568902095, 93.64498022927428, 29.48963599782197,  /* hsluv */
        255.34250568902095, 252.56576335245052, 29.48963599782197,  /* hpluv */
    },
    {
        "#114499",
        0.06666666666666667, 0.26666666666666666, 0.6,  /* rgb */
        0.0804735021586562, 0.06552918750138999, 0.30978741693531336,  /* xyz */
        30.76664878793747, -14.518524382462463, -68.94194112782651,  /* luv */
        30.76664878793747, 70.45408999282337, 258.1078153992114,  /* lch */
        258.1078153992114, 94.59435133500654, 30.76664878793747,  /* hsluv */
        258.1078153992114, 290.5797477172579, 30.76664878793747,  /* hpluv */
    },
    {
        "#1144aa",
        0.06666666666666667, 0.26666666666666666, 0.6666666666666666,  /* rgb */
        0.09553119512390874, 0.0715522646874911, 0.38909126655231197,  /* xyz */
        32.15770520906012, -14.320485209080697, -80.54080983470999,  /* luv */
        32.15770520906012, 81.80402401749205, 259.9179407590246,  /* lch */
        259.9179407590246, 95.38877417561329, 32.15770520906012,  /* hsluv */
        259.9179407590246, 322.79659457535263, 32.15770520906012,  /* hpluv */
    },
    {
        "#1144bb",
        0.06666666666666667, 0.26666666666666666, 0.7333333333333333,  /* rgb */
        0.11266878723124539, 0.07840730153042585, 0.4793492516509537,  /* xyz */
        33.648960300975666, -14.240912709988267, -91.65760487025089,  /* luv */
        33.648960300975666, 92.75731844638754, 261.1685229856084,  /* lch */
        261.1685229856084, 96.04953396125359, 33.648960300975666,  /* hsluv */
        261.1685229856084, 349.7968238164962, 33.648960300975666,  /* hpluv */
    },
    {
        "#1144cc",
        0.06666666666666667, 0.26666666666666666, 0.8,  /* rgb */
        0.13196116267496713, 0.08612425170791466, 0.5809557623212238,  /* xyz */
        35.22710458506446, -14.262270250582695, -102.37423400586052,  /* luv */
        35.22710458506446, 103.36293407690854, 262.06888425586715,  /* lch */
        262.06888425586715, 96.59826942511496, 35.22710458506446,  /* hsluv */
        262.06888425586715, 372.3292937392078, 35.22710458506446,  /* hpluv */
    },
    {
        "#1144dd",
        0.06666666666666667, 0.26666666666666666, 0.8666666666666667,  /* rgb */
        0.15347948822560067, 0.09473158192816819, 0.6942856102212298,  /* xyz */
        36.8797734412618, -14.36848418092985, -112.76462596736562,  /* luv */
        36.8797734412618, 113.6763572921718, 262.73849416957313,  /* lch */
        262.73849416957313, 97.0546019825808, 36.8797734412618,  /* hsluv */
        262.73849416957313, 391.13009227787353, 36.8797734412618,  /* hpluv */
    },
    {
        "#1144ee",
        0.06666666666666667, 0.26666666666666666, 0.9333333333333333,  /* rgb */
        0.1772916684917754, 0.10425645403463821, 0.819696426289753,  /* xyz */
        38.59576709983689, -14.545563879916976, -122.89009906516524,  /* luv */
        38.59576709983689, 123.74792877794309, 263.2497415232713,  /* lch */
        263.2497415232713, 97.43532151471936, 38.59576709983689,  /* hsluv */
        263.2497415232713, 406.8530613309675, 38.59576709983689,  /* hpluv */
    },
    {
        "#1144ff",
        0.06666666666666667, 0.26666666666666666, 1.0,  /* rgb */
        0.2034627169016068, 0.11472487339857092, 0.9575306145815349,  /* xyz */
        40.365130684412755, -14.781667239138221, -132.79926547161375,  /* luv */
        40.365130684412755, 133.61939453600573, 263.6486453061263,  /* lch */
        263.6486453061263, 99.99999999999945, 40.365130684412755,  /* hsluv */
        263.6486453061263, 420.05142577192123, 40.365130684412755,  /* hpluv */
    },
    {
        "#115500",
        0.06666666666666667, 0.3333333333333333, 0.0,  /* rgb */
        0.034795185214122774, 0.06615907146653018, 0.010936214569990102,  /* xyz */
        30.916015706081723, -26.737413491809757, 37.54358057946636,  /* luv */
        30.916015706081723, 46.09131938835006, 125.45733088364642,  /* lch */
        125.45733088364642, 100.0000000000024, 30.916015706081723,  /* hsluv */
        125.45733088364642, 189.17988079246103, 30.916015706081723,  /* hpluv */
    },
    {
        "#115511",
        0.06666666666666667, 0.3333333333333333, 0.06666666666666667,  /* rgb */
        0.0358068507137599, 0.06656373766638503, 0.016264319534745733,  /* xyz */
        31.011476278345896, -26.441034220880418, 34.19218055215287,  /* luv */
        31.011476278345896, 43.22306677667366, 127.71501294924028,  /* lch */
        127.71501294924028, 90.05385223480872, 31.011476278345896,  /* hsluv */
        127.71501294924028, 176.86115764368014, 31.011476278345896,  /* hpluv */
    },
    {
        "#115522",
        0.06666666666666667, 0.3333333333333333, 0.13333333333333333,  /* rgb */
        0.037682208852236915, 0.06731388092177584, 0.02614120573072493,  /* xyz */
        31.187416369701474, -25.925914044022, 28.300139682705513,  /* luv */
        31.187416369701474, 38.38034555705121, 132.49297112952854,  /* lch */
        132.49297112952854, 90.43160470344687, 31.187416369701474,  /* hsluv */
        132.49297112952854, 156.15964344428684, 31.187416369701474,  /* hpluv */
    },
    {
        "#115533",
        0.06666666666666667, 0.3333333333333333, 0.2,  /* rgb */
        0.040769959584694655, 0.06854898121475896, 0.042403359588336076,  /* xyz */
        31.4742731349983, -25.16372493864755, 19.40435381409603,  /* luv */
        31.4742731349983, 31.776437807446822, 142.36331886014077,  /* lch */
        142.36331886014077, 90.99473258900896, 31.4742731349983,  /* hsluv */
        142.36331886014077, 128.11170987348544, 31.4742731349983,  /* hpluv */
    },
    {
        "#115544",
        0.06666666666666667, 0.3333333333333333, 0.26666666666666666,  /* rgb */
        0.045227954828913536, 0.07033217931244654, 0.06588213454122271,  /* xyz */
        31.882411442138064, -24.22058254350897, 8.040354833410834,  /* luv */
        31.882411442138064, 25.52026497891596, 161.63570560615477,  /* lch */
        161.63570560615477, 91.69998438630762, 31.882411442138064,  /* hsluv */
        161.63570560615477, 101.57184560775123, 31.882411442138064,  /* hpluv */
    },
    {
        "#115555",
        0.06666666666666667, 0.3333333333333333, 0.3333333333333333,  /* rgb */
        0.05119036886827553, 0.07271714492819137, 0.09728418181519662,  /* xyz */
        32.417637609391285, -23.1868997601056, -5.003464545617711,  /* luv */
        32.417637609391285, 23.720602394215003, 192.1770506300611,  /* lch */
        192.1770506300611, 92.4869346485079, 32.417637609391285,  /* hsluv */
        192.1770506300611, 92.85037826869889, 32.417637609391285,  /* hpluv */
    },
    {
        "#115566",
        0.06666666666666667, 0.3333333333333333, 0.4,  /* rgb */
        0.058775364641783706, 0.07575114323759469, 0.1372318262223406,  /* xyz */
        33.081864606375404, -22.151660151791276, -18.925708599941622,  /* luv */
        33.081864606375404, 29.135519447752458, 220.50957554945026,  /* lch */
        220.50957554945026, 93.29558781930379, 33.081864606375404,  /* hsluv */
        220.50957554945026, 111.75632501093098, 33.081864606375404,  /* hpluv */
    },
    {
        "#115577",
        0.06666666666666667, 0.3333333333333333, 0.4666666666666667,  /* rgb */
        0.06808937766198561, 0.0794767484456755, 0.1862856281287385,  /* xyz */
        33.87367293047748, -21.185073237253587, -33.074442158515396,  /* luv */
        33.87367293047748, 39.27755150419612, 237.3593411412022,  /* lch */
        237.3593411412022, 94.07825373262374, 33.87367293047748,  /* hsluv */
        237.3593411412022, 147.1368463722204, 33.87367293047748,  /* hpluv */
    },
    {
        "#115588",
        0.06666666666666667, 0.3333333333333333, 0.5333333333333333,  /* rgb */
        0.07922979476392944, 0.0839329152864531, 0.24495849153231067,  /* xyz */
        34.78889434972305, -20.33242661510935, -47.007354939256246,  /* luv */
        34.78889434972305, 51.216198516133794, 246.6097252105988,  /* lch */
        246.6097252105988, 94.80380156911127, 34.78889434972305,  /* hsluv */
        246.6097252105988, 186.81254642703834, 34.78889434972305,  /* hpluv */
    },
    {
        "#115599",
        0.06666666666666667, 0.3333333333333333, 0.6,  /* rgb */
        0.09228675887300217, 0.08915570093008225, 0.3137251691734286,  /* xyz */
        35.82122743716814, -19.616216387022863, -60.476391389741444,  /* luv */
        35.82122743716814, 63.5782184467896, 252.02893011417046,  /* lch */
        252.02893011417046, 95.45628317471314, 35.82122743716814,  /* hsluv */
        252.02893011417046, 225.22013661091745, 35.82122743716814,  /* hpluv */
    },
    {
        "#1155aa",
        0.06666666666666667, 0.3333333333333333, 0.6666666666666666,  /* rgb */
        0.1073444518382547, 0.09517877811618336, 0.3930290187904272,  /* xyz */
        36.96285210431738, -19.041991639455375, -73.37838972066706,  /* luv */
        36.96285210431738, 75.80887496589818, 255.45240187699346,  /* lch */
        255.45240187699346, 96.03103000881642, 36.96285210431738,  /* hsluv */
        255.45240187699346, 260.2518968175624, 36.96285210431738,  /* hpluv */
    },
    {
        "#1155bb",
        0.06666666666666667, 0.3333333333333333, 0.7333333333333333,  /* rgb */
        0.12448204394559134, 0.10203381495911812, 0.4832870038890689,  /* xyz */
        38.205001925147585, -18.60454143545472, -85.70230416782732,  /* luv */
        38.205001925147585, 87.69842587925021, 257.7520767868777,  /* lch */
        257.7520767868777, 96.5305142623785, 38.205001925147585,  /* hsluv */
        257.7520767868777, 291.2801561817985, 38.205001925147585,  /* hpluv */
    },
    {
        "#1155cc",
        0.06666666666666667, 0.3333333333333333, 0.8,  /* rgb */
        0.1437744193893131, 0.10975076513660692, 0.584893514559339,  /* xyz */
        39.53846104983455, -18.292845239891637, -97.48723681763344,  /* luv */
        39.53846104983455, 99.1886562531622, 259.3724028360592,  /* lch */
        259.3724028360592, 96.9610449958707, 39.53846104983455,  /* hsluv */
        259.3724028360592, 318.33293391231575, 39.53846104983455,  /* hpluv */
    },
    {
        "#1155dd",
        0.06666666666666667, 0.3333333333333333, 0.8666666666666667,  /* rgb */
        0.16529274493994664, 0.11835809535686045, 0.698223362459345,  /* xyz */
        40.953966897582205, -18.09345483937374, -108.7941902648341,  /* luv */
        40.953966897582205, 110.28848055624569, 260.55761693057894,  /* lch */
        260.55761693057894, 97.330522563257, 40.953966897582205,  /* hsluv */
        260.55761693057894, 341.72244503184095, 40.953966897582205,  /* hpluv */
    },
    {
        "#1155ee",
        0.06666666666666667, 0.3333333333333333, 0.9333333333333333,  /* rgb */
        0.18910492520612138, 0.12788296746333047, 0.8236341785278682,  /* xyz */
        42.442514194968304, -17.992549051743687, -119.68930352312317,  /* luv */
        42.442514194968304, 121.03413237277205, 261.4509047486403,  /* lch */
        261.4509047486403, 97.64708586856726, 42.442514194968304,  /* hsluv */
        261.4509047486403, 361.8645880354474, 42.442514194968304,  /* hpluv */
    },
    {
        "#1155ff",
        0.06666666666666667, 0.3333333333333333, 1.0,  /* rgb */
        0.21527597361595277, 0.13835138682726317, 0.9614683668196501,  /* xyz */
        43.995566921835376, -17.977047465363377, -130.23508100159464,  /* luv */
        43.995566921835376, 131.46996067187305, 262.1408204588659,  /* lch */
        262.1408204588659, 99.99999999999933, 43.995566921835376,  /* hsluv */
        262.1408204588659, 379.1900572698094, 43.995566921835376,  /* hpluv */
    },
    {
        "#116600",
        0.06666666666666667, 0.4, 0.0,  /* rgb */
        0.04982324291996924, 0.09621518687822352, 0.01594556713860545,  /* xyz */
        37.15439733351681, -33.08287219039095, 45.23487557556912,  /* luv */
        37.15439733351681, 56.041684492018646, 126.18015664692672,  /* lch */
        126.18015664692672, 100.00000000000236, 37.15439733351681,  /* hsluv */
        126.18015664692672, 191.39927399318185, 37.15439733351681,  /* hpluv */
    },
    {
        "#116611",
        0.06666666666666667, 0.4, 0.06666666666666667,  /* rgb */
        0.05083490841960636, 0.09661985307807837, 0.021273672103361084,  /* xyz */
        37.228812829730224, -32.82006055051296, 42.44120811240951,  /* luv */
        37.228812829730224, 53.65083895504517, 127.7150129492403,  /* lch */
        127.7150129492403, 93.11217869178577, 37.228812829730224,  /* hsluv */
        127.7150129492403, 182.8675543075664, 37.228812829730224,  /* hpluv */
    },
    {
        "#116622",
        0.06666666666666667, 0.4, 0.13333333333333333,  /* rgb */
        0.052710266558083384, 0.09736999633346918, 0.031150558299340277,  /* xyz */
        37.36621158735072, -32.35400764617737, 37.45130069890151,  /* luv */
        37.36621158735072, 49.4912288674311, 130.82358491852185,  /* lch */
        130.82358491852185, 93.29547888785056, 37.36621158735072,  /* hsluv */
        130.82358491852185, 168.06934026920854, 37.36621158735072,  /* hpluv */
    },
    {
        "#116633",
        0.06666666666666667, 0.4, 0.2,  /* rgb */
        0.055798017290541124, 0.0986050966264523, 0.04741271215695142,  /* xyz */
        37.59090735806413, -31.641588913607606, 29.727021849435992,  /* luv */
        37.59090735806413, 43.4152735453156, 136.78692400540635,  /* lch */
        136.78692400540635, 93.57691681308981, 37.59090735806413,  /* hsluv */
        136.78692400540635, 146.5544667265037, 37.59090735806413,  /* hpluv */
    },
    {
        "#116644",
        0.06666666666666667, 0.4, 0.26666666666666666,  /* rgb */
        0.060256012534760005, 0.10038829472413988, 0.07089148710983806,  /* xyz */
        37.91202956989845, -30.718976447486703, 19.525279846848818,  /* luv */
        37.91202956989845, 36.39906684351954, 147.55956398567415,  /* lch */
        147.55956398567415, 93.94394708577406, 37.91202956989845,  /* hsluv */
        147.55956398567415, 121.82952247732715, 37.91202956989845,  /* hpluv */
    },
    {
        "#116655",
        0.06666666666666667, 0.4, 0.3333333333333333,  /* rgb */
        0.066218426574122, 0.10277326033988471, 0.10229353438381197,  /* xyz */
        38.33562921295834, -29.649088022879866, 7.357681877597089,  /* luv */
        38.33562921295834, 30.548386261804385, 166.0630873978629,  /* lch */
        166.0630873978629, 94.37392521923135, 38.33562921295834,  /* hsluv */
        166.0630873978629, 101.11719272653006, 38.33562921295834,  /* hpluv */
    },
    {
        "#116666",
        0.06666666666666667, 0.4, 0.4,  /* rgb */
        0.07380342234763017, 0.10580725864928803, 0.14224117879095594,  /* xyz */
        38.86513810179163, -28.50576000310982, -6.151213012394513,  /* luv */
        38.86513810179163, 29.161889082820874, 192.17705063006122,  /* lch */
        192.17705063006122, 94.83998427050832, 38.86513810179163,  /* hsluv */
        192.17705063006122, 95.21267461161574, 38.86513810179163,  /* hpluv */
    },
    {
        "#116677",
        0.06666666666666667, 0.4, 0.4666666666666667,  /* rgb */
        0.08311743536783209, 0.10953286385736884, 0.19129498069735384,  /* xyz */
        39.50168098834231, -27.359238551870874, -20.39311698092933,  /* luv */
        39.50168098834231, 34.12341064923091, 216.70022758997786,  /* lch */
        216.70022758997786, 95.31641060376147, 39.50168098834231,  /* hsluv */
        216.70022758997786, 109.6165632485784, 39.50168098834231,  /* hpluv */
    },
    {
        "#116688",
        0.06666666666666667, 0.4, 0.5333333333333333,  /* rgb */
        0.09425785246977592, 0.11398903069814643, 0.249967844100926,  /* xyz */
        40.24436389929537, -26.26657762672555, -34.86207268843081,  /* luv */
        40.24436389929537, 43.64971033528438, 233.00406581163003,  /* lch */
        233.00406581163003, 95.78220553249189, 40.24436389929537,  /* hsluv */
        233.00406581163003, 137.6307971193621, 40.24436389929537,  /* hpluv */
    },
    {
        "#116699",
        0.06666666666666667, 0.4, 0.6,  /* rgb */
        0.10731481657884863, 0.11921181634177559, 0.3187345217420439,  /* xyz */
        41.09057593654244, -25.267811847463722, -49.189985418125,  /* luv */
        41.09057593654244, 55.30024395058469, 242.81143298809,  /* lch */
        242.81143298809, 96.22251629445482, 41.09057593654244,  /* hsluv */
        242.81143298809, 170.77494147502304, 41.09057593654244,  /* hpluv */
    },
    {
        "#1166aa",
        0.06666666666666667, 0.4, 0.6666666666666666,  /* rgb */
        0.12237250954410117, 0.1252348935278767, 0.3980383713590425,  /* xyz */
        42.036307466096176, -24.386594633286766, -63.14312577464826,  /* luv */
        42.036307466096176, 67.6887016451143, 248.88287109250717,  /* lch */
        248.88287109250717, 96.62842047353479, 42.036307466096176,  /* hsluv */
        248.88287109250717, 204.3294426797032, 42.036307466096176,  /* hpluv */
    },
    {
        "#1166bb",
        0.06666666666666667, 0.4, 0.7333333333333333,  /* rgb */
        0.13951010165143782, 0.13208993037081146, 0.48829635645768427,  /* xyz */
        43.076473081437975, -23.63325209730973, -76.59749010303764,  /* luv */
        43.076473081437975, 80.16050208662584, 252.85300690706177,  /* lch */
        252.85300690706177, 96.9958197331145, 43.076473081437975,  /* hsluv */
        252.85300690706177, 236.13459452455018, 43.076473081437975,  /* hpluv */
    },
    {
        "#1166cc",
        0.06666666666666667, 0.4, 0.8,  /* rgb */
        0.15880247709515954, 0.13980688054830026, 0.5899028671279544,  /* xyz */
        44.20522324008613, -23.008531750755072, -89.50799640338153,  /* luv */
        44.20522324008613, 92.41793090885157, 255.58391634480705,  /* lch */
        255.58391634480705, 97.32407702359922, 44.20522324008613,  /* hsluv */
        255.58391634480705, 265.2906718005289, 44.20522324008613,  /* hpluv */
    },
    {
        "#1166dd",
        0.06666666666666667, 0.4, 0.8666666666666667,  /* rgb */
        0.1803208026457931, 0.1484142107685538, 0.7032327150279604,  /* xyz */
        45.416229651326645, -22.507022318245486, -101.88039000659978,  /* luv */
        45.416229651326645, 104.33685792437338, 257.5425235275642,  /* lch */
        257.5425235275642, 97.6147741074162, 45.416229651326645,  /* hsluv */
        257.5425235275642, 291.5184211423942, 45.416229651326645,  /* hpluv */
    },
    {
        "#1166ee",
        0.06666666666666667, 0.4, 0.9333333333333333,  /* rgb */
        0.20413298291196785, 0.1579390828750238, 0.8286435310964836,  /* xyz */
        46.70293356502287, -22.119828361019472, -113.74943637429719,  /* luv */
        46.70293356502287, 115.8802014245369, 258.9955455263239,  /* lch */
        258.9955455263239, 97.87074228899657, 46.70293356502287,  /* hsluv */
        258.9955455263239, 314.85051430707733, 46.70293356502287,  /* hpluv */
    },
    {
        "#1166ff",
        0.06666666666666667, 0.4, 1.0,  /* rgb */
        0.23030403132179922, 0.1684075022389565, 0.9664777193882654,  /* xyz */
        48.058751113839435, -21.836456275740957, -125.16374318232226,  /* luv */
        48.058751113839435, 127.05429323754736, 260.10360449550666,  /* lch */
        260.10360449550666, 99.99999999999922, 48.058751113839435,  /* hsluv */
        260.10360449550666, 335.4719324940383, 48.058751113839435,  /* hpluv */
    },
    {
        "#117700",
        0.06666666666666667, 0.4666666666666667, 0.0,  /* rgb */
        0.06827698097338687, 0.1331226629850593, 0.022096813156411155,  /* xyz */
        43.230034841823304, -39.16791750071817, 52.7139845365981,  /* luv */
        43.230034841823304, 65.67259646966737, 126.61334824354498,  /* lch */
        126.61334824354498, 100.00000000000236, 43.230034841823304,  /* hsluv */
        126.61334824354498, 192.76932564638344, 43.230034841823304,  /* hpluv */
    },
    {
        "#117711",
        0.06666666666666667, 0.4666666666666667, 0.06666666666666667,  /* rgb */
        0.06928864647302399, 0.13352732918491414, 0.027424918121166784,  /* xyz */
        43.289989941732955, -38.93723193789384, 50.35161837845777,  /* luv */
        43.289989941732955, 63.650557769081544, 127.7150129492404,  /* lch */
        127.7150129492404, 95.00006169914843, 43.289989941732955,  /* hsluv */
        127.7150129492404, 186.5752599291696, 43.289989941732955,  /* hpluv */
    },
    {
        "#117722",
        0.06666666666666667, 0.4666666666666667, 0.13333333333333333,  /* rgb */
        0.07116400461150102, 0.13427747244030497, 0.037301804317145984,  /* xyz */
        43.40081109495143, -38.52309871581513, 46.08983641488876,  /* luv */
        43.40081109495143, 60.06914478681749, 129.88976567323382,  /* lch */
        129.88976567323382, 95.09736059060067, 43.40081109495143,  /* hsluv */
        129.88976567323382, 175.62766587250084, 43.40081109495143,  /* hpluv */
    },
    {
        "#117733",
        0.06666666666666667, 0.4666666666666667, 0.2,  /* rgb */
        0.07425175534395875, 0.13551257273328807, 0.05356395817475713,  /* xyz */
        43.58238078882553, -37.877132409458476, 39.38547707153275,  /* luv */
        43.58238078882553, 54.64332496944052, 133.8815960626058,  /* lch */
        133.8815960626058, 95.24956751594203, 43.58238078882553,  /* hsluv */
        133.8815960626058, 159.0982832067957, 43.58238078882553,  /* hpluv */
    },
    {
        "#117744",
        0.06666666666666667, 0.4666666666666667, 0.26666666666666666,  /* rgb */
        0.07870975058817763, 0.13729577083097566, 0.07704273312764376,  /* xyz */
        43.8425891980029, -37.01613524683321, 30.330653311005605,  /* luv */
        43.8425891980029, 47.85543646111968, 140.6691499054055,  /* lch */
        140.6691499054055, 95.45336190155854, 43.8425891980029,  /* hsluv */
        140.6691499054055, 138.50785824994688, 43.8425891980029,  /* hpluv */
    },
    {
        "#117755",
        0.06666666666666667, 0.4666666666666667, 0.3333333333333333,  /* rgb */
        0.08467216462753963, 0.1396807364467205, 0.10844478040161767,  /* xyz */
        44.18711059062651, -35.980549122383884, 19.233940788220995,  /* luv */
        44.18711059062651, 40.798828333581724, 151.87260146680626,  /* lch */
        151.87260146680626, 95.70008051675394, 44.18711059062651,  /* hsluv */
        151.87260146680626, 117.1632510032723, 44.18711059062651,  /* hpluv */
    },
    {
        "#117766",
        0.06666666666666667, 0.4666666666666667, 0.4,  /* rgb */
        0.0922571604010478, 0.14271473475612378, 0.14839242480876164,  /* xyz */
        44.61976672409209, -34.825411001313746, 6.540718509909258,  /* luv */
        44.61976672409209, 35.43430893973092, 169.36293602312512,  /* lch */
        169.36293602312512, 95.97774141934345, 44.61976672409209,  /* hsluv */
        169.36293602312512, 100.77109980045739, 44.61976672409209,  /* hpluv */
    },
    {
        "#117777",
        0.06666666666666667, 0.4666666666666667, 0.4666666666666667,  /* rgb */
        0.10157117342124972, 0.1464403399642046, 0.19744622671515955,  /* xyz */
        45.142740248677214, -33.61046149862746, -7.25274850066749,  /* luv */
        45.142740248677214, 34.384087641882445, 192.17705063006122,  /* lch */
        192.17705063006122, 96.27324752199644, 45.142740248677214,  /* hsluv */
        192.17705063006122, 96.65157012226335, 45.142740248677214,  /* hpluv */
    },
    {
        "#117788",
        0.06666666666666667, 0.4666666666666667, 0.5333333333333333,  /* rgb */
        0.11271159052319354, 0.1508965068049822, 0.2561190901187317,  /* xyz */
        45.75674314388565, -32.39164016812707, -21.673083345115412,  /* luv */
        45.75674314388565, 38.97359227048159, 213.78628123605418,  /* lch */
        213.78628123605418, 96.57427973718032, 45.75674314388565,  /* hsluv */
        213.78628123605418, 108.08232019233517, 45.75674314388565,  /* hpluv */
    },
    {
        "#117799",
        0.06666666666666667, 0.4666666666666667, 0.6,  /* rgb */
        0.12576855463226627, 0.15611929244861136, 0.3248857677598496,  /* xyz */
        46.46117944278912, -31.215454804421377, -36.31897478500838,  /* luv */
        46.46117944278912, 47.890213489615476, 229.32157989342676,  /* lch */
        229.32157989342676, 96.8705519561321, 46.46117944278912,  /* hsluv */
        229.32157989342676, 130.7964236204937, 46.46117944278912,  /* hpluv */
    },
    {
        "#1177aa",
        0.06666666666666667, 0.4666666666666667, 0.6666666666666666,  /* rgb */
        0.1408262475975188, 0.16214236963471246, 0.4041896173768482,  /* xyz */
        47.25431560430783, -30.116506356749586, -50.88343896666272,  /* luv */
        47.25431560430783, 59.12806707656042, 239.3798785544049,  /* lch */
        239.3798785544049, 97.15436624974035, 47.25431560430783,  /* hsluv */
        239.3798785544049, 158.7784400832255, 47.25431560430783,  /* hpluv */
    },
    {
        "#1177bb",
        0.06666666666666667, 0.4666666666666667, 0.7333333333333333,  /* rgb */
        0.15796383970485545, 0.16899740647764722, 0.49444760247548997,  /* xyz */
        48.13345976517749, -29.117542912213175, -65.15452737259378,  /* luv */
        48.13345976517749, 71.36486350011921, 245.92014354634622,  /* lch */
        245.92014354634622, 97.42060748412705, 48.13345976517749,  /* hsluv */
        245.92014354634622, 188.1380709359626, 48.13345976517749,  /* hpluv */
    },
    {
        "#1177cc",
        0.06666666666666667, 0.4666666666666667, 0.8,  /* rgb */
        0.1772562151485772, 0.17671435665513602, 0.5960541131457602,  /* xyz */
        49.09514527201715, -28.23106169200006, -79.00283443298638,  /* luv */
        49.09514527201715, 83.89541520669275, 250.33603743689312,  /* lch */
        250.33603743689312, 97.66639486917306, 49.09514527201715,  /* hsluv */
        250.33603743689312, 216.83980339157776, 49.09514527201715,  /* hpluv */
    },
    {
        "#1177dd",
        0.06666666666666667, 0.4666666666666667, 0.8666666666666667,  /* rgb */
        0.19877454069921074, 0.18532168687538955, 0.7093839610457662,  /* xyz */
        50.13531160483447, -27.46155891131168, -92.36345192204915,  /* luv */
        50.13531160483447, 96.3594544857749, 253.44170078877806,  /* lch */
        253.44170078877806, 97.89058988181463, 50.13531160483447,  /* hsluv */
        253.44170078877806, 243.8877239152795, 50.13531160483447,  /* hpluv */
    },
    {
        "#1177ee",
        0.06666666666666667, 0.4666666666666667, 0.9333333333333333,  /* rgb */
        0.22258672096538545, 0.1948465589818596, 0.8347947771142894,  /* xyz */
        51.24947569164516, -26.807804975219845, -105.21764417238556,  /* luv */
        51.24947569164516, 108.57905439253081, 255.70605230127092,  /* lch */
        255.70605230127092, 98.0932983984315, 51.24947569164516,  /* hsluv */
        255.70605230127092, 268.84128026737557, 51.24947569164516,  /* hpluv */
    },
    {
        "#1177ff",
        0.06666666666666667, 0.4666666666666667, 1.0,  /* rgb */
        0.24875776937521688, 0.2053149783457923, 0.9726289654060711,  /* xyz */
        52.432887787324674, -26.264811492738595, -117.57705611280936,  /* luv */
        52.432887787324674, 120.47491210581485, 257.40778545437786,  /* lch */
        257.40778545437786, 99.99999999999909, 52.432887787324674,  /* hsluv */
        257.40778545437786, 291.5628368125458, 52.432887787324674,  /* hpluv */
    },
    {
        "#118800",
        0.06666666666666667, 0.5333333333333333, 0.0,  /* rgb */
        0.09034935069835733, 0.17726740243500083, 0.0294542697314011,  /* xyz */
        49.162981874481716, -45.042087199494745, 60.0091756264985,  /* luv */
        49.162981874481716, 75.03259810681507, 126.89140430291064,  /* lch */
        126.89140430291064, 100.00000000000249, 49.162981874481716,  /* hsluv */
        126.89140430291064, 193.66497988112926, 49.162981874481716,  /* hpluv */
    },
    {
        "#118811",
        0.06666666666666667, 0.5333333333333333, 0.06666666666666667,  /* rgb */
        0.09136101619799444, 0.17767206863485568, 0.034782374696156734,  /* xyz */
        49.2125288978643, -44.839450933622366, 57.98406330759469,  /* luv */
        49.2125288978643, 73.29889465529392, 127.7150129492404,  /* lch */
        127.7150129492404, 96.23452371899283, 49.2125288978643,  /* hsluv */
        127.7150129492404, 188.99968016749057, 49.2125288978643,  /* hpluv */
    },
    {
        "#118822",
        0.06666666666666667, 0.5333333333333333, 0.13333333333333333,  /* rgb */
        0.09323637433647147, 0.1784222118902465, 0.04465926089213593,  /* xyz */
        49.30417724393203, -44.47275996390143, 54.306527936635256,  /* luv */
        49.30417724393203, 70.1927728141533, 129.31476933948187,  /* lch */
        129.31476933948187, 96.28997480678169, 49.30417724393203,  /* hsluv */
        129.31476933948187, 180.6541776618526, 49.30417724393203,  /* hpluv */
    },
    {
        "#118833",
        0.06666666666666667, 0.5333333333333333, 0.2,  /* rgb */
        0.0963241250689292, 0.1796573121832296, 0.06092141474974708,  /* xyz */
        49.45451691236977, -43.89315727465989, 48.45819380643098,  /* luv */
        49.45451691236977, 65.38199907099548, 132.17010523464646,  /* lch */
        132.17010523464646, 96.3778002926358, 49.45451691236977,  /* hsluv */
        132.17010523464646, 167.76121303642998, 49.45451691236977,  /* hpluv */
    },
    {
        "#118844",
        0.06666666666666667, 0.5333333333333333, 0.26666666666666666,  /* rgb */
        0.10078212031314808, 0.1814405102809172, 0.08440018970263372,  /* xyz */
        49.6703617695526, -43.105638892453506, 40.43689506897269,  /* luv */
        49.6703617695526, 59.10362583755508, 136.82967609287007,  /* lch */
        136.82967609287007, 96.49750696278294, 49.6703617695526,  /* hsluv */
        136.82967609287007, 150.9927614306973, 49.6703617695526,  /* hpluv */
    },
    {
        "#118855",
        0.06666666666666667, 0.5333333333333333, 0.3333333333333333,  /* rgb */
        0.10674453435251008, 0.18382547589666204, 0.11580223697660762,  /* xyz */
        49.956847367609114, -42.13464224684138, 30.414821940801833,  /* luv */
        49.956847367609114, 51.96527177798641, 144.17642767851387,  /* lch */
        144.17642767851387, 96.64576621918997, 49.956847367609114,  /* hsluv */
        144.17642767851387, 131.9950077990118, 49.956847367609114,  /* hpluv */
    },
    {
        "#118866",
        0.06666666666666667, 0.5333333333333333, 0.4,  /* rgb */
        0.11432953012601825, 0.18685947420606533, 0.1557498813837516,  /* xyz */
        50.31773678854289, -41.01891710615036, 18.693409539482143,  /* luv */
        50.31773678854289, 45.07765655812241, 155.49998607369966,  /* lch */
        155.49998607369966, 96.81715906288825, 50.31773678854289,  /* hsluv */
        155.49998607369966, 113.67882025976219, 50.31773678854289,  /* hpluv */
    },
    {
        "#118877",
        0.06666666666666667, 0.5333333333333333, 0.4666666666666667,  /* rgb */
        0.12364354314622017, 0.19058507941414615, 0.2048036832901495,  /* xyz */
        50.75558739706024, -39.805280619102525, 5.649745350512833,  /* luv */
        50.75558739706024, 40.204228480237504, 171.92170671723616,  /* lch */
        171.92170671723616, 97.00507629907143, 50.75558739706024,  /* hsluv */
        171.92170671723616, 100.51414914172912, 50.75558739706024,  /* hpluv */
    },
    {
        "#118888",
        0.06666666666666667, 0.5333333333333333, 0.5333333333333333,  /* rgb */
        0.134783960248164, 0.19504124625492375, 0.26347654669372167,  /* xyz */
        51.27186640237811, -38.54233683579548, -8.316990104686637,  /* luv */
        51.27186640237811, 39.429482030143035, 192.17705063006116,  /* lch */
        192.17705063006116, 97.2026219422035, 51.27186640237811,  /* hsluv */
        192.17705063006116, 97.58459668214911, 51.27186640237811,  /* hpluv */
    },
    {
        "#118899",
        0.06666666666666667, 0.5333333333333333, 0.6,  /* rgb */
        0.14784092435723672, 0.2002640318985529, 0.33224322433483955,  /* xyz */
        51.86705037929299, -37.27527057829406, -22.829944814568886,  /* luv */
        51.86705037929299, 43.71100750293107, 211.4861745131193,  /* lch */
        211.4861745131193, 97.4033619208845, 51.86705037929299,  /* hsluv */
        211.4861745131193, 106.93960912970239, 51.86705037929299,  /* hpluv */
    },
    {
        "#1188aa",
        0.06666666666666667, 0.5333333333333333, 0.6666666666666666,  /* rgb */
        0.16289861732248925, 0.206287109084654, 0.41154707395183815,  /* xyz */
        52.54072371454794, -36.04236860737641, -37.56448568901505,  /* luv */
        52.54072371454794, 52.059033028958666, 226.1846513159617,  /* lch */
        226.1846513159617, 97.6018250350267, 52.54072371454794,  /* hsluv */
        226.1846513159617, 125.73013241551254, 52.54072371454794,  /* hpluv */
    },
    {
        "#1188bb",
        0.06666666666666667, 0.5333333333333333, 0.7333333333333333,  /* rgb */
        0.1800362094298259, 0.21314214592758876, 0.5018050590504799,  /* xyz */
        53.291681511344905, -34.873360959806256, -52.26281276233816,  /* luv */
        53.291681511344905, 62.82955437104544, 236.2860421099278,  /* lch */
        236.2860421099278, 97.79374308757572, 53.291681511344905,  /* hsluv */
        236.2860421099278, 149.60423309734304, 53.291681511344905,  /* hpluv */
    },
    {
        "#1188cc",
        0.06666666666666667, 0.5333333333333333, 0.8,  /* rgb */
        0.19932858487354765, 0.22085909610507756, 0.60341156972075,  /* xyz */
        54.118037559705755, -33.78926334984578, -66.73598436918874,  /* luv */
        54.118037559705755, 74.80244599911046, 243.14633614982228,  /* lch */
        243.14633614982228, 97.97607599901748, 54.118037559705755,  /* hsluv */
        243.14633614982228, 175.39333502285888, 54.118037559705755,  /* hpluv */
    },
    {
        "#1188dd",
        0.06666666666666667, 0.5333333333333333, 0.8666666666666667,  /* rgb */
        0.2208469104241812, 0.2294664263253311, 0.716741417620756,  /* xyz */
        55.01733538124083, -32.80322158726935, -80.85753668233961,  /* luv */
        55.01733538124083, 87.25819494373803, 247.91801983145498,  /* lch */
        247.91801983145498, 98.14689341623115, 55.01733538124083,  /* hsluv */
        247.91801983145498, 201.25468478524868, 55.01733538124083,  /* hpluv */
    },
    {
        "#1188ee",
        0.06666666666666667, 0.5333333333333333, 0.9333333333333333,  /* rgb */
        0.2446590906903559, 0.23899129843180114, 0.8421522336892793,  /* xyz */
        55.986659163847136, -31.921869990719685, -94.55278054839307,  /* luv */
        55.986659163847136, 99.79596230878776, 251.3448546547046,  /* lch */
        251.3448546547046, 98.3051827042817, 55.986659163847136,  /* hsluv */
        251.3448546547046, 226.18705383796026, 55.986659163847136,  /* hpluv */
    },
    {
        "#1188ff",
        0.06666666666666667, 0.5333333333333333, 1.0,  /* rgb */
        0.27083013910018733, 0.24945971779573384, 0.9799864219810611,  /* xyz */
        57.02274112709941, -31.14682937583588, -107.78690155264914,  /* luv */
        57.02274112709941, 112.19688554718402, 253.88246498848565,  /* lch */
        253.88246498848565, 99.99999999999889, 57.02274112709941,  /* hsluv */
        253.88246498848565, 249.67326335993798, 57.02274112709941,  /* hpluv */
    },
    {
        "#119900",
        0.06666666666666667, 0.6, 0.0,  /* rgb */
        0.11621895115082481, 0.22900660333993653, 0.03807746988222335,  /* xyz */
        54.96986694108247, -50.74225173329378, 67.1433772639973,  /* luv */
        54.96986694108247, 84.16061561906747, 127.07942854498893,  /* lch */
        127.07942854498893, 100.00000000000237, 54.96986694108247,  /* hsluv */
        127.07942854498893, 194.27796440509266, 54.96986694108247,  /* hpluv */
    },
    {
        "#119911",
        0.06666666666666667, 0.6, 0.06666666666666667,  /* rgb */
        0.11723061665046193, 0.22941126953979138, 0.04340557484697898,  /* xyz */
        55.01164478575565, -50.563404981135136, 65.3859852078442,  /* luv */
        55.01164478575565, 82.6558224500047, 127.7150129492404,  /* lch */
        127.7150129492404, 97.07960041337951, 55.01164478575565,  /* hsluv */
        127.7150129492404, 190.65936755184825, 55.01164478575565,  /* hpluv */
    },
    {
        "#119922",
        0.06666666666666667, 0.6, 0.13333333333333333,  /* rgb */
        0.11910597478893896, 0.2301614127951822, 0.05328246104295818,  /* xyz */
        55.088960009600285, -50.23799862791894, 62.18005790919382,  /* luv */
        55.088960009600285, 79.93882728517777, 128.93626655416818,  /* lch */
        128.93626655416818, 97.11306554192869, 55.088960009600285,  /* hsluv */
        128.93626655416818, 184.13338016681914, 55.088960009600285,  /* hpluv */
    },
    {
        "#119933",
        0.06666666666666667, 0.6, 0.2,  /* rgb */
        0.12219372552139669, 0.2313965130881653, 0.06954461490056932,  /* xyz */
        55.21589325677182, -49.7189430335536, 57.04298955477942,  /* luv */
        55.21589325677182, 75.66951799582459, 131.07556270117615,  /* lch */
        131.07556270117615, 97.1665253707361, 55.21589325677182,  /* hsluv */
        131.07556270117615, 173.89864247291885, 55.21589325677182,  /* hpluv */
    },
    {
        "#119944",
        0.06666666666666667, 0.6, 0.26666666666666666,  /* rgb */
        0.12665172076561557, 0.2331797111858529, 0.09302338985345596,  /* xyz */
        55.398361036949, -49.00422537311026, 49.91983586699353,  /* luv */
        55.398361036949, 69.95287068738607, 134.46970314062347,  /* lch */
        134.46970314062347, 97.24030708896902, 55.398361036949,  /* hsluv */
        134.46970314062347, 160.23151970769845, 55.398361036949,  /* hpluv */
    },
    {
        "#119955",
        0.06666666666666667, 0.6, 0.3333333333333333,  /* rgb */
        0.13261413480497758, 0.23556467680159773, 0.12442543712742987,  /* xyz */
        55.64095698809075, -48.10746562046712, 40.89422716640022,  /* luv */
        55.64095698809075, 63.14005118751149, 139.63347119458018,  /* lch */
        139.63347119458018, 97.33318343287016, 55.64095698809075,  /* hsluv */
        139.63347119458018, 143.99574701685717, 55.64095698809075,  /* hpluv */
    },
    {
        "#119966",
        0.06666666666666667, 0.6, 0.4,  /* rgb */
        0.14019913057848574, 0.23859867511100102, 0.16437308153457383,  /* xyz */
        55.9472168173363, -47.0549257965888, 30.16178073201251,  /* luv */
        55.9472168173363, 55.89185145124895, 147.34049680706406,  /* lch */
        147.34049680706406, 97.4426708460479, 55.9472168173363,  /* hsluv */
        147.34049680706406, 126.76791164907155, 55.9472168173363,  /* hpluv */
    },
    {
        "#119977",
        0.06666666666666667, 0.6, 0.4666666666666667,  /* rgb */
        0.14951314359868767, 0.24232428031908185, 0.21342688344097174,  /* xyz */
        56.319758368673476, -45.88166086465393, 17.9971796894826,  /* luv */
        56.319758368673476, 49.28514259363202, 158.58229928491605,  /* lch */
        158.58229928491605, 97.56540872377704, 56.319758368673476,  /* hsluv */
        158.58229928491605, 111.04386285399947, 56.319758368673476,  /* hpluv */
    },
    {
        "#119988",
        0.06666666666666667, 0.6, 0.5333333333333333,  /* rgb */
        0.16065356070063147, 0.24678044715985945, 0.2720997468445439,  /* xyz */
        56.760371000151295, -44.627222331845445, 4.717858626136081,  /* luv */
        56.760371000151295, 44.875908493000686, 173.96527373508107,  /* lch */
        173.96527373508107, 97.69758116741536, 56.760371000151295,  /* hsluv */
        173.96527373508107, 100.32458105467516, 56.760371000151295,  /* hpluv */
    },
    {
        "#119999",
        0.06666666666666667, 0.6, 0.6,  /* rgb */
        0.1737105248097042, 0.2520032328034886, 0.34086642448566185,  /* xyz */
        57.27008464731068, -43.33156965758352, -9.350451105184584,  /* luv */
        57.27008464731068, 44.32895064019067, 192.1770506300611,  /* lch */
        192.1770506300611, 97.83531789001519, 57.27008464731068,  /* hsluv */
        192.1770506300611, 98.21977891958244, 57.27008464731068,  /* hpluv */
    },
    {
        "#1199aa",
        0.06666666666666667, 0.6, 0.6666666666666666,  /* rgb */
        0.18876821777495673, 0.2580263099895897, 0.4201702741026604,  /* xyz */
        57.84923255062682, -42.03174984112964, -23.901745482103838,  /* luv */
        57.84923255062682, 48.35247079311017, 209.62512772211176,  /* lch */
        209.62512772211176, 97.97501982418055, 57.84923255062682,  /* hsluv */
        209.62512772211176, 106.06214254180742, 57.84923255062682,  /* hpluv */
    },
    {
        "#1199bb",
        0.06666666666666667, 0.6, 0.7333333333333333,  /* rgb */
        0.2059058098822934, 0.26488134683252446, 0.5104282592013022,  /* xyz */
        58.497514127855126, -40.759649113707155, -38.66885511520378,  /* luv */
        58.497514127855126, 56.18388872081702, 223.49215320981136,  /* lch */
        223.49215320981136, 98.11357988765957, 58.497514127855126,  /* hsluv */
        223.49215320981136, 121.8747424026255, 58.497514127855126,  /* hpluv */
    },
    {
        "#1199cc",
        0.06666666666666667, 0.6, 0.8,  /* rgb */
        0.22519818532601513, 0.27259829701001326, 0.6120347698715723,  /* xyz */
        59.21406054340285, -39.540845723906614, -53.43341110796253,  /* luv */
        59.21406054340285, 66.47261017286982, 233.4984746932434,  /* lch */
        233.4984746932434, 98.24849614881545, 59.21406054340285,  /* hsluv */
        233.4984746932434, 142.44828194389405, 59.21406054340285,  /* hpluv */
    },
    {
        "#1199dd",
        0.06666666666666667, 0.6, 0.8666666666666667,  /* rgb */
        0.24671651087664867, 0.2812056272302668, 0.7253646177715783,  /* xyz */
        59.997503306786555, -38.394391866561364, -68.02810189090602,  /* luv */
        59.997503306786555, 78.11499199054279, 240.56004448823626,  /* lch */
        240.56004448823626, 98.37789422468923, 59.997503306786555,  /* hsluv */
        240.56004448823626, 165.21160136193552, 59.997503306786555,  /* hpluv */
    },
    {
        "#1199ee",
        0.06666666666666667, 0.6, 0.9333333333333333,  /* rgb */
        0.2705286911428234, 0.29073049933673684, 0.8507754338401016,  /* xyz */
        60.84604497358147, -37.333256663507086, -82.33344502390841,  /* luv */
        60.84604497358147, 90.4022578402124, 245.60857134482,  /* lch */
        245.60857134482, 98.50048511290298, 60.84604497358147,  /* hsluv */
        245.60857134482, 188.53251011207607, 60.84604497358147,  /* hpluv */
    },
    {
        "#1199ff",
        0.06666666666666667, 0.6, 1.0,  /* rgb */
        0.29669973955265483, 0.3011989187006695, 0.9886096221318834,  /* xyz */
        61.75753037717219, -36.3651553748586, -96.27134977338952,  /* luv */
        61.75753037717219, 102.91062779240983, 249.30664361749808,  /* lch */
        249.30664361749808, 99.99999999999862, 61.75753037717219,  /* hsluv */
        249.30664361749808, 211.45094646682003, 61.75753037717219,  /* hpluv */
    },
    {
        "#11aa00",
        0.06666666666666667, 0.6666666666666666, 0.0,  /* rgb */
        0.14605257078039413, 0.28867384259907597, 0.04802200975874617,  /* xyz */
        60.66441045213509, -56.29589548571292, 74.13515068543462,  /* luv */
        60.66441045213509, 93.0873160838275, 127.2118906676988,  /* lch */
        127.2118906676988, 100.00000000000244, 60.66441045213509,  /* hsluv */
        127.2118906676988, 194.71340610375353, 60.66441045213509,  /* hpluv */
    },
    {
        "#11aa11",
        0.06666666666666667, 0.6666666666666666, 0.06666666666666667,  /* rgb */
        0.14706423628003126, 0.2890785087989308, 0.0533501147235018,  /* xyz */
        60.70021673357864, -56.137076281322955, 72.5935692169401,  /* luv */
        60.70021673357864, 91.76708355979144, 127.71501294924037,  /* lch */
        127.71501294924037, 97.68004397073548, 60.70021673357864,  /* hsluv */
        127.71501294924037, 191.8386079731993, 60.70021673357864,  /* hpluv */
    },
    {
        "#11aa22",
        0.06666666666666667, 0.6666666666666666, 0.13333333333333333,  /* rgb */
        0.14893959441850826, 0.2898286520543216, 0.063227000919481,  /* xyz */
        60.76650374835117, -55.846993582141884, 69.77216554885062,  /* luv */
        60.76650374835117, 89.37025107685452, 128.6744569519864,  /* lch */
        128.6744569519864, 97.70121255748332, 60.76650374835117,  /* hsluv */
        128.6744569519864, 186.62424122707677, 60.76650374835117,  /* hpluv */
    },
    {
        "#11aa33",
        0.06666666666666667, 0.6666666666666666, 0.2,  /* rgb */
        0.152027345150966, 0.29106375234730475, 0.07948915477709215,  /* xyz */
        60.87539563474931, -55.38126882927746, 65.22653626362123,  /* luv */
        60.87539563474931, 85.56626654289758, 130.33326794825732,  /* lch */
        130.33326794825732, 97.73523714435949, 60.87539563474931,  /* hsluv */
        130.33326794825732, 178.36108800211815, 60.87539563474931,  /* hpluv */
    },
    {
        "#11aa44",
        0.06666666666666667, 0.6666666666666666, 0.26666666666666666,  /* rgb */
        0.15648534039518489, 0.2928469504449923, 0.10296792972997879,  /* xyz */
        61.03206813832459, -54.73381700145054, 58.87312604649242,  /* luv */
        61.03206813832459, 80.38554406132026, 132.91333111085615,  /* lch */
        132.91333111085615, 97.78262110102784, 61.03206813832459,  /* hsluv */
        132.91333111085615, 167.13184029835867, 61.03206813832459,  /* hpluv */
    },
    {
        "#11aa55",
        0.06666666666666667, 0.6666666666666666, 0.3333333333333333,  /* rgb */
        0.1624477544345469, 0.2952319160607372, 0.1343699770039527,  /* xyz */
        61.24062114791262, -53.91109828971116, 50.738866530473906,  /* luv */
        61.24062114791262, 74.03268937165625, 136.7362629108115,  /* lch */
        136.7362629108115, 97.84298053833234, 61.24062114791262,  /* hsluv */
        136.7362629108115, 153.3992604091805, 61.24062114791262,  /* hpluv */
    },
    {
        "#11aa66",
        0.06666666666666667, 0.6666666666666666, 0.4,  /* rgb */
        0.17003275020805506, 0.2982659143701405, 0.17431762141109663,  /* xyz */
        61.504311805982724, -52.930280292786094, 40.944504442006675,  /* luv */
        61.504311805982724, 66.91836082776089, 142.2760624002185,  /* lch */
        142.2760624002185, 97.91517567613982, 61.504311805982724,  /* hsluv */
        142.2760624002185, 138.06355678531622, 61.504311805982724,  /* hpluv */
    },
    {
        "#11aa77",
        0.06666666666666667, 0.6666666666666666, 0.4666666666666667,  /* rgb */
        0.179346763228257, 0.3019915195782213, 0.22337142331749454,  /* xyz */
        61.825676599682865, -51.81685855605053, 29.684173192351867,  /* luv */
        61.825676599682865, 59.71714133087156, 150.1930242373102,  /* lch */
        150.1930242373102, 97.99747810590276, 61.825676599682865,  /* hsluv */
        150.1930242373102, 122.56584352860227, 61.825676599682865,  /* hpluv */
    },
    {
        "#11aa88",
        0.06666666666666667, 0.6666666666666666, 0.5333333333333333,  /* rgb */
        0.1904871803302008, 0.3064476864189989, 0.28204428672106674,  /* xyz */
        62.2066058842594, -50.60180857798202, 17.201403018159084,  /* luv */
        62.2066058842594, 53.44559193381497, 161.22522678266847,  /* lch */
        161.22522678266847, 98.08776983439887, 62.2066058842594,  /* hsluv */
        161.22522678266847, 109.02214235357108, 62.2066058842594,  /* hpluv */
    },
    {
        "#11aa99",
        0.06666666666666667, 0.6666666666666666, 0.6,  /* rgb */
        0.20354414443927352, 0.31167047206262805, 0.3508109643621846,  /* xyz */
        62.648397029626764, -49.31860514569876, 3.76417356400704,  /* luv */
        62.648397029626764, 49.46204419691238, 175.63544157632745,  /* lch */
        175.63544157632745, 98.18375117243058, 62.648397029626764,  /* hsluv */
        175.63544157632745, 100.184705161952, 62.648397029626764,  /* hpluv */
    },
    {
        "#11aaaa",
        0.06666666666666667, 0.6666666666666666, 0.6666666666666666,  /* rgb */
        0.21860183740452604, 0.31769354924872917, 0.4301148139791832,  /* xyz */
        63.15179862209794, -48.00048715858743, -10.35794945228488,  /* luv */
        63.15179862209794, 49.10533458105958, 192.1770506300611,  /* lch */
        192.1770506300611, 98.28313138550693, 63.15179862209794,  /* hsluv */
        192.1770506300611, 98.66935217669447, 63.15179862209794,  /* hpluv */
    },
    {
        "#11aabb",
        0.06666666666666667, 0.6666666666666666, 0.7333333333333333,  /* rgb */
        0.23573942951186272, 0.3245485860916639, 0.520372799077825,  /* xyz */
        63.71705198908229, -46.67826048913568, -24.91221886818858,  /* luv */
        63.71705198908229, 52.91009970911165, 208.08887035710418,  /* lch */
        208.08887035710418, 98.38378187994505, 63.71705198908229,  /* hsluv */
        208.08887035710418, 105.37127437057828, 63.71705198908229,  /* hpluv */
    },
    {
        "#11aacc",
        0.06666666666666667, 0.6666666666666666, 0.8,  /* rgb */
        0.2550318049555844, 0.33226553626915273, 0.6219793097480951,  /* xyz */
        64.34393313624966, -45.378788098283266, -39.675440108970434,  /* luv */
        64.34393313624966, 60.2774830024396, 221.16374970422956,  /* lch */
        221.16374970422956, 98.48384161018774, 64.34393313624966,  /* hsluv */
        221.16374970422956, 118.87398763321451, 64.34393313624966,  /* hpluv */
    },
    {
        "#11aadd",
        0.06666666666666667, 0.6666666666666666, 0.8666666666666667,  /* rgb */
        0.276550130506218, 0.34087286648940623, 0.7353091576481011,  /* xyz */
        65.03179637780617, -44.12417429268164, -54.460986014470876,  /* luv */
        65.03179637780617, 70.0923801470555, 230.98568280405578,  /* lch */
        230.98568280405578, 98.5817742563244, 65.03179637780617,  /* hsluv */
        230.98568280405578, 136.76796452283173, 65.03179637780617,  /* hpluv */
    },
    {
        "#11aaee",
        0.06666666666666667, 0.6666666666666666, 0.9333333333333333,  /* rgb */
        0.3003623107723927, 0.35039773859587625, 0.8607199737166243,  /* xyz */
        65.77961985445859, -42.93154576399563, -69.12089741376442,  /* luv */
        65.77961985445859, 81.36839731105803, 238.15525139802446,  /* lch */
        238.15525139802446, 98.67638394840765, 65.77961985445859,  /* hsluv */
        238.15525139802446, 156.965326989669, 65.77961985445859,  /* hpluv */
    },
    {
        "#11aaff",
        0.06666666666666667, 0.6666666666666666, 1.0,  /* rgb */
        0.32653335918222415, 0.360866157959809, 0.9985541620084062,  /* xyz */
        66.58605248180133, -41.81327829938456, -83.54431391622185,  /* luv */
        66.58605248180133, 93.42377978798548, 243.41239202365867,  /* lch */
        243.41239202365867, 99.99999999999828, 66.58605248180133,  /* hsluv */
        243.41239202365867, 178.03832182118174, 66.58605248180133,  /* hpluv */
    },
    {
        "#11bb00",
        0.06666666666666667, 0.7333333333333333, 0.0,  /* rgb */
        0.1800070686889929, 0.35658283841627453, 0.059340175728278786,  /* xyz */
        66.25799794252798, -61.72386437001908, 80.99965992511993,  /* luv */
        66.25799794252798, 101.83702833819136, 127.30835094724871,  /* lch */
        127.30835094724871, 100.00000000000242, 66.25799794252798,  /* hsluv */
        127.30835094724871, 195.03238664409787, 66.25799794252798,  /* hpluv */
    },
    {
        "#11bb11",
        0.06666666666666667, 0.7333333333333333, 0.06666666666666667,  /* rgb */
        0.18101873418863004, 0.3569875046161294, 0.06466828069303442,  /* xyz */
        66.2891028676776, -61.58192682532583, 79.63456887394345,  /* luv */
        66.2891028676776, 100.66776182700511, 127.7150129492404,  /* lch */
        127.7150129492404, 98.11997525054643, 66.2891028676776,  /* hsluv */
        127.7150129492404, 192.70261049502548, 66.2891028676776,  /* hpluv */
    },
    {
        "#11bb22",
        0.06666666666666667, 0.7333333333333333, 0.13333333333333333,  /* rgb */
        0.18289409232710704, 0.3577376478715202, 0.07454516688901361,  /* xyz */
        66.34670098901529, -61.321946690170336, 77.13018357056998,  /* luv */
        66.34670098901529, 98.53652299275592, 128.48627008521666,  /* lch */
        128.48627008521666, 98.13390077607112, 66.34670098901529,  /* hsluv */
        128.48627008521666, 188.45914958236673, 66.34670098901529,  /* hpluv */
    },
    {
        "#11bb33",
        0.06666666666666667, 0.7333333333333333, 0.2,  /* rgb */
        0.18598184305956478, 0.3589727481645033, 0.09080732074662476,  /* xyz */
        66.44136031166896, -60.902557051795995, 73.07900094552191,  /* luv */
        66.44136031166896, 95.12971057794121, 129.80713943465682,  /* lch */
        129.80713943465682, 98.15638491685391, 66.44136031166896,  /* hsluv */
        129.80713943465682, 181.68412699249018, 66.44136031166896,  /* hpluv */
    },
    {
        "#11bb44",
        0.06666666666666667, 0.7333333333333333, 0.26666666666666666,  /* rgb */
        0.19043983830378367, 0.3607559462621909, 0.1142860956995114,  /* xyz */
        66.5776441235544, -60.315384515883906, 67.38295957213437,  /* luv */
        66.5776441235544, 90.43455561896029, 131.83214755024275,  /* lch */
        131.83214755024275, 98.18790732129246, 66.5776441235544,  /* hsluv */
        131.83214755024275, 172.3635030654239, 66.5776441235544,  /* hpluv */
    },
    {
        "#11bb55",
        0.06666666666666667, 0.7333333333333333, 0.3333333333333333,  /* rgb */
        0.19640225234314568, 0.36314091187793573, 0.1456881429734853,  /* xyz */
        66.7592187944261, -59.562194793341284, 60.03299782379064,  /* luv */
        66.7592187944261, 84.56722696358905, 134.77444839802823,  /* lch */
        134.77444839802823, 98.22842012979415, 66.7592187944261,  /* hsluv */
        134.77444839802823, 160.742297130584, 66.7592187944261,  /* hpluv */
    },
    {
        "#11bb66",
        0.06666666666666667, 0.7333333333333333, 0.4,  /* rgb */
        0.20398724811665384, 0.36617491018733905, 0.18563578738062927,  /* xyz */
        66.98906095790815, -58.653680512757234, 51.097771240228475,  /* luv */
        66.98906095790815, 77.78969381229957, 138.93835040065852,  /* lch */
        138.93835040065852, 98.27741228045045, 66.98906095790815,  /* hsluv */
        138.93835040065852, 147.35249663507042, 66.98906095790815,  /* hpluv */
    },
    {
        "#11bb77",
        0.06666666666666667, 0.7333333333333333, 0.4666666666666667,  /* rgb */
        0.21330126113685577, 0.36990051539541985, 0.23468958928702718,  /* xyz */
        67.26956604697516, -57.607960857248955, 40.71063794374646,  /* luv */
        67.26956604697516, 70.54100364977194, 144.75175347819567,  /* lch */
        144.75175347819567, 98.33398740837616, 67.26956604697516,  /* hsluv */
        144.75175347819567, 133.06453937158474, 67.26956604697516,  /* hpluv */
    },
    {
        "#11bb88",
        0.06666666666666667, 0.7333333333333333, 0.5333333333333333,  /* rgb */
        0.22444167823879957, 0.37435668223619745, 0.29336245269059935,  /* xyz */
        67.60261317673863, -56.44870944299889, 29.05387258637315,  /* luv */
        67.60261317673863, 63.48688297629139, 152.7653429551746,  /* lch */
        152.7653429551746, 98.39696022333763, 67.60261317673863,  /* hsluv */
        152.7653429551746, 119.16805404714252, 67.60261317673863,  /* hpluv */
    },
    {
        "#11bb99",
        0.06666666666666667, 0.7333333333333333, 0.6,  /* rgb */
        0.2374986423478723, 0.3795794678798266, 0.36212913033171723,  /* xyz */
        67.98960912170934, -55.20305633614085, 16.341160410041415,  /* luv */
        67.98960912170934, 57.57092106608896, 163.51023881420335,  /* lch */
        163.51023881420335, 98.464964167861, 67.98960912170934,  /* hsluv */
        163.51023881420335, 107.4484017280134, 67.98960912170934,  /* hpluv */
    },
    {
        "#11bbaa",
        0.06666666666666667, 0.7333333333333333, 0.6666666666666666,  /* rgb */
        0.2525563353131248, 0.3856025450659277, 0.44143297994871583,  /* xyz */
        68.43152232270515, -53.89949023840068, 2.8001567538204157,  /* luv */
        68.43152232270515, 53.97217733059707, 177.02607466091882,  /* lch */
        177.02607466091882, 98.53655893330877, 68.43152232270515,  /* hsluv */
        177.02607466091882, 100.08132898360098, 68.43152232270515,  /* hpluv */
    },
    {
        "#11bbbb",
        0.06666666666666667, 0.7333333333333333, 0.7333333333333333,  /* rgb */
        0.2696939274204615, 0.3924575819088625, 0.5316909650473576,  /* xyz */
        68.92891264176525, -52.56597947755174, -11.343129842400318,  /* luv */
        68.92891264176525, 53.77591275892901, 192.1770506300611,  /* lch */
        192.1770506300611, 98.61032673154291, 68.92891264176525,  /* hsluv */
        192.1770506300611, 98.99783329419131, 68.92891264176525,  /* hpluv */
    },
    {
        "#11bbcc",
        0.06666666666666667, 0.7333333333333333, 0.8,  /* rgb */
        0.28898630286418325, 0.4001745320863513, 0.6332974757176277,  /* xyz */
        69.48195994049485, -51.22847024171244, -25.87684999406888,  /* luv */
        69.48195994049485, 57.39309652668655, 206.79954343053814,  /* lch */
        206.79954343053814, 98.68494926585537, 69.48195994049485,  /* hsluv */
        206.79954343053814, 104.81584090136549, 69.48195994049485,  /* hpluv */
    },
    {
        "#11bbdd",
        0.06666666666666667, 0.7333333333333333, 0.8666666666666667,  /* rgb */
        0.31050462841481674, 0.4087818623066048, 0.7466273236176337,  /* xyz */
        70.09049307035205, -49.909838838200805, -40.61210116378939,  /* luv */
        70.09049307035205, 64.34543320075669, 219.13557068128532,  /* lch */
        219.13557068128532, 98.75926149995622, 70.09049307035205,  /* hsluv */
        219.13557068128532, 116.49249325423416, 70.09049307035205,  /* hpluv */
    },
    {
        "#11bbee",
        0.06666666666666667, 0.7333333333333333, 0.9333333333333333,  /* rgb */
        0.3343168086809915, 0.4183067344130748, 0.872038139686157,  /* xyz */
        70.75401996252552, -48.629297427094784, -55.38799962110068,  /* luv */
        70.75401996252552, 73.70643845879339, 228.7176654127791,  /* lch */
        228.7176654127791, 98.83228226426604, 70.75401996252552,  /* hsluv */
        228.7176654127791, 132.1884873902597, 70.75401996252552,  /* hpluv */
    },
    {
        "#11bbff",
        0.06666666666666667, 0.7333333333333333, 1.0,  /* rgb */
        0.36048785709082287, 0.42877515377700753, 1.009872327977939,  /* xyz */
        71.47175893740693, -47.402195667163284, -70.07350999881542,  /* luv */
        71.47175893740693, 84.60062031464142, 235.92306997387823,  /* lch */
        235.92306997387823, 99.99999999999781, 71.47175893740693,  /* hsluv */
        235.92306997387823, 150.2029296881672, 71.47175893740693,  /* hpluv */
    },
    {
        "#11cc00",
        0.06666666666666667, 0.8, 0.0,  /* rgb */
        0.21823081199860983, 0.4330303250355094, 0.07208142349815073,  /* xyz */
        71.760164015117, -67.04230475147702, 87.74944441556036,  /* luv */
        71.760164015117, 110.42932410202208, 127.38054048520232,  /* lch */
        127.38054048520232, 100.00000000000225, 71.760164015117,  /* hsluv */
        127.38054048520232, 195.2721544430787, 71.760164015117,  /* hpluv */
    },
    {
        "#11cc11",
        0.06666666666666667, 0.8, 0.06666666666666667,  /* rgb */
        0.21924247749824696, 0.4334349912353643, 0.07740952846290637,  /* xyz */
        71.78749275192634, -66.91466728260532, 86.53059355398695,  /* luv */
        71.78749275192634, 109.38517412495652, 127.71501294924043,  /* lch */
        127.71501294924043, 98.45070616031936, 71.78749275192634,  /* hsluv */
        127.71501294924043, 193.35214907798886, 71.78749275192634,  /* hpluv */
    },
    {
        "#11cc22",
        0.06666666666666667, 0.8, 0.13333333333333333,  /* rgb */
        0.22111783563672396, 0.4341851344907551, 0.08728641465888556,  /* xyz */
        71.83810798669009, -66.68038472611546, 84.29045190042211,  /* luv */
        71.83810798669009, 107.47629500871412, 128.34677201234953,  /* lch */
        128.34677201234953, 98.46017547006014, 71.83810798669009,  /* hsluv */
        128.34677201234953, 189.84411001864018, 71.83810798669009,  /* hpluv */
    },
    {
        "#11cc33",
        0.06666666666666667, 0.8, 0.2,  /* rgb */
        0.2242055863691817, 0.4354202347837382, 0.10354856851649671,  /* xyz */
        71.92131839317116, -66.30109069878814, 80.65562844129136,  /* luv */
        71.92131839317116, 104.40864440796355, 129.42112212389003,  /* lch */
        129.42112212389003, 98.47551687615127, 71.92131839317116,  /* hsluv */
        129.42112212389003, 184.21209587508812, 71.92131839317116,  /* hpluv */
    },
    {
        "#11cc44",
        0.06666666666666667, 0.8, 0.26666666666666666,  /* rgb */
        0.22866358161340058, 0.43720343288142577, 0.12702734346938335,  /* xyz */
        72.04117776603147, -65.76720845308104, 75.52181985255571,  /* luv */
        72.04117776603147, 100.14425086620246, 131.05055963152319,  /* lch */
        131.05055963152319, 98.49713466972003, 72.04117776603147,  /* hsluv */
        131.05055963152319, 176.39429883783419, 72.04117776603147,  /* hpluv */
    },
    {
        "#11cc55",
        0.06666666666666667, 0.8, 0.3333333333333333,  /* rgb */
        0.2346259956527626, 0.43958839849717063, 0.15842939074335727,  /* xyz */
        72.20097715663695, -65.077446685205, 68.8573554627095,  /* luv */
        72.20097715663695, 94.74391520506016, 133.38342727111274,  /* lch */
        133.38342727111274, 98.52510719855992, 72.20097715663695,  /* hsluv */
        133.38342727111274, 166.51278276752885, 72.20097715663695,  /* hpluv */
    },
    {
        "#11cc66",
        0.06666666666666667, 0.8, 0.4,  /* rgb */
        0.24221099142627076, 0.44262239680657395, 0.1983770351505012,  /* xyz */
        72.4034304155724, -64.23793260044533, 60.694919122562034,  /* luv */
        72.4034304155724, 88.37638367841096, 136.62443521853388,  /* lch */
        136.62443521853388, 98.55922193073073, 72.4034304155724,  /* hsluv */
        136.62443521853388, 154.88751418868836, 72.4034304155724,  /* hpluv */
    },
    {
        "#11cc77",
        0.06666666666666667, 0.8, 0.4666666666666667,  /* rgb */
        0.2515250044464727, 0.44634800201465474, 0.2474308370568991,  /* xyz */
        72.65077179370697, -63.26123457988933, 51.1229326663597,  /* luv */
        72.65077179370697, 81.33595788444944, 141.05748476524784,  /* lch */
        141.05748476524784, 98.59901402487148, 72.65077179370697,  /* hsluv */
        141.05748476524784, 142.06322841427942, 72.65077179370697,  /* hpluv */
    },
    {
        "#11cc88",
        0.06666666666666667, 0.8, 0.5333333333333333,  /* rgb */
        0.2626654215484165, 0.45080416885543234, 0.3061037004604713,  /* xyz */
        72.94481382677597, -62.16512506487838, 40.27507026543701,  /* luv */
        72.94481382677597, 74.07147939131403, 147.06191076263224,  /* lch */
        147.06191076263224, 98.64381457923938, 72.94481382677597,  /* hsluv */
        147.06191076263224, 128.85341258398304, 72.94481382677597,  /* hpluv */
    },
    {
        "#11cc99",
        0.06666666666666667, 0.8, 0.6,  /* rgb */
        0.2757223856574892, 0.4560269544990615, 0.3748703781015892,  /* xyz */
        73.28698544966369, -60.97112512290101, 28.318114707232073,  /* luv */
        73.28698544966369, 67.22643616408952, 155.08742955894346,  /* lch */
        155.08742955894346, 98.69280712765726, 73.28698544966369,  /* hsluv */
        155.08742955894346, 116.39988664333858, 73.28698544966369,  /* hpluv */
    },
    {
        "#11ccaa",
        0.06666666666666667, 0.8, 0.6666666666666666,  /* rgb */
        0.29078007862274174, 0.4620500316851626, 0.4541742277185878,  /* xyz */
        73.67835997568852, -59.70295345432483, 15.439097430436538,  /* luv */
        73.67835997568852, 61.666914797448634, 165.50102201116147,  /* lch */
        165.50102201116147, 98.74508772645325, 73.67835997568852,  /* hsluv */
        165.50102201116147, 106.20662237523999, 73.67835997568852,  /* hpluv */
    },
    {
        "#11ccbb",
        0.06666666666666667, 0.8, 0.7333333333333333,  /* rgb */
        0.3079176707300784, 0.4689050685280974, 0.5444322128172295,  /* xyz */
        74.11967806438469, -58.38502502563684, 1.8328764426617707,  /* luv */
        74.11967806438469, 58.41378761301398, 178.20190868210508,  /* lch */
        178.20190868210508, 98.79972307325905, 74.11967806438469,  /* hsluv */
        178.20190868210508, 100.00487457195739, 74.11967806438469,  /* hpluv */
    },
    {
        "#11cccc",
        0.06666666666666667, 0.8, 0.8,  /* rgb */
        0.3272100461738001, 0.4766220187055862, 0.6460387234874997,  /* xyz */
        74.6113685470067, -57.041127907596575, -12.30881506715087,  /* luv */
        74.6113685470067, 58.3540675645504, 192.1770506300611,  /* lch */
        192.1770506300611, 98.85580172073762, 74.6113685470067,  /* hsluv */
        192.1770506300611, 99.24427292038125, 74.6113685470067,  /* hpluv */
    },
    {
        "#11ccdd",
        0.06666666666666667, 0.8, 0.8666666666666667,  /* rgb */
        0.3487283717244337, 0.4852293489258397, 0.7593685713875057,  /* xyz */
        75.15356872935901, -55.69336723233039, -26.806132876873782,  /* luv */
        75.15356872935901, 61.80873654660663, 205.7022764106217,  /* lch */
        205.7022764106217, 98.91247496876854, 75.15356872935901,  /* hsluv */
        205.7022764106217, 104.36132500203259, 75.15356872935901,  /* hpluv */
    },
    {
        "#11ccee",
        0.06666666666666667, 0.8, 0.9333333333333333,  /* rgb */
        0.3725405519906084, 0.4947542210323097, 0.8847793874560289,  /* xyz */
        75.74614504038564, -54.36141741913807, -41.4973677827407,  /* luv */
        75.74614504038564, 68.39002293254342, 217.35669023777243,  /* lch */
        217.35669023777243, 98.96898585581087, 75.74614504038564,  /* hsluv */
        217.35669023777243, 114.57016558150043, 75.74614504038564,  /* hpluv */
    },
    {
        "#11ccff",
        0.06666666666666667, 0.8, 1.0,  /* rgb */
        0.39871160040043985, 0.5052226403962424, 1.0226135757478108,  /* xyz */
        76.38871441689477, -53.062079951822085, -56.24269827364967,  /* luv */
        76.38871441689477, 77.32286491015678, 226.66675785151392,  /* lch */
        226.66675785151392, 99.99999999999692, 76.38871441689477,  /* hsluv */
        226.66675785151392, 131.30464263084565, 76.38871441689477,  /* hpluv */
    },
    {
        "#11dd00",
        0.06666666666666667, 0.8666666666666667, 0.0,  /* rgb */
        0.260864802545785, 0.5182983061298609, 0.08629275368054205,  /* xyz */
        77.17897292086379, -72.2639845338074, 94.39500179579166,  /* luv */
        77.17897292086379, 118.88019105271435, 127.43582058867105,  /* lch */
        127.43582058867105, 100.0000000000023, 77.17897292086379,  /* hsluv */
        127.43582058867105, 210.3672401370558, 77.17897292086379,  /* hpluv */
    },
    {
        "#11dd11",
        0.06666666666666667, 0.8666666666666667, 0.06666666666666667,  /* rgb */
        0.2618764680454221, 0.5187029723297159, 0.09162085864529769,  /* xyz */
        77.2032167276219, -72.148538100067, 93.2987651195291,  /* luv */
        77.2032167276219, 117.94096456620099, 127.71501294924047,  /* lch */
        127.71501294924047, 98.70483751132377, 77.2032167276219,  /* hsluv */
        127.71501294924047, 208.9730008442179, 77.2032167276219,  /* hpluv */
    },
    {
        "#11dd22",
        0.06666666666666667, 0.8666666666666667, 0.13333333333333333,  /* rgb */
        0.26375182618389914, 0.5194531155851067, 0.10149774484127688,  /* xyz */
        77.24812495150218, -71.93628817064717, 91.28116749740225,  /* luv */
        77.24812495150218, 116.21996857450615, 128.24071522256395,  /* lch */
        128.24071522256395, 98.71146173323343, 77.24812495150218,  /* hsluv */
        128.24071522256395, 206.41396744743724, 77.24812495150218,  /* hpluv */
    },
    {
        "#11dd33",
        0.06666666666666667, 0.8666666666666667, 0.2,  /* rgb */
        0.26683957691635685, 0.5206882158780898, 0.11775989869888803,  /* xyz */
        77.32197160747141, -71.59171419338468, 87.9996984996024,  /* luv */
        77.32197160747141, 113.4430274506468, 129.12990557508522,  /* lch */
        129.12990557508522, 98.72222202456504, 77.32197160747141,  /* hsluv */
        129.12990557508522, 202.2730815078432, 77.32197160747141,  /* hpluv */
    },
    {
        "#11dd44",
        0.06666666666666667, 0.8666666666666667, 0.26666666666666666,  /* rgb */
        0.27129757216057576, 0.5224714139757773, 0.14123867365177467,  /* xyz */
        77.4283833065767, -71.10469763822964, 83.3486534805139,  /* luv */
        77.4283833065767, 109.5576380871678, 130.4674793571826,  /* lch */
        130.4674793571826, 98.73744412848694, 77.4283833065767,  /* hsluv */
        130.4674793571826, 196.4551111055974, 77.4283833065767,  /* hpluv */
    },
    {
        "#11dd55",
        0.06666666666666667, 0.8666666666666667, 0.3333333333333333,  /* rgb */
        0.27725998619993775, 0.5248563795915221, 0.17264072092574856,  /* xyz */
        77.57032746304822, -70.47197577050365, 77.28242638548602,  /* luv */
        77.57032746304822, 104.58906633595367, 132.3609308411799,  /* lch */
        132.3609308411799, 98.75724513588756, 77.57032746304822,  /* hsluv */
        132.3609308411799, 188.97465719842904, 77.57032746304822,  /* hpluv */
    },
    {
        "#11dd66",
        0.06666666666666667, 0.8666666666666667, 0.4,  /* rgb */
        0.28484498197344593, 0.5278903779009254, 0.21258836533289255,  /* xyz */
        77.75027951054962, -69.69647009534032, 69.80896508950627,  /* luv */
        77.75027951054962, 98.64527130389259, 134.95379759235584,  /* lch */
        134.95379759235584, 98.78155463182881, 77.75027951054962,  /* hsluv */
        134.95379759235584, 179.96882228706605, 77.75027951054962,  /* hpluv */
    },
    {
        "#11dd77",
        0.06666666666666667, 0.8666666666666667, 0.4666666666666667,  /* rgb */
        0.29415899499364784, 0.5316159831090063, 0.26164216723929046,  /* xyz */
        77.97031134139297, -68.78662162773506, 60.98378715893446,  /* luv */
        77.97031134139297, 91.92726261128094, 138.44093756400994,  /* lch */
        138.44093756400994, 98.8101351189296, 77.97031134139297,  /* hsluv */
        138.44093756400994, 169.72389392093928, 77.97031134139297,  /* hpluv */
    },
    {
        "#11dd88",
        0.06666666666666667, 0.8666666666666667, 0.5333333333333333,  /* rgb */
        0.30529941209559164, 0.5360721499497838, 0.3203150306428626,  /* xyz */
        78.23214368803829, -67.75556138287945, 50.90288371727776,  /* luv */
        78.23214368803829, 84.74620740212417, 143.08347255529662,  /* lch */
        143.08347255529662, 98.84260711485369, 78.23214368803829,  /* hsluv */
        143.08347255529662, 158.72132442321617, 78.23214368803829,  /* hpluv */
    },
    {
        "#11dd99",
        0.06666666666666667, 0.8666666666666667, 0.6,  /* rgb */
        0.3183563762046644, 0.541294935593413, 0.38908170828398053,  /* xyz */
        78.5371801027425, -66.6201031545698, 39.694292881023514,  /* luv */
        78.5371801027425, 77.54917814941687, 149.21222230972467,  /* lch */
        149.21222230972467, 98.87847942467567, 78.5371801027425,  /* hsluv */
        149.21222230972467, 147.71057434042635, 78.5371801027425,  /* hpluv */
    },
    {
        "#11ddaa",
        0.06666666666666667, 0.8666666666666667, 0.6666666666666666,  /* rgb */
        0.3334140691699169, 0.5473180127795141, 0.46838555790097913,  /* xyz */
        78.88653107683908, -65.39961732483644, 27.508766787581926,  /* luv */
        78.88653107683908, 70.94957502627213, 157.18712158734837,  /* lch */
        157.18712158734837, 98.91718289161727, 78.88653107683908,  /* hsluv */
        157.18712158734837, 137.80723273971586, 78.88653107683908,  /* hpluv */
    },
    {
        "#11ddbb",
        0.06666666666666667, 0.8666666666666667, 0.7333333333333333,  /* rgb */
        0.35055166127725357, 0.5541730496224488, 0.5586435429996208,  /* xyz */
        79.28103287595944, -64.11487493168046, 14.51023008734971,  /* luv */
        79.28103287595944, 65.73632150259745, 167.24786192995697,  /* lch */
        167.24786192995697, 98.95810499467045, 79.28103287595944,  /* hsluv */
        167.24786192995697, 130.57254218104305, 79.28103287595944,  /* hpluv */
    },
    {
        "#11ddcc",
        0.06666666666666667, 0.8666666666666667, 0.8,  /* rgb */
        0.3698440367209753, 0.5618899997999377, 0.660250053669891,  /* xyz */
        79.72126370567014, -62.78695454370699, 0.8667674165210268,  /* luv */
        79.72126370567014, 62.7929370759791, 179.20908792727695,  /* lch */
        179.20908792727695, 99.0006225499112, 79.72126370567014,  /* hsluv */
        179.20908792727695, 127.93520146708772, 79.72126370567014,  /* hpluv */
    },
    {
        "#11dddd",
        0.06666666666666667, 0.8666666666666667, 0.8666666666666667,  /* rgb */
        0.3913623622716088, 0.5704973300201912, 0.773579901569897,  /* xyz */
        80.20755874836644, -61.4362892449526, -13.257240003267949,  /* luv */
        80.20755874836644, 62.85039418089378, 192.17705063006113,  /* lch */
        192.17705063006113, 99.04413022019311, 80.20755874836644,  /* hsluv */
        192.17705063006113, 131.7670090827411, 80.20755874836644,  /* hpluv */
    },
    {
        "#11ddee",
        0.06666666666666667, 0.8666666666666667, 0.9333333333333333,  /* rgb */
        0.4151745425377836, 0.5800222021266612, 0.8989907176384202,  /* xyz */
        80.74002497469166, -60.08190529989902, -27.707414132610225,  /* luv */
        80.74002497469166, 66.16295143342687, 204.75729527822082,  /* lch */
        204.75729527822082, 99.08806330147246, 80.74002497469166,  /* hsluv */
        204.75729527822082, 143.22067561241397, 80.74002497469166,  /* hpluv */
    },
    {
        "#11ddff",
        0.06666666666666667, 0.8666666666666667, 1.0,  /* rgb */
        0.44134559094761494, 0.590490621490594, 1.0368249059302022,  /* xyz */
        81.31855622903718, -58.74087534002191, -42.34393329408179,  /* luv */
        81.31855622903718, 72.41200951862642, 215.7863164786126,  /* lch */
        215.7863164786126, 99.99999999999599, 81.31855622903718,  /* hsluv */
        215.7863164786126, 162.4288072777225, 81.31855622903718,  /* hpluv */
    },
    {
        "#11ee00",
        0.06666666666666667, 0.9333333333333333, 0.0,  /* rgb */
        0.3080435788862998, 0.6126558588108919, 0.10201901246071324,  /* xyz */
        82.52131190083256, -77.39919470828836, 100.94522293122722,  /* luv */
        82.52131190083256, 127.20288272726643, 127.47898819200516,  /* lch */
        127.47898819200516, 100.00000000000242, 82.52131190083256,  /* hsluv */
        127.47898819200516, 308.19522276267344, 82.52131190083256,  /* hpluv */
    },
    {
        "#11ee11",
        0.06666666666666667, 0.9333333333333333, 0.06666666666666667,  /* rgb */
        0.3090552443859369, 0.6130605250107468, 0.10734711742546887,  /* xyz */
        82.54299861109438, -77.2942129186682, 99.95288617207635,  /* luv */
        82.54299861109438, 126.35258131452821, 127.7150129492404,  /* lch */
        127.7150129492404, 98.90381308009492, 82.54299861109438,  /* hsluv */
        127.7150129492404, 306.5732965602888, 82.54299861109438,  /* hpluv */
    },
    {
        "#11ee22",
        0.06666666666666667, 0.9333333333333333, 0.13333333333333333,  /* rgb */
        0.31093060252441396, 0.6138106682661376, 0.11722400362144807,  /* xyz */
        82.58317476177932, -77.1009570540098, 98.12451472028683,  /* luv */
        82.58317476177932, 124.79173837933362, 128.15835444556282,  /* lch */
        128.15835444556282, 98.90856202324699, 82.58317476177932,  /* hsluv */
        128.15835444556282, 303.59085997924285, 82.58317476177932,  /* hpluv */
    },
    {
        "#11ee33",
        0.06666666666666667, 0.9333333333333333, 0.2,  /* rgb */
        0.31401835325687166, 0.6150457685591207, 0.1334861574790592,  /* xyz */
        82.64925297208214, -76.78653931156893, 95.14527621193805,  /* luv */
        82.64925297208214, 122.26526982300862, 128.9050983582319,  /* lch */
        128.9050983582319, 98.916292078887, 82.64925297208214,  /* hsluv */
        128.9050983582319, 298.7491431477361, 82.64925297208214,  /* hpluv */
    },
    {
        "#11ee44",
        0.06666666666666667, 0.9333333333333333, 0.26666666666666666,  /* rgb */
        0.3184763485010906, 0.6168289666568083, 0.15696493243194584,  /* xyz */
        82.74449869010155, -76.3407023620842, 90.9108734321077,  /* luv */
        82.74449869010155, 118.71263515449834, 130.02123038852284,  /* lch */
        130.02123038852284, 98.92726127709471, 82.74449869010155,  /* hsluv */
        130.02123038852284, 291.9113867566936, 82.74449869010155,  /* hpluv */
    },
    {
        "#11ee55",
        0.06666666666666667, 0.9333333333333333, 0.3333333333333333,  /* rgb */
        0.32443876254045256, 0.6192139322725531, 0.18836697970591976,  /* xyz */
        82.87160002854229, -75.758934185545, 85.3674144008224,  /* luv */
        82.87160002854229, 114.13593452726218, 131.58731064362993,  /* lch */
        131.58731064362993, 98.94158972710115, 82.87160002854229,  /* hsluv */
        131.58731064362993, 283.0525914951309, 82.87160002854229,  /* hpluv */
    },
    {
        "#11ee66",
        0.06666666666666667, 0.9333333333333333, 0.4,  /* rgb */
        0.33202375831396075, 0.6222479305819564, 0.22831462411306372,  /* xyz */
        83.03281930135226, -75.04191094339491, 78.50591280285137,  /* luv */
        83.03281930135226, 108.6023330460507, 133.70764025305243,  /* lch */
        133.70764025305243, 98.9592735060659, 83.03281930135226,  /* hsluv */
        133.70764025305243, 272.2694495261456, 83.03281930135226,  /* hpluv */
    },
    {
        "#11ee77",
        0.06666666666666667, 0.9333333333333333, 0.4666666666666667,  /* rgb */
        0.34133777133416265, 0.6259735357900372, 0.27736842601946166,  /* xyz */
        83.23007361774557, -74.19502098852789, 70.35790224306852,  /* luv */
        83.23007361774557, 102.25035720002782, 136.52054409716368,  /* lch */
        136.52054409716368, 98.98019627330702, 83.23007361774557,  /* hsluv */
        136.52054409716368, 259.8039491751299, 83.23007361774557,  /* hpluv */
    },
    {
        "#11ee88",
        0.06666666666666667, 0.9333333333333333, 0.5333333333333333,  /* rgb */
        0.35247818843610645, 0.6304297026308148, 0.3360412894230338,  /* xyz */
        83.46498270705762, -73.22779628376931, 60.99050752737558,  /* luv */
        83.46498270705762, 95.30032611184537, 140.20951157447624,  /* lch */
        140.20951157447624, 99.00414288943331, 83.46498270705762,  /* hsluv */
        140.20951157447624, 246.08464416727003, 83.46498270705762,  /* hpluv */
    },
    {
        "#11ee99",
        0.06666666666666667, 0.9333333333333333, 0.6,  /* rgb */
        0.3655351525451792, 0.635652488274444, 0.4048079670641517,  /* xyz */
        83.73889973778756, -72.15321158644454, 50.50054976033724,  /* luv */
        83.73889973778756, 88.07037792773761, 145.01154979544114,  /* lch */
        145.01154979544114, 99.03081605303686, 83.73889973778756,  /* hsluv */
        145.01154979544114, 231.79372537757814, 83.73889973778756,  /* hpluv */
    },
    {
        "#11eeaa",
        0.06666666666666667, 0.9333333333333333, 0.6666666666666666,  /* rgb */
        0.3805928455104317, 0.641675565460545, 0.48411181668115033,  /* xyz */
        84.05293275712529, -70.98687243096347, 39.00780742410218,  /* luv */
        84.05293275712529, 80.99842651290038, 151.21088243918808,  /* lch */
        151.21088243918808, 99.05985549971679, 84.05293275712529,  /* hsluv */
        151.21088243918808, 217.96750402181644, 84.05293275712529,  /* hpluv */
    },
    {
        "#11eebb",
        0.06666666666666667, 0.9333333333333333, 0.7333333333333333,  /* rgb */
        0.3977304376177684, 0.6485306023034798, 0.574369801779792,  /* xyz */
        84.40796084995999, -69.74614289350433, 26.647821694798083,  /* luv */
        84.40796084995999, 74.66345056049094, 159.08970566728726,  /* lch */
        159.08970566728726, 99.09085858614442, 84.40796084995999,  /* hsluv */
        159.08970566728726, 206.12213426554504, 84.40796084995999,  /* hpluv */
    },
    {
        "#11eecc",
        0.06666666666666667, 0.9333333333333333, 0.8,  /* rgb */
        0.41702281306149014, 0.6562475524809687, 0.6759763124500622,  /* xyz */
        84.8046473826435, -68.44927512686616, 13.56473481389922,  /* luv */
        84.8046473826435, 69.7804076798411, 168.79080711015052,  /* lch */
        168.79080711015052, 99.12340081440828, 84.8046473826435,  /* hsluv */
        168.79080711015052, 198.34253857184285, 84.8046473826435,  /* hpluv */
    },
    {
        "#11eedd",
        0.06666666666666667, 0.9333333333333333, 0.8666666666666667,  /* rgb */
        0.4385411386121236, 0.6648548827012222, 0.7893061603500682,  /* xyz */
        85.24345175721407, -67.11460005642154, -0.09536476737558867,  /* luv */
        85.24345175721407, 67.1146678094459, 180.08141291169076,  /* lch */
        180.08141291169076, 99.15705490817795, 85.24345175721407,  /* hsluv */
        180.08141291169076, 197.17395409418035, 85.24345175721407,  /* hpluv */
    },
    {
        "#11eeee",
        0.06666666666666667, 0.9333333333333333, 0.9333333333333333,  /* rgb */
        0.4623533188782984, 0.6743797548076922, 0.9147169764185914,  /* xyz */
        85.72464055023413, -65.75982680324722, -14.19020935701463,  /* luv */
        85.72464055023413, 67.2734484234975, 192.17705063006116,  /* lch */
        192.17705063006116, 99.19140732740091, 85.72464055023413,  /* hsluv */
        192.17705063006116, 205.13808279386382, 85.72464055023413,  /* hpluv */
    },
    {
        "#11eeff",
        0.06666666666666667, 0.9333333333333333, 1.0,  /* rgb */
        0.48852436728812976, 0.6848481741716249, 1.0525511647103734,  /* xyz */
        86.24829856457235, -64.40148165617103, -28.585983907627277,  /* luv */
        86.24829856457235, 70.46069340758193, 203.93507188092792,  /* lch */
        203.93507188092792, 99.99999999999423, 86.24829856457235,  /* hsluv */
        203.93507188092792, 224.026806300523, 86.24829856457235,  /* hpluv */
    },
    {
        "#11ff00",
        0.06666666666666667, 1.0, 0.0,  /* rgb */
        0.35989595131597363, 0.716360603670241, 0.11930313660393735,  /* xyz */
        87.7931168603164, -82.4563732780469, 107.4077181118084,  /* luv */
        87.7931168603164, 135.40853519684163, 127.51327079745793,  /* lch */
        127.51327079745793, 100.00000000000237, 87.7931168603164,  /* hsluv */
        127.51327079745793, 491.31098597876905, 87.7931168603164,  /* hpluv */
    },
    {
        "#11ff11",
        0.06666666666666667, 1.0, 0.06666666666666667,  /* rgb */
        0.36090761681561073, 0.7167652698700959, 0.12463124156869299,  /* xyz */
        87.81265714010351, -82.36043592593593, 106.50426424355777,  /* luv */
        87.81265714010351, 134.63431846290817, 127.71501294924043,  /* lch */
        127.71501294924043, 99.99999999999191, 87.81265714010351,  /* hsluv */
        127.71501294924043, 489.36433450544905, 87.81265714010351,  /* hpluv */
    },
    {
        "#11ff22",
        0.06666666666666667, 1.0, 0.13333333333333333,  /* rgb */
        0.3627829749540878, 0.7175154131254867, 0.13450812776467216,  /* xyz */
        87.84886016532796, -82.1836510367646, 104.83820575758615,  /* luv */
        87.84886016532796, 133.21111771996613, 128.09322968178415,  /* lch */
        128.09322968178415, 99.99999999999186, 87.84886016532796,  /* hsluv */
        128.09322968178415, 485.7796458877379, 87.84886016532796,  /* hpluv */
    },
    {
        "#11ff33",
        0.06666666666666667, 1.0, 0.2,  /* rgb */
        0.3658707256865455, 0.7187505134184698, 0.15077028162228331,  /* xyz */
        87.90841300078327, -81.89553488614887, 102.11941430088567,  /* luv */
        87.90841300078327, 130.90169369203883, 128.7281668325629,  /* lch */
        128.7281668325629, 99.99999999999196, 87.90841300078327,  /* hsluv */
        128.7281668325629, 479.9456324678314, 87.90841300078327,  /* hpluv */
    },
    {
        "#11ff44",
        0.06666666666666667, 1.0, 0.26666666666666666,  /* rgb */
        0.3703287209307644, 0.7205337115161574, 0.17424905657516995,  /* xyz */
        87.9942732352876, -81.48593481778478, 98.24658911088912,  /* luv */
        87.9942732352876, 127.64148951282317, 129.67238607469466,  /* lch */
        129.67238607469466, 99.99999999999189, 87.9942732352876,  /* hsluv */
        129.67238607469466, 471.6741934062248, 87.9942732352876,  /* hpluv */
    },
    {
        "#11ff55",
        0.06666666666666667, 1.0, 0.3333333333333333,  /* rgb */
        0.3762911349701264, 0.7229186771319022, 0.20565110384914387,  /* xyz */
        88.10888717232437, -80.94957229781308, 93.16124949660777,  /* luv */
        88.10888717232437, 123.41738800901625, 130.98799411381293,  /* lch */
        130.98799411381293, 99.9999999999917, 88.10888717232437,  /* hsluv */
        130.98799411381293, 460.8972430096718, 88.10888717232437,  /* hpluv */
    },
    {
        "#11ff66",
        0.06666666666666667, 1.0, 0.4,  /* rgb */
        0.3838761307436346, 0.7259526754413055, 0.24559874825628783,  /* xyz */
        88.2543278429396, -80.28555595290314, 86.8429006471038,  /* luv */
        88.2543278429396, 118.26859214292475, 132.75313210415825,  /* lch */
        132.75313210415825, 99.99999999999167, 88.2543278429396,  /* hsluv */
        132.75313210415825, 447.6755259403652, 88.2543278429396,  /* hpluv */
    },
    {
        "#11ff77",
        0.06666666666666667, 1.0, 0.4666666666666667,  /* rgb */
        0.3931901437638365, 0.7296782806493863, 0.29465255016268577,  /* xyz */
        88.43236879250466, -79.49702114439646, 79.30563705053005,  /* luv */
        88.43236879250466, 112.29051802722714, 135.06905108302496,  /* lch */
        135.06905108302496, 99.99999999999164, 88.43236879250466,  /* hsluv */
        135.06905108302496, 432.2229487159223, 88.43236879250466,  /* hpluv */
    },
    {
        "#11ff88",
        0.06666666666666667, 1.0, 0.5333333333333333,  /* rgb */
        0.4043305608657803, 0.7341344474901639, 0.3533254135662579,  /* xyz */
        88.64452801093388, -78.59072896508876, 70.59460766989304,  /* luv */
        88.64452801093388, 105.64138067694005, 138.06803636264823,  /* lch */
        138.06803636264823, 99.9999999999915, 88.64452801093388,  /* hsluv */
        138.06803636264823, 414.95023459347243, 88.64452801093388,  /* hpluv */
    },
    {
        "#11ff99",
        0.06666666666666667, 1.0, 0.6,  /* rgb */
        0.417387524974853, 0.7393572331337931, 0.4220920912073758,  /* xyz */
        88.89209618768405, -77.57657316093042, 60.781834293212434,  /* luv */
        88.89209618768405, 98.55230125897988, 141.92103098854187,  /* lch */
        141.92103098854187, 99.99999999999135, 88.89209618768405,  /* hsluv */
        141.92103098854187, 396.53738118570254, 88.89209618768405,  /* hpluv */
    },
    {
        "#11ffaa",
        0.06666666666666667, 1.0, 0.6666666666666666,  /* rgb */
        0.43244521794010554, 0.7453803103198942, 0.5013959408243744,  /* xyz */
        89.17615614903391, -76.4669946123218, 49.961336223301416,  /* luv */
        89.17615614903391, 91.34186544109235, 146.84055338152828,  /* lch */
        146.84055338152828, 99.9999999999913, 89.17615614903391,  /* hsluv */
        146.84055338152828, 378.04839207714144, 89.17615614903391,  /* hpluv */
    },
    {
        "#11ffbb",
        0.06666666666666667, 1.0, 0.7333333333333333,  /* rgb */
        0.4495828100474422, 0.7522353471628289, 0.5916539259230161,  /* xyz */
        89.4975971674113, -75.27632967106489, 38.2437510711127,  /* luv */
        89.4975971674113, 84.43405891425614, 153.06738823878464,  /* lch */
        153.06738823878464, 99.99999999999093, 89.4975971674113,  /* hsluv */
        153.06738823878464, 361.09941503293584, 89.4975971674113,  /* hpluv */
    },
    {
        "#11ffcc",
        0.06666666666666667, 1.0, 0.8,  /* rgb */
        0.4688751854911639, 0.7599522973403178, 0.6932604365932863,  /* xyz */
        89.85712628230186, -74.02013160862829, 25.750756489667214,  /* luv */
        89.85712628230186, 78.37143193248922, 160.81779925832888,  /* lch */
        160.81779925832888, 99.999999999991, 89.85712628230186,  /* hsluv */
        160.81779925832888, 348.06761522570685, 89.85712628230186,  /* hpluv */
    },
    {
        "#11ffdd",
        0.06666666666666667, 1.0, 0.8666666666666667,  /* rgb */
        0.4903935110417975, 0.7685596275605713, 0.8065902844932923,  /* xyz */
        90.25527793801413, -72.71450767972642, 12.609629380140879,  /* luv */
        90.25527793801413, 73.7997451229305, 170.1620134987523,  /* lch */
        170.1620134987523, 99.99999999999083, 90.25527793801413,  /* hsluv */
        170.1620134987523, 342.2566866665653, 90.25527793801413,  /* hpluv */
    },
    {
        "#11ffee",
        0.06666666666666667, 1.0, 0.9333333333333333,  /* rgb */
        0.5142056913079722, 0.7780844996670413, 0.9320011005618155,  /* xyz */
        90.69242275841958, -71.37551039441637, -1.0517495272034798,  /* luv */
        90.69242275841958, 71.38325896967308, 180.84421740325766,  /* lch */
        180.84421740325766, 99.99999999999018, 90.69242275841958,  /* hsluv */
        180.84421740325766, 347.8212294780951, 90.69242275841958,  /* hpluv */
    },
    {
        "#11ffff",
        0.06666666666666667, 1.0, 1.0,  /* rgb */
        0.5403767397178036, 0.788552919030974, 1.0698352888535974,  /* xyz */
        91.16877597766899, -70.01861293845494, -15.109206103252466,  /* luv */
        91.16877597766899, 71.63026083224695, 192.17705063006116,  /* lch */
        192.17705063006116, 99.99999999998981, 91.16877597766899,  /* hsluv */
        192.17705063006116, 369.2587099562759, 91.16877597766899,  /* hpluv */
    },
    {
        "#220000",
        0.13333333333333333, 0.0, 0.0,  /* rgb */
        0.00659672420629513, 0.0034014359188709988, 0.0003092214471700777,  /* xyz */
        3.072504467277817, 10.100443166367237, 2.1795587077536007,  /* luv */
        3.072504467277817, 10.332929319295626, 12.177050630061776,  /* lch */
        12.177050630061776, 100.00000000000222, 3.072504467277817,  /* hsluv */
        12.177050630061776, 426.74678918312543, 3.072504467277817,  /* hpluv */
    },
    {
        "#220011",
        0.13333333333333333, 0.0, 0.06666666666666667,  /* rgb */
        0.007608389705932252, 0.0038061021187258534, 0.0056373264119257095,  /* xyz */
        3.438037946804036, 7.824928088951886, -2.1717293120255468,  /* luv */
        3.438037946804036, 8.120708577579864, 344.48854589536415,  /* lch */
        344.48854589536415, 99.99999999999768, 3.438037946804036,  /* hsluv */
        344.48854589536415, 299.72473591628284, 3.438037946804036,  /* hpluv */
    },
    {
        "#220022",
        0.13333333333333333, 0.0, 0.13333333333333333,  /* rgb */
        0.00948374784440927, 0.004556245374116671, 0.015514212607904905,  /* xyz */
        4.115639571017972, 5.734862363599896, -7.416027971518624,  /* luv */
        4.115639571017972, 9.374759581118933, 307.7150129492436,  /* lch */
        307.7150129492436, 99.99999999999882, 4.115639571017972,  /* hsluv */
        307.7150129492436, 289.0427837304834, 4.115639571017972,  /* hpluv */
    },
    {
        "#220033",
        0.13333333333333333, 0.0, 0.2,  /* rgb */
        0.012571498576867011, 0.005791345667099785, 0.03177636646551605,  /* xyz */
        5.231301091105154, 4.104242502962071, -13.649841365421413,  /* luv */
        5.231301091105154, 14.253525031524301, 286.7350132675556,  /* lch */
        286.7350132675556, 99.99999999999957, 5.231301091105154,  /* hsluv */
        286.7350132675556, 345.74180296647927, 5.231301091105154,  /* hpluv */
    },
    {
        "#220044",
        0.13333333333333333, 0.0, 0.26666666666666666,  /* rgb */
        0.01702949382108589, 0.007574543764787361, 0.05525514141840269,  /* xyz */
        6.842057328137227, 2.8443022545468772, -21.199022177165496,  /* luv */
        6.842057328137227, 21.38898306566198, 277.64181651527167,  /* lch */
        277.64181651527167, 100.00000000000009, 6.842057328137227,  /* hsluv */
        277.64181651527167, 396.6822376833464, 6.842057328137227,  /* hpluv */
    },
    {
        "#220055",
        0.13333333333333333, 0.0, 0.3333333333333333,  /* rgb */
        0.022991907860447885, 0.009959509380532193, 0.0866571886923766,  /* xyz */
        8.95766614306443, 1.733083214784268, -30.393491333644945,  /* luv */
        8.95766614306443, 30.442862757594224, 273.26355866064335,  /* lch */
        273.26355866064335, 100.00000000000024, 8.95766614306443,  /* hsluv */
        273.26355866064335, 431.2508303477115, 8.95766614306443,  /* hpluv */
    },
    {
        "#220066",
        0.13333333333333333, 0.0, 0.4,  /* rgb */
        0.030576903633956057, 0.012993507689935506, 0.12660483309952056,  /* xyz */
        11.270941085881294, 0.6202492651463029, -40.31149529203174,  /* luv */
        11.270941085881294, 40.31626671494289, 270.881506896841,  /* lch */
        270.881506896841, 100.00000000000047, 11.270941085881294,  /* hsluv */
        270.881506896841, 453.8992409353729, 11.270941085881294,  /* hpluv */
    },
    {
        "#220077",
        0.13333333333333333, 0.0, 0.4666666666666667,  /* rgb */
        0.039890916654157976, 0.016719112898016322, 0.17565863500591847,  /* xyz */
        13.661679140840896, -0.47628183673840807, -50.490588165641476,  /* luv */
        13.661679140840896, 50.49283451837916, 269.4595402683751,  /* lch */
        269.4595402683751, 100.00000000000071, 13.661679140840896,  /* hsluv */
        269.4595402683751, 468.99152702099894, 13.661679140840896,  /* hpluv */
    },
    {
        "#220088",
        0.13333333333333333, 0.0, 0.5333333333333333,  /* rgb */
        0.051031333756101804, 0.021175279738793913, 0.23433149840949064,  /* xyz */
        16.09231463063839, -1.5383080574936163, -60.76953667432173,  /* luv */
        16.09231463063839, 60.78900376952631, 268.5499356210174,  /* lch */
        268.5499356210174, 100.00000000000071, 16.09231463063839,  /* hsluv */
        268.5499356210174, 479.3423905742407, 16.09231463063839,  /* hpluv */
    },
    {
        "#220099",
        0.13333333333333333, 0.0, 0.6,  /* rgb */
        0.06408829786517452, 0.026398065382423074, 0.30309817605060857,  /* xyz */
        18.539445092642275, -2.560179514798283, -71.05544068762549,  /* luv */
        18.539445092642275, 71.10154829861764, 267.93648379709447,  /* lch */
        267.93648379709447, 100.00000000000074, 18.539445092642275,  /* hsluv */
        267.93648379709447, 486.6555195649454, 18.539445092642275,  /* hpluv */
    },
    {
        "#2200aa",
        0.13333333333333333, 0.0, 0.6666666666666666,  /* rgb */
        0.07914599083042706, 0.03242114256852418, 0.38240202566760717,  /* xyz */
        20.98856031798738, -3.5420797784046125, -81.29558780124079,  /* luv */
        20.98856031798738, 81.3727160976321, 267.50517893191034,  /* lch */
        267.50517893191034, 100.00000000000078, 20.98856031798738,  /* hsluv */
        267.50517893191034, 491.9664526367395, 20.98856031798738,  /* hpluv */
    },
    {
        "#2200bb",
        0.13333333333333333, 0.0, 0.7333333333333333,  /* rgb */
        0.0962835829377637, 0.03927617941145894, 0.4726600107662489,  /* xyz */
        23.430692185683583, -4.486653017728783, -91.46075443669712,  /* luv */
        23.430692185683583, 91.57073581353, 267.1915782258585,  /* lch */
        267.1915782258585, 100.00000000000091, 23.430692185683583,  /* hsluv */
        267.1915782258585, 495.9191875286987, 23.430692185683583,  /* hpluv */
    },
    {
        "#2200cc",
        0.13333333333333333, 0.0, 0.8,  /* rgb */
        0.11557595838148545, 0.04699312958894774, 0.574266521436519,  /* xyz */
        25.860342630381858, -5.397380074093186, -101.53549057354547,  /* luv */
        25.860342630381858, 101.67884518263747, 266.9571594412921,  /* lch */
        266.9571594412921, 100.00000000000088, 25.860342630381858,  /* hsluv */
        266.9571594412921, 498.92544911164754, 25.860342630381858,  /* hpluv */
    },
    {
        "#2200dd",
        0.13333333333333333, 0.0, 0.8666666666666667,  /* rgb */
        0.13709428393211898, 0.05560045980920127, 0.687596369336525,  /* xyz */
        28.274206222811628, -6.277829583943597, -111.51246475147617,  /* luv */
        28.274206222811628, 111.68903679069962, 266.7778143737782,  /* lch */
        266.7778143737782, 100.00000000000084, 28.274206222811628,  /* hsluv */
        266.7778143737782, 501.2558461396944, 28.274206222811628,  /* hpluv */
    },
    {
        "#2200ee",
        0.13333333333333333, 0.0, 0.9333333333333333,  /* rgb */
        0.1609064641982937, 0.0651253319156713, 0.8130071854050482,  /* xyz */
        30.670376645627506, -7.131337226725819, -121.38914275385976,  /* luv */
        30.670376645627506, 121.59843728090517, 266.6378670637724,  /* lch */
        266.6378670637724, 100.00000000000084, 30.670376645627506,  /* hsluv */
        266.6378670637724, 503.09292609212895, 30.670376645627506,  /* hpluv */
    },
    {
        "#2200ff",
        0.13333333333333333, 0.0, 1.0,  /* rgb */
        0.1870775126081251, 0.07559375127960401, 0.9508413736968301,  /* xyz */
        33.047847750232826, -7.960890308728007, -131.16581364918977,  /* luv */
        33.047847750232826, 131.4071780564577, 266.5267887693604,  /* lch */
        266.5267887693604, 100.00000000000082, 33.047847750232826,  /* hsluv */
        266.5267887693604, 504.5628072919129, 33.047847750232826,  /* hpluv */
    },
    {
        "#221100",
        0.13333333333333333, 0.06666666666666667, 0.0,  /* rgb */
        0.00860112446722354, 0.007410236440727872, 0.0009773548674795285,  /* xyz */
        6.693639130875758, 7.187243693755639, 6.550392820116553,  /* luv */
        6.693639130875758, 9.724408363045265, 42.345776199706705,  /* lch */
        42.345776199706705, 100.0000000000024, 6.693639130875758,  /* hsluv */
        42.345776199706705, 184.34875961059691, 6.693639130875758,  /* hpluv */
    },
    {
        "#221111",
        0.13333333333333333, 0.06666666666666667, 0.06666666666666667,  /* rgb */
        0.009612789966860661, 0.007814902640582726, 0.00630545983223516,  /* xyz */
        7.059172610401976, 6.055020796176159, 1.3066033920056033,  /* luv */
        7.059172610401976, 6.194391759174286, 12.1770506300621,  /* lch */
        12.1770506300621, 26.092394217240134, 7.059172610401976,  /* hsluv */
        12.1770506300621, 111.34845454307141, 7.059172610401976,  /* hpluv */
    },
    {
        "#221122",
        0.13333333333333333, 0.06666666666666667, 0.13333333333333333,  /* rgb */
        0.01148814810533768, 0.008565045895973546, 0.016182346028214355,  /* xyz */
        7.736774234615915, 4.620180301866178, -5.97457866985129,  /* luv */
        7.736774234615915, 7.552592687547387, 307.71501294924525,  /* lch */
        307.71501294924525, 42.856167926372315, 7.736774234615915,  /* hsluv */
        307.71501294924525, 123.87266077459759, 7.736774234615915,  /* hpluv */
    },
    {
        "#221133",
        0.13333333333333333, 0.06666666666666667, 0.2,  /* rgb */
        0.01457589883779542, 0.009800146188956659, 0.0324444998858255,  /* xyz */
        8.823832982244365, 3.1381474065779065, -14.643637739035324,  /* luv */
        8.823832982244365, 14.976117500123696, 282.0955989033296,  /* lch */
        282.0955989033296, 58.39416185051613, 8.823832982244365,  /* hsluv */
        282.0955989033296, 215.36805510923017, 8.823832982244365,  /* hpluv */
    },
    {
        "#221144",
        0.13333333333333333, 0.06666666666666667, 0.26666666666666666,  /* rgb */
        0.0190338940820143, 0.011583344286644235, 0.055923274838712136,  /* xyz */
        10.2463738670161, 1.7759694854704022, -23.86745449126382,  /* luv */
        10.2463738670161, 23.933437937452105, 274.25551780115836,  /* lch */
        274.25551780115836, 70.12309595085283, 10.2463738670161,  /* hsluv */
        274.25551780115836, 296.3972814122497, 10.2463738670161,  /* hpluv */
    },
    {
        "#221155",
        0.13333333333333333, 0.06666666666666667, 0.3333333333333333,  /* rgb */
        0.024996308121376293, 0.013968309902389066, 0.08732532211268605,  /* xyz */
        11.936539550067156, 0.551083463009601, -33.380695620043035,  /* luv */
        11.936539550067156, 33.38524424144839, 270.9458127795217,  /* lch */
        270.9458127795217, 78.3035236172291, 11.936539550067156,  /* hsluv */
        270.9458127795217, 354.90771729897995, 11.936539550067156,  /* hpluv */
    },
    {
        "#221166",
        0.13333333333333333, 0.06666666666666667, 0.4,  /* rgb */
        0.032581303894884464, 0.01700230821179238, 0.12727296651983,  /* xyz */
        13.828216326325151, -0.5663623772057307, -43.09692911767165,  /* luv */
        13.828216326325151, 43.10065040943035, 269.247085426223,  /* lch */
        269.247085426223, 83.90846526749522, 13.828216326325151,  /* hsluv */
        269.247085426223, 395.5095600363987, 13.828216326325151,  /* hpluv */
    },
    {
        "#221177",
        0.13333333333333333, 0.06666666666666667, 0.4666666666666667,  /* rgb */
        0.041895316915086384, 0.020727913419873196, 0.1763267684262279,  /* xyz */
        15.864701259849909, -1.6054328197081504, -52.954745458525224,  /* luv */
        15.864701259849909, 52.9790758801604, 268.2634916315392,  /* lch */
        268.2634916315392, 87.78373428258483, 15.864701259849909,  /* hsluv */
        268.2634916315392, 423.7520444835959, 15.864701259849909,  /* hpluv */
    },
    {
        "#221188",
        0.13333333333333333, 0.06666666666666667, 0.5333333333333333,  /* rgb */
        0.05303573401703021, 0.025184080260650787, 0.23499963182980008,  /* xyz */
        18.001652209943742, -2.5861469344379344, -62.89616655076663,  /* luv */
        18.001652209943742, 62.94931232943119, 267.6454545285475,  /* lch */
        267.6454545285475, 90.51569529755675, 18.001652209943742,  /* hsluv */
        267.6454545285475, 443.7291396680462, 18.001652209943742,  /* hpluv */
    },
    {
        "#221199",
        0.13333333333333333, 0.06666666666666667, 0.6,  /* rgb */
        0.06609269812610293, 0.030406865904279948, 0.303766309470918,  /* xyz */
        20.206110748308348, -3.5214856840358273, -72.87112315319187,  /* luv */
        20.206110748308348, 72.95616115881185, 267.2333426831374,  /* lch */
        267.2333426831374, 92.48533363823617, 20.206110748308348,  /* hsluv */
        267.2333426831374, 458.16147844077886, 20.206110748308348,  /* hpluv */
    },
    {
        "#2211aa",
        0.13333333333333333, 0.06666666666666667, 0.6666666666666666,  /* rgb */
        0.08115039109135547, 0.03642994309038105, 0.3830701590879166,  /* xyz */
        22.45423300556908, -4.4200777668624145, -82.84059155767098,  /* luv */
        22.45423300556908, 82.95842752300685, 266.94579821449685,  /* lch */
        266.94579821449685, 93.93731818557009, 22.45423300556908,  /* hsluv */
        266.94579821449685, 468.8151233067817, 22.45423300556908,  /* hpluv */
    },
    {
        "#2211bb",
        0.13333333333333333, 0.06666666666666667, 0.7333333333333333,  /* rgb */
        0.09828798319869211, 0.04328497993331581, 0.47332814418655833,  /* xyz */
        24.72899833167773, -5.287966633162765, -92.77628886985751,  /* luv */
        24.72899833167773, 92.92686569327887, 266.73784410199124,  /* lch */
        266.73784410199124, 95.03021932462774, 24.72899833167773,  /* hsluv */
        266.73784410199124, 476.84154938086226, 24.72899833167773,  /* hpluv */
    },
    {
        "#2211cc",
        0.13333333333333333, 0.06666666666666667, 0.8,  /* rgb */
        0.11758035864241385, 0.05100193011080461, 0.5749346548568285,  /* xyz */
        27.018327990447567, -6.129618148315141, -102.65879478446217,  /* luv */
        27.018327990447567, 102.84162758942739, 266.583003116257,  /* lch */
        266.583003116257, 95.86861282494617, 27.018327990447567,  /* hsluv */
        266.583003116257, 483.00296665536007, 27.018327990447567,  /* hpluv */
    },
    {
        "#2211dd",
        0.13333333333333333, 0.06666666666666667, 0.8666666666666667,  /* rgb */
        0.13909868419304738, 0.05960926033105814, 0.6882645027568345,  /* xyz */
        29.313669578695368, -6.948481903749326, -112.47541494456678,  /* luv */
        29.313669578695368, 112.68984145751207, 266.4648863814945,  /* lch */
        266.4648863814945, 96.52287745826023, 29.313669578695368,  /* hsluv */
        266.4648863814945, 487.81360239373777, 29.313669578695368,  /* hpluv */
    },
    {
        "#2211ee",
        0.13333333333333333, 0.06666666666666667, 0.9333333333333333,  /* rgb */
        0.16291086445922215, 0.06913413243752818, 0.8136753188253577,  /* xyz */
        31.60897466085334, -7.747312318299307, -122.21832814306471,  /* luv */
        31.60897466085334, 122.46362963036461, 266.37292382155624,  /* lch */
        266.37292382155624, 97.04136632141098, 31.60897466085334,  /* hsluv */
        266.37292382155624, 491.6273612330594, 31.60897466085334,  /* hpluv */
    },
    {
        "#2211ff",
        0.13333333333333333, 0.06666666666666667, 1.0,  /* rgb */
        0.18908191286905351, 0.07960255180146088, 0.9515095071171396,  /* xyz */
        33.89997398893871, -8.52836196764118, -131.88314678985756,  /* luv */
        33.89997398893871, 132.1586068519422, 266.3000599479998,  /* lch */
        266.3000599479998, 99.99999999999957, 33.89997398893871,  /* hsluv */
        266.3000599479998, 494.692599475339, 33.89997398893871,  /* hpluv */
    },
    {
        "#222200",
        0.13333333333333333, 0.13333333333333333, 0.0,  /* rgb */
        0.012316748201991475, 0.014841483910263846, 0.002215896112402139,  /* xyz */
        12.50692880457581, 0.9919451286690638, 13.751917387057734,  /* luv */
        12.50692880457581, 13.787646171799997, 85.87432021817473,  /* lch */
        85.87432021817473, 100.00000000000236, 12.50692880457581,  /* hsluv */
        85.87432021817473, 139.88745807479762, 12.50692880457581,  /* hpluv */
    },
    {
        "#222211",
        0.13333333333333333, 0.13333333333333333, 0.06666666666666667,  /* rgb */
        0.013328413701628596, 0.0152461501101187, 0.0075440010771577705,  /* xyz */
        12.763697960436861, 0.6002664949000152, 8.321846652098685,  /* luv */
        12.763697960436861, 8.34346759842367, 85.87432021817298,  /* lch */
        85.87432021817298, 59.29671209632976, 12.763697960436861,  /* hsluv */
        85.87432021817298, 82.94866327348466, 12.763697960436861,  /* hpluv */
    },
    {
        "#222222",
        0.13333333333333333, 0.13333333333333333, 0.13333333333333333,  /* rgb */
        0.015203771840105615, 0.01599629336550952, 0.017420887273136967,  /* xyz */
        13.227910984271784, 6.538910930217203e-13, 2.1000881819675688e-13,  /* luv */
        13.227910984271784, 6.867876420361235e-13, 0.0,  /* lch */
        0.0, 1.88635445986832e-12, 13.227910984271784,  /* hsluv */
        0.0, 6.588257039283575e-12, 13.227910984271784,  /* hpluv */
    },
    {
        "#222233",
        0.13333333333333333, 0.13333333333333333, 0.2,  /* rgb */
        0.018291522572563355, 0.017231393658492633, 0.03368304113074811,  /* xyz */
        13.961585437622158, -0.7572885399777128, -10.49873540276157,  /* luv */
        13.961585437622158, 10.526012112380487, 265.8743202181809,  /* lch */
        265.8743202181809, 18.63381798230072, 13.961585437622158,  /* hsluv */
        265.8743202181809, 95.66838742797604, 13.961585437622158,  /* hpluv */
    },
    {
        "#222244",
        0.13333333333333333, 0.13333333333333333, 0.26666666666666666,  /* rgb */
        0.022749517816782236, 0.019014591756180206, 0.05716181608363475,  /* xyz */
        14.96138105067287, -1.5627399186581008, -21.665180500157145,  /* luv */
        14.96138105067287, 21.721468692465454, 265.8743202181792,  /* lch */
        265.8743202181792, 35.883122221591414, 14.96138105067287,  /* hsluv */
        265.8743202181792, 184.22850550979354, 14.96138105067287,  /* hpluv */
    },
    {
        "#222255",
        0.13333333333333333, 0.13333333333333333, 0.3333333333333333,  /* rgb */
        0.028711931856144228, 0.02139955737192504, 0.08856386335760866,  /* xyz */
        16.205218700597015, -2.360779611048027, -32.728873041368395,  /* luv */
        16.205218700597015, 32.813905755486516, 265.87432021817864,  /* lch */
        265.87432021817864, 50.04673522403931, 16.205218700597015,  /* hsluv */
        265.87432021817864, 256.9462929962491, 16.205218700597015,  /* hpluv */
    },
    {
        "#222266",
        0.13333333333333333, 0.13333333333333333, 0.4,  /* rgb */
        0.036296927629652406, 0.02443355568132835, 0.12851150776475262,  /* xyz */
        17.66047290862653, -3.1361212331465786, -43.477888915018994,  /* luv */
        17.66047290862653, 43.59084859114037, 265.87432021817835,  /* lch */
        265.87432021817835, 61.00504004829466, 17.66047290862653,  /* hsluv */
        265.87432021817835, 313.20762132287626, 17.66047290862653,  /* hpluv */
    },
    {
        "#222277",
        0.13333333333333333, 0.13333333333333333, 0.4666666666666667,  /* rgb */
        0.04561094064985432, 0.028159160889409167, 0.17756530967115053,  /* xyz */
        19.291048295138054, -3.8903622217551797, -53.93437432485479,  /* luv */
        19.291048295138054, 54.07450094110916, 265.87432021817824,  /* lch */
        265.87432021817824, 69.28024478972834, 19.291048295138054,  /* hsluv */
        265.87432021817824, 355.69357315525684, 19.291048295138054,  /* hpluv */
    },
    {
        "#222288",
        0.13333333333333333, 0.13333333333333333, 0.5333333333333333,  /* rgb */
        0.05675135775179815, 0.03261532773018676, 0.2362381730747227,  /* xyz */
        21.06226054873732, -4.628837962259935, -64.17229684926014,  /* luv */
        21.06226054873732, 64.33902255855634, 265.8743202181782,  /* lch */
        265.8743202181782, 75.49917391333777, 21.06226054873732,  /* hsluv */
        265.8743202181782, 387.6223448836144, 21.06226054873732,  /* hpluv */
    },
    {
        "#222299",
        0.13333333333333333, 0.13333333333333333, 0.6,  /* rgb */
        0.06980832186087085, 0.03783811337381592, 0.3050048507158406,  /* xyz */
        22.94345516266668, -5.356056895109844, -74.25415964370897,  /* luv */
        22.94345516266668, 74.44707898807764, 265.8743202181781,  /* lch */
        265.8743202181781, 80.19763537126136, 22.94345516266668,  /* hsluv */
        265.8743202181781, 411.7448425649297, 22.94345516266668,  /* hpluv */
    },
    {
        "#2222aa",
        0.13333333333333333, 0.13333333333333333, 0.6666666666666666,  /* rgb */
        0.08486601482612341, 0.043861190559917024, 0.3843087003328392,  /* xyz */
        24.90893070407632, -6.074916145376273, -84.22012725308447,  /* luv */
        24.90893070407632, 84.43893912585055, 265.87432021817807,  /* lch */
        265.87432021817807, 83.78386787419456, 24.90893070407632,  /* hsluv */
        265.87432021817807, 430.15701557334484, 24.90893070407632,  /* hpluv */
    },
    {
        "#2222bb",
        0.13333333333333333, 0.13333333333333333, 0.7333333333333333,  /* rgb */
        0.10200360693346006, 0.05071622740285178, 0.47456668543148095,  /* xyz */
        26.93785081359247, -6.787038846988041, -94.09270213548811,  /* luv */
        26.93785081359247, 94.33716389349541, 265.87432021817807,  /* lch */
        265.87432021817807, 86.5550863782758, 26.93785081359247,  /* hsluv */
        265.87432021817807, 444.384803230596, 26.93785081359247,  /* hpluv */
    },
    {
        "#2222cc",
        0.13333333333333333, 0.13333333333333333, 0.8,  /* rgb */
        0.12129598237718178, 0.058433177580340584, 0.5761731961017511,  /* xyz */
        29.01367702002741, -7.493248981434967, -103.88330762982127,  /* luv */
        29.01367702002741, 104.15320630883073, 265.874320218178,  /* lch */
        265.874320218178, 88.72430246588327, 29.01367702002741,  /* hsluv */
        265.874320218178, 455.52183404636264, 29.01367702002741,  /* hpluv */
    },
    {
        "#2222dd",
        0.13333333333333333, 0.13333333333333333, 0.8666666666666667,  /* rgb */
        0.14281430792781533, 0.06704050780059412, 0.6895030440017571,  /* xyz */
        31.12345099165983, -8.193928499738968, -113.59723894722784,  /* luv */
        31.12345099165983, 113.89237534046084, 265.874320218178,  /* lch */
        265.874320218178, 90.44397195026146, 31.12345099165983,  /* hsluv */
        265.874320218178, 464.35083552291655, 31.12345099165983,  /* hpluv */
    },
    {
        "#2222ee",
        0.13333333333333333, 0.13333333333333333, 0.9333333333333333,  /* rgb */
        0.16662648819399006, 0.07656537990706415, 0.8149138600702803,  /* xyz */
        33.25709590326295, -8.889239826311881, -123.23674787263907,  /* luv */
        33.25709590326295, 123.55692862366764, 265.874320218178,  /* lch */
        265.874320218178, 93.85466074677143, 33.25709590326295,  /* hsluv */
        265.874320218178, 471.43531020552064, 33.25709590326295,  /* hpluv */
    },
    {
        "#2222ff",
        0.13333333333333333, 0.13333333333333333, 1.0,  /* rgb */
        0.19279753660382146, 0.08703379927099686, 0.9527480483620622,  /* xyz */
        35.4068078244889, -9.579251194283923, -132.80278036197763,  /* luv */
        35.4068078244889, 133.14781457205694, 265.87432021817796,  /* lch */
        265.87432021817796, 99.99999999999953, 35.4068078244889,  /* hsluv */
        265.87432021817796, 477.18479321598784, 35.4068078244889,  /* hpluv */
    },
    {
        "#223300",
        0.13333333333333333, 0.2, 0.0,  /* rgb */
        0.018434470291002286, 0.027076928088285643, 0.00425513680873902,  /* xyz */
        18.83301924655329, -7.156343737687397, 21.759761244673133,  /* luv */
        18.83301924655329, 22.90634115517178, 108.20498582095573,  /* lch */
        108.20498582095573, 100.00000000000233, 18.83301924655329,  /* hsluv */
        108.20498582095573, 154.33879347084556, 18.83301924655329,  /* hpluv */
    },
    {
        "#223311",
        0.13333333333333333, 0.2, 0.06666666666666667,  /* rgb */
        0.019446135790639408, 0.027481594288140496, 0.009583241773494651,  /* xyz */
        19.005689033866958, -7.137310204832616, 17.016762502622566,  /* luv */
        19.005689033866958, 18.452951065633627, 112.75455130424638,  /* lch */
        112.75455130424638, 76.60345115769942, 19.005689033866958,  /* hsluv */
        112.75455130424638, 123.20307215670591, 19.005689033866958,  /* hpluv */
    },
    {
        "#223322",
        0.13333333333333333, 0.2, 0.13333333333333333,  /* rgb */
        0.021321493929116427, 0.028231737543531317, 0.01946012796947385,  /* xyz */
        19.32134167971845, -7.1171990402833725, 9.20359440474635,  /* luv */
        19.32134167971845, 11.634460543836523, 127.71501294923759,  /* lch */
        127.71501294923759, 38.90613854474444, 19.32134167971845,  /* hsluv */
        127.71501294923759, 76.40966523594051, 19.32134167971845,  /* hpluv */
    },
    {
        "#223333",
        0.13333333333333333, 0.2, 0.2,  /* rgb */
        0.024409244661574167, 0.02946683783651443, 0.03572228182708499,  /* xyz */
        19.829094590641837, -7.116171244581926, -1.535587374387584,  /* luv */
        19.829094590641837, 7.279967154224889, 192.17705063006068,  /* lch */
        192.17705063006068, 46.40476419050189, 19.829094590641837,  /* hsluv */
        192.17705063006068, 46.587119844904315, 19.829094590641837,  /* hpluv */
    },
    {
        "#223344",
        0.13333333333333333, 0.2, 0.26666666666666666,  /* rgb */
        0.028867239905793048, 0.031250035934202, 0.05920105677997163,  /* xyz */
        20.53772445178295, -7.160912107030383, -13.827218309168755,  /* luv */
        20.53772445178295, 15.571468407765082, 242.62102836437043,  /* lch */
        242.62102836437043, 54.47255680089802, 20.53772445178295,  /* hsluv */
        242.62102836437043, 96.20919320277382, 20.53772445178295,  /* hpluv */
    },
    {
        "#223355",
        0.13333333333333333, 0.2, 0.3333333333333333,  /* rgb */
        0.03482965394515504, 0.033635001549946836, 0.09060310405394553,  /* xyz */
        21.444537716767883, -7.270145296916048, -26.52136956442741,  /* luv */
        21.444537716767883, 27.499782839346334, 254.67041867671588,  /* lch */
        254.67041867671588, 62.10250477388626, 21.444537716767883,  /* hsluv */
        254.67041867671588, 162.72410902482622, 21.444537716767883,  /* hpluv */
    },
    {
        "#223366",
        0.13333333333333333, 0.2, 0.4,  /* rgb */
        0.04241464971866321, 0.03666899985935015, 0.1305507484610895,  /* xyz */
        22.538163137523668, -7.451062252635046, -38.958969537442265,  /* luv */
        22.538163137523668, 39.66509342119336, 259.17269839925314,  /* lch */
        259.17269839925314, 68.76229622853981, 22.538163137523668,  /* hsluv */
        259.17269839925314, 223.32085911019658, 22.538163137523668,  /* hpluv */
    },
    {
        "#223377",
        0.13333333333333333, 0.2, 0.4666666666666667,  /* rgb */
        0.05172866273886513, 0.040394605067430964, 0.1796045503674874,  /* xyz */
        23.801469915184775, -7.701801027216242, -50.88843891059725,  /* luv */
        23.801469915184775, 51.4679604591091, 261.39378290952305,  /* lch */
        261.39378290952305, 74.30666490791938, 23.801469915184775,  /* hsluv */
        261.39378290952305, 274.39267047672627, 23.801469915184775,  /* hpluv */
    },
    {
        "#223388",
        0.13333333333333333, 0.2, 0.5333333333333333,  /* rgb */
        0.06286907984080896, 0.04485077190820856, 0.23827741377105957,  /* xyz */
        25.214303338898695, -8.015484463352577, -62.28743760892072,  /* luv */
        25.214303338898695, 62.801057913600765, 262.66716896264103,  /* lch */
        262.66716896264103, 78.80601881030522, 25.214303338898695,  /* hsluv */
        262.66716896264103, 316.05256036840984, 25.214303338898695,  /* hpluv */
    },
    {
        "#223399",
        0.13333333333333333, 0.2, 0.6,  /* rgb */
        0.07592604394988167, 0.05007355755183772, 0.3070440914121775,  /* xyz */
        26.75571154739432, -8.383353273949531, -73.22675753141807,  /* luv */
        26.75571154739432, 73.70507873057957, 263.46893680057207,  /* lch */
        263.46893680057207, 82.41519434948141, 26.75571154739432,  /* hsluv */
        263.46893680057207, 349.5587967603508, 26.75571154739432,  /* hpluv */
    },
    {
        "#2233aa",
        0.13333333333333333, 0.2, 0.6666666666666666,  /* rgb */
        0.09098373691513421, 0.05609663473793882, 0.3863479410291761,  /* xyz */
        28.405516449270962, -8.796580687942445, -83.7974050699281,  /* luv */
        28.405516449270962, 84.25784787337672, 264.0073589347989,  /* lch */
        264.0073589347989, 85.30173546129521, 28.405516449270962,  /* hsluv */
        264.0073589347989, 376.3977328725345, 28.405516449270962,  /* hpluv */
    },
    {
        "#2233bb",
        0.13333333333333333, 0.2, 0.7333333333333333,  /* rgb */
        0.10812132902247086, 0.06295167158087359, 0.4766059261278178,  /* xyz */
        30.145257957832285, -9.247124843226816, -94.08068912091959,  /* luv */
        30.145257957832285, 94.53404351519795, 264.3864687864184,  /* lch */
        264.3864687864184, 87.61545895271036, 30.145257957832285,  /* hsluv */
        264.3864687864184, 397.9317175339432, 30.145257957832285,  /* hpluv */
    },
    {
        "#2233cc",
        0.13333333333333333, 0.2, 0.8,  /* rgb */
        0.1274137044661926, 0.07066862175836239, 0.578212436798088,  /* xyz */
        31.958640447146244, -9.728028216139556, -104.14012731755872,  /* luv */
        31.958640447146244, 104.59350195251781, 264.66332336850155,  /* lch */
        264.66332336850155, 89.4797268300864, 31.958640447146244,  /* hsluv */
        264.66332336850155, 415.2940748338267, 31.958640447146244,  /* hpluv */
    },
    {
        "#2233dd",
        0.13333333333333333, 0.2, 0.8666666666666667,  /* rgb */
        0.14893203001682614, 0.07927595197861592, 0.691542284698094,  /* xyz */
        33.83163588545103, -10.233440845943651, -114.02225907293298,  /* luv */
        33.83163588545103, 114.48056112564471, 264.87147297862515,  /* lch */
        264.87147297862515, 90.9921469937159, 33.83163588545103,  /* hsluv */
        264.87147297862515, 429.3861953908922, 33.83163588545103,  /* hpluv */
    },
    {
        "#2233ee",
        0.13333333333333333, 0.2, 0.9333333333333333,  /* rgb */
        0.17274421028300088, 0.08880082408508594, 0.8169531007666172,  /* xyz */
        35.75237931430022, -10.758523068267067, -123.76012668258095,  /* luv */
        35.75237931430022, 124.22686816908377, 265.03174206580775,  /* lch */
        265.03174206580775, 93.13438387578896, 35.75237931430022,  /* hsluv */
        265.03174206580775, 440.9099643149725, 35.75237931430022,  /* hpluv */
    },
    {
        "#2233ff",
        0.13333333333333333, 0.2, 1.0,  /* rgb */
        0.19891525869283228, 0.09926924344901865, 0.954787289058399,  /* xyz */
        37.710957335809454, -11.299307292881416, -133.37689755692725,  /* luv */
        37.710957335809454, 133.85466427140307, 265.15762875286134,  /* lch */
        265.15762875286134, 99.99999999999949, 37.710957335809454,  /* hsluv */
        265.15762875286134, 450.40715198371515, 37.710957335809454,  /* hpluv */
    },
    {
        "#224400",
        0.13333333333333333, 0.26666666666666666, 0.0,  /* rgb */
        0.02726704077396832, 0.04474206905421796, 0.007199326969727615,  /* xyz */
        25.18097996818706, -15.171364792442015, 29.775655148677316,  /* luv */
        25.18097996818706, 33.41795848340085, 116.99986360968968,  /* lch */
        116.99986360968968, 100.00000000000222, 25.18097996818706,  /* hsluv */
        116.99986360968968, 168.4017553608182, 25.18097996818706,  /* hpluv */
    },
    {
        "#224411",
        0.13333333333333333, 0.26666666666666666, 0.06666666666666667,  /* rgb */
        0.02827870627360544, 0.04514673525407281, 0.012527431934483246,  /* xyz */
        25.304760275593587, -15.001331626520624, 25.82326052610655,  /* luv */
        25.304760275593587, 29.864372331726994, 120.15329866305453,  /* lch */
        120.15329866305453, 85.50291453997673, 25.304760275593587,  /* hsluv */
        120.15329866305453, 149.75815832547036, 25.304760275593587,  /* hpluv */
    },
    {
        "#224422",
        0.13333333333333333, 0.26666666666666666, 0.13333333333333333,  /* rgb */
        0.03015406441208246, 0.04589687850946363, 0.022404318130462442,  /* xyz */
        25.532273550554038, -14.717013024860824, 19.03128154257535,  /* luv */
        25.532273550554038, 24.05785006035852, 127.71501294923928,  /* lch */
        127.71501294923928, 60.880257909801436, 25.532273550554038,  /* hsluv */
        127.71501294923928, 119.56571123129788, 25.532273550554038,  /* hpluv */
    },
    {
        "#224433",
        0.13333333333333333, 0.26666666666666666, 0.2,  /* rgb */
        0.0332418151445402, 0.047131978802446746, 0.03866647198807359,  /* xyz */
        25.901529931779734, -14.322212094754963, 9.124656256995781,  /* luv */
        25.901529931779734, 16.981905402382786, 147.49885932799384,  /* lch */
        147.49885932799384, 64.09678513773909, 25.901529931779734,  /* hsluv */
        147.49885932799384, 83.19559391461964, 25.901529931779734,  /* hpluv */
    },
    {
        "#224444",
        0.13333333333333333, 0.26666666666666666, 0.26666666666666666,  /* rgb */
        0.03769981038875908, 0.04891517690013432, 0.06214524694096023,  /* xyz */
        26.423438440277998, -13.876574673205438, -2.9944041726293897,  /* luv */
        26.423438440277998, 14.195977634883302, 192.177050630061,  /* lch */
        192.177050630061, 67.90660371653664, 26.423438440277998,  /* hsluv */
        192.177050630061, 68.17345461805488, 26.423438440277998,  /* hpluv */
    },
    {
        "#224455",
        0.13333333333333333, 0.26666666666666666, 0.3333333333333333,  /* rgb */
        0.04366222442812107, 0.05130014251587915, 0.09354729421493413,  /* xyz */
        27.102008984770798, -13.444491681129733, -16.282686031062852,  /* luv */
        27.102008984770798, 21.115876040319424, 230.45376819342172,  /* lch */
        230.45376819342172, 71.89531184333927, 27.102008984770798,  /* hsluv */
        230.45376819342172, 98.865995891455, 27.102008984770798,  /* hpluv */
    },
    {
        "#224466",
        0.13333333333333333, 0.26666666666666666, 0.4,  /* rgb */
        0.05124722020162925, 0.05433414082528246, 0.1334949386220781,  /* xyz */
        27.935501760142138, -13.076203846006663, -29.882832922422686,  /* luv */
        27.935501760142138, 32.61856542663623, 246.36665632587506,  /* lch */
        246.36665632587506, 75.73220807697354, 27.935501760142138,  /* hsluv */
        246.36665632587506, 148.16571016605366, 27.935501760142138,  /* hpluv */
    },
    {
        "#224477",
        0.13333333333333333, 0.26666666666666666, 0.4666666666666667,  /* rgb */
        0.060561233221831164, 0.05805974603336328, 0.182548740528476,  /* xyz */
        28.917581708600707, -12.801046649585434, -43.246825362194855,  /* luv */
        28.917581708600707, 45.101604175827745, 253.5112629308403,  /* lch */
        253.5112629308403, 79.21641021455814, 28.917581708600707,  /* hsluv */
        253.5112629308403, 197.91073163076092, 28.917581708600707,  /* hpluv */
    },
    {
        "#224488",
        0.13333333333333333, 0.26666666666666666, 0.5333333333333333,  /* rgb */
        0.07170165032377498, 0.06251591287414088, 0.24122160393204817,  /* xyz */
        30.03853707305222, -12.629924374395046, -56.10538596253954,  /* luv */
        30.03853707305222, 57.50938465771015, 257.31357801273,  /* lch */
        257.31357801273, 82.26242457278181, 30.03853707305222,  /* hsluv */
        257.31357801273, 242.94013543841632, 30.03853707305222,  /* hpluv */
    },
    {
        "#224499",
        0.13333333333333333, 0.26666666666666666, 0.6,  /* rgb */
        0.08475861443284771, 0.06773869851777004, 0.3099882815731661,  /* xyz */
        31.28647479855062, -12.56129934373172, -68.37827658072307,  /* luv */
        31.28647479855062, 69.52247801504701, 259.59064804278853,  /* lch */
        259.59064804278853, 84.86260398880728, 31.28647479855062,  /* hsluv */
        259.59064804278853, 281.9732682818117, 31.28647479855062,  /* hpluv */
    },
    {
        "#2244aa",
        0.13333333333333333, 0.26666666666666666, 0.6666666666666666,  /* rgb */
        0.09981630739810024, 0.07376177570387113, 0.3892921311901647,  /* xyz */
        32.64838681667923, -12.586855023029132, -80.08890951546704,  /* luv */
        32.64838681667923, 81.07195783220867, 261.0683941074272,  /* lch */
        261.0683941074272, 87.05158458495707, 32.64838681667923,  /* hsluv */
        261.0683941074272, 315.09989632202877, 32.64838681667923,  /* hpluv */
    },
    {
        "#2244bb",
        0.13333333333333333, 0.26666666666666666, 0.7333333333333333,  /* rgb */
        0.11695389950543689, 0.08061681254680589, 0.47955011628880645,  /* xyz */
        34.11101469725783, -12.695478544937645, -91.30532179409143,  /* luv */
        34.11101469725783, 92.183713113584, 262.0841052976103,  /* lch */
        262.0841052976103, 88.88149018965741, 34.11101469725783,  /* hsluv */
        262.0841052976103, 342.92479311677835, 34.11101469725783,  /* hpluv */
    },
    {
        "#2244cc",
        0.13333333333333333, 0.26666666666666666, 0.8,  /* rgb */
        0.13624627494915864, 0.08833376272429469, 0.5811566269590765,  /* xyz */
        35.661486618305844, -12.875606592693158, -102.10654419102904,  /* luv */
        35.661486618305844, 102.91514763028992, 262.81295215281307,  /* lch */
        262.81295215281307, 90.40756805410165, 35.661486618305844,  /* hsluv */
        262.81295215281307, 366.2007119183045, 35.661486618305844,  /* hpluv */
    },
    {
        "#2244dd",
        0.13333333333333333, 0.26666666666666666, 0.8666666666666667,  /* rgb */
        0.15776460049979218, 0.09694109294454822, 0.6944864748590825,  /* xyz */
        37.287738956963246, -13.11641259137085, -112.5664659599276,  /* luv */
        37.287738956963246, 113.32806156453313, 263.35378127691297,  /* lch */
        263.35378127691297, 91.68112273117164, 37.287738956963246,  /* hsluv */
        263.35378127691297, 385.66545284552143, 37.287738956963246,  /* hpluv */
    },
    {
        "#2244ee",
        0.13333333333333333, 0.26666666666666666, 0.9333333333333333,  /* rgb */
        0.18157678076596692, 0.10646596505101827, 0.8198972909276058,  /* xyz */
        38.97875752493736, -13.40829568866802, -122.74779147325674,  /* luv */
        38.97875752493736, 123.4779442039625, 263.76603971616106,  /* lch */
        263.76603971616106, 92.74676471411152, 38.97875752493736,  /* hsluv */
        263.76603971616106, 401.9765562140661, 38.97875752493736,  /* hpluv */
    },
    {
        "#2244ff",
        0.13333333333333333, 0.26666666666666666, 1.0,  /* rgb */
        0.20774782917579832, 0.11693438441495096, 0.9577314792193876,  /* xyz */
        40.72468163852653, -13.742993874554235, -132.70107234012357,  /* luv */
        40.72468163852653, 133.4108109594374, 264.0873242876581,  /* lch */
        264.0873242876581, 99.99999999999942, 40.72468163852653,  /* hsluv */
        264.0873242876581, 415.69294386835355, 40.72468163852653,  /* hpluv */
    },
    {
        "#225500",
        0.13333333333333333, 0.3333333333333333, 0.0,  /* rgb */
        0.039080297488314285, 0.06836858248291022, 0.011137079207842824,  /* xyz */
        31.432590908454188, -22.663744399171232, 37.621114345944754,  /* luv */
        31.432590908454188, 43.92030913850238, 121.06563700997525,  /* lch */
        121.06563700997525, 100.00000000000237, 31.432590908454188,  /* hsluv */
        121.06563700997525, 177.30645000122325, 31.432590908454188,  /* hpluv */
    },
    {
        "#225511",
        0.13333333333333333, 0.3333333333333333, 0.06666666666666667,  /* rgb */
        0.04009196298795141, 0.06877324868276508, 0.016465184172598457,  /* xyz */
        31.525989659093504, -22.452213479362328, 34.33896823668757,  /* luv */
        31.525989659093504, 41.027632513747335, 123.17829094781541,  /* lch */
        123.17829094781541, 90.39125330031739, 31.525989659093504,  /* hsluv */
        123.17829094781541, 165.13801296773522, 31.525989659093504,  /* hpluv */
    },
    {
        "#225522",
        0.13333333333333333, 0.3333333333333333, 0.13333333333333333,  /* rgb */
        0.041967321126428425, 0.06952339193815589, 0.02634207036857765,  /* xyz */
        31.69816153824147, -22.084447387715933, 28.558467349170648,  /* luv */
        31.69816153824147, 36.10136941660855, 127.71501294923979,  /* lch */
        127.71501294923979, 73.58660391747983, 31.69816153824147,  /* hsluv */
        127.71501294923979, 144.5203245939742, 31.69816153824147,  /* hpluv */
    },
    {
        "#225533",
        0.13333333333333333, 0.3333333333333333, 0.2,  /* rgb */
        0.045055071858886166, 0.070758492231139, 0.0426042242261888,  /* xyz */
        31.978961771341183, -21.540202891740883, 19.807002548917623,  /* luv */
        31.978961771341183, 29.26256466187117, 137.40033058427107,  /* lch */
        137.40033058427107, 75.0932106461487, 31.978961771341183,  /* hsluv */
        137.40033058427107, 116.11473973097497, 31.978961771341183,  /* hpluv */
    },
    {
        "#225544",
        0.13333333333333333, 0.3333333333333333, 0.26666666666666666,  /* rgb */
        0.049513067103105046, 0.07254169032882658, 0.06608299917907544,  /* xyz */
        32.37866496262278, -20.86715498078058, 8.586922784905862,  /* luv */
        32.37866496262278, 22.564870925973658, 157.63262615513344,  /* lch */
        157.63262615513344, 76.98826790055475, 32.37866496262278,  /* hsluv */
        157.63262615513344, 88.43277274321375, 32.37866496262278,  /* hpluv */
    },
    {
        "#225555",
        0.13333333333333333, 0.3333333333333333, 0.3333333333333333,  /* rgb */
        0.05547548114246704, 0.07492665594457142, 0.09748504645304934,  /* xyz */
        32.903143054214986, -20.13121799238332, -4.344083794173134,  /* luv */
        32.903143054214986, 20.594586712717874, 192.17705063006113,  /* lch */
        192.17705063006113, 79.11370619336392, 32.903143054214986,  /* hsluv */
        192.17705063006113, 79.42459736837063, 32.903143054214986,  /* hpluv */
    },
    {
        "#225566",
        0.13333333333333333, 0.3333333333333333, 0.4,  /* rgb */
        0.06306047691597522, 0.07796065425397473, 0.1374326908601933,  /* xyz */
        33.5545056011551, -19.398136743372234, -18.20188033649937,  /* luv */
        33.5545056011551, 26.600679632272755, 223.17773137319895,  /* lch */
        223.17773137319895, 81.30977948017201, 33.5545056011551,  /* hsluv */
        223.17773137319895, 100.59611647431299, 33.5545056011551,  /* hpluv */
    },
    {
        "#225577",
        0.13333333333333333, 0.3333333333333333, 0.4666666666666667,  /* rgb */
        0.07237448993617712, 0.08168625946205554, 0.1864864927665912,  /* xyz */
        34.3316296590174, -18.720625795111705, -32.33641371342451,  /* luv */
        34.3316296590174, 37.36449493846198, 239.93202209407326,  /* lch */
        239.93202209407326, 83.44697526024423, 34.3316296590174,  /* hsluv */
        239.93202209407326, 138.10328963843835, 34.3316296590174,  /* hpluv */
    },
    {
        "#225588",
        0.13333333333333333, 0.3333333333333333, 0.5333333333333333,  /* rgb */
        0.08351490703812095, 0.08614242630283314, 0.24515935617016338,  /* xyz */
        35.230707776085, -18.133381004015288, -46.29657736973878,  /* luv */
        35.230707776085, 49.72114824487656, 248.61078181129238,  /* lch */
        248.61078181129238, 85.43856011396132, 35.230707776085,  /* hsluv */
        248.61078181129238, 179.0849573934319, 35.230707776085,  /* hpluv */
    },
    {
        "#225599",
        0.13333333333333333, 0.3333333333333333, 0.6,  /* rgb */
        0.09657187114719368, 0.0913652119464623, 0.3139260338112813,  /* xyz */
        36.24582738640965, -17.65418191004996, -59.8211858126123,  /* luv */
        36.24582738640965, 62.371823854527634, 253.55783305774702,  /* lch */
        253.55783305774702, 87.23815835864258, 36.24582738640965,  /* hsluv */
        253.55783305774702, 218.35832406203005, 36.24582738640965,  /* hpluv */
    },
    {
        "#2255aa",
        0.13333333333333333, 0.3333333333333333, 0.6666666666666666,  /* rgb */
        0.1116295641124462, 0.0973882891325634, 0.3932298834282799,  /* xyz */
        37.36955332949059, -17.287923374510413, -72.79432343528418,  /* luv */
        37.36955332949059, 74.8190204360075, 256.64032429261795,  /* lch */
        256.64032429261795, 88.83013082702088, 37.36955332949059,  /* hsluv */
        256.64032429261795, 254.05832916562915, 37.36955332949059,  /* hpluv */
    },
    {
        "#2255bb",
        0.13333333333333333, 0.3333333333333333, 0.7333333333333333,  /* rgb */
        0.12876715621978285, 0.10424332597549815, 0.48348786852692166,  /* xyz */
        38.59347542222313, -17.0311035792378, -85.19487452251968,  /* luv */
        38.59347542222313, 86.8805221786483, 258.6951576855825,  /* lch */
        258.6951576855825, 90.21881934962349, 38.59347542222313,  /* hsluv */
        258.6951576855825, 285.65896581598247, 38.59347542222313,  /* hpluv */
    },
    {
        "#2255cc",
        0.13333333333333333, 0.3333333333333333, 0.8,  /* rgb */
        0.1480595316635046, 0.11196027615298695, 0.5850943791971918,  /* xyz */
        39.90868911965341, -16.875529503911846, -97.0550695930042,  /* luv */
        39.90868911965341, 98.5112685419302, 260.136263381096,  /* lch */
        260.136263381096, 91.41968857103144, 39.90868911965341,  /* hsluv */
        260.136263381096, 313.22597901471056, 39.90868911965341,  /* hpluv */
    },
    {
        "#2255dd",
        0.13333333333333333, 0.3333333333333333, 0.8666666666666667,  /* rgb */
        0.16957785721413815, 0.12056760637324049, 0.6984242270971978,  /* xyz */
        41.30619002390285, -16.810917642428674, -108.43182396295298,  /* luv */
        41.30619002390285, 109.72724091998916, 261.1872107759653,  /* lch */
        261.1872107759653, 92.45314717055624, 41.30619002390285,  /* hsluv */
        261.1872107759653, 337.0843943807026, 41.30619002390285,  /* hpluv */
    },
    {
        "#2255ee",
        0.13333333333333333, 0.3333333333333333, 0.9333333333333333,  /* rgb */
        0.1933900374803129, 0.13009247847971053, 0.823835043165721,  /* xyz */
        42.77717631258416, -16.826518686346297, -119.3892569658224,  /* luv */
        42.77717631258416, 120.56917686520521, 261.9776693432476,  /* lch */
        261.9776693432476, 93.3407272081067, 42.77717631258416,  /* hsluv */
        261.9776693432476, 357.6543476741586, 42.77717631258416,  /* hpluv */
    },
    {
        "#2255ff",
        0.13333333333333333, 0.3333333333333333, 1.0,  /* rgb */
        0.21956108589014428, 0.14056089784364323, 0.9616692314575028,  /* xyz */
        44.31326373229641, -16.9120289519133, -129.98922900723832,  /* luv */
        44.31326373229641, 131.08476792200764, 262.58726709658106,  /* lch */
        262.58726709658106, 99.99999999999935, 44.31326373229641,  /* hsluv */
        262.58726709658106, 375.36849442185496, 44.31326373229641,  /* hpluv */
    },
    {
        "#226600",
        0.13333333333333333, 0.4, 0.0,  /* rgb */
        0.054108355194160754, 0.09842469789460356, 0.01614643177645817,  /* xyz */
        37.55820575748815, -29.663041903907743, 45.26685050400008,  /* luv */
        37.55820575748815, 54.120086932159296, 123.23653745232711,  /* lch */
        123.23653745232711, 100.00000000000229, 37.55820575748815,  /* hsluv */
        123.23653745232711, 182.84916238126746, 37.55820575748815,  /* hpluv */
    },
    {
        "#226611",
        0.13333333333333333, 0.4, 0.06666666666666667,  /* rgb */
        0.05512002069379787, 0.09882936409445842, 0.0214745367412138,  /* xyz */
        37.63150565447295, -29.45072124273942, 42.515572516083324,  /* luv */
        37.63150565447295, 51.71961801954731, 124.71051329206442,  /* lch */
        124.71051329206442, 93.27569242701699, 37.63150565447295,  /* hsluv */
        124.71051329206442, 174.3986184486089, 37.63150565447295,  /* hpluv */
    },
    {
        "#226622",
        0.13333333333333333, 0.4, 0.13333333333333333,  /* rgb */
        0.056995378832274894, 0.09957950734984923, 0.031351422937193,  /* xyz */
        37.766856622296906, -29.074063867003993, 37.59707857192632,  /* luv */
        37.766856622296906, 47.52727119124585, 127.71501294924003,  /* lch */
        127.71501294924003, 81.30948282825818, 37.766856622296906,  /* hsluv */
        127.71501294924003, 159.68766358732287, 37.766856622296906,  /* hpluv */
    },
    {
        "#226633",
        0.13333333333333333, 0.4, 0.2,  /* rgb */
        0.060083129564732635, 0.10081460764283234, 0.047613576794804144,  /* xyz */
        37.98823678514311, -28.497993426715972, 29.972642364247125,  /* luv */
        37.98823678514311, 41.358130030795735, 133.55528758817354,  /* lch */
        133.55528758817354, 82.07666423753967, 37.98823678514311,  /* hsluv */
        133.55528758817354, 138.1500621019894, 37.98823678514311,  /* hpluv */
    },
    {
        "#226644",
        0.13333333333333333, 0.4, 0.26666666666666666,  /* rgb */
        0.06454112480895151, 0.10259780574051992, 0.07109235174769078,  /* xyz */
        38.30469098921538, -27.75155720527339, 19.88334888736174,  /* luv */
        38.30469098921538, 34.13936862764323, 144.37927780106662,  /* lch */
        144.37927780106662, 83.07940735384244, 38.30469098921538,  /* hsluv */
        144.37927780106662, 113.09485507153263, 38.30469098921538,  /* hpluv */
    },
    {
        "#226655",
        0.13333333333333333, 0.4, 0.3333333333333333,  /* rgb */
        0.07050353884831351, 0.10498277135626476, 0.10249439902166468,  /* xyz */
        38.72225685925552, -26.885735771514973, 7.8221119171527675,  /* luv */
        38.72225685925552, 28.000503974396302, 163.7782207859703,  /* lch */
        163.7782207859703, 84.25736785003508, 38.72225685925552,  /* hsluv */
        163.7782207859703, 91.75812134055745, 38.72225685925552,  /* hpluv */
    },
    {
        "#226666",
        0.13333333333333333, 0.4, 0.4,  /* rgb */
        0.07808853462182168, 0.10801676966566807, 0.14244204342880865,  /* xyz */
        39.244415665565974, -25.9608324434988, -5.602047106325896,  /* luv */
        39.244415665565974, 26.558383854084838, 192.1770506300611,  /* lch */
        192.1770506300611, 85.53814175002717, 39.244415665565974,  /* hsluv */
        192.1770506300611, 85.87427887058577, 39.244415665565974,  /* hpluv */
    },
    {
        "#226677",
        0.13333333333333333, 0.4, 0.4666666666666667,  /* rgb */
        0.0874025476420236, 0.11174237487374888, 0.19149584533520655,  /* xyz */
        39.872395036163745, -25.034725973132506, -19.789597634593306,  /* luv */
        39.872395036163745, 31.911842301705747, 218.32587296711188,  /* lch */
        218.32587296711188, 86.85169143973361, 39.872395036163745,  /* hsluv */
        218.32587296711188, 101.55910857369226, 39.872395036163745,  /* hpluv */
    },
    {
        "#226688",
        0.13333333333333333, 0.4, 0.5333333333333333,  /* rgb */
        0.09854296474396743, 0.11619854171452648, 0.2501687087387787,  /* xyz */
        40.605445809468684, -24.15490675615749, -34.236154547747624,  /* luv */
        40.605445809468684, 41.89956800034963, 234.7955790683381,  /* lch */
        234.7955790683381, 88.14013864652517, 40.605445809468684,  /* hsluv */
        234.7955790683381, 130.93766405294994, 40.605445809468684,  /* hpluv */
    },
    {
        "#226699",
        0.13333333333333333, 0.4, 0.6,  /* rgb */
        0.11159992885304014, 0.12142132735815564, 0.31893538637989666,  /* xyz */
        41.44113084612182, -23.355114257628575, -48.56986398268603,  /* luv */
        41.44113084612182, 53.89334884086818, 244.31914273028605,  /* lch */
        244.31914273028605, 89.36193831815493, 41.44113084612182,  /* hsluv */
        244.31914273028605, 165.02240013687677, 41.44113084612182,  /* hpluv */
    },
    {
        "#2266aa",
        0.13333333333333333, 0.4, 0.6666666666666666,  /* rgb */
        0.12665762181829268, 0.12744440454425673, 0.39823923599689526,  /* xyz */
        42.37562992965456, -22.655631138578233, -62.55047552453862,  /* luv */
        42.37562992965456, 66.52698407889253, 250.08973551644033,  /* lch */
        250.08973551644033, 90.49158992102106, 42.37562992965456,  /* hsluv */
        250.08973551644033, 199.21452258752655, 42.37562992965456,  /* hpluv */
    },
    {
        "#2266bb",
        0.13333333333333333, 0.4, 0.7333333333333333,  /* rgb */
        0.14379521392562933, 0.1342994413871915, 0.488497221095537,  /* xyz */
        43.40405041245926, -22.065631126334228, -76.04687264320178,  /* luv */
        43.40405041245926, 79.18345102238726, 253.81947513499924,  /* lch */
        253.81947513499924, 91.51684259094769, 43.40405041245926,  /* hsluv */
        253.81947513499924, 231.49600081451757, 43.40405041245926,  /* hpluv */
    },
    {
        "#2266cc",
        0.13333333333333333, 0.4, 0.8,  /* rgb */
        0.16308758936935108, 0.1420163915646803, 0.5901037317658071,  /* xyz */
        44.520728505208055, -21.586185119490256, -89.00761945025532,  /* luv */
        44.520728505208055, 91.5877705166709, 256.36778848430697,  /* lch */
        256.36778848430697, 92.43509558526695, 44.520728505208055,  /* hsluv */
        256.36778848430697, 261.0445025277323, 44.520728505208055,  /* hpluv */
    },
    {
        "#2266dd",
        0.13333333333333333, 0.4, 0.8666666666666667,  /* rgb */
        0.18460591491998463, 0.15062372178493383, 0.7034335796658131,  /* xyz */
        45.71950685887922, -21.21306545895978, -101.43346030833774,  /* luv */
        45.71950685887922, 103.6278969017959, 258.1878164043369,  /* lch */
        258.1878164043369, 93.25004135256107, 45.71950685887922,  /* hsluv */
        258.1878164043369, 287.61694800396185, 45.71950685887922,  /* hpluv */
    },
    {
        "#2266ee",
        0.13333333333333333, 0.4, 0.9333333333333333,  /* rgb */
        0.20841809518615934, 0.16014859389140387, 0.8288443957343363,  /* xyz */
        46.993977723718714, -20.938977171432168, -113.35559709460216,  /* luv */
        46.993977723718714, 115.27329334091021, 259.5343281456166,  /* lch */
        259.5343281456166, 93.96900202390752, 46.993977723718714,  /* hsluv */
        259.5343281456166, 311.2617973417275, 46.993977723718714,  /* hpluv */
    },
    {
        "#2266ff",
        0.13333333333333333, 0.4, 1.0,  /* rgb */
        0.23458914359599076, 0.17061701325533657, 0.9666785840261182,  /* xyz */
        48.33768562433647, -20.75515631493003, -124.82033028859883,  /* luv */
        48.33768562433647, 126.53415099099564, 260.5592205421562,  /* lch */
        260.5592205421562, 99.99999999999922, 48.33768562433647,  /* hsluv */
        260.5592205421562, 332.17062917747086, 48.33768562433647,  /* hpluv */
    },
    {
        "#227700",
        0.13333333333333333, 0.4666666666666667, 0.0,  /* rgb */
        0.07256209324757838, 0.13533217400143932, 0.022297677794263875,  /* xyz */
        43.55592971526923, -36.26136953799537, 52.72196476870803,  /* luv */
        43.55592971526923, 63.98822149305252, 124.51960467688598,  /* lch */
        124.51960467688598, 100.00000000000233, 43.55592971526923,  /* hsluv */
        124.51960467688598, 186.41981713240338, 43.55592971526923,  /* hpluv */
    },
    {
        "#227711",
        0.13333333333333333, 0.4666666666666667, 0.06666666666666667,  /* rgb */
        0.0735737587472155, 0.13573684020129417, 0.02762578275901951,  /* xyz */
        43.61523143086028, -36.06230239873363, 50.38663833353782,  /* luv */
        43.61523143086028, 61.96210920274141, 125.59173877958986,  /* lch */
        125.59173877958986, 95.08678880928053, 43.61523143086028,  /* hsluv */
        125.59173877958986, 180.27161026532096, 43.61523143086028,  /* hpluv */
    },
    {
        "#227722",
        0.13333333333333333, 0.4666666666666667, 0.13333333333333333,  /* rgb */
        0.07544911688569253, 0.136486983456685, 0.0375026689549987,  /* xyz */
        43.724850000605606, -35.70484019747773, 46.17165623778231,  /* luv */
        43.724850000605606, 58.36657822133625, 127.71501294924015,  /* lch */
        127.71501294924015, 86.24721168031112, 43.724850000605606,  /* hsluv */
        127.71501294924015, 169.38511038424235, 43.724850000605606,  /* hpluv */
    },
    {
        "#227733",
        0.13333333333333333, 0.4666666666666667, 0.2,  /* rgb */
        0.07853686761815026, 0.1377220837496681, 0.053764822812609844,  /* xyz */
        43.9044636679785, -35.14704988045475, 39.53581754161684,  /* luv */
        43.9044636679785, 52.89986752330474, 131.63685913347058,  /* lch */
        131.63685913347058, 86.66713702304672, 43.9044636679785,  /* hsluv */
        131.63685913347058, 152.89216650654788, 43.9044636679785,  /* hpluv */
    },
    {
        "#227744",
        0.13333333333333333, 0.4666666666666667, 0.26666666666666666,  /* rgb */
        0.08299486286236914, 0.1395052818473557, 0.07724359776549648,  /* xyz */
        44.16189945488562, -34.403210499316, 30.563810788911994,  /* luv */
        44.16189945488562, 46.01877250210679, 138.38211345802048,  /* lch */
        138.38211345802048, 87.23008306084297, 44.16189945488562,  /* hsluv */
        138.38211345802048, 132.2289691041568, 44.16189945488562,  /* hpluv */
    },
    {
        "#227755",
        0.13333333333333333, 0.4666666666666667, 0.3333333333333333,  /* rgb */
        0.08895727690173114, 0.14189024746310053, 0.1086456450394704,  /* xyz */
        44.50280429631962, -33.50808683045339, 19.553757062195874,  /* luv */
        44.50280429631962, 38.79615056013391, 149.7341572603126,  /* lch */
        149.7341572603126, 87.91266744993872, 44.50280429631962,  /* hsluv */
        149.7341572603126, 110.62176517163955, 44.50280429631962,  /* hpluv */
    },
    {
        "#227766",
        0.13333333333333333, 0.4666666666666667, 0.4,  /* rgb */
        0.09654227267523931, 0.14492424577250382, 0.14859328944661435,  /* xyz */
        44.931004632423566, -32.509255214309825, 6.940389744174022,  /* luv */
        44.931004632423566, 33.24185139835275, 167.9488583301937,  /* lch */
        167.9488583301937, 88.68226057958208, 44.931004632423566,  /* hsluv */
        167.9488583301937, 93.8811500215461, 44.931004632423566,  /* hpluv */
    },
    {
        "#227777",
        0.13333333333333333, 0.4666666666666667, 0.4666666666666667,  /* rgb */
        0.10585628569544123, 0.14864985098058464, 0.19764709135301226,  /* xyz */
        45.448716389667865, -31.458637790652514, -6.788409855024273,  /* luv */
        45.448716389667865, 32.18273450164329, 192.17705063006122,  /* lch */
        192.17705063006122, 89.5029511213474, 45.448716389667865,  /* hsluv */
        192.17705063006122, 89.8546686552558, 45.448716389667865,  /* hpluv */
    },
    {
        "#227788",
        0.13333333333333333, 0.4666666666666667, 0.5333333333333333,  /* rgb */
        0.11699670279738505, 0.15310601782136224, 0.2563199547565844,  /* xyz */
        46.05670936903804, -30.40514073290186, -21.164067647228965,  /* luv */
        46.05670936903804, 37.04578710682298, 214.84056951333662,  /* lch */
        214.84056951333662, 90.34072866357114, 46.05670936903804,  /* hsluv */
        214.84056951333662, 102.06697593824232, 46.05670936903804,  /* hpluv */
    },
    {
        "#227799",
        0.13333333333333333, 0.4666666666666667, 0.6,  /* rgb */
        0.13005366690645775, 0.1583288034649914, 0.32508663239770236,  /* xyz */
        46.75446514689912, -29.389696925283317, -35.78643080069912,  /* luv */
        46.75446514689912, 46.30791417040109, 230.60536243702668,  /* lch */
        230.60536243702668, 91.1669787694701, 46.75446514689912,  /* hsluv */
        230.60536243702668, 125.68152826077919, 46.75446514689912,  /* hpluv */
    },
    {
        "#2277aa",
        0.13333333333333333, 0.4666666666666667, 0.6666666666666666,  /* rgb */
        0.1451113598717103, 0.1643518806510925, 0.40439048201470096,  /* xyz */
        47.54034207531711, -28.443001792596778, -50.34683650079619,  /* luv */
        47.54034207531711, 57.82567160536544, 240.5361059315515,  /* lch */
        240.5361059315515, 91.96009079280714, 47.54034207531711,  /* hsluv */
        240.5361059315515, 154.34682835185214, 47.54034207531711,  /* hpluv */
    },
    {
        "#2277bb",
        0.13333333333333333, 0.4666666666666667, 0.7333333333333333,  /* rgb */
        0.16224895197904696, 0.17120691749402725, 0.4946484671133427,  /* xyz */
        48.411749001613316, -27.585445887711224, -64.62995611033703,  /* luv */
        48.411749001613316, 70.27081934663872, 246.88617520870923,  /* lch */
        246.88617520870923, 92.70552709607544, 48.411749001613316,  /* hsluv */
        246.88617520870923, 184.18894949516144, 48.411749001613316,  /* hpluv */
    },
    {
        "#2277cc",
        0.13333333333333333, 0.4666666666666667, 0.8,  /* rgb */
        0.18154132742276868, 0.17892386767151605, 0.5962549777836128,  /* xyz */
        49.365323522494535, -26.828422395179114, -78.5023488607078,  /* luv */
        49.365323522494535, 82.96012912756596, 251.13197711383708,  /* lch */
        251.13197711383708, 93.39492944548833, 49.365323522494535,  /* hsluv */
        251.13197711383708, 213.24887971212215, 49.365323522494535,  /* hpluv */
    },
    {
        "#2277dd",
        0.13333333333333333, 0.4666666666666667, 0.8666666666666667,  /* rgb */
        0.20305965297340223, 0.18753119789176959, 0.7095848256836188,  /* xyz */
        50.39710823706929, -26.17623666949642, -91.89516871188209,  /* luv */
        50.39710823706929, 95.55060124752102, 254.1004560177625,  /* lch */
        254.1004560177625, 94.02480361144724, 50.39710823706929,  /* hsluv */
        254.1004560177625, 240.58421708319756, 50.39710823706929,  /* hpluv */
    },
    {
        "#2277ee",
        0.13333333333333333, 0.4666666666666667, 0.9333333333333333,  /* rgb */
        0.226871833239577, 0.19705606999823963, 0.834995641752142,  /* xyz */
        51.502718239759645, -25.628071593350626, -104.78627031451263,  /* luv */
        51.502718239759645, 107.87474449573457, 256.2566891123157,  /* lch */
        256.2566891123157, 94.59516422289336, 51.502718239759645,  /* hsluv */
        256.2566891123157, 265.7840748640267, 51.502718239759645,  /* hpluv */
    },
    {
        "#2277ff",
        0.13333333333333333, 0.4666666666666667, 1.0,  /* rgb */
        0.25304288164940836, 0.20752448936217233, 0.9728298300439239,  /* xyz */
        52.67749414095594, -25.179707834773232, -117.18459053564186,  /* luv */
        52.67749414095594, 119.85927559288261, 257.8731202645589,  /* lch */
        257.8731202645589, 99.99999999999902, 52.67749414095594,  /* hsluv */
        257.8731202645589, 288.72598233235385, 52.67749414095594,  /* hpluv */
    },
    {
        "#228800",
        0.13333333333333333, 0.5333333333333333, 0.0,  /* rgb */
        0.09463446297254884, 0.17947691345138087, 0.02965513436925382,  /* xyz */
        49.432601362665295, -42.541162511288285, 60.00406832893655,  /* luv */
        49.432601362665295, 73.55432498388879, 125.33554659214116,  /* lch */
        125.33554659214116, 100.00000000000236, 49.432601362665295,  /* hsluv */
        125.33554659214116, 188.81394887832684, 49.432601362665295,  /* hpluv */
    },
    {
        "#228811",
        0.13333333333333333, 0.5333333333333333, 0.06666666666666667,  /* rgb */
        0.09564612847218595, 0.17988157965123572, 0.03498323933400945,  /* xyz */
        49.48174136306277, -42.35922380102784, 57.99689097386828,  /* luv */
        49.48174136306277, 71.8188220709608, 126.14329358817663,  /* lch */
        126.14329358817663, 96.28392398677538, 49.48174136306277,  /* hsluv */
        126.14329358817663, 184.17582732442042, 49.48174136306277,  /* hpluv */
    },
    {
        "#228822",
        0.13333333333333333, 0.5333333333333333, 0.13333333333333333,  /* rgb */
        0.09752148661066298, 0.18063172290662655, 0.04486012552998865,  /* xyz */
        49.57263924405629, -42.029933363425855, 54.35094021482495,  /* luv */
        49.57263924405629, 68.70618604441302, 127.71501294924023,  /* lch */
        127.71501294924023, 89.549457305464, 49.57263924405629,  /* hsluv */
        127.71501294924023, 175.87055181283887, 49.57263924405629,  /* hpluv */
    },
    {
        "#228833",
        0.13333333333333333, 0.5333333333333333, 0.2,  /* rgb */
        0.10060923734312072, 0.18186682319960965, 0.061122279387599794,  /* xyz */
        49.72175460266689, -41.509310794955155, 48.550239771015136,  /* luv */
        49.72175460266689, 63.87604139656151, 130.5296624430732,  /* lch */
        130.5296624430732, 89.79372389443621, 49.72175460266689,  /* hsluv */
        130.5296624430732, 163.01624095696096, 49.72175460266689,  /* hpluv */
    },
    {
        "#228844",
        0.13333333333333333, 0.5333333333333333, 0.26666666666666666,  /* rgb */
        0.10506723258733959, 0.18365002129729724, 0.08460105434048643,  /* xyz */
        49.93585623286302, -40.80167889050528, 40.58915799061863,  /* luv */
        49.93585623286302, 57.552208877429756, 135.14960557497136,  /* lch */
        135.14960557497136, 90.12690169182366, 49.93585623286302,  /* hsluv */
        135.14960557497136, 146.24762506013977, 49.93585623286302,  /* hpluv */
    },
    {
        "#228855",
        0.13333333333333333, 0.5333333333333333, 0.3333333333333333,  /* rgb */
        0.11102964662670159, 0.18603498691304207, 0.11600310161446034,  /* xyz */
        50.22005420521937, -39.928822774300144, 30.634166925496476,  /* luv */
        50.22005420521937, 50.32656427137315, 142.50388056930635,  /* lch */
        142.50388056930635, 90.53993528658243, 50.22005420521937,  /* hsluv */
        142.50388056930635, 127.16260967520282, 50.22005420521937,  /* hpluv */
    },
    {
        "#228866",
        0.13333333333333333, 0.5333333333333333, 0.4,  /* rgb */
        0.11861464240020976, 0.18906898522244536, 0.1559507460216043,  /* xyz */
        50.578103551996165, -38.92545757753563, 18.980025216679635,  /* luv */
        50.578103551996165, 43.30626519161311, 154.00617039749545,  /* lch */
        154.00617039749545, 91.01794930173726, 50.578103551996165,  /* hsluv */
        154.00617039749545, 108.64944602032037, 50.578103551996165,  /* hpluv */
    },
    {
        "#228877",
        0.13333333333333333, 0.5333333333333333, 0.4666666666666667,  /* rgb */
        0.12792865542041168, 0.19279459043052619, 0.2050045479280022,  /* xyz */
        51.012569485874636, -37.833683058372145, 5.997553408179356,  /* luv */
        51.012569485874636, 38.30611205336975, 170.99218986646125,  /* lch */
        170.99218986646125, 91.54270765848676, 51.012569485874636,  /* hsluv */
        170.99218986646125, 95.28624261062296, 51.012569485874636,  /* hpluv */
    },
    {
        "#228888",
        0.13333333333333333, 0.5333333333333333, 0.5333333333333333,  /* rgb */
        0.1390690725223555, 0.19725075727130378, 0.2636774113315744,  /* xyz */
        51.52494134700676, -36.69737079296709, -7.918867790851278,  /* luv */
        51.52494134700676, 37.542049627124726, 192.1770506300611,  /* lch */
        192.1770506300611, 92.09509667536398, 51.52494134700676,  /* hsluv */
        192.1770506300611, 92.45700049956078, 51.52494134700676,  /* hpluv */
    },
    {
        "#228899",
        0.13333333333333333, 0.5333333333333333, 0.6,  /* rgb */
        0.1521260366314282, 0.20247354291493294, 0.3324440889726923,  /* xyz */
        52.115730206290706, -35.5574728144251, -22.395195973095458,  /* luv */
        52.115730206290706, 42.02235923436392, 212.20399232723307,  /* lch */
        212.20399232723307, 92.65719999541135, 52.115730206290706,  /* hsluv */
        212.20399232723307, 102.31773801651048, 52.115730206290706,  /* hpluv */
    },
    {
        "#2288aa",
        0.13333333333333333, 0.5333333333333333, 0.6666666666666666,  /* rgb */
        0.16718372959668076, 0.20849662010103404, 0.4117479385896909,  /* xyz */
        52.784565077464336, -34.44884782280892, -37.10762791438925,  /* luv */
        52.784565077464336, 50.63298495794819, 227.1279252375742,  /* lch */
        227.1279252375742, 93.213704377986, 52.784565077464336,  /* hsluv */
        227.1279252375742, 121.72111165959474, 52.784565077464336,  /* hpluv */
    },
    {
        "#2288bb",
        0.13333333333333333, 0.5333333333333333, 0.7333333333333333,  /* rgb */
        0.1843213217040174, 0.2153516569439688, 0.5020059236883326,  /* xyz */
        53.53029336311073, -33.39870750353814, -51.79759552268464,  /* luv */
        53.53029336311073, 61.631684747689114, 237.18637567221919,  /* lch */
        237.18637567221919, 93.7525919029994, 53.53029336311073,  /* hsluv */
        237.18637567221919, 146.0978223733792, 53.53029336311073,  /* hpluv */
    },
    {
        "#2288cc",
        0.13333333333333333, 0.5333333333333333, 0.8,  /* rgb */
        0.20361369714773914, 0.2230686071214576, 0.6036124343586028,  /* xyz */
        54.35108628397673, -32.42641486078499, -66.27433304530673,  /* luv */
        54.35108628397673, 73.78183788253023, 243.9286241405253,  /* lch */
        243.9286241405253, 94.26523691901129, 54.35108628397673,  /* hsluv */
        243.9286241405253, 172.25846273591395, 54.35108628397673,  /* hpluv */
    },
    {
        "#2288dd",
        0.13333333333333333, 0.5333333333333333, 0.8666666666666667,  /* rgb */
        0.22513202269837268, 0.23167593734171113, 0.7169422822586088,  /* xyz */
        55.24454745300878, -31.544198041281593, -80.40902685494498,  /* luv */
        55.24454745300878, 86.37504286439953, 248.58008536133678,  /* lch */
        248.58008536133678, 94.74609999966896, 55.24454745300878,  /* hsluv */
        248.58008536133678, 198.39840761978212, 55.24454745300878,  /* hpluv */
    },
    {
        "#2288ee",
        0.13333333333333333, 0.5333333333333333, 0.9333333333333333,  /* rgb */
        0.24894420296454745, 0.24120080944818117, 0.842353098327132,  /* xyz */
        56.20782154661056, -30.75834511421694, -94.12453266734963,  /* luv */
        56.20782154661056, 99.02274205460198, 251.9034617449104,  /* lch */
        251.9034617449104, 95.19221016233568, 56.20782154661056,  /* hsluv */
        251.9034617449104, 223.55146546663454, 56.20782154661056,  /* hpluv */
    },
    {
        "#2288ff",
        0.13333333333333333, 0.5333333333333333, 1.0,  /* rgb */
        0.2751152513743788, 0.25166922881211384, 0.9801872866189139,  /* xyz */
        57.23769971804899, -30.070541549876157, -107.38375554244654,  /* luv */
        57.23769971804899, 111.51461080729622, 254.3562247130704,  /* lch */
        254.3562247130704, 99.99999999999888, 57.23769971804899,  /* hsluv */
        254.3562247130704, 247.2230315484822, 57.23769971804899,  /* hpluv */
    },
    {
        "#229900",
        0.13333333333333333, 0.6, 0.0,  /* rgb */
        0.12050406342501632, 0.23121611435631656, 0.03827833452007608,  /* xyz */
        55.19738160230007, -48.56579610903386, 67.13103017049795,  /* luv */
        55.19738160230007, 82.85657344747341, 125.88377505217294,  /* lch */
        125.88377505217294, 100.00000000000233, 55.19738160230007,  /* hsluv */
        125.88377505217294, 190.4793142610944, 55.19738160230007,  /* hpluv */
    },
    {
        "#229911",
        0.13333333333333333, 0.6, 0.06666666666666667,  /* rgb */
        0.12151572892465344, 0.2316207805561714, 0.043606439484831706,  /* xyz */
        55.238893100694895, -48.40102058569728, 65.38595304590483,  /* luv */
        55.238893100694895, 81.35097817149074, 126.51016849011904,  /* lch */
        126.51016849011904, 97.10940304515363, 55.238893100694895,  /* hsluv */
        126.51016849011904, 186.87755284235132, 55.238893100694895,  /* hpluv */
    },
    {
        "#229922",
        0.13333333333333333, 0.6, 0.13333333333333333,  /* rgb */
        0.12339108706313047, 0.23237092381156224, 0.053483325680810906,  /* xyz */
        55.315716645050074, -48.10118479229643, 62.20196916094401,  /* luv */
        55.315716645050074, 78.63083966181259, 127.71501294924028,  /* lch */
        127.71501294924028, 91.84457916933576, 55.315716645050074,  /* hsluv */
        127.71501294924028, 180.378053709807, 55.315716645050074,  /* hpluv */
    },
    {
        "#229933",
        0.13333333333333333, 0.6, 0.2,  /* rgb */
        0.12647883779558822, 0.23360602410454534, 0.06974547953842206,  /* xyz */
        55.4418461137647, -47.62283431755732, 57.0986643273697,  /* luv */
        55.4418461137647, 74.35181111719577, 129.82961436977726,  /* lch */
        129.82961436977726, 91.99410430825088, 55.4418461137647,  /* hsluv */
        129.82961436977726, 170.17399533018772, 55.4418461137647,  /* hpluv */
    },
    {
        "#229944",
        0.13333333333333333, 0.6, 0.26666666666666666,  /* rgb */
        0.13093683303980708, 0.23538922220223293, 0.0932242544913087,  /* xyz */
        55.623165897589004, -46.96400654213736, 50.019507034435485,  /* luv */
        55.623165897589004, 68.61172636261139, 133.1954727425684,  /* lch */
        133.1954727425684, 92.20056081832288, 55.623165897589004,  /* hsluv */
        133.1954727425684, 156.52437181377167, 55.623165897589004,  /* hpluv */
    },
    {
        "#229955",
        0.13333333333333333, 0.6, 0.3333333333333333,  /* rgb */
        0.13689924707916906, 0.23777418781797777, 0.1246263017652826,  /* xyz */
        55.86424901302817, -46.13712722585177, 41.04500499807686,  /* luv */
        55.86424901302817, 61.75214120940737, 138.342726405552,  /* lch */
        138.342726405552, 92.46059952476664, 55.86424901302817,  /* hsluv */
        138.342726405552, 140.2676053123486, 55.86424901302817,  /* hpluv */
    },
    {
        "#229966",
        0.13333333333333333, 0.6, 0.4,  /* rgb */
        0.14448424285267725, 0.24080818612738106, 0.16457394617242654,  /* xyz */
        56.16862063968364, -45.16629243869515, 30.366712612121066,  /* luv */
        56.16862063968364, 54.42546469737198, 146.08582400534652,  /* lch */
        146.08582400534652, 92.7673635780271, 56.16862063968364,  /* hsluv */
        146.08582400534652, 122.9554301610412, 56.16862063968364,  /* hpluv */
    },
    {
        "#229977",
        0.13333333333333333, 0.6, 0.4666666666666667,  /* rgb */
        0.15379825587287915, 0.24453379133546188, 0.21362774807882445,  /* xyz */
        56.5388973522399, -44.08376190602678, 18.255028723380153,  /* luv */
        56.5388973522399, 47.71398262017846, 157.50561732142717,  /* lch */
        157.50561732142717, 93.1115325865156, 56.5388973522399,  /* hsluv */
        157.50561732142717, 107.08722388625509, 56.5388973522399,  /* hpluv */
    },
    {
        "#229988",
        0.13333333333333333, 0.6, 0.5333333333333333,  /* rgb */
        0.164938672974823, 0.24898995817623948, 0.27230061148239665,  /* xyz */
        56.9768757530356, -42.92602937042511, 5.023557033314732,  /* luv */
        56.9768757530356, 43.218978733625406, 173.3251382041809,  /* lch */
        173.3251382041809, 93.48248788961537, 56.9768757530356,  /* hsluv */
        173.3251382041809, 96.2532040641867, 56.9768757530356,  /* hpluv */
    },
    {
        "#229999",
        0.13333333333333333, 0.6, 0.6,  /* rgb */
        0.1779956370838957, 0.25421274381986864, 0.3410672891235145,  /* xyz */
        57.48360070225475, -41.730064849292454, -9.004864907339034,  /* luv */
        57.48360070225475, 42.690583321449004, 192.1770506300611,  /* lch */
        192.1770506300611, 93.86942546980096, 57.48360070225475,  /* hsluv */
        192.1770506300611, 94.23830182998795, 57.48360070225475,  /* hpluv */
    },
    {
        "#2299aa",
        0.13333333333333333, 0.6, 0.6666666666666666,  /* rgb */
        0.19305333004914826, 0.26023582100596976, 0.42037113874051313,  /* xyz */
        58.059427066298056, -40.53024379930658, -23.52596660965431,  /* luv */
        58.059427066298056, 46.8633307325653, 210.13321964051937,  /* lch */
        210.13321964051937, 94.26226550362027, 58.059427066298056,  /* hsluv */
        210.13321964051937, 102.4235283846829, 58.059427066298056,  /* hpluv */
    },
    {
        "#2299bb",
        0.13333333333333333, 0.6, 0.7333333333333333,  /* rgb */
        0.21019092215648488, 0.2670908578489045, 0.5106291238391549,  /* xyz */
        58.704081470592044, -39.35624850700255, -38.2731734745639,  /* luv */
        58.704081470592044, 54.897632957705945, 224.20066901604446,  /* lch */
        224.20066901604446, 94.65227484267483, 58.704081470592044,  /* hsluv */
        224.20066901604446, 118.6655478471916, 58.704081470592044,  /* hpluv */
    },
    {
        "#2299cc",
        0.13333333333333333, 0.6, 0.8,  /* rgb */
        0.22948329760020664, 0.2748078080263933, 0.6122356345094251,  /* xyz */
        59.41672664891708, -38.23197696114835, -53.027766253261866,  /* luv */
        59.41672664891708, 65.37299179453512, 234.2091374704118,  /* lch */
        234.2091374704118, 95.03239224927617, 59.41672664891708,  /* hsluv */
        234.2091374704118, 139.6139984563855, 59.41672664891708,  /* hpluv */
    },
    {
        "#2299dd",
        0.13333333333333333, 0.6, 0.8666666666666667,  /* rgb */
        0.2510016231508402, 0.2834151382466468, 0.7255654824094311,  /* xyz */
        60.19602877859421, -37.17530897229136, -67.6214137925481,  /* luv */
        60.19602877859421, 77.16643830376222, 241.19992052128615,  /* lch */
        241.19992052128615, 95.39730080048543, 60.19602877859421,  /* hsluv */
        241.19992052128615, 162.66718111259942, 60.19602877859421,  /* hpluv */
    },
    {
        "#2299ee",
        0.13333333333333333, 0.6, 0.9333333333333333,  /* rgb */
        0.2748138034170149, 0.29294001035311684, 0.8509762984779543,  /* xyz */
        61.040226937052324, -36.198488101550005, -81.9332269222821,  /* luv */
        61.040226937052324, 89.57334544794132, 246.16393109570157,  /* lch */
        246.16393109570157, 95.74331870201, 61.040226937052324,  /* hsluv */
        246.16393109570157, 186.20956338188043, 61.040226937052324,  /* hpluv */
    },
    {
        "#2299ff",
        0.13333333333333333, 0.6, 1.0,  /* rgb */
        0.3009848518268463, 0.30340842971704957, 0.9888104867697362,  /* xyz */
        61.94720316581534, -35.30886856996081, -95.88356079897525,  /* luv */
        61.94720316581534, 102.17814556538765, 249.78390331857156,  /* lch */
        249.78390331857156, 99.9999999999986, 61.94720316581534,  /* hsluv */
        249.78390331857156, 209.3030897971113, 61.94720316581534,  /* hpluv */
    },
    {
        "#22aa00",
        0.13333333333333333, 0.6666666666666666, 0.0,  /* rgb */
        0.1503376830545856, 0.290883353615456, 0.04822287439659889,  /* xyz */
        60.85951012296479, -54.382497576378405, 74.11884271720426,  /* luv */
        60.85951012296479, 91.92964096733147, 126.26825202317256,  /* lch */
        126.26825202317256, 100.00000000000229, 60.85951012296479,  /* hsluv */
        126.26825202317256, 191.67542647483077, 60.85951012296479,  /* hpluv */
    },
    {
        "#22aa11",
        0.13333333333333333, 0.6666666666666666, 0.06666666666666667,  /* rgb */
        0.15134934855422275, 0.29128801981531083, 0.05355097936135452,  /* xyz */
        60.89513498057596, -54.2335583573106, 72.58597591321329,  /* luv */
        60.89513498057596, 90.60906550323425, 126.76572653816642,  /* lch */
        126.76572653816642, 97.69889094996444, 60.89513498057596,  /* hsluv */
        126.76572653816642, 188.8114730036518, 60.89513498057596,  /* hpluv */
    },
    {
        "#22aa22",
        0.13333333333333333, 0.6666666666666666, 0.13333333333333333,  /* rgb */
        0.15322470669269975, 0.29203816307070163, 0.06342786555733372,  /* xyz */
        60.96108679678946, -53.961502456072395, 69.78022945057202,  /* luv */
        60.96108679678946, 88.21068058626, 127.71501294924035,  /* lch */
        127.71501294924035, 93.49268459944395, 60.96108679678946,  /* hsluv */
        127.71501294924035, 183.6148484393402, 60.96108679678946,  /* hpluv */
    },
    {
        "#22aa33",
        0.13333333333333333, 0.6666666666666666, 0.2,  /* rgb */
        0.15631245742515748, 0.29327326336368476, 0.07969001941494486,  /* xyz */
        61.06942991051065, -53.52466915097276, 65.25903419601626,  /* luv */
        61.06942991051065, 84.40160988937306, 129.35818885723182,  /* lch */
        129.35818885723182, 93.58823605191607, 61.06942991051065,  /* hsluv */
        129.35818885723182, 175.3743971665907, 61.06942991051065,  /* hpluv */
    },
    {
        "#22aa44",
        0.13333333333333333, 0.6666666666666666, 0.26666666666666666,  /* rgb */
        0.16077045266937637, 0.2950564614613723, 0.1031687943678315,  /* xyz */
        61.225316899448615, -52.917281977470445, 58.938150671985575,  /* luv */
        61.225316899448615, 79.20823401968252, 131.91889999480966,  /* lch */
        131.91889999480966, 93.72134265071324, 61.225316899448615,  /* hsluv */
        131.91889999480966, 164.16426079181414, 61.225316899448615,  /* hpluv */
    },
    {
        "#22aa55",
        0.13333333333333333, 0.6666666666666666, 0.3333333333333333,  /* rgb */
        0.16673286670873838, 0.2974414270771172, 0.1345708416418054,  /* xyz */
        61.43283164024484, -52.14531233726465, 50.84280059931279,  /* luv */
        61.43283164024484, 72.82941693802282, 135.72459281582715,  /* lch */
        135.72459281582715, 93.89096276946168, 61.43283164024484,  /* hsluv */
        135.72459281582715, 150.43386917547195, 61.43283164024484,  /* hpluv */
    },
    {
        "#22aa66",
        0.13333333333333333, 0.6666666666666666, 0.4,  /* rgb */
        0.17431786248224654, 0.3004754253865205, 0.17451848604894937,  /* xyz */
        61.69522143552619, -51.22477472898816, 41.091276176975406,  /* luv */
        61.69522143552619, 65.66940325515415, 141.26425661379642,  /* lch */
        141.26425661379642, 94.09393743566957, 61.69522143552619,  /* hsluv */
        141.26425661379642, 135.06750234646464, 61.69522143552619,  /* hpluv */
    },
    {
        "#22aa77",
        0.13333333333333333, 0.6666666666666666, 0.4666666666666667,  /* rgb */
        0.18363187550244847, 0.3042010305946013, 0.22357228795534728,  /* xyz */
        62.015018576984005, -50.1795183581889, 29.874884837330974,  /* luv */
        62.015018576984005, 58.3994247120946, 149.2321176804288,  /* lch */
        149.2321176804288, 94.32545380205735, 62.015018576984005,  /* hsluv */
        149.2321176804288, 119.49535321649046, 62.015018576984005,  /* hpluv */
    },
    {
        "#22aa88",
        0.13333333333333333, 0.6666666666666666, 0.5333333333333333,  /* rgb */
        0.19477229260439227, 0.3086571974353789, 0.2822451513589195,  /* xyz */
        62.39411446950783, -49.03857737364639, 17.43435727806117,  /* luv */
        62.39411446950783, 52.04554625066576, 160.42851443905278,  /* lch */
        160.42851443905278, 94.57959775548368, 62.39411446950783,  /* hsluv */
        160.42851443905278, 105.84717519726159, 62.39411446950783,  /* hpluv */
    },
    {
        "#22aa99",
        0.13333333333333333, 0.6666666666666666, 0.6,  /* rgb */
        0.207829256713465, 0.31387998307900805, 0.35101182900003736,  /* xyz */
        62.83381237593122, -47.83338904603835, 4.035244554510897,  /* luv */
        62.83381237593122, 48.00329474363579, 175.17792169193586,  /* lch */
        175.17792169193586, 94.84993277149381, 62.83381237593122,  /* hsluv */
        175.17792169193586, 96.94311314939449, 62.83381237593122,  /* hpluv */
    },
    {
        "#22aaaa",
        0.13333333333333333, 0.6666666666666666, 0.6666666666666666,  /* rgb */
        0.22288694967871753, 0.3199030602651092, 0.43031567861703596,  /* xyz */
        63.334871160235295, -46.59523146673561, -10.054711541893578,  /* luv */
        63.334871160235295, 47.667733527296605, 192.17705063006113,  /* lch */
        192.17705063006113, 95.13003273688071, 63.334871160235295,  /* hsluv */
        192.17705063006113, 95.50386287427447, 63.334871160235295,  /* hpluv */
    },
    {
        "#22aabb",
        0.13333333333333333, 0.6666666666666666, 0.7333333333333333,  /* rgb */
        0.2400245417860542, 0.32675809710804393, 0.5205736637156777,  /* xyz */
        63.89754628101572, -45.35315532679702, -24.58388188114917,  /* luv */
        63.89754628101572, 51.58755612008454, 208.46010621002773,  /* lch */
        208.46010621002773, 95.41391214532294, 63.89754628101572,  /* hsluv */
        208.46010621002773, 102.44720153689109, 63.89754628101572,  /* hpluv */
    },
    {
        "#22aacc",
        0.13333333333333333, 0.6666666666666666, 0.8,  /* rgb */
        0.2593169172297759, 0.33447504728553273, 0.6221801743859479,  /* xyz */
        64.52163113040527, -44.13255253751762, -39.32950270272921,  /* luv */
        64.52163113040527, 59.11422820540531, 221.70639196420362,  /* lch */
        221.70639196420362, 95.69632424294709, 64.52163113040527,  /* hsluv */
        221.70639196420362, 116.2588472243701, 64.52163113040527,  /* hpluv */
    },
    {
        "#22aadd",
        0.13333333333333333, 0.6666666666666666, 0.8666666666666667,  /* rgb */
        0.2808352427804095, 0.34308237750578624, 0.7355100222859539,  /* xyz */
        65.20650001753468, -42.954372197975154, -54.10479457135933,  /* luv */
        65.20650001753468, 69.08260914681186, 231.55356512464232,  /* lch */
        231.55356512464232, 95.9729250289437, 65.20650001753468,  /* hsluv */
        231.55356512464232, 134.43649108261187, 65.20650001753468,  /* hpluv */
    },
    {
        "#22aaee",
        0.13333333333333333, 0.6666666666666666, 0.9333333333333333,  /* rgb */
        0.3046474230465842, 0.35260724961225626, 0.8609208383544771,  /* xyz */
        65.95115301628393, -41.83489647399964, -68.76121142241598,  /* luv */
        65.95115301628393, 80.48765594343307, 238.68331888244418,  /* lch */
        238.68331888244418, 96.24032126522853, 65.95115301628393,  /* hsluv */
        238.68331888244418, 154.86248125605442, 65.95115301628393,  /* hpluv */
    },
    {
        "#22aaff",
        0.13333333333333333, 0.6666666666666666, 1.0,  /* rgb */
        0.33081847145641563, 0.363075668976189, 0.9987550266462589,  /* xyz */
        66.75426224744369, -40.785937465112724, -83.18702821855523,  /* luv */
        66.75426224744369, 92.64758150509267, 243.8816547234464,  /* lch */
        243.8816547234464, 99.99999999999825, 66.75426224744369,  /* hsluv */
        243.8816547234464, 176.11421562068276, 66.75426224744369,  /* hpluv */
    },
    {
        "#22bb00",
        0.13333333333333333, 0.7333333333333333, 0.0,  /* rgb */
        0.1842921809631844, 0.35879234943265453, 0.05954104036613151,  /* xyz */
        66.42754792716981, -60.02654446026218, 80.98129225921225,  /* luv */
        66.42754792716981, 100.80255818089034, 126.54730854784916,  /* lch */
        126.54730854784916, 100.0000000000024, 66.42754792716981,  /* hsluv */
        126.54730854784916, 192.55848436808677, 66.42754792716981,  /* hpluv */
    },
    {
        "#22bb11",
        0.13333333333333333, 0.7333333333333333, 0.06666666666666667,  /* rgb */
        0.18530384646282153, 0.3591970156325094, 0.06486914533088714,  /* xyz */
        66.45852509299087, -59.891738470658936, 79.62253155227276,  /* luv */
        66.45852509299087, 99.63316650508744, 126.95033340146746,  /* lch */
        126.95033340146746, 98.13237117533345, 66.45852509299087,  /* hsluv */
        126.95033340146746, 190.23593656138763, 66.45852509299087,  /* hpluv */
    },
    {
        "#22bb22",
        0.13333333333333333, 0.7333333333333333, 0.13333333333333333,  /* rgb */
        0.18717920460129853, 0.3599471588879002, 0.07474603152686633,  /* xyz */
        66.51588701791916, -59.64480918990219, 77.12958834300578,  /* luv */
        66.51588701791916, 97.50116235851435, 127.71501294924037,  /* lch */
        127.71501294924037, 94.70950455520143, 66.51588701791916,  /* hsluv */
        127.71501294924037, 186.0046205665566, 66.51588701791916,  /* hpluv */
    },
    {
        "#22bb33",
        0.13333333333333333, 0.7333333333333333, 0.2,  /* rgb */
        0.19026695533375626, 0.3611822591808833, 0.09100818538447748,  /* xyz */
        66.61015923418616, -59.24644124914341, 73.09644659799987,  /* luv */
        66.61015923418616, 94.09161124107956, 129.02560466204335,  /* lch */
        129.02560466204335, 94.77283614206996, 66.61015923418616,  /* hsluv */
        129.02560466204335, 179.2461185890827, 66.61015923418616,  /* hpluv */
    },
    {
        "#22bb44",
        0.13333333333333333, 0.7333333333333333, 0.26666666666666666,  /* rgb */
        0.19472495057797515, 0.3629654572785709, 0.11448696033736412,  /* xyz */
        66.74588804200529, -58.68863659643749, 67.424797990356,  /* luv */
        66.74588804200529, 89.38936989144187, 131.03732282887168,  /* lch */
        131.03732282887168, 94.86164283172475, 66.74588804200529,  /* hsluv */
        131.03732282887168, 169.94198503944418, 66.74588804200529,  /* hpluv */
    },
    {
        "#22bb55",
        0.13333333333333333, 0.7333333333333333, 0.3333333333333333,  /* rgb */
        0.20068736461733716, 0.36535042289431574, 0.14588900761133802,  /* xyz */
        66.9267274999506, -57.97301254624688, 60.10464590688465,  /* luv */
        66.9267274999506, 83.50711732109595, 133.96576260666626,  /* lch */
        133.96576260666626, 94.97580663872061, 66.9267274999506,  /* hsluv */
        133.96576260666626, 158.33000614260487, 66.9267274999506,  /* hpluv */
    },
    {
        "#22bb66",
        0.13333333333333333, 0.7333333333333333, 0.4,  /* rgb */
        0.20827236039084532, 0.36838442120371906, 0.18583665201848198,  /* xyz */
        67.15564588782223, -57.10965981032089, 51.203160611646005,  /* luv */
        67.15564588782223, 76.70252212458595, 138.12135367172513,  /* lch */
        138.12135367172513, 95.11390832366914, 67.15564588782223,  /* hsluv */
        138.12135367172513, 144.93271929684042, 67.15564588782223,  /* hpluv */
    },
    {
        "#22bb77",
        0.13333333333333333, 0.7333333333333333, 0.4666666666666667,  /* rgb */
        0.21758637341104725, 0.37211002641179985, 0.2348904539248799,  /* xyz */
        67.43503387479478, -56.115730467775656, 40.85185987436709,  /* luv */
        67.43503387479478, 69.41073159913364, 143.94564337146213,  /* lch */
        143.94564337146213, 95.27344439783285, 67.43503387479478,  /* hsluv */
        143.94564337146213, 130.61118462720796, 67.43503387479478,  /* hpluv */
    },
    {
        "#22bb88",
        0.13333333333333333, 0.7333333333333333, 0.5333333333333333,  /* rgb */
        0.22872679051299105, 0.37656619325257745, 0.2935633173284521,  /* xyz */
        67.76676915723687, -55.013673557003266, 29.231051172494322,  /* luv */
        67.76676915723687, 62.29734048003576, 152.0164344096223,  /* lch */
        152.0164344096223, 95.45109582015368, 67.76676915723687,  /* hsluv */
        152.0164344096223, 116.65196328010299, 67.76676915723687,  /* hpluv */
    },
    {
        "#22bb99",
        0.13333333333333333, 0.7333333333333333, 0.6,  /* rgb */
        0.24178375462206378, 0.3817889788962066, 0.36232999496956997,  /* xyz */
        68.15226021888634, -53.829253691780295, 16.552549003324323,  /* luv */
        68.15226021888634, 56.31674201799582, 162.90728503051093,  /* lch */
        162.90728503051093, 95.64302869839256, 68.15226021888634,  /* hsluv */
        162.90728503051093, 104.856796539193, 68.15226021888634,  /* hpluv */
    },
    {
        "#22bbaa",
        0.13333333333333333, 0.7333333333333333, 0.6666666666666666,  /* rgb */
        0.2568414475873163, 0.38781205608230773, 0.44163384458656857,  /* xyz */
        68.59248010565582, -52.589564951165954, 3.0424168834988747,  /* luv */
        68.59248010565582, 52.67749654497546, 176.68900923381463,  /* lch */
        176.68900923381463, 95.84519530793696, 68.59248010565582,  /* hsluv */
        176.68900923381463, 97.4513697523019, 68.59248010565582,  /* hpluv */
    },
    {
        "#22bbbb",
        0.13333333333333333, 0.7333333333333333, 0.7333333333333333,  /* rgb */
        0.273979039694653, 0.3946670929252425, 0.5318918296852103,  /* xyz */
        69.08799591513664, -51.32124664611442, -11.074530906997165,  /* luv */
        69.08799591513664, 52.50252938784327, 192.17705063006107,  /* lch */
        192.17705063006107, 96.05360442262905, 69.08799591513664,  /* hsluv */
        192.17705063006107, 96.43106389683939, 69.08799591513664,  /* hpluv */
    },
    {
        "#22bbcc",
        0.13333333333333333, 0.7333333333333333, 0.8,  /* rgb */
        0.29327141513837474, 0.4023840431027313, 0.6334983403554805,  /* xyz */
        69.63899707167968, -50.04905186906751, -25.58719338418354,  /* luv */
        69.63899707167968, 56.2104265974936, 207.0780405151903,  /* lch */
        207.0780405151903, 96.26453827720705, 69.63899707167968,  /* hsluv */
        207.0780405151903, 102.424464009042, 69.63899707167968,  /* hpluv */
    },
    {
        "#22bbdd",
        0.13333333333333333, 0.7333333333333333, 0.8666666666666667,  /* rgb */
        0.3147897406890082, 0.4109913733229848, 0.7468281882554865,  /* xyz */
        70.24532397941469, -48.794843278289754, -40.306984458542296,  /* luv */
        70.24532397941469, 63.28972844541229, 219.55841227977635,  /* lch */
        219.55841227977635, 96.47470497931711, 70.24532397941469,  /* hsluv */
        219.55841227977635, 114.32866673848667, 70.24532397941469,  /* hpluv */
    },
    {
        "#22bbee",
        0.13333333333333333, 0.7333333333333333, 0.9333333333333333,  /* rgb */
        0.338601920955183, 0.4205162454294548, 0.8722390043240097,  /* xyz */
        70.90649774986744, -47.57701761480356, -55.07296377456023,  /* luv */
        70.90649774986744, 72.77777094713296, 229.17657253180616,  /* lch */
        229.17657253180616, 96.68132617787913, 70.90649774986744,  /* hsluv */
        229.17657253180616, 130.24229529474226, 70.90649774986744,  /* hpluv */
    },
    {
        "#22bbff",
        0.13333333333333333, 0.7333333333333333, 1.0,  /* rgb */
        0.36477296936501435, 0.43098466479338754, 1.0100731926157915,  /* xyz */
        71.62175113604614, -46.41030621144006, -69.75375007427891,  /* luv */
        71.62175113604614, 83.78246936003139, 236.36239159516776,  /* lch */
        236.36239159516776, 99.99999999999774, 71.62175113604614,  /* hsluv */
        236.36239159516776, 148.43883858580122, 71.62175113604614,  /* hpluv */
    },
    {
        "#22cc00",
        0.13333333333333333, 0.8, 0.0,  /* rgb */
        0.2225159242728013, 0.43523983605188943, 0.07228228813600346,  /* xyz */
        71.90917450395234, -65.52464892651942, 87.73014558527947,  /* luv */
        71.90917450395234, 109.49912356433705, 126.75563568012267,  /* lch */
        126.75563568012267, 100.00000000000229, 71.90917450395234,  /* hsluv */
        126.75563568012267, 193.22604574287084, 71.90917450395234,  /* hpluv */
    },
    {
        "#22cc11",
        0.13333333333333333, 0.8, 0.06666666666666667,  /* rgb */
        0.22352758977243845, 0.4356445022517443, 0.0776103931007591,  /* xyz */
        71.93641071514381, -65.4022833696805, 86.51599895678575,  /* luv */
        71.93641071514381, 108.45495260917566, 127.08767416995799,  /* lch */
        127.08767416995799, 98.45913413893504, 71.93641071514381,  /* hsluv */
        127.08767416995799, 191.31100388967315, 71.93641071514381,  /* hpluv */
    },
    {
        "#22cc22",
        0.13333333333333333, 0.8, 0.13333333333333333,  /* rgb */
        0.22540294791091545, 0.4363946455071351, 0.08748727929673829,  /* xyz */
        71.98685481136522, -65.17767019050618, 84.28439857933223,  /* luv */
        71.98685481136522, 106.54571101335867, 127.7150129492404,  /* lch */
        127.7150129492404, 95.6295101801496, 71.98685481136522,  /* hsluv */
        127.7150129492404, 187.81146453634892, 71.98685481136522,  /* hpluv */
    },
    {
        "#22cc33",
        0.13333333333333333, 0.8, 0.2,  /* rgb */
        0.22849069864337318, 0.4376297458001182, 0.10374943315434942,  /* xyz */
        72.06978450899052, -64.81401043168991, 80.66314643127802,  /* luv */
        72.06978450899052, 103.47656324227728, 128.78238323167378,  /* lch */
        128.78238323167378, 95.6728206524347, 72.06978450899052,  /* hsluv */
        128.78238323167378, 182.19149482593338, 72.06978450899052,  /* hpluv */
    },
    {
        "#22cc44",
        0.13333333333333333, 0.8, 0.26666666666666666,  /* rgb */
        0.23294869388759207, 0.4394129438978058, 0.12722820810723606,  /* xyz */
        72.18924093056651, -64.30209311543506, 75.54790246570464,  /* luv */
        72.18924093056651, 99.20808810774301, 130.40254581044658,  /* lch */
        130.40254581044658, 95.73385797623068, 72.18924093056651,  /* hsluv */
        130.40254581044658, 174.38692971209278, 72.18924093056651,  /* hpluv */
    },
    {
        "#22cc55",
        0.13333333333333333, 0.8, 0.3333333333333333,  /* rgb */
        0.23891110792695408, 0.44179790951355064, 0.15863025538120998,  /* xyz */
        72.34850563912906, -63.64063951783567, 68.90649121283691,  /* luv */
        72.34850563912906, 93.79891006564989, 132.72494135945465,  /* lch */
        132.72494135945465, 95.81285149896107, 72.34850563912906,  /* hsluv */
        132.72494135945465, 164.51577712405071, 72.34850563912906,  /* hpluv */
    },
    {
        "#22cc66",
        0.13333333333333333, 0.8, 0.4,  /* rgb */
        0.24649610370046224, 0.44483190782295395, 0.19857789978835394,  /* xyz */
        72.55028563995701, -62.83547667260536, 60.77069428354258,  /* luv */
        72.55028563995701, 87.41495531302026, 135.95700978034986,  /* lch */
        135.95700978034986, 95.90921141653475, 72.55028563995701,  /* hsluv */
        135.95700978034986, 152.89241471165704, 72.55028563995701,  /* hpluv */
    },
    {
        "#22cc77",
        0.13333333333333333, 0.8, 0.4666666666666667,  /* rgb */
        0.25581011672066417, 0.44855751303103475, 0.24763170169475185,  /* xyz */
        72.7968107106438, -61.89860760529276, 51.22773775196409,  /* luv */
        72.7968107106438, 80.34748744458668, 140.3885954544974,  /* lch */
        140.3885954544974, 96.02163670056837, 72.7968107106438,  /* hsluv */
        140.3885954544974, 140.05521160751618, 72.7968107106438,  /* hpluv */
    },
    {
        "#22cc88",
        0.13333333333333333, 0.8, 0.5333333333333333,  /* rgb */
        0.26695053382260797, 0.45301367987181235, 0.30630456509832404,  /* xyz */
        73.08989111898714, -60.84703374340314, 40.40993681628363,  /* luv */
        73.08989111898714, 73.04330570878399, 146.41093430751005,  /* lch */
        146.41093430751005, 96.14825009421185, 73.08989111898714,  /* hsluv */
        146.41093430751005, 126.81260715763447, 73.08989111898714,  /* hpluv */
    },
    {
        "#22cc99",
        0.13333333333333333, 0.8, 0.6,  /* rgb */
        0.28000749793168067, 0.4582364655154415, 0.3750712427394419,  /* xyz */
        73.43095560614543, -59.70136758331612, 28.482691218777067,  /* luv */
        73.43095560614543, 66.1476907411168, 154.4948404163473,  /* lch */
        154.4948404163473, 96.28675635811278, 73.43095560614543,  /* hsluv */
        154.4948404163473, 114.30752824689772, 73.43095560614543,  /* hpluv */
    },
    {
        "#22ccaa",
        0.13333333333333333, 0.8, 0.6666666666666666,  /* rgb */
        0.2950651908969332, 0.4642595427015426, 0.4543750923564405,  /* xyz */
        73.82107923785303, -58.484351750569196, 15.631753236079188,  /* luv */
        73.82107923785303, 60.537353005545086, 165.03572853292485,  /* lch */
        165.03572853292485, 96.43461084232332, 73.82107923785303,  /* hsluv */
        165.03572853292485, 104.05965073493655, 73.82107923785303,  /* hpluv */
    },
    {
        "#22ccbb",
        0.13333333333333333, 0.8, 0.7333333333333333,  /* rgb */
        0.3122027830042699, 0.4711145795444774, 0.5446330774550823,  /* xyz */
        74.26100623142119, -57.21942259875836, 2.0509058024304325,  /* luv */
        74.26100623142119, 57.25616593124046, 177.9472361165366,  /* lch */
        177.9472361165366, 96.58918285313544, 74.26100623142119,  /* hsluv */
        177.9472361165366, 97.83646663063773, 74.26100623142119,  /* hpluv */
    },
    {
        "#22cccc",
        0.13333333333333333, 0.8, 0.8,  /* rgb */
        0.3314951584479916, 0.4788315297219662, 0.6462395881253524,  /* xyz */
        74.75117062106435, -55.92944128384276, -12.068925963159515,  /* luv */
        74.75117062106435, 57.2167927817266, 192.17705063006113,  /* lch */
        192.17705063006113, 96.747899952527, 74.75117062106435,  /* hsluv */
        192.17705063006113, 97.12808778271356, 74.75117062106435,  /* hpluv */
    },
    {
        "#22ccdd",
        0.13333333333333333, 0.8, 0.8666666666666667,  /* rgb */
        0.3530134839986252, 0.4874388599422197, 0.7595694360253584,  /* xyz */
        75.29171637998256, -54.635677914055336, -26.548414891228216,  /* luv */
        75.29171637998256, 60.74434652183841, 205.91591349789152,  /* lch */
        205.91591349789152, 96.9083635301369, 75.29171637998256,  /* hsluv */
        205.91591349789152, 102.37596141669218, 75.29171637998256,  /* hpluv */
    },
    {
        "#22ccee",
        0.13333333333333333, 0.8, 0.9333333333333333,  /* rgb */
        0.3768256642647999, 0.4969637320486897, 0.8849802520938816,  /* xyz */
        75.88251787001128, -53.35708907277048, -41.22608770159046,  /* luv */
        75.88251787001128, 67.42825269498529, 217.6912885793776,  /* lch */
        217.6912885793776, 97.06843110531779, 75.88251787001128,  /* hsluv */
        217.6912885793776, 112.75595805156647, 75.88251787001128,  /* hpluv */
    },
    {
        "#22ccff",
        0.13333333333333333, 0.8, 1.0,  /* rgb */
        0.40299671267463133, 0.5074321514126224, 1.0228144403856634,  /* xyz */
        76.5232010138481, -52.10988716676161, -55.962112432593855,  /* luv */
        76.5232010138481, 76.46697567218742, 227.04144314298077,  /* lch */
        227.04144314298077, 99.999999999997, 76.5232010138481,  /* hsluv */
        227.04144314298077, 130.75468927611735, 76.5232010138481,  /* hpluv */
    },
    {
        "#22dd00",
        0.13333333333333333, 0.8666666666666667, 0.0,  /* rgb */
        0.2651499148199765, 0.520507817146241, 0.08649361831839478,  /* xyz */
        77.31119285386455, -70.89738736930316, 94.3754510494695,  /* luv */
        77.31119285386455, 118.03882961374973, 126.91486453942932,  /* lch */
        126.91486453942932, 100.00000000000229, 77.31119285386455,  /* hsluv */
        126.91486453942932, 210.34707572922625, 77.31119285386455,  /* hpluv */
    },
    {
        "#22dd11",
        0.13333333333333333, 0.8666666666666667, 0.06666666666666667,  /* rgb */
        0.2661615803196136, 0.5209124833460959, 0.09182172328315041,  /* xyz */
        77.33536803009653, -70.78591975674468, 93.28278050285473,  /* luv */
        77.33536803009653, 117.09963097359476, 127.19237505614534,  /* lch */
        127.19237505614534, 98.71073262316642, 77.33536803009653,  /* hsluv */
        127.19237505614534, 208.94165901637808, 77.33536803009653,  /* hpluv */
    },
    {
        "#22dd22",
        0.13333333333333333, 0.8666666666666667, 0.13333333333333333,  /* rgb */
        0.2680369384580907, 0.5216626266014867, 0.1016986094791296,  /* xyz */
        77.38014926651935, -70.58098015457686, 91.27168010271724,  /* luv */
        77.38014926651935, 115.37848303888174, 127.71501294924043,  /* lch */
        127.71501294924043, 96.33950711462622, 77.38014926651935,  /* hsluv */
        127.71501294924043, 206.36169979351382, 77.38014926651935,  /* hpluv */
    },
    {
        "#22dd33",
        0.13333333333333333, 0.8666666666666667, 0.2,  /* rgb */
        0.2711246891905484, 0.5228977268944698, 0.11796076333674074,  /* xyz */
        77.45378750256843, -70.24826089977104, 88.00059569749692,  /* luv */
        77.45378750256843, 112.60072381009198, 128.59932725776207,  /* lch */
        128.59932725776207, 96.36993778684811, 77.45378750256843,  /* hsluv */
        128.59932725776207, 202.18578668083973, 77.45378750256843,  /* hpluv */
    },
    {
        "#22dd44",
        0.13333333333333333, 0.8666666666666667, 0.26666666666666666,  /* rgb */
        0.2755826844347673, 0.5246809249921573, 0.14143953828962738,  /* xyz */
        77.5598997380018, -69.77797231329272, 83.3638834787812,  /* luv */
        77.5598997380018, 108.71293616133481, 129.93030274178784,  /* lch */
        129.93030274178784, 96.41299063204092, 77.5598997380018,  /* hsluv */
        129.93030274178784, 196.31602444994442, 77.5598997380018,  /* hpluv */
    },
    {
        "#22dd55",
        0.13333333333333333, 0.8666666666666667, 0.3333333333333333,  /* rgb */
        0.2815450984741293, 0.5270658906079021, 0.1728415855636013,  /* xyz */
        77.70144601910914, -69.1669361195931, 77.31567405495743,  /* luv */
        77.70144601910914, 103.73899221962921, 131.81595263450097,  /* lch */
        131.81595263450097, 96.46900093502022, 77.70144601910914,  /* hsluv */
        131.81595263450097, 188.76416341383165, 77.70144601910914,  /* hpluv */
    },
    {
        "#22dd66",
        0.13333333333333333, 0.8666666666666667, 0.4,  /* rgb */
        0.28913009424763747, 0.5300998889173054, 0.21278922997074526,  /* xyz */
        77.88089624008038, -68.41793932542471, 69.86336597569719,  /* luv */
        77.88089624008038, 97.78499029499211, 134.40112056032058,  /* lch */
        134.40112056032058, 96.53777487837225, 77.88089624008038,  /* hsluv */
        134.40112056032058, 179.66428363523272, 77.88089624008038,  /* hpluv */
    },
    {
        "#22dd77",
        0.13333333333333333, 0.8666666666666667, 0.4666666666666667,  /* rgb */
        0.2984441072678394, 0.5338254941253863, 0.2618430318771432,  /* xyz */
        78.10031837497452, -67.53909640165776, 61.0616980975421,  /* luv */
        78.10031837497452, 91.04976945224956, 137.88345198702157,  /* lch */
        137.88345198702157, 96.61864690846325, 78.10031837497452,  /* hsluv */
        137.88345198702157, 169.29983692302594, 78.10031837497452,  /* hpluv */
    },
    {
        "#22dd88",
        0.13333333333333333, 0.8666666666666667, 0.5333333333333333,  /* rgb */
        0.3095845243697832, 0.5382816609661638, 0.32051589528071533,  /* xyz */
        78.36143073739173, -66.54305346836746, 51.00572831082092,  /* luv */
        78.36143073739173, 83.84248496681911, 142.52957601428568,  /* lch */
        142.52957601428568, 96.7105501690208, 78.36143073739173,  /* hsluv */
        142.52957601428568, 158.15070284388133, 78.36143073739173,  /* hpluv */
    },
    {
        "#22dd99",
        0.13333333333333333, 0.8666666666666667, 0.6,  /* rgb */
        0.3226414884788559, 0.543504446609793, 0.3892825729218332,  /* xyz */
        78.66563587282805, -65.44602113564966, 39.822492467704485,  /* luv */
        78.66563587282805, 76.60948106356211, 148.6803890565023,  /* lch */
        148.6803890565023, 96.81210150467699, 78.66563587282805,  /* hsluv */
        148.6803890565023, 146.96862949494488, 78.66563587282805,  /* hpluv */
    },
    {
        "#22ddaa",
        0.13333333333333333, 0.8666666666666667, 0.6666666666666666,  /* rgb */
        0.33769918144410843, 0.5495275237958941, 0.46858642253883187,  /* xyz */
        79.01404460068939, -64.26669180317286, 27.66175691303686,  /* luv */
        79.01404460068939, 69.96699558248838, 156.71192344603998,  /* lch */
        156.71192344603998, 96.92169633269735, 79.01404460068939,  /* hsluv */
        156.71192344603998, 136.8806799935021, 79.01404460068939,  /* hpluv */
    },
    {
        "#22ddbb",
        0.13333333333333333, 0.8666666666666667, 0.7333333333333333,  /* rgb */
        0.3548367735514451, 0.5563825606388288, 0.5588444076374736,  /* xyz */
        79.40749476968432, -63.025126809623316, 14.686552094481957,  /* luv */
        79.40749476968432, 64.71368805587448, 166.88262774299784,  /* lch */
        166.88262774299784, 97.0376060255481, 79.40749476968432,  /* hsluv */
        166.88262774299784, 129.47681586597758, 79.40749476968432,  /* hpluv */
    },
    {
        "#22ddcc",
        0.13333333333333333, 0.8666666666666667, 0.8,  /* rgb */
        0.3741291489951668, 0.5640995108163177, 0.6604509183077437,  /* xyz */
        79.84656733475691, -61.74170234091512, 1.0642169393488978,  /* luv */
        79.84656733475691, 61.75087339988124, 179.01251343423314,  /* lch */
        179.01251343423314, 97.15807010303318, 79.84656733475691,  /* hsluv */
        179.01251343423314, 126.73563014759736, 79.84656733475691,  /* hpluv */
    },
    {
        "#22dddd",
        0.13333333333333333, 0.8666666666666667, 0.8666666666666667,  /* rgb */
        0.3956474745458004, 0.5727068410365712, 0.7737807662077497,  /* xyz */
        80.33160129381989, -60.4361886569793, -13.041429874024955,  /* luv */
        80.33160129381989, 61.8272738566169, 192.17705063006125,  /* lch */
        192.17705063006125, 97.28137676372344, 80.33160129381989,  /* hsluv */
        192.17705063006125, 130.5831342555323, 80.33160129381989,  /* hpluv */
    },
    {
        "#22ddee",
        0.13333333333333333, 0.8666666666666667, 0.9333333333333333,  /* rgb */
        0.4194596548119751, 0.5822317131430412, 0.8991915822762729,  /* xyz */
        80.86270838738591, -59.12701268453146, -27.47637734296151,  /* luv */
        80.86270838738591, 65.19934770294526, 204.92433664916385,  /* lch */
        204.92433664916385, 97.405927410883, 80.86270838738591,  /* hsluv */
        204.92433664916385, 142.19363887028285, 80.86270838738591,  /* hpluv */
    },
    {
        "#22ddff",
        0.13333333333333333, 0.8666666666666667, 1.0,  /* rgb */
        0.44563070322180653, 0.592700132506974, 1.0370257705680548,  /* xyz */
        81.43978806209051, -57.8307265123863, -42.100982266920354,  /* luv */
        81.43978806209051, 71.53240969511626, 216.05475633251393,  /* lch */
        216.05475633251393, 99.9999999999961, 81.43978806209051,  /* hsluv */
        216.05475633251393, 161.67615635145793, 81.43978806209051,  /* hpluv */
    },
    {
        "#22ee00",
        0.13333333333333333, 0.9333333333333333, 0.0,  /* rgb */
        0.31232869116049133, 0.6148653698272719, 0.10221987709856596,  /* xyz */
        82.63960710979646, -76.16089297939094, 100.92583052028732,  /* luv */
        82.63960710979646, 126.43775103041021, 127.03902226734965,  /* lch */
        127.03902226734965, 100.0000000000022, 82.63960710979646,  /* hsluv */
        127.03902226734965, 308.74681059884847, 82.63960710979646,  /* hpluv */
    },
    {
        "#22ee11",
        0.13333333333333333, 0.9333333333333333, 0.06666666666666667,  /* rgb */
        0.31334035666012844, 0.6152700360271268, 0.1075479820633216,  /* xyz */
        82.66124185205263, -76.0589691017437, 99.93624490957345,  /* luv */
        82.66124185205263, 125.58749869093758, 127.27385287635963,  /* lch */
        127.27385287635963, 98.90803895424386, 82.66124185205263,  /* hsluv */
        127.27385287635963, 307.1110762398026, 82.66124185205263,  /* hpluv */
    },
    {
        "#22ee22",
        0.13333333333333333, 0.9333333333333333, 0.13333333333333333,  /* rgb */
        0.3152157147986055, 0.6160201792825176, 0.11742486825930079,  /* xyz */
        82.70132181869933, -75.87133921000176, 98.11289934163642,  /* luv */
        82.70132181869933, 124.02661460646756, 127.71501294924037,  /* lch */
        127.71501294924037, 96.89728243344972, 82.70132181869933,  /* hsluv */
        127.71501294924037, 304.1028650146969, 82.70132181869933,  /* hpluv */
    },
    {
        "#22ee33",
        0.13333333333333333, 0.9333333333333333, 0.2,  /* rgb */
        0.3183034655310632, 0.6172552795755007, 0.13368702211691194,  /* xyz */
        82.76724208867739, -75.56606587282334, 95.14173085912788,  /* luv */
        82.76724208867739, 121.49970889827927, 128.45826570638994,  /* lch */
        128.45826570638994, 96.91917352379103, 82.76724208867739,  /* hsluv */
        128.45826570638994, 299.21821405622444, 82.76724208867739,  /* hpluv */
    },
    {
        "#22ee44",
        0.13333333333333333, 0.9333333333333333, 0.26666666666666666,  /* rgb */
        0.3227614607752821, 0.6190384776731883, 0.15716579706979858,  /* xyz */
        82.86226070611126, -75.1331770294334, 90.91854426113345,  /* luv */
        82.86226070611126, 117.94564841951508, 129.56961275566726,  /* lch */
        129.56961275566726, 96.95023972987157, 82.86226070611126,  /* hsluv */
        129.56961275566726, 292.31740901060675, 82.86226070611126,  /* hpluv */
    },
    {
        "#22ee55",
        0.13333333333333333, 0.9333333333333333, 0.3333333333333333,  /* rgb */
        0.3287238748146441, 0.6214234432889331, 0.1885678443437725,  /* xyz */
        82.98906000718462, -74.56827265765982, 85.3893207236587,  /* luv */
        82.98906000718462, 113.36561815998246, 131.12986692981144,  /* lch */
        131.12986692981144, 96.99082338779613, 82.98906000718462,  /* hsluv */
        131.12986692981144, 283.37241521762223, 82.98906000718462,  /* hpluv */
    },
    {
        "#22ee66",
        0.13333333333333333, 0.9333333333333333, 0.4,  /* rgb */
        0.3363088705881523, 0.6244574415983364, 0.22851548875091643,  /* xyz */
        83.1498978333136, -73.87198498529992, 78.54474020134496,  /* luv */
        83.1498978333136, 107.82553676641332, 133.24398982369402,  /* lch */
        133.24398982369402, 97.04091626230087, 83.1498978333136,  /* hsluv */
        133.24398982369402, 272.4767610470921, 83.1498978333136,  /* hpluv */
    },
    {
        "#22ee77",
        0.13333333333333333, 0.9333333333333333, 0.4666666666666667,  /* rgb */
        0.3456228836083542, 0.6281830468064172, 0.27756929065731434,  /* xyz */
        83.34668796290127, -73.04951859544357, 70.41582735094856,  /* luv */
        83.34668796290127, 101.46241130854644, 136.05169958656856,  /* lch */
        136.05169958656856, 97.10019227414874, 83.34668796290127,  /* hsluv */
        136.05169958656856, 259.8693484670809, 83.34668796290127,  /* hpluv */
    },
    {
        "#22ee88",
        0.13333333333333333, 0.9333333333333333, 0.5333333333333333,  /* rgb */
        0.356763300710298, 0.6326392136471948, 0.33624215406088653,  /* xyz */
        83.58104784289777, -72.11010148299903, 61.06906634851857,  /* luv */
        83.58104784289777, 94.49496071520524, 139.73918986599926,  /* lch */
        139.73918986599926, 97.16804582094521, 83.58104784289777,  /* hsluv */
        139.73918986599926, 245.9764037957654, 83.58104784289777,  /* hpluv */
    },
    {
        "#22ee99",
        0.13333333333333333, 0.9333333333333333, 0.6,  /* rgb */
        0.3698202648193707, 0.637861999290824, 0.4050088317020044,  /* xyz */
        83.85432934514222, -71.0663081347816, 50.60055842630493,  /* luv */
        83.85432934514222, 87.24010926724945, 144.54841325857237,  /* lch */
        144.54841325857237, 97.24363859284838, 83.85432934514222,  /* hsluv */
        144.54841325857237, 231.48020809757745, 83.85432934514222,  /* hpluv */
    },
    {
        "#22eeaa",
        0.13333333333333333, 0.9333333333333333, 0.6666666666666666,  /* rgb */
        0.38487795778462325, 0.6438850764769251, 0.484312681319003,  /* xyz */
        84.16764015516038, -69.93327453177663, 39.12933886659673,  /* luv */
        84.16764015516038, 80.13593480376825, 150.77194388379294,  /* lch */
        150.77194388379294, 97.32595363570823, 84.16764015516038,  /* hsluv */
        150.77194388379294, 217.42312560604816, 84.16764015516038,  /* hpluv */
    },
    {
        "#22eebb",
        0.13333333333333333, 0.9333333333333333, 0.7333333333333333,  /* rgb */
        0.4020155498919599, 0.6507401133198598, 0.5745706664176448,  /* xyz */
        84.52185988257547, -68.72785407704178, 26.790235584494564,  /* luv */
        84.52185988257547, 73.76472496192112, 158.70407793229384,  /* lch */
        158.70407793229384, 97.41385336909303, 84.52185988257547,  /* hsluv */
        158.70407793229384, 205.33979619248112, 84.52185988257547,  /* hpluv */
    },
    {
        "#22eecc",
        0.13333333333333333, 0.9333333333333333, 0.8,  /* rgb */
        0.4213079253356816, 0.6584570634973487, 0.6761771770879149,  /* xyz */
        84.91765325308536, -67.46777425719254, 13.726752686977843,  /* luv */
        84.91765325308536, 68.85001309040504, 168.49977258214471,  /* lch */
        168.49977258214471, 97.50613750123749, 84.91765325308536,  /* hsluv */
        168.49977258214471, 197.35451237548315, 84.91765325308536,  /* hpluv */
    },
    {
        "#22eedd",
        0.13333333333333333, 0.9333333333333333, 0.8666666666666667,  /* rgb */
        0.4428262508863152, 0.6670643937176022, 0.7895070249879209,  /* xyz */
        85.35548180501583, -66.17085150585926, 0.08444894488954674,  /* luv */
        85.35548180501583, 66.17090539379652, 179.92687769026008,  /* lch */
        179.92687769026008, 97.60159692918302, 85.35548180501583,  /* hsluv */
        179.92687769026008, 196.0750523098524, 85.35548180501583,  /* hpluv */
    },
    {
        "#22eeee",
        0.13333333333333333, 0.9333333333333333, 0.9333333333333333,  /* rgb */
        0.46663843115248993, 0.6765892658240722, 0.9149178410564441,  /* xyz */
        85.83561496357537, -64.85431045337609, -13.994809411401754,  /* luv */
        85.83561496357537, 66.34708942255376, 192.17705063006125,  /* lch */
        192.17705063006125, 97.69906047668536, 85.83561496357537,  /* hsluv */
        192.17705063006125, 204.08988692033415, 85.83561496357537,  /* hpluv */
    },
    {
        "#22eeff",
        0.13333333333333333, 0.9333333333333333, 1.0,  /* rgb */
        0.49280947956232135, 0.6870576851880049, 1.052752029348226,  /* xyz */
        86.35814102124138, -63.53423765805994, -28.37747407275529,  /* luv */
        86.35814102124138, 69.58362156097324, 204.06785714501765,  /* lch */
        204.06785714501765, 99.99999999999409, 86.35814102124138,  /* hsluv */
        204.06785714501765, 223.22582684044883, 86.35814102124138,  /* hpluv */
    },
    {
        "#22ff00",
        0.13333333333333333, 1.0, 0.0,  /* rgb */
        0.36418106359016517, 0.718570114686621, 0.11950400124179007,  /* xyz */
        87.89971897132374, -81.32803250431957, 107.38872946416274,  /* luv */
        87.89971897132374, 134.70927246092154, 127.13751075039323,  /* lch */
        127.13751075039323, 100.00000000000236, 87.89971897132374,  /* hsluv */
        127.13751075039323, 493.5155610328759, 87.89971897132374,  /* hpluv */
    },
    {
        "#22ff11",
        0.13333333333333333, 1.0, 0.06666666666666667,  /* rgb */
        0.36519272908980227, 0.7189747808864759, 0.12483210620654571,  /* xyz */
        87.91921918593627, -81.23448323651158, 106.487431187561,  /* luv */
        87.91921918593627, 133.93511215371652, 127.3383849867152,  /* lch */
        127.3383849867152, 99.99999999999186, 87.91921918593627,  /* hsluv */
        127.3383849867152, 491.55077114845744, 87.91921918593627,  /* hpluv */
    },
    {
        "#22ff22",
        0.13333333333333333, 1.0, 0.13333333333333333,  /* rgb */
        0.3670680872282793, 0.7197249241418667, 0.1347089924025249,  /* xyz */
        87.95534804048181, -81.06209672954814, 104.82531901584908,  /* luv */
        87.95534804048181, 132.5119278893985, 127.71501294924046,  /* lch */
        127.71501294924046, 99.9999999999918, 87.95534804048181,  /* hsluv */
        127.71501294924046, 487.93227028150545, 87.95534804048181,  /* hpluv */
    },
    {
        "#22ff33",
        0.13333333333333333, 1.0, 0.2,  /* rgb */
        0.37015583796073703, 0.7209600244348499, 0.15097114626013605,  /* xyz */
        88.0147790356886, -80.78114287234051, 102.1128873452011,  /* luv */
        88.0147790356886, 130.20228418017567, 128.34739609900348,  /* lch */
        128.34739609900348, 99.99999999999186, 88.0147790356886,  /* hsluv */
        128.34739609900348, 482.0420586134328, 88.0147790356886,  /* hpluv */
    },
    {
        "#22ff44",
        0.13333333333333333, 1.0, 0.26666666666666666,  /* rgb */
        0.37461383320495595, 0.7227432225325374, 0.1744499212130227,  /* xyz */
        88.10046397451273, -80.3817123888383, 98.24895044242365,  /* luv */
        88.10046397451273, 126.94123029811763, 129.28808201878755,  /* lch */
        129.28808201878755, 99.99999999999177, 88.10046397451273,  /* hsluv */
        129.28808201878755, 473.68835157545294, 88.10046397451273,  /* hpluv */
    },
    {
        "#22ff55",
        0.13333333333333333, 1.0, 0.3333333333333333,  /* rgb */
        0.38057624724431793, 0.7251281881482822, 0.2058519684869966,  /* xyz */
        88.21484458499765, -79.85864447977929, 93.17497796450445,  /* luv */
        88.21484458499765, 122.71503419236647, 130.59930153587666,  /* lch */
        130.59930153587666, 99.9999999999917, 88.21484458499765,  /* hsluv */
        130.59930153587666, 462.7993627367692, 88.21484458499765,  /* hpluv */
    },
    {
        "#22ff66",
        0.13333333333333333, 1.0, 0.4,  /* rgb */
        0.3881612430178261, 0.7281621864576855, 0.24579961289414054,  /* xyz */
        88.35999027751679, -79.21105249784631, 86.87027432889113,  /* luv */
        88.35999027751679, 117.56204914764528, 132.35954438564065,  /* lch */
        132.35954438564065, 99.99999999999164, 88.35999027751679,  /* hsluv */
        132.35954438564065, 449.4320183357278, 88.35999027751679,  /* hpluv */
    },
    {
        "#22ff77",
        0.13333333333333333, 1.0, 0.4666666666666667,  /* rgb */
        0.397475256038028, 0.7318877916657663, 0.29485341480053845,  /* xyz */
        88.53767180233464, -78.441973739162, 79.34860040030858,  /* luv */
        88.53767180233464, 111.57662671717242, 134.67079586388752,  /* lch */
        134.67079586388752, 99.99999999999146, 88.53767180233464,  /* hsluv */
        134.67079586388752, 433.796433649144, 88.53767180233464,  /* hpluv */
    },
    {
        "#22ff88",
        0.13333333333333333, 1.0, 0.5333333333333333,  /* rgb */
        0.4086156731399718, 0.7363439585065439, 0.35352627820411064,  /* xyz */
        88.7494051061703, -77.55798027679346, 70.65466438450038,  /* luv */
        88.7494051061703, 104.91578481764252, 137.66674420954175,  /* lch */
        137.66674420954175, 99.99999999999152, 88.7494051061703,  /* hsluv */
        137.66674420954175, 416.30013096130335, 88.7494051061703,  /* hpluv */
    },
    {
        "#22ff99",
        0.13333333333333333, 1.0, 0.6,  /* rgb */
        0.4216726372490446, 0.7415667441501731, 0.4222929558452285,  /* xyz */
        88.99647953962435, -76.56870039638238, 60.85997250821837,  /* luv */
        88.99647953962435, 97.80951964963361, 141.5208692130273,  /* lch */
        141.5208692130273, 99.99999999999139, 88.99647953962435,  /* hsluv */
        141.5208692130273, 397.6218860717469, 88.99647953962435,  /* hpluv */
    },
    {
        "#22ffaa",
        0.13333333333333333, 1.0, 0.6666666666666666,  /* rgb */
        0.4367303302142971, 0.7475898213362742, 0.5015968054622272,  /* xyz */
        89.27997725863243, -75.4862499862398, 50.057989986528554,  /* luv */
        89.27997725863243, 90.57580415583668, 146.4500299897743,  /* lch */
        146.4500299897743, 99.99999999999119, 89.27997725863243,  /* hsluv */
        146.4500299897743, 378.8294698729454, 89.27997725863243,  /* hpluv */
    },
    {
        "#22ffbb",
        0.13333333333333333, 1.0, 0.7333333333333333,  /* rgb */
        0.45386792232163375, 0.7544448581792089, 0.5918547905608689,  /* xyz */
        89.60078750203346, -74.32459921653717, 38.35879856308958,  /* luv */
        89.60078750203346, 83.63936558763798, 152.70181868951565,  /* lch */
        152.70181868951565, 99.99999999999099, 89.60078750203346,  /* hsluv */
        152.70181868951565, 361.5536980335398, 89.60078750203346,  /* hpluv */
    },
    {
        "#22ffcc",
        0.13333333333333333, 1.0, 0.8,  /* rgb */
        0.4731602977653555, 0.7621618083566978, 0.693461301231139,  /* xyz */
        89.9596178804745, -73.09891251816502, 25.883551971063653,  /* luv */
        89.9596178804745, 77.5461751086222, 160.50148390925915,  /* lch */
        160.50148390925915, 99.99999999999083, 89.9596178804745,  /* hsluv */
        160.50148390925915, 348.20730080254293, 89.9596178804745,  /* hpluv */
    },
    {
        "#22ffdd",
        0.13333333333333333, 1.0, 0.8666666666666667,  /* rgb */
        0.494678623315989, 0.7707691385769513, 0.806791149131145,  /* xyz */
        90.35700397952505, -71.82490312167374, 12.75906297194918,  /* luv */
        90.35700397952505, 72.9493687180361, 169.92698701238913,  /* lch */
        169.92698701238913, 99.9999999999906, 90.35700397952505,  /* hsluv */
        169.92698701238913, 342.1627556263286, 90.35700397952505,  /* hpluv */
    },
    {
        "#22ffee",
        0.13333333333333333, 1.0, 0.9333333333333333,  /* rgb */
        0.5184908035821638, 0.7802940106834213, 0.9322019651996682,  /* xyz */
        90.79331809590887, -70.5182397089352, -0.8871719878375578,  /* luv */
        90.79331809590887, 70.52382013038466, 180.72078556267687,  /* lch */
        180.72078556267687, 99.99999999999017, 90.79331809590887,  /* hsluv */
        180.72078556267687, 347.6811242465368, 90.79331809590887,  /* hpluv */
    },
    {
        "#22ffff",
        0.13333333333333333, 1.0, 1.0,  /* rgb */
        0.5446618519919951, 0.790762430047354, 1.0700361534914502,  /* xyz */
        91.26877762544291, -69.19403439822342, -14.931271599985106,  /* luv */
        91.26877762544291, 70.78670262058438, 192.17705063006122,  /* lch */
        192.17705063006122, 99.99999999999018, 91.26877762544291,  /* hsluv */
        192.17705063006122, 369.384676987995, 91.26877762544291,  /* hpluv */
    },
    {
        "#330000",
        0.2, 0.0, 0.0,  /* rgb */
        0.01365210114567999, 0.007039364653241395, 0.0006399422412037361,  /* xyz */
        6.358632018874149, 20.903143349823495, 4.510656350132777,  /* luv */
        6.358632018874149, 21.38427980111239, 12.177050630061784,  /* lch */
        12.177050630061784, 100.00000000000222, 6.358632018874149,  /* hsluv */
        12.177050630061784, 426.74678918312503, 6.358632018874149,  /* hpluv */
    },
    {
        "#330011",
        0.2, 0.0, 0.06666666666666667,  /* rgb */
        0.014663766645317112, 0.00744403085309625, 0.005968047205959367,  /* xyz */
        6.724165498400369, 18.2566101970553, -0.33258864860112913,  /* luv */
        6.724165498400369, 18.259639402145975, 358.9563331839311,  /* lch */
        358.9563331839311, 99.99999999999709, 6.724165498400369,  /* hsluv */
        358.9563331839311, 344.5824299270887, 6.724165498400369,  /* hpluv */
    },
    {
        "#330022",
        0.2, 0.0, 0.13333333333333333,  /* rgb */
        0.016539124783794133, 0.008194174108487069, 0.015844933401938564,  /* xyz */
        7.401767122614306, 15.008237307496762, -7.112762056683647,  /* luv */
        7.401767122614306, 16.608388577858367, 334.64260955563566,  /* lch */
        334.64260955563566, 99.999999999998, 7.401767122614306,  /* hsluv */
        334.64260955563566, 284.7288058816741, 7.401767122614306,  /* hpluv */
    },
    {
        "#330033",
        0.2, 0.0, 0.2,  /* rgb */
        0.01962687551625187, 0.009429274401470181, 0.03210708725954971,  /* xyz */
        8.50665746950019, 11.853445599417752, -15.328263967084345,  /* luv */
        8.50665746950019, 19.37678633888944, 307.7150129492436,  /* lch */
        307.7150129492436, 99.99999999999879, 8.50665746950019,  /* hsluv */
        307.7150129492436, 289.0427837304833, 8.50665746950019,  /* hpluv */
    },
    {
        "#330044",
        0.2, 0.0, 0.26666666666666666,  /* rgb */
        0.02408487076047075, 0.011212472499157758, 0.055585862212436346,  /* xyz */
        9.963213990832283, 9.13167627644372, -24.253018546702368,  /* luv */
        9.963213990832283, 25.915177411016387, 290.632214162589,  /* lch */
        290.632214162589, 99.9999999999994, 9.963213990832283,  /* hsluv */
        290.632214162589, 330.0608810152577, 9.963213990832283,  /* hpluv */
    },
    {
        "#330055",
        0.2, 0.0, 0.3333333333333333,  /* rgb */
        0.030047284799832742, 0.013597438114902589, 0.08698790948641026,  /* xyz */
        11.68707132711518, 6.83538450996046, -33.589133919325,  /* luv */
        11.68707132711518, 34.27757866082954, 281.5026174362572,  /* lch */
        281.5026174362572, 99.99999999999993, 11.68707132711518,  /* hsluv */
        281.5026174362572, 372.1720615093576, 11.68707132711518,  /* hpluv */
    },
    {
        "#330066",
        0.2, 0.0, 0.4,  /* rgb */
        0.03763228057334092, 0.016631436424305902, 0.1269355538935542,  /* xyz */
        13.609738771423768, 4.873123177331066, -43.207905137573306,  /* luv */
        13.609738771423768, 43.48183984008698, 276.4348061518141,  /* lch */
        276.4348061518141, 100.00000000000027, 13.609738771423768,  /* hsluv */
        276.4348061518141, 405.41279325421226, 13.609738771423768,  /* hpluv */
    },
    {
        "#330077",
        0.2, 0.0, 0.4666666666666667,  /* rgb */
        0.04694629359354283, 0.02035704163238672, 0.17598935579995212,  /* xyz */
        15.673511245710667, 3.1575580416727154, -53.014536461851065,  /* luv */
        15.673511245710667, 53.108485659557914, 273.4085231837061,  /* lch */
        273.4085231837061, 100.00000000000031, 15.673511245710667,  /* hsluv */
        273.4085231837061, 429.9688019036141, 15.673511245710667,  /* hpluv */
    },
    {
        "#330088",
        0.2, 0.0, 0.5333333333333333,  /* rgb */
        0.05808671069548666, 0.02481320847316431, 0.23466221920352429,  /* xyz */
        17.83391838450637, 1.625749111738658, -62.930187053857445,  /* luv */
        17.83391838450637, 62.95118349012834, 271.47985970994057,  /* lch */
        271.47985970994057, 100.00000000000044, 17.83391838450637,  /* hsluv */
        271.47985970994057, 447.91587095992594, 17.83391838450637,  /* hpluv */
    },
    {
        "#330099",
        0.2, 0.0, 0.6,  /* rgb */
        0.07114367480455938, 0.03003599411679347, 0.3034288968446422,  /* xyz */
        20.058306510441234, 0.23454316208440892, -72.89290517462713,  /* luv */
        20.058306510441234, 72.8932825114363, 270.18435658302485,  /* lch */
        270.18435658302485, 100.00000000000063, 20.058306510441234,  /* hsluv */
        270.18435658302485, 461.13976164651643, 20.058306510441234,  /* hpluv */
    },
    {
        "#3300aa",
        0.2, 0.0, 0.6666666666666666,  /* rgb */
        0.08620136776981192, 0.036059071302894576, 0.3827327464616408,  /* xyz */
        22.323294361968983, -1.0460833169945947, -82.85716973718556,  /* luv */
        22.323294361968983, 82.86377294791055, 269.2766712272876,  /* lch */
        269.2766712272876, 100.00000000000055, 22.323294361968983,  /* hsluv */
        269.2766712272876, 471.02693696641904, 22.323294361968983,  /* hpluv */
    },
    {
        "#3300bb",
        0.2, 0.0, 0.7333333333333333,  /* rgb */
        0.10333895987714857, 0.042914108145829334, 0.47299073156028254,  /* xyz */
        24.61234058853968, -2.23769945956788, -92.79121208267885,  /* luv */
        24.61234058853968, 92.8181896970849, 268.61855571411644,  /* lch */
        268.61855571411644, 100.00000000000063, 24.61234058853968,  /* hsluv */
        268.61855571411644, 478.54138702505844, 24.61234058853968,  /* hpluv */
    },
    {
        "#3300cc",
        0.2, 0.0, 0.8,  /* rgb */
        0.12263133532087031, 0.050631058323318136, 0.5745972422305528,  /* xyz */
        26.913801796700078, -3.3563116530698522, -102.67376291081935,  /* luv */
        26.913801796700078, 102.72860564701381, 268.12771993306376,  /* lch */
        268.12771993306376, 100.00000000000088, 26.913801796700078,  /* hsluv */
        268.12771993306376, 484.3459472473202, 26.913801796700078,  /* hpluv */
    },
    {
        "#3300dd",
        0.2, 0.0, 0.8666666666666667,  /* rgb */
        0.14414966087150385, 0.05923838854357167, 0.6879270901305587,  /* xyz */
        29.219497769107427, -4.414130501622691, -112.49115889867052,  /* luv */
        29.219497769107427, 112.57773038417189, 267.752877980499,  /* lch */
        267.752877980499, 100.00000000000075, 29.219497769107427,  /* hsluv */
        267.752877980499, 488.89890937186334, 29.219497769107427,  /* hpluv */
    },
    {
        "#3300ee",
        0.2, 0.0, 0.9333333333333333,  /* rgb */
        0.1679618411376786, 0.0687632606500417, 0.813337906199082,  /* xyz */
        31.523688792933633, -5.42068013199621, -122.23508130485101,  /* luv */
        31.523688792933633, 122.35521596849459, 267.4608047589908,  /* lch */
        267.4608047589908, 100.00000000000082, 31.523688792933633,  /* hsluv */
        267.4608047589908, 492.5210345260728, 31.523688792933633,  /* hpluv */
    },
    {
        "#3300ff",
        0.2, 0.0, 1.0,  /* rgb */
        0.19413288954750998, 0.0792316800139744, 0.9511720944908638,  /* xyz */
        33.8223579343154, -6.383522427861704, -131.9008968996315,  /* luv */
        33.8223579343154, 132.05527615931987, 267.2292550729453,  /* lch */
        267.2292550729453, 100.00000000000088, 33.8223579343154,  /* hsluv */
        267.2292550729453, 495.4401551641423, 33.8223579343154,  /* hpluv */
    },
    {
        "#331100",
        0.2, 0.06666666666666667, 0.0,  /* rgb */
        0.0156565014066084, 0.011048165175098268, 0.001308075661513187,  /* xyz */
        9.835767963621773, 17.918363864654, 8.730474212234311,  /* luv */
        9.835767963621773, 19.932108357036057, 25.97701663869596,  /* lch */
        25.97701663869596, 100.0000000000023, 9.835767963621773,  /* hsluv */
        25.97701663869596, 257.1486752235843, 9.835767963621773,  /* hpluv */
    },
    {
        "#331111",
        0.2, 0.06666666666666667, 0.06666666666666667,  /* rgb */
        0.01666816690624552, 0.011452831374953122, 0.006636180626268818,  /* xyz */
        10.147426128924469, 16.112779906578215, 3.4769513746129066,  /* luv */
        10.147426128924469, 16.483654545617405, 12.177050630061881,  /* lch */
        12.177050630061881, 48.30217312166507, 10.147426128924469,  /* hsluv */
        12.177050630061881, 206.12797290237452, 10.147426128924469,  /* hpluv */
    },
    {
        "#331122",
        0.2, 0.06666666666666667, 0.13333333333333333,  /* rgb */
        0.01854352504472254, 0.01220297463034394, 0.016513066822248016,  /* xyz */
        10.706269382380622, 13.574995891916982, -4.31254131423193,  /* luv */
        10.706269382380622, 14.243543311006578, 342.3758479902427,  /* lch */
        342.3758479902427, 57.10449706176979, 10.706269382380622,  /* hsluv */
        342.3758479902427, 168.81817477584354, 10.706269382380622,  /* hpluv */
    },
    {
        "#331133",
        0.2, 0.06666666666666667, 0.2,  /* rgb */
        0.02163127577718028, 0.013438074923327053, 0.03277522067985916,  /* xyz */
        11.578481001678018, 10.728467702108443, -13.873500622328008,  /* luv */
        11.578481001678018, 17.53778887867338, 307.71501294924417,  /* lch */
        307.71501294924417, 66.4967539441281, 11.578481001678018,  /* hsluv */
        307.71501294924417, 192.2040686905196, 11.578481001678018,  /* hpluv */
    },
    {
        "#331144",
        0.2, 0.06666666666666667, 0.26666666666666666,  /* rgb */
        0.026089271021399157, 0.01522127302101463, 0.0562539956327458,  /* xyz */
        12.748044902325205, 8.083669414679932, -23.962696824369154,  /* luv */
        12.748044902325205, 25.28945531842201, 288.64150868841904,  /* lch */
        288.64150868841904, 74.54397813660833, 12.748044902325205,  /* hsluv */
        288.64150868841904, 251.73014018207067, 12.748044902325205,  /* hpluv */
    },
    {
        "#331155",
        0.2, 0.06666666666666667, 0.3333333333333333,  /* rgb */
        0.032051685060761156, 0.01760623863675946, 0.0876560429067197,  /* xyz */
        14.17728635200691, 5.800740576046114, -34.08050362300007,  /* luv */
        14.17728635200691, 34.57064243585746, 279.65957249850777,  /* lch */
        279.65957249850777, 80.73336483734882, 14.17728635200691,  /* hsluv */
        279.65957249850777, 309.4237644476124, 14.17728635200691,  /* hpluv */
    },
    {
        "#331166",
        0.2, 0.06666666666666667, 0.4,  /* rgb */
        0.03963668083426933, 0.020640236946162772, 0.12760368731386368,  /* xyz */
        15.819709867679052, 3.8557869955501327, -44.12649957265957,  /* luv */
        15.819709867679052, 44.29463915521808, 274.9938386218272,  /* lch */
        274.9938386218272, 85.28486486056751, 15.819709867679052,  /* hsluv */
        274.9938386218272, 355.2973598036255, 15.819709867679052,  /* hpluv */
    },
    {
        "#331177",
        0.2, 0.06666666666666667, 0.4666666666666667,  /* rgb */
        0.04895069385447125, 0.02436584215424359, 0.1766574892202616,  /* xyz */
        17.629349342878776, 2.1767585350208747, -54.11424902427731,  /* luv */
        17.629349342878776, 54.15801164353511, 272.30349448618597,  /* lch */
        272.30349448618597, 88.59369901924626, 17.629349342878776,  /* hsluv */
        272.30349448618597, 389.8214692130375, 17.629349342878776,  /* hpluv */
    },
    {
        "#331188",
        0.2, 0.06666666666666667, 0.5333333333333333,  /* rgb */
        0.060091110956415075, 0.028822008995021183, 0.23533035262383376,  /* xyz */
        19.565812862602144, 0.6966965625649851, -64.06416658788852,  /* luv */
        19.565812862602144, 64.0679547566568, 270.6230659235274,  /* lch */
        270.6230659235274, 91.01124568719113, 19.565812862602144,  /* hsluv */
        270.6230659235274, 415.51077593183, 19.565812862602144,  /* hpluv */
    },
    {
        "#331199",
        0.2, 0.06666666666666667, 0.6,  /* rgb */
        0.07314807506548779, 0.034044794638650344, 0.30409703026495166,  /* xyz */
        21.595993181633126, -0.634894604710849, -73.98276296965746,  /* luv */
        21.595993181633126, 73.98548714297696, 269.508319412823,  /* lch */
        269.508319412823, 92.7998436287799, 21.595993181633126,  /* hsluv */
        269.508319412823, 434.7230644504615, 21.595993181633126,  /* hpluv */
    },
    {
        "#3311aa",
        0.2, 0.06666666666666667, 0.6666666666666666,  /* rgb */
        0.08820576803074033, 0.040067871824751446, 0.38340087988195026,  /* xyz */
        23.693867393524982, -1.8538356608011934, -83.86613854780448,  /* luv */
        23.693867393524982, 83.88662528422988, 268.73370031867535,  /* lch */
        268.73370031867535, 94.1436997610677, 23.693867393524982,  /* hsluv */
        268.73370031867535, 449.2582864406516, 23.693867393524982,  /* hpluv */
    },
    {
        "#3311bb",
        0.2, 0.06666666666666667, 0.7333333333333333,  /* rgb */
        0.10534336013807698, 0.046922908667686204, 0.473658864980592,  /* xyz */
        25.83948187053521, -2.98531729009247, -93.70600078795695,  /* luv */
        25.83948187053521, 93.75354234905001, 268.175268957576,  /* lch */
        268.175268957576, 95.16975622959765, 25.83948187053521,  /* hsluv */
        268.175268957576, 460.40837122453945, 25.83948187053521,  /* hpluv */
    },
    {
        "#3311cc",
        0.2, 0.06666666666666667, 0.8,  /* rgb */
        0.12463573558179872, 0.054639858845175006, 0.5752653756508621,  /* xyz */
        28.01775060525467, -4.047289807796951, -103.49352818917181,  /* luv */
        28.01775060525467, 103.57263601855075, 267.7604926304275,  /* lch */
        267.7604926304275, 95.96550046560314, 28.01775060525467,  /* hsluv */
        267.7604926304275, 469.0845088202235, 28.01775060525467,  /* hpluv */
    },
    {
        "#3311dd",
        0.2, 0.06666666666666667, 0.8666666666666667,  /* rgb */
        0.14615406113243226, 0.06324718906542853, 0.6885952235508681,  /* xyz */
        30.21735266763129, -5.052825404598016, -113.22117304345518,  /* luv */
        30.21735266763129, 113.33386550323506, 267.44470407934926,  /* lch */
        267.44470407934926, 96.59176370255821, 30.21735266763129,  /* hsluv */
        267.44470407934926, 475.92948894689994, 30.21735266763129,  /* hpluv */
    },
    {
        "#3311ee",
        0.2, 0.06666666666666667, 0.9333333333333333,  /* rgb */
        0.169966241398607, 0.07277206117189858, 0.8140060396193913,  /* xyz */
        32.42982293253341, -6.011674044475805, -122.88323418008581,  /* luv */
        32.42982293253341, 123.03019738005312, 267.19921797422853,  /* lch */
        267.19921797422853, 97.09138817442981, 32.42982293253341,  /* hsluv */
        267.19921797422853, 481.40042555193673, 32.42982293253341,  /* hpluv */
    },
    {
        "#3311ff",
        0.2, 0.06666666666666667, 1.0,  /* rgb */
        0.1961372898084384, 0.08324048053583127, 0.9518402279111732,  /* xyz */
        34.64884142248118, -6.931277078683834, -132.47583293320096,  /* luv */
        34.64884142248118, 132.6570349181937, 267.00495459820706,  /* lch */
        267.00495459820706, 99.99999999999953, 34.64884142248118,  /* hsluv */
        267.00495459820706, 485.8261586311452, 34.64884142248118,  /* hpluv */
    },
    {
        "#332200",
        0.2, 0.13333333333333333, 0.0,  /* rgb */
        0.019372125141376335, 0.018479412644634242, 0.0025466169064357973,  /* xyz */
        14.668135753801682, 10.849284229198934, 14.950240784233293,  /* luv */
        14.668135753801682, 18.47205099041515, 54.03187280942036,  /* lch */
        54.03187280942036, 100.00000000000236, 14.668135753801682,  /* hsluv */
        54.03187280942036, 159.80101171664836, 14.668135753801682,  /* hpluv */
    },
    {
        "#332211",
        0.2, 0.13333333333333333, 0.06666666666666667,  /* rgb */
        0.020383790641013456, 0.018884078844489095, 0.00787472187119143,  /* xyz */
        14.890380478812848, 9.93193249146711, 9.871909419419007,  /* luv */
        14.890380478812848, 14.003495227987683, 44.826343888897824,  /* lch */
        44.826343888897824, 67.08448037792266, 14.890380478812848,  /* hsluv */
        44.826343888897824, 119.33558852926538, 14.890380478812848,  /* hpluv */
    },
    {
        "#332222",
        0.2, 0.13333333333333333, 0.13333333333333333,  /* rgb */
        0.022259148779490475, 0.019634222099879917, 0.017751608067170625,  /* xyz */
        15.294106461402862, 8.507987167412324, 1.835925138209524,  /* luv */
        15.294106461402862, 8.703819090144421, 12.177050630062281,  /* lch */
        12.177050630062281, 16.922121578346687, 15.294106461402862,  /* hsluv */
        12.177050630062281, 72.21461049725585, 15.294106461402862,  /* hpluv */
    },
    {
        "#332233",
        0.2, 0.13333333333333333, 0.2,  /* rgb */
        0.025346899511948216, 0.02086932239286303, 0.03401376192478177,  /* xyz */
        15.936999043038163, 6.706949385896467, -8.67308072902737,  /* luv */
        15.936999043038163, 10.963826859140148, 307.7150129492465,  /* lch */
        307.7150129492465, 30.201799304442684, 15.936999043038163,  /* hsluv */
        307.7150129492465, 87.2961214462547, 15.936999043038163,  /* hpluv */
    },
    {
        "#332244",
        0.2, 0.13333333333333333, 0.26666666666666666,  /* rgb */
        0.029804894756167093, 0.022652520490550603, 0.05749253687766841,  /* xyz */
        16.821883517538566, 4.833754776744344, -20.16706611450352,  /* luv */
        16.821883517538566, 20.73826754838636, 283.47869783855634,  /* lch */
        283.47869783855634, 43.289490880975656, 16.821883517538566,  /* hsluv */
        283.47869783855634, 156.43617128370897, 16.821883517538566,  /* hpluv */
    },
    {
        "#332255",
        0.2, 0.13333333333333333, 0.3333333333333333,  /* rgb */
        0.035767308795529085, 0.025037486106295435, 0.08889458415164232,  /* xyz */
        17.935550316431986, 3.073638796389466, -31.70318169920786,  /* luv */
        17.935550316431986, 31.851828602195805, 275.5375469389315,  /* lch */
        275.5375469389315, 54.66006195124561, 17.935550316431986,  /* hsluv */
        275.5375469389315, 225.35074072206172, 17.935550316431986,  /* hpluv */
    },
    {
        "#332266",
        0.2, 0.13333333333333333, 0.4,  /* rgb */
        0.04335230456903726, 0.028071484415698747, 0.12884222855878627,  /* xyz */
        19.25438276602555, 1.4900223407132074, -42.90881724307811,  /* luv */
        19.25438276602555, 42.9346801988288, 271.98881504046165,  /* lch */
        271.98881504046165, 63.87444853028895, 19.25438276602555,  /* hsluv */
        271.98881504046165, 282.95538127679276, 19.25438276602555,  /* hpluv */
    },
    {
        "#332277",
        0.2, 0.13333333333333333, 0.4666666666666667,  /* rgb */
        0.052666317589239176, 0.03179708962377956, 0.17789603046518418,  /* xyz */
        20.7496984269819, 0.07876844790115795, -53.72945596379759,  /* luv */
        20.7496984269819, 53.72951370181987, 270.0839966887692,  /* lch */
        270.0839966887692, 71.08927628389885, 20.7496984269819,  /* hsluv */
        270.0839966887692, 328.57948701152225, 20.7496984269819,  /* hpluv */
    },
    {
        "#332288",
        0.2, 0.13333333333333333, 0.5333333333333333,  /* rgb */
        0.063806734691183, 0.036253256464557154, 0.23656889386875635,  /* xyz */
        22.391964057938893, -1.1881826595420957, -64.22568013854641,  /* luv */
        22.391964057938893, 64.2366699579867, 268.94014222219585,  /* lch */
        268.94014222219585, 76.66378407652324, 22.391964057938893,  /* hsluv */
        268.94014222219585, 364.0241170059764, 22.391964057938893,  /* hpluv */
    },
    {
        "#332299",
        0.2, 0.13333333333333333, 0.6,  /* rgb */
        0.07686369880025572, 0.04147604210818632, 0.3053355715098743,  /* xyz */
        24.153532486762167, -2.3414118298371274, -74.47535434263165,  /* luv */
        24.153532486762167, 74.51215077970467, 268.19928559436767,  /* lch */
        268.19928559436767, 80.96540360495473, 24.153532486762167,  /* hsluv */
        268.19928559436767, 391.45853822720767, 24.153532486762167,  /* hpluv */
    },
    {
        "#3322aa",
        0.2, 0.13333333333333333, 0.6666666666666666,  /* rgb */
        0.09192139176550826, 0.04749911929428742, 0.3846394211268729,  /* xyz */
        26.01004773023326, -3.4066707575127917, -84.54124438772673,  /* luv */
        26.01004773023326, 84.60985408494349, 267.69245988223594,  /* lch */
        267.69245988223594, 84.3023702715129, 26.01004773023326,  /* hsluv */
        267.69245988223594, 412.7804531163038, 26.01004773023326,  /* hpluv */
    },
    {
        "#3322bb",
        0.2, 0.13333333333333333, 0.7333333333333333,  /* rgb */
        0.1090589838728449, 0.05435415613722218, 0.47489740622551463,  /* xyz */
        27.940896003988122, -4.403708353416615, -94.46643806194928,  /* luv */
        27.940896003988122, 94.56902541199233, 267.3309952485173,  /* lch */
        267.3309952485173, 86.91347303704067, 27.940896003988122,  /* hsluv */
        267.3309952485173, 429.48491157058027, 27.940896003988122,  /* hpluv */
    },
    {
        "#3322cc",
        0.2, 0.13333333333333333, 0.8,  /* rgb */
        0.12835135931656666, 0.06207110631471098, 0.5765039168957847,  /* xyz */
        29.929087582862394, -5.347140452769374, -104.27830208457232,  /* luv */
        29.929087582862394, 104.41530633323335, 267.06458125875207,  /* lch */
        267.06458125875207, 88.97746208442024, 29.929087582862394,  /* hsluv */
        267.06458125875207, 442.700503900749, 29.929087582862394,  /* hpluv */
    },
    {
        "#3322dd",
        0.2, 0.13333333333333333, 0.8666666666666667,  /* rgb */
        0.1498696848672002, 0.07067843653496451, 0.6898337647957907,  /* xyz */
        31.96086058172633, -6.247692017339921, -113.99354054105264,  /* luv */
        31.96086058172633, 114.16462210609794, 266.86290467844617,  /* lch */
        266.86290467844617, 90.62642539603078, 31.96086058172633,  /* hsluv */
        266.86290467844617, 453.2652297106444, 31.96086058172633,  /* hpluv */
    },
    {
        "#3322ee",
        0.2, 0.13333333333333333, 0.9333333333333333,  /* rgb */
        0.17368186513337494, 0.08020330864143455, 0.815244580864314,  /* xyz */
        34.02519045937456, -7.113276350065792, -123.62220814713682,  /* luv */
        34.02519045937456, 123.8266895608795, 266.70680686746863,  /* lch */
        266.70680686746863, 93.64307851366507, 34.02519045937456,  /* hsluv */
        266.70680686746863, 461.7990382158033, 34.02519045937456,  /* hpluv */
    },
    {
        "#3322ff",
        0.2, 0.13333333333333333, 1.0,  /* rgb */
        0.19985291354320633, 0.09067172800536724, 0.9530787691560958,  /* xyz */
        36.11330539404788, -7.949808017412239, -133.17043292368675,  /* luv */
        36.11330539404788, 133.40750973088382, 266.5836971573438,  /* lch */
        266.5836971573438, 99.99999999999953, 36.11330539404788,  /* hsluv */
        266.5836971573438, 468.7619620887236, 36.11330539404788,  /* hpluv */
    },
    {
        "#333300",
        0.2, 0.2, 0.0,  /* rgb */
        0.025489847230387146, 0.03071485682265604, 0.004585857602772678,  /* xyz */
        20.32794412849318, 1.6122427391397873, 22.351467148472754,  /* luv */
        20.32794412849318, 22.40953837853796, 85.87432021817474,  /* lch */
        85.87432021817474, 100.00000000000246, 20.32794412849318,  /* hsluv */
        85.87432021817474, 139.88745807479773, 20.32794412849318,  /* hpluv */
    },
    {
        "#333311",
        0.2, 0.2, 0.06666666666666667,  /* rgb */
        0.026501512730024268, 0.031119523022510892, 0.00991396256752831,  /* xyz */
        20.486787989249997, 1.2901955319819518, 17.88673773998992,  /* luv */
        20.486787989249997, 17.93320917989655, 85.8743202181741,  /* lch */
        85.8743202181741, 79.40442206252777, 20.486787989249997,  /* hsluv */
        85.8743202181741, 111.0768276222512, 20.486787989249997,  /* hpluv */
    },
    {
        "#333322",
        0.2, 0.2, 0.13333333333333333,  /* rgb */
        0.028376870868501287, 0.03186966627790171, 0.019790848763507507,  /* xyz */
        20.777637498202836, 0.7525569822208392, 10.433139041100869,  /* luv */
        20.777637498202836, 10.460245325155261, 85.87432021817177,  /* lch */
        85.87432021817177, 45.66739649816371, 20.777637498202836,  /* hsluv */
        85.87432021817177, 63.88296013021867, 20.777637498202836,  /* hpluv */
    },
    {
        "#333333",
        0.2, 0.2, 0.2,  /* rgb */
        0.03146462160095903, 0.033104766570884826, 0.03605300262111865,  /* xyz */
        21.246731294981295, 1.0579491711347878e-12, 3.8331491707782165e-13,  /* luv */
        21.246731294981295, 1.1252496497929523e-12, 0.0,  /* lch */
        0.0, 1.9241939994479224e-12, 21.246731294981295,  /* hsluv */
        0.0, 6.7204149228109215e-12, 21.246731294981295,  /* hpluv */
    },
    {
        "#333344",
        0.2, 0.2, 0.26666666666666666,  /* rgb */
        0.035922616845177904, 0.0348879646685724, 0.05953177757400529,  /* xyz */
        21.903839159993346, -0.878332211796974, -12.176834853004598,  /* luv */
        21.903839159993346, 12.208471424041083, 265.87432021818216,  /* lch */
        265.87432021818216, 13.775703002957751, 21.903839159993346,  /* hsluv */
        265.87432021818216, 70.72620829673515, 21.903839159993346,  /* hpluv */
    },
    {
        "#333355",
        0.2, 0.2, 0.3333333333333333,  /* rgb */
        0.0418850308845399, 0.03727293028431723, 0.0909338248479792,  /* xyz */
        22.748583848698694, -1.8005138201737698, -24.961579621383002,  /* luv */
        22.748583848698694, 25.026432171032287, 265.8743202181798,  /* lch */
        265.8743202181798, 27.190506382927126, 22.748583848698694,  /* hsluv */
        265.8743202181798, 139.59951210619408, 22.748583848698694,  /* hpluv */
    },
    {
        "#333366",
        0.2, 0.2, 0.4,  /* rgb */
        0.049470026658048075, 0.040306928593720544, 0.13088146925512317,  /* xyz */
        23.7726526978294, -2.7140031203296484, -37.625817820292724,  /* luv */
        23.7726526978294, 37.723573261066036, 265.874320218179,  /* lch */
        265.874320218179, 39.22002801173062, 23.7726526978294,  /* hsluv */
        265.874320218179, 201.36060351810085, 23.7726526978294,  /* hpluv */
    },
    {
        "#333377",
        0.2, 0.2, 0.4666666666666667,  /* rgb */
        0.058784039678249994, 0.04403253380180136, 0.17993527116152108,  /* xyz */
        24.962131578677074, -3.594679455561053, -49.83515063197483,  /* luv */
        24.962131578677074, 49.964627076561406, 265.87432021817864,  /* lch */
        265.87432021817864, 49.471343421791865, 24.962131578677074,  /* hsluv */
        265.87432021817864, 253.99215842690973, 24.962131578677074,  /* hpluv */
    },
    {
        "#333388",
        0.2, 0.2, 0.5333333333333333,  /* rgb */
        0.06992445678019382, 0.04848870064257896, 0.23860813456509322,  /* xyz */
        26.29978611113784, -4.436674522221069, -61.50822231948129,  /* luv */
        26.29978611113784, 61.66802651065512, 265.87432021817847,  /* lch */
        265.87432021817847, 57.95361825734432, 26.29978611113784,  /* hsluv */
        265.87432021817847, 297.5412344138632, 26.29978611113784,  /* hpluv */
    },
    {
        "#333399",
        0.2, 0.2, 0.6,  /* rgb */
        0.08298142088926654, 0.053711486286208115, 0.30737481220621116,  /* xyz */
        27.767026902528563, -5.242913014887238, -72.68557963993628,  /* luv */
        27.767026902528563, 72.87442366478923, 265.87432021817835,  /* lch */
        265.87432021817835, 64.86620255524959, 27.767026902528563,  /* hsluv */
        265.87432021817835, 333.0313198793734, 27.767026902528563,  /* hpluv */
    },
    {
        "#3333aa",
        0.2, 0.2, 0.6666666666666666,  /* rgb */
        0.09803911385451908, 0.05973456347230922, 0.38667866182320976,  /* xyz */
        29.34539826905295, -6.019257946300326, -83.44850497935096,  /* luv */
        29.34539826905295, 83.66531210431754, 265.87432021817824,  /* lch */
        265.87432021817824, 70.46576145165614, 29.34539826905295,  /* hsluv */
        265.87432021817824, 361.7801662207985, 29.34539826905295,  /* hpluv */
    },
    {
        "#3333bb",
        0.2, 0.2, 0.7333333333333333,  /* rgb */
        0.11517670596185572, 0.06658960031524397, 0.4769366469218515,  /* xyz */
        31.01756409689107, -6.771682718646643, -93.87981111739649,  /* luv */
        31.01756409689107, 94.12371976436152, 265.8743202181782,  /* lch */
        265.8743202181782, 75.00049256073098, 31.01756409689107,  /* hsluv */
        265.8743202181782, 385.06205150253635, 31.01756409689107,  /* hpluv */
    },
    {
        "#3333cc",
        0.2, 0.2, 0.8,  /* rgb */
        0.13446908140557745, 0.07430655049273277, 0.5785431575921216,  /* xyz */
        32.76785897513683, -7.505221560822743, -104.0492905233249,  /* luv */
        32.76785897513683, 104.31962044162309, 265.8743202181781,  /* lch */
        265.8743202181781, 79.52405283635109, 32.76785897513683,  /* hsluv */
        265.8743202181781, 403.9775759524859, 32.76785897513683,  /* hpluv */
    },
    {
        "#3333dd",
        0.2, 0.2, 0.8666666666666667,  /* rgb */
        0.155987406956211, 0.0829138807129863, 0.6918730054921276,  /* xyz */
        34.582513179913924, -8.223768814402447, -114.01093273955408,  /* luv */
        34.582513179913924, 114.30714394846834, 265.8743202181781,  /* lch */
        265.8743202181781, 86.15426137989016, 34.582513179913924,  /* hsluv */
        265.8743202181781, 419.42677303975813, 34.582513179913924,  /* hpluv */
    },
    {
        "#3333ee",
        0.2, 0.2, 0.9333333333333333,  /* rgb */
        0.17979958722238573, 0.09243875281945635, 0.8172838215606508,  /* xyz */
        36.44966053317479, -8.930208989233147, -123.80472741871364,  /* luv */
        36.44966053317479, 124.1263838344345, 265.87432021817807,  /* lch */
        265.87432021817807, 92.9362870993519, 36.44966053317479,  /* hsluv */
        265.87432021817807, 432.12554656995303, 36.44966053317479,  /* hpluv */
    },
    {
        "#3333ff",
        0.2, 0.2, 1.0,  /* rgb */
        0.20597063563221713, 0.10290717218338905, 0.9551180098524327,  /* xyz */
        38.35921844323274, -9.626634070693212, -133.45967698167118,  /* luv */
        38.35921844323274, 133.80641787142739, 265.87432021817807,  /* lch */
        265.87432021817807, 99.99999999999946, 38.35921844323274,  /* hsluv */
        265.87432021817807, 442.6357842372506, 38.35921844323274,  /* hpluv */
    },
    {
        "#334400",
        0.2, 0.26666666666666666, 0.0,  /* rgb */
        0.03432241771335318, 0.048379997788588355, 0.007530047763761273,  /* xyz */
        26.26815298329055, -7.6510533750916965, 30.066904028819888,  /* luv */
        26.26815298329055, 31.02510814851042, 104.27690719655247,  /* lch */
        104.27690719655247, 100.0000000000023, 26.26815298329055,  /* hsluv */
        104.27690719655247, 149.87289405977236, 26.26815298329055,  /* hpluv */
    },
    {
        "#334411",
        0.2, 0.26666666666666666, 0.06666666666666667,  /* rgb */
        0.03533408321299031, 0.04878466398844321, 0.012858152728516904,  /* xyz */
        26.385674168346313, -7.685148275588697, 26.28832963518211,  /* luv */
        26.385674168346313, 27.388643249087345, 106.2957889444434,  /* lch */
        106.2957889444434, 86.62961249741346, 26.385674168346313,  /* hsluv */
        106.2957889444434, 131.71694538701576, 26.385674168346313,  /* hpluv */
    },
    {
        "#334422",
        0.2, 0.26666666666666666, 0.13333333333333333,  /* rgb */
        0.03720944135146732, 0.04953480724383403, 0.0227350389244961,  /* xyz */
        26.601819536202505, -7.747870209626198, 19.75781141897934,  /* luv */
        26.601819536202505, 21.222643682000683, 111.41223774800011,  /* lch */
        111.41223774800011, 63.7673799144094, 26.601819536202505,  /* hsluv */
        111.41223774800011, 101.23424916325958, 26.601819536202505,  /* hpluv */
    },
    {
        "#334433",
        0.2, 0.26666666666666666, 0.2,  /* rgb */
        0.040297192083925064, 0.05076990753681714, 0.03899719278210725,  /* xyz */
        26.95299453238558, -7.849810247220432, 10.150969399721264,  /* luv */
        26.95299453238558, 12.832057538502715, 127.71501294923623,  /* lch */
        127.71501294923623, 30.76085720235817, 26.95299453238558,  /* hsluv */
        127.71501294923623, 60.41274948166772, 26.95299453238558,  /* hpluv */
    },
    {
        "#334444",
        0.2, 0.26666666666666666, 0.26666666666666666,  /* rgb */
        0.044755187328143944, 0.052553105634504715, 0.062475967734993886,  /* xyz */
        27.450100419409267, -7.9941710207030665, -1.725049561930214,  /* luv */
        27.450100419409267, 8.178176220855377, 192.17705063006042,  /* lch */
        192.17705063006042, 37.65724653006375, 27.450100419409267,  /* hsluv */
        192.17705063006042, 37.80522728061324, 27.450100419409267,  /* hpluv */
    },
    {
        "#334455",
        0.2, 0.26666666666666666, 0.3333333333333333,  /* rgb */
        0.050717601367505936, 0.05493807125024955, 0.0938780150089678,  /* xyz */
        28.097685112904884, -8.182310954202329, -14.887595618671806,  /* luv */
        28.097685112904884, 16.987957966052168, 241.2065435681664,  /* lch */
        241.2065435681664, 44.98593639730036, 28.097685112904884,  /* hsluv */
        241.2065435681664, 76.72024183520799, 28.097685112904884,  /* hpluv */
    },
    {
        "#334466",
        0.2, 0.26666666666666666, 0.4,  /* rgb */
        0.058302597141014115, 0.05797206955965286, 0.13382565941611174,  /* xyz */
        28.894960188056565, -8.414029760588019, -28.487786536758108,  /* luv */
        28.894960188056565, 29.70437473800715, 253.54519475754552,  /* lch */
        253.54519475754552, 52.14277307164716, 28.894960188056565,  /* hsluv */
        253.54519475754552, 130.44806495247602, 28.894960188056565,  /* hpluv */
    },
    {
        "#334477",
        0.2, 0.26666666666666666, 0.4666666666666667,  /* rgb */
        0.06761661016121603, 0.061697674767733676, 0.18287946132250965,  /* xyz */
        29.836796220209614, -8.687853507052676, -41.94961055900857,  /* luv */
        29.836796220209614, 42.839801874104076, 258.29933627678133,  /* lch */
        258.29933627678133, 58.734719643867486, 29.836796220209614,  /* hsluv */
        258.29933627678133, 182.19421868795277, 29.836796220209614,  /* hpluv */
    },
    {
        "#334488",
        0.2, 0.26666666666666666, 0.5333333333333333,  /* rgb */
        0.07875702726315986, 0.06615384160851127, 0.24155232472608182,  /* xyz */
        30.914779440411102, -9.001342552075002, -54.96385993028376,  /* luv */
        30.914779440411102, 55.69605072332911, 260.69932457628147,  /* lch */
        260.69932457628147, 64.57161739497886, 30.914779440411102,  /* hsluv */
        260.69932457628147, 228.61123804283335, 30.914779440411102,  /* hpluv */
    },
    {
        "#334499",
        0.2, 0.26666666666666666, 0.6,  /* rgb */
        0.09181399137223256, 0.07137662725214043, 0.3103190023671997,  /* xyz */
        32.118269112429466, -9.351402006703568, -67.4150720250304,  /* luv */
        32.118269112429466, 68.06056608368033, 262.10267854140324,  /* lch */
        262.10267854140324, 69.60977709863536, 32.118269112429466,  /* hsluv */
        262.10267854140324, 268.89501490103044, 32.118269112429466,  /* hpluv */
    },
    {
        "#3344aa",
        0.2, 0.26666666666666666, 0.6666666666666666,  /* rgb */
        0.10687168433748512, 0.07739970443824154, 0.3896228519841983,  /* xyz */
        33.435366318838156, -9.734566608775365, -79.30230238246492,  /* luv */
        33.435366318838156, 79.89754032647429, 263.0018020374508,  /* lch */
        263.0018020374508, 73.89150164594172, 33.435366318838156,  /* hsluv */
        263.0018020374508, 303.2261490324088, 33.435366318838156,  /* hpluv */
    },
    {
        "#3344bb",
        0.2, 0.26666666666666666, 0.7333333333333333,  /* rgb */
        0.12400927644482176, 0.0842547412811763, 0.4798808370828401,  /* xyz */
        34.85372525213077, -10.147239044312377, -90.67975394907248,  /* luv */
        34.85372525213077, 91.24573544274135, 263.6150544022898,  /* lch */
        263.6150544022898, 77.49951462053714, 34.85372525213077,  /* hsluv */
        263.6150544022898, 332.20234905684134, 34.85372525213077,  /* hpluv */
    },
    {
        "#3344cc",
        0.2, 0.26666666666666666, 0.8,  /* rgb */
        0.1433016518885435, 0.0919716914586651, 0.5814873477531103,  /* xyz */
        36.36117461159691, -10.585872172766997, -101.62038207446163,  /* luv */
        36.36117461159691, 102.1702634949021, 264.0529050776013,  /* lch */
        264.0529050776013, 80.52864685982718, 36.36117461159691,  /* hsluv */
        264.0529050776013, 356.55451128807033, 36.36117461159691,  /* hpluv */
    },
    {
        "#3344dd",
        0.2, 0.26666666666666666, 0.8666666666666667,  /* rgb */
        0.16481997743917703, 0.10057902167891863, 0.6948171956531163,  /* xyz */
        37.94615032156556, -11.04709570425349, -112.19685586542131,  /* luv */
        37.94615032156556, 112.73940211649635, 264.37668424613827,  /* lch */
        264.37668424613827, 84.1625325255073, 37.94615032156556,  /* hsluv */
        264.37668424613827, 377.0051918334427, 37.94615032156556,  /* hpluv */
    },
    {
        "#3344ee",
        0.2, 0.26666666666666666, 0.9333333333333333,  /* rgb */
        0.18863215770535177, 0.11010389378538865, 0.8202280117216395,  /* xyz */
        39.597963215982446, -11.527794442218019, -122.47329353652364,  /* luv */
        39.597963215982446, 123.01462382328988, 264.6228789783298,  /* lch */
        264.6228789783298, 91.98328320276757, 39.597963215982446,  /* hsluv */
        264.6228789783298, 394.2059921682218, 39.597963215982446,  /* hpluv */
    },
    {
        "#3344ff",
        0.2, 0.26666666666666666, 1.0,  /* rgb */
        0.21480320611518317, 0.12057231314932136, 0.9580622000134214,  /* xyz */
        41.30693572971545, -12.025148175323421, -132.5028427546234,  /* luv */
        41.30693572971545, 133.04738827461043, 264.81439078774605,  /* lch */
        264.81439078774605, 99.99999999999945, 41.30693572971545,  /* hsluv */
        264.81439078774605, 408.71699943379286, 41.30693572971545,  /* hpluv */
    },
    {
        "#335500",
        0.2, 0.3333333333333333, 0.0,  /* rgb */
        0.04613567442769914, 0.07200651121728062, 0.011467800001876484,  /* xyz */
        32.259399363748386, -16.283699031356626, 37.76225048680512,  /* luv */
        32.259399363748386, 41.12355062457544, 113.32649436871623,  /* lch */
        113.32649436871623, 100.00000000000229, 32.259399363748386,  /* hsluv */
        113.32649436871623, 161.76093713661172, 32.259399363748386,  /* hpluv */
    },
    {
        "#335511",
        0.2, 0.3333333333333333, 0.06666666666666667,  /* rgb */
        0.04714733992733626, 0.07241117741713547, 0.016795904966632115,  /* xyz */
        32.34963415835764, -16.19454536840276, 34.586079775734746,  /* luv */
        32.34963415835764, 38.18979201230013, 115.09081810835647,  /* lch */
        115.09081810835647, 90.89954460903999, 32.34963415835764,  /* hsluv */
        115.09081810835647, 149.8018738963737, 32.34963415835764,  /* hpluv */
    },
    {
        "#335522",
        0.2, 0.3333333333333333, 0.13333333333333333,  /* rgb */
        0.04902269806581328, 0.07316132067252629, 0.02667279116261131,  /* xyz */
        32.516020185823166, -16.04032467186377, 28.977285120772702,  /* luv */
        32.516020185823166, 33.12061395187832, 118.96664290248918,  /* lch */
        118.96664290248918, 74.93512930223427, 32.516020185823166,  /* hsluv */
        118.96664290248918, 129.25290734683412, 32.516020185823166,  /* hpluv */
    },
    {
        "#335533",
        0.2, 0.3333333333333333, 0.2,  /* rgb */
        0.05211044879827102, 0.0743964209655094, 0.04293494502022246,  /* xyz */
        32.78751190734562, -15.814330074705305, 20.450275307260267,  /* luv */
        32.78751190734562, 25.851630429326267, 127.71501294923874,  /* lch */
        127.71501294923874, 50.94348318732522, 32.78751190734562,  /* hsluv */
        127.71501294923874, 100.05039415103258, 32.78751190734562,  /* hpluv */
    },
    {
        "#335544",
        0.2, 0.3333333333333333, 0.26666666666666666,  /* rgb */
        0.0565684440424899, 0.07617961906319698, 0.06641371997310909,  /* xyz */
        33.174232254198984, -15.539762262897943, 9.457656249415354,  /* luv */
        33.174232254198984, 18.191522006679165, 148.67488391751644,  /* lch */
        148.67488391751644, 54.50887676338597, 33.174232254198984,  /* hsluv */
        148.67488391751644, 69.58369421340349, 33.174232254198984,  /* hpluv */
    },
    {
        "#335555",
        0.2, 0.3333333333333333, 0.3333333333333333,  /* rgb */
        0.0625308580818519, 0.07856458467894181, 0.097815767247083,  /* xyz */
        33.68213633151341, -15.248488259823803, -3.290447242695415,  /* luv */
        33.68213633151341, 15.599469134138706, 192.17705063006082,  /* lch */
        192.17705063006082, 58.53912471090103, 33.68213633151341,  /* hsluv */
        192.17705063006082, 58.76916446179769, 33.68213633151341,  /* hpluv */
    },
    {
        "#335566",
        0.2, 0.3333333333333333, 0.4,  /* rgb */
        0.07011585385536007, 0.08159858298834513, 0.13776341165422695,  /* xyz */
        34.31361569677015, -14.972617911330035, -17.038341218343536,  /* luv */
        34.31361569677015, 22.682247652985918, 228.69227746085622,  /* lch */
        228.69227746085622, 62.73862134114171, 34.31361569677015,  /* hsluv */
        228.69227746085622, 83.8800984368335, 34.31361569677015,  /* hpluv */
    },
    {
        "#335577",
        0.2, 0.3333333333333333, 0.4666666666666667,  /* rgb */
        0.07942986687556199, 0.08532418819642594, 0.18681721356062486,  /* xyz */
        35.06798367454852, -14.738302997491218, -31.141237778060866,  /* luv */
        35.06798367454852, 34.45278313279761, 244.6730761321763,  /* lch */
        244.6730761321763, 66.86042417633983, 35.06798367454852,  /* hsluv */
        244.6730761321763, 124.66738251921676, 35.06798367454852,  /* hpluv */
    },
    {
        "#335588",
        0.2, 0.3333333333333333, 0.5333333333333333,  /* rgb */
        0.09057028397750581, 0.08978035503720354, 0.24549007696419703,  /* xyz */
        35.94197139420285, -14.56304892639515, -45.13627105167932,  /* luv */
        35.94197139420285, 47.42747472176063, 252.11789848380135,  /* lch */
        252.11789848380135, 70.73277306870234, 35.94197139420285,  /* hsluv */
        252.11789848380135, 167.4431685228822, 35.94197139420285,  /* hpluv */
    },
    {
        "#335599",
        0.2, 0.3333333333333333, 0.6,  /* rgb */
        0.10362724808657853, 0.0950031406808327, 0.31425675460531494,  /* xyz */
        36.930253845471185, -14.455942624185102, -58.74279866699278,  /* luv */
        36.930253845471185, 60.49537728111613, 256.17486506539365,  /* lch */
        256.17486506539365, 74.25816778029493, 36.930253845471185,  /* hsluv */
        256.17486506539365, 207.86397267972353, 36.930253845471185,  /* hpluv */
    },
    {
        "#3355aa",
        0.2, 0.3333333333333333, 0.6666666666666666,  /* rgb */
        0.11868494105183107, 0.1010262178669338, 0.39356060422231354,  /* xyz */
        38.025984221189056, -14.41942598704065, -71.82514024856032,  /* luv */
        38.025984221189056, 73.25824607183209, 258.6483487155184,  /* lch */
        258.6483487155184, 77.3978910060545, 38.025984221189056,  /* hsluv */
        258.6483487155184, 244.4642623166077, 38.025984221189056,  /* hpluv */
    },
    {
        "#3355bb",
        0.2, 0.3333333333333333, 0.7333333333333333,  /* rgb */
        0.1358225331591677, 0.10788125470986856, 0.4838185893209553,  /* xyz */
        39.22130327441076, -14.45143889603874, -84.34603407296076,  /* luv */
        39.22130327441076, 85.57509888982308, 260.27762236373917,  /* lch */
        260.27762236373917, 80.15299643518266, 39.22130327441076,  /* hsluv */
        260.27762236373917, 276.8628693770104, 39.22130327441076,  /* hpluv */
    },
    {
        "#3355cc",
        0.2, 0.3333333333333333, 0.8,  /* rgb */
        0.15511490860288946, 0.11559820488735736, 0.5854250999912255,  /* xyz */
        40.50779390911347, -14.547281630958045, -96.32632071728673,  /* luv */
        40.50779390911347, 97.4185991778777, 261.4120403511602,  /* lch */
        261.4120403511602, 82.54782640761837, 40.50779390911347,  /* hsluv */
        261.4120403511602, 305.1705463000935, 40.50779390911347,  /* hpluv */
    },
    {
        "#3355dd",
        0.2, 0.3333333333333333, 0.8666666666666667,  /* rgb */
        0.176633234153523, 0.1242055351076109, 0.6987549478912315,  /* xyz */
        41.876861515802055, -14.700982183284093, -107.81586279040629,  /* luv */
        41.876861515802055, 108.81350626826134, 262.2354500957219,  /* lch */
        262.2354500957219, 84.61803591547545, 41.876861515802055,  /* hsluv */
        262.2354500957219, 329.72206067647727, 41.876861515802055,  /* hpluv */
    },
    {
        "#3355ee",
        0.2, 0.3333333333333333, 0.9333333333333333,  /* rgb */
        0.20044541441969774, 0.13373040721408092, 0.8241657639597547,  /* xyz */
        43.32003221975425, -14.906191199054337, -118.87505979776236,  /* luv */
        43.32003221975425, 119.8059864029521, 262.85277080342814,  /* lch */
        262.85277080342814, 90.80559999783276, 43.32003221975425,  /* hsluv */
        262.85277080342814, 350.93693177529786, 43.32003221975425,  /* hpluv */
    },
    {
        "#3355ff",
        0.2, 0.3333333333333333, 1.0,  /* rgb */
        0.22661646282952913, 0.14419882657801364, 0.9619999522515366,  /* xyz */
        44.82917102850265, -15.156712893784913, -129.56434065723533,  /* luv */
        44.82917102850265, 130.44786052553238, 263.3277434444127,  /* lch */
        263.3277434444127, 99.9999999999993, 44.82917102850265,  /* hsluv */
        263.3277434444127, 369.24581273526184, 44.82917102850265,  /* hpluv */
    },
    {
        "#336600",
        0.2, 0.4, 0.0,  /* rgb */
        0.06116373213354561, 0.10206262662897396, 0.01647715257049183,  /* xyz */
        38.21010346802296, -24.2353400261634, 45.32980296944919,  /* luv */
        38.21010346802296, 51.40177762911359, 118.13095288918932,  /* lch */
        118.13095288918932, 100.00000000000229, 38.21010346802296,  /* hsluv */
        118.13095288918932, 170.7022522664182, 38.21010346802296,  /* hpluv */
    },
    {
        "#336611",
        0.2, 0.4, 0.06666666666666667,  /* rgb */
        0.062175397633182736, 0.10246729282882881, 0.02180525753524746,  /* xyz */
        38.281654529211096, -24.098680839919968, 42.64470024809137,  /* luv */
        38.281654529211096, 48.98282226938225, 119.47095490893435,  /* lch */
        119.47095490893435, 93.5286374368429, 38.281654529211096,  /* hsluv */
        119.47095490893435, 162.36500540628916, 38.281654529211096,  /* hpluv */
    },
    {
        "#336622",
        0.2, 0.4, 0.13333333333333333,  /* rgb */
        0.06405075577165975, 0.10321743608421963, 0.03168214373122666,  /* xyz */
        38.41379443041326, -23.856297846722637, 37.83800761526562,  /* luv */
        38.41379443041326, 44.73072509186993, 122.23081806660278,  /* lch */
        122.23081806660278, 81.99494757255522, 38.41379443041326,  /* hsluv */
        122.23081806660278, 147.76039955080003, 38.41379443041326,  /* hpluv */
    },
    {
        "#336633",
        0.2, 0.4, 0.2,  /* rgb */
        0.06713850650411748, 0.10445253637720274, 0.0479442975888378,  /* xyz */
        38.62997301265452, -23.485807509958697, 30.37063392019242,  /* luv */
        38.62997301265452, 38.39216793968758, 127.71501294923944,  /* lch */
        127.71501294923944, 64.2136550115152, 38.62997301265452,  /* hsluv */
        127.71501294923944, 126.11233256580783, 38.62997301265452,  /* hpluv */
    },
    {
        "#336644",
        0.2, 0.4, 0.26666666666666666,  /* rgb */
        0.07159650174833637, 0.10623573447489032, 0.07142307254172445,  /* xyz */
        38.93909875991476, -23.00642367413321, 20.45953294833656,  /* luv */
        38.93909875991476, 30.78779009181702, 138.3534158067084,  /* lch */
        138.3534158067084, 66.14906139154769, 38.93909875991476,  /* hsluv */
        138.3534158067084, 100.33026233930133, 38.93909875991476,  /* hpluv */
    },
    {
        "#336655",
        0.2, 0.4, 0.3333333333333333,  /* rgb */
        0.07755891578769836, 0.10862070009063515, 0.10282511981569835,  /* xyz */
        39.34718302935321, -22.451978364156542, 8.568615668112445,  /* luv */
        39.34718302935321, 24.031489902467044, 159.11105014365694,  /* lch */
        159.11105014365694, 68.43244215995443, 39.34718302935321,  /* hsluv */
        159.11105014365694, 77.50083435038981, 39.34718302935321,  /* hpluv */
    },
    {
        "#336666",
        0.2, 0.4, 0.4,  /* rgb */
        0.08514391156120654, 0.11165469840003847, 0.1427727642228423,  /* xyz */
        39.857778151087565, -21.862851970077077, -4.717750360338379,  /* luv */
        39.857778151087565, 22.366078438742363, 192.177050630061,  /* lch */
        192.177050630061, 70.92719629984897, 39.857778151087565,  /* hsluv */
        192.177050630061, 71.20591714935254, 39.857778151087565,  /* hpluv */
    },
    {
        "#336677",
        0.2, 0.4, 0.4666666666666667,  /* rgb */
        0.09445792458140845, 0.11538030360811928, 0.1918265661292402,  /* xyz */
        40.4722660639059, -21.27826099289813, -18.81453566188387,  /* luv */
        40.4722660639059, 28.40336499526403, 221.48356328962527,  /* lch */
        221.48356328962527, 73.4989606489913, 40.4722660639059,  /* hsluv */
        221.48356328962527, 89.05362444662185, 40.4722660639059,  /* hpluv */
    },
    {
        "#336688",
        0.2, 0.4, 0.5333333333333333,  /* rgb */
        0.10559834168335228, 0.11983647044889688, 0.2504994295328124,  /* xyz */
        41.19011795821427, -20.730837130992654, -33.22073253946685,  /* luv */
        41.19011795821427, 39.158456029452125, 238.03447127457403,  /* lch */
        238.03447127457403, 76.03463202464287, 41.19011795821427,  /* hsluv */
        238.03447127457403, 120.63458947081813, 41.19011795821427,  /* hpluv */
    },
    {
        "#336699",
        0.2, 0.4, 0.6,  /* rgb */
        0.118655305792425, 0.12505925609252605, 0.3192661071739303,  /* xyz */
        42.009163494482195, -20.244149803297628, -47.559331810385295,  /* luv */
        42.009163494482195, 51.68864133935696, 246.942440261812,  /* lch */
        246.942440261812, 78.45117445648185, 42.009163494482195,  /* hsluv */
        246.942440261812, 156.131455895945, 42.009163494482195,  /* hpluv */
    },
    {
        "#3366aa",
        0.2, 0.4, 0.6666666666666666,  /* rgb */
        0.13371299875767753, 0.13108233327862714, 0.3985699567909289,  /* xyz */
        42.925875474070985, -19.832670948043944, -61.58026811724182,  /* luv */
        42.925875474070985, 64.6951641030825, 252.14821729394077,  /* lch */
        252.14821729394077, 80.6959595489171, 42.925875474070985,  /* hsluv */
        252.14821729394077, 191.2458342126533, 42.925875474070985,  /* hpluv */
    },
    {
        "#3366bb",
        0.2, 0.4, 0.7333333333333333,  /* rgb */
        0.15085059086501418, 0.1379373701215619, 0.4888279418895706,  /* xyz */
        43.93566152226311, -19.5031901130623, -75.14135662535364,  /* luv */
        43.93566152226311, 77.63116577821582, 255.44975766251605,  /* lch */
        255.44975766251605, 82.74207909112404, 43.93566152226311,  /* hsluv */
        255.44975766251605, 224.21169645095068, 43.93566152226311,  /* hpluv */
    },
    {
        "#3366cc",
        0.2, 0.4, 0.8,  /* rgb */
        0.17014296630873593, 0.1456543202990507, 0.5904344525598408,  /* xyz */
        45.03314922580453, -19.256763488045266, -88.18104973027758,  /* luv */
        45.03314922580453, 90.25918497066213, 257.68127843290245,  /* lch */
        257.68127843290245, 84.58180158212187, 45.03314922580453,  /* hsluv */
        257.68127843290245, 254.3304825683642, 45.03314922580453,  /* hpluv */
    },
    {
        "#3366dd",
        0.2, 0.4, 0.8666666666666667,  /* rgb */
        0.19166129185936948, 0.15426165051930424, 0.7037643004598468,  /* xyz */
        46.21245130474254, -19.090600305670804, -100.69197776955104,  /* luv */
        46.21245130474254, 102.48573270057955, 259.2644831605708,  /* lch */
        259.2644831605708, 86.22023373850415, 46.21245130474254,  /* hsluv */
        259.2644831605708, 281.41272456633055, 46.21245130474254,  /* hpluv */
    },
    {
        "#3366ee",
        0.2, 0.4, 0.9333333333333333,  /* rgb */
        0.2154734721255442, 0.16378652262577426, 0.8291751165283701,  /* xyz */
        47.46740038474169, -18.99960653492559, -112.69944712944584,  /* luv */
        47.46740038474169, 114.28976521003422, 260.43068521754094,  /* lch */
        260.43068521754094, 89.42163951095385, 47.46740038474169,  /* hsluv */
        260.43068521754094, 305.52814227057473, 47.46740038474169,  /* hpluv */
    },
    {
        "#3366ff",
        0.2, 0.4, 1.0,  /* rgb */
        0.2416445205353756, 0.17425494198970698, 0.9670093048201519,  /* xyz */
        48.79174705740181, -18.97751942720264, -124.24585327052579,  /* luv */
        48.79174705740181, 125.68682627280744, 261.31566692699016,  /* lch */
        261.31566692699016, 99.99999999999922, 48.79174705740181,  /* hsluv */
        261.31566692699016, 326.87576120737106, 48.79174705740181,  /* hpluv */
    },
    {
        "#337700",
        0.2, 0.4666666666666667, 0.0,  /* rgb */
        0.07961747018696325, 0.13897010273580973, 0.022628398588297533,  /* xyz */
        44.08486855442211, -31.606551080568867, 52.74253182832982,  /* luv */
        44.08486855442211, 61.48779338105241, 120.93261983141262,  /* lch */
        120.93261983141262, 100.00000000000222, 44.08486855442211,  /* hsluv */
        120.93261983141262, 176.9859062795888, 44.08486855442211,  /* hpluv */
    },
    {
        "#337711",
        0.2, 0.4666666666666667, 0.06666666666666667,  /* rgb */
        0.08062913568660036, 0.13937476893566458, 0.027956503553053166,  /* xyz */
        44.143132293210016, -31.456044261391543, 50.449987584497805,  /* luv */
        44.143132293210016, 59.453208221681415, 121.94392943214885,  /* lch */
        121.94392943214885, 95.22321078158164, 44.143132293210016,  /* hsluv */
        121.94392943214885, 170.9037039308192, 44.143132293210016,  /* hpluv */
    },
    {
        "#337722",
        0.2, 0.4666666666666667, 0.13333333333333333,  /* rgb */
        0.0825044938250774, 0.1401249121910554, 0.03783338974903236,  /* xyz */
        44.25084013124585, -31.18572771371092, 46.30916198517076,  /* luv */
        44.25084013124585, 55.83088837554443, 123.95729336248694,  /* lch */
        123.95729336248694, 86.6219708852072, 44.25084013124585,  /* hsluv */
        123.95729336248694, 160.10037324352618, 44.25084013124585,  /* hpluv */
    },
    {
        "#337733",
        0.2, 0.4666666666666667, 0.2,  /* rgb */
        0.08559224455753513, 0.1413600124840385, 0.05409554360664351,  /* xyz */
        44.42734515775547, -30.763810097430998, 39.78217117138533,  /* luv */
        44.42734515775547, 50.289493483432494, 127.71501294923979,  /* lch */
        127.71501294923979, 73.13681744418784, 44.42734515775547,  /* hsluv */
        127.71501294923979, 143.63696697645142, 44.42734515775547,  /* hpluv */
    },
    {
        "#337744",
        0.2, 0.4666666666666667, 0.26666666666666666,  /* rgb */
        0.090050239801754, 0.1431432105817261, 0.07757431855953015,  /* xyz */
        44.680372831529574, -30.201036720586533, 30.942223149479776,  /* luv */
        44.680372831529574, 43.23799015253159, 134.30548723816383,  /* lch */
        134.30548723816383, 74.24229208981237, 44.680372831529574,  /* hsluv */
        134.30548723816383, 122.79707903720151, 44.680372831529574,  /* hpluv */
    },
    {
        "#337755",
        0.2, 0.4666666666666667, 0.3333333333333333,  /* rgb */
        0.096012653841116, 0.14552817619747094, 0.10897636583350405,  /* xyz */
        45.015524859204206, -29.523812936449573, 20.07108343998737,  /* luv */
        45.015524859204206, 35.7001949681147, 145.79107873396384,  /* lch */
        145.79107873396384, 75.58602322444334, 45.015524859204206,  /* hsluv */
        145.79107873396384, 100.6346629227975, 45.015524859204206,  /* hpluv */
    },
    {
        "#337766",
        0.2, 0.4666666666666667, 0.4,  /* rgb */
        0.10359764961462417, 0.14856217450687423, 0.14892401024064802,  /* xyz */
        45.436632811343884, -28.768526948933104, 7.586636045672685,  /* luv */
        45.436632811343884, 29.752061933603702, 165.22669317203713,  /* lch */
        165.22669317203713, 77.10541953634062, 45.436632811343884,  /* hsluv */
        165.22669317203713, 83.09028649958618, 45.436632811343884,  /* hpluv */
    },
    {
        "#337777",
        0.2, 0.4666666666666667, 0.4666666666666667,  /* rgb */
        0.11291166263482609, 0.15228777971495505, 0.19797781214704593,  /* xyz */
        45.94596282003257, -27.975196898508273, -6.036723636473014,  /* luv */
        45.94596282003257, 28.619113783858836, 192.17705063006102,  /* lch */
        192.17705063006102, 78.73083531844497, 45.94596282003257,  /* hsluv */
        192.17705063006102, 79.04022193524163, 45.94596282003257,  /* hpluv */
    },
    {
        "#337788",
        0.2, 0.4666666666666667, 0.5333333333333333,  /* rgb */
        0.12405207973676992, 0.15674394655573265, 0.2566506755506181,  /* xyz */
        46.54437375339183, -27.18184685313583, -20.338386790418284,  /* luv */
        46.54437375339183, 33.948531272854666, 216.80509122672848,  /* lch */
        216.80509122672848, 80.39558973498764, 46.54437375339183,  /* hsluv */
        216.80509122672848, 92.55355935623446, 46.54437375339183,  /* hpluv */
    },
    {
        "#337799",
        0.2, 0.4666666666666667, 0.6,  /* rgb */
        0.13710904384584263, 0.1619667321993618, 0.325417353191736,  /* xyz */
        47.23146770073121, -26.42061992629464, -34.92042907989731,  /* luv */
        47.23146770073121, 43.78910280439478, 232.8890350897692,  /* lch */
        232.8890350897692, 82.04290450740461, 47.23146770073121,  /* hsluv */
        232.8890350897692, 117.64512410410661, 47.23146770073121,  /* hpluv */
    },
    {
        "#3377aa",
        0.2, 0.4666666666666667, 0.6666666666666666,  /* rgb */
        0.15216673681109516, 0.1679898093854629, 0.4047212028087346,  /* xyz */
        48.00574667721975, -25.715901975482936, -49.47185481839534,  /* luv */
        48.00574667721975, 55.75636316677257, 242.53419548155694,  /* lch */
        242.53419548155694, 83.62928275106731, 48.00574667721975,  /* hsluv */
        242.53419548155694, 147.38067309793576, 48.00574667721975,  /* hpluv */
    },
    {
        "#3377bb",
        0.2, 0.4666666666666667, 0.7333333333333333,  /* rgb */
        0.16930432891843183, 0.17484484622839766, 0.49497918790737633,  /* xyz */
        48.86477775029496, -25.084131846423176, -63.7721851155626,  /* luv */
        48.86477775029496, 68.52813484184671, 248.52831601351184,  /* lch */
        248.52831601351184, 85.1249045257873, 48.86477775029496,  /* hsluv */
        248.52831601351184, 177.95586680914604, 48.86477775029496,  /* hpluv */
    },
    {
        "#3377cc",
        0.2, 0.4666666666666667, 0.8,  /* rgb */
        0.18859670436215356, 0.18256179640588646, 0.5965856985776465,  /* xyz */
        49.805363039032684, -24.53470406811355, -77.68166176488126,  /* luv */
        49.805363039032684, 81.46405513024331, 252.47198164491263,  /* lch */
        252.47198164491263, 86.51209029500207, 49.805363039032684,  /* hsluv */
        252.47198164491263, 207.55310799955734, 49.805363039032684,  /* hpluv */
    },
    {
        "#3377dd",
        0.2, 0.4666666666666667, 0.8666666666666667,  /* rgb */
        0.2101150299127871, 0.19116912662614, 0.7099155464776525,  /* xyz */
        50.823708601995705, -24.07138203371225, -91.1251710758325,  /* luv */
        50.823708601995705, 94.2508792352234, 255.20289561126955,  /* lch */
        255.20289561126955, 87.7828608732328, 50.823708601995705,  /* hsluv */
        255.20289561126955, 235.31975334352938, 50.823708601995705,  /* hpluv */
    },
    {
        "#3377ee",
        0.2, 0.4666666666666667, 0.9333333333333333,  /* rgb */
        0.23392721017896184, 0.20069399873261004, 0.8353263625461758,  /* xyz */
        51.91558584156725, -23.693795964224766, -104.07506914110085,  /* luv */
        51.91558584156725, 106.73807185779232, 257.1746020466875,  /* lch */
        257.1746020466875, 88.93634546028757, 51.91558584156725,  /* hsluv */
        257.1746020466875, 260.8920952724066, 51.91558584156725,  /* hpluv */
    },
    {
        "#3377ff",
        0.2, 0.4666666666666667, 1.0,  /* rgb */
        0.2600982585887932, 0.21116241809654274, 0.9731605508379576,  /* xyz */
        53.07647990830827, -23.398780931745225, -116.53587310677126,  /* luv */
        53.07647990830827, 118.86173761917372, 258.6467673839638,  /* lch */
        258.6467673839638, 99.99999999999908, 53.07647990830827,  /* hsluv */
        258.6467673839638, 284.1706947854258, 53.07647990830827,  /* hpluv */
    },
    {
        "#338800",
        0.2, 0.5333333333333333, 0.0,  /* rgb */
        0.1016898399119337, 0.18311484218575128, 0.02998585516328748,  /* xyz */
        49.87174547535089, -38.51079069346019, 60.00098219600165,  /* luv */
        49.87174547535089, 71.29655576758535, 122.69380865426514,  /* lch */
        122.69380865426514, 100.00000000000225, 49.87174547535089,  /* hsluv */
        122.69380865426514, 181.40669381427296, 49.87174547535089,  /* hpluv */
    },
    {
        "#338811",
        0.2, 0.5333333333333333, 0.06666666666666667,  /* rgb */
        0.10270150541157082, 0.18351950838560613, 0.03531396012804311,  /* xyz */
        49.920233183738105, -38.361169332567485, 58.02244432747415,  /* luv */
        49.920233183738105, 69.55705110408832, 123.47043015419375,  /* lch */
        123.47043015419375, 96.36249653149443, 49.920233183738105,  /* hsluv */
        123.47043015419375, 176.80880254001067, 49.920233183738105,  /* hpluv */
    },
    {
        "#338822",
        0.2, 0.5333333333333333, 0.13333333333333333,  /* rgb */
        0.10457686355004785, 0.18426965164099696, 0.04519084632402231,  /* xyz */
        50.0099282713402, -38.090318270923014, 54.42697179172183,  /* luv */
        50.0099282713402, 66.43167621245979, 124.98597057064686,  /* lch */
        124.98597057064686, 89.76727814461569, 50.0099282713402,  /* hsluv */
        124.98597057064686, 168.5614682885075, 50.0099282713402,  /* hpluv */
    },
    {
        "#338833",
        0.2, 0.5333333333333333, 0.2,  /* rgb */
        0.10766461428250558, 0.18550475193398006, 0.06145300018163345,  /* xyz */
        50.15708110293954, -37.661963919405714, 48.70250760706141,  /* luv */
        50.15708110293954, 61.56588156992875, 127.71501294923999,  /* lch */
        127.71501294923999, 79.30800154183744, 50.15708110293954,  /* hsluv */
        127.71501294923999, 155.75685675858716, 50.15708110293954,  /* hpluv */
    },
    {
        "#338844",
        0.2, 0.5333333333333333, 0.26666666666666666,  /* rgb */
        0.11212260952672445, 0.18728795003166765, 0.08493177513452009,  /* xyz */
        50.36838778436422, -37.079522885778644, 40.83800803779715,  /* luv */
        50.36838778436422, 55.16007539817333, 132.23838080591742,  /* lch */
        132.23838080591742, 79.97016309263199, 50.36838778436422,  /* hsluv */
        132.23838080591742, 138.96522268171307, 50.36838778436422,  /* hpluv */
    },
    {
        "#338855",
        0.2, 0.5333333333333333, 0.3333333333333333,  /* rgb */
        0.11808502356608645, 0.18967291564741248, 0.11633382240849399,  /* xyz */
        50.64891686971325, -36.36080938719669, 30.990926990033774,  /* luv */
        50.64891686971325, 47.77599831498715, 139.55848896953574,  /* lch */
        139.55848896953574, 80.79225510950877, 50.64891686971325,  /* hsluv */
        139.55848896953574, 119.69580637435008, 50.64891686971325,  /* hpluv */
    },
    {
        "#338866",
        0.2, 0.5333333333333333, 0.4,  /* rgb */
        0.12567001933959462, 0.19270691395681577, 0.15628146681563795,  /* xyz */
        51.002409593858275, -35.5343950908498, 19.445416273812445,  /* luv */
        51.002409593858275, 40.50700493167151, 151.3112863122482,  /* lch */
        151.3112863122482, 81.74537836440282, 51.002409593858275,  /* hsluv */
        151.3112863122482, 100.78102351571394, 51.002409593858275,  /* hpluv */
    },
    {
        "#338877",
        0.2, 0.5333333333333333, 0.4666666666666667,  /* rgb */
        0.13498403235979656, 0.1964325191648966, 0.20533526872203586,  /* xyz */
        51.431442669216096, -34.63511843395795, 6.562255054951342,  /* luv */
        51.431442669216096, 35.25130664727944, 169.27144162573657,  /* lch */
        169.27144162573657, 82.79380722808442, 51.431442669216096,  /* hsluv */
        169.27144162573657, 86.97327811048865, 51.431442669216096,  /* hpluv */
    },
    {
        "#338888",
        0.2, 0.5333333333333333, 0.5333333333333333,  /* rgb */
        0.14612444946174036, 0.2008886860056742, 0.26400813212560803,  /* xyz */
        51.93753970677548, -33.699492027633646, -7.271960258167055,  /* luv */
        51.93753970677548, 34.47516742405909, 192.17705063006107,  /* lch */
        192.17705063006107, 83.89982317648766, 51.93753970677548,  /* hsluv */
        192.17705063006107, 84.229522237058, 51.93753970677548,  /* hpluv */
    },
    {
        "#338899",
        0.2, 0.5333333333333333, 0.6,  /* rgb */
        0.15918141357081309, 0.20611147164930335, 0.33277480976672597,  /* xyz */
        52.52126582538823, -32.76181329495382, -21.68784770470414,  /* luv */
        52.52126582538823, 39.2899369869163, 213.50398438717448,  /* lch */
        213.50398438717448, 85.02780678137181, 52.52126582538823,  /* hsluv */
        213.50398438717448, 94.92606411431464, 52.52126582538823,  /* hpluv */
    },
    {
        "#3388aa",
        0.2, 0.5333333333333333, 0.6666666666666666,  /* rgb */
        0.1742391065360656, 0.21213454883540445, 0.41207865938372457,  /* xyz */
        53.182320370371414, -31.851482232687616, -36.363113854553475,  /* luv */
        53.182320370371414, 48.340386527399986, 228.78396315405593,  /* lch */
        228.78396315405593, 86.14706469701956, 53.182320370371414,  /* hsluv */
        228.78396315405593, 115.34058859043583, 53.182320370371414,  /* hpluv */
    },
    {
        "#3388bb",
        0.2, 0.5333333333333333, 0.7333333333333333,  /* rgb */
        0.1913766986434023, 0.2189895856783392, 0.5023366444823663,  /* xyz */
        53.919633503643624, -30.991635626710483, -51.0381213421469,  /* luv */
        53.919633503643624, 59.71073026646469, 238.73281945022063,  /* lch */
        238.73281945022063, 87.23327892236863, 53.919633503643624,  /* hsluv */
        238.73281945022063, 140.52214730552086, 53.919633503643624,  /* hpluv */
    },
    {
        "#3388cc",
        0.2, 0.5333333333333333, 0.8,  /* rgb */
        0.21066907408712401, 0.226706535855828, 0.6039431551526364,  /* xyz */
        54.73146763229953, -30.198900966819405, -65.51929921216644,  /* luv */
        54.73146763229953, 72.14396848564098, 245.2542622742995,  /* lch */
        245.2542622742995, 88.2687848362996, 54.73146763229953,  /* hsluv */
        245.2542622742995, 167.26391618686648, 54.73146763229953,  /* hpluv */
    },
    {
        "#3388dd",
        0.2, 0.5333333333333333, 0.8666666666666667,  /* rgb */
        0.23218739963775756, 0.23531386607608154, 0.7172730030526424,  /* xyz */
        55.61552207498167, -29.483925732219873, -79.67413383004417,  /* luv */
        55.61552207498167, 84.95451417170747, 249.69268233897776,  /* lch */
        249.69268233897776, 89.24203833660219, 55.61552207498167,  /* hsluv */
        249.69268233897776, 193.83391551788287, 55.61552207498167,  /* hpluv */
    },
    {
        "#3388ee",
        0.2, 0.5333333333333333, 0.9333333333333333,  /* rgb */
        0.2559995799039323, 0.24483873818255159, 0.8426838191211656,  /* xyz */
        56.56903813445683, -28.852329008539563, -93.42156408596756,  /* luv */
        56.56903813445683, 97.77548529915644, 252.83721230554255,  /* lch */
        252.83721230554255, 90.14664120258333, 56.56903813445683,  /* hsluv */
        252.83721230554255, 219.32619909500923, 56.56903813445683,  /* hpluv */
    },
    {
        "#3388ff",
        0.2, 0.5333333333333333, 1.0,  /* rgb */
        0.2821706283137637, 0.25530715754648425, 0.9805180074129475,  /* xyz */
        57.58890138805282, -28.305794101303576, -106.7208212878177,  /* luv */
        57.58890138805282, 110.41083133484557, 255.14534461523846,  /* lch */
        255.14534461523846, 99.99999999999885, 57.58890138805282,  /* hsluv */
        255.14534461523846, 243.2832521726942, 57.58890138805282,  /* hpluv */
    },
    {
        "#339900",
        0.2, 0.6, 0.0,  /* rgb */
        0.12755944036440117, 0.23485404309068697, 0.038609055314109735,  /* xyz */
        55.5688440832231, -45.04260543763115, 67.11455644731636,  /* luv */
        55.5688440832231, 80.82821284508357, 123.8667547151093,  /* lch */
        123.8667547151093, 100.00000000000226, 55.5688440832231,  /* hsluv */
        123.8667547151093, 184.57417675776583, 55.5688440832231,  /* hpluv */
    },
    {
        "#339911",
        0.2, 0.6, 0.06666666666666667,  /* rgb */
        0.1285711058640383, 0.23525870929054182, 0.043937160278865364,  /* xyz */
        55.609926157881446, -44.90005557878074, 65.38927316922386,  /* luv */
        55.609926157881446, 79.32069109997074, 124.47574378522599,  /* lch */
        124.47574378522599, 97.15716931729726, 55.609926157881446,  /* hsluv */
        124.47574378522599, 180.99788395414978, 55.609926157881446,  /* hpluv */
    },
    {
        "#339922",
        0.2, 0.6, 0.13333333333333333,  /* rgb */
        0.1304464640025153, 0.23600885254593265, 0.053814046474844564,  /* xyz */
        55.68595693786821, -44.64062629288815, 62.240576763164114,  /* luv */
        55.68595693786821, 76.59422244290114, 125.64911487220355,  /* lch */
        125.64911487220355, 91.97784138641171, 55.68595693786821,  /* hsluv */
        125.64911487220355, 174.53786169861013, 55.68595693786821,  /* hpluv */
    },
    {
        "#339933",
        0.2, 0.6, 0.2,  /* rgb */
        0.13353421473497307, 0.23724395283891575, 0.07007620033245571,  /* xyz */
        55.81079031108793, -44.22664474149426, 57.191613973364035,  /* luv */
        55.81079031108793, 72.29714250209776, 127.71501294924015,  /* lch */
        127.71501294924015, 83.69742917682409, 55.81079031108793,  /* hsluv */
        127.71501294924015, 164.37746802230893, 55.81079031108793,  /* hpluv */
    },
    {
        "#339944",
        0.2, 0.6, 0.26666666666666666,  /* rgb */
        0.13799220997919193, 0.23902715093660334, 0.09355497528534235,  /* xyz */
        55.99025869935636, -43.656292650541104, 50.18335970097191,  /* luv */
        55.99025869935636, 66.51497183993105, 131.02116974129345,  /* lch */
        131.02116974129345, 84.11126634111274, 55.99025869935636,  /* hsluv */
        131.02116974129345, 150.74616204638224, 55.99025869935636,  /* hpluv */
    },
    {
        "#339955",
        0.2, 0.6, 0.3333333333333333,  /* rgb */
        0.1439546240185539, 0.24141211655234818, 0.12495702255931626,  /* xyz */
        56.2289015921924, -42.94019164631238, 41.29136452022203,  /* luv */
        56.2289015921924, 59.57211463901451, 136.12141786476622,  /* lch */
        136.12141786476622, 84.63299553802862, 56.2289015921924,  /* hsluv */
        136.12141786476622, 134.4382167835967, 56.2289015921924,  /* hpluv */
    },
    {
        "#339966",
        0.2, 0.6, 0.4,  /* rgb */
        0.1515396197920621, 0.24444611486175147, 0.16490466696646022,  /* xyz */
        56.53022681914875, -42.09910128658168, 30.700698275986678,  /* luv */
        56.53022681914875, 52.104387567373195, 143.89866228402664,  /* lch */
        143.89866228402664, 85.24917249486147, 56.53022681914875,  /* hsluv */
        143.89866228402664, 116.95879739611156, 56.53022681914875,  /* hpluv */
    },
    {
        "#339977",
        0.2, 0.6, 0.4666666666666667,  /* rgb */
        0.160853632812264, 0.2481717200698323, 0.21395846887285813,  /* xyz */
        56.89684844275317, -41.160936600435186, 18.67488568952586,  /* luv */
        56.89684844275317, 45.19927053993131, 155.59600948799417,  /* lch */
        155.59600948799417, 85.94138626115799, 56.89684844275317,  /* hsluv */
        155.59600948799417, 100.80510845981033, 56.89684844275317,  /* hpluv */
    },
    {
        "#339988",
        0.2, 0.6, 0.5333333333333333,  /* rgb */
        0.17199404991420786, 0.2526278869106099, 0.27263133227643027,  /* xyz */
        57.330574208667926, -40.15740418495602, 5.521343719853591,  /* luv */
        57.330574208667926, 40.53519886896683, 172.17134267960472,  /* lch */
        172.17134267960472, 86.68854680189337, 57.330574208667926,  /* hsluv */
        172.17134267960472, 89.7191897797317, 57.330574208667926,  /* hpluv */
    },
    {
        "#339999",
        0.2, 0.6, 0.6,  /* rgb */
        0.18505101402328056, 0.25785067255423905, 0.3413980099175482,  /* xyz */
        57.83247245879316, -39.12076023268747, -8.44180717763071,  /* luv */
        57.83247245879316, 40.021219241893654, 192.1770506300611,  /* lch */
        192.1770506300611, 87.46908637127622, 57.83247245879316,  /* hsluv */
        192.1770506300611, 87.81281147716703, 57.83247245879316,  /* hpluv */
    },
    {
        "#3399aa",
        0.2, 0.6, 0.6666666666666666,  /* rgb */
        0.2001087069885331, 0.26387374974034017, 0.4207018595345468,  /* xyz */
        58.40293233294496, -38.08113468608119, -22.913170914918652,  /* luv */
        58.40293233294496, 44.44306717988454, 211.03504878498663,  /* lch */
        211.03504878498663, 88.2627766327166, 58.40293233294496,  /* hsluv */
        211.03504878498663, 96.56254357372102, 58.40293233294496,  /* hpluv */
    },
    {
        "#3399bb",
        0.2, 0.6, 0.7333333333333333,  /* rgb */
        0.21724629909586973, 0.2707287865832749, 0.5109598446331886,  /* xyz */
        59.04172375075508, -37.06467581425392, -37.627221354990745,  /* luv */
        59.04172375075508, 52.816644915340945, 225.43151770239206,  /* lch */
        225.43151770239206, 89.05199073310412, 59.04172375075508,  /* hsluv */
        225.43151770239206, 113.51443922955168, 59.04172375075508,  /* hpluv */
    },
    {
        "#3399cc",
        0.2, 0.6, 0.8,  /* rgb */
        0.2365386745395915, 0.27844573676076373, 0.6125663553034587,  /* xyz */
        59.74805982690184, -36.092557495659165, -52.36475733681147,  /* luv */
        59.74805982690184, 63.59827448540262, 235.42333623797987,  /* lch */
        235.42333623797987, 89.82238227161886, 59.74805982690184,  /* hsluv */
        235.42333623797987, 135.0706071627098, 59.74805982690184,  /* hpluv */
    },
    {
        "#3399dd",
        0.2, 0.6, 0.8666666666666667,  /* rgb */
        0.25805700009022503, 0.28705306698101724, 0.7258962032034647,  /* xyz */
        60.520662198297686, -35.18073046992372, -66.95586892206653,  /* luv */
        60.520662198297686, 75.63578636800422, 242.2811441956066,  /* lch */
        242.2811441956066, 90.56306161979765, 60.520662198297686,  /* hsluv */
        242.2811441956066, 158.58531958905732, 60.520662198297686,  /* hpluv */
    },
    {
        "#3399ee",
        0.2, 0.6, 0.9333333333333333,  /* rgb */
        0.28186918035639974, 0.29657793908748725, 0.8513070192719879,  /* xyz */
        61.35782849655868, -34.340216286022795, -81.27744101904966,  /* luv */
        61.35782849655868, 88.23419333328731, 247.0956446367521,  /* lch */
        247.0956446367521, 91.26640564949335, 61.35782849655868,  /* hsluv */
        247.0956446367521, 182.4762153690063, 61.35782849655868,  /* hpluv */
    },
    {
        "#3399ff",
        0.2, 0.6, 1.0,  /* rgb */
        0.30804022876623116, 0.30704635845142, 0.9891412075637698,  /* xyz */
        62.257500543470655, -33.57773013611336, -95.2473425151972,  /* luv */
        62.257500543470655, 100.99267407738517, 250.5808182685887,  /* lch */
        250.5808182685887, 99.99999999999858, 62.257500543470655,  /* hsluv */
        250.5808182685887, 205.84367033720622, 62.257500543470655,  /* hpluv */
    },
    {
        "#33aa00",
        0.2, 0.6666666666666666, 0.0,  /* rgb */
        0.1573930599939705, 0.2945212823498264, 0.04855359519063255,  /* xyz */
        61.17859771729631, -51.27497161424697, 74.09482911373847,  /* luv */
        61.17859771729631, 90.10641717123114, 124.68394011287431,  /* lch */
        124.68394011287431, 100.0000000000023, 61.17859771729631,  /* hsluv */
        124.68394011287431, 186.89407345481192, 61.17859771729631,  /* hpluv */
    },
    {
        "#33aa11",
        0.2, 0.6666666666666666, 0.06666666666666667,  /* rgb */
        0.15840472549360762, 0.29492594854968124, 0.05388170015538818,  /* xyz */
        61.21392881081678, -51.14176808613798, 72.57603605448521,  /* luv */
        61.21392881081678, 88.78491680661901, 125.17100026123383,  /* lch */
        125.17100026123383, 97.72926387949144, 61.21392881081678,  /* hsluv */
        125.17100026123383, 184.0467973094407, 61.21392881081678,  /* hpluv */
    },
    {
        "#33aa22",
        0.2, 0.6666666666666666, 0.13333333333333333,  /* rgb */
        0.16028008363208462, 0.29567609180507204, 0.06375858635136737,  /* xyz */
        61.279337850783264, -50.89843106566937, 69.79558319397836,  /* luv */
        61.279337850783264, 86.38329536625847, 126.10140218084841,  /* lch */
        126.10140218084841, 93.57780908153381, 61.279337850783264,  /* hsluv */
        126.10140218084841, 178.87721730558533, 61.279337850783264,  /* hpluv */
    },
    {
        "#33aa33",
        0.2, 0.6666666666666666, 0.2,  /* rgb */
        0.16336783436454239, 0.29691119209805517, 0.08002074020897852,  /* xyz */
        61.386792304464095, -50.50764669682631, 65.3138814728533,  /* luv */
        61.386792304464095, 82.56467457636685, 127.71501294924012,  /* lch */
        127.71501294924012, 86.90174387360933, 61.386792304464095,  /* hsluv */
        127.71501294924012, 170.67057811881446, 61.386792304464095,  /* hpluv */
    },
    {
        "#33aa44",
        0.2, 0.6666666666666666, 0.26666666666666666,  /* rgb */
        0.16782582960876125, 0.29869439019574273, 0.10349951516186516,  /* xyz */
        61.541407155020536, -49.96416073540373, 59.04561467899356,  /* luv */
        61.541407155020536, 77.34857445883175, 130.2377645231648,  /* lch */
        130.2377645231648, 87.17022673557747, 61.541407155020536,  /* hsluv */
        130.2377645231648, 159.48660683700476, 61.541407155020536,  /* hpluv */
    },
    {
        "#33aa55",
        0.2, 0.6666666666666666, 0.3333333333333333,  /* rgb */
        0.17378824364812323, 0.3010793558114876, 0.13490156243583906,  /* xyz */
        61.74724022799528, -49.27320696131116, 51.01327633996389,  /* luv */
        61.74724022799528, 70.92392605594901, 134.00596147156574,  /* lch */
        134.00596147156574, 87.51256762107217, 61.74724022799528,  /* hsluv */
        134.00596147156574, 145.75200681537197, 61.74724022799528,  /* hpluv */
    },
    {
        "#33aa66",
        0.2, 0.6666666666666666, 0.4,  /* rgb */
        0.18137323942163142, 0.3041133541208909, 0.17484920684298302,  /* xyz */
        62.00752272359608, -48.449008798230025, 41.331224612313044,  /* luv */
        62.00752272359608, 63.683408997041305, 139.53293291707666,  /* lch */
        139.53293291707666, 87.92253453155968, 62.00752272359608,  /* hsluv */
        139.53293291707666, 130.32305400344185, 62.00752272359608,  /* hpluv */
    },
    {
        "#33aa77",
        0.2, 0.6666666666666666, 0.4666666666666667,  /* rgb */
        0.19068725244183332, 0.3078389593289717, 0.22390300874938093,  /* xyz */
        62.32477992626562, -47.51283612854417, 30.186220789883915,  /* luv */
        62.32477992626562, 56.2910074750267, 147.57107426517302,  /* lch */
        147.57107426517302, 88.39055889976815, 62.32477992626562,  /* hsluv */
        147.57107426517302, 114.60870212546067, 62.32477992626562,  /* hpluv */
    },
    {
        "#33aa88",
        0.2, 0.6666666666666666, 0.5333333333333333,  /* rgb */
        0.20182766954377718, 0.3122951261697493, 0.2825758721529531,  /* xyz */
        62.700904687653505, -46.490664182460215, 17.814473684822136,  /* luv */
        62.700904687653505, 49.786919253891476, 159.03397227061822,  /* lch */
        159.03397227061822, 88.90482899636288, 62.700904687653505,  /* hsluv */
        159.03397227061822, 100.75828642452824, 62.700904687653505,  /* hpluv */
    },
    {
        "#33aa99",
        0.2, 0.6666666666666666, 0.6,  /* rgb */
        0.21488463365284988, 0.31751791181337846, 0.35134254979407104,  /* xyz */
        63.13720952971428, -45.41070330687708, 4.477591567112361,  /* luv */
        63.13720952971428, 45.63091935373528, 174.3687174787574,  /* lch */
        174.3687174787574, 89.4524406674979, 63.13720952971428,  /* hsluv */
        174.3687174787574, 91.70925423998936, 63.13720952971428,  /* hpluv */
    },
    {
        "#33aaaa",
        0.2, 0.6666666666666666, 0.6666666666666666,  /* rgb */
        0.22994232661810243, 0.3235409889994796, 0.43064639941106964,  /* xyz */
        63.63446965735389, -44.3011098571894, -9.5596666563997,  /* luv */
        63.63446965735389, 45.32080715477433, 192.17705063006116,  /* lch */
        192.17705063006116, 90.02046288158606, 63.63446965735389,  /* hsluv */
        192.17705063006116, 90.37421406866231, 63.63446965735389,  /* hpluv */
    },
    {
        "#33aabb",
        0.2, 0.6666666666666666, 0.7333333333333333,  /* rgb */
        0.24707991872543905, 0.33039602584241434, 0.5209043845097113,  /* xyz */
        64.19296310551898, -43.18812416055838, -24.047524596569566,  /* luv */
        64.19296310551898, 49.43174595065832, 209.10944220554316,  /* lch */
        209.10944220554316, 90.59680473965322, 64.19296310551898,  /* hsluv */
        209.10944220554316, 97.71423894082238, 64.19296310551898,  /* hpluv */
    },
    {
        "#33aacc",
        0.2, 0.6666666666666666, 0.8,  /* rgb */
        0.2663722941691608, 0.33811297601990314, 0.6225108951799815,  /* xyz */
        64.81251112396882, -42.094767306402574, -38.763963369324735,  /* luv */
        64.81251112396882, 57.224245654080306, 222.64115546848208,  /* lch */
        222.64115546848208, 91.17082322667959, 64.81251112396882,  /* hsluv */
        222.64115546848208, 112.03676353480263, 64.81251112396882,  /* hpluv */
    },
    {
        "#33aadd",
        0.2, 0.6666666666666666, 0.8666666666666667,  /* rgb */
        0.28789061971979435, 0.34672030624015665, 0.7358407430799875,  /* xyz */
        65.49252012746922, -41.040111954403265, -53.52200178860625,  /* luv */
        65.49252012746922, 67.44549995877802, 232.51938619928916,  /* lch */
        232.51938619928916, 91.73366484540975, 65.49252012746922,  /* hsluv */
        232.51938619928916, 130.6774353858715, 65.49252012746922,  /* hpluv */
    },
    {
        "#33aaee",
        0.2, 0.6666666666666666, 0.9333333333333333,  /* rgb */
        0.31170279998596906, 0.35624517834662667, 0.8612515591485107,  /* xyz */
        66.23202547083838, -40.039054494753934, -68.1721804788773,  /* luv */
        66.23202547083838, 79.0605595482254, 239.57332590229396,  /* lch */
        239.57332590229396, 92.27837489927443, 66.23202547083838,  /* hsluv */
        239.57332590229396, 151.47158630329915, 66.23202547083838,  /* hpluv */
    },
    {
        "#33aaff",
        0.2, 0.6666666666666666, 1.0,  /* rgb */
        0.3378738483958005, 0.3667135977105594, 0.9990857474402925,  /* xyz */
        67.0297366624436, -39.10246829911953, -82.60140071426099,  /* luv */
        67.0297366624436, 91.38924678014128, 244.66771177311068,  /* lch */
        244.66771177311068, 99.99999999999821, 67.0297366624436,  /* hsluv */
        244.66771177311068, 173.0082890574807, 67.0297366624436,  /* hpluv */
    },
    {
        "#33bb00",
        0.2, 0.7333333333333333, 0.0,  /* rgb */
        0.19134755790256927, 0.36243027816702494, 0.05987176116016517,  /* xyz */
        66.70519945600765, -57.26316297878643, 80.95317359937933,  /* luv */
        66.70519945600765, 99.15889344958578, 125.27412026031516,  /* lch */
        125.27412026031516, 100.00000000000233, 66.70519945600765,  /* hsluv */
        125.27412026031516, 188.63023729938135, 66.70519945600765,  /* hpluv */
    },
    {
        "#33bb11",
        0.2, 0.7333333333333333, 0.06666666666666667,  /* rgb */
        0.1923592234022064, 0.3628349443668798, 0.0651998661249208,  /* xyz */
        66.73596909864958, -57.13978536695441, 79.60467230369254,  /* luv */
        66.73596909864958, 97.98907553579579, 125.67057213213995,  /* lch */
        125.67057213213995, 98.15242857454975, 66.73596909864958,  /* hsluv */
        125.67057213213995, 186.31894461133135, 66.73596909864958,  /* hpluv */
    },
    {
        "#33bb22",
        0.2, 0.7333333333333333, 0.13333333333333333,  /* rgb */
        0.1942345815406834, 0.3635850876222706, 0.0750767523209,  /* xyz */
        66.7929473545782, -56.9137739802675, 77.1302768224563,  /* luv */
        66.7929473545782, 95.85539771648602, 126.42329996771947,  /* lch */
        126.42329996771947, 94.76590819034391, 66.7929473545782,  /* hsluv */
        126.42329996771947, 182.10643483359402, 66.7929473545782,  /* hpluv */
    },
    {
        "#33bb33",
        0.2, 0.7333333333333333, 0.2,  /* rgb */
        0.19732233227314117, 0.3648201879152537, 0.09133890617851115,  /* xyz */
        66.8865907457163, -56.549109923627306, 73.12638985374095,  /* luv */
        66.8865907457163, 92.44063352333643, 127.71501294924023,  /* lch */
        127.71501294924023, 89.29620690492656, 66.8865907457163,  /* hsluv */
        127.71501294924023, 175.37318098525898, 66.8865907457163,  /* hpluv */
    },
    {
        "#33bb44",
        0.2, 0.7333333333333333, 0.26666666666666666,  /* rgb */
        0.20178032751736003, 0.3666033860129413, 0.11481768113139779,  /* xyz */
        67.02141794072256, -56.038411952913776, 67.49431726129714,  /* luv */
        67.02141794072256, 87.72563181176356, 129.7017840039294,  /* lch */
        129.7017840039294, 89.47617496425909, 67.02141794072256,  /* hsluv */
        129.7017840039294, 166.09334038754355, 67.02141794072256,  /* hpluv */
    },
    {
        "#33bb55",
        0.2, 0.7333333333333333, 0.3333333333333333,  /* rgb */
        0.207742741556722, 0.36898835162868615, 0.14621972840537167,  /* xyz */
        67.20106294214006, -55.38308065401065, 60.22256516329788,  /* luv */
        67.20106294214006, 81.81713132086891, 132.60288320444127,  /* lch */
        132.60288320444127, 89.7076242739581, 67.20106294214006,  /* hsluv */
        132.60288320444127, 154.49251109602037, 67.20106294214006,  /* hpluv */
    },
    {
        "#33bb66",
        0.2, 0.7333333333333333, 0.4,  /* rgb */
        0.2153277373302302, 0.37202234993808947, 0.18616737281251566,  /* xyz */
        67.42848037927621, -54.592266890956225, 51.37591489076958,  /* luv */
        67.42848037927621, 74.9653268862145, 136.73851087198236,  /* lch */
        136.73851087198236, 89.98774634383301, 67.42848037927621,  /* hsluv */
        136.73851087198236, 141.07705768332076, 67.42848037927621,  /* hpluv */
    },
    {
        "#33bb77",
        0.2, 0.7333333333333333, 0.4666666666666667,  /* rgb */
        0.2246417503504321, 0.37574795514617026, 0.23522117471891357,  /* xyz */
        67.70605307949054, -53.68159816273245, 41.08291569802959,  /* luv */
        67.70605307949054, 67.5982244112705, 142.57290828080298,  /* lch */
        142.57290828080298, 90.3115397167098, 67.70605307949054,  /* hsluv */
        142.57290828080298, 126.69139486293237, 67.70605307949054,  /* hpluv */
    },
    {
        "#33bb88",
        0.2, 0.7333333333333333, 0.5333333333333333,  /* rgb */
        0.23578216745237596, 0.38020412198694786, 0.2938940381224857,  /* xyz */
        68.03565630960686, -52.67158330257773, 29.5206931148449,  /* luv */
        68.03565630960686, 60.38018722711313, 150.73080109197485,  /* lch */
        150.73080109197485, 90.67234524703424, 68.03565630960686,  /* hsluv */
        150.73080109197485, 112.61524948158088, 68.03565630960686,  /* hpluv */
    },
    {
        "#33bb99",
        0.2, 0.7333333333333333, 0.6,  /* rgb */
        0.24883913156144866, 0.385426907630577, 0.36266071576360365,  /* xyz */
        68.41870118659602, -51.58581488883419, 16.89802592956101,  /* luv */
        68.41870118659602, 54.282958449785916, 161.862695711717,  /* lch */
        161.862695711717, 91.0624469223214, 68.41870118659602,  /* hsluv */
        161.862695711717, 100.67647702146829, 68.41870118659602,  /* hpluv */
    },
    {
        "#33bbaa",
        0.2, 0.7333333333333333, 0.6666666666666666,  /* rgb */
        0.2638968245267012, 0.39144998481667814, 0.44196456538060225,  /* xyz */
        68.85616807993264, -50.44916013985812, 3.4383839713573865,  /* luv */
        68.85616807993264, 50.566196645106075, 176.10101145694136,  /* lch */
        176.10101145694136, 91.47367563461407, 68.85616807993264,  /* hsluv */
        176.10101145694136, 93.18730793216784, 68.85616807993264,  /* hpluv */
    },
    {
        "#33bbbb",
        0.2, 0.7333333333333333, 0.7333333333333333,  /* rgb */
        0.28103441663403783, 0.3983050216596129, 0.5322225504792439,  /* xyz */
        69.34863567566698, -49.28612789129543, -10.635375839212843,  /* luv */
        69.34863567566698, 50.4205674478029, 192.1770506300611,  /* lch */
        192.1770506300611, 91.89795397959139, 69.34863567566698,  /* hsluv */
        192.1770506300611, 92.25908309701131, 69.34863567566698,  /* hpluv */
    },
    {
        "#33bbcc",
        0.2, 0.7333333333333333, 0.8,  /* rgb */
        0.3003267920777596, 0.4060219718371017, 0.6338290611495141,  /* xyz */
        69.89630876530124, -48.11955042190822, -25.113391945721627,  /* luv */
        69.89630876530124, 54.278666046854944, 207.55986758844784,  /* lch */
        207.55986758844784, 92.32773620046953, 69.89630876530124,  /* hsluv */
        207.55986758844784, 98.54038419982246, 69.89630876530124,  /* hpluv */
    },
    {
        "#33bbdd",
        0.2, 0.7333333333333333, 0.8666666666666667,  /* rgb */
        0.32184511762839313, 0.4146293020573552, 0.7471589090495201,  /* xyz */
        70.49904635762952, -46.96965052402936, -39.807618580850594,  /* luv */
        70.49904635762952, 61.56942883792193, 220.28187220447964,  /* lch */
        220.28187220447964, 92.75632001350891, 70.49904635762952,  /* hsluv */
        220.28187220447964, 110.82078163647869, 70.49904635762952,  /* hpluv */
    },
    {
        "#33bbee",
        0.2, 0.7333333333333333, 0.9333333333333333,  /* rgb */
        0.3456572978945679, 0.4241541741638252, 0.8725697251180433,  /* xyz */
        71.15639082437666, -45.85349816303505, -54.55704875041039,  /* luv */
        71.15639082437666, 71.26720748101552, 229.95399555219225,  /* lch */
        229.95399555219225, 93.17802894372089, 71.15639082437666,  /* hsluv */
        229.95399555219225, 127.09110524416386, 71.15639082437666,  /* hpluv */
    },
    {
        "#33bbff",
        0.2, 0.7333333333333333, 1.0,  /* rgb */
        0.37182834630439926, 0.43462259352775795, 1.0104039134098253,  /* xyz */
        71.86759823036266, -44.7848112977892, -69.22976108145922,  /* luv */
        71.86759823036266, 82.45264787970433, 237.10112586627724,  /* lch */
        237.10112586627724, 99.99999999999778, 71.86759823036266,  /* hsluv */
        237.10112586627724, 145.58304620008877, 71.86759823036266,  /* hpluv */
    },
    {
        "#33cc00",
        0.2, 0.8, 0.0,  /* rgb */
        0.2295713012121862, 0.43887776478625984, 0.07261300893003712,  /* xyz */
        72.15342328317065, -63.04911903840135, 87.69998590983363,  /* luv */
        72.15342328317065, 108.01147596484144, 125.71304663597792,  /* lch */
        125.71304663597792, 100.0000000000024, 72.15342328317065,  /* hsluv */
        125.71304663597792, 189.955680955455, 72.15342328317065,  /* hpluv */
    },
    {
        "#33cc11",
        0.2, 0.8, 0.06666666666666667,  /* rgb */
        0.23058296671182332, 0.4392824309861147, 0.07794111389479276,  /* xyz */
        72.1805088449519, -62.93524124356771, 86.49348386866558,  /* luv */
        72.1805088449519, 106.96713206459813, 126.04075435893922,  /* lch */
        126.04075435893922, 98.47281268555066, 72.1805088449519,  /* hsluv */
        126.04075435893922, 188.0484417846846, 72.1805088449519,  /* hpluv */
    },
    {
        "#33cc22",
        0.2, 0.8, 0.13333333333333333,  /* rgb */
        0.23245832485030032, 0.4400325742415055, 0.08781800009077195,  /* xyz */
        72.23067429076455, -62.72619765166626, 84.27576539603092,  /* luv */
        72.23067429076455, 105.05703453326076, 126.66019878596018,  /* lch */
        126.66019878596018, 95.66807404492069, 72.23067429076455,  /* hsluv */
        126.66019878596018, 184.56221561171128, 72.23067429076455,  /* hpluv */
    },
    {
        "#33cc33",
        0.2, 0.8, 0.2,  /* rgb */
        0.23554607558275809, 0.4412676745344886, 0.1040801539483831,  /* xyz */
        72.31314692234902, -62.38771738981154, 80.67657563653697,  /* luv */
        72.31314692234902, 101.98498486320848, 127.7150129492403,  /* lch */
        127.7150129492403, 91.12302588220713, 72.31314692234902,  /* hsluv */
        127.7150129492403, 178.9609599764882, 72.31314692234902,  /* hpluv */
    },
    {
        "#33cc44",
        0.2, 0.8, 0.26666666666666666,  /* rgb */
        0.24000407082697695, 0.4430508726321762, 0.12755892890126974,  /* xyz */
        72.43194721075827, -61.91118634454131, 75.59152245907971,  /* luv */
        72.43194721075827, 97.70912578807607, 129.31826079180553,  /* lch */
        129.31826079180553, 91.24716194186736, 72.43194721075827,  /* hsluv */
        129.31826079180553, 171.17655962997782, 72.43194721075827,  /* hpluv */
    },
    {
        "#33cc55",
        0.2, 0.8, 0.3333333333333333,  /* rgb */
        0.24596648486633893, 0.44543583824792105, 0.15896097617524363,  /* xyz */
        72.59034124088163, -61.29535731891194, 68.98762007512154,  /* luv */
        72.59034124088163, 92.28441121057448, 131.62102349374678,  /* lch */
        131.62102349374678, 91.4078622695478, 72.59034124088163,  /* hsluv */
        131.62102349374678, 161.3202306310428, 72.59034124088163,  /* hpluv */
    },
    {
        "#33cc66",
        0.2, 0.8, 0.4,  /* rgb */
        0.2535514806398471, 0.44846983655732436, 0.19890862058238762,  /* xyz */
        72.79102483159734, -60.54558782385721, 60.89519481239933,  /* luv */
        72.79102483159734, 85.87195675059742, 134.8350558258884,  /* lch */
        134.8350558258884, 91.60396132934525, 72.79102483159734,  /* hsluv */
        134.8350558258884, 149.6969155071448, 72.79102483159734,  /* hpluv */
    },
    {
        "#33cc77",
        0.2, 0.8, 0.4666666666666667,  /* rgb */
        0.262865493660049, 0.45219544176540516, 0.24796242248878553,  /* xyz */
        73.03622042418584, -59.6729854923348, 51.39953931267681,  /* luv */
        73.03622042418584, 78.75771606086484, 139.25991723112168,  /* lch */
        139.25991723112168, 91.83285103257353, 73.03622042418584,  /* hsluv */
        139.25991723112168, 136.83403985653206, 73.03622042418584,  /* hpluv */
    },
    {
        "#33cc88",
        0.2, 0.8, 0.5333333333333333,  /* rgb */
        0.2740059107619929, 0.45665160860618276, 0.30663528589235767,  /* xyz */
        73.3277345291399, -58.69332460645942, 40.63076685273132,  /* luv */
        73.3277345291399, 71.38463117786786, 145.3068745739903,  /* lch */
        145.3068745739903, 92.09075122856919, 73.3277345291399,  /* hsluv */
        145.3068745739903, 123.5309493111808, 73.3277345291399,  /* hpluv */
    },
    {
        "#33cc99",
        0.2, 0.8, 0.6,  /* rgb */
        0.2870628748710656, 0.4618743942498119, 0.3754019635334756,  /* xyz */
        73.66699549690277, -57.62576670921377, 28.752031286129544,  /* luv */
        73.66699549690277, 64.400374936046, 153.483372150156,  /* lch */
        153.483372150156, 92.37302735104291, 73.66699549690277,  /* hsluv */
        153.483372150156, 110.93146916538305, 73.66699549690277,  /* hpluv */
    },
    {
        "#33ccaa",
        0.2, 0.8, 0.6666666666666666,  /* rgb */
        0.30212056783631813, 0.46789747143591304, 0.4547058131504742,  /* xyz */
        74.05508116234641, -56.49149108826851, 15.947002269016084,  /* luv */
        74.05508116234641, 58.69919460047067, 164.23613941889758,  /* lch */
        164.23613941889758, 92.67452966419198, 74.05508116234641,  /* hsluv */
        164.23613941889758, 100.58115228071698, 74.05508116234641,  /* hpluv */
    },
    {
        "#33ccbb",
        0.2, 0.8, 0.7333333333333333,  /* rgb */
        0.31925815994365475, 0.4747525082788478, 0.5449637982491159,  /* xyz */
        74.49274144494511, -55.312362155227014, 2.407706537995659,  /* luv */
        74.49274144494511, 55.364740204972485, 177.50753020659295,  /* lch */
        177.50753020659295, 92.9899230693886, 74.49274144494511,  /* hsluv */
        177.50753020659295, 94.31019343606182, 74.49274144494511,  /* hpluv */
    },
    {
        "#33cccc",
        0.2, 0.8, 0.8,  /* rgb */
        0.3385505353873765, 0.4824694584563366, 0.646570308919386,  /* xyz */
        74.98041875615324, -54.10974764828409, -11.676257142247575,  /* luv */
        74.98041875615324, 55.355214491616536, 192.17705063006113,  /* lch */
        192.17705063006113, 93.31397954050014, 74.98041875615324,  /* hsluv */
        192.17705063006113, 93.68067317855309, 74.98041875615324,  /* hpluv */
    },
    {
        "#33ccdd",
        0.2, 0.8, 0.8666666666666667,  /* rgb */
        0.36006886093801005, 0.4910767886765901, 0.759900156819392,  /* xyz */
        75.51826783033826, -52.90356786545441, -26.12641737785712,  /* luv */
        75.51826783033826, 59.00319633627262, 206.28245469149368,  /* lch */
        206.28245469149368, 93.64181350465303, 75.51826783033826,  /* hsluv */
        206.28245469149368, 99.14318019327796, 75.51826783033826,  /* hpluv */
    },
    {
        "#33ccee",
        0.2, 0.8, 0.9333333333333333,  /* rgb */
        0.38388104120418476, 0.5006016607830601, 0.8853109728879153,  /* xyz */
        76.10617585375677, -51.71161470408086, -40.78170030633246,  /* luv */
        76.10617585375677, 65.85771158474024, 218.26062431545347,  /* lch */
        218.26062431545347, 93.969050662624, 76.10617585375677,  /* hsluv */
        218.26062431545347, 110.22935021534401, 76.10617585375677,  /* hpluv */
    },
    {
        "#33ccff",
        0.2, 0.8, 1.0,  /* rgb */
        0.4100520896140162, 0.5110700801469928, 1.0231451611796971,  /* xyz */
        76.74378329393954, -50.5491406549608, -55.502271861157425,  /* luv */
        76.74378329393954, 75.0714180144803, 227.6740561465466,  /* lch */
        227.6740561465466, 99.99999999999697, 76.74378329393954,  /* hsluv */
        227.6740561465466, 129.84556015683847, 76.74378329393954,  /* hpluv */
    },
    {
        "#33dd00",
        0.2, 0.8666666666666667, 0.0,  /* rgb */
        0.27220529175936137, 0.5241457458806114, 0.08682433911242844,  /* xyz */
        77.52807827872707, -68.66498092216692, 94.34450928433695,  /* luv */
        77.52807827872707, 116.68661464428509, 126.04754342437614,  /* lch */
        126.04754342437614, 100.00000000000242, 77.52807827872707,  /* hsluv */
        126.04754342437614, 210.35620828350926, 77.52807827872707,  /* hpluv */
    },
    {
        "#33dd11",
        0.2, 0.8666666666666667, 0.06666666666666667,  /* rgb */
        0.27321695725899847, 0.5245504120804663, 0.09215244407718408,  /* xyz */
        77.55214150694749, -68.5599423432795, 93.2576459912042,  /* luv */
        77.55214150694749, 115.74737245369579, 126.32209767174687,  /* lch */
        126.32209767174687, 98.72032279176409, 77.55214150694749,  /* hsluv */
        126.32209767174687, 208.9320741651206, 77.55214150694749,  /* hpluv */
    },
    {
        "#33dd22",
        0.2, 0.8666666666666667, 0.13333333333333333,  /* rgb */
        0.27509231539747553, 0.5253005553358571, 0.10202933027316327,  /* xyz */
        77.59671560317933, -68.36681588768, 91.25712701199298,  /* luv */
        77.59671560317933, 114.02580736439867, 126.839335004613,  /* lch */
        126.839335004613, 96.36659795250371, 77.59671560317933,  /* hsluv */
        126.839335004613, 206.3170666405989, 77.59671560317933,  /* hpluv */
    },
    {
        "#33dd33",
        0.2, 0.8666666666666667, 0.2,  /* rgb */
        0.27818006612993323, 0.5265356556288402, 0.11829148413077442,  /* xyz */
        77.67001386150426, -68.0532561222895, 88.00295786681752,  /* luv */
        77.67001386150426, 111.24642134538438, 127.71501294924033,  /* lch */
        127.71501294924033, 92.54262730460044, 77.67001386150426,  /* hsluv */
        127.71501294924033, 202.0824665233406, 77.67001386150426,  /* hpluv */
    },
    {
        "#33dd44",
        0.2, 0.8666666666666667, 0.26666666666666666,  /* rgb */
        0.28263806137415215, 0.5283188537265278, 0.14177025908366106,  /* xyz */
        77.77563759417713, -67.61000905676097, 83.38959798954701,  /* luv */
        77.77563759417713, 107.3542657630034, 129.03419521758573,  /* lch */
        129.03419521758573, 92.63043085056421, 77.77563759417713,  /* hsluv */
        129.03419521758573, 196.12587531132309, 77.77563759417713,  /* hpluv */
    },
    {
        "#33dd55",
        0.2, 0.8666666666666667, 0.3333333333333333,  /* rgb */
        0.28860047541351413, 0.5307038193422725, 0.17317230635763498,  /* xyz */
        77.9165348137244, -67.03403912762171, 77.37075484394104,  /* luv */
        77.9165348137244, 102.3708752863076, 130.90566406922113,  /* lch */
        130.90566406922113, 92.74468319432343, 77.9165348137244,  /* hsluv */
        130.90566406922113, 188.4541795144647, 77.9165348137244,  /* hpluv */
    },
    {
        "#33dd66",
        0.2, 0.8666666666666667, 0.4,  /* rgb */
        0.2961854711870223, 0.5337378176516758, 0.2131199507647789,  /* xyz */
        78.09516635687858, -66.32792385910378, 69.95293897058288,  /* luv */
        78.09516635687858, 96.39920722745163, 133.47631502868552,  /* lch */
        133.47631502868552, 92.88500679548642, 78.09516635687858,  /* hsluv */
        133.47631502868552, 179.19622273494463, 78.09516635687858,  /* hpluv */
    },
    {
        "#33dd77",
        0.2, 0.8666666666666667, 0.4666666666666667,  /* rgb */
        0.3054994842072242, 0.5374634228597567, 0.2621737526711768,  /* xyz */
        78.31359377813085, -65.49925889722954, 61.18962752962942,  /* luv */
        78.31359377813085, 89.63438756024992, 136.9483043548969,  /* lch */
        136.9483043548969, 93.05006480123812, 78.31359377813085,  /* hsluv */
        136.9483043548969, 168.63038828411712, 78.31359377813085,  /* hpluv */
    },
    {
        "#33dd88",
        0.2, 0.8666666666666667, 0.5333333333333333,  /* rgb */
        0.316639901309168, 0.5419195897005342, 0.320846616074749,  /* xyz */
        78.57353141067165, -64.55991579203484, 51.1743638074698,  /* luv */
        78.57353141067165, 82.38202618395536, 141.59738099104726,  /* lch */
        141.59738099104726, 93.23770287404164, 78.57353141067165,  /* hsluv */
        141.59738099104726, 157.23338358068398, 78.57353141067165,  /* hpluv */
    },
    {
        "#33dd99",
        0.2, 0.8666666666666667, 0.6,  /* rgb */
        0.3296968654182407, 0.5471423753441634, 0.3896132937158669,  /* xyz */
        78.87638011670606, -63.52513865358128, 40.03255435912591,  /* luv */
        78.87638011670606, 75.08694060536158, 147.78150756658786,  /* lch */
        147.78150756658786, 93.44512050959123, 78.87638011670606,  /* hsluv */
        147.78150756658786, 145.76000688672033, 78.87638011670606,  /* hpluv */
    },
    {
        "#33ddaa",
        0.2, 0.8666666666666667, 0.6666666666666666,  /* rgb */
        0.3447545583834933, 0.5531654525302645, 0.4689171433328655,  /* xyz */
        79.22325120413856, -62.41253088726868, 27.912360113858213,  /* luv */
        79.22325120413856, 68.36975836493771, 155.90467719546356,  /* lch */
        155.90467719546356, 93.6690625743759, 79.22325120413856,  /* hsluv */
        155.90467719546356, 135.3557697291633, 79.22325120413856,  /* hpluv */
    },
    {
        "#33ddbb",
        0.2, 0.8666666666666667, 0.7333333333333333,  /* rgb */
        0.36189215049082996, 0.5600204893731993, 0.5591751284315073,  /* xyz */
        79.61498505277709, -61.24101132902836, 14.97535212218471,  /* luv */
        79.61498505277709, 63.04540141664261, 166.25902885418398,  /* lch */
        166.25902885418398, 93.90601634083596, 79.61498505277709,  /* hsluv */
        166.25902885418398, 127.65894471294463, 79.61498505277709,  /* hpluv */
    },
    {
        "#33ddcc",
        0.2, 0.8666666666666667, 0.8,  /* rgb */
        0.38118452593455165, 0.5677374395506881, 0.6607816391017775,  /* xyz */
        80.05216704786926, -60.029822884106814, 1.3876488942262355,  /* luv */
        80.05216704786926, 60.045859182385605, 178.67578706033822,  /* lch */
        178.67578706033822, 94.15239850565959, 80.05216704786926,  /* hsluv */
        178.67578706033822, 124.73434070272806, 80.05216704786926,  /* hpluv */
    },
    {
        "#33dddd",
        0.2, 0.8666666666666667, 0.8666666666666667,  /* rgb */
        0.40270285148518525, 0.5763447697709416, 0.7741114870017834,  /* xyz */
        80.53514235495516, -58.7976638126828, -12.687855180971015,  /* luv */
        80.53514235495516, 60.151034396114596, 192.17705063006125,  /* lch */
        192.17705063006125, 94.40471906967733, 80.53514235495516,  /* hsluv */
        192.17705063006125, 128.60302149707096, 80.53514235495516,  /* hpluv */
    },
    {
        "#33ddee",
        0.2, 0.8666666666666667, 0.9333333333333333,  /* rgb */
        0.42651503175135996, 0.5858696418774116, 0.8995223030703067,  /* xyz */
        81.0640304387754, -57.56198921310409, -27.09775624996464,  /* luv */
        81.0640304387754, 63.62130929140023, 205.20907773407035,  /* lch */
        205.20907773407035, 94.65971317993478, 81.0640304387754,  /* hsluv */
        205.20907773407035, 140.47663705635298, 81.0640304387754,  /* hpluv */
    },
    {
        "#33ddff",
        0.2, 0.8666666666666667, 1.0,  /* rgb */
        0.4526860801611914, 0.5963380612413444, 1.0373564913620885,  /* xyz */
        81.63873982949002, -56.338504675429945, -41.70271146808378,  /* luv */
        81.63873982949002, 70.09381750806335, 216.50946924270437,  /* lch */
        216.50946924270437, 99.999999999996, 81.63873982949002,  /* hsluv */
        216.50946924270437, 160.4214330333583, 81.63873982949002,  /* hpluv */
    },
    {
        "#33ee00",
        0.2, 0.9333333333333333, 0.0,  /* rgb */
        0.3193840680998762, 0.6185032985616423, 0.10255059789259963,  /* xyz */
        82.83376260069937, -74.13570709583902, 100.89487944249746,  /* luv */
        82.83376260069937, 125.20335364644244, 126.3077634478595,  /* lch */
        126.3077634478595, 100.0000000000023, 82.83376260069937,  /* hsluv */
        126.3077634478595, 309.71310530524084, 82.83376260069937,  /* hpluv */
    },
    {
        "#33ee11",
        0.2, 0.9333333333333333, 0.06666666666666667,  /* rgb */
        0.3203957335995133, 0.6189079647614972, 0.10787870285735526,  /* xyz */
        82.85531245284119, -74.03873828310105, 99.90978133625985,  /* luv */
        82.85531245284119, 124.35312289288431, 126.5405152630975,  /* lch */
        126.5405152630975, 98.91492625762238, 82.85531245284119,  /* hsluv */
        126.5405152630975, 308.05423991570217, 82.85531245284119,  /* hpluv */
    },
    {
        "#33ee22",
        0.2, 0.9333333333333333, 0.13333333333333333,  /* rgb */
        0.32227109173799035, 0.619658108016888, 0.11775558905333446,  /* xyz */
        82.8952353009988, -73.86022532727713, 98.09463425733638,  /* luv */
        82.8952353009988, 122.79206063698395, 126.97787070529297,  /* lch */
        126.97787070529297, 96.91676821513963, 82.8952353009988,  /* hsluv */
        126.97787070529297, 305.0028450117226, 82.8952353009988,  /* hpluv */
    },
    {
        "#33ee33",
        0.2, 0.9333333333333333, 0.2,  /* rgb */
        0.32535884247044805, 0.6208932083098712, 0.1340177429109456,  /* xyz */
        82.96089756911888, -73.56977213834874, 95.13663161286873,  /* luv */
        82.96089756911888, 120.26425091078083, 127.71501294924037,  /* lch */
        127.71501294924037, 93.66390644163128, 82.96089756911888,  /* hsluv */
        127.71501294924037, 300.046240285686, 82.96089756911888,  /* hpluv */
    },
    {
        "#33ee44",
        0.2, 0.9333333333333333, 0.26666666666666666,  /* rgb */
        0.32981683771466697, 0.6226764064075587, 0.15749651786383223,  /* xyz */
        83.05554520149462, -73.1578713419028, 90.93174697286875,  /* luv */
        83.05554520149462, 116.707569363843, 128.81793253549358,  /* lch */
        128.81793253549358, 93.72740341827964, 83.05554520149462,  /* hsluv */
        128.81793253549358, 293.0397209893598, 83.05554520149462,  /* hpluv */
    },
    {
        "#33ee55",
        0.2, 0.9333333333333333, 0.3333333333333333,  /* rgb */
        0.33577925175402895, 0.6250613720233035, 0.18889856513780615,  /* xyz */
        83.18185108987836, -72.62030796736812, 85.42575793053581,  /* luv */
        83.18185108987836, 112.1216716218675, 130.3678125576057,  /* lch */
        130.3678125576057, 93.81036537925301, 83.18185108987836,  /* hsluv */
        130.3678125576057, 283.9500898787192, 83.18185108987836,  /* hpluv */
    },
    {
        "#33ee66",
        0.2, 0.9333333333333333, 0.4,  /* rgb */
        0.34336424752753714, 0.6280953703327068, 0.2288462095449501,  /* xyz */
        83.3420657578551, -71.9576476395269, 78.60880405027572,  /* luv */
        83.3420657578551, 106.5703857928128, 132.47064767984335,  /* lch */
        132.47064767984335, 93.91278507934524, 83.3420657578551,  /* hsluv */
        132.47064767984335, 272.865433725808, 83.3420657578551,  /* hpluv */
    },
    {
        "#33ee77",
        0.2, 0.9333333333333333, 0.4666666666666667,  /* rgb */
        0.35267826054773904, 0.6318209755407876, 0.277900011451348,  /* xyz */
        83.53809752727035, -71.17480247625979, 70.51108395505574,  /* luv */
        83.53809752727035, 100.18815033751005, 135.26839647086757,  /* lch */
        135.26839647086757, 94.03400742760283, 83.53809752727035,  /* hsluv */
        135.26839647086757, 260.01923812947297, 83.53809752727035,  /* hpluv */
    },
    {
        "#33ee88",
        0.2, 0.9333333333333333, 0.5333333333333333,  /* rgb */
        0.36381867764968284, 0.6362771423815652, 0.33657287485492016,  /* xyz */
        83.77156009730537, -70.28051354448408, 61.1980405537673,  /* luv */
        83.77156009730537, 93.19093706845617, 138.9516860867921,  /* lch */
        138.9516860867921, 94.17280698186752, 83.77156009730537,  /* hsluv */
        138.9516860867921, 245.83342468256393, 83.77156009730537,  /* hpluv */
    },
    {
        "#33ee99",
        0.2, 0.9333333333333333, 0.6,  /* rgb */
        0.37687564175875554, 0.6414999280251944, 0.4053395524960381,  /* xyz */
        84.04380319849028, -69.28671216698798, 50.76460351384698,  /* luv */
        84.04380319849028, 85.89350064369903, 143.77071930591418,  /* lch */
        143.77071930591418, 94.32748263417689, 84.04380319849028,  /* hsluv */
        143.77071930591418, 230.98981048269488, 84.04380319849028,  /* hpluv */
    },
    {
        "#33eeaa",
        0.2, 0.9333333333333333, 0.6666666666666666,  /* rgb */
        0.3919333347240081, 0.6475230052112955, 0.4846434021130367,  /* xyz */
        84.35593389890947, -68.20777821573702, 39.32859698051394,  /* luv */
        84.35593389890947, 78.73397963765619, 150.0322559224223,  /* lch */
        150.0322559224223, 94.49596707568159, 84.35593389890947,  /* hsluv */
        150.0322559224223, 216.54011970693134, 84.35593389890947,  /* hpluv */
    },
    {
        "#33eebb",
        0.2, 0.9333333333333333, 0.7333333333333333,  /* rgb */
        0.40907092683134477, 0.6543780420542302, 0.5749013872116784,  /* xyz */
        84.7088326356722, -67.0597412553262, 27.023684774377493,  /* luv */
        84.7088326356722, 72.2999891840671, 158.05158762355737,  /* lch */
        158.05158762355737, 94.67594444985718, 84.7088326356722,  /* hsluv */
        158.05158762355737, 204.04938686040532, 84.7088326356722,  /* hpluv */
    },
    {
        "#33eecc",
        0.2, 0.9333333333333333, 0.8,  /* rgb */
        0.42836330227506647, 0.6620949922317191, 0.6765078978819485,  /* xyz */
        85.1031663228954, -65.8594808644086, 13.992327638881461,  /* luv */
        85.1031663228954, 67.32946199460685, 168.00544141017713,  /* lch */
        168.00544141017713, 94.86496801257674, 85.1031663228954,  /* hsluv */
        168.00544141017713, 195.70849862692987, 85.1031663228954,  /* hpluv */
    },
    {
        "#33eedd",
        0.2, 0.9333333333333333, 0.8666666666666667,  /* rgb */
        0.44988162782570007, 0.6707023224519726, 0.7898377457819545,  /* xyz */
        85.53939995477675, -64.62398051564799, 0.37921629457989664,  /* luv */
        85.53939995477675, 64.62509313482593, 179.66378976277608,  /* lch */
        179.66378976277608, 95.06056987304589, 85.53939995477675,  /* hsluv */
        179.66378976277608, 194.23300979303164, 85.53939995477675,  /* hpluv */
    },
    {
        "#33eeee",
        0.2, 0.9333333333333333, 0.9333333333333333,  /* rgb */
        0.4736938080918748, 0.6802271945584426, 0.9152485618504778,  /* xyz */
        86.01780757517203, -63.36967896026545, -13.67444312199086,  /* luv */
        86.01780757517203, 64.82828554129496, 192.17705063006122,  /* lch */
        192.17705063006122, 95.26035640203271, 86.01780757517203,  /* hsluv */
        192.17705063006122, 202.32751522146916, 86.01780757517203,  /* hpluv */
    },
    {
        "#33eeff",
        0.2, 0.9333333333333333, 1.0,  /* rgb */
        0.4998648565017062, 0.6906956139223753, 1.0530827501422597,  /* xyz */
        86.53848314223043, -62.11194801425988, -28.03554332124551,  /* luv */
        86.53848314223043, 68.14606206849781, 204.2930447365935,  /* lch */
        204.2930447365935, 99.99999999999393, 86.53848314223043,  /* hsluv */
        204.2930447365935, 221.87885236487398, 86.53848314223043,  /* hpluv */
    },
    {
        "#33ff00",
        0.2, 1.0, 0.0,  /* rgb */
        0.37123644052955, 0.7222080434209914, 0.11983472203582374,  /* xyz */
        88.07476275306223, -79.4809541468946, 107.35824159736104,  /* luv */
        88.07476275306223, 133.57774556780822, 126.5138038199733,  /* lch */
        126.5138038199733, 100.00000000000226, 88.07476275306223,  /* hsluv */
        126.5138038199733, 497.27297669997466, 88.07476275306223,  /* hpluv */
    },
    {
        "#33ff11",
        0.2, 1.0, 0.06666666666666667,  /* rgb */
        0.3722481060291871, 0.7226127096208463, 0.12516282700057937,  /* xyz */
        88.0941974462199, -79.39128334421414, 106.46046404540373,  /* luv */
        88.0941974462199, 132.80363803677966, 126.71317891025123,  /* lch */
        126.71317891025123, 99.99999999999179, 88.0941974462199,  /* hsluv */
        126.71317891025123, 495.2777699786455, 88.0941974462199,  /* hpluv */
    },
    {
        "#33ff22",
        0.2, 1.0, 0.13333333333333333,  /* rgb */
        0.3741234641676642, 0.7233628528762371, 0.13503971319655855,  /* xyz */
        88.13020500347334, -79.22604053236593, 104.80479771387299,  /* luv */
        88.13020500347334, 131.38040615815558, 127.08705878985978,  /* lch */
        127.08705878985978, 99.99999999999152, 88.13020500347334,  /* hsluv */
        127.08705878985978, 491.60255884038656, 88.13020500347334,  /* hpluv */
    },
    {
        "#33ff33",
        0.2, 1.0, 0.2,  /* rgb */
        0.3772112149001219, 0.7245979531692203, 0.1513018670541697,  /* xyz */
        88.18943674164107, -78.95672031650172, 102.10275491931047,  /* luv */
        88.18943674164107, 129.0702763817102, 127.71501294924035,  /* lch */
        127.71501294924035, 99.99999999999176, 88.18943674164107,  /* hsluv */
        127.71501294924035, 485.61806273712904, 88.18943674164107,  /* hpluv */
    },
    {
        "#33ff44",
        0.2, 1.0, 0.26666666666666666,  /* rgb */
        0.3816692101443408, 0.7263811512669078, 0.17478064200705634,  /* xyz */
        88.2748349985884, -78.57381010864621, 98.25333919683949,  /* luv */
        88.2748349985884, 125.80764006338721, 128.64954443912612,  /* lch */
        128.64954443912612, 99.99999999999172, 88.2748349985884,  /* hsluv */
        128.64954443912612, 477.12626783388663, 88.2748349985884,  /* hpluv */
    },
    {
        "#33ff55",
        0.2, 1.0, 0.3333333333333333,  /* rgb */
        0.3876316241837028, 0.7287661168826526, 0.20618268928103026,  /* xyz */
        88.38883401501022, -78.0723424240601, 93.19794109214561,  /* luv */
        88.38883401501022, 121.57774004888698, 129.95306271607248,  /* lch */
        129.95306271607248, 99.99999999999164, 88.38883401501022,  /* hsluv */
        129.95306271607248, 466.0490876534442, 88.38883401501022,  /* hpluv */
    },
    {
        "#33ff66",
        0.2, 1.0, 0.4,  /* rgb */
        0.39521661995721097, 0.7318001151920559, 0.24613033368817422,  /* xyz */
        88.5334972733264, -77.45144104237269, 86.9155395518881,  /* luv */
        88.5334972733264, 116.4175104317901, 131.70460066806442,  /* lch */
        131.70460066806442, 99.99999999999139, 88.5334972733264,  /* hsluv */
        131.70460066806442, 452.43688525451455, 88.5334972733264,  /* hpluv */
    },
    {
        "#33ff77",
        0.2, 1.0, 0.4666666666666667,  /* rgb */
        0.4045306329774129, 0.7355257204001368, 0.29518413559457213,  /* xyz */
        88.71059094377401, -76.71398726030155, 79.41935320202565,  /* luv */
        88.71059094377401, 110.41951595801265, 134.0073193841375,  /* lch */
        134.0073193841375, 99.9999999999915, 88.71059094377401,  /* hsluv */
        134.0073193841375, 436.4931576691781, 88.71059094377401,  /* hpluv */
    },
    {
        "#33ff88",
        0.2, 1.0, 0.5333333333333333,  /* rgb */
        0.4156710500793567, 0.7399818872409143, 0.35385699899814427,  /* xyz */
        88.92162762043124, -75.86624973595349, 70.75337292217866,  /* luv */
        88.92162762043124, 103.73874699871281, 136.9971924592701,  /* lch */
        136.9971924592701, 99.99999999999126, 88.92162762043124,  /* hsluv */
        136.9971924592701, 418.61965065889103, 88.92162762043124,  /* hpluv */
    },
    {
        "#33ff99",
        0.2, 1.0, 0.6,  /* rgb */
        0.42872801418842943, 0.7452046728845435, 0.4226236766392622,  /* xyz */
        89.16789445085124, -74.91742922984282, 60.98826497962007,  /* luv */
        89.16789445085124, 96.60325909426068, 140.8518911103214,  /* lch */
        140.8518911103214, 99.99999999999135, 89.16789445085124,  /* hsluv */
        140.8518911103214, 399.49248348725234, 89.16789445085124,  /* hpluv */
    },
    {
        "#33ffaa",
        0.2, 1.0, 0.6666666666666666,  /* rgb */
        0.44378570715368193, 0.7512277500706446, 0.5019275262562608,  /* xyz */
        89.45047247902684, -73.8791171714821, 50.21659093279649,  /* luv */
        89.45047247902684, 89.32989398263831, 145.79554670585338,  /* lch */
        145.79554670585338, 99.9999999999912, 89.45047247902684,  /* hsluv */
        145.79554670585338, 380.1849286029681, 89.45047247902684,  /* hpluv */
    },
    {
        "#33ffbb",
        0.2, 1.0, 0.7333333333333333,  /* rgb */
        0.4609232992610186, 0.7580827869135793, 0.5921855113549026,  /* xyz */
        89.77025087121503, -72.76469186148745, 38.54752496250603,  /* luv */
        89.77025087121503, 82.3444719603705, 152.08733011021545,  /* lch */
        152.08733011021545, 99.99999999999098, 89.77025087121503,  /* hsluv */
        152.08733011021545, 362.3515432223334, 89.77025087121503,  /* hpluv */
    },
    {
        "#33ffcc",
        0.2, 1.0, 0.8,  /* rgb */
        0.48021567470474036, 0.7657997370910682, 0.6937920220251728,  /* xyz */
        90.12793815278357, -71.58868832958697, 26.101364314727206,  /* luv */
        90.12793815278357, 76.1985663634222, 159.96805361961265,  /* lch */
        159.96805361961265, 99.99999999999083, 90.12793815278357,  /* hsluv */
        159.96805361961265, 348.4644406306531, 90.12793815278357,  /* hpluv */
    },
    {
        "#33ffdd",
        0.2, 1.0, 0.8666666666666667,  /* rgb */
        0.5017340002553738, 0.7744070673113217, 0.8071218699251788,  /* xyz */
        90.52407175501463, -70.36618111135999, 13.004161829046334,  /* luv */
        90.52407175501463, 71.55772263755144, 169.52947516180726,  /* lch */
        169.52947516180726, 99.99999999999041, 90.52407175501463,  /* hsluv */
        169.52947516180726, 342.01315574542883, 90.52407175501463,  /* hpluv */
    },
    {
        "#33ffee",
        0.2, 1.0, 0.9333333333333333,  /* rgb */
        0.5255461805215487, 0.7839319394177917, 0.932532685993702,  /* xyz */
        90.9590266887802, -69.11221581610646, -0.6172164630686426,  /* luv */
        90.9590266887802, 69.11497183081505, 180.51167449693034,  /* lch */
        180.51167449693034, 99.99999999999015, 90.9590266887802,  /* hsluv */
        180.51167449693034, 347.4423422280899, 90.9590266887802,  /* hpluv */
    },
    {
        "#33ffff",
        0.2, 1.0, 1.0,  /* rgb */
        0.55171722893138, 0.7944003587817244, 1.0703668742854837,  /* xyz */
        91.43302386298772, -67.84131753632127, -14.639370960882262,  /* luv */
        91.43302386298772, 69.40284970514031, 192.17705063006113,  /* lch */
        192.17705063006113, 99.99999999998973, 91.43302386298772,  /* hsluv */
        192.17705063006113, 369.5909179888609, 91.43302386298772,  /* hpluv */
    },
    {
        "#440000",
        0.26666666666666666, 0.0, 0.0,  /* rgb */
        0.023838427558406292, 0.012291689209803506, 0.0011174262918002714,  /* xyz */
        10.770830612352881, 35.40764988733273, 7.640560949840302,  /* luv */
        10.770830612352881, 36.22264267239702, 12.177050630061776,  /* lch */
        12.177050630061776, 100.0000000000022, 10.770830612352881,  /* hsluv */
        12.177050630061776, 426.74678918312514, 10.770830612352881,  /* hpluv */
    },
    {
        "#440011",
        0.26666666666666666, 0.0, 0.06666666666666667,  /* rgb */
        0.024850093058043414, 0.01269635540965836, 0.006445531256555902,  /* xyz */
        11.061446871672125, 32.471737783962915, 2.6870241403600876,  /* luv */
        11.061446871672125, 32.582723235502016, 4.7304267418156485,  /* lch */
        4.7304267418156485, 99.99999999999683, 11.061446871672125,  /* hsluv */
        4.7304267418156485, 373.77888847126576, 11.061446871672125,  /* hpluv */
    },
    {
        "#440022",
        0.26666666666666666, 0.0, 0.13333333333333333,  /* rgb */
        0.026725451196520433, 0.013446498665049178, 0.0163224174525351,  /* xyz */
        11.584242379374668, 28.24475792993189, -4.825774341366797,  /* luv */
        11.584242379374668, 28.65404768116094, 350.3043175324467,  /* lch */
        350.3043175324467, 99.99999999999748, 11.584242379374668,  /* hsluv */
        350.3043175324467, 313.87568243446776, 11.584242379374668,  /* hpluv */
    },
    {
        "#440033",
        0.26666666666666666, 0.0, 0.2,  /* rgb */
        0.029813201928978173, 0.014681598958032291, 0.03258457131014624,  /* xyz */
        12.40419212037505, 23.391013440487136, -14.25412162930869,  /* luv */
        12.40419212037505, 27.391960375193587, 328.64251678817294,  /* lch */
        328.64251678817294, 99.99999999999817, 12.40419212037505,  /* hsluv */
        328.64251678817294, 280.2166631566042, 12.40419212037505,  /* hpluv */
    },
    {
        "#440044",
        0.26666666666666666, 0.0, 0.26666666666666666,  /* rgb */
        0.03427119717319705, 0.01646479705571987, 0.05606334626303288,  /* xyz */
        13.510514633565844, 18.82597845314672, -24.34478352713322,  /* luv */
        13.510514633565844, 30.774761570178274, 307.7150129492436,  /* lch */
        307.7150129492436, 99.99999999999878, 13.510514633565844,  /* hsluv */
        307.7150129492436, 289.0427837304832, 13.510514633565844,  /* hpluv */
    },
    {
        "#440055",
        0.26666666666666666, 0.0, 0.3333333333333333,  /* rgb */
        0.04023361121255904, 0.0188497626714647, 0.08746539353700679,  /* xyz */
        14.871657786523194, 14.904856444093502, -34.51162140490254,  /* luv */
        14.871657786523194, 37.59264233349876, 293.3585184257321,  /* lch */
        293.3585184257321, 99.99999999999926, 14.871657786523194,  /* hsluv */
        293.3585184257321, 320.7619137815748, 14.871657786523194,  /* hpluv */
    },
    {
        "#440066",
        0.26666666666666666, 0.0, 0.4,  /* rgb */
        0.04781860698606722, 0.021883760980868014, 0.12741303794415076,  /* xyz */
        16.44630976797275, 11.632197273302166, -44.59783256292201,  /* luv */
        16.44630976797275, 46.0898544445027, 284.6184442786502,  /* lch */
        284.6184442786502, 99.99999999999964, 16.44630976797275,  /* hsluv */
        284.6184442786502, 355.6118276096742, 16.44630976797275,  /* hpluv */
    },
    {
        "#440077",
        0.26666666666666666, 0.0, 0.4666666666666667,  /* rgb */
        0.05713262000626913, 0.02560936618894883, 0.17646683985054867,  /* xyz */
        18.191981193664247, 8.8934050845755, -54.6002997321373,  /* luv */
        18.191981193664247, 55.319846211261165, 279.2512078994166,  /* lch */
        279.2512078994166, 100.00000000000003, 18.191981193664247,  /* hsluv */
        279.2512078994166, 385.86935777850306, 18.191981193664247,  /* hpluv */
    },
    {
        "#440088",
        0.26666666666666666, 0.0, 0.5333333333333333,  /* rgb */
        0.06827303710821296, 0.03006553302972642, 0.23513970325412084,  /* xyz */
        20.07012315724758, 6.564925822200582, -64.54216489490364,  /* luv */
        20.07012315724758, 64.8751824688912, 275.80788304600424,  /* lch */
        275.80788304600424, 100.00000000000028, 20.07012315724758,  /* hsluv */
        275.80788304600424, 410.17376713284557, 20.07012315724758,  /* hpluv */
    },
    {
        "#440099",
        0.26666666666666666, 0.0, 0.6,  /* rgb */
        0.08133000121728567, 0.03528831867335558, 0.30390638089523875,  /* xyz */
        22.048275547371304, 4.54664979059262, -74.43770502758443,  /* luv */
        22.048275547371304, 74.57643028525813, 273.495279820248,  /* lch */
        273.495279820248, 100.00000000000038, 22.048275547371304,  /* hsluv */
        273.495279820248, 429.20649964036636, 22.048275547371304,  /* hpluv */
    },
    {
        "#4400aa",
        0.26666666666666666, 0.0, 0.6666666666666666,  /* rgb */
        0.09638769418253822, 0.04131139585945669, 0.38321023051223735,  /* xyz */
        24.10032991883306, 2.764362423805781, -84.29004182881006,  /* luv */
        24.10032991883306, 84.33535943548648, 271.8783897610097,  /* lch */
        271.8783897610097, 100.0000000000004, 24.10032991883306,  /* hsluv */
        271.8783897610097, 444.044033459252, 24.10032991883306,  /* hpluv */
    },
    {
        "#4400bb",
        0.26666666666666666, 0.0, 0.7333333333333333,  /* rgb */
        0.11352528628987486, 0.048166432702391446, 0.4734682156108791,  /* xyz */
        26.205866104904416, 1.1644050724908295, -94.09580025896777,  /* luv */
        26.205866104904416, 94.10300455112154, 270.70898053884605,  /* lch */
        270.70898053884605, 100.0000000000006, 26.205866104904416,  /* hsluv */
        270.70898053884605, 455.66355984379425, 26.205866104904416,  /* hpluv */
    },
    {
        "#4400cc",
        0.26666666666666666, 0.0, 0.8,  /* rgb */
        0.1328176617335966, 0.05588338287988025, 0.5750747262811492,  /* xyz */
        28.349175673039937, -0.29208391457314403, -103.84918071196901,  /* luv */
        28.349175673039937, 103.84959146554381, 269.83885157951386,  /* lch */
        269.83885157951386, 100.00000000000054, 28.349175673039937,  /* hsluv */
        269.83885157951386, 464.840204698682, 28.349175673039937,  /* hpluv */
    },
    {
        "#4400dd",
        0.26666666666666666, 0.0, 0.8666666666666667,  /* rgb */
        0.15433598728423015, 0.06449071310013378, 0.6884045741811552,  /* xyz */
        30.518287194239846, -1.6336241509986928, -113.54430880345694,  /* luv */
        30.518287194239846, 113.5560601179942, 269.1757111164841,  /* lch */
        269.1757111164841, 100.00000000000058, 30.518287194239846,  /* hsluv */
        269.1757111164841, 472.16032046081455, 30.518287194239846,  /* hpluv */
    },
    {
        "#4400ee",
        0.26666666666666666, 0.0, 0.9333333333333333,  /* rgb */
        0.17814816755040488, 0.07401558520660381, 0.8138153902496784,  /* xyz */
        32.70412159046954, -2.8815172380409693, -123.17629511251916,  /* luv */
        32.70412159046954, 123.20999480253028, 268.6598990566049,  /* lch */
        268.6598990566049, 100.00000000000068, 32.70412159046954,  /* hsluv */
        268.6598990566049, 478.06040711588685, 32.70412159046954,  /* hpluv */
    },
    {
        "#4400ff",
        0.26666666666666666, 0.0, 1.0,  /* rgb */
        0.20431921596023628, 0.08448400457053651, 0.9516495785414603,  /* xyz */
        34.899809042032416, -4.051970576257103, -132.74155829719703,  /* luv */
        34.899809042032416, 132.80338762516192, 268.25157435617893,  /* lch */
        268.25157435617893, 100.00000000000082, 34.899809042032416,  /* hsluv */
        268.25157435617893, 482.8646688037458, 34.899809042032416,  /* hpluv */
    },
    {
        "#441100",
        0.26666666666666666, 0.06666666666666667, 0.0,  /* rgb */
        0.025842827819334703, 0.01630048973166038, 0.0017855597121097222,  /* xyz */
        13.412021407860891, 30.878837797926078, 11.120944627764468,  /* luv */
        13.412021407860891, 32.82039050901789, 19.806371308471164,  /* lch */
        19.806371308471164, 100.00000000000226, 13.412021407860891,  /* hsluv */
        19.806371308471164, 310.5194674718288, 13.412021407860891,  /* hpluv */
    },
    {
        "#441111",
        0.26666666666666666, 0.06666666666666667, 0.06666666666666667,  /* rgb */
        0.026854493318971825, 0.016705155931515232, 0.007113664676865354,  /* xyz */
        13.653423074551444, 28.700965822764857, 6.19333616848069,  /* luv */
        13.653423074551444, 29.361588037014066, 12.177050630061816,  /* lch */
        12.177050630061816, 63.945068577740486, 13.653423074551444,  /* hsluv */
        12.177050630061816, 272.8835269964485, 13.653423074551444,  /* hpluv */
    },
    {
        "#441122",
        0.26666666666666666, 0.06666666666666667, 0.13333333333333333,  /* rgb */
        0.028729851457448843, 0.017455299186906054, 0.01699055087284455,  /* xyz */
        14.0908014406849, 25.39853112859077, -1.527580539369178,  /* luv */
        14.0908014406849, 25.444427401579578, 356.55812335009404,  /* lch */
        356.55812335009404, 68.4589860949294, 14.0908014406849,  /* hsluv */
        356.55812335009404, 229.13757543736608, 14.0908014406849,  /* hpluv */
    },
    {
        "#441133",
        0.26666666666666666, 0.06666666666666667, 0.2,  /* rgb */
        0.031817602189906584, 0.018690399479889167, 0.0332527047304557,  /* xyz */
        14.784411134527122, 21.35888408216226, -11.525475585498693,  /* luv */
        14.784411134527122, 24.27011571268606, 331.648240125609,  /* lch */
        331.648240125609, 73.84946693948368, 14.784411134527122,  /* hsluv */
        331.648240125609, 208.30857224305865, 14.784411134527122,  /* hpluv */
    },
    {
        "#441144",
        0.26666666666666666, 0.06666666666666667, 0.26666666666666666,  /* rgb */
        0.036275597434125464, 0.02047359757757674, 0.056731479683342335,  /* xyz */
        15.733846020816415, 17.32546345309222, -22.404394986560835,  /* luv */
        15.733846020816415, 28.321874912834893, 307.71501294924394,  /* lch */
        307.71501294924394, 79.02496278864231, 15.733846020816415,  /* hsluv */
        307.71501294924394, 228.4159522862726, 15.733846020816415,  /* hpluv */
    },
    {
        "#441155",
        0.26666666666666666, 0.06666666666666667, 0.3333333333333333,  /* rgb */
        0.042238011473487456, 0.022858563193321572, 0.08813352695731624,  /* xyz */
        16.92109703191567, 13.702084666530855, -33.34402208015827,  /* luv */
        16.92109703191567, 36.04956217058485, 292.3392688836475,  /* lch */
        292.3392688836475, 83.41500977431133, 16.92109703191567,  /* hsluv */
        292.3392688836475, 270.3403085445136, 16.92109703191567,  /* hpluv */
    },
    {
        "#441166",
        0.26666666666666666, 0.06666666666666667, 0.4,  /* rgb */
        0.049823007246995635, 0.025892561502724884, 0.1280811713644602,  /* xyz */
        18.317554183879622, 10.592801308498224, -44.04933920195402,  /* luv */
        18.317554183879622, 45.305096001334384, 283.5215086015157,  /* lch */
        283.5215086015157, 86.90234177078395, 18.317554183879622,  /* hsluv */
        283.5215086015157, 313.8476612231624, 18.317554183879622,  /* hpluv */
    },
    {
        "#441177",
        0.26666666666666666, 0.06666666666666667, 0.4666666666666667,  /* rgb */
        0.05913702026719755, 0.0296181667108057, 0.17713497327085811,  /* xyz */
        19.890324113966443, 7.953703122929756, -54.48793125295337,  /* luv */
        19.890324113966443, 55.06537973712953, 278.3049149301807,  /* lch */
        278.3049149301807, 89.59017835491076, 19.890324113966443,  /* hsluv */
        278.3049149301807, 351.2983459721746, 19.890324113966443,  /* hpluv */
    },
    {
        "#441188",
        0.26666666666666666, 0.06666666666666667, 0.5333333333333333,  /* rgb */
        0.07027743736914138, 0.03407433355158329, 0.23580783667443028,  /* xyz */
        21.606863406663187, 5.69776159856002, -64.70948517160164,  /* luv */
        21.606863406663187, 64.95984881761778, 275.03199667533886,  /* lch */
        275.03199667533886, 91.64175943173485, 21.606863406663187,  /* hsluv */
        275.03199667533886, 381.4982987200287, 21.606863406663187,  /* hpluv */
    },
    {
        "#441199",
        0.26666666666666666, 0.06666666666666667, 0.6,  /* rgb */
        0.08333440147821408, 0.039297119195212456, 0.30457451431554816,  /* xyz */
        23.43769832774617, 3.7406310226982495, -74.76936719784993,  /* luv */
        23.43769832774617, 74.86287859556892, 272.8640583398327,  /* lch */
        272.8640583398327, 93.21012686222703, 23.43769832774617,  /* hsluv */
        272.8640583398327, 405.3133316440985, 23.43769832774617,  /* hpluv */
    },
    {
        "#4411aa",
        0.26666666666666666, 0.06666666666666667, 0.6666666666666666,  /* rgb */
        0.09839209444346664, 0.04532019638131356, 0.38387836393254676,  /* xyz */
        25.357592547235534, 2.0139499346539345, -84.70774688583329,  /* luv */
        25.357592547235534, 84.73168460979453, 271.36196630103893,  /* lch */
        271.36196630103893, 94.41804043502039, 25.357592547235534,  /* hsluv */
        271.36196630103893, 424.0110242155554, 25.357592547235534,  /* hpluv */
    },
    {
        "#4411bb",
        0.26666666666666666, 0.06666666666666667, 0.7333333333333333,  /* rgb */
        0.11552968655080328, 0.052175233224248316, 0.4741363490311885,  /* xyz */
        27.345710117802, 0.4658463782802316, -94.54921806930923,  /* luv */
        27.345710117802, 94.5503656807627, 270.28229546415105,  /* lch */
        270.28229546415105, 95.3579307613671, 27.345710117802,  /* hsluv */
        270.28229546415105, 438.74616528359593, 27.345710117802,  /* hpluv */
    },
    {
        "#4411cc",
        0.26666666666666666, 0.06666666666666667, 0.8,  /* rgb */
        0.134822061994525, 0.05989218340173712, 0.5757428597014587,  /* xyz */
        29.385247120175748, -0.9421816517973732, -104.30736512086487,  /* luv */
        29.385247120175748, 104.31162027656555, 269.48247600708424,  /* lch */
        269.48247600708424, 96.09762952635796, 29.385247120175748,  /* hsluv */
        269.48247600708424, 450.44593346340554, 29.385247120175748,  /* hpluv */
    },
    {
        "#4411dd",
        0.26666666666666666, 0.06666666666666667, 0.8666666666666667,  /* rgb */
        0.15634038754515855, 0.06849951362199065, 0.6890727076014647,  /* xyz */
        31.46285063047071, -2.2386673531041716, -113.9891152722231,  /* luv */
        31.46285063047071, 114.01109609183669, 268.87489517121514,  /* lch */
        268.87489517121514, 96.68653827560644, 31.46285063047071,  /* hsluv */
        268.87489517121514, 459.8205525680887, 31.46285063047071,  /* hpluv */
    },
    {
        "#4411ee",
        0.26666666666666666, 0.06666666666666667, 0.9333333333333333,  /* rgb */
        0.1801525678113333, 0.07802438572846068, 0.8144835236699879,  /* xyz */
        33.56800523779481, -3.4449349542652996, -123.59777474794072,  /* luv */
        33.56800523779481, 123.64577428881995, 268.4034571353968,  /* lch */
        268.4034571353968, 97.16069530943828, 33.56800523779481,  /* hsluv */
        268.4034571353968, 467.40469529424774, 33.56800523779481,  /* hpluv */
    },
    {
        "#4411ff",
        0.26666666666666666, 0.06666666666666667, 1.0,  /* rgb */
        0.20632361622116469, 0.08849280509239338, 0.9523177119617697,  /* xyz */
        35.69247302990261, -4.57713081064657, -133.1348845050823,  /* luv */
        35.69247302990261, 133.21354134861582, 268.0309666488174,  /* lch */
        268.0309666488174, 99.99999999999953, 35.69247302990261,  /* hsluv */
        268.0309666488174, 473.5993091812269, 35.69247302990261,  /* hpluv */
    },
    {
        "#442200",
        0.26666666666666666, 0.13333333333333333, 0.0,  /* rgb */
        0.029558451554102638, 0.023731737201196354, 0.0030241009570323328,  /* xyz */
        17.335054234495246, 22.939934036980937, 16.43787544481942,  /* luv */
        17.335054234495246, 28.221345162136295, 35.62392928365679,  /* lch */
        35.62392928365679, 100.00000000000233, 17.335054234495246,  /* hsluv */
        35.62392928365679, 206.5816929714252, 17.335054234495246,  /* hpluv */
    },
    {
        "#442211",
        0.26666666666666666, 0.13333333333333333, 0.06666666666666667,  /* rgb */
        0.03057011705373976, 0.024136403401051207, 0.008352205921787963,  /* xyz */
        17.52346036863171, 21.626934736568952, 11.793569621503133,  /* luv */
        17.52346036863171, 24.6335663377647, 28.604455948929278,  /* lch */
        28.604455948929278, 74.20891633542168, 17.52346036863171,  /* hsluv */
        28.604455948929278, 178.38024144397153, 17.52346036863171,  /* hpluv */
    },
    {
        "#442222",
        0.26666666666666666, 0.13333333333333333, 0.13333333333333333,  /* rgb */
        0.03244547519221678, 0.024886546656442028, 0.01822909211776716,  /* xyz */
        17.867218894769124, 19.520407715454283, 4.212278007443301,  /* luv */
        17.867218894769124, 19.969717158476673, 12.17705063006198,  /* lch */
        12.17705063006198, 33.23410747851134, 17.867218894769124,  /* hsluv */
        12.17705063006198, 141.82548657821144, 17.867218894769124,  /* hpluv */
    },
    {
        "#442233",
        0.26666666666666666, 0.13333333333333333, 0.2,  /* rgb */
        0.03553322592467452, 0.02612164694942514, 0.0344912459753783,  /* xyz */
        18.41846579253717, 16.742876035452564, -6.091311674447706,  /* luv */
        18.41846579253717, 17.816508520296413, 340.0078474902701,  /* lch */
        340.0078474902701, 42.08882916744639, 18.41846579253717,  /* hsluv */
        340.0078474902701, 122.74631828897522, 18.41846579253717,  /* hpluv */
    },
    {
        "#442244",
        0.26666666666666666, 0.13333333333333333, 0.26666666666666666,  /* rgb */
        0.0399912211688934, 0.027904845047112714, 0.05797002092826494,  /* xyz */
        19.184484654176366, 13.739181474451915, -17.766800257843144,  /* luv */
        19.184484654176366, 22.459392222186644, 307.71501294924474,  /* lch */
        307.71501294924474, 51.39549550668775, 19.184484654176366,  /* hsluv */
        307.71501294924474, 148.55497092460666, 19.184484654176366,  /* hpluv */
    },
    {
        "#442255",
        0.26666666666666666, 0.13333333333333333, 0.3333333333333333,  /* rgb */
        0.04595363520825539, 0.030289810662857547, 0.08937206820223885,  /* xyz */
        20.15959093593866, 10.84516371404078, -29.759603043606887,  /* luv */
        20.15959093593866, 31.67414638624699, 290.0230394308377,  /* lch */
        290.0230394308377, 59.99426948661502, 20.15959093593866,  /* hsluv */
        290.0230394308377, 199.37124945415627, 20.15959093593866,  /* hpluv */
    },
    {
        "#442266",
        0.26666666666666666, 0.13333333333333333, 0.4,  /* rgb */
        0.05353863098176356, 0.03332380897226086, 0.12931971260938283,  /* xyz */
        21.328700207166023, 8.225596403740248, -41.513737385232226,  /* luv */
        21.328700207166023, 42.32080845030317, 281.20751024789365,  /* lch */
        281.20751024789365, 67.34378999526514, 21.328700207166023,  /* hsluv */
        281.20751024789365, 251.78444250533212, 21.328700207166023,  /* hpluv */
    },
    {
        "#442277",
        0.26666666666666666, 0.13333333333333333, 0.4666666666666667,  /* rgb */
        0.06285264400196548, 0.037049414180341675, 0.17837351451578073,  /* xyz */
        22.670973432823146, 5.919222191981879, -52.84423243286612,  /* luv */
        22.670973432823146, 53.17471290732871, 276.3912107834053,  /* lch */
        276.3912107834053, 73.3546851738733, 22.670973432823146,  /* hsluv */
        276.3912107834053, 297.62836069812846, 22.670973432823146,  /* hpluv */
    },
    {
        "#442288",
        0.26666666666666666, 0.13333333333333333, 0.5333333333333333,  /* rgb */
        0.07399306110390931, 0.04150558102111927, 0.2370463779193529,  /* xyz */
        24.16306256867677, 3.901360261081485, -63.75403795120868,  /* luv */
        24.16306256867677, 63.873296196226654, 273.50178734535825,  /* lch */
        273.50178734535825, 78.16243803743649, 24.16306256867677,  /* hsluv */
        273.50178734535825, 335.433687598002, 24.16306256867677,  /* hpluv */
    },
    {
        "#442299",
        0.26666666666666666, 0.13333333333333333, 0.6,  /* rgb */
        0.08705002521298202, 0.04672836666474843, 0.3058130555604708,  /* xyz */
        25.781579723973344, 2.126012828326607, -74.31178517152048,  /* luv */
        25.781579723973344, 74.34219088730451, 271.63874874229737,  /* lch */
        271.63874874229737, 81.97442325268939, 25.781579723973344,  /* hsluv */
        271.63874874229737, 365.9023154576992, 25.781579723973344,  /* hpluv */
    },
    {
        "#4422aa",
        0.26666666666666666, 0.13333333333333333, 0.6666666666666666,  /* rgb */
        0.10210771817823457, 0.05275144385084953, 0.3851169051774694,  /* xyz */
        27.5046927955253, 0.5463751257897731, -84.59347691506922,  /* luv */
        27.5046927955253, 84.59524136946729, 270.37005871586604,  /* lch */
        270.37005871586604, 84.99505447684108, 27.5046927955253,  /* hsluv */
        270.37005871586604, 390.28194603250415, 27.5046927955253,  /* hpluv */
    },
    {
        "#4422bb",
        0.26666666666666666, 0.13333333333333333, 0.7333333333333333,  /* rgb */
        0.11924531028557121, 0.05960648069378429, 0.47537489027611113,  /* xyz */
        29.312965227715125, -0.87767531850734, -94.6620020982533,  /* luv */
        29.312965227715125, 94.66607077097068, 269.4687873747244,  /* lch */
        269.4687873747244, 87.39844359413115, 29.312965227715125,  /* hsluv */
        269.4687873747244, 409.80186003034385, 29.312965227715125,  /* hpluv */
    },
    {
        "#4422cc",
        0.26666666666666666, 0.13333333333333333, 0.8,  /* rgb */
        0.13853768572929295, 0.0673234308712731, 0.5769814009463813,  /* xyz */
        31.189647787292287, -2.178162270558094, -104.5636784846657,  /* luv */
        31.189647787292287, 104.58636263453005, 268.8066462434555,  /* lch */
        268.8066462434555, 89.32354136879263, 31.189647787292287,  /* hsluv */
        268.8066462434555, 425.5042626646315, 31.189647787292287,  /* hpluv */
    },
    {
        "#4422dd",
        0.26666666666666666, 0.13333333333333333, 0.8666666666666667,  /* rgb */
        0.1600560112799265, 0.07593076109152663, 0.6903112488463873,  /* xyz */
        33.1206275871571, -3.37987077956927, -114.33074760315782,  /* luv */
        33.1206275871571, 114.38069493574325, 268.30670268445874,  /* lch */
        268.30670268445874, 90.87788462644902, 33.1206275871571,  /* hsluv */
        268.30670268445874, 438.22131720165, 33.1206275871571,  /* hpluv */
    },
    {
        "#4422ee",
        0.26666666666666666, 0.13333333333333333, 0.9333333333333333,  /* rgb */
        0.18386819154610123, 0.08545563319799665, 0.8157220649149105,  /* xyz */
        35.094194245728495, -4.501781215390942, -123.98506814749854,  /* luv */
        35.094194245728495, 124.06676894983242, 267.92055762145594,  /* lch */
        267.92055762145594, 93.34526796615985, 35.094194245728495,  /* hsluv */
        267.92055762145594, 448.6002621818896, 35.094194245728495,  /* hpluv */
    },
    {
        "#4422ff",
        0.26666666666666666, 0.13333333333333333, 1.0,  /* rgb */
        0.21003923995593263, 0.09592405256192936, 0.9535562532066924,  /* xyz */
        37.1007304630435, -5.558433323691039, -133.54135623850334,  /* luv */
        37.1007304630435, 133.65698637569523, 267.6165357991792,  /* lch */
        267.6165357991792, 99.99999999999953, 37.1007304630435,  /* hsluv */
        267.6165357991792, 457.1392703956108, 37.1007304630435,  /* hpluv */
    },
    {
        "#443300",
        0.26666666666666666, 0.2, 0.0,  /* rgb */
        0.03567617364311345, 0.03596718137921815, 0.005063341653369214,  /* xyz */
        22.29071337722766, 12.718170288291832, 23.177830096624476,  /* luv */
        22.29071337722766, 26.437920936979527, 61.2454831359909,  /* lch */
        61.2454831359909, 100.00000000000222, 22.29071337722766,  /* hsluv */
        61.2454831359909, 150.50213417517443, 22.29071337722766,  /* hpluv */
    },
    {
        "#443311",
        0.26666666666666666, 0.2, 0.06666666666666667,  /* rgb */
        0.036687839142750575, 0.036371847579073004, 0.010391446618124845,  /* xyz */
        22.433780901835803, 12.072970412625418, 19.045384784131137,  /* luv */
        22.433780901835803, 22.54957419020906, 57.629172933000696,  /* lch */
        57.629172933000696, 82.43962629041629, 22.433780901835803,  /* hsluv */
        57.629172933000696, 127.54845368116494, 22.433780901835803,  /* hpluv */
    },
    {
        "#443322",
        0.26666666666666666, 0.2, 0.13333333333333333,  /* rgb */
        0.03856319728122759, 0.037121990834463825, 0.02026833281410404,  /* xyz */
        22.696208012825196, 10.987826358432828, 12.044527949459761,  /* luv */
        22.696208012825196, 16.30346532515062, 47.62683156031201,  /* lch */
        47.62683156031201, 53.15273639083543, 22.696208012825196,  /* hsluv */
        47.62683156031201, 91.1519465603444, 22.696208012825196,  /* hpluv */
    },
    {
        "#443333",
        0.26666666666666666, 0.2, 0.2,  /* rgb */
        0.04165094801368533, 0.03835709112744694, 0.036530486671715184,  /* xyz */
        23.120693409411984, 9.456709543870385, 2.040648444186429,  /* luv */
        23.120693409411984, 9.674378608979996, 12.17705063006262,  /* lch */
        12.17705063006262, 12.442031287537192, 23.120693409411984,  /* hsluv */
        12.17705063006262, 53.09596902872139, 23.120693409411984,  /* hpluv */
    },
    {
        "#443344",
        0.26666666666666666, 0.2, 0.26666666666666666,  /* rgb */
        0.04610894325790421, 0.04014028922513451, 0.06000926162460182,  /* xyz */
        23.717766813164857, 7.6631588220980635, -9.90960141180911,  /* luv */
        23.717766813164857, 12.526939102335753, 307.7150129492477,  /* lch */
        307.7150129492477, 23.187203128030674, 23.717766813164857,  /* hsluv */
        307.7150129492477, 67.02093739050106, 23.717766813164857,  /* hpluv */
    },
    {
        "#443355",
        0.26666666666666666, 0.2, 0.3333333333333333,  /* rgb */
        0.0520713572972662, 0.042525254840879344, 0.09141130889857574,  /* xyz */
        24.489302703414438, 5.791768638331533, -22.723263265430916,  /* luv */
        24.489302703414438, 23.44976071072033, 284.29924581568366,  /* lch */
        284.29924581568366, 34.01725628242175, 24.489302703414438,  /* hsluv */
        284.29924581568366, 121.5070067704628, 24.489302703414438,  /* hpluv */
    },
    {
        "#443366",
        0.26666666666666666, 0.2, 0.4,  /* rgb */
        0.05965635307077438, 0.045559253150282655, 0.1313589533057197,  /* xyz */
        25.430183284665546, 3.973822450468024, -35.615165563468096,  /* luv */
        25.430183284665546, 35.83617282831814, 276.3665410486477,  /* lch */
        276.3665410486477, 44.052166583945755, 25.430183284665546,  /* hsluv */
        276.3665410486477, 178.8180928237824, 25.430183284665546,  /* hpluv */
    },
    {
        "#443377",
        0.26666666666666666, 0.2, 0.4666666666666667,  /* rgb */
        0.06897036609097629, 0.04928485835836347, 0.1804127552121176,  /* xyz */
        26.530043490118196, 2.2780541920282986, -48.15639097331764,  /* luv */
        26.530043490118196, 48.21024292074088, 272.70837696599085,  /* lch */
        272.70837696599085, 52.85632854699646, 26.530043490118196,  /* hsluv */
        272.70837696599085, 230.59011420562925, 26.530043490118196,  /* hpluv */
    },
    {
        "#443388",
        0.26666666666666666, 0.2, 0.5333333333333333,  /* rgb */
        0.08011078319292012, 0.05374102519914106, 0.23908561861568978,  /* xyz */
        27.775048733978736, 0.7264546828788158, -60.18529860707736,  /* luv */
        27.775048733978736, 60.18968271082134, 270.69154373418417,  /* lch */
        270.69154373418417, 60.324174233719404, 27.775048733978736,  /* hsluv */
        270.69154373418417, 274.98344647514443, 27.775048733978736,  /* hpluv */
    },
    {
        "#443399",
        0.26666666666666666, 0.2, 0.6,  /* rgb */
        0.09316774730199284, 0.05896381084277023, 0.30785229625680766,  /* xyz */
        29.149523442996127, -0.6856251053431653, -71.69289032982304,  /* luv */
        29.149523442996127, 71.69616869560822, 269.4520763892188,  /* lch */
        269.4520763892188, 66.5368599437509, 29.149523442996127,  /* hsluv */
        269.4520763892188, 312.1072204314613, 29.149523442996127,  /* hpluv */
    },
    {
        "#4433aa",
        0.26666666666666666, 0.2, 0.6666666666666666,  /* rgb */
        0.10822544026724537, 0.06498688802887133, 0.38715614587380626,  /* xyz */
        30.637282446041525, -1.9745033094659883, -82.73771931882848,  /* luv */
        30.637282446041525, 82.76127633984589, 268.6329181198423,  /* lch */
        268.6329181198423, 71.65533873228857, 30.637282446041525,  /* hsluv */
        268.6329181198423, 342.78062465137026, 30.637282446041525,  /* hpluv */
    },
    {
        "#4433bb",
        0.26666666666666666, 0.2, 0.7333333333333333,  /* rgb */
        0.12536303237458202, 0.07184192487180609, 0.477414130972448,  /* xyz */
        32.22260223977725, -3.159512199412677, -93.39716427763916,  /* luv */
        32.22260223977725, 93.45059021987264, 268.06249249337276,  /* lch */
        268.06249249337276, 75.85811901350428, 32.22260223977725,  /* hsluv */
        268.06249249337276, 368.01097010926605, 32.22260223977725,  /* hpluv */
    },
    {
        "#4433cc",
        0.26666666666666666, 0.2, 0.8,  /* rgb */
        0.14465540781830377, 0.07955887504929489, 0.5790206416427182,  /* xyz */
        33.89084585806263, -4.258883975433159, -103.7446460064479,  /* luv */
        33.89084585806263, 103.83202621407031, 267.64923636722057,  /* lch */
        267.64923636722057, 79.3114034284002, 33.89084585806263,  /* hsluv */
        267.64923636722057, 388.7659742130086, 33.89084585806263,  /* hpluv */
    },
    {
        "#4433dd",
        0.26666666666666666, 0.2, 0.8666666666666667,  /* rgb */
        0.16617373336893732, 0.08816620526954842, 0.6923504895427242,  /* xyz */
        35.62880094230274, -5.288235304271155, -113.84148557108705,  /* luv */
        35.62880094230274, 113.96424557581804, 267.34037283148996,  /* lch */
        267.34037283148996, 85.5677988674314, 35.62880094230274,  /* hsluv */
        267.34037283148996, 405.88849342464613, 35.62880094230274,  /* hpluv */
    },
    {
        "#4433ee",
        0.26666666666666666, 0.2, 0.9333333333333333,  /* rgb */
        0.18998591363511205, 0.09769107737601845, 0.8177613056112474,  /* xyz */
        37.42480622510425, -6.260322962048417, -123.73575853791813,  /* luv */
        37.42480622510425, 123.8940256208633, 267.1036303379014,  /* lch */
        267.1036303379014, 92.6566888343209, 37.42480622510425,  /* hsluv */
        267.1036303379014, 420.0781866988076, 37.42480622510425,  /* hpluv */
    },
    {
        "#4433ff",
        0.26666666666666666, 0.2, 1.0,  /* rgb */
        0.21615696204494345, 0.10815949673995115, 0.9555954939030292,  /* xyz */
        39.26873720847325, -7.185325259127194, -133.4639193988003,  /* luv */
        39.26873720847325, 133.65719838590405, 266.9183300519548,  /* lch */
        266.9183300519548, 99.99999999999946, 39.26873720847325,  /* hsluv */
        266.9183300519548, 431.9015319411559, 39.26873720847325,  /* hpluv */
    },
    {
        "#444400",
        0.26666666666666666, 0.26666666666666666, 0.0,  /* rgb */
        0.04450874412607948, 0.05363232234515046, 0.008007531814357809,  /* xyz */
        27.74551397494701, 2.2005424241160507, 30.507410892539095,  /* luv */
        27.74551397494701, 30.58667203745036, 85.87432021817473,  /* lch */
        85.87432021817473, 100.00000000000233, 27.74551397494701,  /* hsluv */
        85.87432021817473, 139.8874580747976, 27.74551397494701,  /* hpluv */
    },
    {
        "#444411",
        0.26666666666666666, 0.26666666666666666, 0.06666666666666667,  /* rgb */
        0.0455204096257166, 0.05403698854500531, 0.01333563677911344,  /* xyz */
        27.85526119033846, 1.9436625081132386, 26.946133881171576,  /* luv */
        27.85526119033846, 27.016142490878813, 85.8743202181744,  /* lch */
        85.8743202181744, 87.97851984188515, 27.85526119033846,  /* hsluv */
        85.8743202181744, 123.07091505864167, 27.85526119033846,  /* hpluv */
    },
    {
        "#444422",
        0.26666666666666666, 0.26666666666666666, 0.13333333333333333,  /* rgb */
        0.04739576776419362, 0.054787131800396134, 0.023212522975092638,  /* xyz */
        28.05726271702293, 1.4966332659688721, 20.748705182851612,  /* luv */
        28.05726271702293, 20.802612285424587, 85.87432021817351,  /* lch */
        85.87432021817351, 67.25632360927025, 28.05726271702293,  /* hsluv */
        85.87432021817351, 94.08316149156585, 28.05726271702293,  /* hpluv */
    },
    {
        "#444433",
        0.26666666666666666, 0.26666666666666666, 0.2,  /* rgb */
        0.050483518496651364, 0.05602223209337925, 0.03947467683270378,  /* xyz */
        28.38587564175301, 0.8321596289439407, 11.536717243043768,  /* luv */
        28.38587564175301, 11.566690727861081, 85.8743202181704,  /* lch */
        85.8743202181704, 36.96301390181452, 28.38587564175301,  /* hsluv */
        85.8743202181704, 51.706620575080976, 28.38587564175301,  /* hpluv */
    },
    {
        "#444444",
        0.26666666666666666, 0.26666666666666666, 0.26666666666666666,  /* rgb */
        0.054941513740870244, 0.05780543019106682, 0.06295345178559042,  /* xyz */
        28.851902398399886, 1.4574581087858305e-12, 5.621624133888204e-13,  /* luv */
        28.851902398399886, 1.5621173828789924e-12, 0.0,  /* lch */
        0.0, 1.967122046524583e-12, 28.851902398399886,  /* hsluv */
        0.0, 6.870344861405415e-12, 28.851902398399886,  /* hpluv */
    },
    {
        "#444455",
        0.26666666666666666, 0.26666666666666666, 0.3333333333333333,  /* rgb */
        0.060903927780232237, 0.06019039580681165, 0.09435549905956434,  /* xyz */
        29.460449155476795, -0.9350076474510962, -12.962559674338587,  /* luv */
        29.460449155476795, 12.996237632929807, 265.8743202181835,  /* lch */
        265.8743202181835, 10.903125265393685, 29.460449155476795,  /* hsluv */
        265.8743202181835, 55.978029465358816, 29.460449155476795,  /* hpluv */
    },
    {
        "#444466",
        0.26666666666666666, 0.26666666666666666, 0.4,  /* rgb */
        0.06848892355374041, 0.06322439411621497, 0.1343031434667083,  /* xyz */
        30.211799594498324, -1.9132700229980284, -26.52478502590359,  /* luv */
        30.211799594498324, 26.593698931350303, 265.8743202181804,  /* lch */
        265.8743202181804, 21.755790816569554, 30.211799594498324,  /* hsluv */
        265.8743202181804, 111.69699235114156, 30.211799594498324,  /* hpluv */
    },
    {
        "#444477",
        0.26666666666666666, 0.26666666666666666, 0.4666666666666667,  /* rgb */
        0.07780293657394233, 0.06694999932429578, 0.1833569453731062,  /* xyz */
        31.102235000061533, -2.8913549583876708, -40.084550420447286,  /* luv */
        31.102235000061533, 40.188693881548005, 265.8743202181794,  /* lch */
        265.8743202181794, 31.93633059892706, 31.102235000061533,  /* hsluv */
        265.8743202181794, 163.96517620104862, 31.102235000061533,  /* hpluv */
    },
    {
        "#444488",
        0.26666666666666666, 0.26666666666666666, 0.5333333333333333,  /* rgb */
        0.08894335367588616, 0.07140616616507338, 0.24202980877667837,  /* xyz */
        32.12490604381161, -3.8435576093674464, -53.285494518625086,  /* luv */
        32.12490604381161, 53.4239352836437, 265.8743202181789,  /* lch */
        265.8743202181789, 41.10235740058935, 32.12490604381161,  /* hsluv */
        265.8743202181789, 211.0247215969328, 32.12490604381161,  /* hpluv */
    },
    {
        "#444499",
        0.26666666666666666, 0.26666666666666666, 0.6,  /* rgb */
        0.10200031778495887, 0.07662895180870254, 0.3107964864177963,  /* xyz */
        33.27072478272764, -4.758226887654945, -65.96609144677873,  /* luv */
        33.27072478272764, 66.13747760445038, 265.87432021817864,  /* lch */
        265.87432021817864, 50.23375829037082, 33.27072478272764,  /* hsluv */
        265.87432021817864, 252.24623468359613, 33.27072478272764,  /* hpluv */
    },
    {
        "#4444aa",
        0.26666666666666666, 0.26666666666666666, 0.6666666666666666,  /* rgb */
        0.11705801075021141, 0.08265202899480364, 0.3901003360347949,  /* xyz */
        34.52920853177758, -5.632795914712675, -78.09075506151174,  /* luv */
        34.52920853177758, 78.29364224439827, 265.87432021817847,  /* lch */
        265.87432021817847, 59.026096841655765, 34.52920853177758,  /* hsluv */
        265.87432021817847, 287.7260607718821, 34.52920853177758,  /* hpluv */
    },
    {
        "#4444bb",
        0.26666666666666666, 0.26666666666666666, 0.7333333333333333,  /* rgb */
        0.13419560285754806, 0.0895070658377384, 0.4803583211334366,  /* xyz */
        35.889214465207765, -6.46961387860876, -89.6920535355044,  /* luv */
        35.889214465207765, 89.92508199136698, 265.87432021817835,  /* lch */
        265.87432021817835, 67.42837175477598, 35.889214465207765,  /* hsluv */
        265.87432021817835, 317.94808698570125, 35.889214465207765,  /* hpluv */
    },
    {
        "#4444cc",
        0.26666666666666666, 0.26666666666666666, 0.8,  /* rgb */
        0.1534879783012698, 0.0972240160152272, 0.5819648318037067,  /* xyz */
        37.33952878530004, -7.273142728114592, -100.83184548282328,  /* luv */
        37.33952878530004, 101.09381617396524, 265.8743202181783,  /* lch */
        265.8743202181783, 75.58085489875343, 37.33952878530004,  /* hsluv */
        265.8743202181783, 343.5540594207739, 37.33952878530004,  /* hpluv */
    },
    {
        "#4444dd",
        0.26666666666666666, 0.26666666666666666, 0.8666666666666667,  /* rgb */
        0.17500630385190336, 0.10583134623548074, 0.6952946797037127,  /* xyz */
        38.86930123289487, -8.048339564000841, -111.57885410025274,  /* luv */
        38.86930123289487, 111.86874653835605, 265.87432021817824,  /* lch */
        265.87432021817824, 83.63137260767607, 38.86930123289487,  /* hsluv */
        265.87432021817824, 365.208910634554, 38.86930123289487,  /* hpluv */
    },
    {
        "#4444ee",
        0.26666666666666666, 0.26666666666666666, 0.9333333333333333,  /* rgb */
        0.19881848411807806, 0.11535621834195076, 0.820705495772236,  /* xyz */
        40.46833632266467, -8.799851087852959, -121.99749933853333,  /* luv */
        40.46833632266467, 122.31446040441755, 265.8743202181781,  /* lch */
        265.8743202181781, 91.72493192366336, 40.46833632266467,  /* hsluv */
        265.8743202181781, 383.5321540535898, 40.46833632266467,  /* hpluv */
    },
    {
        "#4444ff",
        0.26666666666666666, 0.26666666666666666, 1.0,  /* rgb */
        0.22498953252790949, 0.12582463770588348, 0.9585396840640178,  /* xyz */
        42.12726451512772, -9.531690631441306, -132.14342037099996,  /* luv */
        42.12726451512772, 132.4867415013303, 265.8743202181781,  /* lch */
        265.8743202181781, 99.99999999999945, 42.12726451512772,  /* hsluv */
        265.8743202181781, 399.06945294425486, 42.12726451512772,  /* hpluv */
    },
    {
        "#445500",
        0.26666666666666666, 0.3333333333333333, 0.0,  /* rgb */
        0.05632200084042545, 0.07725883577384272, 0.011945284052473018,  /* xyz */
        33.40535706082105, -7.7080633936099785, 37.99035250062638,  /* luv */
        33.40535706082105, 38.76443117603764, 101.46935061277635,  /* lch */
        101.46935061277635, 100.00000000000225, 33.40535706082105,  /* hsluv */
        101.46935061277635, 147.2504477107337, 33.40535706082105,  /* hpluv */
    },
    {
        "#445511",
        0.26666666666666666, 0.3333333333333333, 0.06666666666666667,  /* rgb */
        0.05733366634006257, 0.07766350197369758, 0.01727338901722865,  /* xyz */
        33.49146532809925, -7.76452054412734, 34.95193030210451,  /* luv */
        33.49146532809925, 35.80398317398983, 102.524785035338,  /* lch */
        102.524785035338, 91.54526334948821, 33.49146532809925,  /* hsluv */
        102.524785035338, 135.6552235974694, 33.49146532809925,  /* hpluv */
    },
    {
        "#445522",
        0.26666666666666666, 0.3333333333333333, 0.13333333333333333,  /* rgb */
        0.05920902447853959, 0.07841364522908839, 0.027150275213207845,  /* xyz */
        33.65029924749038, -7.866084102104785, 29.568154300136623,  /* luv */
        33.65029924749038, 30.59658523133053, 104.89747834962938,  /* lch */
        104.89747834962938, 76.65584974943702, 33.65029924749038,  /* hsluv */
        104.89747834962938, 115.37809260186573, 33.65029924749038,  /* hpluv */
    },
    {
        "#445533",
        0.26666666666666666, 0.3333333333333333, 0.2,  /* rgb */
        0.06229677521099733, 0.0796487455220715, 0.04341242907081899,  /* xyz */
        33.90962451591509, -8.025357305677975, 21.3394372651287,  /* luv */
        33.90962451591509, 22.79863905315759, 110.61032755328398,  /* lch */
        110.61032755328398, 54.14033976531783, 33.90962451591509,  /* hsluv */
        110.61032755328398, 85.31497514678564, 33.90962451591509,  /* hpluv */
    },
    {
        "#445544",
        0.26666666666666666, 0.3333333333333333, 0.26666666666666666,  /* rgb */
        0.0667547704552162, 0.08143194361975908, 0.06689120402370563,  /* xyz */
        34.27934245856332, -8.240206141340904, 10.655809217524563,  /* luv */
        34.27934245856332, 13.470236350267719, 127.71501294923505,  /* lch */
        127.71501294923505, 25.389368077603987, 34.27934245856332,  /* hsluv */
        127.71501294923505, 49.86341970510898, 34.27934245856332,  /* hpluv */
    },
    {
        "#445555",
        0.26666666666666666, 0.3333333333333333, 0.3333333333333333,  /* rgb */
        0.0727171844945782, 0.08381690923550392, 0.09829325129767953,  /* xyz */
        34.765484639924374, -8.504548176457845, -1.8351830437726266,  /* luv */
        34.765484639924374, 8.700300942487164, 192.17705063006022,  /* lch */
        192.17705063006022, 31.631662766838197, 34.765484639924374,  /* hsluv */
        192.17705063006022, 31.755964929866167, 34.765484639924374,  /* hpluv */
    },
    {
        "#445566",
        0.26666666666666666, 0.3333333333333333, 0.4,  /* rgb */
        0.08030218026808637, 0.08685090754490724, 0.1382408957048235,  /* xyz */
        35.37077403356499, -8.810704524327633, -15.418348942742396,  /* luv */
        35.37077403356499, 17.758209322315498, 240.25450405072752,  /* lch */
        240.25450405072752, 38.20834130497328, 35.37077403356499,  /* hsluv */
        240.25450405072752, 63.707994458834335, 35.37077403356499,  /* hpluv */
    },
    {
        "#445577",
        0.26666666666666666, 0.3333333333333333, 0.4666666666666667,  /* rgb */
        0.08961619328828829, 0.09057651275298804, 0.18729469761122142,  /* xyz */
        36.09505744427929, -9.151247658478036, -29.460204217726012,  /* luv */
        36.09505744427929, 30.848808182114933, 252.74359474799982,  /* lch */
        252.74359474799982, 44.73624158797629, 36.09505744427929,  /* hsluv */
        252.74359474799982, 108.45010561443505, 36.09505744427929,  /* hpluv */
    },
    {
        "#445588",
        0.26666666666666666, 0.3333333333333333, 0.5333333333333333,  /* rgb */
        0.10075661039023212, 0.09503267959376564, 0.24596756101479358,  /* xyz */
        36.93573906814324, -9.520006236887241, -43.486035987457925,  /* luv */
        36.93573906814324, 44.51590552435003, 257.651563208142,  /* lch */
        257.651563208142, 50.935955060618795, 36.93573906814324,  /* hsluv */
        257.651563208142, 152.93530201777457, 36.93573906814324,  /* hpluv */
    },
    {
        "#445599",
        0.26666666666666666, 0.3333333333333333, 0.6,  /* rgb */
        0.11381357449930483, 0.1002554652373948, 0.3147342386559115,  /* xyz */
        37.88824104626649, -9.912312200622779, -57.19145086007327,  /* luv */
        37.88824104626649, 58.04408656049977, 260.1672847459598,  /* lch */
        260.1672847459598, 56.63742714999568, 37.88824104626649,  /* hsluv */
        260.1672847459598, 194.39847957109023, 37.88824104626649,  /* hpluv */
    },
    {
        "#4455aa",
        0.26666666666666666, 0.3333333333333333, 0.6666666666666666,  /* rgb */
        0.12887126746455738, 0.10627854242349591, 0.3940380882729101,  /* xyz */
        38.94647705030069, -10.324795865755794, -70.41490438378501,  /* luv */
        38.94647705030069, 71.16783099861281, 261.6582777967235,  /* lch */
        261.6582777967235, 61.761764613918565, 38.94647705030069,  /* hsluv */
        261.6582777967235, 231.87550738335244, 38.94647705030069,  /* hpluv */
    },
    {
        "#4455bb",
        0.26666666666666666, 0.3333333333333333, 0.7333333333333333,  /* rgb */
        0.14600885957189402, 0.11313357926643067, 0.48429607337155184,  /* xyz */
        40.1033117689144, -10.755022431765958, -83.09693160134084,  /* luv */
        40.1033117689144, 83.7900384834958, 262.62535077863674,  /* lch */
        262.62535077863674, 66.2950009745661, 40.1033117689144,  /* hsluv */
        262.62535077863674, 265.1254861404168, 40.1033117689144,  /* hpluv */
    },
    {
        "#4455cc",
        0.26666666666666666, 0.3333333333333333, 0.8,  /* rgb */
        0.16530123501561578, 0.12085052944391947, 0.5859025840418219,  /* xyz */
        41.3509797710146, -11.201148817186375, -95.24196975873555,  /* luv */
        41.3509797710146, 95.89837609860061, 263.29241135806944,  /* lch */
        263.29241135806944, 71.98501610952789, 41.3509797710146,  /* hsluv */
        263.29241135806944, 294.28272942652967, 41.3509797710146,  /* hpluv */
    },
    {
        "#4455dd",
        0.26666666666666666, 0.3333333333333333, 0.8666666666666667,  /* rgb */
        0.18681956056624932, 0.129457859664173, 0.6992324319418279,  /* xyz */
        42.681444615652666, -11.661670844638417, -106.88917561239117,  /* luv */
        42.681444615652666, 107.5234413046071, 263.7736234620424,  /* lch */
        263.7736234620424, 81.27323638377302, 42.681444615652666,  /* hsluv */
        263.7736234620424, 319.6710972843696, 42.681444615652666,  /* hpluv */
    },
    {
        "#4455ee",
        0.26666666666666666, 0.3333333333333333, 0.9333333333333333,  /* rgb */
        0.21063174083242403, 0.13898273177064302, 0.8246432480103512,  /* xyz */
        44.0866885883675, -12.135265575370425, -118.09285002410934,  /* luv */
        44.0866885883675, 118.71472485501347, 264.1328581088545,  /* lch */
        264.1328581088545, 90.56842838106772, 44.0866885883675,  /* hsluv */
        264.1328581088545, 341.6932795953854, 44.0866885883675,  /* hpluv */
    },
    {
        "#4455ff",
        0.26666666666666666, 0.3333333333333333, 1.0,  /* rgb */
        0.23680278924225545, 0.14945115113457574, 0.962477436302133,  /* xyz */
        45.55893211969558, -12.620707105740887, -128.91063053418102,  /* luv */
        45.55893211969558, 129.52695824641688, 264.4084044122752,  /* lch */
        264.4084044122752, 99.99999999999928, 45.55893211969558,  /* hsluv */
        264.4084044122752, 360.76629600395404, 45.55893211969558,  /* hpluv */
    },
    {
        "#446600",
        0.26666666666666666, 0.4, 0.0,  /* rgb */
        0.07135005854627191, 0.10731495118553606, 0.016954636621088367,  /* xyz */
        39.12450889353716, -16.806485623906017, 45.44054293117367,  /* luv */
        39.12450889353716, 48.448951494396624, 110.29724752770484,  /* lch */
        110.29724752770484, 100.0000000000023, 39.12450889353716,  /* hsluv */
        110.29724752770484, 157.13568029472475, 39.12450889353716,  /* hpluv */
    },
    {
        "#446611",
        0.26666666666666666, 0.4, 0.06666666666666667,  /* rgb */
        0.07236172404590903, 0.10771961738539092, 0.022282741585844,  /* xyz */
        39.19371032734533, -16.764880163284474, 42.843846683952,  /* luv */
        39.19371032734533, 46.007134289882416, 111.37050244306216,  /* lch */
        111.37050244306216, 93.861989786091, 39.19371032734533,  /* hsluv */
        111.37050244306216, 148.9526145018813, 39.19371032734533,  /* hpluv */
    },
    {
        "#446622",
        0.26666666666666666, 0.4, 0.13333333333333333,  /* rgb */
        0.07423708218438606, 0.10846976064078173, 0.03215962778182319,  /* xyz */
        39.32153430877322, -16.691751857993918, 38.187112435869395,  /* luv */
        39.32153430877322, 41.6757739733598, 113.61034642058726,  /* lch */
        113.61034642058726, 82.9003633409612, 39.32153430877322,  /* hsluv */
        113.61034642058726, 134.49079012246207, 39.32153430877322,  /* hpluv */
    },
    {
        "#446633",
        0.26666666666666666, 0.4, 0.2,  /* rgb */
        0.07732483291684379, 0.10970486093376484, 0.048421781639434336,  /* xyz */
        39.53071682346862, -16.581815111493814, 30.93184266800768,  /* luv */
        39.53071682346862, 35.09608928684427, 118.19468606127141,  /* lch */
        118.19468606127141, 65.945418212904, 39.53071682346862,  /* hsluv */
        118.19468606127141, 112.65834401420636, 39.53071682346862,  /* hpluv */
    },
    {
        "#446644",
        0.26666666666666666, 0.4, 0.26666666666666666,  /* rgb */
        0.08178282816106267, 0.11148805903145242, 0.07190055659232097,  /* xyz */
        39.829975949316676, -16.443497013349514, 21.263881514334972,  /* luv */
        39.829975949316676, 26.880127438010984, 127.71501294923806,  /* lch */
        127.71501294923806, 43.604412328256686, 39.829975949316676,  /* hsluv */
        127.71501294923806, 85.6368345314009, 39.829975949316676,  /* hpluv */
    },
    {
        "#446655",
        0.26666666666666666, 0.4, 0.3333333333333333,  /* rgb */
        0.08774524220042466, 0.11387302464719726, 0.10330260386629489,  /* xyz */
        40.22527755640668, -16.29051559926522, 9.608814046334315,  /* luv */
        40.22527755640668, 18.913228330111576, 149.46615321029324,  /* lch */
        149.46615321029324, 47.24520224911043, 40.22527755640668,  /* hsluv */
        149.46615321029324, 59.66311756138425, 40.22527755640668,  /* hpluv */
    },
    {
        "#446666",
        0.26666666666666666, 0.4, 0.4,  /* rgb */
        0.09533023797393284, 0.11690702295660058, 0.14325024827343885,  /* xyz */
        40.72025696026557, -16.138995029719425, -3.4826082947077013,  /* luv */
        40.72025696026557, 16.510473073285187, 192.17705063006085,  /* lch */
        192.17705063006085, 51.24895828218242, 40.72025696026557,  /* hsluv */
        192.17705063006085, 51.450350046325966, 40.72025696026557,  /* hpluv */
    },
    {
        "#446677",
        0.26666666666666666, 0.4, 0.4666666666666667,  /* rgb */
        0.10464425099413475, 0.12063262816468139, 0.19230405017983676,  /* xyz */
        41.31648986483636, -16.004594232257723, -17.446282351996317,  /* luv */
        41.31648986483636, 23.675299458397465, 227.46784435344162,  /* lch */
        227.46784435344162, 55.404942323449326, 41.31648986483636,  /* hsluv */
        227.46784435344162, 72.71288720341518, 41.31648986483636,  /* hpluv */
    },
    {
        "#446688",
        0.26666666666666666, 0.4, 0.5333333333333333,  /* rgb */
        0.11578466809607858, 0.12508879500545897, 0.2509769135834089,  /* xyz */
        42.013730376853665, -15.900396481246213, -31.787517500281176,  /* luv */
        42.013730376853665, 35.5424939627414, 243.4253782180881,  /* lch */
        243.4253782180881, 59.53136005220854, 42.013730376853665,  /* hsluv */
        243.4253782180881, 107.34850011685391, 42.013730376853665,  /* hpluv */
    },
    {
        "#446699",
        0.26666666666666666, 0.4, 0.6,  /* rgb */
        0.1288416322051513, 0.13031158064908815, 0.31974359122452684,  /* xyz */
        42.81015537462897, -15.835865252188624, -46.12387793335588,  /* luv */
        42.81015537462897, 48.76665606637991, 251.05094476794574,  /* lch */
        251.05094476794574, 63.49076525764232, 42.81015537462897,  /* hsluv */
        251.05094476794574, 144.54913577189367, 42.81015537462897,  /* hpluv */
    },
    {
        "#4466aa",
        0.26666666666666666, 0.4, 0.6666666666666666,  /* rgb */
        0.14389932517040382, 0.13633465783518925, 0.39904744084152544,  /* xyz */
        43.70262318889151, -15.816739085962512, -60.19299824917784,  /* luv */
        43.70262318889151, 62.23637419981133, 255.27738032783347,  /* lch */
        255.27738032783347, 67.19246484537689, 43.70262318889151,  /* hsluv */
        255.27738032783347, 180.7074694215707, 43.70262318889151,  /* hpluv */
    },
    {
        "#4466bb",
        0.26666666666666666, 0.4, 0.7333333333333333,  /* rgb */
        0.1610369172777405, 0.143189694678124, 0.4893054259401672,  /* xyz */
        44.68694053627064, -15.845524703712519, -73.83807029483539,  /* luv */
        44.68694053627064, 75.51914510904514, 257.8881202090847,  /* lch */
        257.8881202090847, 70.58664135618821, 44.68694053627064,  /* hsluv */
        257.8881202090847, 214.44492340630447, 44.68694053627064,  /* hpluv */
    },
    {
        "#4466cc",
        0.26666666666666666, 0.4, 0.8,  /* rgb */
        0.18032929272146223, 0.1509066448556128, 0.5909119366104373,  /* xyz */
        45.75812616456453, -15.92224467497789, -86.983727499712,  /* luv */
        45.75812616456453, 88.42899256032501, 259.6269295997438,  /* lch */
        259.6269295997438, 73.65492916467362, 45.75812616456453,  /* hsluv */
        259.6269295997438, 245.22558113148207, 45.75812616456453,  /* hpluv */
    },
    {
        "#4466dd",
        0.26666666666666666, 0.4, 0.8666666666666667,  /* rgb */
        0.20184761827209577, 0.15951397507586634, 0.7042417845104433,  /* xyz */
        46.91065909072692, -16.04519855273895, -99.61119330553174,  /* luv */
        46.91065909072692, 100.89518436649406, 260.84949508815873,  /* lch */
        260.84949508815873, 78.54190789436868, 46.91065909072692,  /* hsluv */
        260.84949508815873, 272.9218019281599, 46.91065909072692,  /* hpluv */
    },
    {
        "#4466ee",
        0.26666666666666666, 0.4, 0.9333333333333333,  /* rgb */
        0.2256597985382705, 0.16903884718233636, 0.8296526005789665,  /* xyz */
        48.13870149957819, -16.211612022850947, -111.73725331323539,  /* luv */
        48.13870149957819, 112.90717489320852, 261.7447361926657,  /* lch */
        261.7447361926657, 89.20258289890121, 48.13870149957819,  /* hsluv */
        261.7447361926657, 297.62300409884296, 48.13870149957819,  /* hpluv */
    },
    {
        "#4466ff",
        0.26666666666666666, 0.4, 1.0,  /* rgb */
        0.25183084694810187, 0.17950726654626908, 0.9674867888707483,  /* xyz */
        49.43628980364332, -16.418133421512533, -123.3984793602865,  /* luv */
        49.43628980364332, 124.48590206717242, 262.42132309689305,  /* lch */
        262.42132309689305, 99.9999999999992, 49.43628980364332,  /* hsluv */
        262.42132309689305, 319.53146291038354, 49.43628980364332,  /* hpluv */
    },
    {
        "#447700",
        0.26666666666666666, 0.4666666666666667, 0.0,  /* rgb */
        0.08980379659968954, 0.14422242729237184, 0.02310588263889407,  /* xyz */
        44.83248944102629, -25.1544589141716, 52.787071467721134,  /* luv */
        44.83248944102629, 58.47411151443898, 115.47905516313459,  /* lch */
        115.47905516313459, 100.00000000000216, 44.83248944102629,  /* hsluv */
        115.47905516313459, 165.50461307776385, 44.83248944102629,  /* hpluv */
    },
    {
        "#447711",
        0.26666666666666666, 0.4666666666666667, 0.06666666666666667,  /* rgb */
        0.09081546209932666, 0.1446270934922267, 0.0284339876036497,  /* xyz */
        44.88933188201425, -25.06716734040064, 50.552773531764416,  /* luv */
        44.88933188201425, 56.426463562990634, 116.3750363045054,  /* lch */
        116.3750363045054, 95.40732281696344, 44.88933188201425,  /* hsluv */
        116.3750363045054, 159.5067320571847, 44.88933188201425,  /* hpluv */
    },
    {
        "#447722",
        0.26666666666666666, 0.4666666666666667, 0.13333333333333333,  /* rgb */
        0.09269082023780369, 0.14537723674761752, 0.0383108737996289,  /* xyz */
        44.99442279300584, -24.91050231892215, 46.51312489711144,  /* luv */
        44.99442279300584, 52.76366091805338, 118.17165699597821,  /* lch */
        118.17165699597821, 87.12836946967309, 44.99442279300584,  /* hsluv */
        118.17165699597821, 148.8043278036075, 44.99442279300584,  /* hpluv */
    },
    {
        "#447733",
        0.26666666666666666, 0.4666666666666667, 0.2,  /* rgb */
        0.09577857097026142, 0.14661233704060062, 0.05457302765724004,  /* xyz */
        45.16666866900048, -24.66631686291858, 40.13518288097489,  /* luv */
        45.16666866900048, 47.1090234718488, 121.57408960159279,  /* lch */
        121.57408960159279, 74.12455354421412, 45.16666866900048,  /* hsluv */
        121.57408960159279, 132.35043363430358, 45.16666866900048,  /* hpluv */
    },
    {
        "#447744",
        0.26666666666666666, 0.4666666666666667, 0.26666666666666666,  /* rgb */
        0.1002365662144803, 0.1483955351382882, 0.07805180261012667,  /* xyz */
        45.41365344943674, -24.341413377085168, 31.477059260664877,  /* luv */
        45.41365344943674, 39.790823878044414, 127.71501294923908,  /* lch */
        127.71501294923908, 56.6116285441109, 45.41365344943674,  /* hsluv */
        127.71501294923908, 111.18234158710581, 45.41365344943674,  /* hpluv */
    },
    {
        "#447755",
        0.26666666666666666, 0.4666666666666667, 0.3333333333333333,  /* rgb */
        0.10619898025384229, 0.15078050075403304, 0.10945384988410059,  /* xyz */
        45.74091332623599, -23.952020354944747, 20.798638417872084,  /* luv */
        45.74091332623599, 31.72195831157137, 139.0307188065928,  /* lch */
        139.0307188065928, 58.79922526313101, 45.74091332623599,  /* hsluv */
        139.0307188065928, 88.00239353603148, 45.74091332623599,  /* hpluv */
    },
    {
        "#447766",
        0.26666666666666666, 0.4666666666666667, 0.4,  /* rgb */
        0.11378397602735046, 0.15381449906343633, 0.14940149429124455,  /* xyz */
        46.15228229947503, -23.52051083006626, 8.49488024846472,  /* luv */
        46.15228229947503, 25.007547263636635, 160.14184963516604,  /* lch */
        160.14184963516604, 61.28255192148887, 46.15228229947503,  /* hsluv */
        160.14184963516604, 68.7570511480334, 46.15228229947503,  /* hpluv */
    },
    {
        "#447777",
        0.26666666666666666, 0.4666666666666667, 0.4666666666666667,  /* rgb */
        0.12309798904755238, 0.15754010427151716, 0.19845529619764246,  /* xyz */
        46.65008993328267, -23.0716472128555, -4.9785943801395325,  /* luv */
        46.65008993328267, 23.602697030560297, 192.17705063006093,  /* lch */
        192.17705063006093, 63.95068211349504, 46.65008993328267,  /* hsluv */
        192.17705063006093, 64.2019875277067, 46.65008993328267,  /* hpluv */
    },
    {
        "#447788",
        0.26666666666666666, 0.4666666666666667, 0.5333333333333333,  /* rgb */
        0.13423840614949623, 0.16199627111229475, 0.2571281596012146,  /* xyz */
        47.23531144332841, -22.629174149698073, -19.172738243450357,  /* luv */
        47.23531144332841, 29.65928883923597, 220.2731899018536,  /* lch */
        220.2731899018536, 66.69581699091586, 47.23531144332841,  /* hsluv */
        220.2731899018536, 79.6770556088496, 47.23531144332841,  /* hpluv */
    },
    {
        "#447799",
        0.26666666666666666, 0.4666666666666667, 0.6,  /* rgb */
        0.14729537025856893, 0.1672190567559239, 0.32589483724233254,  /* xyz */
        47.90770851222445, -22.213383266858198, -33.6934576046404,  /* luv */
        47.90770851222445, 40.356950845127486, 236.60398079873676,  /* lch */
        236.60398079873676, 69.42466080102912, 47.90770851222445,  /* hsluv */
        236.60398079873676, 106.8937403525249, 47.90770851222445,  /* hpluv */
    },
    {
        "#4477aa",
        0.26666666666666666, 0.4666666666666667, 0.6666666666666666,  /* rgb */
        0.16235306322382148, 0.173242133942025, 0.40519868685933114,  /* xyz */
        48.6659751090485, -21.839858196429944, -48.22725138498465,  /* luv */
        48.6659751090485, 52.94192272850196, 245.6364597161942,  /* lch */
        245.6364597161942, 72.0643617009564, 48.6659751090485,  /* hsluv */
        245.6364597161942, 138.04275134774124, 48.6659751090485,  /* hpluv */
    },
    {
        "#4477bb",
        0.26666666666666666, 0.4666666666666667, 0.7333333333333333,  /* rgb */
        0.1794906553311581, 0.18009717078495976, 0.4954566719579729,  /* xyz */
        49.5078912458612, -21.51924868246256, -62.54705739917591,  /* luv */
        49.5078912458612, 66.145388752002, 251.01427572726897,  /* lch */
        251.01427572726897, 74.56371936500476, 49.5078912458612,  /* hsluv */
        251.01427572726897, 169.53699124532218, 49.5078912458612,  /* hpluv */
    },
    {
        "#4477cc",
        0.26666666666666666, 0.4666666666666667, 0.8,  /* rgb */
        0.19878303077487985, 0.18781412096244857, 0.5970631826282431,  /* xyz */
        50.43048194577976, -21.257742093143936, -76.50468333305658,  /* luv */
        50.43048194577976, 79.4031370336833, 254.4714107428486,  /* lch */
        254.4714107428486, 76.89118554388396, 50.43048194577976,  /* hsluv */
        254.4714107428486, 199.7946564172313, 50.43048194577976,  /* hpluv */
    },
    {
        "#4477dd",
        0.26666666666666666, 0.4666666666666667, 0.8666666666666667,  /* rgb */
        0.2203013563255134, 0.1964214511827021, 0.7103930305282491,  /* xyz */
        51.43017617147642, -21.057887317585514, -90.01643346520015,  /* luv */
        51.43017617147642, 92.44670308926617, 256.8333536406715,  /* lch */
        256.8333536406715, 79.03124207464279, 51.43017617147642,  /* hsluv */
        256.8333536406715, 228.0934121944044, 51.43017617147642,  /* hpluv */
    },
    {
        "#4477ee",
        0.26666666666666666, 0.4666666666666667, 0.9333333333333333,  /* rgb */
        0.24411353659168814, 0.20594632328917215, 0.8358038465967723,  /* xyz */
        52.50295987613559, -20.9195063280493, -103.04698598324808,  /* luv */
        52.50295987613559, 105.14897557865707, 258.5243699798756,  /* lch */
        258.5243699798756, 87.6254974090696, 52.50295987613559,  /* hsluv */
        258.5243699798756, 254.13272001073815, 52.50295987613559,  /* hpluv */
    },
    {
        "#4477ff",
        0.26666666666666666, 0.4666666666666667, 1.0,  /* rgb */
        0.27028458500151953, 0.21641474265310484, 0.973638034888554,  /* xyz */
        53.6445179522116, -20.84053252302583, -115.59457682066316,  /* luv */
        53.6445179522116, 117.45822230134208, 259.7799393644558,  /* lch */
        259.7799393644558, 99.999999999999, 53.6445179522116,  /* hsluv */
        259.7799393644558, 277.8416843084311, 53.6445179522116,  /* hpluv */
    },
    {
        "#448800",
        0.26666666666666666, 0.5333333333333333, 0.0,  /* rgb */
        0.11187616632465999, 0.18836716674231338, 0.030463339213884017,  /* xyz */
        50.495622761944816, -32.873947818662586, 60.00741862244787,  /* luv */
        50.495622761944816, 68.42212167796212, 118.71531142601455,  /* lch */
        118.71531142601455, 100.00000000000237, 50.495622761944816,  /* hsluv */
        118.71531142601455, 171.94206202889225, 50.495622761944816,  /* hpluv */
    },
    {
        "#448811",
        0.26666666666666666, 0.5333333333333333, 0.06666666666666667,  /* rgb */
        0.11288783182429711, 0.18877183294216823, 0.03579144417863965,  /* xyz */
        50.543205868460916, -32.76742656496171, 58.06839257940959,  /* luv */
        50.543205868460916, 66.67565118127148, 119.4356125752783,  /* lch */
        119.4356125752783, 96.47024910568243, 50.543205868460916,  /* hsluv */
        119.4356125752783, 167.3955109731753, 50.543205868460916,  /* hpluv */
    },
    {
        "#448822",
        0.26666666666666666, 0.5333333333333333, 0.13333333333333333,  /* rgb */
        0.11476318996277414, 0.18952197619755906, 0.04566833037461884,  /* xyz */
        50.63123270621276, -32.57459532619555, 54.54264635307504,  /* luv */
        50.63123270621276, 63.52955636443569, 120.84698607213436,  /* lch */
        120.84698607213436, 90.0662104861249, 50.63123270621276,  /* hsluv */
        120.84698607213436, 159.21964378208312, 50.63123270621276,  /* hpluv */
    },
    {
        "#448833",
        0.26666666666666666, 0.5333333333333333, 0.2,  /* rgb */
        0.11785094069523187, 0.19075707649054216, 0.06193048423222999,  /* xyz */
        50.77566296935076, -32.26964048387392, 48.92370765994872,  /* luv */
        50.77566296935076, 58.60766902167838, 123.40848727456681,  /* lch */
        123.40848727456681, 79.89903881988057, 50.77566296935076,  /* hsluv */
        123.40848727456681, 146.46645579674188, 50.77566296935076,  /* hpluv */
    },
    {
        "#448844",
        0.26666666666666666, 0.5333333333333333, 0.26666666666666666,  /* rgb */
        0.12230893593945075, 0.19254027458822975, 0.08540925918511663,  /* xyz */
        50.983091035863765, -31.85505695667696, 41.19331527893514,  /* luv */
        50.983091035863765, 52.0733509329185, 127.71501294923954,  /* lch */
        127.71501294923954, 65.99309875229812, 50.983091035863765,  /* hsluv */
        127.71501294923954, 129.6070690167938, 50.983091035863765,  /* hpluv */
    },
    {
        "#448855",
        0.26666666666666666, 0.5333333333333333, 0.3333333333333333,  /* rgb */
        0.12827134997881273, 0.1949252402039746, 0.11681130645909053,  /* xyz */
        51.25852650389554, -31.343703674462155, 31.49671510661366,  /* luv */
        51.25852650389554, 44.435017976137665, 134.86048960010476,  /* lch */
        134.86048960010476, 67.35177254645487, 51.25852650389554,  /* hsluv */
        134.86048960010476, 110.00149031373503, 51.25852650389554,  /* hpluv */
    },
    {
        "#448866",
        0.26666666666666666, 0.5333333333333333, 0.4,  /* rgb */
        0.13585634575232092, 0.19795923851337788, 0.1567589508662345,  /* xyz */
        51.605689649152254, -30.756276588427706, 20.10354453218249,  /* luv */
        51.605689649152254, 36.74372126420119, 146.8297479275588,  /* lch */
        146.8297479275588, 68.93087522485628, 51.605689649152254,  /* hsluv */
        146.8297479275588, 90.34931789613748, 51.605689649152254,  /* hpluv */
    },
    {
        "#448877",
        0.26666666666666666, 0.5333333333333333, 0.4666666666666667,  /* rgb */
        0.14517035877252282, 0.2016848437214587, 0.20581275277263242,  /* xyz */
        52.027170934286204, -30.118149901155657, 7.3606705233222725,  /* luv */
        52.027170934286204, 31.004554891521792, 166.26650318299164,  /* lch */
        166.26650318299164, 70.67269954029345, 52.027170934286204,  /* hsluv */
        166.26650318299164, 75.61964189372046, 52.027170934286204,  /* hpluv */
    },
    {
        "#448888",
        0.26666666666666666, 0.5333333333333333, 0.5333333333333333,  /* rgb */
        0.15631077587446668, 0.2061410105622363, 0.2644856161762046,  /* xyz */
        52.524539049345904, -29.456097564679137, -6.356284856620092,  /* luv */
        52.524539049345904, 30.13410096416341, 192.177050630061,  /* lch */
        192.177050630061, 72.51569672724798, 52.524539049345904,  /* hsluv */
        192.177050630061, 72.80065986760272, 52.524539049345904,  /* hpluv */
    },
    {
        "#448899",
        0.26666666666666666, 0.5333333333333333, 0.6,  /* rgb */
        0.16936773998353938, 0.21136379620586546, 0.33325229381732246,  /* xyz */
        53.09843152799621, -28.795466442382395, -20.68471984840661,  /* luv */
        53.09843152799621, 35.4547108695225, 215.69091611339385,  /* lch */
        215.69091611339385, 74.40114201227213, 53.09843152799621,  /* hsluv */
        215.69091611339385, 84.7289026839812, 53.09843152799621,  /* hpluv */
    },
    {
        "#4488aa",
        0.26666666666666666, 0.5333333333333333, 0.6666666666666666,  /* rgb */
        0.18442543294879193, 0.21738687339196655, 0.41255614343432107,  /* xyz */
        53.74864279712686, -28.15817657920432, -35.304803083271565,  /* luv */
        53.74864279712686, 45.158742553510415, 231.42506423612136,  /* lch */
        231.42506423612136, 76.2778611087785, 53.74864279712686,  /* hsluv */
        231.42506423612136, 106.6138593018484, 53.74864279712686,  /* hpluv */
    },
    {
        "#4488bb",
        0.26666666666666666, 0.5333333333333333, 0.7333333333333333,  /* rgb */
        0.20156302505612855, 0.2242419102349013, 0.5028141285329628,  /* xyz */
        54.47421559092585, -27.561651657574515, -49.95575134887872,  /* luv */
        54.47421559092585, 57.05455051899435, 241.11354325793724,  /* lch */
        241.11354325793724, 78.10478036232007, 54.47421559092585,  /* hsluv */
        241.11354325793724, 132.9041767229242, 54.47421559092585,  /* hpluv */
    },
    {
        "#4488cc",
        0.26666666666666666, 0.5333333333333333, 0.8,  /* rgb */
        0.2208554004998503, 0.2319588604123901, 0.604420639203233,  /* xyz */
        55.27353697861447, -27.018561846425698, -64.44035491957834,  /* luv */
        55.27353697861447, 69.87533203077002, 247.25266296501286,  /* lch */
        247.25266296501286, 79.85157745947086, 55.27353697861447,  /* hsluv */
        247.25266296501286, 160.41536171824998, 55.27353697861447,  /* hpluv */
    },
    {
        "#4488dd",
        0.26666666666666666, 0.5333333333333333, 0.8666666666666667,  /* rgb */
        0.24237372605048385, 0.24056619063264364, 0.717750487103239,  /* xyz */
        56.14443772076362, -26.53714651812043, -78.62111455512466,  /* luv */
        56.14443772076362, 82.97891177410213, 251.34881235313225,  /* lch */
        251.34881235313225, 81.4979766670821, 56.14443772076362,  /* hsluv */
        251.34881235313225, 187.54276934167575, 56.14443772076362,  /* hpluv */
    },
    {
        "#4488ee",
        0.26666666666666666, 0.5333333333333333, 0.9333333333333333,  /* rgb */
        0.2661859063166586, 0.2500910627391137, 0.8431613031717622,  /* xyz */
        57.08429241415456, -26.12186780354241, -92.41158344269198,  /* luv */
        57.08429241415456, 96.03256079024118, 254.21605977883954,  /* lch */
        254.21605977883954, 85.80501689001095, 57.08429241415456,  /* hsluv */
        254.21605977883954, 213.47214512672412, 57.08429241415456,  /* hpluv */
    },
    {
        "#4488ff",
        0.26666666666666666, 0.5333333333333333, 1.0,  /* rgb */
        0.29235695472649, 0.26055948210304636, 0.980995491463544,  /* xyz */
        58.09011746699623, -25.774189868522758, -105.76586657941287,  /* luv */
        58.09011746699623, 108.86104627768754, 256.3044738659354,  /* lch */
        256.3044738659354, 99.99999999999886, 58.09011746699623,  /* hsluv */
        256.3044738659354, 237.79875465041127, 58.09011746699623,  /* hpluv */
    },
    {
        "#449900",
        0.26666666666666666, 0.6, 0.0,  /* rgb */
        0.1377457667771275, 0.24010636764724907, 0.03908653936470627,  /* xyz */
        56.098442300003754, -40.08301698609072, 67.09878826105083,  /* luv */
        56.098442300003754, 78.159424491283, 120.85296261082777,  /* lch */
        120.85296261082777, 100.00000000000242, 56.098442300003754,  /* hsluv */
        120.85296261082777, 176.79495877762434, 56.098442300003754,  /* hpluv */
    },
    {
        "#449911",
        0.26666666666666666, 0.6, 0.06666666666666667,  /* rgb */
        0.13875743227676463, 0.24051103384710393, 0.0444146443294619,  /* xyz */
        56.138923563478414, -39.97061709088089, 65.40107381599383,  /* luv */
        56.138923563478414, 76.64822689998049, 121.43166679562589,  /* lch */
        121.43166679562589, 97.2234127009916, 56.138923563478414,  /* hsluv */
        121.43166679562589, 173.2516415881561, 56.138923563478414,  /* hpluv */
    },
    {
        "#449922",
        0.26666666666666666, 0.6, 0.13333333333333333,  /* rgb */
        0.14063279041524163, 0.24126117710249476, 0.0542915305254411,  /* xyz */
        56.21384509356389, -39.766035954678856, 62.30156212016118,  /* luv */
        56.21384509356389, 73.91090757230027, 122.54940325437212,  /* lch */
        122.54940325437212, 92.1627352690631, 56.21384509356389,  /* hsluv */
        122.54940325437212, 166.84168568249441, 56.21384509356389,  /* hpluv */
    },
    {
        "#449933",
        0.26666666666666666, 0.6, 0.2,  /* rgb */
        0.1437205411476994, 0.24249627739547785, 0.07055368438305223,  /* xyz */
        56.336864709554106, -39.43952351575552, 57.32843838974803,  /* luv */
        56.336864709554106, 69.58466686962701, 124.5263150479547,  /* lch */
        124.5263150479547, 84.06654417127189, 56.336864709554106,  /* hsluv */
        124.5263150479547, 156.73291295139785, 56.336864709554106,  /* hpluv */
    },
    {
        "#449944",
        0.26666666666666666, 0.6, 0.26666666666666666,  /* rgb */
        0.14817853639191825, 0.24427947549316545, 0.09403245933593887,  /* xyz */
        56.51374174269144, -38.98958864989586, 50.41932337573459,  /* luv */
        56.51374174269144, 63.736145104289015, 127.71501294923974,  /* lch */
        127.71501294923974, 72.8686777069245, 56.51374174269144,  /* hsluv */
        127.71501294923974, 143.110354253444, 56.51374174269144,  /* hpluv */
    },
    {
        "#449955",
        0.26666666666666666, 0.6, 0.3333333333333333,  /* rgb */
        0.15414095043128023, 0.24666444110891028, 0.1254345066099128,  /* xyz */
        56.74896819746466, -38.42457243649243, 41.64299208669279,  /* luv */
        56.74896819746466, 56.66203805776503, 132.6981609890746,  /* lch */
        132.6981609890746, 73.74053492329897, 56.74896819746466,  /* hsluv */
        132.6981609890746, 126.69910537289924, 56.74896819746466,  /* hpluv */
    },
    {
        "#449966",
        0.26666666666666666, 0.6, 0.4,  /* rgb */
        0.16172594620478842, 0.24969843941831357, 0.16538215101705675,  /* xyz */
        57.04602685004372, -37.76088179841547, 31.175579675702206,  /* luv */
        57.04602685004372, 48.96734587773735, 140.45674303667886,  /* lch */
        140.45674303667886, 74.77185377872728, 57.04602685004372,  /* hsluv */
        140.45674303667886, 108.9232245332856, 57.04602685004372,  /* hpluv */
    },
    {
        "#449977",
        0.26666666666666666, 0.6, 0.4666666666666667,  /* rgb */
        0.17103995922499032, 0.2534240446263944, 0.21443595292345466,  /* xyz */
        57.40752728410145, -37.0206846158697, 19.27106515268882,  /* luv */
        57.40752728410145, 41.73613592016957, 152.50083223176378,  /* lch */
        152.50083223176378, 75.93255022498448, 57.40752728410145,  /* hsluv */
        152.50083223176378, 92.25347278282659, 57.40752728410145,  /* hpluv */
    },
    {
        "#449988",
        0.26666666666666666, 0.6, 0.5333333333333333,  /* rgb */
        0.18218037632693418, 0.257880211467172, 0.2731088163270268,  /* xyz */
        57.835291723238086, -36.22928544896462, 6.228192009424373,  /* luv */
        57.835291723238086, 36.76073312447423, 170.24560337496592,  /* lch */
        170.24560337496592, 77.18789573554862, 57.835291723238086,  /* hsluv */
        170.24560337496592, 80.65486339944094, 57.835291723238086,  /* hpluv */
    },
    {
        "#449999",
        0.26666666666666666, 0.6, 0.6,  /* rgb */
        0.19523734043600688, 0.26310299711080115, 0.34187549396814476,  /* xyz */
        58.33042015482995, -35.41256849963125, -7.641622329433726,  /* luv */
        58.33042015482995, 36.22767449846561, 192.17705063006116,  /* lch */
        192.17705063006116, 78.50212031844498, 58.33042015482995,  /* hsluv */
        192.17705063006116, 78.81060815956153, 58.33042015482995,  /* hpluv */
    },
    {
        "#4499aa",
        0.26666666666666666, 0.6, 0.6666666666666666,  /* rgb */
        0.21029503340125943, 0.2691260742969023, 0.4211793435851433,  /* xyz */
        58.89334843280446, -34.59485797453465, -22.041166266239177,  /* luv */
        58.89334843280446, 41.01971731563034, 212.50213351308162,  /* lch */
        212.50213351308162, 79.84142762441357, 58.89334843280446,  /* hsluv */
        212.50213351308162, 88.38239021178995, 58.89334843280446,  /* hpluv */
    },
    {
        "#4499bb",
        0.26666666666666666, 0.6, 0.7333333333333333,  /* rgb */
        0.22743262550859605, 0.27598111113983703, 0.5114373286837851,  /* xyz */
        59.52390585194422, -33.797405154676206, -36.70656647388549,  /* luv */
        59.52390585194422, 49.89625855203081, 227.36281958486083,  /* lch */
        227.36281958486083, 81.17613130867109, 59.52390585194422,  /* hsluv */
        227.36281958486083, 106.36919851968392, 59.52390585194422,  /* hpluv */
    },
    {
        "#4499cc",
        0.26666666666666666, 0.6, 0.8,  /* rgb */
        0.2467250009523178, 0.28369806131732583, 0.6130438393540553,  /* xyz */
        60.22137492529764, -33.03754845801458, -51.4181219791773,  /* luv */
        60.22137492529764, 61.117124245020044, 237.2781469495979,  /* lch */
        237.2781469495979, 82.48184890798117, 60.22137492529764,  /* hsluv */
        237.2781469495979, 128.78093410062272, 60.22137492529764,  /* hpluv */
    },
    {
        "#4499dd",
        0.26666666666666666, 0.6, 0.8666666666666667,  /* rgb */
        0.26824332650295135, 0.29230539153757934, 0.7263736872540613,  /* xyz */
        60.98455396194555, -32.32846488779682, -66.00385274452577,  /* luv */
        60.98455396194555, 73.4958381074912, 243.90454278549134,  /* lch */
        243.90454278549134, 83.73986793699645, 60.98455396194555,  /* hsluv */
        243.90454278549134, 152.92631424071342, 60.98455396194555,  /* hpluv */
    },
    {
        "#4499ee",
        0.26666666666666666, 0.6, 0.9333333333333333,  /* rgb */
        0.29205550676912606, 0.30183026364404936, 0.8517845033225845,  /* xyz */
        61.811821810391265, -31.67936206409616, -80.33762114602142,  /* luv */
        61.811821810391265, 86.35806477793354, 248.47930093460587,  /* lch */
        248.47930093460587, 84.93689542066583, 61.811821810391265,  /* hsluv */
        248.47930093460587, 177.284466220706, 61.811821810391265,  /* hpluv */
    },
    {
        "#4499ff",
        0.26666666666666666, 0.6, 1.0,  /* rgb */
        0.3182265551789575, 0.3122986830079821, 0.9896186916143663,  /* xyz */
        62.70120347054676, -31.09594528706929, -94.33386192253582,  /* luv */
        62.70120347054676, 99.3269113509348, 251.75586024460134,  /* lch */
        251.75586024460134, 99.99999999999861, 62.70120347054676,  /* hsluv */
        251.75586024460134, 201.01588617081086, 62.70120347054676,  /* hpluv */
    },
    {
        "#44aa00",
        0.26666666666666666, 0.6666666666666666, 0.0,  /* rgb */
        0.16757938640669678, 0.2997736069063885, 0.049031079241229084,  /* xyz */
        61.63468353868697, -46.879450710712256, 74.0661245293922,  /* luv */
        61.63468353868697, 87.65542596862747, 122.33137692510135,  /* lch */
        122.33137692510135, 100.00000000000226, 61.63468353868697,  /* hsluv */
        122.33137692510135, 180.46498952442255, 61.63468353868697,  /* hpluv */
    },
    {
        "#44aa11",
        0.26666666666666666, 0.6666666666666666, 0.06666666666666667,  /* rgb */
        0.16859105190633392, 0.30017827310624334, 0.05435918420598471,  /* xyz */
        61.66960100746729, -46.767858157414025, 72.56707052484525,  /* luv */
        61.66960100746729, 86.33198874802932, 122.80087722620695,  /* lch */
        122.80087722620695, 97.77172732057578, 61.66960100746729,  /* hsluv */
        122.80087722620695, 177.63966003504805, 61.66960100746729,  /* hpluv */
    },
    {
        "#44aa22",
        0.26666666666666666, 0.6666666666666666, 0.13333333333333333,  /* rgb */
        0.17046641004481092, 0.30092841636163414, 0.06423607040196391,  /* xyz */
        61.734245772064554, -46.5639790081192, 69.8221097085679,  /* luv */
        61.734245772064554, 83.92455627064021, 123.69910278406556,  /* lch */
        123.69910278406556, 93.69685305787789, 61.734245772064554,  /* hsluv */
        123.69910278406556, 172.50521693840747, 61.734245772064554,  /* hpluv */
    },
    {
        "#44aa33",
        0.26666666666666666, 0.6666666666666666, 0.2,  /* rgb */
        0.17355416077726865, 0.30216351665461727, 0.08049822425957506,  /* xyz */
        61.84044881183698, -46.23650653801721, 65.3958697634278,  /* luv */
        61.84044881183698, 80.09016368415861, 125.2612609135905,  /* lch */
        125.2612609135905, 87.14108288180759, 61.84044881183698,  /* hsluv */
        125.2612609135905, 164.34098094123468, 61.84044881183698,  /* hpluv */
    },
    {
        "#44aa44",
        0.26666666666666666, 0.6666666666666666, 0.26666666666666666,  /* rgb */
        0.17801215602148754, 0.30394671475230484, 0.1039769992124617,  /* xyz */
        61.9932720073472, -45.78096684497185, 59.20158308252815,  /* luv */
        61.9932720073472, 74.83798744446496, 127.71501294923992,  /* lch */
        127.71501294923992, 77.99858056181913, 61.9932720073472,  /* hsluv */
        127.71501294923992, 153.18522095820916, 61.9932720073472,  /* hpluv */
    },
    {
        "#44aa55",
        0.26666666666666666, 0.6666666666666666, 0.3333333333333333,  /* rgb */
        0.18397457006084955, 0.3063316803680497, 0.13537904648643562,  /* xyz */
        62.19673624479279, -45.20166478889523, 51.25798647040431,  /* luv */
        62.19673624479279, 68.34158087641669, 131.4073395238885,  /* lch */
        131.4073395238885, 78.57541560698547, 62.19673624479279,  /* hsluv */
        131.4073395238885, 139.43016823200955, 62.19673624479279,  /* hpluv */
    },
    {
        "#44aa66",
        0.26666666666666666, 0.6666666666666666, 0.4,  /* rgb */
        0.1915595658343577, 0.309365678677453, 0.17532669089357955,  /* xyz */
        62.45404969722104, -44.510458035487396, 41.67398366296557,  /* luv */
        62.45404969722104, 60.9745995384144, 136.88501969128177,  /* lch */
        136.88501969128177, 79.26692466798949, 62.45404969722104,  /* hsluv */
        136.88501969128177, 123.88755407265441, 62.45404969722104,  /* hpluv */
    },
    {
        "#44aa77",
        0.26666666666666666, 0.6666666666666666, 0.4666666666666667,  /* rgb */
        0.20087357885455964, 0.3130912838855338, 0.22438049279997746,  /* xyz */
        62.76772733498882, -43.7251633677153, 30.629998072253084,  /* luv */
        62.76772733498882, 53.38620321243701, 144.9882994596703,  /* lch */
        144.9882994596703, 80.05733071476736, 62.76772733498882,  /* hsluv */
        144.9882994596703, 107.92746030201282, 62.76772733498882,  /* hpluv */
    },
    {
        "#44aa88",
        0.26666666666666666, 0.6666666666666666, 0.5333333333333333,  /* rgb */
        0.21201399595650344, 0.3175474507263114, 0.28305335620354966,  /* xyz */
        63.139663516894714, -42.867624951076635, 18.355896458551126,  /* luv */
        63.139663516894714, 46.63230858260416, 156.8194141301328,  /* lch */
        156.8194141301328, 80.92703067321185, 63.139663516894714,  /* hsluv */
        156.8194141301328, 93.7182088199909, 63.139663516894714,  /* hpluv */
    },
    {
        "#44aa99",
        0.26666666666666666, 0.6666666666666666, 0.6,  /* rgb */
        0.22507096006557617, 0.32277023636994057, 0.35182003384466753,  /* xyz */
        63.5711832083111, -41.961661323992985, 5.107715481429276,  /* luv */
        63.5711832083111, 42.27138250056083, 173.05990551152644,  /* lch */
        173.05990551152644, 81.85449249317813, 63.5711832083111,  /* hsluv */
        173.05990551152644, 84.37727267736706, 63.5711832083111,  /* hpluv */
    },
    {
        "#44aaaa",
        0.26666666666666666, 0.6666666666666666, 0.6666666666666666,  /* rgb */
        0.2401286530308287, 0.3287933135560417, 0.43112388346166614,  /* xyz */
        64.06308398978015, -41.03114670244819, -8.854046462259868,  /* luv */
        64.06308398978015, 41.975577881354795, 192.177050630061,  /* lch */
        192.177050630061, 82.81802640512139, 64.06308398978015,  /* hsluv */
        192.177050630061, 83.14347435566857, 64.06308398978015,  /* hpluv */
    },
    {
        "#44aabb",
        0.26666666666666666, 0.6666666666666666, 0.7333333333333333,  /* rgb */
        0.2572662451381654, 0.33564835039897645, 0.5213818685603079,  /* xyz */
        64.61567504102699, -40.09843344861964, -23.28230983394263,  /* luv */
        64.61567504102699, 46.36755672058945, 210.1406893288356,  /* lch */
        210.1406893288356, 83.7972417316187, 64.61567504102699,  /* hsluv */
        210.1406893288356, 91.05748535499961, 64.61567504102699,  /* hpluv */
    },
    {
        "#44aacc",
        0.26666666666666666, 0.6666666666666666, 0.8,  /* rgb */
        0.27655862058188707, 0.34336530057646525, 0.622988379230578,  /* xyz */
        65.22881621255581, -39.183230976268206, -37.956203827872514,  /* luv */
        65.22881621255581, 54.55271761115654, 224.0886950542707,  /* lch */
        224.0886950542707, 84.77408409339854, 65.22881621255581,  /* hsluv */
        224.0886950542707, 106.12463754531633, 65.22881621255581,  /* hpluv */
    },
    {
        "#44aadd",
        0.26666666666666666, 0.6666666666666666, 0.8666666666666667,  /* rgb */
        0.29807694613252067, 0.35197263079671876, 0.736318227130584,  /* xyz */
        65.90195855044158, -38.30196057973454, -52.68855810219244,  /* luv */
        65.90195855044158, 65.13926879494156, 233.98471308743802,  /* lch */
        233.98471308743802, 85.73343547606522, 65.90195855044158,  /* hsluv */
        233.98471308743802, 125.42493483364589, 65.90195855044158,  /* hpluv */
    },
    {
        "#44aaee",
        0.26666666666666666, 0.6666666666666666, 0.9333333333333333,  /* rgb */
        0.3218891263986954, 0.36149750290318877, 0.8617290431991073,  /* xyz */
        66.63418658734992, -37.46753169684491, -67.32870645567877,  /* luv */
        66.63418658734992, 77.0517400481588, 240.90464275334526,  /* lch */
        240.90464275334526, 86.66332736183257, 66.63418658734992,  /* hsluv */
        240.90464275334526, 146.73194579095005, 66.63418658734992,  /* hpluv */
    },
    {
        "#44aaff",
        0.26666666666666666, 0.6666666666666666, 1.0,  /* rgb */
        0.3480601748085268, 0.3719659222671215, 0.9995632314908891,  /* xyz */
        67.42426207278807, -36.68944340715272, -81.76167312317045,  /* luv */
        67.42426207278807, 89.61632914501038, 245.83248751248385,  /* lch */
        245.83248751248385, 99.99999999999821, 67.42426207278807,  /* hsluv */
        245.83248751248385, 168.65929278604997, 67.42426207278807,  /* hpluv */
    },
    {
        "#44bb00",
        0.26666666666666666, 0.7333333333333333, 0.0,  /* rgb */
        0.20153388431529556, 0.36768260272358705, 0.0603492452107617,  /* xyz */
        67.10280500922691, -53.34021401795286, 80.91707825705335,  /* luv */
        67.10280500922691, 96.91621115757215, 123.39271098156095,  /* lch */
        123.39271098156095, 100.00000000000226, 67.10280500922691,  /* hsluv */
        123.39271098156095, 183.2715611221222, 67.10280500922691,  /* hpluv */
    },
    {
        "#44bb11",
        0.26666666666666666, 0.7333333333333333, 0.06666666666666667,  /* rgb */
        0.2025455498149327, 0.3680872689234419, 0.06567735017551733,  /* xyz */
        67.13328108327273, -53.23267648966546, 79.58304173196517,  /* luv */
        67.13328108327273, 95.74538306135231, 123.77835535520865,  /* lch */
        123.77835535520865, 98.18063840275833, 67.13328108327273,  /* hsluv */
        123.77835535520865, 180.9752953480724, 67.13328108327273,  /* hpluv */
    },
    {
        "#44bb22",
        0.26666666666666666, 0.7333333333333333, 0.13333333333333333,  /* rgb */
        0.2044209079534097, 0.3688374121788327, 0.07555423637149652,  /* xyz */
        67.18971657182524, -53.03566579282883, 77.13480481896464,  /* luv */
        67.18971657182524, 93.60854640762457, 124.51129075368458,  /* lch */
        124.51129075368458, 94.84525245106985, 67.18971657182524,  /* hsluv */
        124.51129075368458, 176.78768905385616, 67.18971657182524,  /* hpluv */
    },
    {
        "#44bb33",
        0.26666666666666666, 0.7333333333333333, 0.2,  /* rgb */
        0.20750865868586743, 0.37007251247181583, 0.09181639022910768,  /* xyz */
        67.28247032983609, -52.71775040097655, 73.17219874852465,  /* luv */
        67.28247032983609, 90.18498698249756, 125.77129696925269,  /* lch */
        125.77129696925269, 89.45657393049133, 67.28247032983609,  /* hsluv */
        125.77129696925269, 170.08720513292786, 67.28247032983609,  /* hpluv */
    },
    {
        "#44bb44",
        0.26666666666666666, 0.7333333333333333, 0.26666666666666666,  /* rgb */
        0.21196665393008632, 0.3718557105695034, 0.11529516518199431,  /* xyz */
        67.41602185755774, -52.27243577596468, 67.59601561050812,  /* luv */
        67.41602185755774, 85.44956915262013, 127.71501294924008,  /* lch */
        127.71501294924008, 81.89472221008843, 67.41602185755774,  /* hsluv */
        127.71501294924008, 160.8370437859544, 67.41602185755774,  /* hpluv */
    },
    {
        "#44bb55",
        0.26666666666666666, 0.7333333333333333, 0.3333333333333333,  /* rgb */
        0.21792906796944833, 0.37424067618524826, 0.14669721245596823,  /* xyz */
        67.59397666204478, -51.700865958318076, 60.392688605132776,  /* luv */
        67.59397666204478, 79.5000401119176, 130.56611221439414,  /* lch */
        130.56611221439414, 82.28716981488344, 67.59397666204478,  /* hsluv */
        130.56611221439414, 149.24461735840396, 67.59397666204478,  /* hpluv */
    },
    {
        "#44bb66",
        0.26666666666666666, 0.7333333333333333, 0.4,  /* rgb */
        0.2255140637429565, 0.3772746744946516, 0.1866448568631122,  /* xyz */
        67.81926989103563, -51.010940774731914, 51.62366954202218,  /* luv */
        67.81926989103563, 72.5749222232247, 134.65794817972832,  /* lch */
        134.65794817972832, 82.76248784432345, 67.81926989103563,  /* hsluv */
        134.65794817972832, 135.7915656045291, 67.81926989103563,  /* hpluv */
    },
    {
        "#44bb77",
        0.26666666666666666, 0.7333333333333333, 0.4666666666666667,  /* rgb */
        0.23482807676315842, 0.38100027970273237, 0.2356986587695101,  /* xyz */
        68.09427305941895, -50.216227505403516, 41.41335255686182,  /* luv */
        68.09427305941895, 65.09020874811647, 140.48757762754914,  /* lch */
        140.48757762754914, 83.31237350807072, 68.09427305941895,  /* hsluv */
        140.48757762754914, 121.29542008700037, 68.09427305941895,  /* hpluv */
    },
    {
        "#44bb88",
        0.26666666666666666, 0.7333333333333333, 0.5333333333333333,  /* rgb */
        0.24596849386510222, 0.38545644654350997, 0.29437152217308227,  /* xyz */
        68.42085773293805, -49.33459272362959, 29.934390709291023,  /* luv */
        68.42085773293805, 57.705890395547094, 148.75218580301689,  /* lch */
        148.75218580301689, 83.92570376522828, 68.42085773293805,  /* hsluv */
        148.75218580301689, 107.0214815409687, 68.42085773293805,  /* hpluv */
    },
    {
        "#44bb99",
        0.26666666666666666, 0.7333333333333333, 0.6,  /* rgb */
        0.259025457974175, 0.3906792321871391, 0.36313819981420015,  /* xyz */
        68.80043845095523, -48.386653059406854, 17.391275422762078,  /* luv */
        68.80043845095523, 51.41716304038735, 160.2303963341413,  /* lch */
        160.2303963341413, 84.58953300526497, 68.80043845095523,  /* hsluv */
        160.2303963341413, 94.8322885243955, 68.80043845095523,  /* hpluv */
    },
    {
        "#44bbaa",
        0.26666666666666666, 0.7333333333333333, 0.6666666666666666,  /* rgb */
        0.2740831509394275, 0.39670230937324025, 0.44244204943119875,  /* xyz */
        69.23400561143946, -47.39420715535316, 4.003791165451279,  /* luv */
        69.23400561143946, 47.5630236168925, 175.1712042369108,  /* lch */
        175.1712042369108, 85.29010105457643, 69.23400561143946,  /* hsluv */
        175.1712042369108, 87.17447144150391, 69.23400561143946,  /* hpluv */
    },
    {
        "#44bbbb",
        0.26666666666666666, 0.7333333333333333, 0.7333333333333333,  /* rgb */
        0.29122074304676415, 0.403557346216175, 0.5327000345298405,  /* xyz */
        69.722153945093, -46.37881067844179, -10.008010441170022,  /* luv */
        69.722153945093, 47.446331290599424, 192.1770506300611,  /* lch */
        192.1770506300611, 86.0137488036252, 69.722153945093,  /* hsluv */
        192.1770506300611, 86.35175490546212, 69.722153945093,  /* hpluv */
    },
    {
        "#44bbcc",
        0.26666666666666666, 0.7333333333333333, 0.8,  /* rgb */
        0.3105131184904859, 0.4112742963936638, 0.6343065452001106,  /* xyz */
        70.265109629848, -45.36061622414234, -24.4360711219862,  /* luv */
        70.265109629848, 51.523849585533625, 208.3116472602016,  /* lch */
        208.3116472602016, 86.74766398016955, 70.265109629848,  /* hsluv */
        208.3116472602016, 93.04818411002775, 70.265109629848,  /* hpluv */
    },
    {
        "#44bbdd",
        0.26666666666666666, 0.7333333333333333, 0.8666666666666667,  /* rgb */
        0.3320314440411194, 0.4198816266139173, 0.7476363931001166,  /* xyz */
        70.86275765114347, -44.357542252504274, -39.09316512580265,  /* luv */
        70.86275765114347, 59.1258582536945, 221.39035497045302,  /* lch */
        221.39035497045302, 87.48041629856804, 70.86275765114347,  /* hsluv */
        221.39035497045302, 105.8762950004835, 70.86275765114347,  /* hpluv */
    },
    {
        "#44bbee",
        0.26666666666666666, 0.7333333333333333, 0.9333333333333333,  /* rgb */
        0.35584362430729416, 0.42940649872038733, 0.8730472091686399,  /* xyz */
        71.51467013790922, -43.38477846521225, -53.81824515765113,  /* luv */
        71.51467013790922, 69.12772608964208, 231.12649235522883,  /* lch */
        231.12649235522883, 88.20227738530699, 71.51467013790922,  /* hsluv */
        231.12649235522883, 122.65816352572412, 71.51467013790922,  /* hpluv */
    },
    {
        "#44bbff",
        0.26666666666666666, 0.7333333333333333, 1.0,  /* rgb */
        0.3820146727171255, 0.43987491808432005, 1.0108813974604218,  /* xyz */
        72.2201358507708, -42.45459147475308, -68.47867238456256,  /* luv */
        72.2201358507708, 80.57121637930277, 238.20240799555256,  /* lch */
        238.20240799555256, 99.99999999999767, 72.2201358507708,  /* hsluv */
        238.20240799555256, 141.56664692348363, 72.2201358507708,  /* hpluv */
    },
    {
        "#44cc00",
        0.26666666666666666, 0.8, 0.0,  /* rgb */
        0.23975762762491248, 0.44413008934282194, 0.07309049298063365,  /* xyz */
        72.50369205595238, -59.524974592652654, 87.65988833962834,  /* luv */
        72.50369205595238, 105.95979720616708, 124.17825396533586,  /* lch */
        124.17825396533586, 100.00000000000236, 72.50369205595238,  /* hsluv */
        124.17825396533586, 185.44721796992195, 72.50369205595238,  /* hpluv */
    },
    {
        "#44cc11",
        0.26666666666666666, 0.8, 0.06666666666666667,  /* rgb */
        0.24076929312454962, 0.4445347555426768, 0.07841859794538929,  /* xyz */
        72.53056374792718, -59.42294348015299, 86.46420768025109,  /* luv */
        72.53056374792718, 104.91494374787153, 124.49898281772543,  /* lch */
        124.49898281772543, 98.49213833023816, 72.53056374792718,  /* hsluv */
        124.49898281772543, 183.55052269402043, 72.53056374792718,  /* hpluv */
    },
    {
        "#44cc22",
        0.26666666666666666, 0.8, 0.13333333333333333,  /* rgb */
        0.24264465126302662, 0.4452848987980676, 0.08829548414136848,  /* xyz */
        72.5803335982668, -59.23563495000813, 84.26614402526731,  /* luv */
        72.5803335982668, 103.00312362650813, 125.10564185661819,  /* lch */
        125.10564185661819, 95.72256584302484, 72.5803335982668,  /* hsluv */
        125.10564185661819, 180.08218921711116, 72.5803335982668,  /* hpluv */
    },
    {
        "#44cc33",
        0.26666666666666666, 0.8, 0.2,  /* rgb */
        0.24573240199548435, 0.4465199990910507, 0.10455763799897963,  /* xyz */
        72.66215731605803, -58.932316156450476, 80.6982027200153,  /* luv */
        72.66215731605803, 99.92606171467241, 126.13992354282041,  /* lch */
        126.13992354282041, 91.23360713220158, 72.66215731605803,  /* hsluv */
        126.13992354282041, 174.50577750414755, 72.66215731605803,  /* hpluv */
    },
    {
        "#44cc44",
        0.26666666666666666, 0.8, 0.26666666666666666,  /* rgb */
        0.25019039723970327, 0.4483031971887383, 0.12803641295186627,  /* xyz */
        72.78002601436363, -58.50522275860604, 75.6559339961998,  /* luv */
        72.78002601436363, 95.63828437854505, 127.71501294924015,  /* lch */
        127.71501294924015, 84.90411293637403, 72.78002601436363,  /* hsluv */
        127.71501294924015, 166.74733317885293, 72.78002601436363,  /* hpluv */
    },
    {
        "#44cc55",
        0.26666666666666666, 0.8, 0.3333333333333333,  /* rgb */
        0.25615281127906525, 0.45068816280448315, 0.15943846022584018,  /* xyz */
        72.93718374221157, -57.9531752136704, 69.10522624560845,  /* luv */
        72.93718374221157, 90.18926106695359, 129.9839429710967,  /* lch */
        129.9839429710967, 85.17792722692936, 72.93718374221157,  /* hsluv */
        129.9839429710967, 156.90802823925497, 72.93718374221157,  /* hpluv */
    },
    {
        "#44cc66",
        0.26666666666666666, 0.8, 0.4,  /* rgb */
        0.26373780705257344, 0.45372216111388647, 0.19938610463298412,  /* xyz */
        73.13631035074172, -57.28090462038152, 61.074368962666,  /* luv */
        73.13631035074172, 83.73279272971317, 133.1642126439812,  /* lch */
        133.1642126439812, 85.51222416771488, 73.13631035074172,  /* hsluv */
        133.1642126439812, 145.27867025824168, 73.13631035074172,  /* hpluv */
    },
    {
        "#44cc77",
        0.26666666666666666, 0.8, 0.4666666666666667,  /* rgb */
        0.27305182007277534, 0.45744776632196726, 0.24843990653938203,  /* xyz */
        73.37961775368123, -56.49830016045176, 51.6459387330839,  /* luv */
        73.37961775368123, 76.5464624175537, 137.5691010737738,  /* lch */
        137.5691010737738, 85.90265340821252, 73.37961775368123,  /* hsluv */
        137.5691010737738, 132.36982845972832, 73.37961775368123,  /* hpluv */
    },
    {
        "#44cc88",
        0.26666666666666666, 0.8, 0.5333333333333333,  /* rgb */
        0.28419223717471914, 0.46190393316274486, 0.3071127699429542,  /* xyz */
        73.66890698997194, -55.61945340862041, 40.94694590100953,  /* luv */
        73.66890698997194, 69.06646057308784, 143.63956352519642,  /* lch */
        143.63956352519642, 86.34286829651359, 73.66890698997194,  /* hsluv */
        143.63956352519642, 118.96584688739648, 73.66890698997194,  /* hpluv */
    },
    {
        "#44cc99",
        0.26666666666666666, 0.8, 0.6,  /* rgb */
        0.29724920128379184, 0.467126718806374, 0.3758794475840721,  /* xyz */
        74.0056056952011, -54.66152604694033, 29.137368933892265,  /* luv */
        74.0056056952011, 61.942462803557355, 151.94011865570516,  /* lch */
        151.94011865570516, 86.8250568088678, 74.0056056952011,  /* hsluv */
        151.94011865570516, 106.2094543815975, 74.0056056952011,  /* hpluv */
    },
    {
        "#44ccaa",
        0.26666666666666666, 0.8, 0.6666666666666666,  /* rgb */
        0.3123068942490444, 0.47314979599247514, 0.4551832972010707,  /* xyz */
        74.39079545632993, -53.64353297980012, 16.397921463110613,  /* luv */
        74.39079545632993, 56.09385402042943, 163.00249320288032,  /* lch */
        163.00249320288032, 87.34051064597777, 74.39079545632993,  /* hsluv */
        163.00249320288032, 95.68313666926416, 74.39079545632993,  /* hpluv */
    },
    {
        "#44ccbb",
        0.26666666666666666, 0.8, 0.7333333333333333,  /* rgb */
        0.32944448635638107, 0.4800048328354099, 0.5454412822997124,  /* xyz */
        74.82523409488233, -52.58515280125889, 2.9181251133057993,  /* luv */
        74.82523409488233, 52.666058797945496, 176.82372431896061,  /* lch */
        176.82372431896061, 87.88018095580372, 74.82523409488233,  /* hsluv */
        176.82372431896061, 89.31451864143935, 74.82523409488233,  /* hpluv */
    },
    {
        "#44cccc",
        0.26666666666666666, 0.8, 0.8,  /* rgb */
        0.34873686180010277, 0.4877217830128987, 0.6470477929699826,  /* xyz */
        75.30937571414674, -51.50566713606288, -11.11432671378849,  /* luv */
        75.30937571414674, 52.691194761855044, 192.1770506300611,  /* lch */
        192.1770506300611, 88.43517376082082, 75.30937571414674,  /* hsluv */
        192.1770506300611, 88.78269527643818, 75.30937571414674,  /* hpluv */
    },
    {
        "#44ccdd",
        0.26666666666666666, 0.8, 0.8666666666666667,  /* rgb */
        0.37025518735073637, 0.4963291132331522, 0.7603776408699886,  /* xyz */
        75.84339012342237, -50.423101427505074, -25.52220698605481,  /* luv */
        75.84339012342237, 56.5143539908888, 206.84675369880318,  /* lch */
        206.84675369880318, 88.99715150770653, 75.84339012342237,  /* hsluv */
        206.84675369880318, 94.55409817247713, 75.84339012342237,  /* hpluv */
    },
    {
        "#44ccee",
        0.26666666666666666, 0.8, 0.9333333333333333,  /* rgb */
        0.3940673676169111, 0.5058539853396222, 0.8857884569385118,  /* xyz */
        76.42718251861811, -49.3536035237008, -40.14504142097059,  /* luv */
        76.42718251861811, 63.619199393470026, 219.12547938567903,  /* lch */
        219.12547938567903, 89.5586239337052, 76.42718251861811,  /* hsluv */
        219.12547938567903, 108.24809221111921, 76.42718251861811,  /* hpluv */
    },
    {
        "#44ccff",
        0.26666666666666666, 0.8, 1.0,  /* rgb */
        0.4202384160267425, 0.516322404703555, 1.0236226452302937,  /* xyz */
        77.06041383161048, -48.311062192829034, -54.84302486477434,  /* luv */
        77.06041383161048, 73.08704472420301, 228.6232677289035,  /* lch */
        228.6232677289035, 99.99999999999697, 77.06041383161048,  /* hsluv */
        228.6232677289035, 128.52645691877916, 77.06041383161048,  /* hpluv */
    },
    {
        "#44dd00",
        0.26666666666666666, 0.8666666666666667, 0.0,  /* rgb */
        0.2823916181720877, 0.5293980704371735, 0.08730182316302497,  /* xyz */
        77.83944716756912, -65.47998122632649, 94.3025116894186,  /* luv */
        77.83944716756912, 114.80675786874656, 124.77460364771503,  /* lch */
        124.77460364771503, 100.00000000000217, 77.83944716756912,  /* hsluv */
        124.77460364771503, 210.46586177171233, 77.83944716756912,  /* hpluv */
    },
    {
        "#44dd11",
        0.26666666666666666, 0.8666666666666667, 0.06666666666666667,  /* rgb */
        0.2834032836717248, 0.5298027366370284, 0.0926299281277806,  /* xyz */
        77.86335103320937, -65.38396458430725, 93.22389462023767,  /* luv */
        77.86335103320937, 113.8672795535536, 125.04447057905567,  /* lch */
        125.04447057905567, 98.73391975268473, 77.86335103320937,  /* hsluv */
        125.04447057905567, 209.01403929437078, 77.86335103320937,  /* hpluv */
    },
    {
        "#44dd22",
        0.26666666666666666, 0.8666666666666667, 0.13333333333333333,  /* rgb */
        0.28527864181020185, 0.5305528798924192, 0.1025068143237598,  /* xyz */
        77.90763025232577, -65.20741780244269, 91.23840333060065,  /* luv */
        77.90763025232577, 112.14478846018517, 125.55311423623571,  /* lch */
        125.55311423623571, 96.40501091600804, 77.90763025232577,  /* hsluv */
        125.55311423623571, 206.3471708228947, 77.90763025232577,  /* hpluv */
    },
    {
        "#44dd33",
        0.26666666666666666, 0.8666666666666667, 0.2,  /* rgb */
        0.28836639254265956, 0.5317879801854023, 0.11876896818137095,  /* xyz */
        77.98044451808488, -64.92075418483095, 88.00826321308779,  /* luv */
        77.98044451808488, 109.36251056788788, 126.41495586461761,  /* lch */
        126.41495586461761, 92.62082416540687, 77.98044451808488,  /* hsluv */
        126.41495586461761, 202.0256853119702, 77.98044451808488,  /* hpluv */
    },
    {
        "#44dd44",
        0.26666666666666666, 0.8666666666666667, 0.26666666666666666,  /* rgb */
        0.29282438778687847, 0.5335711782830899, 0.1422477431342576,  /* xyz */
        78.08537278988923, -64.51548060817514, 83.42808919409208,  /* luv */
        78.08537278988923, 105.4632320037709, 127.71501294924012,  /* lch */
        127.71501294924012, 87.26509122179904, 78.08537278988923,  /* hsluv */
        127.71501294924012, 195.94042509834082, 78.08537278988923,  /* hpluv */
    },
    {
        "#44dd55",
        0.26666666666666666, 0.8666666666666667, 0.3333333333333333,  /* rgb */
        0.29878680182624046, 0.5359561438988346, 0.17364979040823147,  /* xyz */
        78.22534591682829, -63.988774962702166, 77.45100000797143,  /* luv */
        78.22534591682829, 100.46502238820301, 129.5629717920018,  /* lch */
        129.5629717920018, 87.4605090914447, 78.22534591682829,  /* hsluv */
        129.5629717920018, 188.09087820476705, 78.22534591682829,  /* hpluv */
    },
    {
        "#44dd66",
        0.26666666666666666, 0.8666666666666667, 0.4,  /* rgb */
        0.30637179759974864, 0.5389901422082379, 0.21359743481537546,  /* xyz */
        78.40281179577576, -63.34293739318318, 70.0822592109557,  /* luv */
        78.40281179577576, 94.4661355921174, 132.10844105644188,  /* lch */
        132.10844105644188, 87.70060534613737, 78.40281179577576,  /* hsluv */
        132.10844105644188, 178.59774401526758, 78.40281179577576,  /* hpluv */
    },
    {
        "#44dd77",
        0.26666666666666666, 0.8666666666666667, 0.4666666666666667,  /* rgb */
        0.31568581061995055, 0.5427157474163188, 0.2626512367217734,  /* xyz */
        78.61982278240693, -62.58485415081966, 61.37356607784704,  /* luv */
        78.61982278240693, 87.65602422076434, 135.55986100319083,  /* lch */
        135.55986100319083, 87.98314397677022, 78.61982278240693,  /* hsluv */
        135.55986100319083, 167.73117312681623, 78.61982278240693,  /* hpluv */
    },
    {
        "#44dd88",
        0.26666666666666666, 0.8666666666666667, 0.5333333333333333,  /* rgb */
        0.32682622772189435, 0.5471719142570963, 0.3213241001253455,  /* xyz */
        78.87808746920102, -61.72532881384218, 51.41632421611319,  /* luv */
        78.87808746920102, 80.33464142618304, 140.2061813807648,  /* lch */
        140.2061813807648, 88.30449356067177, 78.87808746920102,  /* hsluv */
        140.2061813807648, 155.9619213771488, 78.87808746920102,  /* hpluv */
    },
    {
        "#44dd99",
        0.26666666666666666, 0.8666666666666667, 0.6,  /* rgb */
        0.33988319183096705, 0.5523946999007255, 0.39009077776646345,  /* xyz */
        79.1790042342924, -60.778266562872865, 40.33363282100912,  /* luv */
        79.1790042342924, 72.94381140938286, 146.43097895219424,  /* lch */
        146.43097895219424, 88.65991526317731, 79.1790042342924,  /* hsluv */
        146.43097895219424, 144.04742354952523, 79.1790042342924,  /* hpluv */
    },
    {
        "#44ddaa",
        0.26666666666666666, 0.8666666666666667, 0.6666666666666666,  /* rgb */
        0.3549408847962196, 0.5584177770868266, 0.46939462738346205,  /* xyz */
        79.5236849812282, -59.75975658522205, 28.271373123608306,  /* luv */
        79.5236849812282, 66.10975000269833, 154.68192701277403,  /* lch */
        154.68192701277403, 89.04388561805273, 79.5236849812282,  /* hsluv */
        154.68192701277403, 133.15854000611057, 79.5236849812282,  /* hpluv */
    },
    {
        "#44ddbb",
        0.26666666666666666, 0.8666666666666667, 0.7333333333333333,  /* rgb */
        0.3720784769035563, 0.5652728139297614, 0.5596526124821037,  /* xyz */
        79.91297358343547, -58.68712367835916, 15.38903713768997,  /* luv */
        79.91297358343547, 60.671253074781845, 165.30661480955396,  /* lch */
        165.30661480955396, 89.45042959820596, 79.91297358343547,  /* hsluv */
        165.30661480955396, 125.00533866723372, 79.91297358343547,  /* hpluv */
    },
    {
        "#44ddcc",
        0.26666666666666666, 0.8666666666666667, 0.8,  /* rgb */
        0.391370852347278, 0.5729897641072502, 0.6612591231523739,  /* xyz */
        80.34746161637368, -57.57802417376716, 1.8509976013049105,  /* luv */
        80.34746161637368, 57.60776909302209, 178.15871003021618,  /* lch */
        178.15871003021618, 89.87343791839524, 80.34746161637368,  /* hsluv */
        178.15871003021618, 121.78659206895044, 80.34746161637368,  /* hpluv */
    },
    {
        "#44dddd",
        0.26666666666666666, 0.8666666666666667, 0.8666666666666667,  /* rgb */
        0.4128891778979116, 0.5815970943275037, 0.7745889710523799,  /* xyz */
        80.82750290512718, -56.44965016620695, -12.181181017787516,  /* luv */
        80.82750290512718, 57.7489755309586, 192.17705063006113,  /* lch */
        192.17705063006113, 90.30694632257952, 80.82750290512718,  /* hsluv */
        192.17705063006113, 125.67472173627247, 80.82750290512718,  /* hpluv */
    },
    {
        "#44ddee",
        0.26666666666666666, 0.8666666666666667, 0.9333333333333333,  /* rgb */
        0.4367013581640863, 0.5911219664339737, 0.8999997871209031,  /* xyz */
        81.35322778949931, -55.318086024327876, -26.554977164046807,  /* luv */
        81.35322778949931, 61.36169369873999, 205.64293845945596,  /* lch */
        205.64293845945596, 90.74536155638178, 81.35322778949931,  /* hsluv */
        205.64293845945596, 137.93963476634826, 81.35322778949931,  /* hpluv */
    },
    {
        "#44ddff",
        0.26666666666666666, 0.8666666666666667, 1.0,  /* rgb */
        0.4628724065739177, 0.6015903857979065, 1.037833975412685,  /* xyz */
        81.92455761290381, -54.19783821781258, -41.1314953029609,  /* luv */
        81.92455761290381, 68.03826550803365, 217.19536970924855,  /* lch */
        217.19536970924855, 99.99999999999574, 81.92455761290381,  /* hsluv */
        217.19536970924855, 158.576151866946, 81.92455761290381,  /* hpluv */
    },
    {
        "#44ee00",
        0.26666666666666666, 0.9333333333333333, 0.0,  /* rgb */
        0.3295703945126025, 0.6237556231182044, 0.10302808194319615,  /* xyz */
        83.11273954151333, -71.24131758972972, 100.85229750786719,  /* luv */
        83.11273954151333, 123.47676398633101, 125.23710114083579,  /* lch */
        125.23710114083579, 100.0000000000024, 83.11273954151333,  /* hsluv */
        125.23710114083579, 311.24079842712575, 83.11273954151333,  /* hpluv */
    },
    {
        "#44ee11",
        0.26666666666666666, 0.9333333333333333, 0.06666666666666667,  /* rgb */
        0.3305820600122396, 0.6241602893180593, 0.10835618690795179,  /* xyz */
        83.13416828910891, -71.15133202960057, 99.87358736906467,  /* luv */
        83.13416828910891, 122.62644699881285, 125.46660001292226,  /* lch */
        125.46660001292226, 98.92471804094423, 83.13416828910891,  /* hsluv */
        125.46660001292226, 309.5476753631476, 83.13416828910891,  /* hpluv */
    },
    {
        "#44ee22",
        0.26666666666666666, 0.9333333333333333, 0.13333333333333333,  /* rgb */
        0.33245741815071667, 0.6249104325734501, 0.11823307310393098,  /* xyz */
        83.17386698896202, -70.98566891531462, 98.0701120789979,  /* luv */
        83.17386698896202, 121.06490851828977, 125.89798623448384,  /* lch */
        125.89798623448384, 96.9444732717922, 83.17386698896202,  /* hsluv */
        125.89798623448384, 306.43230917617956, 83.17386698896202,  /* hpluv */
    },
    {
        "#44ee33",
        0.26666666666666666, 0.9333333333333333, 0.2,  /* rgb */
        0.33554516888317437, 0.6261455328664333, 0.13449522696154212,  /* xyz */
        83.23916117956645, -70.71610726154367, 95.13085638050269,  /* luv */
        83.23916117956645, 118.53542787670689, 126.62549443347844,  /* lch */
        126.62549443347844, 93.72044517171337, 83.23916117956645,  /* hsluv */
        126.62549443347844, 301.3690677517937, 83.23916117956645,  /* hpluv */
    },
    {
        "#44ee44",
        0.26666666666666666, 0.9333333333333333, 0.26666666666666666,  /* rgb */
        0.3400031641273933, 0.6279287309641208, 0.15797400191442876,  /* xyz */
        83.33327953200927, -70.33379975140699, 90.9520391649414,  /* luv */
        83.33327953200927, 114.97441809260029, 127.71501294924028,  /* lch */
        127.71501294924028, 89.14395641470743, 83.33327953200927,  /* hsluv */
        127.71501294924028, 294.2057650911511, 83.33327953200927,  /* hpluv */
    },
    {
        "#44ee55",
        0.26666666666666666, 0.9333333333333333, 0.3333333333333333,  /* rgb */
        0.34596557816675527, 0.6303136965798656, 0.18937604918840267,  /* xyz */
        83.45888144648592, -69.83479979139801, 85.47915533048521,  /* luv */
        83.45888144648592, 110.37927911486767, 129.24815113793196,  /* lch */
        129.24815113793196, 89.28628760884804, 83.45888144648592,  /* hsluv */
        129.24815113793196, 284.9013825387622, 83.45888144648592,  /* hpluv */
    },
    {
        "#44ee66",
        0.26666666666666666, 0.9333333333333333, 0.4,  /* rgb */
        0.35355057394026346, 0.6333476948892689, 0.22932369359554663,  /* xyz */
        83.6182069813856, -69.2195888954281, 78.7015837099029,  /* luv */
        83.6182069813856, 104.81073783395921, 131.3322627231483,  /* lch */
        131.3322627231483, 89.46204677902683, 83.6182069813856,  /* hsluv */
        131.3322627231483, 273.53562680177663, 83.6182069813856,  /* hpluv */
    },
    {
        "#44ee77",
        0.26666666666666666, 0.9333333333333333, 0.4666666666666667,  /* rgb */
        0.36286458696046536, 0.6370733000973497, 0.27837749550194457,  /* xyz */
        83.81315664064186, -68.49267832748349, 70.64835594498521,  /* luv */
        83.81315664064186, 98.39937592384138, 134.11240167504172,  /* lch */
        134.11240167504172, 89.67013812620357, 83.81315664064186,  /* hsluv */
        134.11240167504172, 260.33339995100505, 83.81315664064186,  /* hpluv */
    },
    {
        "#44ee88",
        0.26666666666666666, 0.9333333333333333, 0.5333333333333333,  /* rgb */
        0.37400500406240916, 0.6415294669381273, 0.3370503589055167,  /* xyz */
        84.04533873507957, -67.66213492001874, 61.383440655321195,  /* luv */
        84.04533873507957, 91.35694439187509, 137.78552140015003,  /* lch */
        137.78552140015003, 89.90848997345523, 84.04533873507957,  /* hsluv */
        137.78552140015003, 245.7093114885916, 84.04533873507957,  /* hpluv */
    },
    {
        "#44ee99",
        0.26666666666666666, 0.9333333333333333, 0.6,  /* rgb */
        0.38706196817148186, 0.6467522525817565, 0.4058170365466346,  /* xyz */
        84.31609989063884, -66.738995210465, 51.00010553212929,  /* luv */
        84.31609989063884, 83.99466796166763, 142.61393179031896,  /* lch */
        142.61393179031896, 90.17421474064727, 84.31609989063884,  /* hsluv */
        142.61393179031896, 230.34304814929857, 84.31609989063884,  /* hpluv */
    },
    {
        "#44eeaa",
        0.26666666666666666, 0.9333333333333333, 0.6666666666666666,  /* rgb */
        0.4021196611367344, 0.6527753297678576, 0.48512088616363325,  /* xyz */
        84.62654623733224, -65.73658370090882, 39.61445317224156,  /* luv */
        84.62654623733224, 76.75026603733899, 148.92581778642307,  /* lch */
        148.92581778642307, 90.46379417946649, 84.62654623733224,  /* hsluv */
        148.92581778642307, 215.2983168257943, 84.62654623733224,  /* hpluv */
    },
    {
        "#44eebb",
        0.26666666666666666, 0.9333333333333333, 0.7333333333333333,  /* rgb */
        0.4192572532440711, 0.6596303666107923, 0.5753788712622749,  /* xyz */
        84.9775593290447, -64.66977682675906, 27.358488982373107,  /* luv */
        84.9775593290447, 70.21870800734982, 157.06925312765316,  /* lch */
        157.06925312765316, 90.77327889928614, 84.9775593290447,  /* hsluv */
        157.06925312765316, 202.1836936968223, 84.9775593290447,  /* hpluv */
    },
    {
        "#44eecc",
        0.26666666666666666, 0.9333333333333333, 0.8,  /* rgb */
        0.4385496286877928, 0.6673473167882812, 0.6769853819325451,  /* xyz */
        85.36980913296338, -63.55426416976089, 14.373183266524109,  /* luv */
        85.36980913296338, 65.15928860394995, 167.25658536415816,  /* lch */
        167.25658536415816, 91.0984884260964, 85.36980913296338,  /* hsluv */
        167.25658536415816, 193.29006776543105, 85.36980913296338,  /* hpluv */
    },
    {
        "#44eedd",
        0.26666666666666666, 0.9333333333333333, 0.8666666666666667,  /* rgb */
        0.4600679542384264, 0.6759546470085347, 0.7903152298325511,  /* xyz */
        85.80376550083805, -62.40585700402726, 0.8019824351190614,  /* luv */
        85.80376550083805, 62.41100996004902, 179.26372809106527,  /* lch */
        179.26372809106527, 91.43519837088819, 85.80376550083805,  /* hsluv */
        179.26372809106527, 191.49984254960356, 85.80376550083805,  /* hpluv */
    },
    {
        "#44eeee",
        0.26666666666666666, 0.9333333333333333, 0.9333333333333333,  /* rgb */
        0.4838801345046011, 0.6854795191150047, 0.9157260459010743,  /* xyz */
        86.27970899097465, -61.23988497094359, -13.214858234606409,  /* luv */
        86.27970899097465, 62.64946918701824, 192.17705063006116,  /* lch */
        192.17705063006116, 91.77930375806618, 86.27970899097465,  /* hsluv */
        192.17705063006116, 199.70016668431632, 86.27970899097465,  /* hpluv */
    },
    {
        "#44eeff",
        0.26666666666666666, 0.9333333333333333, 1.0,  /* rgb */
        0.5100511829144325, 0.6959479384789374, 1.0535602341928563,  /* xyz */
        86.79774156961228, -60.070708048363116, -27.54487195476271,  /* luv */
        86.79774156961228, 66.08486919436211, 204.63338851466852,  /* lch */
        204.63338851466852, 99.99999999999369, 86.79774156961228,  /* hsluv */
        204.63338851466852, 219.87055647797467, 86.79774156961228,  /* hpluv */
    },
    {
        "#44ff00",
        0.26666666666666666, 1.0, 0.0,  /* rgb */
        0.38142276694227634, 0.7274603679775535, 0.12031220608642026,  /* xyz */
        88.3264513606833, -76.83740841849695, 107.31589974563431,  /* luv */
        88.3264513606833, 131.9874602781868, 125.60238970276382,  /* lch */
        125.60238970276382, 100.00000000000233, 88.3264513606833,  /* hsluv */
        125.60238970276382, 502.9906513781552, 88.3264513606833,  /* hpluv */
    },
    {
        "#44ff11",
        0.26666666666666666, 1.0, 0.06666666666666667,  /* rgb */
        0.38243443244191344, 0.7278650341774084, 0.1256403110511759,  /* xyz */
        88.34579242024185, -76.75322232036656, 106.42314390807707,  /* luv */
        88.34579242024185, 131.21334800941136, 125.79944403840186,  /* lch */
        125.79944403840186, 99.99999999999176, 88.34579242024185,  /* hsluv */
        125.79944403840186, 500.95031091153135, 88.34579242024185,  /* hpluv */
    },
    {
        "#44ff22",
        0.26666666666666666, 1.0, 0.13333333333333333,  /* rgb */
        0.3843097905803905, 0.7286151774327992, 0.13551719724715508,  /* xyz */
        88.38162663587995, -76.59808240618061, 104.77667218056271,  /* luv */
        88.38162663587995, 129.789896608084, 126.16906142889749,  /* lch */
        126.16906142889749, 99.99999999999154, 88.38162663587995,  /* hsluv */
        126.16906142889749, 497.1909290741439, 88.38162663587995,  /* hpluv */
    },
    {
        "#44ff33",
        0.26666666666666666, 1.0, 0.2,  /* rgb */
        0.3873975413128482, 0.7298502777257824, 0.15177935110476623,  /* xyz */
        88.44057361895922, -76.34521686755281, 102.089450454884,  /* luv */
        88.44057361895922, 127.478814054469, 126.79012109890259,  /* lch */
        126.79012109890259, 99.9999999999916, 88.44057361895922,  /* hsluv */
        126.79012109890259, 491.0664297253084, 88.44057361895922,  /* hpluv */
    },
    {
        "#44ff44",
        0.26666666666666666, 1.0, 0.26666666666666666,  /* rgb */
        0.3918555365570671, 0.7316334758234699, 0.17525812605765287,  /* xyz */
        88.52556217466271, -75.9856771103925, 98.2607552122302,  /* luv */
        88.52556217466271, 124.21352237499205, 127.71501294924025,  /* lch */
        127.71501294924025, 99.99999999999159, 88.52556217466271,  /* hsluv */
        127.71501294924025, 482.3694373823855, 88.52556217466271,  /* hpluv */
    },
    {
        "#44ff55",
        0.26666666666666666, 1.0, 0.3333333333333333,  /* rgb */
        0.3978179505964291, 0.7340184414392147, 0.20666017333162678,  /* xyz */
        88.6390158335401, -75.51477351055598, 93.23186842538777,  /* luv */
        88.6390158335401, 119.977757557138, 129.0063444720888,  /* lch */
        129.0063444720888, 99.99999999999167, 88.6390158335401,  /* hsluv */
        129.0063444720888, 471.0123022428135, 88.6390158335401,  /* hpluv */
    },
    {
        "#44ff66",
        0.26666666666666666, 1.0, 0.4,  /* rgb */
        0.4054029463699373, 0.737052439748618, 0.24660781773877075,  /* xyz */
        88.78298959201003, -74.93165046751575, 86.98131008018424,  /* luv */
        88.78298959201003, 114.80636108269923, 130.74385959991292,  /* lch */
        130.74385959991292, 99.99999999999137, 88.78298959201003,  /* hsluv */
        130.74385959991292, 457.0352825090388, 88.78298959201003,  /* hpluv */
    },
    {
        "#44ff77",
        0.26666666666666666, 1.0, 0.4666666666666667,  /* rgb */
        0.4147169593901392, 0.7407780449566989, 0.2956616196451687,  /* xyz */
        88.95924305587175, -74.23897565634682, 79.52153113766762,  /* luv */
        88.95924305587175, 108.78924313084771, 133.03233519919377,  /* lch */
        133.03233519919377, 99.99999999999137, 88.95924305587175,  /* hsluv */
        133.03233519919377, 440.6314558551574, 88.95924305587175,  /* hpluv */
    },
    {
        "#44ff88",
        0.26666666666666666, 1.0, 0.5333333333333333,  /* rgb */
        0.425857376492083, 0.7452342117974764, 0.3543344830487408,  /* xyz */
        89.16928400388053, -73.44259630518825, 70.89550486436579,  /* luv */
        89.16928400388053, 102.07834031771952, 136.0109766071641,  /* lch */
        136.0109766071641, 99.99999999999122, 89.16928400388053,  /* hsluv */
        136.0109766071641, 422.1930512248951, 89.16928400388053,  /* hpluv */
    },
    {
        "#44ff99",
        0.26666666666666666, 1.0, 0.6,  /* rgb */
        0.43891434060115575, 0.7504569974411056, 0.4231011606898587,  /* xyz */
        89.41439640621911, -72.55111632772153, 61.172704031476414,  /* luv */
        89.41439640621911, 94.89870493806114, 139.8635197336403,  /* lch */
        139.8635197336403, 99.9999999999912, 89.41439640621911,  /* hsluv */
        139.8635197336403, 402.3908266141122, 89.41439640621911,  /* hpluv */
    },
    {
        "#44ffaa",
        0.26666666666666666, 1.0, 0.6666666666666666,  /* rgb */
        0.45397203356640825, 0.7564800746272067, 0.5024050103068574,  /* xyz */
        89.69565968409167, -71.57539271458542, 50.44440420085868,  /* luv */
        89.69565968409167, 87.56525999177262, 144.82485232612342,  /* lch */
        144.82485232612342, 99.99999999999093, 89.69565968409167,  /* hsluv */
        144.82485232612342, 382.30428232539737, 89.69565968409167,  /* hpluv */
    },
    {
        "#44ffbb",
        0.26666666666666666, 1.0, 0.7333333333333333,  /* rgb */
        0.4711096256737449, 0.7633351114701414, 0.592662995405499,  /* xyz */
        90.01396286201536, -70.52797291540799, 38.818485844085956,  /* luv */
        90.01396286201536, 80.50509180656852, 151.17168246098842,  /* lch */
        151.17168246098842, 99.99999999999083, 90.01396286201536,  /* hsluv */
        151.17168246098842, 363.6211162501946, 90.01396286201536,  /* hpluv */
    },
    {
        "#44ffcc",
        0.26666666666666666, 1.0, 0.8,  /* rgb */
        0.4904020011174667, 0.7710520616476303, 0.6942695060757692,  /* xyz */
        90.37001573087134, -69.42250648550605, 26.414022977148502,  /* luv */
        90.37001573087134, 74.27775586652749, 159.16907454257608,  /* lch */
        159.16907454257608, 99.99999999999059, 90.37001573087134,  /* hsluv */
        159.16907454257608, 348.9008047438379, 90.37001573087134,  /* hpluv */
    },
    {
        "#44ffdd",
        0.26666666666666666, 1.0, 0.8666666666666667,  /* rgb */
        0.5119203266681002, 0.7796593918678838, 0.8075993539757752,  /* xyz */
        90.7643583149998, -68.27316748275139, 13.355980629979458,  /* luv */
        90.7643583149998, 69.56728840997188, 168.9312628351567,  /* lch */
        168.9312628351567, 99.99999999999028, 90.7643583149998,  /* hsluv */
        168.9312628351567, 341.8105096769695, 90.7643583149998,  /* hpluv */
    },
    {
        "#44ffee",
        0.26666666666666666, 1.0, 0.9333333333333333,  /* rgb */
        0.5357325069342749, 0.7891842639743538, 0.9330101700442984,  /* xyz */
        91.19736945737549, -67.094121132442, -0.22968024968898199,  /* luv */
        91.19736945737549, 67.09451425826032, 180.19613726684497,  /* lch */
        180.19613726684497, 99.99999999998983, 91.19736945737549,  /* hsluv */
        180.19613726684497, 347.0794883308162, 91.19736945737549,  /* hpluv */
    },
    {
        "#44ffff",
        0.26666666666666666, 1.0, 1.0,  /* rgb */
        0.5619035553441063, 0.7996526833382865, 1.0708443583360803,  /* xyz */
        91.66927503973987, -65.89906115155873, -14.220254517536919,  /* luv */
        91.66927503973987, 67.4158875874256, 192.1770506300611,  /* lch */
        192.1770506300611, 99.9999999999897, 91.66927503973987,  /* hsluv */
        192.1770506300611, 369.88615739088135, 91.66927503973987,  /* hpluv */
    },
    {
        "#550000",
        0.3333333333333333, 0.0, 0.0,  /* rgb */
        0.03746228588161209, 0.01931649115770664, 0.0017560446507005295,  /* xyz */
        15.124381917342227, 49.71936139051173, 10.728862613026655,  /* luv */
        15.124381917342227, 50.863772864874164, 12.177050630061776,  /* lch */
        12.177050630061776, 100.0000000000022, 15.124381917342227,  /* hsluv */
        12.177050630061776, 426.7467891831252, 15.124381917342227,  /* hpluv */
    },
    {
        "#550011",
        0.3333333333333333, 0.0, 0.06666666666666667,  /* rgb */
        0.038473951381249205, 0.019721157357561494, 0.007084149615456161,  /* xyz */
        15.340225863358896, 46.86764167395349, 6.159847662081742,  /* luv */
        15.340225863358896, 47.27070508568871, 7.487508937066973,  /* lch */
        7.487508937066973, 99.99999999999669, 15.340225863358896,  /* hsluv */
        7.487508937066973, 391.02061345776855, 15.340225863358896,  /* hpluv */
    },
    {
        "#550022",
        0.3333333333333333, 0.0, 0.13333333333333333,  /* rgb */
        0.04034930951972623, 0.020471300612952312, 0.016961035811435356,  /* xyz */
        15.732659219986093, 42.414978966518674, -1.1764344876039017,  /* luv */
        15.732659219986093, 42.43129079858218, 358.4112345270549,  /* lch */
        358.4112345270549, 99.99999999999716, 15.732659219986093,  /* hsluv */
        358.4112345270549, 342.23422156362375, 15.732659219986093,  /* hpluv */
    },
    {
        "#550033",
        0.3333333333333333, 0.0, 0.2,  /* rgb */
        0.04343706025218397, 0.021706400905935428, 0.0332231896690465,  /* xyz */
        16.358416636328208, 36.76250960263651, -10.955147345963749,  /* luv */
        16.358416636328208, 38.360101220613565, 343.4060586719473,  /* lch */
        343.4060586719473, 99.99999999999775, 16.358416636328208,  /* hsluv */
        343.4060586719473, 297.56223074916323, 16.358416636328208,  /* hpluv */
    },
    {
        "#550044",
        0.3333333333333333, 0.0, 0.26666666666666666,  /* rgb */
        0.04789505549640285, 0.023489599003623005, 0.05670196462193314,  /* xyz */
        17.221292386860206, 30.91120168719524, -21.862889663751623,  /* luv */
        17.221292386860206, 37.86143597641061, 324.7289759346472,  /* lch */
        324.7289759346472, 99.99999999999831, 17.221292386860206,  /* hsluv */
        324.7289759346472, 278.9784568427376, 17.221292386860206,  /* hpluv */
    },
    {
        "#550055",
        0.3333333333333333, 0.0, 0.3333333333333333,  /* rgb */
        0.05385746953576484, 0.025874564619367834, 0.08810401189590705,  /* xyz */
        18.3096014215038, 25.51317778751105, -32.992324509029864,  /* luv */
        18.3096014215038, 41.706303088697275, 307.71501294924354,  /* lch */
        307.71501294924354, 99.9999999999988, 18.3096014215038,  /* hsluv */
        307.71501294924354, 289.0427837304834, 18.3096014215038,  /* hpluv */
    },
    {
        "#550066",
        0.3333333333333333, 0.0, 0.4,  /* rgb */
        0.06144246530927301, 0.02890856292877115, 0.12805165630305101,  /* xyz */
        19.60137925506411, 20.818580180871372, -43.93161137339901,  /* luv */
        19.60137925506411, 48.61481007481908, 295.3556230118651,  /* lch */
        295.3556230118651, 99.99999999999925, 19.60137925506411,  /* hsluv */
        295.3556230118651, 314.71778665522424, 19.60137925506411,  /* hpluv */
    },
    {
        "#550077",
        0.3333333333333333, 0.0, 0.4666666666666667,  /* rgb */
        0.07075647832947493, 0.032634168136851965, 0.17710545820944892,  /* xyz */
        21.069395574911745, 16.83119884103942, -54.57634634934806,  /* luv */
        21.069395574911745, 57.11275545156794, 287.1396222236831,  /* lch */
        287.1396222236831, 99.99999999999957, 21.069395574911745,  /* hsluv */
        287.1396222236831, 343.9698389417931, 21.069395574911745,  /* hpluv */
    },
    {
        "#550088",
        0.3333333333333333, 0.0, 0.5333333333333333,  /* rgb */
        0.08189689543141876, 0.037090334977629556, 0.2357783216130211,  /* xyz */
        22.685205460118993, 13.454662288017035, -64.95050333020791,  /* luv */
        22.685205460118993, 66.32944911675308, 281.7034339048354,  /* lch */
        281.7034339048354, 99.99999999999987, 22.685205460118993,  /* hsluv */
        281.7034339048354, 371.02485144937094, 22.685205460118993,  /* hpluv */
    },
    {
        "#550099",
        0.3333333333333333, 0.0, 0.6,  /* rgb */
        0.09495385954049147, 0.04231312062125872, 0.30454499925413897,  /* xyz */
        24.42186443622664, 10.57276822522522, -75.10982714037733,  /* luv */
        24.42186443622664, 75.85031022350334, 278.01254475278904,  /* lch */
        278.01254475278904, 100.00000000000007, 24.42186443622664,  /* hsluv */
        278.01254475278904, 394.11037848183616, 24.42186443622664,  /* hpluv */
    },
    {
        "#5500aa",
        0.3333333333333333, 0.0, 0.6666666666666666,  /* rgb */
        0.11001155250574401, 0.048336197807359815, 0.38384884887113757,  /* xyz */
        26.25539355537908, 8.0814629277942, -85.10477687716036,  /* luv */
        26.25539355537908, 85.4876195151354, 275.4244833198721,  /* lch */
        275.4244833198721, 100.00000000000027, 26.25539355537908,  /* hsluv */
        275.4244833198721, 413.1654693966054, 26.25539355537908,  /* hpluv */
    },
    {
        "#5500bb",
        0.3333333333333333, 0.0, 0.7333333333333333,  /* rgb */
        0.12714914461308066, 0.055191234650294574, 0.4741068339697793,  /* xyz */
        28.1653177219846, 5.896942953600298, -94.97174797489427,  /* luv */
        28.1653177219846, 95.15464702054678, 273.55302233180134,  /* lch */
        273.55302233180134, 100.00000000000036, 28.1653177219846,  /* hsluv */
        273.55302233180134, 428.70117552805044, 28.1653177219846,  /* hpluv */
    },
    {
        "#5500cc",
        0.3333333333333333, 0.0, 0.8,  /* rgb */
        0.1464415200568024, 0.06290818482778338, 0.5757133446400495,  /* xyz */
        30.134629859371145, 3.9545585056015806, -104.73439553232446,  /* luv */
        30.134629859371145, 104.80902699908826, 272.1623453079593,  /* lch */
        272.1623453079593, 100.00000000000044, 30.134629859371145,  /* hsluv */
        272.1623453079593, 441.33884517145486, 30.134629859371145,  /* hpluv */
    },
    {
        "#5500dd",
        0.3333333333333333, 0.0, 0.8666666666666667,  /* rgb */
        0.16795984560743593, 0.07151551504803691, 0.6890431925400555,  /* xyz */
        32.14945910910832, 2.2051726126544846, -114.40725098641853,  /* luv */
        32.14945910910832, 114.42850110230827, 271.10422582070726,  /* lch */
        271.10422582070726, 100.00000000000048, 32.14945910910832,  /* hsluv */
        271.10422582070726, 451.6477645739501, 32.14945910910832,  /* hpluv */
    },
    {
        "#5500ee",
        0.3333333333333333, 0.0, 0.9333333333333333,  /* rgb */
        0.1917720258736107, 0.08104038715450694, 0.8144540086085788,  /* xyz */
        34.19862540057058, 0.6114671787043776, -123.99899453875402,  /* luv */
        34.19862540057058, 124.00050217129196, 270.28253619964516,  /* lch */
        270.28253619964516, 100.0000000000006, 34.19862540057058,  /* hsluv */
        270.28253619964516, 460.1019992147216, 34.19862540057058,  /* hpluv */
    },
    {
        "#5500ff",
        0.3333333333333333, 0.0, 1.0,  /* rgb */
        0.21794307428344206, 0.09150880651843965, 0.9522881969003606,  /* xyz */
        36.273183861195506, -0.855085145745556, -133.514807647929,  /* luv */
        36.273183861195506, 133.51754578282944, 269.6330586770423,  /* lch */
        269.6330586770423, 100.00000000000067, 36.273183861195506,  /* hsluv */
        269.6330586770423, 467.08077286548234, 36.273183861195506,  /* hpluv */
    },
    {
        "#551100",
        0.3333333333333333, 0.06666666666666667, 0.0,  /* rgb */
        0.039466686142540494, 0.023325291679563515, 0.0024241780710099804,  /* xyz */
        17.14365123509834, 44.61842765254415, 13.588999619361617,  /* luv */
        17.14365123509834, 46.64188028843098, 16.938651764802458,  /* lch */
        16.938651764802458, 100.00000000000225, 17.14365123509834,  /* hsluv */
        16.938651764802458, 345.232802292268, 17.14365123509834,  /* hpluv */
    },
    {
        "#551111",
        0.3333333333333333, 0.06666666666666667, 0.06666666666666667,  /* rgb */
        0.04047835164217761, 0.023729957879418367, 0.007752283035765611,  /* xyz */
        17.334221098823974, 42.35759120849961, 9.140277831111986,  /* luv */
        17.334221098823974, 43.33255371907224, 12.177050630061817,  /* lch */
        12.177050630061817, 74.33254743896588, 17.334221098823974,  /* hsluv */
        12.177050630061817, 317.2117595138026, 17.334221098823974,  /* hpluv */
    },
    {
        "#551122",
        0.3333333333333333, 0.06666666666666667, 0.13333333333333333,  /* rgb */
        0.042353709780654634, 0.02448010113480919, 0.017629169231744807,  /* xyz */
        17.681833534927847, 38.73612687956296, 1.8638579825914492,  /* luv */
        17.681833534927847, 38.78094238422875, 2.754764187423315,  /* lch */
        2.754764187423315, 76.70579952871422, 17.681833534927847,  /* hsluv */
        2.754764187423315, 278.31100989488795, 17.681833534927847,  /* hpluv */
    },
    {
        "#551133",
        0.3333333333333333, 0.06666666666666667, 0.2,  /* rgb */
        0.045441460513112375, 0.0257152014277923, 0.033891323089355954,  /* xyz */
        18.239017928685122, 33.976110188218016, -8.056195829660117,  /* luv */
        18.239017928685122, 34.91816654361688, 346.6607435062823,  /* lch */
        346.6607435062823, 79.78349224398673, 18.239017928685122,  /* hsluv */
        346.6607435062823, 242.9345634355779, 18.239017928685122,  /* hpluv */
    },
    {
        "#551144",
        0.3333333333333333, 0.06666666666666667, 0.26666666666666666,  /* rgb */
        0.049899455757331256, 0.027498399525479875, 0.05737009804224259,  /* xyz */
        19.012823009118605, 28.857216149022577, -19.344009876232523,  /* luv */
        19.012823009118605, 34.74089293560531, 326.16465867681416,  /* lch */
        326.16465867681416, 83.02210272381977, 19.012823009118605,  /* hsluv */
        326.16465867681416, 231.86419975018313, 19.012823009118605,  /* hpluv */
    },
    {
        "#551155",
        0.3333333333333333, 0.06666666666666667, 0.3333333333333333,  /* rgb */
        0.05586186979669325, 0.029883365141224708, 0.0887721453162165,  /* xyz */
        19.99712557180257, 23.96855949336901, -30.994903865182433,  /* luv */
        19.99712557180257, 39.1813209297373, 307.71501294924377,  /* lch */
        307.71501294924377, 86.01787212070984, 19.99712557180257,  /* hsluv */
        307.71501294924377, 248.62845208342978, 19.99712557180257,  /* hpluv */
    },
    {
        "#551166",
        0.3333333333333333, 0.06666666666666667, 0.4,  /* rgb */
        0.06344686557020142, 0.03291736345062802, 0.12871978972336046,  /* xyz */
        21.17631478289624, 19.598904910965793, -42.471654967457226,  /* luv */
        21.17631478289624, 46.77561917691537, 294.7713621173193,  /* lch */
        294.7713621173193, 88.58107465734685, 21.17631478289624,  /* hsluv */
        294.7713621173193, 280.29057047770084, 21.17631478289624,  /* hpluv */
    },
    {
        "#551177",
        0.3333333333333333, 0.06666666666666667, 0.4666666666666667,  /* rgb */
        0.07276087859040334, 0.036642968658708835, 0.17777359162975837,  /* xyz */
        22.529041607596703, 15.814622386107668, -53.58773844058365,  /* luv */
        22.529041607596703, 55.872605026001644, 286.4421962362724,  /* lch */
        286.4421962362724, 90.67925091688652, 22.529041607596703,  /* hsluv */
        286.4421962362724, 314.6991210730825, 22.529041607596703,  /* hpluv */
    },
    {
        "#551188",
        0.3333333333333333, 0.06666666666666667, 0.5333333333333333,  /* rgb */
        0.08390129569234717, 0.04109913549948643, 0.23644645503333053,  /* xyz */
        24.031532678349308, 12.569447691200168, -64.33595485570376,  /* luv */
        24.031532678349308, 65.55231576730885, 281.05474383939486,  /* lch */
        281.05474383939486, 92.35864215819817, 24.031532678349308,  /* hsluv */
        281.05474383939486, 346.1353022259875, 24.031532678349308,  /* hpluv */
    },
    {
        "#551199",
        0.3333333333333333, 0.06666666666666667, 0.6,  /* rgb */
        0.09695825980141988, 0.04632192114311559, 0.30521313267444844,  /* xyz */
        25.660087412478475, 9.778860914643388, -74.77319315338104,  /* luv */
        25.660087412478475, 75.40992332008281, 277.4508728372973,  /* lch */
        277.4508728372973, 93.69095306779451, 25.660087412478475,  /* hsluv */
        277.4508728372973, 372.9148639774892, 25.660087412478475,  /* hpluv */
    },
    {
        "#5511aa",
        0.3333333333333333, 0.06666666666666667, 0.6666666666666666,  /* rgb */
        0.11201595276667242, 0.05234499832921669, 0.38451698229144704,  /* xyz */
        27.39267123945038, 7.356638345124844, -84.96509916527849,  /* luv */
        27.39267123945038, 85.28298894801101, 274.94856982383953,  /* lch */
        274.94856982383953, 94.74715277558022, 27.39267123945038,  /* hsluv */
        274.94856982383953, 395.0639067658648, 27.39267123945038,  /* hpluv */
    },
    {
        "#5511bb",
        0.3333333333333333, 0.06666666666666667, 0.7333333333333333,  /* rgb */
        0.12915354487400907, 0.05920003517215145, 0.4747749673900888,  /* xyz */
        29.209736674087758, 5.228401378934995, -94.96638380798471,  /* luv */
        29.209736674087758, 95.11020047578867, 273.15125416593287,  /* lch */
        273.15125416593287, 95.5878244802283, 29.209736674087758,  /* hsluv */
        273.15125416593287, 413.17951524917316, 29.209736674087758,  /* hpluv */
    },
    {
        "#5511cc",
        0.3333333333333333, 0.06666666666666667, 0.8,  /* rgb */
        0.1484459203177308, 0.06691698534964025, 0.576381478060359,  /* xyz */
        31.094491471652873, 3.334331007444757, -104.81724584215,  /* luv */
        31.094491471652873, 104.8702664686274, 271.8220159366556,  /* lch */
        271.8220159366556, 96.26138721321777, 31.094491471652873,  /* hsluv */
        271.8220159366556, 427.9649867781945, 31.094491471652873,  /* hpluv */
    },
    {
        "#5511dd",
        0.3333333333333333, 0.06666666666666667, 0.8666666666666667,  /* rgb */
        0.16996424586836434, 0.07552431556989378, 0.689711325960365,  /* xyz */
        33.03282571759505, 1.6277552355309375, -114.54546995902213,  /* luv */
        33.03282571759505, 114.55703503163845, 270.81415029326394,  /* lch */
        270.81415029326394, 96.80535228283868, 33.03282571759505,  /* hsluv */
        270.81415029326394, 440.06351686219347, 33.03282571759505,  /* hpluv */
    },
    {
        "#5511ee",
        0.3333333333333333, 0.06666666666666667, 0.9333333333333333,  /* rgb */
        0.1937764261345391, 0.08504918767636382, 0.8151221420288882,  /* xyz */
        35.01306045713189, 0.07264755717825204, -124.16970827321357,  /* luv */
        35.01306045713189, 124.16972952504378, 270.0335218468433,  /* lch */
        270.0335218468433, 97.24838770855067, 35.01306045713189,  /* hsluv */
        270.0335218468433, 450.0129254693102, 35.01306045713189,  /* hpluv */
    },
    {
        "#5511ff",
        0.3333333333333333, 0.06666666666666667, 1.0,  /* rgb */
        0.21994747454437047, 0.09551760704029652, 0.9529563303206701,  /* xyz */
        37.025625528868424, -1.358795346737704, -133.7023783178021,  /* luv */
        37.025625528868424, 133.70928274667767, 269.4177324336022,  /* lch */
        269.4177324336022, 99.99999999999953, 37.025625528868424,  /* hsluv */
        269.4177324336022, 458.2457873826079, 37.025625528868424,  /* hpluv */
    },
    {
        "#552200",
        0.3333333333333333, 0.13333333333333333, 0.0,  /* rgb */
        0.04318230987730843, 0.03075653914909949, 0.003662719315932591,  /* xyz */
        20.34436993371488, 36.29394167569133, 18.15164202079884,  /* luv */
        20.34436993371488, 40.57994961073404, 26.57095023962007,  /* lch */
        26.57095023962007, 100.00000000000236, 20.34436993371488,  /* hsluv */
        26.57095023962007, 253.10841584108, 20.34436993371488,  /* hpluv */
    },
    {
        "#552211",
        0.3333333333333333, 0.13333333333333333, 0.06666666666666667,  /* rgb */
        0.044193975376945555, 0.031161205348954342, 0.008990824280688222,  /* xyz */
        20.503071183213933, 34.754974265300454, 13.96625421669475,  /* luv */
        20.503071183213933, 37.456167623330614, 21.89268235197822,  /* lch */
        21.89268235197822, 79.998991439989, 20.503071183213933,  /* hsluv */
        21.89268235197822, 231.81618102916505, 20.503071183213933,  /* hpluv */
    },
    {
        "#552222",
        0.3333333333333333, 0.13333333333333333, 0.13333333333333333,  /* rgb */
        0.04606933351542257, 0.03191134860434516, 0.018867710476667417,  /* xyz */
        20.793664333218118, 32.209891549934966, 6.950521719405951,  /* luv */
        20.793664333218118, 32.951280185002005, 12.177050630061949,  /* lch */
        12.177050630061949, 47.120547431092405, 20.793664333218118,  /* hsluv */
        12.177050630061949, 201.08542320769223, 20.793664333218118,  /* hpluv */
    },
    {
        "#552233",
        0.3333333333333333, 0.13333333333333333, 0.2,  /* rgb */
        0.04915708424788031, 0.033146448897328276, 0.03512986433427856,  /* xyz */
        21.26235723478937, 28.70964786266091, -2.9290836465012253,  /* luv */
        21.26235723478937, 28.85868000110523, 354.1745907436,  /* lch */
        354.1745907436, 52.832536686949624, 21.26235723478937,  /* hsluv */
        354.1745907436, 172.22824591775802, 21.26235723478937,  /* hpluv */
    },
    {
        "#552244",
        0.3333333333333333, 0.13333333333333333, 0.26666666666666666,  /* rgb */
        0.05361507949209919, 0.03492964699501585, 0.0586086392871652,  /* xyz */
        21.91892833116797, 24.742449174855764, -14.545901173228334,  /* luv */
        21.91892833116797, 28.701429095284542, 329.5490474106795,  /* lch */
        329.5490474106795, 59.1960886419386, 21.91892833116797,  /* hsluv */
        329.5490474106795, 166.1588705464689, 21.91892833116797,  /* hpluv */
    },
    {
        "#552255",
        0.3333333333333333, 0.13333333333333333, 0.3333333333333333,  /* rgb */
        0.05957749353146118, 0.03731461261076068, 0.09001068656113911,  /* xyz */
        22.763022651117254, 20.7546297224435, -26.838815790433774,  /* luv */
        22.763022651117254, 33.92752109937554, 307.7150129492442,  /* lch */
        307.7150129492442, 65.43338593546862, 22.763022651117254,  /* hsluv */
        307.7150129492442, 189.13048019699076, 22.763022651117254,  /* hpluv */
    },
    {
        "#552266",
        0.3333333333333333, 0.13333333333333333, 0.4,  /* rgb */
        0.06716248930496936, 0.040348610920163994, 0.12995833096828308,  /* xyz */
        23.786357914417813, 17.02968193554444, -39.10690839143106,  /* luv */
        23.786357914417813, 42.65396055188298, 293.53142992767704,  /* lch */
        293.53142992767704, 71.0608597854246, 23.786357914417813,  /* hsluv */
        293.53142992767704, 227.5468040063441, 23.786357914417813,  /* hpluv */
    },
    {
        "#552277",
        0.3333333333333333, 0.13333333333333333, 0.4666666666666667,  /* rgb */
        0.07647650232517128, 0.04407421612824481, 0.17901213287468098,  /* xyz */
        24.975052770659552, 13.690485134935335, -51.011949514733786,  /* luv */
        24.975052770659552, 52.81712200152176, 285.0229207588894,  /* lch */
        285.0229207588894, 75.88227451154556, 24.975052770659552,  /* hsluv */
        285.0229207588894, 268.35373536087286, 24.975052770659552,  /* hpluv */
    },
    {
        "#552288",
        0.3333333333333333, 0.13333333333333333, 0.5333333333333333,  /* rgb */
        0.08761691942711511, 0.0485303829690224, 0.23768499627825315,  /* xyz */
        26.31190335695154, 10.754023379801918, -62.45607208095426,  /* luv */
        26.31190335695154, 63.37515253342338, 279.76969802223687,  /* lch */
        279.76969802223687, 79.88975054980654, 26.31190335695154,  /* hsluv */
        279.76969802223687, 305.63710600295286, 26.31190335695154,  /* hpluv */
    },
    {
        "#552299",
        0.3333333333333333, 0.13333333333333333, 0.6,  /* rgb */
        0.10067388353618781, 0.053753168612651565, 0.30645167391937106,  /* xyz */
        27.778345647168607, 8.184686359746124, -73.46175823412098,  /* luv */
        27.778345647168607, 73.9162973481211, 276.3573476815173,  /* lch */
        276.3573476815173, 83.16780459737501, 27.778345647168607,  /* hsluv */
        276.3573476815173, 337.6549748743051, 27.778345647168607,  /* hpluv */
    },
    {
        "#5522aa",
        0.3333333333333333, 0.13333333333333333, 0.6666666666666666,  /* rgb */
        0.11573157650144036, 0.05977624579875267, 0.38575552353636966,  /* xyz */
        29.355943042022886, 5.928695859546754, -84.09506032583535,  /* luv */
        29.355943042022886, 84.30378761242518, 274.0326761495896,  /* lch */
        274.0326761495896, 85.83126351493749, 29.355943042022886,  /* hsluv */
        274.0326761495896, 364.4100763812533, 29.355943042022886,  /* hpluv */
    },
    {
        "#5522bb",
        0.3333333333333333, 0.13333333333333333, 0.7333333333333333,  /* rgb */
        0.132869168608777, 0.06663128264168743, 0.4760135086350114,  /* xyz */
        31.027372398637908, 3.9316479249176663, -94.42724037345013,  /* luv */
        31.027372398637908, 94.50905554469816, 272.3842356406967,  /* lch */
        272.3842356406967, 87.99354150109394, 31.027372398637908,  /* hsluv */
        272.3842356406967, 386.51624475037977, 31.027372398637908,  /* hpluv */
    },
    {
        "#5522cc",
        0.3333333333333333, 0.13333333333333333, 0.8,  /* rgb */
        0.15216154405249874, 0.07434823281917623, 0.5776200193052815,  /* xyz */
        32.77697606207932, 2.145620802837479, -104.51973668886941,  /* luv */
        32.77697606207932, 104.54175742802569, 271.17602431690676,  /* lch */
        271.17602431690676, 89.75380928942485, 32.77697606207932,  /* hsluv */
        271.17602431690676, 404.72519335688713, 32.77697606207932,  /* hpluv */
    },
    {
        "#5522dd",
        0.3333333333333333, 0.13333333333333333, 0.8666666666666667,  /* rgb */
        0.17367986960313228, 0.08295556303942976, 0.6909498672052875,  /* xyz */
        34.590988011861285, 0.5309898124095533, -114.42061032613957,  /* luv */
        34.590988011861285, 114.42184239727641, 270.2658896568741,  /* lch */
        270.2658896568741, 91.19384400167125, 34.590988011861285,  /* hsluv */
        270.2658896568741, 419.7447724714208, 34.590988011861285,  /* hpluv */
    },
    {
        "#5522ee",
        0.3333333333333333, 0.13333333333333333, 0.9333333333333333,  /* rgb */
        0.19749204986930702, 0.09248043514589979, 0.8163606832738107,  /* xyz */
        36.45754285267471, -0.9440290658019156, -124.16565900571574,  /* luv */
        36.45754285267471, 124.16924767107497, 269.56438970751486,  /* lch */
        269.56438970751486, 92.96001810110731, 36.45754285267471,  /* hsluv */
        269.56438970751486, 432.18130979066274, 36.45754285267471,  /* hpluv */
    },
    {
        "#5522ff",
        0.3333333333333333, 0.13333333333333333, 1.0,  /* rgb */
        0.2236630982791384, 0.10294885450983249, 0.9541948715655926,  /* xyz */
        38.36655681362187, -2.3045949496505087, -133.78090625800112,  /* luv */
        38.36655681362187, 133.80075499448438, 269.01308409021976,  /* lch */
        269.01308409021976, 99.99999999999945, 38.36655681362187,  /* hsluv */
        269.01308409021976, 442.53239191188715, 38.36655681362187,  /* hpluv */
    },
    {
        "#553300",
        0.3333333333333333, 0.2, 0.0,  /* rgb */
        0.04930003196631924, 0.042991983327121286, 0.005701960012269471,  /* xyz */
        24.636891817040265, 25.43488226292887, 24.233560440905602,  /* luv */
        24.636891817040265, 35.13116404806534, 43.614467272051485,  /* lch */
        43.614467272051485, 100.00000000000225, 24.636891817040265,  /* hsluv */
        43.614467272051485, 180.94473470251546, 24.636891817040265,  /* hpluv */
    },
    {
        "#553311",
        0.3333333333333333, 0.2, 0.06666666666666667,  /* rgb */
        0.05031169746595636, 0.04339664952697614, 0.011030064977025102,  /* xyz */
        24.76399341966713, 24.536650698978292, 20.454496759827716,  /* luv */
        24.76399341966713, 31.94422741625589, 39.81561298659506,  /* lch */
        39.81561298659506, 85.33095965741433, 24.76399341966713,  /* hsluv */
        39.81561298659506, 163.68581140929442, 24.76399341966713,  /* hpluv */
    },
    {
        "#553322",
        0.3333333333333333, 0.2, 0.13333333333333333,  /* rgb */
        0.05218705560443338, 0.04414679278236696, 0.0209069511730043,  /* xyz */
        24.99753153229439, 23.004889220590403, 13.960805403509227,  /* luv */
        24.99753153229439, 26.909645400233146, 31.25199490101754,  /* lch */
        31.25199490101754, 60.44177620686848, 24.99753153229439,  /* hsluv */
        31.25199490101754, 136.59983556614165, 24.99753153229439,  /* hpluv */
    },
    {
        "#553333",
        0.3333333333333333, 0.2, 0.2,  /* rgb */
        0.05527480633689112, 0.04538189307535007, 0.03716910503061544,  /* xyz */
        25.376351437130992, 20.799989547597608, 4.488396953770193,  /* luv */
        25.376351437130992, 21.27875166439007, 12.17705063006215,  /* lch */
        12.17705063006215, 24.93365983705469, 25.376351437130992,  /* hsluv */
        12.17705063006215, 106.40359278046898, 25.376351437130992,  /* hpluv */
    },
    {
        "#553344",
        0.3333333333333333, 0.2, 0.26666666666666666,  /* rgb */
        0.05973280158111, 0.047165091173037646, 0.06064787998350208,  /* xyz */
        25.911340215099266, 18.156417984486446, -7.105455580657543,  /* luv */
        25.911340215099266, 19.497256551527453, 338.62726977239026,  /* lch */
        338.62726977239026, 32.972317849154784, 25.911340215099266,  /* hsluv */
        338.62726977239026, 95.48231854707495, 25.911340215099266,  /* hpluv */
    },
    {
        "#553355",
        0.3333333333333333, 0.2, 0.3333333333333333,  /* rgb */
        0.065695215620472, 0.04955005678878248, 0.09204992725747599,  /* xyz */
        26.606190817345052, 15.337358446740376, -19.833480219537183,  /* luv */
        26.606190817345052, 25.07192656623282, 307.71501294924536,  /* lch */
        307.71501294924536, 41.369683748934996, 26.606190817345052,  /* hsluv */
        307.71501294924536, 119.57608552841951, 26.606190817345052,  /* hpluv */
    },
    {
        "#553366",
        0.3333333333333333, 0.2, 0.4,  /* rgb */
        0.07328021139398017, 0.05258405509818579, 0.13199757166461995,  /* xyz */
        27.45862825927143, 12.55406796313717, -32.88783679102205,  /* luv */
        27.45862825927143, 35.202477628939285, 290.8930425737565,  /* lch */
        290.8930425737565, 49.429407074258, 27.45862825927143,  /* hsluv */
        290.8930425737565, 162.67983383536892, 27.45862825927143,  /* hpluv */
    },
    {
        "#553377",
        0.3333333333333333, 0.2, 0.4666666666666667,  /* rgb */
        0.08259422441418209, 0.05630966030626661, 0.18105137357101786,  /* xyz */
        28.461655060413058, 9.936788433585924, -45.75408227254529,  /* luv */
        28.461655060413058, 46.82067715205206, 282.25311327130265,  /* lch */
        282.25311327130265, 56.73299451366539, 28.461655060413058,  /* hsluv */
        282.25311327130265, 208.74537696470955, 28.461655060413058,  /* hpluv */
    },
    {
        "#553388",
        0.3333333333333333, 0.2, 0.5333333333333333,  /* rgb */
        0.09373464151612591, 0.060765827147044205, 0.23972423697459003,  /* xyz */
        29.604860036932443, 7.5440776253835855, -58.17962079888726,  /* luv */
        29.604860036932443, 58.66669739741729, 277.38824648505374,  /* lch */
        277.38824648505374, 63.10617830001147, 29.604860036932443,  /* hsluv */
        277.38824648505374, 251.45944628352285, 29.604860036932443,  /* hpluv */
    },
    {
        "#553399",
        0.3333333333333333, 0.2, 0.6,  /* rgb */
        0.10679160562519863, 0.06598861279067336, 0.30849091461570793,  /* xyz */
        30.875688053977868, 5.38640350826703, -70.08794695695657,  /* luv */
        30.875688053977868, 70.29462035885128, 274.3946606260667,  /* lch */
        274.3946606260667, 68.537799314251, 30.875688053977868,  /* hsluv */
        274.3946606260667, 288.8981573344439, 30.875688053977868,  /* hpluv */
    },
    {
        "#5533aa",
        0.3333333333333333, 0.2, 0.6666666666666666,  /* rgb */
        0.12184929859045117, 0.07201168997677446, 0.38779476423270653,  /* xyz */
        32.2605562861205, 3.4481903922403903, -81.49831048347525,  /* luv */
        32.2605562861205, 81.57122426837832, 272.42273725033226,  /* lch */
        272.42273725033226, 73.10422240246119, 32.2605562861205,  /* hsluv */
        272.42273725033226, 320.8517815832162, 32.2605562861205,  /* hpluv */
    },
    {
        "#5533bb",
        0.3333333333333333, 0.2, 0.7333333333333333,  /* rgb */
        0.1389868906977878, 0.07886672681970922, 0.4780527493313483,  /* xyz */
        33.74574372327394, 1.702983139034782, -92.47081521432612,  /* luv */
        33.74574372327394, 92.48649532755518, 271.0550649657345,  /* lch */
        271.0550649657345, 76.91721996706558, 33.74574372327394,  /* hsluv */
        271.0550649657345, 347.7752289224959, 33.74574372327394,  /* hpluv */
    },
    {
        "#5533cc",
        0.3333333333333333, 0.2, 0.8,  /* rgb */
        0.15827926614150956, 0.08658367699719802, 0.5796592600016185,  /* xyz */
        35.3180325241442, 0.12210251098248695, -103.07547474872597,  /* luv */
        35.3180325241442, 103.07554706960538, 270.0678721615585,  /* lch */
        270.0678721615585, 80.09409576697692, 35.3180325241442,  /* hsluv */
        270.0678721615585, 370.3381671293555, 35.3180325241442,  /* hpluv */
    },
    {
        "#5533dd",
        0.3333333333333333, 0.2, 0.8666666666666667,  /* rgb */
        0.1797975916921431, 0.09519100721745155, 0.6929891079016245,  /* xyz */
        36.96512032823979, -1.3211697163552594, -113.3775495709866,  /* luv */
        36.96512032823979, 113.38524699510488, 269.33237203439813,  /* lch */
        269.33237203439813, 84.81192987100349, 36.96512032823979,  /* hsluv */
        269.33237203439813, 389.2277114551394, 36.96512032823979,  /* hpluv */
    },
    {
        "#5533ee",
        0.3333333333333333, 0.2, 0.9333333333333333,  /* rgb */
        0.20360977195831784, 0.1047158793239216, 0.8183999239701477,  /* xyz */
        38.675845027060625, -2.6499973828468057, -123.43216329205295,  /* luv */
        38.675845027060625, 123.460606758128, 268.7700908744607,  /* lch */
        268.7700908744607, 92.29366858746494, 38.675845027060625,  /* hsluv */
        268.7700908744607, 405.06798740881874, 38.675845027060625,  /* hpluv */
    },
    {
        "#5533ff",
        0.3333333333333333, 0.2, 1.0,  /* rgb */
        0.22978082036814923, 0.11518429868785429, 0.9562341122619296,  /* xyz */
        40.440270089438236, -3.883718854766327, -133.28352471215877,  /* luv */
        40.440270089438236, 133.34009611455778, 268.3309433531707,  /* lch */
        268.3309433531707, 99.99999999999946, 40.440270089438236,  /* hsluv */
        268.3309433531707, 418.39457322764594, 40.440270089438236,  /* hpluv */
    },
    {
        "#554400",
        0.3333333333333333, 0.26666666666666666, 0.0,  /* rgb */
        0.05813260244928528, 0.0606571242930536, 0.008646150173258066,  /* xyz */
        29.577649910945688, 13.888855356151547, 31.118046032292455,  /* luv */
        29.577649910945688, 34.07687033710654, 65.94745530700047,  /* lch */
        65.94745530700047, 100.00000000000222, 29.577649910945688,  /* hsluv */
        65.94745530700047, 146.19595752482383, 29.577649910945688,  /* hpluv */
    },
    {
        "#554411",
        0.3333333333333333, 0.26666666666666666, 0.06666666666666667,  /* rgb */
        0.0591442679489224, 0.061061790492908455, 0.013974255138013697,  /* xyz */
        29.67878049230115, 13.424319140427743, 27.79981751517083,  /* luv */
        29.67878049230115, 30.871381541175857, 64.22445888468529,  /* lch */
        64.22445888468529, 89.40776944503635, 29.67878049230115,  /* hsluv */
        64.22445888468529, 131.9925259468386, 29.67878049230115,  /* hpluv */
    },
    {
        "#554422",
        0.3333333333333333, 0.26666666666666666, 0.13333333333333333,  /* rgb */
        0.06101962608739942, 0.061811933748299276, 0.023851141333992895,  /* xyz */
        29.86507408727889, 12.612793817931964, 21.982913111116222,  /* luv */
        29.86507408727889, 25.344250565849215, 60.154760329171154,  /* lch */
        60.154760329171154, 70.99219271992719, 29.86507408727889,  /* hsluv */
        60.154760329171154, 107.68499287303884, 29.86507408727889,  /* hpluv */
    },
    {
        "#554433",
        0.3333333333333333, 0.26666666666666666, 0.2,  /* rgb */
        0.06410737681985716, 0.06304703404128238, 0.04011329519160404,  /* xyz */
        30.16854727933177, 11.400244593092479, 13.239056048037853,  /* luv */
        30.16854727933177, 17.47106699161279, 49.26802667562815,  /* lch */
        49.26802667562815, 43.7071568358896, 30.16854727933177,  /* hsluv */
        49.26802667562815, 73.48595755861173, 30.16854727933177,  /* hpluv */
    },
    {
        "#554444",
        0.3333333333333333, 0.26666666666666666, 0.26666666666666666,  /* rgb */
        0.06856537206407604, 0.06483023213896996, 0.06359207014449067,  /* xyz */
        30.599778042498244, 9.874070036007764, 2.13071000682558,  /* luv */
        30.599778042498244, 10.101345663285315, 12.177050630062926,  /* lch */
        12.177050630062926, 9.815897635496823, 30.599778042498244,  /* hsluv */
        12.177050630062926, 41.88902798898166, 30.599778042498244,  /* hpluv */
    },
    {
        "#554455",
        0.3333333333333333, 0.26666666666666666, 0.3333333333333333,  /* rgb */
        0.07452778610343803, 0.0672151977547148, 0.09499411741846459,  /* xyz */
        31.164345936904134, 8.155083123667092, -10.545732525165485,  /* luv */
        31.164345936904134, 13.331086049015399, 307.715012949249,  /* lch */
        307.715012949249, 18.779529636348016, 31.164345936904134,  /* hsluv */
        307.715012949249, 54.28087523239067, 31.164345936904134,  /* hpluv */
    },
    {
        "#554466",
        0.3333333333333333, 0.26666666666666666, 0.4,  /* rgb */
        0.0821127818769462, 0.07024919606411811, 0.13494176182560855,  /* xyz */
        31.863572262004453, 6.361012239648948, -24.005616214070443,  /* luv */
        31.863572262004453, 24.83409121611269, 284.8411653725167,  /* lch */
        284.8411653725167, 27.896370426499683, 31.863572262004453,  /* hsluv */
        284.8411653725167, 98.89928117004423, 31.863572262004453,  /* hpluv */
    },
    {
        "#554477",
        0.3333333333333333, 0.26666666666666666, 0.4666666666666667,  /* rgb */
        0.09142679489714813, 0.07397480127219892, 0.18399556373200646,  /* xyz */
        32.695174327790944, 4.583461027497113, -37.631491211709026,  /* luv */
        32.695174327790944, 37.90959305779368, 276.94433812137817,  /* lch */
        276.94433812137817, 36.630871497836395, 32.695174327790944,  /* hsluv */
        276.94433812137817, 147.13120494789317, 32.695174327790944,  /* hpluv */
    },
    {
        "#554488",
        0.3333333333333333, 0.26666666666666666, 0.5333333333333333,  /* rgb */
        0.10256721199909195, 0.07843096811297652, 0.24266842713557862,  /* xyz */
        33.65395517173809, 2.881026009006699, -51.02058585741821,  /* luv */
        33.65395517173809, 51.10186388086795, 273.231940865766,  /* lch */
        273.231940865766, 44.65058124959328, 33.65395517173809,  /* hsluv */
        273.231940865766, 192.6814719811233, 33.65395517173809,  /* hpluv */
    },
    {
        "#554499",
        0.3333333333333333, 0.26666666666666666, 0.6,  /* rgb */
        0.11562417610816467, 0.08365375375660568, 0.31143510477669656,  /* xyz */
        34.73252372103359, 1.2833742275111057, -63.95903789097749,  /* luv */
        34.73252372103359, 63.97191240964533, 271.14951792484914,  /* lch */
        271.14951792484914, 51.79997102001339, 34.73252372103359,  /* hsluv */
        271.14951792484914, 233.71808513869823, 34.73252372103359,  /* hpluv */
    },
    {
        "#5544aa",
        0.3333333333333333, 0.26666666666666666, 0.6666666666666666,  /* rgb */
        0.13068186907341722, 0.08967683094270679, 0.3907389543936951,  /* xyz */
        35.92199926823277, -0.20042437465385984, -76.36763552040368,  /* luv */
        35.92199926823277, 76.36789852357585, 269.8496294361391,  /* lch */
        269.8496294361391, 58.04902399636725, 35.92199926823277,  /* hsluv */
        269.8496294361391, 269.76752455378676, 35.92199926823277,  /* hpluv */
    },
    {
        "#5544bb",
        0.3333333333333333, 0.26666666666666666, 0.7333333333333333,  /* rgb */
        0.14781946118075384, 0.09653186778564155, 0.4809969394923369,  /* xyz */
        37.21265060619987, -1.573763122330166, -88.24874995849986,  /* luv */
        37.21265060619987, 88.26278150841969, 268.9783376200633,  /* lch */
        268.9783376200633, 66.00750293215047, 37.21265060619987,  /* hsluv */
        268.9783376200633, 300.97216398316993, 37.21265060619987,  /* hpluv */
    },
    {
        "#5544cc",
        0.3333333333333333, 0.26666666666666666, 0.8,  /* rgb */
        0.1671118366244756, 0.10424881796313035, 0.5826034501626071,  /* xyz */
        38.59443414523577, -2.846370301366802, -99.64647075195288,  /* luv */
        38.59443414523577, 99.68711530188996, 268.36380887614587,  /* lch */
        268.36380887614587, 74.52836810636524, 38.59443414523577,  /* hsluv */
        268.36380887614587, 327.7582841819392, 38.59443414523577,  /* hpluv */
    },
    {
        "#5544dd",
        0.3333333333333333, 0.26666666666666666, 0.8666666666666667,  /* rgb */
        0.18863016217510914, 0.11285614818338388, 0.6959332980626131,  /* xyz */
        40.057414571093574, -4.030359954068701, -110.62107049636028,  /* luv */
        40.057414571093574, 110.694467066426, 267.913412719582,  /* lch */
        267.913412719582, 82.9425769408534, 40.057414571093574,  /* hsluv */
        267.913412719582, 350.65684831918054, 40.057414571093574,  /* hpluv */
    },
    {
        "#5544ee",
        0.3333333333333333, 0.26666666666666666, 0.9333333333333333,  /* rgb */
        0.21244234244128388, 0.1223810202898539, 0.8213441141311363,  /* xyz */
        41.59206876295548, -5.1379866615847165, -121.23462268002875,  /* luv */
        41.59206876295548, 121.34344911573744, 267.5732271444359,  /* lch */
        267.5732271444359, 91.38786883891959, 41.59206876295548,  /* hsluv */
        267.5732271444359, 370.20743742580436, 41.59206876295548,  /* hpluv */
    },
    {
        "#5544ff",
        0.3333333333333333, 0.26666666666666666, 1.0,  /* rgb */
        0.23861339085111527, 0.1328494396537866, 0.9591783024229181,  /* xyz */
        43.18948549394138, -6.18053297470727, -131.54397746832166,  /* luv */
        43.18948549394138, 131.6890921680219, 267.3099625819741,  /* lch */
        267.3099625819741, 99.99999999999942, 43.18948549394138,  /* hsluv */
        267.3099625819741, 386.9110203308465, 43.18948549394138,  /* hpluv */
    },
    {
        "#555500",
        0.3333333333333333, 0.3333333333333333, 0.0,  /* rgb */
        0.06994585916363125, 0.08428363772174587, 0.012583902411373277,  /* xyz */
        34.859538272914875, 2.7647674115502796, 38.32959297767119,  /* luv */
        34.859538272914875, 38.42917689300554, 85.87432021817473,  /* lch */
        85.87432021817473, 100.00000000000233, 34.859538272914875,  /* hsluv */
        85.87432021817473, 139.88745807479756, 34.859538272914875,  /* hpluv */
    },
    {
        "#555511",
        0.3333333333333333, 0.3333333333333333, 0.06666666666666667,  /* rgb */
        0.07095752466326836, 0.08468830392160072, 0.017912007376128906,  /* xyz */
        34.9408046802893, 2.5572216410029456, 35.45226417377725,  /* luv */
        34.9408046802893, 35.54437251617341, 85.87432021817453,  /* lch */
        85.87432021817453, 92.2780688504912, 34.9408046802893,  /* hsluv */
        85.87432021817453, 129.08544487546067, 34.9408046802893,  /* hpluv */
    },
    {
        "#555522",
        0.3333333333333333, 0.3333333333333333, 0.13333333333333333,  /* rgb */
        0.0728328828017454, 0.08543844717699153, 0.027788893572108106,  /* xyz */
        35.09076882392506, 2.188050860345086, 30.334233013991405,  /* luv */
        35.09076882392506, 30.41304422636088, 85.87432021817402,  /* lch */
        85.87432021817402, 78.61900767834067, 35.09076882392506,  /* hsluv */
        85.87432021817402, 109.97813140485806, 35.09076882392506,  /* hpluv */
    },
    {
        "#555533",
        0.3333333333333333, 0.3333333333333333, 0.2,  /* rgb */
        0.07592063353420313, 0.08667354746997465, 0.04405104742971925,  /* xyz */
        35.33578175525701, 1.6203424713160401, 22.463758488503228,  /* luv */
        35.33578175525701, 22.522121462112565, 85.87432021817285,  /* lch */
        85.87432021817285, 57.81694501752116, 35.33578175525701,  /* hsluv */
        85.87432021817285, 80.87865472151167, 35.33578175525701,  /* hpluv */
    },
    {
        "#555544",
        0.3333333333333333, 0.3333333333333333, 0.26666666666666666,  /* rgb */
        0.080378628778422, 0.08845674556766223, 0.06752982238260588,  /* xyz */
        35.68545076690586, 0.8771943748362624, 12.161060351502845,  /* luv */
        35.68545076690586, 12.192655938889562, 85.87432021816917,  /* lch */
        85.87432021816917, 30.993289982883226, 35.68545076690586,  /* hsluv */
        85.87432021816917, 43.355725530805, 35.68545076690586,  /* hpluv */
    },
    {
        "#555555",
        0.3333333333333333, 0.3333333333333333, 0.3333333333333333,  /* rgb */
        0.086341042817784, 0.09084171118340706, 0.0989318696565798,  /* xyz */
        36.14585083971973, 1.7998285197345141e-12, 5.999428399115047e-13,  /* luv */
        36.14585083971973, 1.8971858400301257e-12, 0.0,  /* lch */
        0.0, 1.9069684920366045e-12, 36.14585083971973,  /* hsluv */
        0.0, 6.660253339782792e-12, 36.14585083971973,  /* hpluv */
    },
    {
        "#555566",
        0.3333333333333333, 0.3333333333333333, 0.4,  /* rgb */
        0.09392603859129217, 0.09387570949281038, 0.13887951406372376,  /* xyz */
        36.72004027205231, -0.963409690459316, -13.35631386273989,  /* luv */
        36.72004027205231, 13.391014832031539, 265.87432021818483,  /* lch */
        265.87432021818483, 10.020578852309384, 36.72004027205231,  /* hsluv */
        265.87432021818483, 46.27534537179467, 36.72004027205231,  /* hpluv */
    },
    {
        "#555577",
        0.3333333333333333, 0.3333333333333333, 0.4666666666666667,  /* rgb */
        0.10324005161149409, 0.09760131470089119, 0.18793331597012167,  /* xyz */
        37.408438223749044, -1.968769320503266, -27.294204353927416,  /* luv */
        37.408438223749044, 27.365117283711854, 265.874320218181,  /* lch */
        265.874320218181, 20.457601163446, 37.408438223749044,  /* hsluv */
        265.874320218181, 92.82544999385301, 37.408438223749044,  /* hpluv */
    },
    {
        "#555588",
        0.3333333333333333, 0.3333333333333333, 0.5333333333333333,  /* rgb */
        0.11438046871343792, 0.10205748154166878, 0.24660617937369383,  /* xyz */
        38.20919252274904, -2.981241023149999, -41.330693680935326,  /* luv */
        38.20919252274904, 41.43807474033295, 265.87432021817983,  /* lch */
        265.87432021817983, 30.967761612198824, 38.20919252274904,  /* hsluv */
        265.87432021817983, 137.61666726450338, 38.20919252274904,  /* hpluv */
    },
    {
        "#555599",
        0.3333333333333333, 0.3333333333333333, 0.6,  /* rgb */
        0.12743743282251063, 0.10728026718529794, 0.31537285701481177,  /* xyz */
        39.11856953940921, -3.9770812160867526, -55.13661062954876,  /* luv */
        39.11856953940921, 55.279860769667465, 265.8743202181792,  /* lch */
        265.8743202181792, 41.33774602123527, 39.11856953940921,  /* hsluv */
        265.8743202181792, 179.31775855965935, 39.11856953940921,  /* hpluv */
    },
    {
        "#5555aa",
        0.3333333333333333, 0.3333333333333333, 0.6666666666666666,  /* rgb */
        0.1424951257877632, 0.11330334437139905, 0.3946767066318103,  /* xyz */
        40.13136010090051, -4.942482222850342, -68.52053127868528,  /* luv */
        40.13136010090051, 68.69855411314332, 265.87432021817887,  /* lch */
        265.87432021817887, 51.47058657317369, 40.13136010090051,  /* hsluv */
        265.87432021817887, 217.221618066114, 40.13136010090051,  /* hpluv */
    },
    {
        "#5555bb",
        0.3333333333333333, 0.3333333333333333, 0.7333333333333333,  /* rgb */
        0.1596327178950998, 0.12015838121433381, 0.4849346917304521,  /* xyz */
        41.24128116534638, -5.871178598378386, -81.3955940869131,  /* luv */
        41.24128116534638, 81.60706755481158, 265.87432021817864,  /* lch */
        265.87432021817864, 61.358492437487264, 41.24128116534638,  /* hsluv */
        265.87432021817864, 251.09319948852425, 41.24128116534638,  /* hpluv */
    },
    {
        "#5555cc",
        0.3333333333333333, 0.3333333333333333, 0.8,  /* rgb */
        0.17892509333882156, 0.1278753313918226, 0.5865412024007223,  /* xyz */
        42.44135094362704, -6.761943924070294, -93.74479649351748,  /* luv */
        42.44135094362704, 93.9883543596933, 265.87432021817847,  /* lch */
        265.87432021817847, 71.05463323159998, 42.44135094362704,  /* hsluv */
        265.87432021817847, 281.0115514841879, 42.44135094362704,  /* hpluv */
    },
    {
        "#5555dd",
        0.3333333333333333, 0.3333333333333333, 0.8666666666666667,  /* rgb */
        0.2004434188894551, 0.13648266161207614, 0.6998710503007283,  /* xyz */
        43.72421960045324, -7.616529677832023, -105.59242026446559,  /* luv */
        43.72421960045324, 105.86675938008501, 265.8743202181784,  /* lch */
        265.8743202181784, 80.65003000648645, 43.72421960045324,  /* hsluv */
        265.8743202181784, 307.23937929713105, 43.72421960045324,  /* hpluv */
    },
    {
        "#5555ee",
        0.3333333333333333, 0.3333333333333333, 0.9333333333333333,  /* rgb */
        0.22425559915562984, 0.14600753371854616, 0.8252818663692515,  /* xyz */
        45.08244476522986, -8.438190536367534, -116.98358689273267,  /* luv */
        45.08244476522986, 117.28752133887721, 265.87432021817835,  /* lch */
        265.87432021817835, 90.25721108557127, 45.08244476522986,  /* hsluv */
        265.87432021817835, 330.1289994179583, 45.08244476522986,  /* hpluv */
    },
    {
        "#5555ff",
        0.3333333333333333, 0.3333333333333333, 1.0,  /* rgb */
        0.25042664756546124, 0.15647595308247886, 0.9631160546610333,  /* xyz */
        46.50870827034442, -9.23073412981071, -127.97108378916273,  /* luv */
        46.50870827034442, 128.30356479361032, 265.87432021817824,  /* lch */
        265.87432021817824, 99.99999999999925, 46.50870827034442,  /* hsluv */
        265.87432021817824, 350.06103452253103, 46.50870827034442,  /* hpluv */
    },
    {
        "#556600",
        0.3333333333333333, 0.4, 0.0,  /* rgb */
        0.08497391686947771, 0.1143397531334392, 0.017593254979988624,  /* xyz */
        40.30198922067329, -7.536789200786137, 45.619196730297126,  /* luv */
        40.30198922067329, 46.23758538001999, 99.38114891536063,  /* lch */
        99.38114891536063, 100.0000000000023, 40.30198922067329,  /* hsluv */
        99.38114891536063, 145.582103533726, 40.30198922067329,  /* hpluv */
    },
    {
        "#556611",
        0.3333333333333333, 0.4, 0.06666666666666667,  /* rgb */
        0.08598558236911483, 0.11474441933329406, 0.022921359944744257,  /* xyz */
        40.36833152067263, -7.600857400224208, 43.12935579317367,  /* luv */
        40.36833152067263, 43.79399918199646, 99.99483123849814,  /* lch */
        99.99483123849814, 94.25761385992142, 40.36833152067263,  /* hsluv */
        99.99483123849814, 137.66170134739698, 40.36833152067263,  /* hpluv */
    },
    {
        "#556622",
        0.3333333333333333, 0.4, 0.13333333333333333,  /* rgb */
        0.08786094050759186, 0.11549456258868487, 0.03279824614072345,  /* xyz */
        40.49090106081484, -7.716698000046511, 38.654779792370576,  /* luv */
        40.49090106081484, 39.417501554773644, 101.28961011017671,  /* lch */
        101.28961011017671, 83.97795481282654, 40.49090106081484,  /* hsluv */
        101.28961011017671, 123.52958389905378, 40.49090106081484,  /* hpluv */
    },
    {
        "#556633",
        0.3333333333333333, 0.4, 0.2,  /* rgb */
        0.09094869124004959, 0.11672966288166799, 0.0490603999983346,  /* xyz */
        40.691558939192745, -7.899695744446852, 31.65935487454915,  /* luv */
        40.691558939192745, 32.630046643047734, 104.01044750968255,  /* lch */
        104.01044750968255, 68.01552576073713, 40.691558939192745,  /* hsluv */
        104.01044750968255, 101.75428164085531, 40.691558939192745,  /* hpluv */
    },
    {
        "#556644",
        0.3333333333333333, 0.4, 0.26666666666666666,  /* rgb */
        0.09540668648426846, 0.11851286097935557, 0.07253917495122124,  /* xyz */
        40.97878051351153, -8.148606600591117, 22.293130411939504,  /* luv */
        40.97878051351153, 23.735699970612604, 110.07841781545402,  /* lch */
        110.07841781545402, 46.86591944296441, 40.97878051351153,  /* hsluv */
        110.07841781545402, 73.49915397573454, 40.97878051351153,  /* hpluv */
    },
    {
        "#556655",
        0.3333333333333333, 0.4, 0.3333333333333333,  /* rgb */
        0.10136910052363046, 0.1208978265951004, 0.10394122222519514,  /* xyz */
        41.35846059376384, -8.457012253178652, 10.936171689690187,  /* luv */
        41.35846059376384, 13.824648548038933, 127.71501294923371,  /* lch */
        127.71501294923371, 21.59727173023801, 41.35846059376384,  /* hsluv */
        127.71501294923371, 42.415936524236166, 41.35846059376384,  /* hpluv */
    },
    {
        "#556666",
        0.3333333333333333, 0.4, 0.4,  /* rgb */
        0.10895409629713863, 0.12393182490450372, 0.1438888666323391,  /* xyz */
        41.834316073315215, -8.815435423102448, -1.902268912619466,  /* luv */
        41.834316073315215, 9.018344011779984, 192.1770506300603,  /* lch */
        192.1770506300603, 27.24771946027788, 41.834316073315215,  /* hsluv */
        192.1770506300603, 27.35479414969455, 41.834316073315215,  /* hpluv */
    },
    {
        "#556677",
        0.3333333333333333, 0.4, 0.4666666666666667,  /* rgb */
        0.11826810931734055, 0.12765743011258454, 0.192942668538737,  /* xyz */
        42.40813712234925, -9.213445589941193, -15.68568177286978,  /* luv */
        42.40813712234925, 18.191431838053486, 239.5709034305692,  /* lch */
        239.5709034305692, 33.16268449964279, 42.40813712234925,  /* hsluv */
        239.5709034305692, 54.432341238419944, 42.40813712234925,  /* hpluv */
    },
    {
        "#556688",
        0.3333333333333333, 0.4, 0.5333333333333333,  /* rgb */
        0.12940852641928438, 0.1321135969533621, 0.2516155319423092,  /* xyz */
        43.08000111906554, -9.641306141920285, -29.929850482812125,  /* luv */
        43.08000111906554, 31.44440703918137, 252.14468708181334,  /* lch */
        252.14468708181334, 39.08627887169969, 43.08000111906554,  /* hsluv */
        252.14468708181334, 92.62048057664417, 43.08000111906554,  /* hpluv */
    },
    {
        "#556699",
        0.3333333333333333, 0.4, 0.6,  /* rgb */
        0.1424654905283571, 0.13733638259699127, 0.3203822095834271,  /* xyz */
        43.848489048687696, -10.090933534038701, -44.248218678905964,  /* luv */
        43.848489048687696, 45.3842681536749, 257.1532373134514,  /* lch */
        257.1532373134514, 44.818232635509005, 43.848489048687696,  /* hsluv */
        257.1532373134514, 131.3378886078639, 43.848489048687696,  /* hpluv */
    },
    {
        "#5566aa",
        0.3333333333333333, 0.4, 0.6666666666666666,  /* rgb */
        0.15752318349360964, 0.1433594597830924, 0.3996860592004257,  /* xyz */
        44.7109144588579, -10.556210311016503, -58.36504628820379,  /* luv */
        44.7109144588579, 59.31199039279142, 259.748012643434,  /* lch */
        259.748012643434, 50.220255725203934, 44.7109144588579,  /* hsluv */
        259.748012643434, 168.33261588574226, 44.7109144588579,  /* hpluv */
    },
    {
        "#5566bb",
        0.3333333333333333, 0.4, 0.7333333333333333,  /* rgb */
        0.17466077560094628, 0.15021449662602715, 0.48994404429906746,  /* xyz */
        45.663561525298746, -11.032851911231404, -72.10631666966955,  /* luv */
        45.663561525298746, 72.94549146425588, 261.30074927886255,  /* lch */
        261.30074927886255, 56.15514800821008, 45.663561525298746,  /* hsluv */
        261.30074927886255, 202.7066516509892, 45.663561525298746,  /* hpluv */
    },
    {
        "#5566cc",
        0.3333333333333333, 0.4, 0.8,  /* rgb */
        0.19395315104466804, 0.15793144680351595, 0.5915505549693376,  /* xyz */
        46.701923023928195, -11.51805152829885, -85.3796255742992,  /* luv */
        46.701923023928195, 86.15303810206622, 262.3169552187839,  /* lch */
        262.3169552187839, 67.08011362977321, 46.701923023928195,  /* hsluv */
        262.3169552187839, 234.0858486849409, 46.701923023928195,  /* hpluv */
    },
    {
        "#5566dd",
        0.3333333333333333, 0.4, 0.8666666666666667,  /* rgb */
        0.21547147659530158, 0.16653877702376949, 0.7048804028693436,  /* xyz */
        47.820927718279954, -12.010072956506761, -98.15159782672227,  /* luv */
        47.820927718279954, 98.8836589551542, 263.02382547589804,  /* lch */
        263.02382547589804, 77.97386153157339, 47.820927718279954,  /* hsluv */
        263.02382547589804, 262.3891408401151, 47.820927718279954,  /* hpluv */
    },
    {
        "#5566ee",
        0.3333333333333333, 0.4, 0.9333333333333333,  /* rgb */
        0.2392836568614763, 0.1760636491302395, 0.8302912189378668,  /* xyz */
        49.01514800191211, -12.50788800873526, -110.42772265060322,  /* luv */
        49.01514800191211, 111.13383459701915, 263.5377839037806,  /* lch */
        263.5377839037806, 88.91331335051711, 49.01514800191211,  /* hsluv */
        263.5377839037806, 287.71023239819266, 49.01514800191211,  /* hpluv */
    },
    {
        "#5566ff",
        0.3333333333333333, 0.4, 1.0,  /* rgb */
        0.2654547052713077, 0.1865320684941722, 0.9681254072296487,  /* xyz */
        50.278981284109875, -13.010896276595671, -122.2365506870404,  /* luv */
        50.278981284109875, 122.92704236979644, 263.92429556513446,  /* lch */
        263.92429556513446, 99.99999999999919, 50.278981284109875,  /* hsluv */
        263.92429556513446, 310.2417842032321, 50.278981284109875,  /* hpluv */
    },
    {
        "#557700",
        0.3333333333333333, 0.4666666666666667, 0.0,  /* rgb */
        0.10342765492289534, 0.15124722924027498, 0.023744500997794328,  /* xyz */
        45.80455232716135, -16.97672074684951, 52.87068404567493,  /* luv */
        45.80455232716135, 55.529436146732984, 107.80176948302088,  /* lch */
        107.80176948302088, 100.00000000000229, 45.80455232716135,  /* hsluv */
        107.80176948302088, 153.83457187868342, 45.80455232716135,  /* hpluv */
    },
    {
        "#557711",
        0.3333333333333333, 0.4666666666666667, 0.06666666666666667,  /* rgb */
        0.10443932042253246, 0.15165189544012983, 0.029072605962549958,  /* xyz */
        45.859623178970125, -16.96301662030795, 50.70846798960191,  /* luv */
        45.859623178970125, 53.47048399550284, 108.49613914638488,  /* lch */
        108.49613914638488, 95.6324690191426, 45.859623178970125,  /* hsluv */
        108.49613914638488, 147.95272207175668, 45.859623178970125,  /* hpluv */
    },
    {
        "#557722",
        0.3333333333333333, 0.4666666666666667, 0.13333333333333333,  /* rgb */
        0.10631467856100948, 0.15240203869552066, 0.03894949215852916,  /* xyz */
        45.96145128792675, -16.93896350220896, 46.79437232064054,  /* luv */
        45.96145128792675, 49.76586948312967, 109.89960724551774,  /* lch */
        109.89960724551774, 87.74862100934612, 45.96145128792675,  /* hsluv */
        109.89960724551774, 137.39698068400037, 45.96145128792675,  /* hpluv */
    },
    {
        "#557733",
        0.3333333333333333, 0.4666666666666667, 0.2,  /* rgb */
        0.10940242929346722, 0.15363713898850376, 0.0552116460161403,  /* xyz */
        46.1283843073061, -16.90297264989734, 40.60225098039052,  /* luv */
        46.1283843073061, 43.98014630577985, 112.60226929711881,  /* lch */
        112.60226929711881, 75.33739741560974, 46.1283843073061,  /* hsluv */
        112.60226929711881, 120.98394814469344, 46.1283843073061,  /* hpluv */
    },
    {
        "#557744",
        0.3333333333333333, 0.4666666666666667, 0.26666666666666666,  /* rgb */
        0.11386042453768609, 0.15542033708619135, 0.07869042096902694,  /* xyz */
        46.36782584826654, -16.858274831362323, 32.172406013566686,  /* luv */
        46.36782584826654, 36.32168964945775, 117.65444636896297,  /* lch */
        117.65444636896297, 58.568249351416235, 46.36782584826654,  /* hsluv */
        117.65444636896297, 99.40051560496109, 46.36782584826654,  /* hpluv */
    },
    {
        "#557755",
        0.3333333333333333, 0.4666666666666667, 0.3333333333333333,  /* rgb */
        0.11982283857704809, 0.15780530270193618, 0.11009246824300084,  /* xyz */
        46.685224672249035, -16.810371569469062, 21.73830475202133,  /* luv */
        46.685224672249035, 27.479856000266214, 127.71501294923736,  /* lch */
        127.71501294923736, 38.03156157957312, 46.685224672249035,  /* hsluv */
        127.71501294923736, 74.69204082931985, 46.685224672249035,  /* hpluv */
    },
    {
        "#557766",
        0.3333333333333333, 0.4666666666666667, 0.4,  /* rgb */
        0.12740783435055628, 0.16083930101133947, 0.1500401126501448,  /* xyz */
        47.08441037573553, -16.7662346577491, 9.666623979391144,  /* luv */
        47.08441037573553, 19.353300590794504, 150.03426915489322,  /* lch */
        150.03426915489322, 41.61559838083334, 47.08441037573553,  /* hsluv */
        150.03426915489322, 52.157555912765915, 47.08441037573553,  /* hpluv */
    },
    {
        "#557777",
        0.3333333333333333, 0.4666666666666667, 0.4666666666666667,  /* rgb */
        0.13672184737075818, 0.1645649062194203, 0.1990939145565427,  /* xyz */
        47.56778294082555, -16.733329138647683, -3.6108587151191585,  /* luv */
        47.56778294082555, 17.118487220629852, 192.17705063006056,  /* lch */
        192.17705063006056, 45.48712702528797, 47.56778294082555,  /* hsluv */
        192.17705063006056, 45.66587666361237, 47.56778294082555,  /* hpluv */
    },
    {
        "#557788",
        0.3333333333333333, 0.4666666666666667, 0.5333333333333333,  /* rgb */
        0.147862264472702, 0.1690210730601979, 0.2577667779601149,  /* xyz */
        48.13645339883644, -16.71869320717207, -17.660533876074616,  /* luv */
        48.13645339883644, 24.318905389501406, 226.569261606948,  /* lch */
        226.569261606948, 49.49303976790026, 48.13645339883644,  /* hsluv */
        226.569261606948, 64.10756192326902, 48.13645339883644,  /* hpluv */
    },
    {
        "#557799",
        0.3333333333333333, 0.4666666666666667, 0.6,  /* rgb */
        0.1609192285817747, 0.17424385870382705, 0.3265334556012328,  /* xyz */
        48.79037336000498, -16.72825752523161, -32.094352861043575,  /* luv */
        48.79037336000498, 36.19229317685802, 242.47051849594322,  /* lch */
        242.47051849594322, 53.498140918325966, 48.79037336000498,  /* hsluv */
        242.47051849594322, 94.12853214915545, 48.79037336000498,  /* hpluv */
    },
    {
        "#5577aa",
        0.3333333333333333, 0.4666666666666667, 0.6666666666666666,  /* rgb */
        0.17597692154702727, 0.18026693588992815, 0.4058373052182314,  /* xyz */
        49.528468029488096, -16.76647789878516, -46.59685605889183,  /* luv */
        49.528468029488096, 49.52152840637631, 250.21025726321818,  /* lch */
        250.21025726321818, 57.39437815851425, 49.528468029488096,  /* hsluv */
        250.21025726321818, 126.87570591136486, 49.528468029488096,  /* hpluv */
    },
    {
        "#5577bb",
        0.3333333333333333, 0.4666666666666667, 0.7333333333333333,  /* rgb */
        0.1931145136543639, 0.1871219727328629, 0.49609529031687316,  /* xyz */
        50.34877644719293, -16.83625552095724, -60.93360577533161,  /* luv */
        50.34877644719293, 63.2168000831305, 254.55426183786207,  /* lch */
        254.55426183786207, 61.103545740068974, 50.34877644719293,  /* hsluv */
        254.55426183786207, 159.32462846471373, 50.34877644719293,  /* hpluv */
    },
    {
        "#5577cc",
        0.3333333333333333, 0.4666666666666667, 0.8,  /* rgb */
        0.21240688909808564, 0.1948389229103517, 0.5977018009871433,  /* xyz */
        51.248597173840494, -16.93906298452356, -74.94631951119005,  /* luv */
        51.248597173840494, 76.83672730580763, 257.2642242473372,  /* lch */
        257.2642242473372, 64.57531932286943, 51.248597173840494,  /* hsluv */
        257.2642242473372, 190.25067368759798, 51.248597173840494,  /* hpluv */
    },
    {
        "#5577dd",
        0.3333333333333333, 0.4666666666666667, 0.8666666666666667,  /* rgb */
        0.23392521464871918, 0.20344625313060524, 0.7110316488871493,  /* xyz */
        52.22463504662704, -17.075183181685393, -88.54066276120903,  /* luv */
        52.22463504662704, 90.17211787954335, 259.08443954534147,  /* lch */
        259.08443954534147, 74.91399407719138, 52.22463504662704,  /* hsluv */
        259.08443954534147, 219.09687482347618, 52.22463504662704,  /* hpluv */
    },
    {
        "#5577ee",
        0.3333333333333333, 0.4666666666666667, 0.9333333333333333,  /* rgb */
        0.25773739491489395, 0.2129711252370753, 0.8364424649556725,  /* xyz */
        53.27314383224578, -17.243985114150444, -101.67153920097851,  /* luv */
        53.27314383224578, 103.12350317029166, 260.3739611872646,  /* lch */
        260.3739611872646, 87.3510385353649, 53.27314383224578,  /* hsluv */
        260.3739611872646, 245.63410016831412, 53.27314383224578,  /* hpluv */
    },
    {
        "#5577ff",
        0.3333333333333333, 0.4666666666666667, 1.0,  /* rgb */
        0.2839084433247253, 0.22343954460100798, 0.9742766532474544,  /* xyz */
        54.39005994849376, -17.44418707197071, -114.32899931064253,  /* luv */
        54.39005994849376, 115.65214976806445, 261.3247835851708,  /* lch */
        261.3247835851708, 99.99999999999898, 54.39005994849376,  /* hsluv */
        261.3247835851708, 269.8196030109779, 54.39005994849376,  /* hpluv */
    },
    {
        "#558800",
        0.3333333333333333, 0.5333333333333333, 0.0,  /* rgb */
        0.1255000246478658, 0.19539196869021652, 0.031101957572784274,  /* xyz */
        51.31216492950033, -25.647704918879903, 60.03425158438095,  /* luv */
        51.31216492950033, 65.2833526322192, 113.1330392023359,  /* lch */
        113.1330392023359, 100.00000000000242, 51.31216492950033,  /* hsluv */
        113.1330392023359, 161.443824642532, 51.31216492950033,  /* hpluv */
    },
    {
        "#558811",
        0.3333333333333333, 0.5333333333333333, 0.06666666666666667,  /* rgb */
        0.12651169014750294, 0.19579663489007137, 0.03643006253753991,  /* xyz */
        51.358601800943376, -25.592973674777017, 58.144958275646786,  /* luv */
        51.358601800943376, 63.528233679164536, 113.75708268023878,  /* lch */
        113.75708268023878, 96.60476589495603, 51.358601800943376,  /* hsluv */
        113.75708268023878, 156.96141859217582, 51.358601800943376,  /* hpluv */
    },
    {
        "#558822",
        0.3333333333333333, 0.5333333333333333, 0.13333333333333333,  /* rgb */
        0.12838704828597994, 0.1965467781454622, 0.0463069487335191,  /* xyz */
        51.444514426305275, -25.49402266705962, 54.707115096615226,  /* luv */
        51.444514426305275, 60.355725775959776, 114.9859554443815,  /* lch */
        114.9859554443815, 90.43974748734495, 51.444514426305275,  /* hsluv */
        114.9859554443815, 148.87395664167173, 51.444514426305275,  /* hpluv */
    },
    {
        "#558833",
        0.3333333333333333, 0.5333333333333333, 0.2,  /* rgb */
        0.13147479901843767, 0.1977818784384453, 0.06256910259113024,  /* xyz */
        51.58549334846764, -25.33789652719493, 49.22157238649455,  /* luv */
        51.58549334846764, 55.36038465023305, 117.23815000379763,  /* lch */
        117.23815000379763, 80.63869451191088, 51.58549334846764,  /* hsluv */
        117.23815000379763, 136.17921837597515, 51.58549334846764,  /* hpluv */
    },
    {
        "#558844",
        0.3333333333333333, 0.5333333333333333, 0.26666666666666666,  /* rgb */
        0.13593279426265656, 0.1995650765361329, 0.08604787754401688,  /* xyz */
        51.78800251399814, -25.12644296776718, 41.66140017629008,  /* luv */
        51.78800251399814, 48.65193111132835, 121.09463495852579,  /* lch */
        121.09463495852579, 67.20690535749621, 51.78800251399814,  /* hsluv */
        121.09463495852579, 119.20933058927335, 51.78800251399814,  /* hpluv */
    },
    {
        "#558855",
        0.3333333333333333, 0.5333333333333333, 0.3333333333333333,  /* rgb */
        0.14189520830201857, 0.20195004215187773, 0.1174499248179908,  /* xyz */
        52.05697452465937, -24.867120390674227, 32.15687643332258,  /* luv */
        52.05697452465937, 40.65019530669272, 127.71501294923866,  /* lch */
        127.71501294923866, 50.453682641474565, 52.05697452465937,  /* hsluv */
        127.71501294923866, 99.08845094256445, 52.05697452465937,  /* hpluv */
    },
    {
        "#558866",
        0.3333333333333333, 0.5333333333333333, 0.4,  /* rgb */
        0.14948020407552673, 0.20498404046128102, 0.15739756922513476,  /* xyz */
        52.396100060625216, -24.57168930668605, 20.959586461113005,  /* luv */
        52.396100060625216, 32.296627997442414, 139.53590866194554,  /* lch */
        139.53590866194554, 52.77171060371225, 52.396100060625216,  /* hsluv */
        139.53590866194554, 78.21634987927833, 52.396100060625216,  /* hpluv */
    },
    {
        "#558877",
        0.3333333333333333, 0.5333333333333333, 0.4666666666666667,  /* rgb */
        0.15879421709572866, 0.20870964566936184, 0.20645137113153267,  /* xyz */
        52.80798333640284, -24.254533898193547, 8.398812338681019,  /* luv */
        52.80798333640284, 25.667537149461776, 160.90015411305166,  /* lch */
        160.90015411305166, 55.33756040285277, 52.80798333640284,  /* hsluv */
        160.90015411305166, 61.67709967041559, 52.80798333640284,  /* hpluv */
    },
    {
        "#558888",
        0.3333333333333333, 0.5333333333333333, 0.5333333333333333,  /* rgb */
        0.16993463419767246, 0.21316581251013944, 0.2651242345351048,  /* xyz */
        53.29424605436533, -23.930882865918015, -5.164007487148539,  /* luv */
        53.29424605436533, 24.4817100724115, 192.17705063006076,  /* lch */
        192.17705063006076, 58.06273144485545, 53.29424605436533,  /* hsluv */
        192.17705063006076, 58.290899124914176, 53.29424605436533,  /* hpluv */
    },
    {
        "#558899",
        0.3333333333333333, 0.5333333333333333, 0.6,  /* rgb */
        0.1829915983067452, 0.2183885981537686, 0.33389091217622274,  /* xyz */
        53.85561321973114, -23.615240150249264, -19.37538015297426,  /* luv */
        53.85561321973114, 30.5464388010487, 219.36753781469702,  /* lch */
        219.36753781469702, 60.861676067449, 53.85561321973114,  /* hsluv */
        219.36753781469702, 71.97288927937309, 53.85561321973114,  /* hpluv */
    },
    {
        "#5588aa",
        0.3333333333333333, 0.5333333333333333, 0.6666666666666666,  /* rgb */
        0.19804929127199772, 0.2244116753398697, 0.41319476179322134,  /* xyz */
        54.491995562986105, -23.32024115333264, -33.919211402446045,  /* luv */
        54.491995562986105, 41.16244100649784, 235.49057853568965,  /* lch */
        235.49057853568965, 63.65878772220752, 54.491995562986105,  /* hsluv */
        235.49057853568965, 95.85344700065285, 54.491995562986105,  /* hpluv */
    },
    {
        "#5588bb",
        0.3333333333333333, 0.5333333333333333, 0.7333333333333333,  /* rgb */
        0.2151868833793344, 0.23126671218280445, 0.503452746891863,  /* xyz */
        55.20257468039361, -23.056007996534387, -48.53384498237099,  /* luv */
        55.20257468039361, 53.731867764940716, 244.58993976984618,  /* lch */
        244.58993976984618, 66.3923972476147, 55.20257468039361,  /* hsluv */
        244.58993976984618, 123.5127893858455, 55.20257468039361,  /* hpluv */
    },
    {
        "#5588cc",
        0.3333333333333333, 0.5333333333333333, 0.8,  /* rgb */
        0.23447925882305612, 0.23898366236029325, 0.6050592575621332,  /* xyz */
        55.9858924676882, -22.82995573103292, -63.017905216644444,  /* luv */
        55.9858924676882, 67.02584021535952, 250.0856986045656,  /* lch */
        250.0856986045656, 69.01606893868527, 55.9858924676882,  /* hsluv */
        250.0856986045656, 151.91581494537095, 55.9858924676882,  /* hpluv */
    },
    {
        "#5588dd",
        0.3333333333333333, 0.5333333333333333, 0.8666666666666667,  /* rgb */
        0.2559975843736897, 0.2475909925805468, 0.7183891054621392,  /* xyz */
        56.839943937308476, -22.646932672240638, -77.22784582850386,  /* luv */
        56.839943937308476, 80.47995856591976, 253.65631585692304,  /* lch */
        253.65631585692304, 71.49789667079098, 56.839943937308476,  /* hsluv */
        253.65631585692304, 179.66911547276933, 56.839943937308476,  /* hpluv */
    },
    {
        "#5588ee",
        0.3333333333333333, 0.5333333333333333, 0.9333333333333333,  /* rgb */
        0.2798097646398644, 0.2571158646870168, 0.8437999215306624,  /* xyz */
        57.76227123443462, -22.50956185518033, -91.07049699709175,  /* luv */
        57.76227123443462, 93.81106436987851, 256.11666422549024,  /* lch */
        256.11666422549024, 85.53542860928971, 57.76227123443462,  /* hsluv */
        256.11666422549024, 206.08630299002652, 57.76227123443462,  /* hpluv */
    },
    {
        "#5588ff",
        0.3333333333333333, 0.5333333333333333, 1.0,  /* rgb */
        0.3059808130496958, 0.26758428405094953, 0.9816341098224443,  /* xyz */
        58.75005618205812, -22.418669204353407, -104.49343342177114,  /* luv */
        58.75005618205812, 106.87129809805971, 257.8909741121245,  /* lch */
        257.8909741121245, 99.99999999999885, 58.75005618205812,  /* hsluv */
        257.8909741121245, 230.82993261243016, 58.75005618205812,  /* hpluv */
    },
    {
        "#559900",
        0.3333333333333333, 0.6, 0.0,  /* rgb */
        0.15136962510033328, 0.24713116959515222, 0.039725157723606526,  /* xyz */
        56.79482350689011, -33.671363804258185, 67.09141161906658,  /* luv */
        56.79482350689011, 75.06675864507358, 116.65083595858228,  /* lch */
        116.65083595858228, 100.00000000000237, 56.79482350689011,  /* hsluv */
        116.65083595858228, 167.71744425310982, 56.79482350689011,  /* hpluv */
    },
    {
        "#559911",
        0.3333333333333333, 0.6, 0.06666666666666667,  /* rgb */
        0.1523812905999704, 0.24753583579500707, 0.045053262688362156,  /* xyz */
        56.8345345919718, -33.59601987091395, 65.42882891934654,  /* luv */
        56.8345345919718, 73.55014755202033, 117.17933155779322,  /* lch */
        117.17933155779322, 97.30733106408735, 56.8345345919718,  /* hsluv */
        117.17933155779322, 164.2141462884672, 56.8345345919718,  /* hpluv */
    },
    {
        "#559922",
        0.3333333333333333, 0.6, 0.13333333333333333,  /* rgb */
        0.1542566487384474, 0.2482859790503979, 0.054930148884341355,  /* xyz */
        56.90803403320338, -33.45890767026985, 62.392055935182626,  /* luv */
        56.90803403320338, 70.79736680348076, 118.20326717720626,  /* lch */
        118.20326717720626, 92.39710044497384, 56.90803403320338,  /* hsluv */
        118.20326717720626, 157.86390773293638, 56.90803403320338,  /* hpluv */
    },
    {
        "#559933",
        0.3333333333333333, 0.6, 0.2,  /* rgb */
        0.15734439947090517, 0.249521079343381, 0.0711923027419525,  /* xyz */
        57.02872796017387, -33.24014567165241, 57.51583166263862,  /* luv */
        57.02872796017387, 66.43025045954332, 120.02492158356685,  /* lch */
        120.02492158356685, 84.53486328769426, 57.02872796017387,  /* hsluv */
        120.02492158356685, 147.81262569191267, 57.02872796017387,  /* hpluv */
    },
    {
        "#559944",
        0.3333333333333333, 0.6, 0.26666666666666666,  /* rgb */
        0.16180239471512403, 0.2513042774410686, 0.09467107769483914,  /* xyz */
        57.20228136463383, -32.93886137235156, 50.73370458374472,  /* luv */
        57.20228136463383, 60.488654880875586, 122.99365144798546,  /* lch */
        122.99365144798546, 73.64689832330541, 57.20228136463383,  /* hsluv */
        122.99365144798546, 134.18374345360945, 57.20228136463383,  /* hpluv */
    },
    {
        "#559955",
        0.3333333333333333, 0.6, 0.3333333333333333,  /* rgb */
        0.16776480875448602, 0.2536892430568134, 0.12607312496881304,  /* xyz */
        57.43312440046566, -32.56087018536586, 42.10603651176735,  /* luv */
        57.43312440046566, 53.227141365646645, 127.71501294923925,  /* lch */
        127.71501294923925, 59.879733406636944, 57.43312440046566,  /* hsluv */
        127.71501294923925, 117.60073230492011, 57.43312440046566,  /* hpluv */
    },
    {
        "#559966",
        0.3333333333333333, 0.6, 0.4,  /* rgb */
        0.1753498045279942, 0.2567232413662167, 0.166020769375957,  /* xyz */
        57.724706403815915, -32.11752131596084, 31.797747503724285,  /* luv */
        57.724706403815915, 45.195485635091956, 135.2866535228766,  /* lch */
        135.2866535228766, 61.413313190642405, 57.724706403815915,  /* hsluv */
        135.2866535228766, 99.35109341927934, 57.724706403815915,  /* hpluv */
    },
    {
        "#559977",
        0.3333333333333333, 0.6, 0.4666666666666667,  /* rgb */
        0.1846638175481961, 0.26044884657429757, 0.2150745712823549,  /* xyz */
        58.07962957417686, -31.624170974627738, 20.050709607670385,  /* luv */
        58.07962957417686, 37.444881433963886, 147.6240294620411,  /* lch */
        147.6240294620411, 63.143291318176445, 58.07962957417686,  /* hsluv */
        147.6240294620411, 81.81029307508297, 58.07962957417686,  /* hpluv */
    },
    {
        "#559988",
        0.3333333333333333, 0.6, 0.5333333333333333,  /* rgb */
        0.19580423465013996, 0.2649050134150751, 0.2737474346859271,  /* xyz */
        58.49973279303211, -31.098420404645054, 7.15252701768072,  /* luv */
        58.49973279303211, 31.910349330627774, 167.0474274006385,  /* lch */
        167.0474274006385, 65.01914169191078, 58.49973279303211,  /* hsluv */
        167.0474274006385, 69.21767425148741, 58.49973279303211,  /* hpluv */
    },
    {
        "#559999",
        0.3333333333333333, 0.6, 0.6,  /* rgb */
        0.20886119875921266, 0.2701277990587043, 0.342514112327045,  /* xyz */
        58.98615454284064, -30.558374205696268, -6.594143395271298,  /* luv */
        58.98615454284064, 31.26174917071601, 192.17705063006093,  /* lch */
        192.17705063006093, 66.98834133820702, 58.98615454284064,  /* hsluv */
        192.17705063006093, 67.25158376676275, 58.98615454284064,  /* hpluv */
    },
    {
        "#5599aa",
        0.3333333333333333, 0.6, 0.6666666666666666,  /* rgb */
        0.22391889172446522, 0.2761508762448054, 0.4218179619440436,  /* xyz */
        59.53938842816069, -30.021157632640342, -20.89772748121837,  /* luv */
        59.53938842816069, 36.578476177707415, 214.8417759986932,  /* lch */
        214.8417759986932, 69.0007957908225, 59.53938842816069,  /* hsluv */
        214.8417759986932, 77.95797801960278, 59.53938842816069,  /* hpluv */
    },
    {
        "#5599bb",
        0.3333333333333333, 0.6, 0.7333333333333333,  /* rgb */
        0.24105648383180184, 0.28300591308774015, 0.5120759470426853,  /* xyz */
        60.15933778191915, -29.501843001072448, -35.4967885479802,  /* luv */
        60.15933778191915, 46.15604768261626, 230.26958851804108,  /* lch */
        230.26958851804108, 71.01205266808238, 60.15933778191915,  /* hsluv */
        230.26958851804108, 97.35648663474653, 60.15933778191915,  /* hpluv */
    },
    {
        "#5599cc",
        0.3333333333333333, 0.6, 0.8,  /* rgb */
        0.2603488592755236, 0.29072286326522895, 0.6136824577129555,  /* xyz */
        60.84537217748863, -29.012827927617906, -50.171288361418476,  /* luv */
        60.84537217748863, 57.95603816861683, 239.96025615222158,  /* lch */
        239.96025615222158, 72.98517943183187, 60.84537217748863,  /* hsluv */
        239.96025615222158, 120.86775743980735, 60.84537217748863,  /* hpluv */
    },
    {
        "#5599dd",
        0.3333333333333333, 0.6, 0.8666666666666667,  /* rgb */
        0.28186718482615714, 0.2993301934854825, 0.7270123056129615,  /* xyz */
        61.59638658527008, -28.56362038193467, -64.7468394355121,  /* luv */
        61.59638658527008, 70.76746163464716, 246.19491702596417,  /* lch */
        246.19491702596417, 74.89143932417932, 61.59638658527008,  /* hsluv */
        246.19491702596417, 145.7866339341696, 61.59638658527008,  /* hpluv */
    },
    {
        "#5599ee",
        0.3333333333333333, 0.6, 0.9333333333333333,  /* rgb */
        0.30567936509233185, 0.3088550655919525, 0.8524231216814847,  /* xyz */
        62.41086269977282, -28.160934947485902, -79.09359703395548,  /* luv */
        62.41086269977282, 83.9573424358243, 250.40194675158068,  /* lch */
        250.40194675158068, 83.38658076825548, 62.41086269977282,  /* hsluv */
        250.40194675158068, 170.70169116973702, 62.41086269977282,  /* hpluv */
    },
    {
        "#5599ff",
        0.3333333333333333, 0.6, 1.0,  /* rgb */
        0.33185041350216327, 0.31932348495588525, 0.9902573099732666,  /* xyz */
        63.2869312953637, -27.808990422461566, -93.12167986508759,  /* luv */
        63.2869312953637, 97.18532404232863, 253.37276117199121,  /* lch */
        253.37276117199121, 99.99999999999862, 63.2869312953637,  /* hsluv */
        253.37276117199121, 194.8614705946752, 63.2869312953637,  /* hpluv */
    },
    {
        "#55aa00",
        0.3333333333333333, 0.6666666666666666, 0.0,  /* rgb */
        0.18120324472990257, 0.3067984088542916, 0.04966969760012934,  /* xyz */
        62.236429739195074, -41.161095515455166, 74.03809971763334,  /* luv */
        62.236429739195074, 84.71054240075813, 119.07164282044113,  /* lch */
        119.07164282044113, 100.00000000000216, 62.236429739195074,  /* hsluv */
        119.07164282044113, 172.71581972238147, 62.236429739195074,  /* hpluv */
    },
    {
        "#55aa11",
        0.3333333333333333, 0.6666666666666666, 0.06666666666666667,  /* rgb */
        0.1822149102295397, 0.30720307505414646, 0.05499780256488497,  /* xyz */
        62.270812500354296, -41.07650575629562, 72.56443177691878,  /* luv */
        62.270812500354296, 83.38390782551564, 119.51287337073872,  /* lch */
        119.51287337073872, 97.82609876320466, 62.270812500354296,  /* hsluv */
        119.51287337073872, 169.9170810366022, 62.270812500354296,  /* hpluv */
    },
    {
        "#55aa22",
        0.3333333333333333, 0.6666666666666666, 0.13333333333333333,  /* rgb */
        0.1840902683680167, 0.30795321830953726, 0.06487468876086416,  /* xyz */
        62.33446919424338, -40.92195601876251, 69.86514519555803,  /* luv */
        62.33446919424338, 80.9675552156414, 120.35869089992791,  /* lch */
        120.35869089992791, 93.84933856368377, 62.33446919424338,  /* hsluv */
        120.35869089992791, 164.82462146417632, 62.33446919424338,  /* hpluv */
    },
    {
        "#55aa33",
        0.3333333333333333, 0.6666666666666666, 0.2,  /* rgb */
        0.18717801910047444, 0.3091883186025204, 0.08113684261847531,  /* xyz */
        62.43905420048513, -40.673707977531414, 65.51035437607051,  /* luv */
        62.43905420048513, 77.11003210425893, 121.83509099860194,  /* lch */
        121.83509099860194, 87.4478443822902, 62.43905420048513,  /* hsluv */
        121.83509099860194, 156.70898385029096, 62.43905420048513,  /* hpluv */
    },
    {
        "#55aa44",
        0.3333333333333333, 0.6666666666666666, 0.26666666666666666,  /* rgb */
        0.19163601434469332, 0.31097151670020795, 0.10461561757136195,  /* xyz */
        62.58956046084272, -40.328369035033596, 59.41152640035663,  /* luv */
        62.58956046084272, 71.80603608504043, 124.16854516794946,  /* lch */
        124.16854516794946, 78.51312627682336, 62.58956046084272,  /* hsluv */
        124.16854516794946, 145.57888132761838, 62.58956046084272,  /* hpluv */
    },
    {
        "#55aa55",
        0.3333333333333333, 0.6666666666666666, 0.3333333333333333,  /* rgb */
        0.19759842838405534, 0.3133564823159528, 0.13601766484533587,  /* xyz */
        62.78996066181473, -39.88922564954042, 51.58268750386547,  /* luv */
        62.78996066181473, 65.20677858199554, 127.71501294923955,  /* lch */
        127.71501294923955, 67.09832715433396, 62.78996066181473,  /* hsluv */
        127.71501294923955, 131.77768104275194, 62.78996066181473,  /* hpluv */
    },
    {
        "#55aa66",
        0.3333333333333333, 0.6666666666666666, 0.4,  /* rgb */
        0.2051834241575635, 0.31639048062535613, 0.17596530925247983,  /* xyz */
        63.04343259572434, -39.365339791116774, 42.12583761904019,  /* luv */
        63.04343259572434, 57.6560159218084, 133.05985846145427,  /* lch */
        133.05985846145427, 68.13684005995603, 63.04343259572434,  /* hsluv */
        133.05985846145427, 116.04972184797764, 63.04343259572434,  /* hpluv */
    },
    {
        "#55aa77",
        0.3333333333333333, 0.6666666666666666, 0.4666666666666667,  /* rgb */
        0.21449743717776543, 0.3201160858334369, 0.22501911115887774,  /* xyz */
        63.352477125031086, -38.77036753512123, 31.21331843641635,  /* luv */
        63.352477125031086, 49.773613959823244, 141.16309023888363,  /* lch */
        141.16309023888363, 69.32575108199967, 63.352477125031086,  /* hsluv */
        141.16309023888363, 99.69534965446509, 63.352477125031086,  /* hpluv */
    },
    {
        "#55aa88",
        0.3333333333333333, 0.6666666666666666, 0.5333333333333333,  /* rgb */
        0.22563785427970923, 0.3245722526742145, 0.2836919745624499,  /* xyz */
        63.71898963870359, -38.12111435403713, 19.06684462682818,  /* luv */
        63.71898963870359, 42.62351374085884, 153.4273893257347,  /* lch */
        153.4273893257347, 70.63624991771748, 63.71898963870359,  /* hsluv */
        153.4273893257347, 84.88279947741098, 63.71898963870359,  /* hpluv */
    },
    {
        "#55aa99",
        0.3333333333333333, 0.6666666666666666, 0.6,  /* rgb */
        0.23869481838878195, 0.3297950383178437, 0.3524586522035678,  /* xyz */
        64.14431015748315, -37.43598485696849, 5.935219435870481,  /* luv */
        64.14431015748315, 37.90355909361427, 170.99112864761366,  /* lch */
        170.99112864761366, 72.03646739911599, 64.14431015748315,  /* hsluv */
        170.99112864761366, 74.98271806610792, 64.14431015748315,  /* hpluv */
    },
    {
        "#55aaaa",
        0.3333333333333333, 0.6666666666666666, 0.6666666666666666,  /* rgb */
        0.2537525113540345, 0.3358181155039448, 0.4317625018205664,  /* xyz */
        64.62926408626109, -36.73351796535695, -7.926667932196027,  /* luv */
        64.62926408626109, 37.57902881420044, 192.177050630061,  /* lch */
        192.177050630061, 73.49408309278948, 64.62926408626109,  /* hsluv */
        192.177050630061, 73.7828909738526, 64.62926408626109,  /* hpluv */
    },
    {
        "#55aabb",
        0.3333333333333333, 0.6666666666666666, 0.7333333333333333,  /* rgb */
        0.27089010346137116, 0.34267315234687956, 0.5220204869192081,  /* xyz */
        65.17419974346625, -36.031166113129615, -22.275375152081335,  /* luv */
        65.17419974346625, 42.36079873701513, 211.72540159550186,  /* lch */
        211.72540159550186, 74.9784994025983, 65.17419974346625,  /* hsluv */
        211.72540159550186, 82.47603221899602, 65.17419974346625,  /* hpluv */
    },
    {
        "#55aacc",
        0.3333333333333333, 0.6666666666666666, 0.8,  /* rgb */
        0.29018247890509286, 0.35039010252436836, 0.6236269975894783,  /* xyz */
        65.77902578711483, -35.34441111835192, -36.891687858145524,  /* luv */
        65.77902578711483, 51.09035163635029, 226.22707169793765,  /* lch */
        226.22707169793765, 76.4624197891718, 65.77902578711483,  /* hsluv */
        226.22707169793765, 98.55775019573258, 65.77902578711483,  /* hpluv */
    },
    {
        "#55aadd",
        0.3333333333333333, 0.6666666666666666, 0.8666666666666667,  /* rgb */
        0.31170080445572645, 0.35899743274462187, 0.7369568454894843,  /* xyz */
        66.44324994788781, -34.68623816365237, -51.58835794257844,  /* luv */
        66.44324994788781, 62.16505282839556, 236.0844703112757,  /* lch */
        236.0844703112757, 77.92279391551929, 66.44324994788781,  /* hsluv */
        236.0844703112757, 118.72297385107488, 66.44324994788781,  /* hpluv */
    },
    {
        "#55aaee",
        0.3333333333333333, 0.6666666666666666, 0.9333333333333333,  /* rgb */
        0.33551298472190116, 0.3685223048510919, 0.8623676615580075,  /* xyz */
        67.16601944767753, -34.06693260241909, -66.21330004629748,  /* luv */
        67.16601944767753, 74.46312510201798, 242.7740498940467,  /* lch */
        242.7740498940467, 80.75509154230801, 67.16601944767753,  /* hsluv */
        242.7740498940467, 140.6795513397087, 67.16601944767753,  /* hpluv */
    },
    {
        "#55aaff",
        0.3333333333333333, 0.6666666666666666, 1.0,  /* rgb */
        0.3616840331317326, 0.3789907242150246, 1.0002018498497893,  /* xyz */
        67.94616285023751, -33.49413075756465, -80.64921551408429,  /* luv */
        67.94616285023751, 87.3278464079016, 247.44657821333007,  /* lch */
        247.44657821333007, 99.9999999999981, 67.94616285023751,  /* hsluv */
        247.44657821333007, 163.08992799717922, 67.94616285023751,  /* hpluv */
    },
    {
        "#55bb00",
        0.3333333333333333, 0.7333333333333333, 0.0,  /* rgb */
        0.21515774263850135, 0.37470740467149016, 0.06098786356966196,  /* xyz */
        67.62871320515221, -48.212053221974884, 80.87671509495874,  /* luv */
        67.62871320515221, 94.15649271521144, 120.79992415926164,  /* lch */
        120.79992415926164, 100.00000000000225, 67.62871320515221,  /* hsluv */
        120.79992415926164, 176.66823707672825, 67.62871320515221,  /* hpluv */
    },
    {
        "#55bb11",
        0.3333333333333333, 0.7333333333333333, 0.06666666666666667,  /* rgb */
        0.21616940813813848, 0.375112070871345, 0.0663159685344176,  /* xyz */
        67.65880738705924, -48.1245535730997, 79.5614112615755,  /* luv */
        67.65880738705924, 92.983820197622, 121.16861322374334,  /* lch */
        121.16861322374334, 98.21704845278929, 67.65880738705924,  /* hsluv */
        121.16861322374334, 174.39031946251075, 67.65880738705924,  /* hpluv */
    },
    {
        "#55bb22",
        0.3333333333333333, 0.7333333333333333, 0.13333333333333333,  /* rgb */
        0.21804476627661548, 0.3758622141267358, 0.07619285473039679,  /* xyz */
        67.7145367797011, -47.96424243898937, 77.14706519879803,  /* luv */
        67.7145367797011, 90.84183079140217, 121.8702408444057,  /* lch */
        121.8702408444057, 94.94768711570984, 67.7145367797011,  /* hsluv */
        121.8702408444057, 170.23281973627945, 67.7145367797011,  /* hpluv */
    },
    {
        "#55bb33",
        0.3333333333333333, 0.7333333333333333, 0.2,  /* rgb */
        0.22113251700907322, 0.37709731441971894, 0.09245500858800793,  /* xyz */
        67.80613311193946, -47.70552269077321, 73.23798020908161,  /* luv */
        67.80613311193946, 87.40491199186523, 123.07928856311989,  /* lch */
        123.07928856311989, 89.66369543687635, 67.80613311193946,  /* hsluv */
        123.07928856311989, 163.57095469780967, 67.80613311193946,  /* hpluv */
    },
    {
        "#55bb44",
        0.3333333333333333, 0.7333333333333333, 0.26666666666666666,  /* rgb */
        0.2255905122532921, 0.3788805125174065, 0.11593378354089456,  /* xyz */
        67.93802479171147, -47.34307585470112, 67.73433563490373,  /* luv */
        67.93802479171147, 82.63962158242119, 124.95171609649913,  /* lch */
        124.95171609649913, 82.24461525829352, 67.93802479171147,  /* hsluv */
        124.95171609649913, 154.35287750025358, 67.93802479171147,  /* hpluv */
    },
    {
        "#55bb55",
        0.3333333333333333, 0.7333333333333333, 0.3333333333333333,  /* rgb */
        0.23155292629265412, 0.38126547813315137, 0.14733583081486848,  /* xyz */
        68.1137800414251, -46.87779667453444, 60.619946799095096,  /* luv */
        68.1137800414251, 76.63097135613062, 127.71501294923974,  /* lch */
        127.71501294923974, 72.69064234208122, 68.1137800414251,  /* hsluv */
        127.71501294923974, 142.7607019071391, 68.1137800414251,  /* hpluv */
    },
    {
        "#55bb66",
        0.3333333333333333, 0.7333333333333333, 0.4,  /* rgb */
        0.23913792206616227, 0.3842994764425547, 0.18728347522201244,  /* xyz */
        68.33630836676407, -46.3160914021311, 51.95202169866877,  /* luv */
        68.33630836676407, 69.60023621619048, 131.7175348163948,  /* lch */
        131.7175348163948, 73.40998391456564, 68.33630836676407,  /* hsluv */
        131.7175348163948, 129.24046926456677, 68.33630836676407,  /* hpluv */
    },
    {
        "#55bb77",
        0.3333333333333333, 0.7333333333333333, 0.4666666666666667,  /* rgb */
        0.2484519350863642, 0.3880250816506355, 0.23633727712841035,  /* xyz */
        68.60796618311724, -45.6690129611091, 41.849627308459596,  /* luv */
        68.60796618311724, 61.94392666516159, 137.49884951329724,  /* lch */
        137.49884951329724, 74.24308744677087, 68.60796618311724,  /* hsluv */
        137.49884951329724, 114.56804790844166, 68.60796618311724,  /* hpluv */
    },
    {
        "#55bb88",
        0.3333333333333333, 0.7333333333333333, 0.5333333333333333,  /* rgb */
        0.259592352188308, 0.3924812484914131, 0.2950101405319825,  /* xyz */
        68.93061977888703, -44.95116779196814, 30.479650362833006,  /* luv */
        68.93061977888703, 54.31037260139374, 145.86032052764796,  /* lch */
        145.86032052764796, 75.17346886655007, 68.93061977888703,  /* hsluv */
        145.86032052764796, 99.97926171570384, 68.93061977888703,  /* hpluv */
    },
    {
        "#55bb99",
        0.3333333333333333, 0.7333333333333333, 0.6,  /* rgb */
        0.27264931629738076, 0.39770403413504224, 0.3637768181731004,  /* xyz */
        69.30568761459192, -44.17946974214668, 18.041019110468056,  /* luv */
        69.30568761459192, 47.72110557438425, 157.78698111338483,  /* lch */
        157.78698111338483, 76.18183061731878, 69.30568761459192,  /* hsluv */
        157.78698111338483, 87.37374411753447, 69.30568761459192,  /* hpluv */
    },
    {
        "#55bbaa",
        0.3333333333333333, 0.7333333333333333, 0.6666666666666666,  /* rgb */
        0.28770700926263326, 0.40372711132114336, 0.443080667790099,  /* xyz */
        69.73417255116374, -43.37186937951342, 4.748697257870348,  /* luv */
        69.73417255116374, 43.63105750632775, 173.75169042530246,  /* lch */
        173.75169042530246, 77.24755434235142, 69.73417255116374,  /* hsluv */
        173.75169042530246, 79.39431641610017, 69.73417255116374,  /* hpluv */
    },
    {
        "#55bbbb",
        0.3333333333333333, 0.7333333333333333, 0.7333333333333333,  /* rgb */
        0.30484460136996994, 0.4105821481640781, 0.5333386528887407,  /* xyz */
        70.21668957715876, -42.54618913897857, -9.180975081209148,  /* luv */
        70.21668957715876, 43.52549268752189, 192.17705063006107,  /* lch */
        192.17705063006107, 78.35006842944019, 70.21668957715876,  /* hsluv */
        192.17705063006107, 78.65795875600823, 70.21668957715876,  /* hpluv */
    },
    {
        "#55bbcc",
        0.3333333333333333, 0.7333333333333333, 0.8,  /* rgb */
        0.3241369768136917, 0.4182990983415669, 0.6349451635590109,  /* xyz */
        70.75349206925439, -41.71916464032718, -23.542372190503585,  /* luv */
        70.75349206925439, 47.90336091176612, 209.4362950848068,  /* lch */
        209.4362950848068, 79.46997414439664, 70.75349206925439,  /* hsluv */
        209.4362950848068, 85.91271261322728, 70.75349206925439,  /* hpluv */
    },
    {
        "#55bbdd",
        0.3333333333333333, 0.7333333333333333, 0.8666666666666667,  /* rgb */
        0.3456553023643252, 0.42690642856182043, 0.7482750114590169,  /* xyz */
        71.34449819924707, -40.90574740370157, -38.14943270040396,  /* luv */
        71.34449819924707, 55.93442040477481, 223.00315104306767,  /* lch */
        223.00315104306767, 80.5898663629362, 71.34449819924707,  /* hsluv */
        223.00315104306767, 99.48508631421001, 71.34449819924707,  /* hpluv */
    },
    {
        "#55bbee",
        0.3333333333333333, 0.7333333333333333, 0.9333333333333333,  /* rgb */
        0.36946748263049994, 0.43643130066829044, 0.8736858275275401,  /* xyz */
        71.9893182406489, -40.118678797636385, -52.84115246249183,  /* luv */
        71.9893182406489, 66.34527701375754, 232.79307917301458,  /* lch */
        232.79307917301458, 81.69483767582969, 71.9893182406489,  /* hsluv */
        232.79307917301458, 116.94489750291253, 71.9893182406489,  /* hpluv */
    },
    {
        "#55bbff",
        0.3333333333333333, 0.7333333333333333, 1.0,  /* rgb */
        0.3956385310403313, 0.44689972003222317, 1.011520015819322,  /* xyz */
        72.68728298340484, -39.36830935883178, -67.48404268165048,  /* luv */
        72.68728298340484, 78.12784265824511, 239.74190456759862,  /* lch */
        239.74190456759862, 99.99999999999761, 72.68728298340484,  /* hsluv */
        239.74190456759862, 136.39131713467242, 72.68728298340484,  /* hpluv */
    },
    {
        "#55cc00",
        0.3333333333333333, 0.8, 0.0,  /* rgb */
        0.25338148594811827, 0.45115489129072506, 0.07372911133953391,  /* xyz */
        72.9678739916599, -54.90092346620341, 87.61236966737447,  /* luv */
        72.9678739916599, 103.39264343353737, 122.0726728346537,  /* lch */
        122.0726728346537, 100.00000000000244, 72.9678739916599,  /* hsluv */
        122.0726728346537, 179.80314043337398, 72.9678739916599,  /* hpluv */
    },
    {
        "#55cc11",
        0.3333333333333333, 0.8, 0.06666666666666667,  /* rgb */
        0.2543931514477554, 0.4515595574905799, 0.07905721630428955,  /* xyz */
        72.99446613948075, -54.81402053240801, 86.43077861367814,  /* luv */
        72.99446613948075, 102.34674561848017, 122.38269100313389,  /* lch */
        122.38269100313389, 98.51723388867578, 72.99446613948075,  /* hsluv */
        122.38269100313389, 177.9194500917507, 72.99446613948075,  /* hpluv */
    },
    {
        "#55cc22",
        0.3333333333333333, 0.8, 0.13333333333333333,  /* rgb */
        0.25626850958623243, 0.4523097007459707, 0.08893410250026874,  /* xyz */
        73.04371890096479, -54.654474549663966, 84.25831308368751,  /* luv */
        73.04371890096479, 100.43194169191679, 122.96961144858444,  /* lch */
        122.96961144858444, 95.7933392549395, 73.04371890096479,  /* hsluv */
        122.96961144858444, 174.47303235442777, 73.04371890096479,  /* hpluv */
    },
    {
        "#55cc33",
        0.3333333333333333, 0.8, 0.2,  /* rgb */
        0.25935626031869013, 0.45354480103895384, 0.10519625635787988,  /* xyz */
        73.12469437042877, -54.39608712759364, 80.73108898751151,  /* luv */
        73.12469437042877, 97.3470237033586, 123.97183561512011,  /* lch */
        123.97183561512011, 91.37726978104035, 73.12469437042877,  /* hsluv */
        123.97183561512011, 168.92656087759536, 73.12469437042877,  /* hpluv */
    },
    {
        "#55cc44",
        0.3333333333333333, 0.8, 0.26666666666666666,  /* rgb */
        0.26381425556290905, 0.4553279991366414, 0.12867503131076652,  /* xyz */
        73.2413452172043, -54.03220801508878, 75.74460982443334,  /* luv */
        73.2413452172043, 93.04152524782398, 125.50205694383394,  /* lch */
        125.50205694383394, 85.14814084276895, 73.2413452172043,  /* hsluv */
        125.50205694383394, 161.19806913180835, 73.2413452172043,  /* hpluv */
    },
    {
        "#55cc55",
        0.3333333333333333, 0.8, 0.3333333333333333,  /* rgb */
        0.26977666960227104, 0.45771296475238626, 0.16007707858474043,  /* xyz */
        73.39688657794869, -53.56178511200331, 69.26333561487571,  /* luv */
        73.39688657794869, 87.55726403265082, 127.71501294923992,  /* lch */
        127.71501294923992, 77.0768048277098, 73.39688657794869,  /* hsluv */
        127.71501294923992, 151.3749005846026, 73.39688657794869,  /* hpluv */
    },
    {
        "#55cc66",
        0.3333333333333333, 0.8, 0.4,  /* rgb */
        0.2773616653757792, 0.4607469630617896, 0.2000247229918844,  /* xyz */
        73.5939772793636, -52.9887999422805, 61.31294498267692,  /* luv */
        73.5939772793636, 81.03758474789208, 130.83472777876958,  /* lch */
        130.83472777876958, 77.58578831840828, 73.5939772793636,  /* hsluv */
        130.83472777876958, 139.728031568505, 73.5939772793636,  /* hpluv */
    },
    {
        "#55cc77",
        0.3333333333333333, 0.8, 0.4666666666666667,  /* rgb */
        0.2866756783959811, 0.4644725682698704, 0.2490785248982823,  /* xyz */
        73.83481527618486, -52.3216404431773, 51.97251535283888,  /* luv */
        73.83481527618486, 73.74751799732789, 135.19179712735053,  /* lch */
        135.19179712735053, 78.18069781069808, 73.83481527618486,  /* hsluv */
        135.19179712735053, 126.74345519043962, 73.83481527618486,  /* hpluv */
    },
    {
        "#55cc88",
        0.3333333333333333, 0.8, 0.5333333333333333,  /* rgb */
        0.2978160954979249, 0.468928735110648, 0.30775138830185444,  /* xyz */
        74.12119421272106, -51.57230230851783, 41.365042443331134,  /* luv */
        74.12119421272106, 66.11179245595856, 141.2676448066626,  /* lch */
        141.2676448066626, 78.85206484128376, 74.12119421272106,  /* hsluv */
        141.2676448066626, 113.1816056490522, 74.12119421272106,  /* hpluv */
    },
    {
        "#55cc99",
        0.3333333333333333, 0.8, 0.6,  /* rgb */
        0.3108730596069976, 0.47415152075427713, 0.3765180659429724,  /* xyz */
        74.4545405069311, -50.7554383804248, 29.646377947024483,  /* luv */
        74.4545405069311, 58.77943731073749, 149.71069301812025,  /* lch */
        149.71069301812025, 79.58817326100304, 74.4545405069311,  /* hsluv */
        149.71069301812025, 100.17827820780956, 74.4545405069311,  /* hpluv */
    },
    {
        "#55ccaa",
        0.3333333333333333, 0.8, 0.6666666666666666,  /* rgb */
        0.3259307525722502, 0.48017459794037826, 0.455821915559971,  /* xyz */
        74.83594033291888, -49.88733159715699, 16.99337365820891,  /* luv */
        74.83594033291888, 52.702187830982936, 161.18935777781888,  /* lch */
        161.18935777781888, 80.37590732897381, 74.83594033291888,  /* hsluv */
        161.18935777781888, 89.36300224991638, 74.83594033291888,  /* hpluv */
    },
    {
        "#55ccbb",
        0.3333333333333333, 0.8, 0.7333333333333333,  /* rgb */
        0.34306834467958686, 0.487029634783313, 0.5460799006586128,  /* xyz */
        75.2661614985634, -48.98488499563054, 3.5922566505954743,  /* luv */
        75.2661614985634, 49.11642562197393, 175.80578027240836,  /* lch */
        175.80578027240836, 81.20158465857342, 75.2661614985634,  /* hsluv */
        175.80578027240836, 82.80685922575236, 75.2661614985634,  /* hpluv */
    },
    {
        "#55cccc",
        0.3333333333333333, 0.8, 0.8,  /* rgb */
        0.36236072012330856, 0.4947465849608018, 0.6476864113288829,  /* xyz */
        75.74567303246829, -48.064714764734006, -10.371809026161898,  /* luv */
        75.74567303246829, 49.17104054105844, 192.1770506300611,  /* lch */
        192.1770506300611, 82.05170400665328, 75.74567303246829,  /* hsluv */
        192.1770506300611, 82.37414055901986, 75.74567303246829,  /* hpluv */
    },
    {
        "#55ccdd",
        0.3333333333333333, 0.8, 0.8666666666666667,  /* rgb */
        0.38387904567394215, 0.5033539151810553, 0.7610162592288889,  /* xyz */
        76.27466408829333, -47.14240902398021, -24.723274529652546,  /* luv */
        76.27466408829333, 53.23201134705335, 207.6742279096848,  /* lch */
        207.6742279096848, 82.91355680361993, 76.27466408829333,  /* hsluv */
        207.6742279096848, 89.8673986045394, 76.27466408829333,  /* hpluv */
    },
    {
        "#55ccee",
        0.3333333333333333, 0.8, 0.9333333333333333,  /* rgb */
        0.40769122594011686, 0.5128787872875253, 0.8864270752974122,  /* xyz */
        76.85306305137897, -46.23198509376937, -39.30250686007222,  /* luv */
        76.85306305137897, 60.68017379009833, 220.36836367031083,  /* lch */
        220.36836367031083, 83.77567572759229, 76.85306305137897,  /* hsluv */
        220.36836367031083, 105.55411204702996, 76.85306305137897,  /* hpluv */
    },
    {
        "#55ccff",
        0.3333333333333333, 0.8, 1.0,  /* rgb */
        0.4338622743499483, 0.5233472066514581, 1.024261263589194,  /* xyz */
        77.48055727248978, -45.34554927124664, -53.969795504012644,  /* luv */
        77.48055727248978, 70.49083391091355, 229.9629437526429,  /* lch */
        229.9629437526429, 99.99999999999689, 77.48055727248978,  /* hsluv */
        229.9629437526429, 126.75441260172103, 77.48055727248978,  /* hpluv */
    },
    {
        "#55dd00",
        0.3333333333333333, 0.8666666666666667, 0.0,  /* rgb */
        0.2960154764952935, 0.5364228723850766, 0.08794044152192523,  /* xyz */
        78.25268950579081, -61.28862707900045, 94.25111663736833,  /* luv */
        78.25268950579081, 112.42583687311202, 123.03472145311792,  /* lch */
        123.03472145311792, 100.00000000000229, 78.25268950579081,  /* hsluv */
        123.03472145311792, 210.80043363140524, 78.25268950579081,  /* hpluv */
    },
    {
        "#55dd11",
        0.3333333333333333, 0.8666666666666667, 0.06666666666666667,  /* rgb */
        0.2970271419949306, 0.5368275385849315, 0.09326854648668087,  /* xyz */
        78.27638430130591, -61.20421629926551, 93.18328145290204,  /* luv */
        78.27638430130591, 111.48578400467943, 123.29752633429607,  /* lch */
        123.29752633429607, 98.75165988565556, 78.27638430130591,  /* hsluv */
        123.29752633429607, 209.31042132221344, 78.27638430130591,  /* hpluv */
    },
    {
        "#55dd22",
        0.3333333333333333, 0.8666666666666667, 0.13333333333333333,  /* rgb */
        0.29890250013340763, 0.5375776818403223, 0.10314543268266006,  /* xyz */
        78.32027665866264, -61.049001441327974, 91.21744268128462,  /* luv */
        78.32027665866264, 109.76157080826017, 123.79316628238006,  /* lch */
        123.79316628238006, 96.45513501576022, 78.32027665866264,  /* hsluv */
        123.79316628238006, 206.57199507209273, 78.32027665866264,  /* hpluv */
    },
    {
        "#55dd33",
        0.3333333333333333, 0.8666666666666667, 0.2,  /* rgb */
        0.30199025086586534, 0.5388127821333054, 0.1194075865402712,  /* xyz */
        78.39245593128409, -60.79695360298418, 88.01873731772493,  /* luv */
        78.39245593128409, 106.97461234521991, 124.6339004660476,  /* lch */
        124.6339004660476, 92.72288178405194, 78.39245593128409,  /* hsluv */
        124.6339004660476, 202.13053805610633, 78.39245593128409,  /* hpluv */
    },
    {
        "#55dd44",
        0.3333333333333333, 0.8666666666666667, 0.26666666666666666,  /* rgb */
        0.30644824611008425, 0.540595980230993, 0.14288636149315784,  /* xyz */
        78.49647171615013, -60.440574410157176, 83.4819993500804,  /* luv */
        78.49647171615013, 103.06457805917886, 125.90436139092331,  /* lch */
        125.90436139092331, 87.43919703631232, 78.49647171615013,  /* hsluv */
        125.90436139092331, 195.86738587697644, 78.49647171615013,  /* hpluv */
    },
    {
        "#55dd55",
        0.3333333333333333, 0.8666666666666667, 0.3333333333333333,  /* rgb */
        0.31241066014944624, 0.5429809458467377, 0.17428840876713175,  /* xyz */
        78.63523228696806, -59.9773394353739, 77.55959929103707,  /* luv */
        78.63523228696806, 98.04474839547652, 127.71501294923998,  /* lch */
        127.71501294923998, 80.55941816056749, 78.63523228696806,  /* hsluv */
        127.71501294923998, 187.77143549512704, 78.63523228696806,  /* hpluv */
    },
    {
        "#55dd66",
        0.3333333333333333, 0.8666666666666667, 0.4,  /* rgb */
        0.3199956559229544, 0.546014944156141, 0.21423605317427571,  /* xyz */
        78.81116848252285, -59.409221125521455, 70.2551951590567,  /* luv */
        78.81116848252285, 92.00678236727035, 130.2185396362355,  /* lch */
        130.2185396362355, 80.92673378643427, 78.81116848252285,  /* hsluv */
        130.2185396362355, 177.9513887679854, 78.81116848252285,  /* hpluv */
    },
    {
        "#55dd77",
        0.3333333333333333, 0.8666666666666667, 0.4666666666666667,  /* rgb */
        0.32930966894315633, 0.5497405493642219, 0.2632898550806736,  /* xyz */
        79.02632048322619, -58.742226054294704, 61.61818617048712,  /* luv */
        79.02632048322619, 85.13195633106683, 133.6312025364067,  /* lch */
        133.6312025364067, 81.3592233632428, 79.02632048322619,  /* hsluv */
        133.6312025364067, 166.66460441184762, 79.02632048322619,  /* hpluv */
    },
    {
        "#55dd88",
        0.3333333333333333, 0.8666666666666667, 0.5333333333333333,  /* rgb */
        0.34045008604510013, 0.5541967162049994, 0.3219627184842458,  /* xyz */
        79.2823892178289, -57.98581754151869, 51.7371982221375,  /* luv */
        79.2823892178289, 77.71159962216093, 138.25941847017913,  /* lch */
        138.25941847017913, 81.8514411788724, 79.2823892178289,  /* hsluv */
        138.25941847017913, 154.37110204601183, 79.2823892178289,  /* hpluv */
    },
    {
        "#55dd99",
        0.3333333333333333, 0.8666666666666667, 0.6,  /* rgb */
        0.35350705015417283, 0.5594195018486287, 0.3907293961253637,  /* xyz */
        79.58076964922985, -57.152209272179974, 40.73232511818856,  /* luv */
        79.58076964922985, 70.18188750828001, 144.52256409497076,  /* lch */
        144.52256409497076, 82.39624409461285, 79.58076964922985,  /* hsluv */
        144.52256409497076, 141.82803097961914, 79.58076964922985,  /* hpluv */
    },
    {
        "#55ddaa",
        0.3333333333333333, 0.8666666666666667, 0.6666666666666666,  /* rgb */
        0.3685647431194254, 0.5654425790347297, 0.47003324574236227,  /* xyz */
        79.9225742847085, -56.255567654949814, 28.746467837281227,  /* luv */
        79.9225742847085, 63.17474420447209, 152.9330703370029,  /* lch */
        152.9330703370029, 82.98527547073803, 79.9225742847085,  /* hsluv */
        152.9330703370029, 130.23682451213813, 79.9225742847085,  /* hpluv */
    },
    {
        "#55ddbb",
        0.3333333333333333, 0.8666666666666667, 0.7333333333333333,  /* rgb */
        0.38570233522676206, 0.5722976158776645, 0.5602912308410041,  /* xyz */
        80.30865138577305, -55.31118384676049, 15.936388632898726,  /* luv */
        80.30865138577305, 57.561232971409865, 163.92712610593478,  /* lch */
        163.92712610593478, 83.6094665313934, 80.30865138577305,  /* hsluv */
        163.92712610593478, 121.40658022985147, 80.30865138577305,  /* hpluv */
    },
    {
        "#55ddcc",
        0.3333333333333333, 0.8666666666666667, 0.8,  /* rgb */
        0.40499471067048376, 0.5800145660551533, 0.6618977415112742,  /* xyz */
        80.73960044094827, -54.33468058988831, 2.4641553330808224,  /* luv */
        80.73960044094827, 54.39052836947565, 177.40333386087704,  /* lch */
        177.40333386087704, 84.25951628766747, 80.73960044094827,  /* hsluv */
        177.40333386087704, 117.73427745544555, 80.73960044094827,  /* hpluv */
    },
    {
        "#55dddd",
        0.3333333333333333, 0.8666666666666667, 0.8666666666666667,  /* rgb */
        0.42651303622111736, 0.5886218962754068, 0.7752275894112802,  /* xyz */
        81.21578642084016, -53.341310006075076, -11.51043719485958,  /* luv */
        81.21578642084016, 54.569089396663124, 192.1770506300611,  /* lch */
        192.1770506300611, 84.92631641510638, 81.21578642084016,  /* hsluv */
        192.1770506300611, 121.62521100073165, 81.21578642084016,  /* hpluv */
    },
    {
        "#55ddee",
        0.3333333333333333, 0.8666666666666667, 0.9333333333333333,  /* rgb */
        0.45032521648729207, 0.5981467683818769, 0.9006384054798034,  /* xyz */
        81.73735371635685, -52.34538161366926, -25.83605675280026,  /* luv */
        81.73735371635685, 58.37414500285704, 206.269517439458,  /* lch */
        206.269517439458, 85.60129756492884, 81.73735371635685,  /* hsluv */
        206.269517439458, 134.43668727045923, 81.73735371635685,  /* hpluv */
    },
    {
        "#55ddff",
        0.3333333333333333, 0.8666666666666667, 1.0,  /* rgb */
        0.4764962648971235, 0.6086151877458096, 1.0384725937715853,  /* xyz */
        82.30424027005508, -51.35984015250143, -40.374429801293,  /* luv */
        82.30424027005508, 65.32937901335076, 218.17120505081962,  /* lch */
        218.17120505081962, 99.99999999999581, 82.30424027005508,  /* hsluv */
        218.17120505081962, 156.0467738188682, 82.30424027005508,  /* hpluv */
    },
    {
        "#55ee00",
        0.3333333333333333, 0.9333333333333333, 0.0,  /* rgb */
        0.3431942528358083, 0.6307804250661075, 0.10366670030209642,  /* xyz */
        83.48342416784813, -67.423446821455, 100.79912152497583,  /* luv */
        83.48342416784813, 121.26988118033438, 123.77813801339137,  /* lch */
        123.77813801339137, 100.0000000000024, 83.48342416784813,  /* hsluv */
        123.77813801339137, 313.5428751787019, 83.48342416784813,  /* hpluv */
    },
    {
        "#55ee11",
        0.3333333333333333, 0.9333333333333333, 0.06666666666666667,  /* rgb */
        0.3442059183354454, 0.6311850912659625, 0.10899480526685205,  /* xyz */
        83.50469357308245, -67.34249686487765, 99.82879154146154,  /* luv */
        83.50469357308245, 120.41926550442267, 124.00281120188602,  /* lch */
        124.00281120188602, 98.93754126241066, 83.50469357308245,  /* hsluv */
        124.00281120188602, 311.80236567126093, 83.50469357308245,  /* hpluv */
    },
    {
        "#55ee22",
        0.3333333333333333, 0.9333333333333333, 0.13333333333333333,  /* rgb */
        0.34608127647392245, 0.6319352345213533, 0.11887169146283125,  /* xyz */
        83.54409734709559, -67.19346221903675, 98.04063026254087,  /* luv */
        83.54409734709559, 118.85674800892612, 124.42531359841453,  /* lch */
        124.42531359841453, 96.98075878000331, 83.54409734709559,  /* hsluv */
        124.42531359841453, 308.59848358059196, 83.54409734709559,  /* hpluv */
    },
    {
        "#55ee33",
        0.3333333333333333, 0.9333333333333333, 0.2,  /* rgb */
        0.34916902720638016, 0.6331703348143364, 0.1351338453204424,  /* xyz */
        83.60890722270855, -66.95094130972424, 95.12597758809645,  /* luv */
        83.60890722270855, 116.32446068797897, 125.13839783227029,  /* lch */
        125.13839783227029, 93.79450512258221, 83.60890722270855,  /* hsluv */
        125.13839783227029, 303.3876037474342, 83.60890722270855,  /* hpluv */
    },
    {
        "#55ee44",
        0.3333333333333333, 0.9333333333333333, 0.26666666666666666,  /* rgb */
        0.35362702245059907, 0.6349535329120239, 0.15861262027332904,  /* xyz */
        83.70232912330007, -66.60694997569885, 90.98138328734485,  /* luv */
        83.70232912330007, 112.7568086190098, 126.20764466335712,  /* lch */
        126.20764466335712, 89.2707337544585, 83.70232912330007,  /* hsluv */
        126.20764466335712, 296.0070205381404, 83.70232912330007,  /* hpluv */
    },
    {
        "#55ee55",
        0.3333333333333333, 0.9333333333333333, 0.3333333333333333,  /* rgb */
        0.35958943648996106, 0.6373384985277687, 0.19001466754730295,  /* xyz */
        83.8270046653184, -66.1579022543843, 85.55198408416427,  /* luv */
        83.8270046653184, 108.1480929625565, 127.71501294924008,  /* lch */
        127.71501294924008, 83.35738388461131, 83.8270046653184,  /* hsluv */
        127.71501294924008, 286.40456222390725, 83.8270046653184,  /* hpluv */
    },
    {
        "#55ee66",
        0.3333333333333333, 0.9333333333333333, 0.4,  /* rgb */
        0.36717443226346924, 0.640372496837172, 0.22996231195444689,  /* xyz */
        83.98516009198538, -65.60418806984796, 78.82617606185399,  /* luv */
        83.98516009198538, 102.55474403867616, 129.76939351303596,  /* lch */
        129.76939351303596, 83.62731110347575, 83.98516009198538,  /* hsluv */
        129.76939351303596, 274.6477282188176, 83.98516009198538,  /* hpluv */
    },
    {
        "#55ee77",
        0.3333333333333333, 0.9333333333333333, 0.4666666666666667,  /* rgb */
        0.37648844528367115, 0.6440981020452529, 0.2790161138608448,  /* xyz */
        84.17868556086538, -64.9498200787083, 70.83147586610905,  /* luv */
        84.17868556086538, 96.10190997908298, 132.51966195180236,  /* lch */
        132.51966195180236, 83.94702543148327, 84.17868556086538,  /* hsluv */
        132.51966195180236, 260.9484575395776, 84.17868556086538,  /* hpluv */
    },
    {
        "#55ee88",
        0.3333333333333333, 0.9333333333333333, 0.5333333333333333,  /* rgb */
        0.38762886238561495, 0.6485542688860304, 0.337688977264417,  /* xyz */
        84.40918221837877, -64.20201404461844, 61.6299323860706,  /* luv */
        84.40918221837877, 88.9952087097784, 136.17099757544557,  /* lch */
        136.17099757544557, 84.31340841095685, 84.40918221837877,  /* hsluv */
        136.17099757544557, 245.70939700115835, 84.40918221837877,  /* hpluv */
    },
    {
        "#55ee99",
        0.3333333333333333, 0.9333333333333333, 0.6,  /* rgb */
        0.40068582649468765, 0.6537770545296596, 0.40645565490553487,  /* xyz */
        84.67799251653179, -63.37066950075705, 51.312643482463315,  /* luv */
        84.67799251653179, 81.54035279622332, 141.00213671242977,  /* lch */
        141.00213671242977, 84.72208945504454, 84.67799251653179,  /* hsluv */
        141.00213671242977, 229.6043670751549, 84.67799251653179,  /* hpluv */
    },
    {
        "#55eeaa",
        0.3333333333333333, 0.9333333333333333, 0.6666666666666666,  /* rgb */
        0.4157435194599402, 0.6598001317157607, 0.48575950452253347,  /* xyz */
        84.98622124861814, -62.46776375760754, 39.993458032785576,  /* luv */
        84.98622124861814, 74.17343321093104, 147.37159021859884,  /* lch */
        147.37159021859884, 85.16772507651864, 84.98622124861814,  /* hsluv */
        147.37159021859884, 213.709694911287, 84.98622124861814,  /* hpluv */
    },
    {
        "#55eebb",
        0.3333333333333333, 0.9333333333333333, 0.7333333333333333,  /* rgb */
        0.4328811115672769, 0.6666551685586954, 0.5760174896211753,  /* xyz */
        85.33475132375605, -61.506695564359234, 27.802203729307774,  /* luv */
        85.33475132375605, 67.49841576994754, 155.676120933413,  /* lch */
        155.676120933413, 85.64430051771393, 85.33475132375605,  /* hsluv */
        155.676120933413, 199.69078414578328, 85.33475132375605,  /* hpluv */
    },
    {
        "#55eecc",
        0.3333333333333333, 0.9333333333333333, 0.8,  /* rgb */
        0.4521734870109986, 0.6743721187361843, 0.6776240002914454,  /* xyz */
        85.72425660258658, -60.501623957192464, 14.877886566050575,  /* luv */
        85.72425660258658, 62.3040769944455, 166.18458347290837,  /* lch */
        166.18458347290837, 86.14543322105432, 85.72425660258658,  /* hsluv */
        166.18458347290837, 189.97916606165143, 85.72425660258658,  /* hpluv */
    },
    {
        "#55eedd",
        0.3333333333333333, 0.9333333333333333, 0.8666666666666667,  /* rgb */
        0.4736918125616322, 0.6829794489564378, 0.7909538481914514,  /* xyz */
        86.15521319784663, -59.466846939229846, 1.362305353908214,  /* luv */
        86.15521319784663, 59.48244918268814, 178.68766041872556,  /* lch */
        178.68766041872556, 86.6646578889921, 86.15521319784663,  /* hsluv */
        178.68766041872556, 187.70313477713728, 86.15521319784663,  /* hpluv */
    },
    {
        "#55eeee",
        0.3333333333333333, 0.9333333333333333, 0.9333333333333333,  /* rgb */
        0.4975039928278069, 0.6925043210629078, 0.9163646642599746,  /* xyz */
        86.62791010528966, -58.41625672452653, -12.605551946697297,  /* luv */
        86.62791010528966, 59.76084830042722, 192.17705063006125,  /* lch */
        192.17705063006125, 87.19567644196597, 86.62791010528966,  /* hsluv */
        192.17705063006125, 196.02549006749464, 86.62791010528966,  /* hpluv */
    },
    {
        "#55eeff",
        0.3333333333333333, 0.9333333333333333, 1.0,  /* rgb */
        0.5236750412376383, 0.7029727404268405, 1.0541988525517565,  /* xyz */
        87.14245969359159, -57.36289640075822, -26.894081492312868,  /* luv */
        87.14245969359159, 63.35450657056123, 205.1191124922481,  /* lch */
        205.1191124922481, 99.9999999999933, 87.14245969359159,  /* hsluv */
        205.1191124922481, 217.06231600799947, 87.14245969359159,  /* hpluv */
    },
    {
        "#55ff00",
        0.3333333333333333, 1.0, 0.0,  /* rgb */
        0.3950466252654821, 0.7344851699254566, 0.12095082444532053,  /* xyz */
        88.66118950978617, -73.34378818303952, 107.26228816814496,  /* luv */
        88.66118950978617, 129.94040837285658, 124.36353263948527,  /* lch */
        124.36353263948527, 100.0000000000022, 88.66118950978617,  /* hsluv */
        124.36353263948527, 511.2146849761083, 88.66118950978617,  /* hpluv */
    },
    {
        "#55ff11",
        0.3333333333333333, 1.0, 0.06666666666666667,  /* rgb */
        0.3960582907651192, 0.7348898361253116, 0.12627892941007615,  /* xyz */
        88.68040708413355, -73.26673187260856, 106.37613789028431,  /* luv */
        88.68040708413355, 129.1661593132872, 124.55718860657127,  /* lch */
        124.55718860657127, 99.99999999999137, 88.68040708413355,  /* hsluv */
        124.55718860657127, 509.1117141907399, 88.68040708413355,  /* hpluv */
    },
    {
        "#55ff22",
        0.3333333333333333, 1.0, 0.13333333333333333,  /* rgb */
        0.3979336489035963, 0.7356399793807024, 0.13615581560605536,  /* xyz */
        88.71601269204729, -73.12472634537119, 104.74176200975222,  /* luv */
        88.71601269204729, 127.74217123562993, 124.92054906175086,  /* lch */
        124.92054906175086, 99.99999999999125, 88.71601269204729,  /* hsluv */
        124.92054906175086, 505.2354898588076, 88.71601269204729,  /* hpluv */
    },
    {
        "#55ff33",
        0.3333333333333333, 1.0, 0.2,  /* rgb */
        0.401021399636054, 0.7368750796736855, 0.1524179694636665,  /* xyz */
        88.77458412506388, -72.89325629965538, 102.0740414672186,  /* luv */
        88.77458412506388, 125.42940945176578, 125.53144296417908,  /* lch */
        125.53144296417908, 99.99999999999154, 88.77458412506388,  /* hsluv */
        125.53144296417908, 498.91651887176283, 88.77458412506388,  /* hpluv */
    },
    {
        "#55ff44",
        0.3333333333333333, 1.0, 0.26666666666666666,  /* rgb */
        0.4054793948802729, 0.738658277771373, 0.17589674441655315,  /* xyz */
        88.85903232949413, -72.56411165813232, 98.27261712790757,  /* luv */
        88.85903232949413, 122.15996716560711, 126.44201332947843,  /* lch */
        126.44201332947843, 99.99999999999147, 88.85903232949413,  /* hsluv */
        126.44201332947843, 489.93420459674155, 88.85903232949413,  /* hpluv */
    },
    {
        "#55ff55",
        0.3333333333333333, 1.0, 0.3333333333333333,  /* rgb */
        0.4114418089196349, 0.7410432433871178, 0.20729879169052706,  /* xyz */
        88.97176669266202, -72.1329719647303, 93.2786357968462,  /* luv */
        88.97176669266202, 117.91551865884848, 127.71501294924012,  /* lch */
        127.71501294924012, 99.99999999999125, 88.97176669266202,  /* hsluv */
        127.71501294924012, 478.1872074425948, 88.97176669266202,  /* hpluv */
    },
    {
        "#55ff66",
        0.3333333333333333, 1.0, 0.4,  /* rgb */
        0.4190268046931431, 0.7440772416965211, 0.247246436097671,  /* xyz */
        89.1148309932425, -71.59901886675439, 87.07002320146337,  /* luv */
        89.1148309932425, 112.72802864853631, 129.43098651395997,  /* lch */
        129.43098651395997, 99.99999999999137, 89.1148309932425,  /* hsluv */
        129.43098651395997, 463.70104748744757, 89.1148309932425,  /* hpluv */
    },
    {
        "#55ff77",
        0.3333333333333333, 1.0, 0.4666666666666667,  /* rgb */
        0.428340817713345, 0.747802846904602, 0.2963002380040689,  /* xyz */
        89.28997614503842, -70.96465477822727, 79.65823085522828,  /* luv */
        89.28997614503842, 106.6837193332601, 131.6966958261094,  /* lch */
        131.6966958261094, 99.99999999999115, 89.28997614503842,  /* hsluv */
        131.6966958261094, 446.65316580794564, 89.28997614503842,  /* hpluv */
    },
    {
        "#55ff88",
        0.3333333333333333, 1.0, 0.5333333333333333,  /* rgb */
        0.4394812348152888, 0.7522590137453795, 0.3549731014076411,  /* xyz */
        89.49870353277863, -70.23519272805858, 71.08490343766968,  /* luv */
        89.49870353277863, 99.93020461447257, 134.6555036961201,  /* lch */
        134.6555036961201, 99.99999999999105, 89.49870353277863,  /* hsluv */
        134.6555036961201, 427.42070847183396, 89.49870353277863,  /* hpluv */
    },
    {
        "#55ff99",
        0.3333333333333333, 1.0, 0.6,  /* rgb */
        0.45253819892436153, 0.7574817993890087, 0.423739779048759,  /* xyz */
        89.74229288399395, -69.41847460253824, 61.41795207440673,  /* luv */
        89.74229288399395, 92.68813005534942, 138.49922509305514,  /* lch */
        138.49922509305514, 99.99999999999092, 89.74229288399395,  /* hsluv */
        138.49922509305514, 406.66413560565024, 89.74229288399395,  /* hpluv */
    },
    {
        "#55ffaa",
        0.3333333333333333, 1.0, 0.6666666666666666,  /* rgb */
        0.46759589188961403, 0.7635048765751098, 0.5030436286657576,  /* xyz */
        90.02182141903273, -68.52441563283058, 50.74696608164161,  /* luv */
        90.02182141903273, 85.26927995657171, 143.4775485100333,  /* lch */
        143.4775485100333, 99.99999999999089, 90.02182141903273,  /* hsluv */
        143.4775485100333, 385.4676037766397, 90.02182141903273,  /* hpluv */
    },
    {
        "#55ffbb",
        0.3333333333333333, 1.0, 0.7333333333333333,  /* rgb */
        0.4847334839969507, 0.7703599134180446, 0.5933016137643994,  /* xyz */
        90.33817790710496, -67.56449429436435, 39.17812571958436,  /* luv */
        90.33817790710496, 78.10176966082619, 149.89215646458197,  /* lch */
        149.89215646458197, 99.9999999999906, 90.33817790710496,  /* hsluv */
        149.89215646458197, 365.5603197642387, 90.33817790710496,  /* hpluv */
    },
    {
        "#55ffcc",
        0.3333333333333333, 1.0, 0.8,  /* rgb */
        0.5040258594406725, 0.7780768635955334, 0.6949081244346695,  /* xyz */
        90.69207373307378, -66.55121744267292, 26.828893251416094,  /* luv */
        90.69207373307378, 71.75551585904608, 158.04408297895796,  /* lch */
        158.04408297895796, 99.99999999999052, 90.69207373307378,  /* hsluv */
        158.04408297895796, 349.6209925639259, 90.69207373307378,  /* hpluv */
    },
    {
        "#55ffdd",
        0.3333333333333333, 1.0, 0.8666666666666667,  /* rgb */
        0.525544184991306, 0.7866841938157869, 0.8082379723346755,  /* xyz */
        91.08405226078781, -65.4975936461766, 13.822795921318727,  /* luv */
        91.08405226078781, 66.94030520188939, 168.0830081510422,  /* lch */
        168.0830081510422, 99.99999999999011, 91.08405226078781,  /* hsluv */
        168.0830081510422, 341.5709279554382, 91.08405226078781,  /* hpluv */
    },
    {
        "#55ffee",
        0.3333333333333333, 1.0, 0.9333333333333333,  /* rgb */
        0.5493563652574807, 0.7962090659222569, 0.9336487884031988,  /* xyz */
        91.5144973031429, -64.41664521308743, 0.2845936394338046,  /* luv */
        91.5144973031429, 64.4172738793593, 179.746868091755,  /* lch */
        179.746868091755, 99.99999999998981, 91.5144973031429,  /* hsluv */
        179.746868091755, 346.5599140309244, 91.5144973031429,  /* hpluv */
    },
    {
        "#55ffff",
        0.3333333333333333, 1.0, 1.0,  /* rgb */
        0.5755274136673121, 0.8066774852861897, 1.0714829766949805,  /* xyz */
        91.9836412143362, -63.3209831419883, -13.663935128132529,  /* luv */
        91.9836412143362, 64.77846887086619, 192.1770506300611,  /* lch */
        192.1770506300611, 99.99999999998907, 91.9836412143362,  /* hsluv */
        192.1770506300611, 370.27643398755475, 91.9836412143362,  /* hpluv */
    },
    {
        "#660000",
        0.4, 0.0, 0.0,  /* rgb */
        0.054793673322704246, 0.02825298780701998, 0.0025684534370017074,  /* xyz */
        19.330201679573328, 63.54542541379254, 13.71236717213788,  /* luv */
        19.330201679573328, 65.00807722493718, 12.177050630061776,  /* lch */
        12.177050630061776, 100.00000000000222, 19.330201679573328,  /* hsluv */
        12.177050630061776, 426.7467891831252, 19.330201679573328,  /* hpluv */
    },
    {
        "#660011",
        0.4, 0.0, 0.06666666666666667,  /* rgb */
        0.05580533882234137, 0.02865765400687483, 0.007896558401757339,  /* xyz */
        19.49808030582436, 60.93768778819058, 9.641916024853316,  /* luv */
        19.49808030582436, 61.69577244513042, 8.991134285664161,  /* lch */
        8.991134285664161, 99.99999999999662, 19.49808030582436,  /* hsluv */
        8.991134285664161, 401.51602003210553, 19.49808030582436,  /* hpluv */
    },
    {
        "#660022",
        0.4, 0.0, 0.13333333333333333,  /* rgb */
        0.05768069696081839, 0.029407797262265653, 0.017773444597736533,  /* xyz */
        19.805149201468865, 56.65733416371736, 2.845652017874405,  /* luv */
        19.805149201468865, 56.72875152817984, 2.8753022193359197,  /* lch */
        2.8753022193359197, 99.99999999999686, 19.805149201468865,  /* hsluv */
        2.8753022193359197, 363.4665375662474, 19.805149201468865,  /* hpluv */
    },
    {
        "#660033",
        0.4, 0.0, 0.2,  /* rgb */
        0.06076844769327613, 0.030642897555248766, 0.034035598455347676,  /* xyz */
        20.299552044498412, 50.83611098872697, -6.677436691435248,  /* luv */
        20.299552044498412, 51.272783630560696, 352.51691145040263,  /* lch */
        352.51691145040263, 99.99999999999739, 20.299552044498412,  /* hsluv */
        352.51691145040263, 320.5086599440551, 20.299552044498412,  /* hpluv */
    },
    {
        "#660044",
        0.4, 0.0, 0.26666666666666666,  /* rgb */
        0.06522644293749501, 0.03242609565293634, 0.057514373408234315,  /* xyz */
        20.990443843346476, 44.330568963583985, -17.825005571983684,  /* luv */
        20.990443843346476, 47.78001850435311, 338.09529237337586,  /* lch */
        338.09529237337586, 99.99999999999791, 20.990443843346476,  /* hsluv */
        338.09529237337586, 288.84444406211895, 20.990443843346476,  /* hpluv */
    },
    {
        "#660055",
        0.4, 0.0, 0.3333333333333333,  /* rgb */
        0.071188856976857, 0.03481106126868117, 0.08891642068220823,  /* xyz */
        21.875968244743532, 37.89205946083341, -29.594014143686774,  /* luv */
        21.875968244743532, 48.07924545289857, 322.009867044845,  /* lch */
        322.009867044845, 99.9999999999984, 21.875968244743532,  /* hsluv */
        322.009867044845, 278.8879086279489, 21.875968244743532,  /* hpluv */
    },
    {
        "#660066",
        0.4, 0.0, 0.4,  /* rgb */
        0.07877385275036518, 0.03784505957808448, 0.1288640650893522,  /* xyz */
        22.945838056693987, 31.97345656778308, -41.34642354415153,  /* luv */
        22.945838056693987, 52.26689836583264, 307.7150129492436,  /* lch */
        307.7150129492436, 99.9999999999988, 22.945838056693987,  /* hsluv */
        307.7150129492436, 289.0427837304834, 22.945838056693987,  /* hpluv */
    },
    {
        "#660077",
        0.4, 0.0, 0.4666666666666667,  /* rgb */
        0.0880878657705671, 0.0415706647861653, 0.1779178669957501,  /* xyz */
        24.184044471653905, 26.752290484461806, -52.78840991298641,  /* luv */
        24.184044471653905, 59.180243893604455, 296.8751354676607,  /* lch */
        296.8751354676607, 99.99999999999923, 24.184044471653905,  /* hsluv */
        296.8751354676607, 310.5182603277313, 24.184044471653905,  /* hpluv */
    },
    {
        "#660088",
        0.4, 0.0, 0.5333333333333333,  /* rgb */
        0.09922828287251093, 0.04602683162694289, 0.23659073039932227,  /* xyz */
        25.571434982634038, 22.23419570918799, -63.84260396703277,  /* luv */
        25.571434982634038, 67.60353200925128, 289.2014797415473,  /* lch */
        289.2014797415473, 99.99999999999952, 25.571434982634038,  /* hsluv */
        289.2014797415473, 335.4699417821982, 25.571434982634038,  /* hpluv */
    },
    {
        "#660099",
        0.4, 0.0, 0.6,  /* rgb */
        0.11228524698158363, 0.051249617270572055, 0.30535740804044015,  /* xyz */
        27.087854021386356, 18.3449067131383, -74.53392033425233,  /* luv */
        27.087854021386356, 76.75832777429703, 283.82727061443006,  /* lch */
        283.82727061443006, 99.99999999999967, 27.087854021386356,  /* hsluv */
        283.82727061443006, 359.5756142353319, 27.087854021386356,  /* hpluv */
    },
    {
        "#6600aa",
        0.4, 0.0, 0.6666666666666666,  /* rgb */
        0.12734293994683618, 0.05727269445667316, 0.38466125765743875,  /* xyz */
        28.713691666451233, 14.986287702447209, -84.92091614657222,  /* luv */
        28.713691666451233, 86.23311903366172, 280.0081392435834,  /* lch */
        280.0081392435834, 99.99999999999989, 28.713691666451233,  /* hsluv */
        280.0081392435834, 381.0872235417815, 28.713691666451233,  /* hpluv */
    },
    {
        "#6600bb",
        0.4, 0.0, 0.7333333333333333,  /* rgb */
        0.14448053205417283, 0.06412773129960792, 0.4749192427560805,  /* xyz */
        30.43084788441272, 12.063278317584528, -95.06358103774852,  /* luv */
        30.43084788441272, 95.82592093733348, 277.23200626107723,  /* lch */
        277.23200626107723, 100.00000000000007, 30.43084788441272,  /* hsluv */
        277.23200626107723, 399.5841703034605, 30.43084788441272,  /* hpluv */
    },
    {
        "#6600cc",
        0.4, 0.0, 0.8,  /* rgb */
        0.16377290749789455, 0.07184468147709672, 0.5765257534263507,  /* xyz */
        32.22321900582546, 9.49391256045434, -105.01182781764044,  /* luv */
        32.22321900582546, 105.44011739991242, 275.16595430901134,  /* lch */
        275.16595430901134, 100.00000000000028, 32.22321900582546,  /* hsluv */
        275.16595430901134, 415.21810716599924, 32.22321900582546,  /* hpluv */
    },
    {
        "#6600dd",
        0.4, 0.0, 0.8666666666666667,  /* rgb */
        0.1852912330485281, 0.08045201169735025, 0.6898556013263567,  /* xyz */
        34.07684493665644, 7.211198226344432, -114.80353766755717,  /* luv */
        34.07684493665644, 115.02979457882141, 273.5942195064543,  /* lch */
        273.5942195064543, 100.00000000000031, 34.07684493665644,  /* hsluv */
        273.5942195064543, 428.3416375850512, 34.07684493665644,  /* hpluv */
    },
    {
        "#6600ee",
        0.4, 0.0, 0.9333333333333333,  /* rgb */
        0.20910341331470284, 0.08997688380382028, 0.8152664173948799,  /* xyz */
        35.979844015396566, 5.161728420860397, -124.46616347761226,  /* luv */
        35.979844015396566, 124.573148355199, 272.3747488898702,  /* lch */
        272.3747488898702, 100.00000000000031, 35.979844015396566,  /* hsluv */
        272.3747488898702, 439.34378872335014, 35.979844015396566,  /* hpluv */
    },
    {
        "#6600ff",
        0.4, 0.0, 1.0,  /* rgb */
        0.23527446172453423, 0.10044530316775299, 0.9531006056866618,  /* xyz */
        37.92223281556727, 3.303343852889532, -134.0191719236749,  /* luv */
        37.92223281556727, 134.05987663621787, 271.41195728326903,  /* lch */
        271.41195728326903, 100.00000000000054, 37.92223281556727,  /* hsluv */
        271.41195728326903, 448.58447779597617, 37.92223281556727,  /* hpluv */
    },
    {
        "#661100",
        0.4, 0.06666666666666667, 0.0,  /* rgb */
        0.056798073583632654, 0.032261788328876856, 0.0032365868573111583,  /* xyz */
        20.92785952258243, 58.47179275366042, 16.101536579102227,  /* luv */
        20.92785952258243, 60.648248350922564, 15.396103161209082,  /* lch */
        15.396103161209082, 100.00000000000216, 20.92785952258243,  /* hsluv */
        15.396103161209082, 367.73314590329267, 20.92785952258243,  /* hpluv */
    },
    {
        "#661111",
        0.4, 0.06666666666666667, 0.06666666666666667,  /* rgb */
        0.05780973908326978, 0.03266645452873171, 0.008564691822066789,  /* xyz */
        21.081616330265113, 56.28558146233018, 12.145776890829183,  /* luv */
        21.081616330265113, 57.581130388647345, 12.17705063006181,  /* lch */
        12.17705063006181, 81.21670116161258, 21.081616330265113,  /* hsluv */
        12.17705063006181, 346.5896644876274, 21.081616330265113,  /* hpluv */
    },
    {
        "#661122",
        0.4, 0.06666666666666667, 0.13333333333333333,  /* rgb */
        0.059685097221746794, 0.03341659778412253, 0.018441578018045985,  /* xyz */
        21.363314856368774, 52.648744799420655, 5.472390809876797,  /* luv */
        21.363314856368774, 52.93238507880169, 5.934101543717499,  /* lch */
        5.934101543717499, 82.51995136103874, 21.363314856368774,  /* hsluv */
        5.934101543717499, 314.406957937895, 21.363314856368774,  /* hpluv */
    },
    {
        "#661133",
        0.4, 0.06666666666666667, 0.2,  /* rgb */
        0.06277284795420454, 0.03465169807710564, 0.03470373187565713,  /* xyz */
        21.818081763225592, 47.605557833060466, -4.011315315211714,  /* luv */
        21.818081763225592, 47.77425862485902, 355.1835495802781,  /* lch */
        355.1835495802781, 84.31211753032926, 21.818081763225592,  /* hsluv */
        355.1835495802781, 277.8540413017299, 21.818081763225592,  /* hpluv */
    },
    {
        "#661144",
        0.4, 0.06666666666666667, 0.26666666666666666,  /* rgb */
        0.06723084319842342, 0.036434896174793216, 0.05818250682854377,  /* xyz */
        22.45597569683244, 41.836930141979025, -15.280871045394663,  /* luv */
        22.45597569683244, 44.54024858047847, 339.9353606776824,  /* lch */
        339.9353606776824, 86.33488636241165, 22.45597569683244,  /* hsluv */
        339.9353606776824, 251.68656491162426, 22.45597569683244,  /* hpluv */
    },
    {
        "#661155",
        0.4, 0.06666666666666667, 0.3333333333333333,  /* rgb */
        0.07319325723778541, 0.03881986179053805, 0.08958455410251767,  /* xyz */
        23.277392697791015, 35.991964511090536, -27.326731303593046,  /* luv */
        23.277392697791015, 45.19039447832219, 322.79258399575593,  /* lch */
        322.79258399575593, 88.34482680016473, 23.277392697791015,  /* hsluv */
        322.79258399575593, 246.34918258876635, 23.277392697791015,  /* hpluv */
    },
    {
        "#661166",
        0.4, 0.06666666666666667, 0.4,  /* rgb */
        0.08077825301129359, 0.04185386009994136, 0.12953219850966163,  /* xyz */
        24.27508775109827, 30.50464152045151, -39.44702774606965,  /* luv */
        24.27508775109827, 49.86583151107021, 307.7150129492437,  /* lch */
        307.7150129492437, 90.18191475987032, 24.27508775109827,  /* hsluv */
        307.7150129492437, 260.6643168433837, 24.27508775109827,  /* hpluv */
    },
    {
        "#661177",
        0.4, 0.06666666666666667, 0.4666666666666667,  /* rgb */
        0.0900922660314955, 0.04557946530802218, 0.17858600041605954,  /* xyz */
        25.43630915033917, 25.579808785901424, -51.27703586525721,  /* luv */
        25.43630915033917, 57.30323747093313, 296.512546946797,  /* lch */
        296.512546946797, 91.77404639721485, 25.43630915033917,  /* hsluv */
        296.512546946797, 285.8672414648582, 25.43630915033917,  /* hpluv */
    },
    {
        "#661188",
        0.4, 0.06666666666666667, 0.5333333333333333,  /* rgb */
        0.10123268313343933, 0.050035632148799775, 0.2372588638196317,  /* xyz */
        26.744914517168013, 21.261794852186846, -62.68989024272381,  /* luv */
        26.744914517168013, 66.19732818612272, 288.73479207624337,  /* lch */
        288.73479207624337, 93.11037269224535, 26.744914517168013,  /* hsluv */
        288.73479207624337, 314.0787642136354, 26.744914517168013,  /* hpluv */
    },
    {
        "#661199",
        0.4, 0.06666666666666667, 0.6,  /* rgb */
        0.11428964724251203, 0.05525841779242893, 0.3060255414607496,  /* xyz */
        28.18323096306503, 17.50943217893437, -73.68640125210646,  /* luv */
        28.18323096306503, 75.73814062092586, 283.3667778115961,  /* lch */
        283.3667778115961, 94.2123428080992, 28.18323096306503,  /* hsluv */
        283.3667778115961, 341.00691496147624, 28.18323096306503,  /* hpluv */
    },
    {
        "#6611aa",
        0.4, 0.06666666666666667, 0.6666666666666666,  /* rgb */
        0.1293473402077646, 0.061281494978530034, 0.3853293910777482,  /* xyz */
        29.733500038717203, 14.247986744340036, -84.3193518539685,  /* luv */
        29.733500038717203, 85.51466671478191, 279.5910391594268,  /* lch */
        279.5910391594268, 95.11365359121523, 29.733500038717203,  /* hsluv */
        279.5910391594268, 364.9504465268321, 29.733500038717203,  /* hpluv */
    },
    {
        "#6611bb",
        0.4, 0.06666666666666667, 0.7333333333333333,  /* rgb */
        0.14648493231510124, 0.06813653182146479, 0.47558737617638996,  /* xyz */
        31.378866229854367, 11.397424130094535, -94.65301472535342,  /* luv */
        31.378866229854367, 95.33674251514593, 276.866082014695,  /* lch */
        276.866082014695, 95.84932209807776, 31.378866229854367,  /* hsluv */
        276.866082014695, 385.53373662108663, 31.378866229854367,  /* hpluv */
    },
    {
        "#6611cc",
        0.4, 0.06666666666666667, 0.8,  /* rgb */
        0.16577730775882296, 0.07585348199895359, 0.5771938868466602,  /* xyz */
        33.10395763678779, 8.884941437010374, -104.74571415778033,  /* luv */
        33.10395763678779, 105.12186651102864, 274.84844614886595,  /* lch */
        274.84844614886595, 96.45085283444634, 33.10395763678779,  /* hsluv */
        274.84844614886595, 402.9512176222345, 33.10395763678779,  /* hpluv */
    },
    {
        "#6611dd",
        0.4, 0.06666666666666667, 0.8666666666666667,  /* rgb */
        0.1872956333094565, 0.08446081221920712, 0.6905237347466662,  /* xyz */
        34.895150983591556, 6.6489959504780405, -114.64450080309474,  /* luv */
        34.895150983591556, 114.83714865643549, 273.3192445364079,  /* lch */
        273.3192445364079, 96.94472237192977, 34.895150983591556,  /* hsluv */
        273.3192445364079, 417.59630322859067, 34.895150983591556,  /* hpluv */
    },
    {
        "#6611ee",
        0.4, 0.06666666666666667, 0.9333333333333333,  /* rgb */
        0.21110781357563124, 0.09398568432567717, 0.8159345508151894,  /* xyz */
        36.74061930881509, 4.639401018040975, -124.38517318216446,  /* luv */
        36.74061930881509, 124.47166484531026, 272.1360659468293,  /* lch */
        272.1360659468293, 97.35241172386804, 36.74061930881509,  /* hsluv */
        272.1360659468293, 429.8959486326661, 36.74061930881509,  /* hpluv */
    },
    {
        "#6611ff",
        0.4, 0.06666666666666667, 1.0,  /* rgb */
        0.23727886198546264, 0.10445410368960986, 0.9537687391069712,  /* xyz */
        38.63024625256878, 2.81591803113255, -133.99416360557228,  /* luv */
        38.63024625256878, 134.0237489205362, 271.20390671628064,  /* lch */
        271.20390671628064, 99.99999999999953, 38.63024625256878,  /* hsluv */
        271.20390671628064, 440.2441682994409, 38.63024625256878,  /* hpluv */
    },
    {
        "#662200",
        0.4, 0.13333333333333333, 0.0,  /* rgb */
        0.06051369731840059, 0.039693035798412823, 0.004475128102233768,  /* xyz */
        23.569700321105913, 50.19083359667749, 20.038983444740694,  /* luv */
        23.569700321105913, 54.0433218319152, 21.764643843199348,  /* lch */
        21.764643843199348, 100.0000000000023, 23.569700321105913,  /* hsluv */
        21.764643843199348, 290.95598920401886, 23.569700321105913,  /* hpluv */
    },
    {
        "#662211",
        0.4, 0.13333333333333333, 0.06666666666666667,  /* rgb */
        0.06152536281803771, 0.040097701998267676, 0.0098032330669894,  /* xyz */
        23.703715526830024, 48.56484183258322, 16.29494136673542,  /* luv */
        23.703715526830024, 51.22566716372926, 18.54812661135048,  /* lch */
        18.54812661135048, 84.44219446306798, 23.703715526830024,  /* hsluv */
        18.54812661135048, 274.2271962887535, 23.703715526830024,  /* hpluv */
    },
    {
        "#662222",
        0.4, 0.13333333333333333, 0.13333333333333333,  /* rgb */
        0.06340072095651474, 0.0408478452536585, 0.019680119262968594,  /* xyz */
        23.949778276070482, 45.80956608883845, 9.88517404858116,  /* luv */
        23.949778276070482, 46.863984158609476, 12.177050630061828,  /* lch */
        12.177050630061828, 58.18442873937858, 23.949778276070482,  /* hsluv */
        12.177050630061828, 248.30018144983558, 23.949778276070482,  /* hpluv */
    },
    {
        "#662233",
        0.4, 0.13333333333333333, 0.2,  /* rgb */
        0.06648847168897247, 0.04208294554664161, 0.03594227312057974,  /* xyz */
        24.34843545774745, 41.88258429073573, 0.5842501882160852,  /* luv */
        24.34843545774745, 41.886659154831314, 0.7992080581682148,  /* lch */
        0.7992080581682148, 61.83884071027149, 24.34843545774745,  /* hsluv */
        0.7992080581682148, 218.29510084716267, 24.34843545774745,  /* hpluv */
    },
    {
        "#662244",
        0.4, 0.13333333333333333, 0.26666666666666666,  /* rgb */
        0.07094646693319134, 0.043866143644329184, 0.059421048073466376,  /* xyz */
        24.910470544936636, 37.23613219604805, -10.732202730500523,  /* luv */
        24.910470544936636, 38.75189951950909, 343.9219538222164,  /* lch */
        343.9219538222164, 66.1143919991375, 24.910470544936636,  /* hsluv */
        343.9219538222164, 197.40147375767063, 24.910470544936636,  /* hpluv */
    },
    {
        "#662255",
        0.4, 0.13333333333333333, 0.3333333333333333,  /* rgb */
        0.07690888097255334, 0.046251109260074016, 0.09082309534744029,  /* xyz */
        25.638848125407037, 32.35778939912854, -23.090258565000365,  /* luv */
        25.638848125407037, 39.75156066617924, 324.4886510145846,  /* lch */
        324.4886510145846, 70.53037771949307, 25.638848125407037,  /* hsluv */
        324.4886510145846, 196.74105716675524, 25.638848125407037,  /* hpluv */
    },
    {
        "#662266",
        0.4, 0.13333333333333333, 0.4,  /* rgb */
        0.08449387674606151, 0.04928510756947733, 0.13077073975458425,  /* xyz */
        26.53011517502643, 27.622868319185017, -35.72046740107964,  /* luv */
        26.53011517502643, 45.15500687111705, 307.715012949244,  /* lch */
        307.715012949244, 74.72122317606001, 26.53011517502643,  /* hsluv */
        307.715012949244, 215.97630350555303, 26.53011517502643,  /* hpluv */
    },
    {
        "#662277",
        0.4, 0.13333333333333333, 0.4666666666666667,  /* rgb */
        0.09380788976626343, 0.053010712777558144, 0.17982454166098216,  /* xyz */
        27.575850318125305, 23.249916350925837, -48.152668623380514,  /* luv */
        27.575850318125305, 53.47184404785515, 295.77299489267165,  /* lch */
        295.77299489267165, 78.47929494367146, 27.575850318125305,  /* hsluv */
        295.77299489267165, 246.05691523634258, 27.575850318125305,  /* hpluv */
    },
    {
        "#662288",
        0.4, 0.13333333333333333, 0.5333333333333333,  /* rgb */
        0.10494830686820726, 0.05746687961833574, 0.23849740506455433,  /* xyz */
        28.764169128853922, 19.326405091340327, -60.16932912319672,  /* luv */
        28.764169128853922, 63.19697857405965, 287.8070326024137,  /* lch */
        287.8070326024137, 81.72831393067516, 28.764169128853922,  /* hsluv */
        287.8070326024137, 278.7942472735948, 28.764169128853922,  /* hpluv */
    },
    {
        "#662299",
        0.4, 0.13333333333333333, 0.6,  /* rgb */
        0.11800527097727997, 0.0626896652619649, 0.30726408270567224,  /* xyz */
        30.081149723697223, 15.856231799012608, -71.71458008530168,  /* luv */
        30.081149723697223, 73.446586603294, 282.467625610713,  /* lch */
        282.467625610713, 84.47531758704426, 30.081149723697223,  /* hsluv */
        282.467625610713, 309.82503839078146, 30.081149723697223,  /* hpluv */
    },
    {
        "#6622aa",
        0.4, 0.13333333333333333, 0.6666666666666666,  /* rgb */
        0.13306296394253253, 0.068712742448066, 0.38656793232267084,  /* xyz */
        31.512047889249807, 12.800730113673355, -82.81562923547256,  /* luv */
        31.512047889249807, 83.79908792528926, 278.7866170544589,  /* lch */
        278.7866170544589, 86.76925308371113, 31.512047889249807,  /* hsluv */
        278.7866170544589, 337.44421756264853, 31.512047889249807,  /* hpluv */
    },
    {
        "#6622bb",
        0.4, 0.13333333333333333, 0.7333333333333333,  /* rgb */
        0.15020055604986915, 0.07556777929100075, 0.4768259174213126,  /* xyz */
        33.04222993113053, 10.105388826228975, -93.53204717396586,  /* luv */
        33.04222993113053, 94.07636648958254, 276.16643073789237,  /* lch */
        276.16643073789237, 88.67395915160677, 33.04222993113053,  /* hsluv */
        276.16643073789237, 361.28548425932473, 33.04222993113053,  /* hpluv */
    },
    {
        "#6622cc",
        0.4, 0.13333333333333333, 0.8,  /* rgb */
        0.1694929314935909, 0.08328472946848955, 0.5784324280915827,  /* xyz */
        34.657814461233485, 7.714337294679522, -103.92874236976155,  /* luv */
        34.657814461233485, 104.21465583331528, 274.24511905865575,  /* lch */
        274.24511905865575, 90.25349164893831, 34.657814461233485,  /* hsluv */
        274.24511905865575, 381.5636132429596, 34.657814461233485,  /* hpluv */
    },
    {
        "#6622dd",
        0.4, 0.13333333333333333, 0.8666666666666667,  /* rgb */
        0.19101125704422445, 0.09189205968874309, 0.6917622759915887,  /* xyz */
        36.34605830456316, 5.576904820867234, -114.064052082299,  /* luv */
        36.34605830456316, 114.20030580000402, 272.79911903021775,  /* lch */
        272.79911903021775, 91.56548942171551, 36.34605830456316,  /* hsluv */
        272.79911903021775, 398.70278972726857, 36.34605830456316,  /* hpluv */
    },
    {
        "#6622ee",
        0.4, 0.13333333333333333, 0.9333333333333333,  /* rgb */
        0.21482343731039918, 0.10141693179521313, 0.8171730920601119,  /* xyz */
        38.0955422395423, 3.6498015113216806, -123.9859808642226,  /* luv */
        38.0955422395423, 124.0396892205693, 271.68614103651913,  /* lch */
        271.68614103651913, 92.65901525699735, 38.0955422395423,  /* hsluv */
        271.68614103651913, 413.1671994453811, 38.0955422395423,  /* hpluv */
    },
    {
        "#6622ff",
        0.4, 0.13333333333333333, 1.0,  /* rgb */
        0.24099448572023058, 0.11188535115914583, 0.9550072803518938,  /* xyz */
        39.896214775742926, 1.8971767829447994, -133.732233416399,  /* luv */
        39.896214775742926, 133.74568977834002, 270.8127653943789,  /* lch */
        270.8127653943789, 99.99999999999946, 39.896214775742926,  /* hsluv */
        270.8127653943789, 425.3901487734844, 39.896214775742926,  /* hpluv */
    },
    {
        "#663300",
        0.4, 0.2, 0.0,  /* rgb */
        0.06663141940741141, 0.05192847997643463, 0.006514368798570649,  /* xyz */
        27.277270236516102, 39.097251294819394, 25.50060209233871,  /* luv */
        27.277270236516102, 46.6784293424923, 33.11380405317354,  /* lch */
        33.11380405317354, 100.00000000000229, 27.277270236516102,  /* hsluv */
        33.11380405317354, 217.14741038655725, 27.277270236516102,  /* hpluv */
    },
    {
        "#663311",
        0.4, 0.2, 0.06666666666666667,  /* rgb */
        0.06764308490704853, 0.05233314617628948, 0.01184247376332628,  /* xyz */
        27.389395947871577, 38.031369165675535, 22.069930321561596,  /* luv */
        27.389395947871577, 43.97120495295165, 30.12696174658122,  /* lch */
        30.12696174658122, 87.87139660906806, 27.389395947871577,  /* hsluv */
        30.12696174658122, 203.71604639357736, 27.389395947871577,  /* hpluv */
    },
    {
        "#663322",
        0.4, 0.2, 0.13333333333333333,  /* rgb */
        0.06951844304552555, 0.0530832894316803, 0.021719359959305476,  /* xyz */
        27.595727729398078, 36.188946950051744, 16.09985638096557,  /* luv */
        27.595727729398078, 39.608651287835805, 23.983480238985447,  /* lch */
        23.983480238985447, 66.97794680560105, 27.595727729398078,  /* hsluv */
        23.983480238985447, 182.1325338797144, 27.595727729398078,  /* hpluv */
    },
    {
        "#663333",
        0.4, 0.2, 0.2,  /* rgb */
        0.07260619377798329, 0.054318389724663414, 0.03798151381691662,  /* xyz */
        27.9312558147072, 33.48203677705597, 7.225035932458661,  /* luv */
        27.9312558147072, 34.25270691442425, 12.177050630061968,  /* lch */
        12.177050630061968, 36.46477183003425, 27.9312558147072,  /* hsluv */
        12.177050630061968, 155.61224296761904, 27.9312558147072,  /* hpluv */
    },
    {
        "#663344",
        0.4, 0.2, 0.26666666666666666,  /* rgb */
        0.07706418902220216, 0.05610158782235099, 0.06146028876980326,  /* xyz */
        28.406823347621845, 30.152090584173784, -3.893238586375443,  /* luv */
        28.406823347621845, 30.402399137019827, 352.64267456688924,  /* lch */
        352.64267456688924, 42.319756813324204, 28.406823347621845,  /* hsluv */
        352.64267456688924, 135.80773693404763, 28.406823347621845,  /* hpluv */
    },
    {
        "#663355",
        0.4, 0.2, 0.3333333333333333,  /* rgb */
        0.08302660306156416, 0.05848655343809582, 0.09286233604377717,  /* xyz */
        29.027378781744666, 26.50282642151185, -16.395358666052132,  /* luv */
        29.027378781744666, 31.164203729876963, 328.25795443091044,  /* lch */
        328.25795443091044, 48.64888120995835, 29.027378781744666,  /* hsluv */
        328.25795443091044, 136.23463772164394, 29.027378781744666,  /* hpluv */
    },
    {
        "#663366",
        0.4, 0.2, 0.4,  /* rgb */
        0.09061159883507233, 0.06152055174749913, 0.13280998045092113,  /* xyz */
        29.792891089842925, 22.807528924690732, -29.493519066872047,  /* luv */
        29.792891089842925, 37.28338829289191, 307.71501294924457,  /* lch */
        307.71501294924457, 54.93889501295238, 29.792891089842925,  /* hsluv */
        307.71501294924457, 158.79691149620643, 29.792891089842925,  /* hpluv */
    },
    {
        "#663377",
        0.4, 0.2, 0.4666666666666667,  /* rgb */
        0.09992561185527425, 0.06524615695557995, 0.18186378235731904,  /* xyz */
        30.699220856666727, 19.260265577169584, -42.615114808600865,  /* luv */
        30.699220856666727, 46.765434246389034, 294.32099643727105,  /* lch */
        294.32099643727105, 60.83047161265844, 30.699220856666727,  /* hsluv */
        294.32099643727105, 193.30226579646833, 30.699220856666727,  /* hpluv */
    },
    {
        "#663388",
        0.4, 0.2, 0.5333333333333333,  /* rgb */
        0.11106602895721808, 0.06970232379635755, 0.2405366457608912,  /* xyz */
        31.73904662249725, 15.970308297427255, -55.42178125446191,  /* luv */
        31.73904662249725, 57.67689818750918, 286.07483463719143,  /* lch */
        286.07483463719143, 66.1275975958513, 31.73904662249725,  /* hsluv */
        286.07483463719143, 230.59365101932622, 31.73904662249725,  /* hpluv */
    },
    {
        "#663399",
        0.4, 0.2, 0.6,  /* rgb */
        0.1241229930662908, 0.0749251094399867, 0.3093033234020091,  /* xyz */
        32.90280659427148, 12.98040745622497, -67.75973190871973,  /* luv */
        32.90280659427148, 68.99182738608387, 280.8444976170615,  /* lch */
        280.8444976170615, 70.76187693629068, 32.90280659427148,  /* hsluv */
        280.8444976170615, 266.0749750638724, 32.90280659427148,  /* hpluv */
    },
    {
        "#6633aa",
        0.4, 0.2, 0.6666666666666666,  /* rgb */
        0.13918068603154332, 0.0809481866260878, 0.3886071730190077,  /* xyz */
        34.17958100267566, 10.290646026549602, -79.5938225097975,  /* luv */
        34.17958100267566, 80.2563017922262, 277.36687675177507,  /* lch */
        277.36687675177507, 74.74639514548143, 34.17958100267566,  /* hsluv */
        277.36687675177507, 297.9557257411632, 34.17958100267566,  /* hpluv */
    },
    {
        "#6633bb",
        0.4, 0.2, 0.7333333333333333,  /* rgb */
        0.15631827813888, 0.08780322346902256, 0.47886515811764946,  /* xyz */
        35.55785126220497, 7.878289992494395, -90.95276156638782,  /* luv */
        35.55785126220497, 91.29333102564519, 274.95057970374205,  /* lch */
        274.95057970374205, 78.13733975992982, 35.55785126220497,  /* hsluv */
        274.95057970374205, 325.793841875348, 35.55785126220497,  /* hpluv */
    },
    {
        "#6633cc",
        0.4, 0.2, 0.8,  /* rgb */
        0.17561065358260172, 0.09552017364651136, 0.5804716687879197,  /* xyz */
        37.02610046637044, 5.71114175070883, -101.89254046711957,  /* luv */
        37.02610046637044, 102.05247151803962, 273.2081081123132,  /* lch */
        273.2081081123132, 81.008127051099, 37.02610046637044,  /* hsluv */
        273.2081081123132, 349.7477089373397, 37.02610046637044,  /* hpluv */
    },
    {
        "#6633dd",
        0.4, 0.2, 0.8666666666666667,  /* rgb */
        0.19712897913323527, 0.10412750386676489, 0.6938015166879257,  /* xyz */
        38.573248788503726, 3.7552897154135048, -112.47548805160639,  /* luv */
        38.573248788503726, 112.53816069802163, 271.91225981022757,  /* lch */
        271.91225981022757, 83.8924044294761, 38.573248788503726,  /* hsluv */
        271.91225981022757, 370.21407075705815, 38.573248788503726,  /* hpluv */
    },
    {
        "#6633ee",
        0.4, 0.2, 0.9333333333333333,  /* rgb */
        0.22094115939941, 0.11365237597323494, 0.8192123327564489,  /* xyz */
        40.18893867645384, 1.9790124153653845, -122.75992920453716,  /* luv */
        40.18893867645384, 122.77587999457852, 270.92358506971516,  /* lch */
        270.92358506971516, 91.84813707252745, 40.18893867645384,  /* hsluv */
        270.92358506971516, 387.6554060376746, 40.18893867645384,  /* hpluv */
    },
    {
        "#6633ff",
        0.4, 0.2, 1.0,  /* rgb */
        0.2471122078092414, 0.12412079533716763, 0.9570465210482307,  /* xyz */
        41.86369627389516, 0.35437712343964045, -132.79609300587302,  /* luv */
        41.86369627389516, 132.79656584705077, 270.15289806252446,  /* lch */
        270.15289806252446, 99.99999999999937, 41.86369627389516,  /* hsluv */
        270.15289806252446, 402.5210527265664, 41.86369627389516,  /* hpluv */
    },
    {
        "#664400",
        0.4, 0.26666666666666666, 0.0,  /* rgb */
        0.07546398989037743, 0.06959362094236693, 0.009458558959559243,  /* xyz */
        31.714216887843683, 26.868344837487797, 31.909318028268686,  /* luv */
        31.714216887843683, 41.714656073559446, 49.90188690729244,  /* lch */
        49.90188690729244, 100.0000000000021, 31.714216887843683,  /* hsluv */
        49.90188690729244, 166.90678890006137, 31.714216887843683,  /* hpluv */
    },
    {
        "#664411",
        0.4, 0.26666666666666666, 0.06666666666666667,  /* rgb */
        0.07647565539001455, 0.06999828714222178, 0.014786663924314875,  /* xyz */
        31.806519539185622, 26.233272865779355, 28.842990669946595,  /* luv */
        31.806519539185622, 38.988494662362406, 47.71285760673844,  /* lch */
        47.71285760673844, 90.79933192884602, 31.806519539185622,  /* hsluv */
        47.71285760673844, 155.5462858420552, 31.806519539185622,  /* hpluv */
    },
    {
        "#664422",
        0.4, 0.26666666666666666, 0.13333333333333333,  /* rgb */
        0.07835101352849158, 0.0707484303976126, 0.024663550120294073,  /* xyz */
        31.976687466188103, 25.116436032279772, 23.429007731193103,  /* luv */
        31.976687466188103, 34.34754375835203, 43.009213594773406,  /* lch */
        43.009213594773406, 74.66884395585262, 31.976687466188103,  /* hsluv */
        43.009213594773406, 136.3017838702639, 31.976687466188103,  /* hpluv */
    },
    {
        "#664433",
        0.4, 0.26666666666666666, 0.2,  /* rgb */
        0.08143876426094931, 0.07198353069059571, 0.040925703977905216,  /* xyz */
        32.254264900224776, 23.430564491389866, 15.199700475999803,  /* luv */
        32.254264900224776, 27.928878368908556, 32.97197952730072,  /* lch */
        32.97197952730072, 50.45089024627595, 32.254264900224776,  /* hsluv */
        32.97197952730072, 109.87671651198593, 32.254264900224776,  /* hpluv */
    },
    {
        "#664444",
        0.4, 0.26666666666666666, 0.26666666666666666,  /* rgb */
        0.08589675950516819, 0.07376672878828329, 0.06440447893079185,  /* xyz */
        32.649475701226194, 21.280673734617743, 4.592123036699721,  /* luv */
        32.649475701226194, 21.7704999617243, 12.177050630062242,  /* lch */
        12.177050630062242, 19.82719397834044, 32.649475701226194,  /* hsluv */
        12.177050630062242, 84.6119136876739, 32.649475701226194,  /* hpluv */
    },
    {
        "#664455",
        0.4, 0.26666666666666666, 0.3333333333333333,  /* rgb */
        0.09185917354453019, 0.07615169440402812, 0.09580652620476576,  /* xyz */
        33.168223028845716, 18.8246474429619, -7.710642572012432,  /* luv */
        33.168223028845716, 20.342599642748283, 337.7258191836083,  /* lch */
        337.7258191836083, 26.99022189504039, 33.168223028845716,  /* hsluv */
        337.7258191836083, 77.82579637730286, 33.168223028845716,  /* hpluv */
    },
    {
        "#664466",
        0.4, 0.26666666666666666, 0.4,  /* rgb */
        0.09944416931803836, 0.07918569271343144, 0.13575417061190972,  /* xyz */
        33.812716844738745, 16.227364299546807, -20.98438984574164,  /* luv */
        33.812716844738745, 26.526816041663782, 307.71501294924593,  /* lch */
        307.71501294924593, 34.441515518725936, 33.812716844738745,  /* hsluv */
        307.71501294924593, 99.55071521429191, 33.812716844738745,  /* hpluv */
    },
    {
        "#664477",
        0.4, 0.26666666666666666, 0.4666666666666667,  /* rgb */
        0.10875818233824028, 0.08291129792151225, 0.18480797251830763,  /* xyz */
        34.58198795446631, 13.62718941467049, -34.61361463036465,  /* luv */
        34.58198795446631, 37.19949743105008, 291.4892864843231,  /* lch */
        291.4892864843231, 41.74253831871408, 34.58198795446631,  /* hsluv */
        291.4892864843231, 136.4980489834545, 34.58198795446631,  /* hpluv */
    },
    {
        "#664488",
        0.4, 0.26666666666666666, 0.5333333333333333,  /* rgb */
        0.1198985994401841, 0.08736746476228985, 0.2434808359218798,  /* xyz */
        35.472417602254026, 11.12124650518307, -48.15820153264411,  /* luv */
        35.472417602254026, 49.42564616358406, 283.00344461974834,  /* lch */
        283.00344461974834, 48.59052043174022, 35.472417602254026,  /* hsluv */
        283.00344461974834, 176.80758560902925, 35.472417602254026,  /* hpluv */
    },
    {
        "#664499",
        0.4, 0.26666666666666666, 0.6,  /* rgb */
        0.1329555635492568, 0.092590250405919, 0.31224751356299774,  /* xyz */
        36.478298089745756, 8.766031648715535, -61.352245097413984,  /* luv */
        36.478298089745756, 61.97532806980082, 278.1314067053718,  /* lch */
        278.1314067053718, 54.81554243822785, 36.478298089745756,  /* hsluv */
        278.1314067053718, 215.5875082467536, 36.478298089745756,  /* hpluv */
    },
    {
        "#6644aa",
        0.4, 0.26666666666666666, 0.6666666666666666,  /* rgb */
        0.14801325651450936, 0.0986133275920201, 0.3915513631799963,  /* xyz */
        37.59239846638499, 6.586023886722082, -74.06746551509116,  /* luv */
        37.59239846638499, 74.35970117251475, 275.081334091822,  /* lch */
        275.081334091822, 60.35203602081152, 37.59239846638499,  /* hsluv */
        275.081334091822, 251.0018525877771, 37.59239846638499,  /* hpluv */
    },
    {
        "#6644bb",
        0.4, 0.26666666666666666, 0.7333333333333333,  /* rgb */
        0.165150848621846, 0.10546836443495486, 0.4818093482786381,  /* xyz */
        38.80649888438304, 4.584133101532986, -86.26840067661719,  /* luv */
        38.80649888438304, 86.39011072798748, 273.0417242393652,  /* lch */
        273.0417242393652, 65.20447895492273, 38.80649888438304,  /* hsluv */
        273.0417242393652, 282.4872785030571, 38.80649888438304,  /* hpluv */
    },
    {
        "#6644cc",
        0.4, 0.26666666666666666, 0.8,  /* rgb */
        0.18444322406556773, 0.11318531461244366, 0.5834158589489082,  /* xyz */
        40.11186237473232, 2.7506633752080494, -97.9740015535209,  /* luv */
        40.11186237473232, 98.01260699222844, 271.608181870646,  /* lch */
        271.608181870646, 73.24903707812437, 40.11186237473232,  /* hsluv */
        271.608181870646, 310.0619263800039, 40.11186237473232,  /* hpluv */
    },
    {
        "#6644dd",
        0.4, 0.26666666666666666, 0.8666666666666667,  /* rgb */
        0.20596154961620128, 0.1217926448326972, 0.6967457068489142,  /* xyz */
        41.49962466283315, 1.0697560259971495, -109.2301654290472,  /* luv */
        41.49962466283315, 109.23540368219534, 270.56111373316025,  /* lch */
        270.56111373316025, 82.09829125802764, 41.49962466283315,  /* hsluv */
        270.56111373316025, 334.0093126052119, 41.49962466283315,  /* hpluv */
    },
    {
        "#6644ee",
        0.4, 0.26666666666666666, 0.9333333333333333,  /* rgb */
        0.22977372988237604, 0.13131751693916724, 0.8221565229174375,  /* xyz */
        42.96109538230403, -0.4765135709081607, -120.09241759334641,  /* luv */
        42.96109538230403, 120.09336296647687, 269.77265781005343,  /* lch */
        269.77265781005343, 90.97169441080985, 42.96109538230403,  /* hsluv */
        269.77265781005343, 354.7178038589997, 42.96109538230403,  /* hpluv */
    },
    {
        "#6644ff",
        0.4, 0.26666666666666666, 1.0,  /* rgb */
        0.2559447782922074, 0.14178593630309994, 0.9599907112092193,  /* xyz */
        44.48797437203725, -1.9057989856953557, -130.61615439053088,  /* luv */
        44.48797437203725, 130.6300572515563, 269.1640659526302,  /* lch */
        269.1640659526302, 99.99999999999935, 44.48797437203725,  /* hsluv */
        269.1640659526302, 372.5973929414921, 44.48797437203725,  /* hpluv */
    },
    {
        "#665500",
        0.4, 0.3333333333333333, 0.0,  /* rgb */
        0.0872772466047234, 0.0932201343710592, 0.013396311197674454,  /* xyz */
        36.597031120442566, 14.738450774511978, 38.80054374310786,  /* luv */
        36.597031120442566, 41.505471036883065, 69.20063640191997,  /* lch */
        69.20063640191997, 100.00000000000236, 36.597031120442566,  /* hsluv */
        69.20063640191997, 143.91259956280322, 36.597031120442566,  /* hpluv */
    },
    {
        "#665511",
        0.4, 0.3333333333333333, 0.06666666666666667,  /* rgb */
        0.08828891210436052, 0.09362480057091405, 0.018724416162430084,  /* xyz */
        36.673028710438345, 14.390130402159642, 36.09806864352504,  /* luv */
        36.673028710438345, 38.86060232142324, 68.26580140490579,  /* lch */
        68.26580140490579, 93.04494052468091, 36.673028710438345,  /* hsluv */
        68.26580140490579, 134.46277682476426, 36.673028710438345,  /* hpluv */
    },
    {
        "#665522",
        0.4, 0.3333333333333333, 0.13333333333333333,  /* rgb */
        0.09016427024283755, 0.09437494382630486, 0.028601302358409283,  /* xyz */
        36.813330770675336, 13.769229594380441, 31.271584241958504,  /* luv */
        36.813330770675336, 34.16875275196139, 66.23556759968727,  /* lch */
        66.23556759968727, 80.68532830691056, 36.813330770675336,  /* hsluv */
        66.23556759968727, 117.77777340892968, 36.813330770675336,  /* hpluv */
    },
    {
        "#665533",
        0.4, 0.3333333333333333, 0.2,  /* rgb */
        0.09325202097529528, 0.09561004411928797, 0.04486345621602043,  /* xyz */
        37.04272518126151, 12.811394571348385, 23.80140232979174,  /* luv */
        37.04272518126151, 27.030327110994985, 61.708100199128864,  /* lch */
        61.708100199128864, 61.720951391054705, 37.04272518126151,  /* hsluv */
        61.708100199128864, 92.59503459841932, 37.04272518126151,  /* hpluv */
    },
    {
        "#665544",
        0.4, 0.3333333333333333, 0.26666666666666666,  /* rgb */
        0.09771001621951415, 0.09739324221697555, 0.06834223116890706,  /* xyz */
        37.37045809064045, 11.55293061711959, 13.936623784040766,  /* luv */
        37.37045809064045, 18.102477408958976, 50.342561086283254,  /* lch */
        50.342561086283254, 37.01173395141841, 37.37045809064045,  /* hsluv */
        50.342561086283254, 61.467976871049835, 37.37045809064045,  /* hpluv */
    },
    {
        "#665555",
        0.4, 0.3333333333333333, 0.3333333333333333,  /* rgb */
        0.10367243025887615, 0.09977820783272039, 0.09974427844288097,  /* xyz */
        37.802594906838735, 10.062687659887992, 2.1714115065313786,  /* luv */
        37.802594906838735, 10.294304778427678, 12.17705063006311,  /* lch */
        12.17705063006311, 8.097379129492573, 37.802594906838735,  /* hsluv */
        12.17705063006311, 34.555305443090965, 37.802594906838735,  /* hpluv */
    },
    {
        "#665566",
        0.4, 0.3333333333333333, 0.4,  /* rgb */
        0.11125742603238432, 0.1028122061421237, 0.13969192285002494,  /* xyz */
        38.34249181974807, 8.42342892447929, -10.892743462601535,  /* luv */
        38.34249181974807, 13.769749997287635, 307.7150129492503,  /* lch */
        307.7150129492503, 15.76605063469622, 38.34249181974807,  /* hsluv */
        307.7150129492503, 45.57063163888257, 38.34249181974807,  /* hpluv */
    },
    {
        "#665577",
        0.4, 0.3333333333333333, 0.4666666666666667,  /* rgb */
        0.12057143905258624, 0.10653781135020451, 0.18874572475642284,  /* xyz */
        38.99112182703758, 6.71492531026355, -24.671805035392353,  /* luv */
        38.99112182703758, 25.56928207100914, 285.22539591020876,  /* lch */
        285.22539591020876, 23.594869704155943, 38.99112182703758,  /* hsluv */
        285.22539591020876, 83.21318213562529, 38.99112182703758,  /* hpluv */
    },
    {
        "#665588",
        0.4, 0.3333333333333333, 0.5333333333333333,  /* rgb */
        0.13171185615453007, 0.11099397819098211, 0.247418588159995,  /* xyz */
        39.747380046184055, 5.002823959529893, -38.6815269493963,  /* luv */
        39.747380046184055, 39.00370206412359, 277.36936569429434,  /* lch */
        277.36936569429434, 31.23880685338356, 39.747380046184055,  /* hsluv */
        277.36936569429434, 124.51929395965927, 39.747380046184055,  /* hpluv */
    },
    {
        "#665599",
        0.4, 0.3333333333333333, 0.6,  /* rgb */
        0.14476882026360277, 0.11621676383461127, 0.31618526580111295,  /* xyz */
        40.60840458818895, 3.3342009556423906, -52.57072515347332,  /* luv */
        40.60840458818895, 52.676351802062364, 273.6290180893103,  /* lch */
        273.6290180893103, 39.28941172681446, 40.60840458818895,  /* hsluv */
        273.6290180893103, 164.60350876551396, 40.60840458818895,  /* hpluv */
    },
    {
        "#6655aa",
        0.4, 0.3333333333333333, 0.6666666666666666,  /* rgb */
        0.15982651322885533, 0.12223984102071236, 0.3954891154181115,  /* xyz */
        41.56991408913436, 1.7382218425594453, -66.11706708381212,  /* luv */
        41.56991408913436, 66.1399121177165, 271.5059627452521,  /* lch */
        271.5059627452521, 49.66828329781271, 41.56991408913436,  /* hsluv */
        271.5059627452521, 201.8941862019546, 41.56991408913436,  /* hpluv */
    },
    {
        "#6655bb",
        0.4, 0.3333333333333333, 0.7333333333333333,  /* rgb */
        0.17696410533619197, 0.12909487786364712, 0.4857471005167533,  /* xyz */
        42.626548411756865, 0.2295257189955239, -79.2028634876978,  /* luv */
        42.626548411756865, 79.20319606371055, 270.1660396808295,  /* lch */
        270.1660396808295, 59.86538208344703, 42.626548411756865,  /* hsluv */
        270.1660396808295, 235.7772322935196, 42.626548411756865,  /* hpluv */
    },
    {
        "#6655cc",
        0.4, 0.3333333333333333, 0.8,  /* rgb */
        0.1962564807799137, 0.13681182804113592, 0.5873536111870234,  /* xyz */
        43.77219498533513, -1.1876365485041294, -91.78529431991477,  /* luv */
        43.77219498533513, 91.7929775852419, 269.2586746587239,  /* lch */
        269.2586746587239, 69.91122363924897, 43.77219498533513,  /* hsluv */
        269.2586746587239, 266.10342179287915, 43.77219498533513,  /* hpluv */
    },
    {
        "#6655dd",
        0.4, 0.3333333333333333, 0.8666666666666667,  /* rgb */
        0.21777480633054724, 0.14541915826138946, 0.7006834590870294,  /* xyz */
        45.000285088121146, -2.5156612197599095, -103.86949418145768,  /* luv */
        45.000285088121146, 103.89995367123353, 268.61259940679895,  /* lch */
        268.61259940679895, 79.87936251856827, 45.000285088121146,  /* hsluv */
        268.61259940679895, 292.98097185143456, 45.000285088121146,  /* hpluv */
    },
    {
        "#6655ee",
        0.4, 0.3333333333333333, 0.9333333333333333,  /* rgb */
        0.241586986596722, 0.1549440303678595, 0.8260942751555527,  /* xyz */
        46.30404909714241, -3.760701000110765, -115.48780589460245,  /* luv */
        46.30404909714241, 115.54902068975576, 268.13490107842597,  /* lch */
        268.13490107842597, 89.87018203850793, 46.30404909714241,  /* hsluv */
        268.13490107842597, 316.6552010189889, 46.30404909714241,  /* hpluv */
    },
    {
        "#6655ff",
        0.4, 0.3333333333333333, 1.0,  /* rgb */
        0.2677580350065534, 0.1654124497317922, 0.9639284634473345,  /* xyz */
        47.676725232621365, -4.9306576133547395, -126.68543294261592,  /* luv */
        47.676725232621365, 126.78134840881827, 267.7711458417259,  /* lch */
        267.7711458417259, 99.99999999999925, 47.676725232621365,  /* hsluv */
        267.7711458417259, 337.43356135020605, 47.676725232621365,  /* hpluv */
    },
    {
        "#666600",
        0.4, 0.4, 0.0,  /* rgb */
        0.10230530431056986, 0.12327624978275253, 0.0184056637662898,  /* xyz */
        41.73215832153946, 3.309846230255327, 45.88634049083709,  /* luv */
        41.73215832153946, 46.00555755241937, 85.87432021817474,  /* lch */
        85.87432021817474, 100.0000000000022, 41.73215832153946,  /* hsluv */
        85.87432021817474, 139.88745807479737, 41.73215832153946,  /* hpluv */
    },
    {
        "#666611",
        0.4, 0.4, 0.06666666666666667,  /* rgb */
        0.10331696981020698, 0.12368091598260739, 0.023733768731045435,  /* xyz */
        41.795259788702374, 3.1389244905755893, 43.51675211765446,  /* luv */
        41.795259788702374, 43.62981276405984, 85.8743202181746,  /* lch */
        85.8743202181746, 94.69278028807138, 41.795259788702374,  /* hsluv */
        85.8743202181746, 132.4633233253329, 41.795259788702374,  /* hpluv */
    },
    {
        "#666622",
        0.4, 0.4, 0.13333333333333333,  /* rgb */
        0.10519232794868401, 0.1244310592379982, 0.03361065492702463,  /* xyz */
        41.91186998457369, 2.831038407192595, 39.248346677737,  /* luv */
        41.91186998457369, 39.35031760226121, 85.87432021817428,  /* lch */
        85.87432021817428, 85.16707886406853, 41.91186998457369,  /* hsluv */
        85.87432021817428, 119.13806173950081, 41.91186998457369,  /* hpluv */
    },
    {
        "#666633",
        0.4, 0.4, 0.2,  /* rgb */
        0.10828007868114174, 0.12566615953098131, 0.04987280878463578,  /* xyz */
        42.102850184244495, 2.3478696229749256, 32.549894301156584,  /* luv */
        42.102850184244495, 32.634462011544706, 85.87432021817365,  /* lch */
        85.87432021817365, 70.3113616926845, 42.102850184244495,  /* hsluv */
        85.87432021817365, 98.35677660967093, 42.102850184244495,  /* hpluv */
    },
    {
        "#666644",
        0.4, 0.4, 0.26666666666666666,  /* rgb */
        0.11273807392536062, 0.1274493576286689, 0.07335158373752242,  /* xyz */
        42.376386169674156, 1.6975156972261793, 23.53365620414554,  /* luv */
        42.376386169674156, 23.59479887342223, 85.87432021817236,  /* lch */
        85.87432021817236, 50.50715546882035, 42.376386169674156,  /* hsluv */
        85.87432021817236, 70.65317593121713, 42.376386169674156,  /* hpluv */
    },
    {
        "#666655",
        0.4, 0.4, 0.3333333333333333,  /* rgb */
        0.11870048796472261, 0.12983432324441374, 0.10475363101149632,  /* xyz */
        42.738271466119954, 0.9037911653042489, 12.529787264616274,  /* luv */
        42.738271466119954, 12.562340839470254, 85.87432021816781,  /* lch */
        85.87432021816781, 26.663316449753072, 42.738271466119954,  /* hsluv */
        85.87432021816781, 37.298635619997846, 42.738271466119954,  /* hpluv */
    },
    {
        "#666666",
        0.4, 0.4, 0.4,  /* rgb */
        0.12628548373823079, 0.13286832155381703, 0.14470127541864028,  /* xyz */
        43.192289562984705, 2.150695385005745e-12, 7.480679600019983e-13,  /* luv */
        43.192289562984705, 2.277080655547045e-12, 0.0,  /* lch */
        0.0, 1.915421168830634e-12, 43.192289562984705,  /* hsluv */
        0.0, 6.689775048758389e-12, 43.192289562984705,  /* hpluv */
    },
    {
        "#666677",
        0.4, 0.4, 0.4666666666666667,  /* rgb */
        0.1355994967584327, 0.13659392676189785, 0.1937550773250382,  /* xyz */
        43.74044490746065, -0.9776041797605666, -13.553100397181431,  /* luv */
        43.74044490746065, 13.588312636540447, 265.8743202181861,  /* lch */
        265.8743202181861, 10.352795718381746, 43.74044490746065,  /* hsluv */
        265.8743202181861, 39.42045755107798, 43.74044490746065,  /* hpluv */
    },
    {
        "#666688",
        0.4, 0.4, 0.5333333333333333,  /* rgb */
        0.14673991386037655, 0.14105009360267545, 0.25242794072861036,  /* xyz */
        44.38315237238797, -1.9952189844931838, -27.660891566352042,  /* luv */
        44.38315237238797, 27.732757184267985, 265.8743202181817,  /* lch */
        265.8743202181817, 21.22541674840796, 44.38315237238797,  /* hsluv */
        265.8743202181817, 79.28923548579617, 44.38315237238797,  /* hpluv */
    },
    {
        "#666699",
        0.4, 0.4, 0.6,  /* rgb */
        0.15979687796944925, 0.1462728792463046, 0.3211946183697283,  /* xyz */
        45.11942492319423, -3.0248802016238048, -41.93568921936906,  /* luv */
        45.11942492319423, 42.0446421145154, 265.87432021818023,  /* lch */
        265.87432021818023, 32.36475419600697, 45.11942492319423,  /* hsluv */
        265.87432021818023, 118.2459925230984, 45.11942492319423,  /* hpluv */
    },
    {
        "#6666aa",
        0.4, 0.4, 0.6666666666666666,  /* rgb */
        0.1748545709347018, 0.1522959564324057, 0.4004984679867269,  /* xyz */
        45.94707147885177, -4.045783939328898, -56.08907679626621,  /* luv */
        45.94707147885177, 56.234801533758265, 265.87432021817955,  /* lch */
        265.87432021817955, 43.59903794555732, 45.94707147885177,  /* hsluv */
        265.87432021817955, 155.3054360188885, 45.94707147885177,  /* hpluv */
    },
    {
        "#6666bb",
        0.4, 0.4, 0.7333333333333333,  /* rgb */
        0.19199216304203842, 0.15915099327534046, 0.49075645308536864,  /* xyz */
        46.86290409565988, -5.044053527410496, -69.92867387532895,  /* luv */
        46.86290409565988, 70.1103551977131, 265.8743202181791,  /* lch */
        265.8743202181791, 54.83538573997553, 46.86290409565988,  /* hsluv */
        265.8743202181791, 189.84199780970695, 46.86290409565988,  /* hpluv */
    },
    {
        "#6666cc",
        0.4, 0.4, 0.8,  /* rgb */
        0.21128453848576018, 0.16686794345282926, 0.5923629637556388,  /* xyz */
        47.862947724561685, -6.01162892081844, -83.34273932243515,  /* luv */
        47.862947724561685, 83.5592716582008, 265.87432021817887,  /* lch */
        265.87432021817887, 66.04823448929777, 47.862947724561685,  /* hsluv */
        265.87432021817887, 221.53101147898275, 47.862947724561685,  /* hpluv */
    },
    {
        "#6666dd",
        0.4, 0.4, 0.8666666666666667,  /* rgb */
        0.23280286403639372, 0.1754752736730828, 0.7056928116556448,  /* xyz */
        48.94264390281171, -6.94485076081307, -96.28054130008287,  /* luv */
        48.94264390281171, 96.53068727159736, 265.8743202181787,  /* lch */
        265.8743202181787, 77.26469682826169, 48.94264390281171,  /* hsluv */
        265.8743202181787, 250.27490105408475, 48.94264390281171,  /* hpluv */
    },
    {
        "#6666ee",
        0.4, 0.4, 0.9333333333333333,  /* rgb */
        0.25661504430256843, 0.18500014577955284, 0.831103627724168,  /* xyz */
        50.09704025896562, -7.843104691876717, -108.73356263723052,  /* luv */
        50.09704025896562, 109.0160627384436, 265.8743202181785,  /* lch */
        265.8743202181785, 88.55072838966092, 50.09704025896562,  /* hsluv */
        265.8743202181785, 276.1326437379398, 50.09704025896562,  /* hpluv */
    },
    {
        "#6666ff",
        0.4, 0.4, 1.0,  /* rgb */
        0.28278609271239985, 0.19546856514348554, 0.9689378160159499,  /* xyz */
        51.320959558319714, -8.707701000140025, -120.71996859937629,  /* luv */
        51.320959558319714, 121.03361051931911, 265.8743202181784,  /* lch */
        265.8743202181784, 99.99999999999916, 51.320959558319714,  /* hsluv */
        265.8743202181784, 299.2612925932234, 51.320959558319714,  /* hpluv */
    },
    {
        "#667700",
        0.4, 0.4666666666666667, 0.0,  /* rgb */
        0.12075904236398749, 0.16018372588958832, 0.024556909784095506,  /* xyz */
        46.998583742929746, -7.237411623881503, 53.01058108738735,  /* luv */
        46.998583742929746, 53.5023535392226, 97.77439321029297,  /* lch */
        97.77439321029297, 100.00000000000242, 46.998583742929746,  /* hsluv */
        97.77439321029297, 144.45329155300468, 46.998583742929746,  /* hpluv */
    },
    {
        "#667711",
        0.4, 0.4666666666666667, 0.06666666666666667,  /* rgb */
        0.12177070786362461, 0.16058839208944317, 0.029885014748851135,  /* xyz */
        47.05158946025483, -7.302358420605768, 50.9317019768564,  /* luv */
        47.05158946025483, 51.452528652752434, 98.15920612526857,  /* lch */
        98.15920612526857, 95.88885524338406, 47.05158946025483,  /* hsluv */
        98.15920612526857, 138.7623833859824, 47.05158946025483,  /* hpluv */
    },
    {
        "#667722",
        0.4, 0.4666666666666667, 0.13333333333333333,  /* rgb */
        0.12364606600210164, 0.161338535344834, 0.039761900944830335,  /* xyz */
        47.14961287798501, -7.420446561379434, 47.1632331632727,  /* luv */
        47.14961287798501, 47.74341409643338, 98.9413563019921,  /* lch */
        98.9413563019921, 88.45626350092721, 47.14961287798501,  /* hsluv */
        98.9413563019921, 128.49157929086138, 47.14961287798501,  /* hpluv */
    },
    {
        "#667733",
        0.4, 0.4666666666666667, 0.2,  /* rgb */
        0.12673381673455936, 0.1625736356378171, 0.05602405480244148,  /* xyz */
        47.31034719694266, -7.608666681092178, 41.187830759069996,  /* luv */
        47.31034719694266, 41.88471333675037, 100.46631156170895,  /* lch */
        100.46631156170895, 76.7252257071794, 47.31034719694266,  /* hsluv */
        100.46631156170895, 112.3411172603854, 47.31034719694266,  /* hpluv */
    },
    {
        "#667744",
        0.4, 0.4666666666666667, 0.26666666666666666,  /* rgb */
        0.13119181197877824, 0.1643568337355047, 0.07950282975532812,  /* xyz */
        47.54098037552011, -7.867784767855129, 33.02644152694968,  /* luv */
        47.54098037552011, 33.95066828629916, 103.39963320178278,  /* lch */
        103.39963320178278, 60.816132979532554, 47.54098037552011,  /* hsluv */
        103.39963320178278, 90.61905324497823, 47.54098037552011,  /* hpluv */
    },
    {
        "#667755",
        0.4, 0.4666666666666667, 0.3333333333333333,  /* rgb */
        0.13715422601814026, 0.16674179935124953, 0.11090487702930202,  /* xyz */
        47.84685123369428, -8.193368645693328, 22.88298009343548,  /* luv */
        47.84685123369428, 24.305597456569444, 109.70016773335524,  /* lch */
        109.70016773335524, 41.23982633361328, 47.84685123369428,  /* hsluv */
        109.70016773335524, 64.46029148239413, 47.84685123369428,  /* hpluv */
    },
    {
        "#667766",
        0.4, 0.4666666666666667, 0.4,  /* rgb */
        0.14473922179164841, 0.16977579766065282, 0.15085252143644598,  /* xyz */
        48.231773839922354, -8.577246280104914, 11.091652126758063,  /* luv */
        48.231773839922354, 14.021194694126113, 127.71501294923249,  /* lch */
        127.71501294923249, 18.782826372202855, 48.231773839922354,  /* hsluv */
        127.71501294923249, 36.888509859032496, 48.231773839922354,  /* hpluv */
    },
    {
        "#667777",
        0.4, 0.4666666666666667, 0.4666666666666667,  /* rgb */
        0.15405323481185035, 0.17350140286873364, 0.1999063233428439,  /* xyz */
        48.698218075888136, -9.009159327094547, -1.9440722884605313,  /* luv */
        48.698218075888136, 9.21652694043341, 192.17705063005974,  /* lch */
        192.17705063005974, 23.92160205545035, 48.698218075888136,  /* hsluv */
        192.17705063005974, 24.01560618354518, 48.698218075888136,  /* hpluv */
    },
    {
        "#667788",
        0.4, 0.4666666666666667, 0.5333333333333333,  /* rgb */
        0.16519365191379415, 0.17795756970951124, 0.25857918674641606,  /* xyz */
        49.24744018802896, -9.478340192208794, -15.809950915266333,  /* luv */
        49.24744018802896, 18.43348802430976, 239.05658063802747,  /* lch */
        239.05658063802747, 29.274081353383373, 49.24744018802896,  /* hsluv */
        239.05658063802747, 47.496672625942956, 49.24744018802896,  /* hpluv */
    },
    {
        "#667799",
        0.4, 0.4666666666666667, 0.6,  /* rgb */
        0.17825061602286688, 0.1831803553531404, 0.327345864387534,  /* xyz */
        49.87960020390774, -9.97474964621831, -30.126768188683684,  /* luv */
        49.87960020390774, 31.73511922144638, 251.68067547359624,  /* lch */
        251.68067547359624, 34.66176165583535, 49.87960020390774,  /* hsluv */
        251.68067547359624, 80.73400493380618, 49.87960020390774,  /* hpluv */
    },
    {
        "#6677aa",
        0.4, 0.4666666666666667, 0.6666666666666666,  /* rgb */
        0.1933083089881194, 0.1892034325392415, 0.4066497140045326,  /* xyz */
        50.59388108500882, -10.489846362566642, -44.57849280573357,  /* luv */
        50.59388108500882, 45.79605766374538, 256.7585189194332,  /* lch */
        256.7585189194332, 39.938165635921486, 50.59388108500882,  /* hsluv */
        256.7585189194332, 114.86016197763654, 50.59388108500882,  /* hpluv */
    },
    {
        "#6677bb",
        0.4, 0.4666666666666667, 0.7333333333333333,  /* rgb */
        0.21044590109545608, 0.19605846938217625, 0.49690769910317434,  /* xyz */
        51.38861414745712, -11.01690472391583, -58.92337837687301,  /* luv */
        51.38861414745712, 59.944446857402774, 259.40968234851147,  /* lch */
        259.40968234851147, 49.210101734436336, 51.38861414745712,  /* hsluv */
        259.40968234851147, 148.0203333147309, 51.38861414745712,  /* hpluv */
    },
    {
        "#6677cc",
        0.4, 0.4666666666666667, 0.8,  /* rgb */
        0.2297382765391778, 0.20377541955966505, 0.5985142097734445,  /* xyz */
        52.26140996617242, -11.550989593165697, -72.99210636152576,  /* luv */
        52.26140996617242, 73.90042592349323, 261.00752312302825,  /* lch */
        261.00752312302825, 61.65812300085953, 52.26140996617242,  /* hsluv */
        261.00752312302825, 179.43416810270375, 52.26140996617242,  /* hpluv */
    },
    {
        "#6677dd",
        0.4, 0.4666666666666667, 0.8666666666666667,  /* rgb */
        0.2512566020898114, 0.21238274977991858, 0.7118440576734505,  /* xyz */
        53.2092913421323, -12.08872452253212, -86.6781349799548,  /* luv */
        53.2092913421323, 87.51706316019143, 262.060353074135,  /* lch */
        262.060353074135, 74.24599718923041, 53.2092913421323,  /* hsluv */
        262.060353074135, 208.71063868762056, 53.2092913421323,  /* hpluv */
    },
    {
        "#6677ee",
        0.4, 0.4666666666666667, 0.9333333333333333,  /* rgb */
        0.2750687823559861, 0.22190762188638863, 0.8372548737419737,  /* xyz */
        54.22882392578059, -12.627972310645985, -99.92476313098835,  /* luv */
        54.22882392578059, 100.71953123134843, 262.7974382314098,  /* lch */
        262.7974382314098, 87.00420805842002, 54.22882392578059,  /* hsluv */
        262.7974382314098, 235.68005803746027, 54.22882392578059,  /* hpluv */
    },
    {
        "#6677ff",
        0.4, 0.4666666666666667, 1.0,  /* rgb */
        0.3012398307658175, 0.23237604125032132, 0.9750890620337556,  /* xyz */
        55.31624016312118, -13.167510150655739, -112.71203684956622,  /* luv */
        55.31624016312118, 113.47857319487936, 263.33666199201184,  /* lch */
        263.33666199201184, 99.999999999999, 55.31624016312118,  /* hsluv */
        263.33666199201184, 260.3158065937623, 55.31624016312118,  /* hpluv */
    },
    {
        "#668800",
        0.4, 0.5333333333333333, 0.0,  /* rgb */
        0.14283141208895794, 0.20432846533952986, 0.031914366359085455,  /* xyz */
        52.32310792684153, -16.92646561439394, 60.09488810012402,  /* luv */
        52.32310792684153, 62.43317078253905, 105.73052795354684,  /* lch */
        105.73052795354684, 100.00000000000236, 52.32310792684153,  /* hsluv */
        105.73052795354684, 151.41231019632332, 52.32310792684153,  /* hpluv */
    },
    {
        "#668811",
        0.4, 0.5333333333333333, 0.06666666666666667,  /* rgb */
        0.14384307758859508, 0.20473313153938472, 0.037242471323841085,  /* xyz */
        52.36818211726222, -16.92927834925621, 58.26425179456308,  /* luv */
        52.36818211726222, 60.67391121896496, 106.20176687692808,  /* lch */
        106.20176687692808, 96.76175701279259, 52.36818211726222,  /* hsluv */
        106.20176687692808, 147.0191203657593, 52.36818211726222,  /* hpluv */
    },
    {
        "#668822",
        0.4, 0.5333333333333333, 0.13333333333333333,  /* rgb */
        0.14571843572707208, 0.20548327479477554, 0.047119357519820285,  /* xyz */
        52.4515808002199, -16.934815067551025, 54.93028503505078,  /* luv */
        52.4515808002199, 57.481511596373984, 107.1343477308673,  /* lch */
        107.1343477308673, 90.87619102808146, 52.4515808002199,  /* hsluv */
        107.1343477308673, 139.06214538658298, 52.4515808002199,  /* hpluv */
    },
    {
        "#668833",
        0.4, 0.5333333333333333, 0.2,  /* rgb */
        0.1488061864595298, 0.20671837508775864, 0.06338151137743142,  /* xyz */
        52.58845445417141, -16.944804109842632, 49.60289587860703,  /* luv */
        52.58845445417141, 52.41730311514386, 108.8606375729689,  /* lch */
        108.8606375729689, 81.50448425644807, 52.58845445417141,  /* hsluv */
        108.8606375729689, 126.48050525233442, 52.58845445417141,  /* hpluv */
    },
    {
        "#668844",
        0.4, 0.5333333333333333, 0.26666666666666666,  /* rgb */
        0.1532641817037487, 0.20850157318544624, 0.08686028633031806,  /* xyz */
        52.785109759450194, -16.961011885681856, 42.24553436788632,  /* luv */
        52.785109759450194, 45.52319297033662, 111.87479457301106,  /* lch */
        111.87479457301106, 68.63124302017037, 52.785109759450194,  /* hsluv */
        111.87479457301106, 109.43610140862177, 52.785109759450194,  /* hpluv */
    },
    {
        "#668855",
        0.4, 0.5333333333333333, 0.3333333333333333,  /* rgb */
        0.1592265957431107, 0.21088653880119107, 0.11826233360429197,  /* xyz */
        53.046384471354486, -16.985676495597104, 32.97141791563756,  /* luv */
        53.046384471354486, 37.08945409925448, 117.25587851352226,  /* lch */
        117.25587851352226, 52.52612581875042, 53.046384471354486,  /* hsluv */
        117.25587851352226, 88.72254255846927, 53.046384471354486,  /* hpluv */
    },
    {
        "#668866",
        0.4, 0.5333333333333333, 0.4,  /* rgb */
        0.16681159151661887, 0.21392053711059436, 0.15820997801143594,  /* xyz */
        53.37592968415889, -17.021394814482452, 22.01118911932472,  /* luv */
        53.37592968415889, 27.824814965731022, 127.7150129492368,  /* lch */
        127.7150129492368, 33.68185415565203, 53.37592968415889,  /* hsluv */
        127.7150129492368, 66.14943802760814, 53.37592968415889,  /* hpluv */
    },
    {
        "#668877",
        0.4, 0.5333333333333333, 0.4666666666666667,  /* rgb */
        0.1761256045368208, 0.21764614231867518, 0.20726377991783385,  /* xyz */
        53.776360618062384, -17.070922684720585, 9.673327575117721,  /* luv */
        53.776360618062384, 19.62115357677119, 150.4617138586936,  /* lch */
        150.4617138586936, 37.14841660606081, 53.776360618062384,  /* hsluv */
        150.4617138586936, 46.29909010489392, 53.776360618062384,  /* hpluv */
    },
    {
        "#668888",
        0.4, 0.5333333333333333, 0.5333333333333333,  /* rgb */
        0.1872660216387646, 0.22210230915945278, 0.265936643321406,  /* xyz */
        54.249355985551944, -17.13694311642471, -3.69795393909545,  /* luv */
        54.249355985551944, 17.531391351266098, 192.17705063006045,  /* lch */
        192.17705063006045, 40.84678057799172, 54.249355985551944,  /* hsluv */
        192.17705063006045, 41.00729516162268, 54.249355985551944,  /* hpluv */
    },
    {
        "#668899",
        0.4, 0.5333333333333333, 0.6,  /* rgb */
        0.20032298574783733, 0.22732509480308194, 0.3347033209625239,  /* xyz */
        54.79573846120297, -17.221854101330496, -17.760720004259458,  /* luv */
        54.79573846120297, 24.73934990571127, 225.88250510805096,  /* lch */
        225.88250510805096, 44.663135299821796, 54.79573846120297,  /* hsluv */
        225.88250510805096, 57.290264266671386, 54.79573846120297,  /* hpluv */
    },
    {
        "#6688aa",
        0.4, 0.5333333333333333, 0.6666666666666666,  /* rgb */
        0.21538067871308986, 0.23334817198918303, 0.4140071705795225,  /* xyz */
        55.415550825681336, -17.32761197636311, -32.204219067381764,  /* luv */
        55.415550825681336, 36.56990378088678, 241.7173448364655,  /* lch */
        241.7173448364655, 48.49521188848042, 55.415550825681336,  /* hsluv */
        241.7173448364655, 83.73971717197884, 55.415550825681336,  /* hpluv */
    },
    {
        "#6688bb",
        0.4, 0.5333333333333333, 0.7333333333333333,  /* rgb */
        0.23251827082042653, 0.2402032088321178, 0.5042651556781643,  /* xyz */
        56.108134060327146, -17.455645194441978, -46.76662700254245,  /* luv */
        56.108134060327146, 49.91810243137431, 249.5319093786818,  /* lch */
        249.5319093786818, 52.25801478647802, 56.108134060327146,  /* hsluv */
        249.5319093786818, 112.8941838879785, 56.108134060327146,  /* hpluv */
    },
    {
        "#6688cc",
        0.4, 0.5333333333333333, 0.8,  /* rgb */
        0.2518106462641483, 0.2479201590096066, 0.6058716663484345,  /* xyz */
        56.87220930965671, -17.60683485423637, -61.24230827701994,  /* luv */
        56.87220930965671, 63.72300178649698, 253.9603407999707,  /* lch */
        253.9603407999707, 56.640269560183235, 56.87220930965671,  /* hsluv */
        253.9603407999707, 142.17899915849267, 56.87220930965671,  /* hpluv */
    },
    {
        "#6688dd",
        0.4, 0.5333333333333333, 0.8666666666666667,  /* rgb */
        0.2733289718147818, 0.25652748922986013, 0.7192015142484405,  /* xyz */
        57.705963212580556, -17.781546963659327, -75.48097274774688,  /* luv */
        57.705963212580556, 77.54715120084637, 256.7441479045631,  /* lch */
        256.7441479045631, 70.75293371080875, 57.705963212580556,  /* hsluv */
        256.7441479045631, 170.52359503645997, 57.705963212580556,  /* hpluv */
    },
    {
        "#6688ee",
        0.4, 0.5333333333333333, 0.9333333333333333,  /* rgb */
        0.29714115208095654, 0.26605236133633015, 0.8446123303169637,  /* xyz */
        58.60713481777047, -17.979697586292076, -89.38165298393686,  /* luv */
        58.60713481777047, 91.17208682176485, 258.6263694925045,  /* lch */
        258.6263694925045, 85.19203676019113, 58.60713481777047,  /* hsluv */
        258.6263694925045, 197.40162879311913, 58.60713481777047,  /* hpluv */
    },
    {
        "#6688ff",
        0.4, 0.5333333333333333, 1.0,  /* rgb */
        0.3233122004907879, 0.27652078070026287, 0.9824465186087454,  /* xyz */
        59.57310174908622, -18.20083360023056, -102.88414643990608,  /* luv */
        59.57310174908622, 104.48166313957354, 259.96782236023694,  /* lch */
        259.96782236023694, 99.99999999999874, 59.57310174908622,  /* hsluv */
        259.96782236023694, 222.55081591190722, 59.57310174908622,  /* hpluv */
    },
    {
        "#669900",
        0.4, 0.6, 0.0,  /* rgb */
        0.16870101254142544, 0.25606766624446553, 0.04053756650990771,  /* xyz */
        57.661897803302196, -25.855172979480383, 67.10254388566126,  /* luv */
        57.661897803302196, 71.91134379029464, 111.07209235984739,  /* lch */
        111.07209235984739, 100.00000000000244, 57.661897803302196,  /* hsluv */
        111.07209235984739, 158.25148675418643, 57.661897803302196,  /* hpluv */
    },
    {
        "#669911",
        0.4, 0.6, 0.06666666666666667,  /* rgb */
        0.16971267804106258, 0.2564723324443204, 0.04586567147466334,  /* xyz */
        57.70068024995889, -25.822167947989787, 65.48201779280937,  /* luv */
        57.70068024995889, 70.38948083166969, 111.52129283915711,  /* lch */
        111.52129283915711, 97.40702687253278, 57.70068024995889,  /* hsluv */
        111.52129283915711, 154.79828873006002, 57.70068024995889,  /* hpluv */
    },
    {
        "#669922",
        0.4, 0.6, 0.13333333333333333,  /* rgb */
        0.17158803617953958, 0.2572224756997112, 0.05574255767064254,  /* xyz */
        57.77246480196375, -25.76222509081585, 62.52044002290944,  /* luv */
        57.77246480196375, 67.62024594962723, 112.39464107254844,  /* lch */
        112.39464107254844, 92.67572934516342, 57.77246480196375,  /* hsluv */
        112.39464107254844, 148.52350032968707, 57.77246480196375,  /* hpluv */
    },
    {
        "#669933",
        0.4, 0.6, 0.2,  /* rgb */
        0.1746757869119973, 0.2584575759926943, 0.07200471152825369,  /* xyz */
        57.89035359732375, -25.666924755992437, 57.76059157695308,  /* luv */
        57.89035359732375, 63.20662121763321, 113.95880339101524,  /* lch */
        113.95880339101524, 85.09227549517398, 57.89035359732375,  /* hsluv */
        113.95880339101524, 138.54654482110337, 57.89035359732375,  /* hpluv */
    },
    {
        "#669944",
        0.4, 0.6, 0.26666666666666666,  /* rgb */
        0.1791337821562162, 0.2602407740903819, 0.09548348648114033,  /* xyz */
        58.059896922529646, -25.53641132178582, 51.13144624174466,  /* luv */
        58.059896922529646, 57.15359217029019, 116.53876868241973,  /* lch */
        116.53876868241973, 74.57465036244318, 58.059896922529646,  /* hsluv */
        116.53876868241973, 124.91270051259428, 58.059896922529646,  /* hpluv */
    },
    {
        "#669955",
        0.4, 0.6, 0.3333333333333333,  /* rgb */
        0.1850961961955782, 0.26262573970612674, 0.12688553375511424,  /* xyz */
        58.285448901081836, -25.37401546301219, 42.683627428253416,  /* luv */
        58.285448901081836, 49.65614474716225, 120.7300937454592,  /* lch */
        120.7300937454592, 61.24953389937458, 58.285448901081836,  /* hsluv */
        120.7300937454592, 108.10659263040733, 58.285448901081836,  /* hpluv */
    },
    {
        "#669966",
        0.4, 0.6, 0.4,  /* rgb */
        0.19268119196908637, 0.26565973801553006, 0.16683317816225818,  /* xyz */
        58.570416579239875, -25.185736416182603, 32.568894230357195,  /* luv */
        58.570416579239875, 41.1710358166226, 127.71501294923827,  /* lch */
        127.71501294923827, 45.41743874088093, 58.570416579239875,  /* hsluv */
        127.71501294923827, 89.19752563142436, 58.570416579239875,  /* hpluv */
    },
    {
        "#669977",
        0.4, 0.6, 0.4666666666666667,  /* rgb */
        0.2019952049892883, 0.26938534322361085, 0.2158869800686561,  /* xyz */
        58.91739080279885, -24.97952715812321, 21.014727679876714,  /* luv */
        58.91739080279885, 32.643461159974926, 139.92683483205585,  /* lch */
        139.92683483205585, 47.78760053229218, 58.91739080279885,  /* hsluv */
        139.92683483205585, 70.30594035260185, 58.91739080279885,  /* hpluv */
    },
    {
        "#669988",
        0.4, 0.6, 0.5333333333333333,  /* rgb */
        0.2131356220912321, 0.27384151006438845, 0.2745598434722283,  /* xyz */
        59.328227692638464, -24.76444935797153, 8.295287381564755,  /* luv */
        59.328227692638464, 26.11684790985091, 161.4808212438864,  /* lch */
        161.4808212438864, 50.36553592741221, 59.328227692638464,  /* hsluv */
        161.4808212438864, 55.85971448928011, 59.328227692638464,  /* hpluv */
    },
    {
        "#669999",
        0.4, 0.6, 0.6,  /* rgb */
        0.22619258620030483, 0.2790642957080176, 0.34332652111334616,  /* xyz */
        59.804109033048604, -24.549821569472606, -5.297567294245849,  /* luv */
        59.804109033048604, 25.114895148696235, 192.17705063006062,  /* lch */
        192.17705063006062, 53.080667981315145, 59.804109033048604,  /* hsluv */
        192.17705063006062, 53.289257769771204, 59.804109033048604,  /* hpluv */
    },
    {
        "#6699aa",
        0.4, 0.6, 0.6666666666666666,  /* rgb */
        0.24125027916555736, 0.28508737289411873, 0.42263037073034476,  /* xyz */
        60.34559483863441, -24.344479090577632, -19.479458356376114,  /* luv */
        60.34559483863441, 31.178565715076804, 218.6653689057203,  /* lch */
        218.6653689057203, 55.864915307838736, 60.34559483863441,  /* hsluv */
        218.6653689057203, 65.56165177059239, 60.34559483863441,  /* hpluv */
    },
    {
        "#6699bb",
        0.4, 0.6, 0.7333333333333333,  /* rgb */
        0.25838787127289403, 0.2919424097370535, 0.5128883558289865,  /* xyz */
        60.95267455584202, -24.156224102552844, -33.99236253737342,  /* luv */
        60.95267455584202, 41.70136537051254, 234.60099737489486,  /* lch */
        234.60099737489486, 58.65712499671501, 60.95267455584202,  /* hsluv */
        234.60099737489486, 86.8154127469588, 60.95267455584202,  /* hpluv */
    },
    {
        "#6699cc",
        0.4, 0.6, 0.8,  /* rgb */
        0.27768024671661573, 0.2996593599145423, 0.6144948664992567,  /* xyz */
        61.62481981058285, -23.991493855284997, -48.61629884929701,  /* luv */
        61.62481981058285, 54.21380166721695, 243.7342764960409,  /* lch */
        243.7342764960409, 61.40579183860871, 61.62481981058285,  /* hsluv */
        243.7342764960409, 111.63323923403088, 61.62481981058285,  /* hpluv */
    },
    {
        "#6699dd",
        0.4, 0.6, 0.8666666666666667,  /* rgb */
        0.29919857226724933, 0.3082666901347958, 0.7278247143992627,  /* xyz */
        62.361039595623, -23.855231160798947, -63.17436272995223,  /* luv */
        62.361039595623, 67.52830636163424, 249.31299382043898,  /* lch */
        249.31299382043898, 66.62550454031512, 62.361039595623,  /* hsluv */
        249.31299382043898, 137.40794277733798, 62.361039595623,  /* hpluv */
    },
    {
        "#6699ee",
        0.4, 0.6, 0.9333333333333333,  /* rgb */
        0.32301075253342404, 0.3177915622412658, 0.8532355304677859,  /* xyz */
        63.159937604874045, -23.750914588458134, -77.53251101894273,  /* luv */
        63.159937604874045, 81.08881679177905, 252.96834507642063,  /* lch */
        252.96834507642063, 83.03018831339992, 63.159937604874045,  /* hsluv */
        252.96834507642063, 162.9140715358131, 63.159937604874045,  /* hpluv */
    },
    {
        "#6699ff",
        0.4, 0.6, 1.0,  /* rgb */
        0.34918180094325546, 0.32825998160519854, 0.9910697187595677,  /* xyz */
        64.01977075146212, -23.680696222440073, -91.59580793189825,  /* luv */
        64.01977075146212, 94.60743841937948, 255.50445042443192,  /* lch */
        255.50445042443192, 99.99999999999851, 64.01977075146212,  /* hsluv */
        255.50445042443192, 187.52125271543778, 64.01977075146212,  /* hpluv */
    },
    {
        "#66aa00",
        0.4, 0.6666666666666666, 0.0,  /* rgb */
        0.19853463217099473, 0.31573490550360495, 0.050482106386430525,  /* xyz */
        62.98880101150719, -34.13647120605459, 74.01827614930629,  /* luv */
        62.98880101150719, 81.51075923163002, 114.75866791007807,  /* lch */
        114.75866791007807, 100.00000000000225, 62.98880101150719,  /* hsluv */
        114.75866791007807, 164.20671887558868, 62.98880101150719,  /* hpluv */
    },
    {
        "#66aa11",
        0.4, 0.6666666666666666, 0.06666666666666667,  /* rgb */
        0.19954629767063187, 0.3161395717034598, 0.055810211351186155,  /* xyz */
        63.022532317259135, -34.08337583102673, 72.57534111148863,  /* luv */
        63.022532317259135, 80.18015119397037, 115.15604080123285,  /* lch */
        115.15604080123285, 97.8915472494395, 63.022532317259135,  /* hsluv */
        115.15604080123285, 161.4397021866978, 63.022532317259135,  /* hpluv */
    },
    {
        "#66aa22",
        0.4, 0.6666666666666666, 0.13333333333333333,  /* rgb */
        0.20142165580910887, 0.3168897149588506, 0.06568709754716535,  /* xyz */
        63.08498510823823, -33.98640029905901, 69.9313915701248,  /* luv */
        63.08498510823823, 77.75265225201004, 115.91958223160601,  /* lch */
        115.91958223160601, 94.03297637277637, 63.08498510823823,  /* hsluv */
        115.91958223160601, 156.397041701241, 63.08498510823823,  /* hpluv */
    },
    {
        "#66aa33",
        0.4, 0.6666666666666666, 0.2,  /* rgb */
        0.20450940654156663, 0.3181248152518337, 0.08194925140477649,  /* xyz */
        63.18759836827036, -33.830725074642906, 65.66328013402308,  /* luv */
        63.18759836827036, 73.86598890582364, 117.25821541047966,  /* lch */
        117.25821541047966, 87.81755682156452, 63.18759836827036,  /* hsluv */
        117.25821541047966, 148.33785473734432, 63.18759836827036,  /* hpluv */
    },
    {
        "#66aa44",
        0.4, 0.6666666666666666, 0.26666666666666666,  /* rgb */
        0.2089674017857855, 0.3199080133495213, 0.10542802635766313,  /* xyz */
        63.33528060748611, -33.614374839671044, 59.680490074220906,  /* luv */
        63.33528060748611, 68.49589105458145, 119.38990447813534,  /* lch */
        119.38990447813534, 79.13392003967951, 63.33528060748611,  /* hsluv */
        119.38990447813534, 137.23287038555728, 63.33528060748611,  /* hpluv */
    },
    {
        "#66aa55",
        0.4, 0.6666666666666666, 0.3333333333333333,  /* rgb */
        0.21492981582514747, 0.32229297896526615, 0.13683007363163704,  /* xyz */
        63.531945111636716, -33.339658593888075, 51.9915293529473,  /* luv */
        63.531945111636716, 61.76286877740861, 122.67009337440383,  /* lch */
        122.67009337440383, 68.02524611759884, 63.531945111636716,  /* hsluv */
        122.67009337440383, 123.36007777430208, 63.531945111636716,  /* hpluv */
    },
    {
        "#66aa66",
        0.4, 0.6666666666666666, 0.4,  /* rgb */
        0.22251481159865566, 0.32532697727466947, 0.176777718038781,  /* xyz */
        63.78073172939321, -33.012616843481084, 42.69021197060497,  /* luv */
        63.78073172939321, 53.96561005816273, 127.71501294923887,  /* lch */
        127.71501294923887, 54.66844892063665, 63.78073172939321,  /* hsluv */
        127.71501294923887, 107.36603624104255, 63.78073172939321,  /* hpluv */
    },
    {
        "#66aa77",
        0.4, 0.6666666666666666, 0.4666666666666667,  /* rgb */
        0.23182882461885757, 0.32905258248275027, 0.22583151994517892,  /* xyz */
        64.08412295783313, -32.64228595058059, 31.939207167085335,  /* luv */
        64.08412295783313, 45.668717811445795, 135.6237368271104,  /* lch */
        135.6237368271104, 56.31539515171643, 64.08412295783313,  /* hsluv */
        135.6237368271104, 90.42899413042463, 64.08412295783313,  /* hpluv */
    },
    {
        "#66aa88",
        0.4, 0.6666666666666666, 0.5333333333333333,  /* rgb */
        0.24296924172080142, 0.33350874932352786, 0.28450438334875106,  /* xyz */
        64.44401404242909, -32.23978546180412, 19.950375278534125,  /* luv */
        64.44401404242909, 37.913338554887275, 148.25026899586868,  /* lch */
        148.25026899586868, 58.13466861702521, 64.44401404242909,  /* hsluv */
        148.25026899586868, 74.65325904191441, 64.44401404242909,  /* hpluv */
    },
    {
        "#66aa99",
        0.4, 0.6666666666666666, 0.6,  /* rgb */
        0.2560262058298741, 0.338731534967157, 0.353271060989869,  /* xyz */
        64.86176177221714, -31.817325978958532, 6.963667939815763,  /* luv */
        64.86176177221714, 32.57046059894345, 167.6546782164461,  /* lch */
        167.6546782164461, 60.083023100845935, 64.86176177221714,  /* hsluv */
        167.6546782164461, 63.71981202728057, 64.86176177221714,  /* hpluv */
    },
    {
        "#66aaaa",
        0.4, 0.6666666666666666, 0.6666666666666666,  /* rgb */
        0.2710838987951267, 0.34475461215325814, 0.4325749106068676,  /* xyz */
        65.3382237636027, -31.387258852500235, -6.773007106487464,  /* luv */
        65.3382237636027, 32.109712604418995, 192.17705063006088,  /* lch */
        192.17705063006088, 62.116235712779876, 65.3382237636027,  /* hsluv */
        192.17705063006088, 62.36033234833046, 65.3382237636027,  /* hpluv */
    },
    {
        "#66aabb",
        0.4, 0.6666666666666666, 0.7333333333333333,  /* rgb */
        0.2882214909024633, 0.3516096489961929, 0.5228328957055093,  /* xyz */
        65.87379429065076, -30.961271344749058, -21.020864781881972,  /* luv */
        65.87379429065076, 37.422948567173925, 214.17417596211163,  /* lch */
        214.17417596211163, 64.19208378691094, 65.87379429065076,  /* hsluv */
        214.17417596211163, 72.08827774957697, 65.87379429065076,  /* hpluv */
    },
    {
        "#66aacc",
        0.4, 0.6666666666666666, 0.8,  /* rgb */
        0.30751386634618505, 0.3593265991736817, 0.6244394063757794,  /* xyz */
        66.46843978468608, -30.54979105634222, -35.5629714322516,  /* luv */
        66.46843978468608, 46.882989139743536, 229.3363102844009,  /* lch */
        229.3363102844009, 66.27255533640817, 66.46843978468608,  /* hsluv */
        229.3363102844009, 89.5033179536005, 66.46843978468608,  /* hpluv */
    },
    {
        "#66aadd",
        0.4, 0.6666666666666666, 0.8666666666666667,  /* rgb */
        0.3290321918968186, 0.3679339293939352, 0.7377692542757854,  /* xyz */
        67.12173546185075, -30.161618668811688, -50.21224252857107,  /* luv */
        67.12173546185075, 58.57467490708635, 239.0074961486522,  /* lch */
        239.0074961486522, 68.32522489275703, 67.12173546185075,  /* hsluv */
        239.0074961486522, 110.73528725840912, 67.12173546185075,  /* hpluv */
    },
    {
        "#66aaee",
        0.4, 0.6666666666666666, 0.9333333333333333,  /* rgb */
        0.35284437216299336, 0.3774588015004052, 0.8631800703443087,  /* xyz */
        67.8329035309127, -29.803771094245274, -64.81508586270826,  /* luv */
        67.8329035309127, 71.3390505041132, 245.3057188176386,  /* lch */
        245.3057188176386, 80.36289099518144, 67.8329035309127,  /* hsluv */
        245.3057188176386, 133.45235564825794, 67.8329035309127,  /* hpluv */
    },
    {
        "#66aaff",
        0.4, 0.6666666666666666, 1.0,  /* rgb */
        0.3790154205728247, 0.38792722086433795, 1.0010142586360906,  /* xyz */
        68.60085281283241, -29.481494052104104, -79.2515397475312,  /* luv */
        68.60085281283241, 84.55746592642643, 249.5948489610488,  /* lch */
        249.5948489610488, 99.9999999999981, 68.60085281283241,  /* hsluv */
        249.5948489610488, 156.4090114288652, 68.60085281283241,  /* hpluv */
    },
    {
        "#66bb00",
        0.4, 0.7333333333333333, 0.0,  /* rgb */
        0.23248913007959351, 0.3836439013208035, 0.06180027235596314,  /* xyz */
        68.2883247343563, -41.87503653985264, 80.83763130924889,  /* luv */
        68.2883247343563, 91.03977878325523, 117.38479566323439,  /* lch */
        117.38479566323439, 100.0000000000024, 68.2883247343563,  /* hsluv */
        117.38479566323439, 169.170277477244, 68.2883247343563,  /* hpluv */
    },
    {
        "#66bb11",
        0.4, 0.7333333333333333, 0.06666666666666667,  /* rgb */
        0.23350079557923065, 0.38404856752065836, 0.06712837732071877,  /* xyz */
        68.31794999397191, -41.81127334849559, 79.54520147109326,  /* luv */
        68.31794999397191, 89.86446269855195, 117.72772244142865,  /* lch */
        117.72772244142865, 98.26131308402391, 68.31794999397191,  /* hsluv */
        117.72772244142865, 166.91389144855998, 68.31794999397191,  /* hpluv */
    },
    {
        "#66bb22",
        0.4, 0.7333333333333333, 0.13333333333333333,  /* rgb */
        0.23537615371770765, 0.38479871077604916, 0.07700526351669797,  /* xyz */
        68.37281233003793, -41.69445571206356, 77.17226007493468,  /* luv */
        68.37281233003793, 87.71536559918444, 118.38136632796022,  /* lch */
        118.38136632796022, 95.07225916818668, 68.37281233003793,  /* hsluv */
        118.38136632796022, 162.79143841649272, 68.37281233003793,  /* hpluv */
    },
    {
        "#66bb33",
        0.4, 0.7333333333333333, 0.2,  /* rgb */
        0.2384639044501654, 0.3860338110690323, 0.0932674173743091,  /* xyz */
        68.46298725920278, -41.50594462882633, 73.32862002964987,  /* luv */
        68.46298725920278, 84.26048869419145, 119.51101246965615,  /* lch */
        119.51101246965615, 89.91570792775948, 68.46298725920278,  /* hsluv */
        119.51101246965615, 156.17354023796938, 68.46298725920278,  /* hpluv */
    },
    {
        "#66bb44",
        0.4, 0.7333333333333333, 0.26666666666666666,  /* rgb */
        0.24292189969438427, 0.38781700916671985, 0.11674619232719574,  /* xyz */
        68.59284023878755, -41.241896248764846, 67.91379326004358,  /* luv */
        68.59284023878755, 79.45550529171547, 121.2689844426688,  /* lch */
        121.2689844426688, 82.6706505658268, 68.59284023878755,  /* hsluv */
        121.2689844426688, 146.98889809784254, 68.59284023878755,  /* hpluv */
    },
    {
        "#66bb55",
        0.4, 0.7333333333333333, 0.3333333333333333,  /* rgb */
        0.24888431373374625, 0.3902019747824647, 0.14814823960116966,  /* xyz */
        68.76589337731147, -40.90302322833924, 60.90850135775524,  /* luv */
        68.76589337731147, 73.36826866476905, 123.88328258311009,  /* lch */
        123.88328258311009, 73.33231477626666, 68.76589337731147,  /* hsluv */
        123.88328258311009, 135.3862339969673, 68.76589337731147,  /* hpluv */
    },
    {
        "#66bb66",
        0.4, 0.7333333333333333, 0.4,  /* rgb */
        0.25646930950725444, 0.39323597309186803, 0.18809588400831362,  /* xyz */
        68.98502423385477, -40.494097329030495, 52.364876335938035,  /* luv */
        68.98502423385477, 66.19556021495005, 127.71501294923934,  /* lch */
        127.71501294923934, 61.99878794908559, 68.98502423385477,  /* hsluv */
        127.71501294923934, 121.76244699215377, 68.98502423385477,  /* hpluv */
    },
    {
        "#66bb77",
        0.4, 0.7333333333333333, 0.4666666666666667,  /* rgb */
        0.26578332252745634, 0.3969615782999488, 0.23714968591471153,  /* xyz */
        69.2525700917713, -40.02333333781991, 42.39556574291179,  /* luv */
        69.2525700917713, 58.303097740444315, 133.3513321402899,  /* lch */
        133.3513321402899, 63.1630001095548, 69.2525700917713,  /* hsluv */
        133.3513321402899, 106.83045083532747, 69.2525700917713,  /* hpluv */
    },
    {
        "#66bb88",
        0.4, 0.7333333333333333, 0.5333333333333333,  /* rgb */
        0.2769237396294002, 0.4014177451407264, 0.29582254931828367,  /* xyz */
        69.57039004479476, -39.50160334783815, 31.160458342842762,  /* luv */
        69.57039004479476, 50.31253155214889, 141.73219844426413,  /* lch */
        141.73219844426413, 64.46512917832989, 69.57039004479476,  /* hsluv */
        141.73219844426413, 91.76795596521026, 69.57039004479476,  /* hpluv */
    },
    {
        "#66bb99",
        0.4, 0.7333333333333333, 0.6,  /* rgb */
        0.2899807037384729, 0.4066405307843556, 0.3645892269594016,  /* xyz */
        69.93990654681019, -38.94153298543386, 18.851676718819554,  /* luv */
        69.93990654681019, 43.26463574753076, 154.16827985301026,  /* lch */
        154.16827985301026, 65.87875793812078, 69.93990654681019,  /* hsluv */
        154.16827985301026, 78.49596457140969, 69.93990654681019,  /* hpluv */
    },
    {
        "#66bbaa",
        0.4, 0.7333333333333333, 0.6666666666666666,  /* rgb */
        0.30503839670372546, 0.4126636079704567, 0.4438930765764002,  /* xyz */
        70.36213685839269, -38.35657107201903, 5.678227865530998,  /* luv */
        70.36213685839269, 38.774589824983835, 171.57920978229185,  /* lch */
        171.57920978229185, 67.37547943529961, 70.36213685839269,  /* hsluv */
        171.57920978229185, 69.92742217902263, 70.36213685839269,  /* hpluv */
    },
    {
        "#66bbbb",
        0.4, 0.7333333333333333, 0.7333333333333333,  /* rgb */
        0.3221759888110621, 0.41951864481339146, 0.534151061675042,  /* xyz */
        70.83771988798132, -37.76012763763702, -8.148198414950722,  /* luv */
        70.83771988798132, 38.62926839353866, 192.17705063006093,  /* lch */
        192.17705063006093, 68.92677264642288, 70.83771988798132,  /* hsluv */
        192.17705063006093, 69.19763248055946, 70.83771988798132,  /* hpluv */
    },
    {
        "#66bbcc",
        0.4, 0.7333333333333333, 0.8,  /* rgb */
        0.34146836425478383, 0.42723559499088026, 0.6357575723453122,  /* xyz */
        71.36694143922611, -37.1648552128157, -22.42509564278822,  /* luv */
        71.36694143922611, 43.4063518114314, 211.1065799827238,  /* lch */
        211.1065799827238, 70.50556749685067, 71.36694143922611,  /* hsluv */
        211.1065799827238, 77.17835682236938, 71.36694143922611,  /* hpluv */
    },
    {
        "#66bbdd",
        0.4, 0.7333333333333333, 0.8666666666666667,  /* rgb */
        0.3629866898054174, 0.43584292521113377, 0.7490874202453182,  /* xyz */
        71.94975948486136, -36.58211674338763, -36.967983186699506,  /* luv */
        71.94975948486136, 52.00849013688956, 225.3005885219118,  /* lch */
        225.3005885219118, 72.08740656330313, 71.94975948486136,  /* hsluv */
        225.3005885219118, 91.72426194817976, 71.94975948486136,  /* hpluv */
    },
    {
        "#66bbee",
        0.4, 0.7333333333333333, 0.9333333333333333,  /* rgb */
        0.3867988700715921, 0.4453677973176038, 0.8744982363138414,  /* xyz */
        72.58583024613579, -36.021650776959795, -51.61605946538511,  /* luv */
        72.58583024613579, 62.94264785843872, 235.08970555380492,  /* lch */
        235.08970555380492, 76.90895553523171, 72.58583024613579,  /* hsluv */
        235.08970555380492, 110.03541521375723, 72.58583024613579,  /* hpluv */
    },
    {
        "#66bbff",
        0.4, 0.7333333333333333, 1.0,  /* rgb */
        0.4129699184814235, 0.4558362166815365, 1.0123324246056231,  /* xyz */
        73.27453532326896, -35.491418109518264, -66.23492416500258,  /* luv */
        73.27453532326896, 75.14456692648035, 241.81574873061552,  /* lch */
        241.81574873061552, 99.99999999999766, 73.27453532326896,  /* hsluv */
        241.81574873061552, 130.13192055518988, 73.27453532326896,  /* hpluv */
    },
    {
        "#66cc00",
        0.4, 0.8, 0.0,  /* rgb */
        0.27071287338921046, 0.4600913879400384, 0.07454152012583509,  /* xyz */
        73.55146409484733, -49.16029045660296, 87.56149683157143,  /* luv */
        73.55146409484733, 100.4178763227089, 119.31147921594228,  /* lch */
        119.31147921594228, 100.00000000000226, 73.55146409484733,  /* hsluv */
        119.31147921594228, 173.24433285163656, 73.55146409484733,  /* hpluv */
    },
    {
        "#66cc11",
        0.4, 0.8, 0.06666666666666667,  /* rgb */
        0.27172453888884757, 0.46049605413989325, 0.07986962509059073,  /* xyz */
        73.57771093223906, -49.09152302199866, 86.39722562115548,  /* luv */
        73.57771093223906, 99.3703085818509, 119.60554877562399,  /* lch */
        119.60554877562399, 98.54797660161447, 73.57771093223906,  /* hsluv */
        119.60554877562399, 171.37587790833007, 73.57771093223906,  /* hpluv */
    },
    {
        "#66cc22",
        0.4, 0.8, 0.13333333333333333,  /* rgb */
        0.2735998970273246, 0.46124619739528405, 0.08974651128656992,  /* xyz */
        73.62632492926379, -48.965269014871545, 84.25623816614062,  /* luv */
        73.62632492926379, 97.45107100287893, 120.16288882343657,  /* lch */
        120.16288882343657, 95.88005763428504, 73.62632492926379,  /* hsluv */
        120.16288882343657, 167.95495458437392, 73.62632492926379,  /* hpluv */
    },
    {
        "#66cc33",
        0.4, 0.8, 0.2,  /* rgb */
        0.27668764775978233, 0.4624812976882672, 0.10600866514418106,  /* xyz */
        73.70625248272181, -48.760790830449025, 80.779114663321,  /* luv */
        73.70625248272181, 94.3550745227874, 121.11648961432712,  /* lch */
        121.11648961432712, 91.55336194757129, 73.70625248272181,  /* hsluv */
        121.11648961432712, 162.4427219147723, 73.70625248272181,  /* hpluv */
    },
    {
        "#66cc44",
        0.4, 0.8, 0.26666666666666666,  /* rgb */
        0.28114564300400124, 0.46426449578595474, 0.1294874400970677,  /* xyz */
        73.8213986639243, -48.47281782278644, 75.86134514188115,  /* luv */
        73.8213986639243, 90.02531729695073, 122.57719320324202,  /* lch */
        122.57719320324202, 85.44740486939875, 73.8213986639243,  /* hsluv */
        122.57719320324202, 154.74681456428343, 73.8213986639243,  /* hpluv */
    },
    {
        "#66cc55",
        0.4, 0.8, 0.3333333333333333,  /* rgb */
        0.28710805704336323, 0.4666494614016996, 0.1608894873710416,  /* xyz */
        73.97494272410246, -48.100513339115345, 69.46569216556321,  /* luv */
        73.97494272410246, 84.49344218060479, 124.70010461968083,  /* lch */
        124.70010461968083, 77.5306238992907, 73.97494272410246,  /* hsluv */
        124.70010461968083, 144.93647417019832, 73.97494272410246,  /* hpluv */
    },
    {
        "#66cc66",
        0.4, 0.8, 0.4,  /* rgb */
        0.2946930528168714, 0.4696834597111029, 0.20083713177818557,  /* xyz */
        74.16951728019416, -47.64703751426112, 61.614689344349394,  /* luv */
        74.16951728019416, 77.88844668425536, 127.71501294923955,  /* lch */
        127.71501294923955, 67.8510775159793, 74.16951728019416,  /* hsluv */
        127.71501294923955, 133.25604423403615, 74.16951728019416,  /* hpluv */
    },
    {
        "#66cc77",
        0.4, 0.8, 0.4666666666666667,  /* rgb */
        0.3040070658370733, 0.4734090649191837, 0.24989093368458348,  /* xyz */
        74.40730273402338, -47.11906298197572, 52.383171535080855,  /* luv */
        74.40730273402338, 70.45709869397902, 131.9716229484868,  /* lch */
        131.9716229484868, 68.68826736019075, 74.40730273402338,  /* hsluv */
        131.9716229484868, 120.15684615580753, 74.40730273402338,  /* hpluv */
    },
    {
        "#66cc88",
        0.4, 0.8, 0.5333333333333333,  /* rgb */
        0.3151474829390171, 0.4778652317599613, 0.3085637970881556,  /* xyz */
        74.69008321633936, -46.526155224959986, 41.889240498003154,  /* luv */
        74.69008321633936, 62.605044441455505, 138.00210690352299,  /* lch */
        138.00210690352299, 69.63408732954554, 74.69008321633936,  /* hsluv */
        138.00210690352299, 106.36180806600706, 74.69008321633936,  /* hpluv */
    },
    {
        "#66cc99",
        0.4, 0.8, 0.6,  /* rgb */
        0.3282044470480898, 0.4830880174035905, 0.37733047472927356,  /* xyz */
        75.01928319821404, -45.88003035660606, 30.283688778292248,  /* luv */
        75.01928319821404, 54.97343896413574, 146.57269339174667,  /* lch */
        146.57269339174667, 70.6723780843603, 75.01928319821404,  /* hsluv */
        146.57269339174667, 92.98637602969573, 75.01928319821404,  /* hpluv */
    },
    {
        "#66ccaa",
        0.4, 0.8, 0.6666666666666666,  /* rgb */
        0.3432621400133424, 0.4891110945896916, 0.45663432434627216,  /* xyz */
        75.3959940236094, -45.19374776294906, 17.73860262184417,  /* luv */
        75.3959940236094, 48.5503126646653, 158.56993049336737,  /* lch */
        158.56993049336737, 71.78495395961524, 75.3959940236094,  /* hsluv */
        158.56993049336737, 81.71148179885772, 75.3959940236094,  /* hpluv */
    },
    {
        "#66ccbb",
        0.4, 0.8, 0.7333333333333333,  /* rgb */
        0.36039973212067905, 0.49596613143262636, 0.5468923094449138,  /* xyz */
        75.8209952994642, -44.480910210515376, 4.43610979112772,  /* luv */
        75.8209952994642, 44.70157092580607, 174.30468746813747,  /* lch */
        174.30468746813747, 72.95275069912651, 75.8209952994642,  /* hsluv */
        174.30468746813747, 74.81223528060461, 75.8209952994642,  /* hpluv */
    },
    {
        "#66cccc",
        0.4, 0.8, 0.8,  /* rgb */
        0.37969210756440075, 0.5036830816101151, 0.648498820115184,  /* xyz */
        76.29477393031603, -43.75493934256419, -9.44180938207391,  /* luv */
        76.29477393031603, 44.76206520346096, 192.17705063006102,  /* lch */
        192.17705063006102, 74.15686468217257, 76.29477393031603,  /* hsluv */
        192.17705063006102, 75.6461904464395, 76.29477393031603,  /* hpluv */
    },
    {
        "#66ccdd",
        0.4, 0.8, 0.8666666666666667,  /* rgb */
        0.40121043311503435, 0.5122904118303687, 0.76182866801519,  /* xyz */
        76.81754239842458, -43.02847721180391, -23.721759076422085,  /* luv */
        76.81754239842458, 49.13422132125981, 208.8681111291976,  /* lch */
        208.8681111291976, 75.37941202126717, 76.81754239842458,  /* hsluv */
        208.8681111291976, 85.31131309700858, 76.81754239842458,  /* hpluv */
    },
    {
        "#66ccee",
        0.4, 0.8, 0.9333333333333333,  /* rgb */
        0.42502261338120906, 0.5218152839368387, 0.8872394840837132,  /* xyz */
        77.38925718016284, -42.312941633688304, -38.245235531031426,  /* luv */
        77.38925718016284, 57.035805162371304, 222.10936087291768,  /* lch */
        222.10936087291768, 76.60416826013329, 77.38925718016284,  /* hsluv */
        222.10936087291768, 102.06163183001003, 77.38925718016284,  /* hpluv */
    },
    {
        "#66ccff",
        0.4, 0.8, 1.0,  /* rgb */
        0.4511936617910405, 0.5322837033007715, 1.0250736723754952,  /* xyz */
        78.00963773776282, -41.61824068500103, -52.87273485343031,  /* luv */
        78.00963773776282, 67.28747319223557, 231.79230390155715,  /* lch */
        231.79230390155715, 99.99999999999666, 78.00963773776282,  /* hsluv */
        231.79230390155715, 124.49809490935687, 78.00963773776282,  /* hpluv */
    },
    {
        "#66dd00",
        0.4, 0.8666666666666667, 0.0,  /* rgb */
        0.3133468639363856, 0.54535936903439, 0.08875285030822641,  /* xyz */
        78.77320814432821, -56.065991901711214, 94.1932853050883,  /* luv */
        78.77320814432821, 109.61646976840893, 120.76207284072807,  /* lch */
        120.76207284072807, 100.00000000000244, 78.77320814432821,  /* hsluv */
        120.76207284072807, 211.55935101071915, 78.77320814432821,  /* hpluv */
    },
    {
        "#66dd11",
        0.4, 0.8666666666666667, 0.06666666666666667,  /* rgb */
        0.3143585294360227, 0.5457640352342449, 0.09408095527298205,  /* xyz */
        78.79664347537886, -55.99562440914737, 93.1387739746547,  /* luv */
        78.79664347537886, 108.67539358323997, 121.0145530377659,  /* lch */
        121.0145530377659, 98.77352182446619, 78.79664347537886,  /* hsluv */
        121.0145530377659, 210.01901353006315, 78.79664347537886,  /* hpluv */
    },
    {
        "#66dd22",
        0.4, 0.8666666666666667, 0.13333333333333333,  /* rgb */
        0.3162338875744998, 0.5465141784896357, 0.10395784146896124,  /* xyz */
        78.84005570892894, -55.86622730920376, 91.19722717456905,  /* luv */
        78.84005570892894, 106.9484436450273, 121.49109019175474,  /* lch */
        121.49109019175474, 96.5169147905729, 78.84005570892894,  /* hsluv */
        121.49109019175474, 207.18624621304915, 78.84005570892894,  /* hpluv */
    },
    {
        "#66dd33",
        0.4, 0.8666666666666667, 0.2,  /* rgb */
        0.3193216383069575, 0.5477492787826188, 0.12021999532657238,  /* xyz */
        78.91144687265057, -55.65609045489508, 88.03739424985089,  /* luv */
        78.91144687265057, 104.1546119527462, 122.3005394291077,  /* lch */
        122.3005394291077, 92.84870348995318, 78.91144687265057,  /* hsluv */
        122.3005394291077, 202.5864768023681, 78.91144687265057,  /* hpluv */
    },
    {
        "#66dd44",
        0.4, 0.8666666666666667, 0.26666666666666666,  /* rgb */
        0.3237796335511764, 0.5495324768803064, 0.14369877027945901,  /* xyz */
        79.01433006480717, -55.3589437481663, 83.55440459837169,  /* luv */
        79.01433006480717, 100.22949256930835, 123.52645127632185,  /* lch */
        123.52645127632185, 87.65392060409918, 79.01433006480717,  /* hsluv */
        123.52645127632185, 196.08820789864438, 79.01433006480717,  /* hpluv */
    },
    {
        "#66dd55",
        0.4, 0.8666666666666667, 0.3333333333333333,  /* rgb */
        0.3297420475905384, 0.5519174424960511, 0.17510081755343293,  /* xyz */
        79.1515854502963, -54.97265863515325, 77.69973795439388,  /* luv */
        79.1515854502963, 95.18005292916456, 125.27945296022996,  /* lch */
        125.27945296022996, 80.88680345059717, 79.1515854502963,  /* hsluv */
        125.27945296022996, 187.6657307337935, 79.1515854502963,  /* hpluv */
    },
    {
        "#66dd66",
        0.4, 0.8666666666666667, 0.4,  /* rgb */
        0.33732704336404656, 0.5549514408054544, 0.2150484619605769,  /* xyz */
        79.32562256898697, -54.49885615964507, 70.47510752150829,  /* luv */
        79.32562256898697, 89.08909081856116, 127.71501294923974,  /* lch */
        127.71501294923974, 72.5638298210149, 79.32562256898697,  /* hsluv */
        127.71501294923974, 177.41063010911756, 79.32562256898697,  /* hpluv */
    },
    {
        "#66dd77",
        0.4, 0.8666666666666667, 0.4666666666666667,  /* rgb */
        0.34664105638424847, 0.5586770460135353, 0.2641022638669748,  /* xyz */
        79.53846632257584, -53.942529626262605, 61.92710907700554,  /* luv */
        79.53846632257584, 82.12650815123921, 131.05797832605234,  /* lch */
        131.05797832605234, 73.17589704683249, 79.53846632257584,  /* hsluv */
        131.05797832605234, 165.5608864646358, 79.53846632257584,  /* hpluv */
    },
    {
        "#66dd88",
        0.4, 0.8666666666666667, 0.5333333333333333,  /* rgb */
        0.35778147348619227, 0.5631332128543128, 0.32277512727054697,  /* xyz */
        79.79180792028352, -53.3115731427918, 52.14096783413274,  /* luv */
        79.79180792028352, 74.57080097222575, 135.63600163886272,  /* lch */
        135.63600163886272, 73.87305139224544, 79.79180792028352,  /* hsluv */
        135.63600163886272, 152.5577647906669, 79.79180792028352,  /* hpluv */
    },
    {
        "#66dd99",
        0.4, 0.8666666666666667, 0.6,  /* rgb */
        0.370838437595265, 0.568355998497942, 0.3915418049116649,  /* xyz */
        80.08703784011232, -52.61620237594314, 41.23308253456099,  /* luv */
        80.08703784011232, 66.84782605117479, 141.91570887087892,  /* lch */
        141.91570887087892, 74.64537909330818, 80.08703784011232,  /* hsluv */
        141.91570887087892, 139.15046817924238, 80.08703784011232,  /* hpluv */
    },
    {
        "#66ddaa",
        0.4, 0.8666666666666667, 0.6666666666666666,  /* rgb */
        0.3858961305605175, 0.5743790756840431, 0.47084565452866345,  /* xyz */
        80.42526905819989, -51.86829722278009, 29.342672975082557,  /* luv */
        80.42526905819989, 59.59289147300454, 150.5025084478712,  /* lch */
        150.5025084478712, 75.48122815713506, 80.42526905819989,  /* hsluv */
        150.5025084478712, 126.57130878024591, 80.42526905819989,  /* hpluv */
    },
    {
        "#66ddbb",
        0.4, 0.8666666666666667, 0.7333333333333333,  /* rgb */
        0.4030337226678542, 0.5812341125269779, 0.5611036396273053,  /* xyz */
        80.80735497337456, -51.08071577320003, 16.62311111652761,  /* luv */
        80.80735497337456, 53.71747711029317, 161.9736451668376,  /* lch */
        161.9736451668376, 76.36790295543688, 80.80735497337456,  /* hsluv */
        161.9736451668376, 116.75777023574064, 80.80735497337456,  /* hpluv */
    },
    {
        "#66ddcc",
        0.4, 0.8666666666666667, 0.8,  /* rgb */
        0.42232609811157595, 0.5889510627044667, 0.6627101502975754,  /* xyz */
        81.23390456556814, -50.266633107155926, 3.233582217703689,  /* luv */
        81.23390456556814, 50.370531641904215, 176.31931413268555,  /* lch */
        176.31931413268555, 77.29233304182965, 81.23390456556814,  /* hsluv */
        176.31931413268555, 112.39366564620694, 81.23390456556814,  /* hpluv */
    },
    {
        "#66dddd",
        0.4, 0.8666666666666667, 0.8666666666666667,  /* rgb */
        0.44384442366220944, 0.5975583929247202, 0.7760399981975814,  /* xyz */
        81.70529629659579, -49.4389517336029, -10.668353455221004,  /* luv */
        81.70529629659579, 50.57690890083184, 192.177050630061,  /* lch */
        192.177050630061, 78.24166947537094, 81.70529629659579,  /* hsluv */
        192.177050630061, 116.24271456346251, 81.70529629659579,  /* hpluv */
    },
    {
        "#66ddee",
        0.4, 0.8666666666666667, 0.9333333333333333,  /* rgb */
        0.4676566039283842, 0.6070832650311903, 0.9014508142661046,  /* xyz */
        82.22169165226745, -48.60981709360266, -24.932889579391116,  /* luv */
        82.22169165226745, 54.631156867227475, 207.15414084662171,  /* lch */
        207.15414084662171, 79.2037752530793, 82.22169165226745,  /* hsluv */
        207.15414084662171, 129.7933187239995, 82.22169165226745,  /* hpluv */
    },
    {
        "#66ddff",
        0.4, 0.8666666666666667, 1.0,  /* rgb */
        0.4938276523382156, 0.617551684395123, 1.0392850025578864,  /* xyz */
        82.78304883986934, -47.79025560341584, -39.42257998913214,  /* luv */
        82.78304883986934, 61.951984178388834, 219.51950595668382,  /* lch */
        219.51950595668382, 99.9999999999957, 82.78304883986934,  /* hsluv */
        219.51950595668382, 152.7306650753561, 82.78304883986934,  /* hpluv */
    },
    {
        "#66ee00",
        0.4, 0.9333333333333333, 0.0,  /* rgb */
        0.3605256402769004, 0.6397169217154209, 0.1044791090883976,  /* xyz */
        83.95102883009035, -62.652104310472915, 100.7374854894557,  /* luv */
        83.95102883009035, 118.63105477600996, 121.87890060642158,  /* lch */
        121.87890060642158, 100.00000000000225, 83.95102883009035,  /* hsluv */
        121.87890060642158, 316.9323058124418, 83.95102883009035,  /* hpluv */
    },
    {
        "#66ee11",
        0.4, 0.9333333333333333, 0.06666666666666667,  /* rgb */
        0.36153730577653753, 0.6401215879152758, 0.10980721405315323,  /* xyz */
        83.97209975283944, -62.58216879599794, 99.77755513449884,  /* luv */
        83.97209975283944, 117.77983002122534, 122.09663171960449,  /* lch */
        122.09663171960449, 98.95341871988708, 83.97209975283944,  /* hsluv */
        122.09663171960449, 315.12898496103287, 83.97209975283944,  /* hpluv */
    },
    {
        "#66ee22",
        0.4, 0.9333333333333333, 0.13333333333333333,  /* rgb */
        0.3634126639150146, 0.6408717311706666, 0.11968410024913242,  /* xyz */
        84.01113614972795, -62.453407607221706, 98.00840173668135,  /* luv */
        84.01113614972795, 116.21563979401611, 122.50630753964116,  /* lch */
        122.50630753964116, 97.0256918708191, 84.01113614972795,  /* hsluv */
        122.50630753964116, 311.80772596199574, 84.01113614972795,  /* hpluv */
    },
    {
        "#66ee33",
        0.4, 0.9333333333333333, 0.2,  /* rgb */
        0.3665004146474723, 0.6421068314636498, 0.13594625410674357,  /* xyz */
        84.07534271397452, -62.243863903825456, 95.1242960560921,  /* luv */
        84.07534271397452, 113.67906708732706, 123.19842640224176,  /* lch */
        123.19842640224176, 93.88623202501611, 84.07534271397452,  /* hsluv */
        123.19842640224176, 306.40092293427745, 84.07534271397452,  /* hpluv */
    },
    {
        "#66ee44",
        0.4, 0.9333333333333333, 0.26666666666666666,  /* rgb */
        0.3709584098916912, 0.6438900295613373, 0.1594250290596302,  /* xyz */
        84.16789700094597, -61.94661990069899, 91.02221277020156,  /* luv */
        84.16789700094597, 110.10189342016568, 124.23787032573718,  /* lch */
        124.23787032573718, 89.42779493121483, 84.16789700094597,  /* hsluv */
        124.23787032573718, 298.7316368104554, 84.16789700094597,  /* hpluv */
    },
    {
        "#66ee55",
        0.4, 0.9333333333333333, 0.3333333333333333,  /* rgb */
        0.3769208239310532, 0.6462749951770821, 0.19082707633360413,  /* xyz */
        84.29141842379954, -61.55855010939148, 85.64686418354447,  /* luv */
        84.29141842379954, 105.47435914024307, 125.70663250341708,  /* lch */
        125.70663250341708, 83.59789642359773, 84.29141842379954,  /* hsluv */
        125.70663250341708, 288.73234358282025, 84.29141842379954,  /* hpluv */
    },
    {
        "#66ee66",
        0.4, 0.9333333333333333, 0.4,  /* rgb */
        0.3845058197045614, 0.6493089934864854, 0.23077472074074806,  /* xyz */
        84.44811594472944, -61.079959746641734, 78.98545095963706,  /* luv */
        84.44811594472944, 99.84719798746787, 127.71501294923985,  /* lch */
        127.71501294923985, 76.39326563131245, 84.44811594472944,  /* hsluv */
        127.71501294923985, 276.4533026971144, 84.44811594472944,  /* hpluv */
    },
    {
        "#66ee77",
        0.4, 0.9333333333333333, 0.4666666666666667,  /* rgb */
        0.3938198327247633, 0.6530345986945663, 0.27982852264714597,  /* xyz */
        84.63986673836044, -60.514285092298486, 71.06363501914461,  /* luv */
        84.63986673836044, 93.3381964812165, 130.41607686155143,  /* lch */
        130.41607686155143, 76.84781219581625, 84.63986673836044,  /* hsluv */
        130.41607686155143, 262.0873651270012, 84.63986673836044,  /* hpluv */
    },
    {
        "#66ee88",
        0.4, 0.9333333333333333, 0.5333333333333333,  /* rgb */
        0.4049602498267071, 0.6574907655353438, 0.33850138605071817,  /* xyz */
        84.86826290837277, -59.86773798929172, 61.94110587215885,  /* luv */
        84.86826290837277, 86.14433613778955, 134.02483469668903,  /* lch */
        134.02483469668903, 77.36901944629749, 84.86826290837277,  /* hsluv */
        134.02483469668903, 246.01801336277038, 84.86826290837277,  /* hpluv */
    },
    {
        "#66ee99",
        0.4, 0.9333333333333333, 0.6,  /* rgb */
        0.41801721393577984, 0.662713551178973, 0.40726806369183605,  /* xyz */
        85.13464156617874, -59.14886477331433, 51.70628562006417,  /* luv */
        85.13464156617874, 78.5628931277068, 138.84095273960565,  /* lch */
        138.84095273960565, 77.9507906120806, 85.13464156617874,  /* hsluv */
        138.84095273960565, 228.90588496932435, 85.13464156617874,  /* hpluv */
    },
    {
        "#66eeaa",
        0.4, 0.9333333333333333, 0.6666666666666666,  /* rgb */
        0.43307490690103234, 0.6687366283650741, 0.48657191330883465,  /* xyz */
        85.44010567728535, -58.36802974835564, 40.47023429743606,  /* luv */
        85.44010567728535, 71.02581756512414, 145.26399114769904,  /* lch */
        145.26399114769904, 78.58563920835029, 85.44010567728535,  /* hsluv */
        145.26399114769904, 211.8363063698006, 85.44010567728535,  /* hpluv */
    },
    {
        "#66eebb",
        0.4, 0.9333333333333333, 0.7333333333333333,  /* rgb */
        0.450212499008369, 0.6755916652080088, 0.5768298984074764,  /* xyz */
        85.78553965747984, -57.5368534805651, 28.360074327120103,  /* luv */
        85.78553965747984, 64.14657687113002, 153.7611846199909,  /* lch */
        153.7611846199909, 79.26510916643217, 85.78553965747984,  /* hsluv */
        153.7611846199909, 196.5425285955965, 85.78553965747984,  /* hpluv */
    },
    {
        "#66eecc",
        0.4, 0.9333333333333333, 0.8,  /* rgb */
        0.46950487445209077, 0.6833086153854977, 0.6784364090777466,  /* xyz */
        86.1716220205593, -56.66764443899155, 15.512360225009218,  /* luv */
        86.1716220205593, 58.75249140261558, 164.6907375324595,  /* lch */
        164.6907375324595, 79.98019931765681, 86.1716220205593,  /* hsluv */
        164.6907375324595, 185.64534166481818, 86.1716220205593,  /* hpluv */
    },
    {
        "#66eedd",
        0.4, 0.9333333333333333, 0.8666666666666667,  /* rgb */
        0.49102320000272426, 0.6919159456057512, 0.7917662569777526,  /* xyz */
        86.59883647059293, -55.77286216964994, 2.066822466061681,  /* luv */
        86.59883647059293, 55.811145031265816, 177.87771263442758,  /* lch */
        177.87771263442758, 80.72176410952775, 86.59883647059293,  /* hsluv */
        177.87771263442758, 182.62808895032694, 86.59883647059293,  /* hpluv */
    },
    {
        "#66eeee",
        0.4, 0.9333333333333333, 0.9333333333333333,  /* rgb */
        0.514835380268899, 0.7014408177122212, 0.9171770730462758,  /* xyz */
        87.06748229972823, -54.86464381218805, -11.839154995379852,  /* luv */
        87.06748229972823, 56.12748641835738, 192.17705063006107,  /* lch */
        192.17705063006107, 81.48086707786182, 87.06748229972823,  /* hsluv */
        192.17705063006107, 191.0669102850977, 87.06748229972823,  /* hpluv */
    },
    {
        "#66eeff",
        0.4, 0.9333333333333333, 1.0,  /* rgb */
        0.5410064286787304, 0.711909237076154, 1.0550112613380576,  /* xyz */
        87.57768461994125, -53.95441589890522, -26.07507511512896,  /* luv */
        87.57768461994125, 59.92485742370735, 205.79353643189762,  /* lch */
        205.79353643189762, 99.99999999999334, 87.57768461994125,  /* hsluv */
        205.79353643189762, 213.2765906964471, 87.57768461994125,  /* hpluv */
    },
    {
        "#66ff00",
        0.4, 1.0, 0.0,  /* rgb */
        0.41237801270657426, 0.74342166657477, 0.1217632332316217,  /* xyz */
        89.08395117222784, -68.96716981982141, 107.198919720201,  /* luv */
        89.08395117222784, 127.46795245132866, 122.75548447471023,  /* lch */
        122.75548447471023, 100.0000000000024, 89.08395117222784,  /* hsluv */
        122.75548447471023, 522.7177029135307, 89.08395117222784,  /* hpluv */
    },
    {
        "#66ff11",
        0.4, 1.0, 0.06666666666666667,  /* rgb */
        0.41338967820621136, 0.743826332774625, 0.12709133819637733,  /* xyz */
        89.10301447181409, -68.89885667511643, 106.32099483673517,  /* luv */
        89.10301447181409, 126.69335576189977, 122.94431987669387,  /* lch */
        122.94431987669387, 99.99999999999135, 89.10301447181409,  /* hsluv */
        122.94431987669387, 520.53129302948, 89.10301447181409,  /* hpluv */
    },
    {
        "#66ff22",
        0.4, 1.0, 0.13333333333333333,  /* rgb */
        0.4152650363446884, 0.7445764760300158, 0.13696822439235654,  /* xyz */
        89.13833446737078, -68.77295959585385, 104.70168300016438,  /* luv */
        89.13833446737078, 125.26836150696575, 123.29878008449495,  /* lch */
        123.29878008449495, 99.99999999999149, 89.13833446737078,  /* hsluv */
        123.29878008449495, 516.4993312536218, 89.13833446737078,  /* hpluv */
    },
    {
        "#66ff33",
        0.4, 1.0, 0.2,  /* rgb */
        0.4183527870771461, 0.7458115763229989, 0.15323037824996769,  /* xyz */
        89.1964366933732, -68.56773503037704, 102.0582546055644,  /* luv */
        89.1964366933732, 122.95292440739343, 123.8951396902124,  /* lch */
        123.8951396902124, 99.99999999999135, 89.1964366933732,  /* hsluv */
        123.8951396902124, 509.92093254051633, 89.1964366933732,  /* hpluv */
    },
    {
        "#66ff44",
        0.4, 1.0, 0.26666666666666666,  /* rgb */
        0.42281078232136504, 0.7475947744206864, 0.17670915320285432,  /* xyz */
        89.2802097655713, -68.27588694758354, 98.29081276243691,  /* luv */
        89.2802097655713, 119.67740226116057, 124.78505822481998,  /* lch */
        124.78505822481998, 99.99999999999145, 89.2802097655713,  /* hsluv */
        124.78505822481998, 500.55747958951144, 89.2802097655713,  /* hpluv */
    },
    {
        "#66ff55",
        0.4, 1.0, 0.3333333333333333,  /* rgb */
        0.428773196360727, 0.7499797400364312, 0.20811120047682824,  /* xyz */
        89.39204537206246, -67.89356011711898, 93.34034813379915,  /* luv */
        89.39204537206246, 115.42077843748791, 126.03125575861255,  /* lch */
        126.03125575861255, 99.99999999999122, 89.39204537206246,  /* hsluv */
        126.03125575861255, 488.28865267241525, 89.39204537206246,  /* hpluv */
    },
    {
        "#66ff66",
        0.4, 1.0, 0.4,  /* rgb */
        0.4363581921342352, 0.7530137383458345, 0.24805884488397217,  /* xyz */
        89.53397323485281, -67.41999830069214, 87.18406154108337,  /* luv */
        89.53397323485281, 110.21123698455047, 127.71501294923998,  /* lch */
        127.71501294923998, 99.99999999999122, 89.53397323485281,  /* hsluv */
        127.71501294923998, 473.1190638884799, 89.53397323485281,  /* hpluv */
    },
    {
        "#66ff77",
        0.4, 1.0, 0.4666666666666667,  /* rgb */
        0.4456722051544371, 0.7567393435539154, 0.2971126467903701,  /* xyz */
        89.7077333531255, -66.85729823761388, 79.83217648690862,  /* luv */
        89.7077333531255, 104.13008561539827, 129.9452671864523,  /* lch */
        129.9452671864523, 99.99999999999115, 89.7077333531255,  /* hsluv */
        129.9452671864523, 455.2032116282061, 89.7077333531255,  /* hpluv */
    },
    {
        "#66ff88",
        0.4, 1.0, 0.5333333333333333,  /* rgb */
        0.4568126222563809, 0.7611955103946929, 0.3557855101939423,  /* xyz */
        89.91481905389615, -66.21013943752344, 71.32469928005287,  /* luv */
        89.91481905389615, 97.31903869092764, 132.87030162873992,  /* lch */
        132.87030162873992, 99.99999999999083, 89.91481905389615,  /* hsluv */
        132.87030162873992, 434.89474335590836, 89.91481905389615,  /* hpluv */
    },
    {
        "#66ff99",
        0.4, 1.0, 0.6,  /* rgb */
        0.4698695863654536, 0.7664182960383221, 0.42455218783506016,  /* xyz */
        90.1565046807361, -65.48545128454488, 61.72760982462217,  /* luv */
        90.1565046807361, 89.99245604272222, 136.6920107166462,  /* lch */
        136.6920107166462, 99.99999999999099, 90.1565046807361,  /* hsluv */
        136.6920107166462, 412.83511486653276, 90.1565046807361,  /* hpluv */
    },
    {
        "#66ffaa",
        0.4, 1.0, 0.6666666666666666,  /* rgb */
        0.4849272793307062, 0.7724413732244232, 0.5038560374520588,  /* xyz */
        90.43386460745961, -64.6920148236146, 51.128406466974226,  /* luv */
        90.43386460745961, 82.45708416983287, 141.67942466328066,  /* lch */
        141.67942466328066, 99.99999999999059, 90.43386460745961,  /* hsluv */
        141.67942466328066, 390.10709074414774, 90.43386460745961,  /* hpluv */
    },
    {
        "#66ffbb",
        0.4, 1.0, 0.7333333333333333,  /* rgb */
        0.5020648714380428, 0.779296410067358, 0.5941140225507006,  /* xyz */
        90.74778717506267, -63.84001546278364, 39.63115506717236,  /* luv */
        90.74778717506267, 75.14104089142441, 148.16846032605247,  /* lch */
        148.16846032605247, 99.99999999999041, 90.74778717506267,  /* hsluv */
        148.16846032605247, 368.4861677205568, 90.74778717506267,  /* hpluv */
    },
    {
        "#66ffcc",
        0.4, 1.0, 0.8,  /* rgb */
        0.5213572468817645, 0.7870133602448468, 0.6957205332209707,  /* xyz */
        91.09898563992475, -62.94057237477371, 27.35130688263665,  /* luv */
        91.09898563992475, 68.6265957122477, 156.51227550364464,  /* lch */
        156.51227550364464, 99.99999999999035, 91.09898563992475,  /* hsluv */
        156.51227550364464, 350.80485005939914, 91.09898563992475,  /* hpluv */
    },
    {
        "#66ffdd",
        0.4, 1.0, 0.8666666666666667,  /* rgb */
        0.5428755724323981, 0.7956206904651003, 0.8090503811209767,  /* xyz */
        91.48800740964907, -62.00527337154728, 14.410588119229697,  /* luv */
        91.48800740964907, 63.65782729423299, 166.91620985452903,  /* lch */
        166.91620985452903, 99.99999999998988, 91.48800740964907,  /* hsluv */
        166.91620985452903, 341.3362951768756, 91.48800740964907,  /* hpluv */
    },
    {
        "#66ffee",
        0.4, 1.0, 0.9333333333333333,  /* rgb */
        0.5666877526985729, 0.8051455625715703, 0.9344611971894999,  /* xyz */
        91.91524237183951, -61.04574211177663, 0.9322466381658455,  /* luv */
        91.91524237183951, 61.05285999666118, 179.12508810083676,  /* lch */
        179.12508810083676, 99.9999999999894, 91.91524237183951,  /* hsluv */
        179.12508810083676, 345.8406464385836, 91.91524237183951,  /* hpluv */
    },
    {
        "#66ffff",
        0.4, 1.0, 1.0,  /* rgb */
        0.5928588011084043, 0.815613981935503, 1.0722953854812818,  /* xyz */
        92.3809308294128, -60.073259216600626, -12.963113902235467,  /* luv */
        92.3809308294128, 61.4559907165056, 192.17705063006116,  /* lch */
        192.17705063006116, 99.99999999998899, 92.3809308294128,  /* hsluv */
        192.17705063006116, 370.7654627291903, 92.3809308294128,  /* hpluv */
    },
    {
        "#770000",
        0.4666666666666667, 0.0, 0.0,  /* rgb */
        0.07607579042661859, 0.039226579438726046, 0.0035660526762476717,  /* xyz */
        23.41408682722647, 76.97064587193813, 16.609374330249285,  /* luv */
        23.41408682722647, 78.74231163475994, 12.177050630061796,  /* lch */
        12.177050630061796, 100.00000000000236, 23.41408682722647,  /* hsluv */
        12.177050630061796, 426.74678918312543, 23.41408682722647,  /* hpluv */
    },
    {
        "#770011",
        0.4666666666666667, 0.0, 0.06666666666666667,  /* rgb */
        0.07708745592625571, 0.0396312456385809, 0.008894157641003302,  /* xyz */
        23.549156936297727, 74.63086677481569, 13.01396331239708,  /* luv */
        23.549156936297727, 75.75704268684665, 9.891649473323945,  /* lch */
        9.891649473323945, 99.99999999999652, 23.549156936297727,  /* hsluv */
        9.891649473323945, 408.2131355866551, 23.549156936297727,  /* hpluv */
    },
    {
        "#770022",
        0.4666666666666667, 0.0, 0.13333333333333333,  /* rgb */
        0.07896281406473274, 0.04038138889397172, 0.0187710438369825,  /* xyz */
        23.797128737219822, 70.66519566137512, 6.850635420553274,  /* luv */
        23.797128737219822, 70.99648641676409, 5.537234094408177,  /* lch */
        5.537234094408177, 99.99999999999677, 23.797128737219822,  /* hsluv */
        5.537234094408177, 378.5747312254323, 23.797128737219822,  /* hpluv */
    },
    {
        "#770033",
        0.4666666666666667, 0.0, 0.2,  /* rgb */
        0.08205056479719047, 0.04161648918695483, 0.03503319769459364,  /* xyz */
        24.198804347572846, 65.01205509882189, -2.1111684546756653,  /* luv */
        24.198804347572846, 65.04632457269412, 358.1400595617264,  /* lch */
        358.1400595617264, 99.99999999999716, 24.198804347572846,  /* hsluv */
        358.1400595617264, 341.0893663063926, 24.198804347572846,  /* hpluv */
    },
    {
        "#770044",
        0.4666666666666667, 0.0, 0.26666666666666666,  /* rgb */
        0.08650856004140935, 0.043399687284642406, 0.05851197264748028,  /* xyz */
        24.764944554878376, 58.32387876796264, -13.045616183974492,  /* luv */
        24.764944554878376, 59.76506451230167, 347.39187464130407,  /* lch */
        347.39187464130407, 99.99999999999756, 24.764944554878376,  /* hsluv */
        347.39187464130407, 306.23114567797285, 24.764944554878376,  /* hpluv */
    },
    {
        "#770055",
        0.4666666666666667, 0.0, 0.3333333333333333,  /* rgb */
        0.09247097408077135, 0.04578465290038724, 0.08991401992145419,  /* xyz */
        25.49839478449814, 51.30698933721346, -25.026533174201873,  /* luv */
        25.49839478449814, 57.08532663976236, 333.9977966444319,  /* lch */
        333.9977966444319, 99.999999999998, 25.49839478449814,  /* hsluv */
        333.9977966444319, 284.0867484480091, 25.49839478449814,  /* hpluv */
    },
    {
        "#770066",
        0.4666666666666667, 0.0, 0.4,  /* rgb */
        0.10005596985427952, 0.04881865120979055, 0.12986166432859816,  /* xyz */
        26.39551494454721, 44.50777326210654, -37.316145396693095,  /* luv */
        26.39551494454721, 58.08129292653724, 320.0229053409443,  /* lch */
        320.0229053409443, 99.9999999999984, 26.39551494454721,  /* hsluv */
        320.0229053409443, 279.21931865954616, 26.39551494454721,  /* hpluv */
    },
    {
        "#770077",
        0.4666666666666667, 0.0, 0.4666666666666667,  /* rgb */
        0.10936998287448144, 0.05254425641787137, 0.17891546623499607,  /* xyz */
        27.447661483719436, 38.24643973205828, -49.45832155697993,  /* luv */
        27.447661483719436, 62.521322150220016, 307.7150129492436,  /* lch */
        307.7150129492436, 99.99999999999886, 27.447661483719436,  /* hsluv */
        307.7150129492436, 289.04278373048345, 27.447661483719436,  /* hpluv */
    },
    {
        "#770088",
        0.4666666666666667, 0.0, 0.5333333333333333,  /* rgb */
        0.12051039997642526, 0.05700042325864896, 0.23758832963856824,  /* xyz */
        28.64272362178957, 32.65259264257229, -61.23701246333978,  /* luv */
        28.64272362178957, 69.39858429187873, 298.06728028240104,  /* lch */
        298.06728028240104, 99.99999999999915, 28.64272362178957,  /* hsluv */
        298.06728028240104, 307.45079839081023, 28.64272362178957,  /* hpluv */
    },
    {
        "#770099",
        0.4666666666666667, 0.0, 0.6,  /* rgb */
        0.13356736408549796, 0.06222320890227812, 0.3063550072796861,  /* xyz */
        29.966572734933592, 27.73335312674328, -72.5912125469701,  /* luv */
        29.966572734933592, 77.70857748467688, 290.9092744378611,  /* lch */
        290.9092744378611, 99.99999999999936, 29.966572734933592,  /* hsluv */
        290.9092744378611, 329.0570574443157, 29.966572734933592,  /* hpluv */
    },
    {
        "#7700aa",
        0.4666666666666667, 0.0, 0.6666666666666666,  /* rgb */
        0.14862505705075052, 0.06824628608837922, 0.3856588568966847,  /* xyz */
        31.40429186188001, 23.43283364985987, -83.54058644550784,  /* luv */
        31.40429186188001, 86.7647813143177, 285.6686169020514,  /* lch */
        285.6686169020514, 99.99999999999964, 31.40429186188001,  /* hsluv */
        285.6686169020514, 350.5853774094493, 31.40429186188001,  /* hpluv */
    },
    {
        "#7700bb",
        0.4666666666666667, 0.0, 0.7333333333333333,  /* rgb */
        0.16576264915808717, 0.07510132293131398, 0.47591684199532647,  /* xyz */
        32.94111412370694, 19.671223317333475, -94.13706806810679,  /* luv */
        32.94111412370694, 96.170393631615, 281.80289560882954,  /* lch */
        281.80289560882954, 99.99999999999983, 32.94111412370694,  /* hsluv */
        281.80289560882954, 370.46095036472065, 32.94111412370694,  /* hpluv */
    },
    {
        "#7700cc",
        0.4666666666666667, 0.0, 0.8,  /* rgb */
        0.1850550246018089, 0.08281827310880278, 0.5775233526655966,  /* xyz */
        34.56306354990262, 16.366175374782372, -104.43884024930176,  /* luv */
        34.56306354990262, 105.71340051770781, 278.90615220501803,  /* lch */
        278.90615220501803, 99.99999999999987, 34.56306354990262,  /* hsluv */
        278.90615220501803, 388.1120616046167, 34.56306354990262,  /* hpluv */
    },
    {
        "#7700dd",
        0.4666666666666667, 0.0, 0.8666666666666667,  /* rgb */
        0.20657335015244244, 0.09142560332905632, 0.6908532005656026,  /* xyz */
        36.257336153459796, 13.442621855333819, -114.49871162496196,  /* luv */
        36.257336153459796, 115.28512066230272, 276.6961077563504,  /* lch */
        276.6961077563504, 100.00000000000016, 36.257336153459796,  /* hsluv */
        276.6961077563504, 403.4750572584687, 36.257336153459796,  /* hpluv */
    },
    {
        "#7700ee",
        0.4666666666666667, 0.0, 0.9333333333333333,  /* rgb */
        0.2303855304186172, 0.10095047543552635, 0.8162640166341258,  /* xyz */
        38.012479203832, 10.836138843651678, -124.36030867659363,  /* luv */
        38.012479203832, 124.83151957409054, 274.9798914098847,  /* lch */
        274.9798914098847, 100.00000000000016, 38.012479203832,  /* hsluv */
        274.9798914098847, 416.7133252993913, 38.012479203832,  /* hpluv */
    },
    {
        "#7700ff",
        0.4666666666666667, 0.0, 1.0,  /* rgb */
        0.25655657882844857, 0.11141889479945905, 0.9540982049259077,  /* xyz */
        39.818428416098904, 8.493151652275229, -134.05793939861778,  /* luv */
        39.818428416098904, 134.32670896285674, 273.6250911150011,  /* lch */
        273.6250911150011, 100.00000000000031, 39.818428416098904,  /* hsluv */
        273.6250911150011, 428.0727534061401, 39.818428416098904,  /* hpluv */
    },
    {
        "#771100",
        0.4666666666666667, 0.06666666666666667, 0.0,  /* rgb */
        0.078080190687547, 0.04323537996058292, 0.004234186096557123,  /* xyz */
        24.713435355562446, 72.16375435248924, 18.6352205622059,  /* luv */
        24.713435355562446, 74.53105988544958, 14.479461840222152,  /* lch */
        14.479461840222152, 100.00000000000217, 24.713435355562446,  /* hsluv */
        14.479461840222152, 382.68681899366925, 24.713435355562446,  /* hpluv */
    },
    {
        "#771111",
        0.4666666666666667, 0.06666666666666667, 0.06666666666666667,  /* rgb */
        0.07909185618718412, 0.043640046160437776, 0.009562291061312754,  /* xyz */
        24.84006171156132, 70.12022213878049, 15.131132192406984,  /* luv */
        24.84006171156132, 71.73420881431687, 12.177050630061824,  /* lch */
        12.177050630061824, 85.87024589571742, 24.84006171156132,  /* hsluv */
        12.177050630061824, 366.4485172236194, 24.84006171156132,  /* hpluv */
    },
    {
        "#771122",
        0.4666666666666667, 0.06666666666666667, 0.13333333333333333,  /* rgb */
        0.08096721432566115, 0.0443901894158286, 0.01943917725729195,  /* xyz */
        25.072738041320356, 66.6307123231625, 9.0883501491595,  /* luv */
        25.072738041320356, 67.24767604256496, 7.767144754923544,  /* lch */
        7.767144754923544, 86.6206298981217, 25.072738041320356,  /* hsluv */
        7.767144754923544, 340.34144922345376, 25.072738041320356,  /* hpluv */
    },
    {
        "#771133",
        0.4666666666666667, 0.06666666666666667, 0.2,  /* rgb */
        0.08405496505811888, 0.04562528970881171, 0.0357013311149031,  /* xyz */
        25.450190825983356, 61.599773884646936, 0.22503531838821597,  /* luv */
        25.450190825983356, 61.60018493100612, 0.2093111031782953,  /* lch */
        0.2093111031782953, 87.69644490224708, 25.450190825983356,  /* hsluv */
        0.2093111031782953, 307.13569981756257, 25.450190825983356,  /* hpluv */
    },
    {
        "#771144",
        0.4666666666666667, 0.06666666666666667, 0.26666666666666666,  /* rgb */
        0.08851296030233775, 0.04740848780649928, 0.059180106067789735,  /* xyz */
        25.983311393736678, 55.5618510799655, -10.700877110651854,  /* luv */
        25.983311393736678, 56.58293087468637, 349.09865661723416,  /* lch */
        349.09865661723416, 88.97620991211124, 25.983311393736678,  /* hsluv */
        349.09865661723416, 276.3314192893906, 25.983311393736678,  /* hpluv */
    },
    {
        "#771155",
        0.4666666666666667, 0.06666666666666667, 0.3333333333333333,  /* rgb */
        0.09447537434169975, 0.049793453422244116, 0.09058215334176364,  /* xyz */
        26.67583937287383, 49.127918835603694, -22.79154565040662,  /* luv */
        26.67583937287383, 54.157242934368746, 335.11235498637444,  /* lch */
        335.11235498637444, 90.32251816564204, 26.67583937287383,  /* hsluv */
        335.11235498637444, 257.6189345671989, 26.67583937287383,  /* hpluv */
    },
    {
        "#771166",
        0.4666666666666667, 0.06666666666666667, 0.4,  /* rgb */
        0.10206037011520792, 0.05282745173164743, 0.1305297977489076,  /* xyz */
        27.525577611561808, 42.79870391460974, -35.292190755702656,  /* luv */
        27.525577611561808, 55.47312669308748, 320.4907057658472,  /* lch */
        320.4907057658472, 91.62385824130644, 27.525577611561808,  /* hsluv */
        320.4907057658472, 255.73226814141128, 27.525577611561808,  /* hpluv */
    },
    {
        "#771177",
        0.4666666666666667, 0.06666666666666667, 0.4666666666666667,  /* rgb */
        0.11137438313540984, 0.056553056939728244, 0.17958359965530551,  /* xyz */
        28.525624322061, 36.890964532289296, -47.70549099909407,  /* luv */
        28.525624322061, 60.305531550491054, 307.71501294924366,  /* lch */
        307.71501294924366, 92.81094331722322, 28.525624322061,  /* hsluv */
        307.71501294924366, 268.263334170626, 28.525624322061,  /* hpluv */
    },
    {
        "#771188",
        0.4666666666666667, 0.06666666666666667, 0.5333333333333333,  /* rgb */
        0.12251480023735367, 0.06100922378050584, 0.23825646305887768,  /* xyz */
        29.66566878655287, 31.552914206387634, -59.77324367751811,  /* luv */
        29.66566878655287, 67.5901402176946, 297.8285379013071,  /* lch */
        297.8285379013071, 93.85294728846769, 29.66566878655287,  /* hsluv */
        297.8285379013071, 289.1136058827806, 29.66566878655287,  /* hpluv */
    },
    {
        "#771199",
        0.4666666666666667, 0.06666666666666667, 0.6,  /* rgb */
        0.13557176434642637, 0.066232009424135, 0.3070231406999956,  /* xyz */
        30.933250438121625, 26.81603269620033, -71.40361978877235,  /* luv */
        30.933250438121625, 76.27303932913155, 290.58395138113974,  /* lch */
        290.58395138113974, 94.74556280266486, 30.933250438121625,  /* hsluv */
        290.58395138113974, 312.8850563300989, 30.933250438121625,  /* hpluv */
    },
    {
        "#7711aa",
        0.4666666666666667, 0.06666666666666667, 0.6666666666666666,  /* rgb */
        0.15062945731167893, 0.07225508661023611, 0.3863269903169942,  /* xyz */
        32.31486805847564, 22.6461849228904, -82.59891141721042,  /* luv */
        32.31486805847564, 85.64712405486785, 285.33205660347755,  /* lch */
        285.33205660347755, 95.49926110830788, 32.31486805847564,  /* hsluv */
        285.33205660347755, 336.3176996367444, 32.31486805847564,  /* hpluv */
    },
    {
        "#7711bb",
        0.4666666666666667, 0.06666666666666667, 0.7333333333333333,  /* rgb */
        0.16776704941901557, 0.07911012345317087, 0.47658497541563594,  /* xyz */
        33.79686588255044, 18.98012444447869, -93.4042755787407,  /* luv */
        33.79686588255044, 95.3131880713117, 281.48633949344367,  /* lch */
        281.48633949344367, 96.130904738193, 33.79686588255044,  /* hsluv */
        281.48633949344367, 357.86225518910396, 33.79686588255044,  /* hpluv */
    },
    {
        "#7711cc",
        0.4666666666666667, 0.06666666666666667, 0.8,  /* rgb */
        0.1870594248627373, 0.08682707363065967, 0.5781914860859061,  /* xyz */
        35.36607449089243, 15.747097997800951, -103.87781770700215,  /* luv */
        35.36607449089243, 105.0646092027259, 278.61998037592923,  /* lch */
        278.61998037592923, 96.65877786709154, 35.36607449089243,  /* hsluv */
        278.61998037592923, 376.97184803120246, 35.36607449089243,  /* hpluv */
    },
    {
        "#7711dd",
        0.4666666666666667, 0.06666666666666667, 0.8666666666666667,  /* rgb */
        0.20857775041337084, 0.0954344038509132, 0.6915213339859121,  /* xyz */
        37.0102245888209, 12.879777082898492, -114.07577664179688,  /* luv */
        37.0102245888209, 114.80057262110799, 276.44172602496644,  /* lch */
        276.44172602496644, 97.10007373101911, 37.0102245888209,  /* hsluv */
        276.44172602496644, 393.6059549107714, 37.0102245888209,  /* hpluv */
    },
    {
        "#7711ee",
        0.4666666666666667, 0.06666666666666667, 0.9333333333333333,  /* rgb */
        0.2323899306795456, 0.10495927595738322, 0.8169321500544353,  /* xyz */
        38.718174230065465, 10.318775418426553, -124.0466048599388,  /* luv */
        38.718174230065465, 124.47504691067088, 274.7551823321968,  /* lch */
        274.7551823321968, 97.46986666172647, 38.718174230065465,  /* hsluv */
        274.7551823321968, 407.949828918098, 38.718174230065465,  /* hpluv */
    },
    {
        "#7711ff",
        0.4666666666666667, 0.06666666666666667, 1.0,  /* rgb */
        0.258560979089377, 0.11542769532131593, 0.9547663383462172,  /* xyz */
        40.4799968781786, 8.013763233169737, -133.82962357638274,  /* luv */
        40.4799968781786, 134.06934231118464, 273.4267988388625,  /* lch */
        273.4267988388625, 99.99999999999946, 40.4799968781786,  /* hsluv */
        273.4267988388625, 420.26994686079524, 40.4799968781786,  /* hpluv */
    },
    {
        "#772200",
        0.4666666666666667, 0.13333333333333333, 0.0,  /* rgb */
        0.08179581442231494, 0.05066662743011889, 0.005472727341479733,  /* xyz */
        26.923848649021394, 64.19451310585212, 22.056220750203195,  /* luv */
        26.923848649021394, 67.87792267504298, 18.96191188308662,  /* lch */
        18.96191188308662, 100.0000000000022, 26.923848649021394,  /* hsluv */
        18.96191188308662, 319.9121457392351, 26.923848649021394,  /* hpluv */
    },
    {
        "#772211",
        0.4666666666666667, 0.13333333333333333, 0.06666666666666667,  /* rgb */
        0.08280747992195206, 0.051071293629973744, 0.010800832306235363,  /* xyz */
        27.037821049585354, 62.572969867415296, 18.714044093808315,  /* luv */
        27.037821049585354, 65.31149978658785, 16.650637144536063,  /* lch */
        16.650637144536063, 87.77659617077137, 27.037821049585354,  /* hsluv */
        16.650637144536063, 306.51892518377207, 27.037821049585354,  /* hpluv */
    },
    {
        "#772222",
        0.4666666666666667, 0.13333333333333333, 0.13333333333333333,  /* rgb */
        0.08468283806042909, 0.051821436885364565, 0.02067771850221456,  /* xyz */
        27.247513158245155, 59.77333581831951, 12.898393904943463,  /* luv */
        27.247513158245155, 61.14916385509029, 12.177050630061826,  /* lch */
        12.177050630061826, 66.7317810633447, 27.247513158245155,  /* hsluv */
        12.177050630061826, 284.77573305252923, 27.247513158245155,  /* hpluv */
    },
    {
        "#772233",
        0.4666666666666667, 0.13333333333333333, 0.2,  /* rgb */
        0.08777058879288682, 0.05305653717834768, 0.0369398723598257,  /* xyz */
        27.588402888612507, 55.668063043001986, 4.2533903421916825,  /* luv */
        27.588402888612507, 55.830319472153235, 4.3692688370676755,  /* lch */
        4.3692688370676755, 69.0869865520346, 27.588402888612507,  /* hsluv */
        4.3692688370676755, 256.7928219629598, 27.588402888612507,  /* hpluv */
    },
    {
        "#772244",
        0.4666666666666667, 0.13333333333333333, 0.26666666666666666,  /* rgb */
        0.0922285840371057, 0.05483973527603525, 0.06041864731271234,  /* xyz */
        28.071358629293336, 50.63222676476142, -6.578477177901139,  /* luv */
        28.071358629293336, 51.057798122700014, 352.5972189616339,  /* lch */
        352.5972189616339, 71.95362761364689, 28.071358629293336,  /* hsluv */
        352.5972189616339, 230.80115388763826, 28.071358629293336,  /* hpluv */
    },
    {
        "#772255",
        0.4666666666666667, 0.13333333333333333, 0.3333333333333333,  /* rgb */
        0.0981909980764677, 0.057224700891780084, 0.09182069458668625,  /* xyz */
        28.701198399569087, 45.13423557362355, -18.764136701522617,  /* luv */
        28.701198399569087, 48.87936217841609, 337.4253578221666,  /* lch */
        337.4253578221666, 75.04829977797864, 28.701198399569087,  /* hsluv */
        337.4253578221666, 216.10500532769498, 28.701198399569087,  /* hpluv */
    },
    {
        "#772266",
        0.4666666666666667, 0.13333333333333333, 0.4,  /* rgb */
        0.10577599384997587, 0.060258699201183395, 0.13176833899383023,  /* xyz */
        29.477638659659334, 39.593133506591954, -31.542199968827543,  /* luv */
        29.477638659659334, 50.621404561156915, 321.4571279801886,  /* lch */
        321.4571279801886, 78.11962574106349, 29.477638659659334,  /* hsluv */
        321.4571279801886, 217.91183944378267, 29.477638659659334,  /* hpluv */
    },
    {
        "#772277",
        0.4666666666666667, 0.13333333333333333, 0.4666666666666667,  /* rgb */
        0.11509000687017779, 0.06398430440926421, 0.18082214090022813,  /* xyz */
        30.396206588785333, 34.30444041035251, -44.36073152255594,  /* luv */
        30.396206588785333, 56.07734955473301, 307.7150129492438,  /* lch */
        307.7150129492438, 80.9925899090149, 30.396206588785333,  /* hsluv */
        307.7150129492438, 234.10323648843362, 30.396206588785333,  /* hpluv */
    },
    {
        "#772288",
        0.4666666666666667, 0.13333333333333333, 0.5333333333333333,  /* rgb */
        0.1262304239721216, 0.06844047125004181, 0.2394950043038003,  /* xyz */
        31.449210023598383, 29.432687880373738, -56.89419481663281,  /* luv */
        31.449210023598383, 64.0564791390884, 297.3535749073395,  /* lch */
        297.3535749073395, 83.57253582871897, 31.449210023598383,  /* hsluv */
        297.3535749073395, 258.4595891937096, 31.449210023598383,  /* hpluv */
    },
    {
        "#772299",
        0.4666666666666667, 0.13333333333333333, 0.6,  /* rgb */
        0.13928738808119434, 0.07366325689367097, 0.3082616819449182,  /* xyz */
        32.62671833717913, 25.040297814612174, -68.99448969325611,  /* luv */
        32.62671833717913, 73.39792996179999, 289.94744705971874,  /* lch */
        289.94744705971874, 85.82720990618532, 32.62671833717913,  /* hsluv */
        289.94744705971874, 285.462946683821, 32.62671833717913,  /* hpluv */
    },
    {
        "#7722aa",
        0.4666666666666667, 0.13333333333333333, 0.6666666666666666,  /* rgb */
        0.15434508104644687, 0.07968633407977208, 0.3875655315619168,  /* xyz */
        33.91747454857272, 21.124590770718804, -80.6269963900962,  /* luv */
        33.91747454857272, 83.34843059181692, 284.6817107607691,  /* lch */
        284.6817107607691, 87.7639475735253, 33.91747454857272,  /* hsluv */
        284.6817107607691, 311.8266617655624, 33.91747454857272,  /* hpluv */
    },
    {
        "#7722bb",
        0.4666666666666667, 0.13333333333333333, 0.7333333333333333,  /* rgb */
        0.17148267315378352, 0.08654137092270683, 0.47782351666055856,  /* xyz */
        35.309672910712614, 17.64833814709175, -91.81786305999522,  /* luv */
        35.309672910712614, 93.4985765466947, 280.8801452809734,  /* lch */
        280.8801452809734, 89.41085012991117, 35.309672910712614,  /* hsluv */
        280.8801452809734, 336.0087841077101, 35.309672910712614,  /* hpluv */
    },
    {
        "#7722cc",
        0.4666666666666667, 0.13333333333333333, 0.8,  /* rgb */
        0.19077504859750527, 0.09425832110019564, 0.5794300273308287,  /* xyz */
        36.791567319594016, 14.560199239203019, -102.6190547468082,  /* luv */
        36.791567319594016, 103.6468513704768, 278.0755610584415,  /* lch */
        278.0755610584415, 90.80417719111334, 36.791567319594016,  /* hsluv */
        278.0755610584415, 357.47621489852344, 36.791567319594016,  /* hpluv */
    },
    {
        "#7722dd",
        0.4666666666666667, 0.13333333333333333, 0.8666666666666667,  /* rgb */
        0.2122933741481388, 0.10286565132044917, 0.6927598752308347,  /* xyz */
        38.35190652889666, 11.806522665958907, -113.08846505390339,  /* luv */
        38.35190652889666, 113.70309980695218, 275.9601318049922,  /* lch */
        275.9601318049922, 91.98105643337081, 38.35190652889666,  /* hsluv */
        275.9601318049922, 376.2050950271981, 38.35190652889666,  /* hpluv */
    },
    {
        "#7722ee",
        0.4666666666666667, 0.13333333333333333, 0.9333333333333333,  /* rgb */
        0.23610555441431352, 0.11239052342691919, 0.8181706912993579,  /* xyz */
        39.98021393417083, 9.337257733469828, -123.28017072625599,  /* luv */
        39.98021393417083, 123.63326767612375, 274.3313208459956,  /* lch */
        274.3313208459956, 92.97583556524168, 39.98021393417083,  /* hsluv */
        274.3313208459956, 392.40050786027524, 39.98021393417083,  /* hpluv */
    },
    {
        "#7722ff",
        0.4666666666666667, 0.13333333333333333, 1.0,  /* rgb */
        0.26227660282414494, 0.1228589427908519, 0.9560048795911398,  /* xyz */
        41.66694092145242, 7.108350608843932, -133.2406214165395,  /* luv */
        41.66694092145242, 133.43010096617576, 273.053819065229,  /* lch */
        273.053819065229, 99.9999999999994, 41.66694092145242,  /* hsluv */
        273.053819065229, 406.351179140502, 41.66694092145242,  /* hpluv */
    },
    {
        "#773300",
        0.4666666666666667, 0.2, 0.0,  /* rgb */
        0.08791353651132575, 0.0629020716081407, 0.0075119680378166135,  /* xyz */
        30.13313540486117, 53.20247099507106, 26.952799257122777,  /* luv */
        30.13313540486117, 59.640223907830325, 26.86713987196533,  /* lch */
        26.86713987196533, 100.00000000000217, 30.13313540486117,  /* hsluv */
        26.86713987196533, 251.15062812364403, 30.13313540486117,  /* hpluv */
    },
    {
        "#773311",
        0.4666666666666667, 0.2, 0.06666666666666667,  /* rgb */
        0.08892520201096286, 0.06330673780799555, 0.012840073002572245,  /* xyz */
        30.23185303241101, 52.04518743657902, 23.849209166937893,  /* luv */
        30.23185303241101, 57.24933460920744, 24.619165823846153,  /* lch */
        24.619165823846153, 89.99835765445911, 30.23185303241101,  /* hsluv */
        24.619165823846153, 240.2951483015896, 30.23185303241101,  /* hpluv */
    },
    {
        "#773322",
        0.4666666666666667, 0.2, 0.13333333333333333,  /* rgb */
        0.0908005601494399, 0.06405688106338636, 0.02271695919855144,  /* xyz */
        30.41374218658987, 50.021044685321606, 18.39008676322755,  /* luv */
        30.41374218658987, 53.29446690389142, 20.18579978595385,  /* lch */
        20.18579978595385, 72.5478159849102, 30.41374218658987,  /* hsluv */
        20.18579978595385, 222.35740076876786, 30.41374218658987,  /* hpluv */
    },
    {
        "#773333",
        0.4666666666666667, 0.2, 0.2,  /* rgb */
        0.09388831088189763, 0.06529198135636947, 0.038979113056162584,  /* xyz */
        30.71015106885926, 46.99219674407809, 10.140372053285322,  /* luv */
        30.71015106885926, 48.07383592156126, 12.177050630061919,  /* lch */
        12.177050630061919, 46.54744938548482, 30.71015106885926,  /* hsluv */
        12.177050630061919, 198.639745699191, 30.71015106885926,  /* hpluv */
    },
    {
        "#773344",
        0.4666666666666667, 0.2, 0.26666666666666666,  /* rgb */
        0.0983463061261165, 0.06707517945405705, 0.06245788800904922,  /* xyz */
        31.131573276905222, 43.17597860687288, -0.4139922481480332,  /* luv */
        31.131573276905222, 43.17796334060549, 359.45063708006825,  /* lch */
        359.45063708006825, 50.753084379908266, 31.131573276905222,  /* hsluv */
        359.45063708006825, 175.99503288464385, 31.131573276905222,  /* hpluv */
    },
    {
        "#773355",
        0.4666666666666667, 0.2, 0.3333333333333333,  /* rgb */
        0.1043087201654785, 0.06946014506980189, 0.09385993528302314,  /* xyz */
        31.683693148419316, 38.87980336559706, -12.555087427134543,  /* luv */
        31.683693148419316, 40.856692598036915, 342.10366566631876,  /* lch */
        342.10366566631876, 55.44198970416326, 31.683693148419316,  /* hsluv */
        342.10366566631876, 163.63143346806748, 31.683693148419316,  /* hpluv */
    },
    {
        "#773366",
        0.4666666666666667, 0.2, 0.4,  /* rgb */
        0.11189371593898667, 0.0724941433792052, 0.1338075796901671,  /* xyz */
        32.36809283193442, 34.410533422391495, -25.55262265656037,  /* luv */
        32.36809283193442, 42.86048687360054, 323.4031066921529,  /* lch */
        323.4031066921529, 60.25590310792539, 32.36809283193442,  /* hsluv */
        323.4031066921529, 168.0270937004172, 32.36809283193442,  /* hpluv */
    },
    {
        "#773377",
        0.4666666666666667, 0.2, 0.4666666666666667,  /* rgb */
        0.12120772895918859, 0.07621974858728602, 0.182861381596565,  /* xyz */
        33.18286532501061, 30.0135669321659, -38.81199543806742,  /* luv */
        33.18286532501061, 49.06307358774182, 307.7150129492442,  /* lch */
        307.7150129492442, 64.91096449588115, 33.18286532501061,  /* hsluv */
        307.7150129492442, 187.62045872520216, 33.18286532501061,  /* hpluv */
    },
    {
        "#773388",
        0.4666666666666667, 0.2, 0.5333333333333333,  /* rgb */
        0.13234814606113243, 0.08067591542806361, 0.24153424500013718,  /* xyz */
        34.1232577260479, 25.851052580380948, -51.92865940216269,  /* luv */
        34.1232577260479, 58.00743561664694, 296.4649759967002,  /* lch */
        296.4649759967002, 69.22266339176542, 34.1232577260479,  /* hsluv */
        296.4649759967002, 215.71110666224848, 34.1232577260479,  /* hpluv */
    },
    {
        "#773399",
        0.4666666666666667, 0.2, 0.6,  /* rgb */
        0.14540511017020513, 0.08589870107169277, 0.3103009226412551,  /* xyz */
        35.18234596783726, 22.008807486837476, -64.67379368997064,  /* luv */
        35.18234596783726, 68.3160830057283, 288.7936899209943,  /* lch */
        288.7936899209943, 73.0971646513407, 35.18234596783726,  /* hsluv */
        288.7936899209943, 246.39817629942024, 35.18234596783726,  /* hpluv */
    },
    {
        "#7733aa",
        0.4666666666666667, 0.2, 0.6666666666666666,  /* rgb */
        0.1604628031354577, 0.09192177825779388, 0.3896047722582537,  /* xyz */
        36.3517007299652, 18.51598852110156, -76.94937202946917,  /* luv */
        36.3517007299652, 79.14573700865523, 283.5296203168499,  /* lch */
        283.5296203168499, 76.50772730759141, 36.3517007299652,  /* hsluv */
        283.5296203168499, 276.27533857597143, 36.3517007299652,  /* hpluv */
    },
    {
        "#7733bb",
        0.4666666666666667, 0.2, 0.7333333333333333,  /* rgb */
        0.1776003952427943, 0.09877681510072864, 0.47986275735689543,  /* xyz */
        37.62199842169605, 15.365863902292558, -88.74041100743456,  /* luv */
        37.62199842169605, 90.06092559613292, 279.823655256592,  /* lch */
        279.823655256592, 79.46990020380086, 37.62199842169605,  /* hsluv */
        279.823655256592, 303.76229946694735, 37.62199842169605,  /* hpluv */
    },
    {
        "#7733cc",
        0.4666666666666667, 0.2, 0.8,  /* rgb */
        0.19689277068651606, 0.10649376527821744, 0.5814692680271656,  /* xyz */
        38.98354243103647, 12.53230597176099, -100.07717549293552,  /* luv */
        38.98354243103647, 100.85881095677091, 277.13778907249014,  /* lch */
        277.13778907249014, 82.0218198813884, 38.98354243103647,  /* hsluv */
        277.13778907249014, 328.3007459515093, 38.98354243103647,  /* hpluv */
    },
    {
        "#7733dd",
        0.4666666666666667, 0.2, 0.8666666666666667,  /* rgb */
        0.2184110962371496, 0.11510109549847097, 0.6947991159271716,  /* xyz */
        40.42667697039025, 9.98093438608736, -111.00984890777067,  /* luv */
        40.42667697039025, 111.45764040991293, 275.1376692312497,  /* lch */
        275.1376692312497, 84.21087533202665, 40.42667697039025,  /* hsluv */
        275.1376692312497, 349.8493947752789, 40.42667697039025,  /* hpluv */
    },
    {
        "#7733ee",
        0.4666666666666667, 0.2, 0.9333333333333333,  /* rgb */
        0.24222327650332434, 0.12462596760494099, 0.8202099319956948,  /* xyz */
        41.94209185904511, 7.675786509408708, -121.59356110041139,  /* luv */
        41.94209185904511, 121.83559331992231, 273.6120940723041,  /* lch */
        273.6120940723041, 91.32288067292777, 41.94209185904511,  /* hsluv */
        273.6120940723041, 368.60686728115815, 41.94209185904511,  /* hpluv */
    },
    {
        "#7733ff",
        0.4666666666666667, 0.2, 1.0,  /* rgb */
        0.26839432491315574, 0.13509438696887371, 0.9580441202874767,  /* xyz */
        43.52102811039561, 5.582859798729542, -131.88058319125102,  /* luv */
        43.52102811039561, 131.9986990329706, 272.42403713962017,  /* lch */
        272.42403713962017, 99.99999999999936, 43.52102811039561,  /* hsluv */
        272.42403713962017, 384.86625251012055, 43.52102811039561,  /* hpluv */
    },
    {
        "#774400",
        0.4666666666666667, 0.26666666666666666, 0.0,  /* rgb */
        0.09674610699429179, 0.08056721257407301, 0.010456158198805209,  /* xyz */
        34.10073555572836, 40.648842977615686, 32.88041394839865,  /* luv */
        34.10073555572836, 52.282406762092585, 38.96902482801039,  /* lch */
        38.96902482801039, 100.0000000000023, 34.10073555572836,  /* hsluv */
        38.96902482801039, 194.54996243552577, 34.10073555572836,  /* hpluv */
    },
    {
        "#774411",
        0.4666666666666667, 0.26666666666666666, 0.06666666666666667,  /* rgb */
        0.0977577724939289, 0.08097187877392786, 0.015784263163560838,  /* xyz */
        34.18447609311787, 39.888591577326316, 30.061752945084873,  /* luv */
        34.18447609311787, 49.9480603042207, 37.00324600663896,  /* lch */
        37.00324600663896, 92.07742667971745, 34.18447609311787,  /* hsluv */
        37.00324600663896, 185.4082375243967, 34.18447609311787,  /* hpluv */
    },
    {
        "#774422",
        0.4666666666666667, 0.26666666666666666, 0.13333333333333333,  /* rgb */
        0.09963313063240593, 0.08172202202931868, 0.025661149359540038,  /* xyz */
        34.338973716170564, 38.542488289151045, 25.052006910966487,  /* luv */
        34.338973716170564, 45.96875519074296, 33.02322958170128,  /* lch */
        33.02322958170128, 78.08039419272798, 34.338973716170564,  /* hsluv */
        33.02322958170128, 169.86924582672148, 34.338973716170564,  /* hpluv */
    },
    {
        "#774433",
        0.4666666666666667, 0.26666666666666666, 0.2,  /* rgb */
        0.10272088136486367, 0.08295712232230179, 0.04192330321715118,  /* xyz */
        34.59130498946528, 36.488581466088775, 17.357364174931714,  /* luv */
        34.59130498946528, 40.406616642681186, 25.440107700920127,  /* lch */
        25.440107700920127, 56.80509532274027, 34.59130498946528,  /* hsluv */
        25.440107700920127, 148.2261632601194, 34.59130498946528,  /* hpluv */
    },
    {
        "#774444",
        0.4666666666666667, 0.26666666666666666, 0.26666666666666666,  /* rgb */
        0.10717887660908254, 0.08474032041998937, 0.06540207817003782,  /* xyz */
        34.95123201536173, 33.83141146835793, 7.300426946313607,  /* luv */
        34.95123201536173, 34.61012331009241, 12.17705063006209,  /* lch */
        12.17705063006209, 29.444875468963904, 34.95123201536173,  /* hsluv */
        12.17705063006209, 125.65506064276836, 34.95123201536173,  /* hpluv */
    },
    {
        "#774455",
        0.4666666666666667, 0.26666666666666666, 0.3333333333333333,  /* rgb */
        0.11314129064844454, 0.0871252860357342, 0.09680412544401173,  /* xyz */
        35.42481383918389, 30.744943802749887, -4.550852148422306,  /* luv */
        35.42481383918389, 31.079926394878232, 351.5802420928885,  /* lch */
        351.5802420928885, 35.052507198141186, 35.42481383918389,  /* hsluv */
        351.5802420928885, 111.32987756722501, 35.42481383918389,  /* hpluv */
    },
    {
        "#774466",
        0.4666666666666667, 0.26666666666666666, 0.4,  /* rgb */
        0.12072628642195271, 0.09015928434513752, 0.1367517698511557,  /* xyz */
        36.01494470563987, 27.42433770552973, -17.54740785991981,  /* luv */
        36.01494470563987, 32.55773059028094, 327.3869353366618,  /* lch */
        327.3869353366618, 41.01622017854385, 36.01494470563987,  /* hsluv */
        327.3869353366618, 114.71248800968061, 36.01494470563987,  /* hpluv */
    },
    {
        "#774477",
        0.4666666666666667, 0.26666666666666666, 0.4666666666666667,  /* rgb */
        0.13004029944215462, 0.09388488955321833, 0.1858055717575536,  /* xyz */
        36.72175870515229, 24.04598187459838, -31.095022491996406,  /* luv */
        36.72175870515229, 39.30788302734295, 307.71501294924497,  /* lch */
        307.71501294924497, 46.99302237446034, 36.72175870515229,  /* hsluv */
        307.71501294924497, 135.82994003022975, 36.72175870515229,  /* hpluv */
    },
    {
        "#774488",
        0.4666666666666667, 0.26666666666666666, 0.5333333333333333,  /* rgb */
        0.14118071654409847, 0.09834105639399593, 0.24447843516112577,  /* xyz */
        37.54303016862313, 20.744973206910416, -44.731470651041306,  /* luv */
        37.54303016862313, 49.30779228438849, 294.8803071305058,  /* lch */
        294.8803071305058, 52.72297502868838, 37.54303016862313,  /* hsluv */
        294.8803071305058, 166.65776828250958, 37.54303016862313,  /* hpluv */
    },
    {
        "#774499",
        0.4666666666666667, 0.26666666666666666, 0.6,  /* rgb */
        0.15423768065317117, 0.10356384203762509, 0.31324511280224365,  /* xyz */
        38.47459880525957, 17.609743748149274, -58.145930907339604,  /* luv */
        38.47459880525957, 60.75403160249198, 286.84916089992527,  /* lch */
        286.84916089992527, 58.039190861475774, 38.47459880525957,  /* hsluv */
        286.84916089992527, 200.37352082020084, 38.47459880525957,  /* hpluv */
    },
    {
        "#7744aa",
        0.4666666666666667, 0.26666666666666666, 0.6666666666666666,  /* rgb */
        0.16929537361842373, 0.10958691922372618, 0.39254896241924225,  /* xyz */
        39.51080966502063, 14.687860039020723, -71.16077925899094,  /* luv */
        39.51080966502063, 72.66078541601857, 281.66229655521045,  /* lch */
        281.66229655521045, 62.85597962258011, 39.51080966502063,  /* hsluv */
        281.66229655521045, 233.35842506481055, 39.51080966502063,  /* hpluv */
    },
    {
        "#7744bb",
        0.4666666666666667, 0.26666666666666666, 0.7333333333333333,  /* rgb */
        0.18643296572576035, 0.11644195606666094, 0.482806947517884,  /* xyz */
        40.6449442050895, 11.99641088275335, -83.6978873128468,  /* luv */
        40.6449442050895, 84.55323893678967, 278.1566465583881,  /* lch */
        278.1566465583881, 67.14804501686238, 40.6449442050895,  /* hsluv */
        278.1566465583881, 263.9751487920793, 40.6449442050895,  /* hpluv */
    },
    {
        "#7744cc",
        0.4666666666666667, 0.26666666666666666, 0.8,  /* rgb */
        0.2057253411694821, 0.12415890624414974, 0.5844134581881542,  /* xyz */
        41.86961795762002, 9.532487400630052, -95.74450734398287,  /* luv */
        41.86961795762002, 96.21787257357731, 275.68572884006755,  /* lch */
        275.68572884006755, 71.75639471729667, 41.86961795762002,  /* hsluv */
        275.68572884006755, 291.605746800226, 41.86961795762002,  /* hpluv */
    },
    {
        "#7744dd",
        0.4666666666666667, 0.26666666666666666, 0.8666666666666667,  /* rgb */
        0.22724366672011564, 0.13276623646440328, 0.6977433060881602,  /* xyz */
        43.177126183378704, 7.281653005464711, -107.32577471709446,  /* luv */
        43.177126183378704, 107.57250758960909, 273.88135651664186,  /* lch */
        273.88135651664186, 81.10403131161077, 43.177126183378704,  /* hsluv */
        273.88135651664186, 316.1454138451698, 43.177126183378704,  /* hpluv */
    },
    {
        "#7744ee",
        0.4666666666666667, 0.26666666666666666, 0.9333333333333333,  /* rgb */
        0.25105584698629035, 0.14229110857087332, 0.8231541221566834,  /* xyz */
        44.559727206130596, 5.223931273794982, -118.48538742831818,  /* luv */
        44.559727206130596, 118.60049111193425, 272.52449275199297,  /* lch */
        272.52449275199297, 90.47754633346209, 44.559727206130596,  /* hsluv */
        272.52449275199297, 337.74061548506677, 44.559727206130596,  /* hpluv */
    },
    {
        "#7744ff",
        0.4666666666666667, 0.26666666666666666, 1.0,  /* rgb */
        0.2772268953961218, 0.15275952793480602, 0.9609883104484652,  /* xyz */
        46.00986108459452, 3.337631272574989, -129.27337835038998,  /* luv */
        46.00986108459452, 129.31645731551242, 271.47895656312755,  /* lch */
        271.47895656312755, 99.99999999999928, 46.00986108459452,  /* hsluv */
        271.47895656312755, 356.64997909330884, 46.00986108459452,  /* hpluv */
    },
    {
        "#775500",
        0.4666666666666667, 0.3333333333333333, 0.0,  /* rgb */
        0.10855936370863775, 0.10419372600276527, 0.01439391043692042,  /* xyz */
        38.58481534909834, 27.799721324525628, 39.41684106824999,  /* luv */
        38.58481534909834, 48.23392857233343, 54.805631156433066,  /* lch */
        54.805631156433066, 100.0000000000023, 38.58481534909834,  /* hsluv */
        54.805631156433066, 158.6264248714426, 38.58481534909834,  /* hpluv */
    },
    {
        "#775511",
        0.4666666666666667, 0.3333333333333333, 0.06666666666666667,  /* rgb */
        0.10957102920827487, 0.10459839220262013, 0.01972201540167605,  /* xyz */
        38.65538932171166, 27.331529085291326, 36.89413234945985,  /* luv */
        38.65538932171166, 45.915024599357295, 53.468595529655396,  /* lch */
        53.468595529655396, 93.80091302681313, 38.65538932171166,  /* hsluv */
        53.468595529655396, 150.72458479524832, 38.65538932171166,  /* hpluv */
    },
    {
        "#775522",
        0.4666666666666667, 0.3333333333333333, 0.13333333333333333,  /* rgb */
        0.1114463873467519, 0.10534853545801094, 0.02959890159765525,  /* xyz */
        38.78573469439235, 26.4939762066725, 32.37067192681346,  /* luv */
        38.78573469439235, 41.83050533083622, 50.70117840268304,  /* lch */
        50.70117840268304, 82.73429824294001, 38.78573469439235,  /* hsluv */
        50.70117840268304, 136.8549200136553, 38.78573469439235,  /* hpluv */
    },
    {
        "#775533",
        0.4666666666666667, 0.3333333333333333, 0.2,  /* rgb */
        0.11453413807920963, 0.10658363575099405, 0.04586105545526639,  /* xyz */
        38.999005018824974, 25.194581865486786, 25.324382529866316,  /* luv */
        38.999005018824974, 35.72242021330181, 45.147212318596495,  /* lch */
        45.147212318596495, 65.62727283248707, 38.999005018824974,  /* hsluv */
        45.147212318596495, 116.23225790343565, 38.999005018824974,  /* hpluv */
    },
    {
        "#775544",
        0.4666666666666667, 0.3333333333333333, 0.26666666666666666,  /* rgb */
        0.1189921333234285, 0.10836683384868163, 0.06933983040815303,  /* xyz */
        39.30403059773057, 23.474239242895933, 15.936914160113526,  /* luv */
        39.30403059773057, 28.372964966311546, 34.173005803303234,  /* lch */
        34.173005803303234, 43.10497918560678, 39.30403059773057,  /* hsluv */
        34.173005803303234, 91.6024225041024, 39.30403059773057,  /* hpluv */
    },
    {
        "#775555",
        0.4666666666666667, 0.3333333333333333, 0.3333333333333333,  /* rgb */
        0.1249545473627905, 0.11075179946442647, 0.10074187768212695,  /* xyz */
        39.70680529056537, 21.418786424599862, 4.621926156339577,  /* luv */
        39.70680529056537, 21.91179164964105, 12.177050630062494,  /* lch */
        12.177050630062494, 16.408995950210446, 39.70680529056537,  /* hsluv */
        12.177050630062494, 70.02486335470806, 39.70680529056537,  /* hpluv */
    },
    {
        "#775566",
        0.4666666666666667, 0.3333333333333333, 0.4,  /* rgb */
        0.13253954313629868, 0.11378579777382979, 0.1406895220892709,  /* xyz */
        40.21091767922141, 19.136818279155182, -8.08694912894311,  /* luv */
        40.21091767922141, 20.775383511827684, 337.0917672345603,  /* lch */
        337.0917672345603, 22.801533528690904, 40.21091767922141,  /* hsluv */
        337.0917672345603, 65.56082221901565, 40.21091767922141,  /* hpluv */
    },
    {
        "#775577",
        0.4666666666666667, 0.3333333333333333, 0.4666666666666667,  /* rgb */
        0.14185355615650058, 0.1175114029819106, 0.18974332399566882,  /* xyz */
        40.81783218010824, 16.73808422176853, -21.64482648548474,  /* luv */
        40.81783218010824, 27.36168812412272, 307.71501294924656,  /* lch */
        307.71501294924656, 29.42863699240427, 40.81783218010824,  /* hsluv */
        307.71501294924656, 85.0613515767839, 40.81783218010824,  /* hpluv */
    },
    {
        "#775588",
        0.4666666666666667, 0.3333333333333333, 0.5333333333333333,  /* rgb */
        0.15299397325844444, 0.1219675698226882, 0.24841618739924098,  /* xyz */
        41.52713948741359, 14.317648223710199, -35.57540200761883,  /* luv */
        41.52713948741359, 38.34845862171779, 291.9227739840131,  /* lch */
        291.9227739840131, 36.00005768298534, 41.52713948741359,  /* hsluv */
        291.9227739840131, 117.18046645980577, 41.52713948741359,  /* hpluv */
    },
    {
        "#775599",
        0.4666666666666667, 0.3333333333333333, 0.6,  /* rgb */
        0.16605093736751714, 0.12719035546631735, 0.31718286504035886,  /* xyz */
        42.336815252734, 11.947876811039839, -49.511674498229844,  /* luv */
        42.336815252734, 50.93287417680693, 283.5669164890709,  /* lch */
        283.5669164890709, 42.29752557102757, 42.336815252734,  /* hsluv */
        283.5669164890709, 152.6579146150484, 42.336815252734,  /* hpluv */
    },
    {
        "#7755aa",
        0.4666666666666667, 0.3333333333333333, 0.6666666666666666,  /* rgb */
        0.1811086303327697, 0.13321343265241845, 0.39648671465735746,  /* xyz */
        43.243493780022206, 9.677226711211725, -63.20271253352467,  /* luv */
        43.243493780022206, 63.93928048090271, 278.7051841934008,  /* lch */
        278.7051841934008, 48.17805363140113, 43.243493780022206,  /* hsluv */
        278.7051841934008, 187.62309535423807, 43.243493780022206,  /* hpluv */
    },
    {
        "#7755bb",
        0.4666666666666667, 0.3333333333333333, 0.7333333333333333,  /* rgb */
        0.1982462224401063, 0.1400684694953532, 0.4867446997559992,  /* xyz */
        44.24274931072781, 7.533312711697035, -76.49904329836461,  /* luv */
        44.24274931072781, 76.86907327382892, 275.62412068132966,  /* lch */
        275.62412068132966, 58.11377579767445, 44.24274931072781,  /* hsluv */
        275.62412068132966, 220.46967655612156, 44.24274931072781,  /* hpluv */
    },
    {
        "#7755cc",
        0.4666666666666667, 0.3333333333333333, 0.8,  /* rgb */
        0.21753859788382807, 0.147785419672842, 0.5883512104262694,  /* xyz */
        45.329372189217395, 5.527768949320581, -89.32906241750565,  /* luv */
        45.329372189217395, 89.49993084884308, 273.5410031659269,  /* lch */
        273.5410031659269, 68.56000741273614, 45.329372189217395,  /* hsluv */
        273.5410031659269, 250.54302814762877, 45.329372189217395,  /* hpluv */
    },
    {
        "#7755dd",
        0.4666666666666667, 0.3333333333333333, 0.8666666666666667,  /* rgb */
        0.2390569234344616, 0.15639274989309554, 0.7016810583262754,  /* xyz */
        46.49762702347356, 3.6611919132950517, -101.67498882259574,  /* luv */
        46.49762702347356, 101.74088498878386, 272.06225987653295,  /* lch */
        272.06225987653295, 78.96234122339139, 46.49762702347356,  /* hsluv */
        272.06225987653295, 277.6540725780468, 46.49762702347356,  /* hpluv */
    },
    {
        "#7755ee",
        0.4666666666666667, 0.3333333333333333, 0.9333333333333333,  /* rgb */
        0.2628691037006363, 0.16591762199956558, 0.8270918743947986,  /* xyz */
        47.741482599804925, 1.9272982762340214, -113.55267200056082,  /* luv */
        47.741482599804925, 113.56902657464543, 270.9723721456759,  /* lch */
        270.9723721456759, 89.40672291751392, 47.741482599804925,  /* hsluv */
        270.9723721456759, 301.8584433421986, 47.741482599804925,  /* hpluv */
    },
    {
        "#7755ff",
        0.4666666666666667, 0.3333333333333333, 1.0,  /* rgb */
        0.28904015211046774, 0.17638604136349828, 0.9649260626865804,  /* xyz */
        49.054807140833475, 0.3160366194976461, -124.99653955208265,  /* luv */
        49.054807140833475, 124.99693907908396, 270.1448642174328,  /* lch */
        270.1448642174328, 99.99999999999922, 49.054807140833475,  /* hsluv */
        270.1448642174328, 323.3382861727456, 49.054807140833475,  /* hpluv */
    },
    {
        "#776600",
        0.4666666666666667, 0.4, 0.0,  /* rgb */
        0.12358742141448421, 0.13424984141445861, 0.019403263005535767,  /* xyz */
        43.39673640317106, 15.418631213636175, 46.25998365475207,  /* luv */
        43.39673640317106, 48.761873182231675, 71.56657090915348,  /* lch */
        71.56657090915348, 100.0000000000022, 43.39673640317106,  /* hsluv */
        71.56657090915348, 142.5813219533009, 43.39673640317106,  /* hpluv */
    },
    {
        "#776611",
        0.4666666666666667, 0.4, 0.06666666666666667,  /* rgb */
        0.12459908691412133, 0.13465450761431347, 0.0247313679702914,  /* xyz */
        43.45635594405657, 15.147779378144739, 44.01868802947542,  /* luv */
        43.45635594405657, 46.55212257164253, 71.01055553348658,  /* lch */
        71.01055553348658, 95.1446041192036, 43.45635594405657,  /* hsluv */
        71.01055553348658, 135.93318996857852, 43.45635594405657,  /* hpluv */
    },
    {
        "#776622",
        0.4666666666666667, 0.4, 0.13333333333333333,  /* rgb */
        0.12647444505259836, 0.1354046508697043, 0.03460825416627059,  /* xyz */
        43.56655950325111, 14.65926460063946, 39.97158929641287,  /* luv */
        43.56655950325111, 42.57489858487827, 69.85988685787426,  /* lch */
        69.85988685787426, 86.40598512939917, 43.56655950325111,  /* hsluv */
        69.85988685787426, 124.00513915757838, 43.56655950325111,  /* hpluv */
    },
    {
        "#776633",
        0.4666666666666667, 0.4, 0.2,  /* rgb */
        0.1295621957850561, 0.1366397511626874, 0.050870408023881736,  /* xyz */
        43.747124716439586, 13.891121817986605, 33.595258629740854,  /* luv */
        43.747124716439586, 36.3538810550032, 67.53565947196826,  /* lch */
        67.53565947196826, 72.7162107178341, 43.747124716439586,  /* hsluv */
        67.53565947196826, 105.44854562101487, 43.747124716439586,  /* hpluv */
    },
    {
        "#776644",
        0.4666666666666667, 0.4, 0.26666666666666666,  /* rgb */
        0.13402019102927498, 0.138422949260375, 0.07434918297676837,  /* xyz */
        44.00590940025314, 12.854587120101176, 24.964717595254744,  /* luv */
        44.00590940025314, 28.079842140565763, 62.75560042590078,  /* lch */
        62.75560042590078, 54.3487361937933, 44.00590940025314,  /* hsluv */
        62.75560042590078, 80.969785387169, 44.00590940025314,  /* hpluv */
    },
    {
        "#776655",
        0.4666666666666667, 0.4, 0.3333333333333333,  /* rgb */
        0.13998260506863697, 0.14080791487611982, 0.10575123025074229,  /* xyz */
        44.34857389523682, 11.586232336515781, 14.358766816543945,  /* luv */
        44.34857389523682, 18.45033778139597, 51.09959375417163,  /* lch */
        51.09959375417163, 32.05445309603823, 44.34857389523682,  /* hsluv */
        51.09959375417163, 52.79149841915235, 44.34857389523682,  /* hpluv */
    },
    {
        "#776666",
        0.4666666666666667, 0.4, 0.4,  /* rgb */
        0.14756760084214515, 0.1438419131855231, 0.14569887465788625,  /* xyz */
        44.778942503958454, 10.138905771020372, 2.187858492576547,  /* luv */
        44.778942503958454, 10.372277233913946, 12.177050630063178,  /* lch */
        12.177050630063178, 6.887622680304892, 44.778942503958454,  /* hsluv */
        12.177050630063178, 29.392708639247118, 44.778942503958454,  /* hpluv */
    },
    {
        "#776677",
        0.4666666666666667, 0.4, 0.4666666666666667,  /* rgb */
        0.15688161386234706, 0.14756751839360394, 0.19475267656428416,  /* xyz */
        45.29921512748669, 8.571805550292328, -11.084616455810522,  /* luv */
        45.29921512748669, 14.012300751998145, 307.71501294925173,  /* lch */
        307.71501294925173, 13.579881122914353, 45.29921512748669,  /* hsluv */
        307.71501294925173, 39.25166642496101, 45.29921512748669,  /* hpluv */
    },
    {
        "#776688",
        0.4666666666666667, 0.4, 0.5333333333333333,  /* rgb */
        0.16802203096429089, 0.15202368523438153, 0.25342553996785633,  /* xyz */
        45.91013360937259, 6.941794916045297, -25.011160612546195,  /* luv */
        45.91013360937259, 25.956630594956167, 285.511882327844,  /* lch */
        285.511882327844, 20.42101798769198, 45.91013360937259,  /* hsluv */
        285.511882327844, 71.74292618216333, 45.91013360937259,  /* hpluv */
    },
    {
        "#776699",
        0.4666666666666667, 0.4, 0.6,  /* rgb */
        0.1810789950733636, 0.1572464708780107, 0.3221922176089742,  /* xyz */
        46.61114196770418, 5.297457534696983, -39.207366384207845,  /* luv */
        46.61114196770418, 39.563627678935475, 277.69485305733224,  /* lch */
        277.69485305733224, 30.31158530056612, 46.61114196770418,  /* hsluv */
        277.69485305733224, 107.70743648434713, 46.61114196770418,  /* hpluv */
    },
    {
        "#7766aa",
        0.4666666666666667, 0.4, 0.6666666666666666,  /* rgb */
        0.19613668803861614, 0.16326954806411179, 0.4014960672259728,  /* xyz */
        47.400553994027995, 3.6762544384108335, -53.374645839892196,  /* luv */
        47.400553994027995, 53.501099663743894, 273.94010537559177,  /* lch */
        273.94010537559177, 41.74764921034622, 47.400553994027995,  /* hsluv */
        273.94010537559177, 143.22492965422455, 47.400553994027995,  /* hpluv */
    },
    {
        "#7766bb",
        0.4666666666666667, 0.4, 0.7333333333333333,  /* rgb */
        0.2132742801459528, 0.17012458490704654, 0.49175405232461455,  /* xyz */
        48.275729652239505, 2.10423911354751, -67.3027859511178,  /* luv */
        48.275729652239505, 67.33567270792624, 271.7907840986749,  /* lch */
        271.7907840986749, 53.26174830093764, 48.275729652239505,  /* hsluv */
        271.7907840986749, 176.99283399979987, 48.275729652239505,  /* hpluv */
    },
    {
        "#7766cc",
        0.4666666666666667, 0.4, 0.8,  /* rgb */
        0.23256665558967454, 0.17784153508453535, 0.5933605629948847,  /* xyz */
        49.233255892350684, 0.5973980611848849, -80.85968264683939,  /* luv */
        49.233255892350684, 80.86188943000953, 270.4232982831947,  /* lch */
        270.4232982831947, 64.81229498626745, 49.233255892350684,  /* hsluv */
        270.4232982831947, 208.41292746748522, 49.233255892350684,  /* hpluv */
    },
    {
        "#7766dd",
        0.4666666666666667, 0.4, 0.8666666666666667,  /* rgb */
        0.2540849811403081, 0.18644886530478888, 0.7066904108948907,  /* xyz */
        50.26912517229367, -0.8362736015664722, -93.97526965648068,  /* luv */
        50.26912517229367, 93.97899052737763, 269.49014582953134,  /* lch */
        269.49014582953134, 76.41136590307194, 50.26912517229367,  /* hsluv */
        269.49014582953134, 237.22954448800832, 50.26912517229367,  /* hpluv */
    },
    {
        "#7766ee",
        0.4666666666666667, 0.4, 0.9333333333333333,  /* rgb */
        0.2778971614064828, 0.19597373741125892, 0.8321012269634139,  /* xyz */
        51.37890481111759, -2.194598616337708, -106.62465856296154,  /* luv */
        51.37890481111759, 106.64724129931801, 268.8208779433126,  /* lch */
        268.8208779433126, 88.11245890326042, 51.37890481111759,  /* hsluv */
        268.8208779433126, 263.39292772202356, 51.37890481111759,  /* hpluv */
    },
    {
        "#7766ff",
        0.4666666666666667, 0.4, 1.0,  /* rgb */
        0.3040682098163142, 0.20644215677519162, 0.9699354152551958,  /* xyz */
        52.557891404764675, -3.4793023078491885, -118.81329109850806,  /* luv */
        52.557891404764675, 118.86422374376664, 268.32264234060756,  /* lch */
        268.32264234060756, 99.99999999999906, 52.557891404764675,  /* hsluv */
        268.32264234060756, 286.9806082813307, 52.557891404764675,  /* hpluv */
    },
    {
        "#777700",
        0.4666666666666667, 0.4666666666666667, 0.0,  /* rgb */
        0.14204115946790186, 0.17115731752129437, 0.02555450902334147,  /* xyz */
        48.40552820630889, 3.8391221902002184, 53.22400369997387,  /* luv */
        48.40552820630889, 53.362284706017974, 85.8743202181747,  /* lch */
        85.8743202181747, 100.00000000000233, 48.40552820630889,  /* hsluv */
        85.8743202181747, 139.88745807479762, 48.40552820630889,  /* hpluv */
    },
    {
        "#777711",
        0.4666666666666667, 0.4666666666666667, 0.06666666666666667,  /* rgb */
        0.143052824967539, 0.17156198372114922, 0.0308826139880971,  /* xyz */
        48.45624612218148, 3.695770802333592, 51.23663929211785,  /* luv */
        48.45624612218148, 51.36975693707316, 85.87432021817462,  /* lch */
        85.87432021817462, 96.16527816699323, 48.45624612218148,  /* hsluv */
        85.87432021817462, 134.52316317836198, 48.45624612218148,  /* hpluv */
    },
    {
        "#777722",
        0.4666666666666667, 0.4666666666666667, 0.13333333333333333,  /* rgb */
        0.144928183106016, 0.17231212697654005, 0.0407595001840763,  /* xyz */
        48.55005306943386, 3.4355223894912097, 47.62866283244683,  /* luv */
        48.55005306943386, 47.75240661260538, 85.87432021817443,  /* lch */
        85.87432021817443, 89.22079791606943, 48.55005306943386,  /* hsluv */
        85.87432021817443, 124.80870627883856, 48.55005306943386,  /* hpluv */
    },
    {
        "#777733",
        0.4666666666666667, 0.4666666666666667, 0.2,  /* rgb */
        0.14801593383847372, 0.17354722726952315, 0.05702165404168744,  /* xyz */
        48.703913507456306, 3.0218419065889273, 41.89356755238099,  /* luv */
        48.703913507456306, 42.00241101144465, 85.874320218174,  /* lch */
        85.874320218174, 78.22956382389637, 48.703913507456306,  /* hsluv */
        85.874320218174, 109.43334829624743, 48.703913507456306,  /* hpluv */
    },
    {
        "#777744",
        0.4666666666666667, 0.4666666666666667, 0.26666666666666666,  /* rgb */
        0.1524739290826926, 0.17533042536721075, 0.08050042899457407,  /* xyz */
        48.92476973879853, 2.4548204251045496, 34.0326160292585,  /* luv */
        48.92476973879853, 34.12103599122472, 85.87432021817325,  /* lch */
        85.87432021817325, 63.26360942747664, 48.92476973879853,  /* hsluv */
        85.87432021817325, 88.49785511446291, 48.92476973879853,  /* hpluv */
    },
    {
        "#777755",
        0.4666666666666667, 0.4666666666666667, 0.3333333333333333,  /* rgb */
        0.15843634312205462, 0.17771539098295558, 0.11190247626854799,  /* xyz */
        49.217828793542154, 1.7469218410275804, 24.218602566931725,  /* luv */
        49.217828793542154, 24.281524791776384, 85.87432021817163,  /* lch */
        85.87432021817163, 44.75216518788253, 49.217828793542154,  /* hsluv */
        85.87432021817163, 62.6026663147617, 49.217828793542154,  /* hpluv */
    },
    {
        "#777766",
        0.4666666666666667, 0.4666666666666667, 0.4,  /* rgb */
        0.16602133889556278, 0.18074938929235887, 0.15185012067569195,  /* xyz */
        49.58687450788297, 0.9197130180714892, 12.750521252385596,  /* luv */
        49.58687450788297, 12.783648315060413, 85.87432021816647,  /* lch */
        85.87432021816647, 23.385605928338574, 49.58687450788297,  /* hsluv */
        85.87432021816647, 32.71352968854101, 49.58687450788297,  /* hpluv */
    },
    {
        "#777777",
        0.4666666666666667, 0.4666666666666667, 0.4666666666666667,  /* rgb */
        0.17533535191576471, 0.1844749945004397, 0.20090392258208986,  /* xyz */
        50.03443879253807, 2.5274970617111615e-12, 8.665704211581125e-13,  /* luv */
        50.03443879253807, 2.6719254652375136e-12, 0.0,  /* lch */
        0.0, 1.9402040248474474e-12, 50.03443879253807,  /* hsluv */
        0.0, 6.776331329181805e-12, 50.03443879253807,  /* hpluv */
    },
    {
        "#777788",
        0.4666666666666667, 0.4666666666666667, 0.5333333333333333,  /* rgb */
        0.18647576901770851, 0.1889311613412173, 0.25957678598566203,  /* xyz */
        50.561922009952355, -0.9840009948563624, -13.641783198477793,  /* luv */
        50.561922009952355, 13.677225844159674, 265.87432021818756,  /* lch */
        265.87432021818756, 11.179763921173834, 50.561922009952355,  /* hsluv */
        265.87432021818756, 34.3252548472133, 50.561922009952355,  /* hpluv */
    },
    {
        "#777799",
        0.4666666666666667, 0.4666666666666667, 0.6,  /* rgb */
        0.19953273312678124, 0.19415394698484645, 0.3283434636267799,  /* xyz */
        51.16969822905607, -2.0058037388874626, -27.80763422760451,  /* luv */
        51.16969822905607, 27.879881096862245, 265.8743202181824,  /* lch */
        265.8743202181824, 22.984601178240354, 51.16969822905607,  /* hsluv */
        265.8743202181824, 69.13809165496426, 51.16969822905607,  /* hpluv */
    },
    {
        "#7777aa",
        0.4666666666666667, 0.4666666666666667, 0.6666666666666666,  /* rgb */
        0.21459042609203377, 0.20017702417094754, 0.40764731324377856,  /* xyz */
        51.8572203345112, -3.042729523632854, -42.183144844275844,  /* luv */
        51.8572203345112, 42.29274065258886, 265.8743202181806,  /* lch */
        265.8743202181806, 35.22071488198144, 51.8572203345112,  /* hsluv */
        265.8743202181806, 103.48941257795178, 51.8572203345112,  /* hpluv */
    },
    {
        "#7777bb",
        0.4666666666666667, 0.4666666666666667, 0.7333333333333333,  /* rgb */
        0.23172801819937044, 0.2070320610138823, 0.49790529834242025,  /* xyz */
        52.623130228576244, -4.07688697591046, -56.52027644350388,  /* luv */
        52.623130228576244, 56.6671214785474, 265.87432021817983,  /* lch */
        265.87432021817983, 47.751077300634, 52.623130228576244,  /* hsluv */
        265.87432021817983, 136.64501756549117, 52.623130228576244,  /* hpluv */
    },
    {
        "#7777cc",
        0.4666666666666667, 0.4666666666666667, 0.8,  /* rgb */
        0.25102039364309214, 0.2147490111913711, 0.5995118090126904,  /* xyz */
        53.46537429983097, -5.0952619472788445, -70.6386062488075,  /* luv */
        53.46537429983097, 70.82213204278345, 265.8743202181794,  /* lch */
        265.8743202181794, 60.49689820984037, 53.46537429983097,  /* hsluv */
        265.8743202181794, 168.0876136958379, 53.46537429983097,  /* hpluv */
    },
    {
        "#7777dd",
        0.4666666666666667, 0.4666666666666667, 0.8666666666666667,  /* rgb */
        0.27253871919372574, 0.22335634141162464, 0.7128416569126964,  /* xyz */
        54.38132170924041, -6.089224982492846, -84.41849905840421,  /* luv */
        54.38132170924041, 84.63782631992156, 265.87432021817904,  /* lch */
        265.87432021817904, 73.43309701283854, 54.38132170924041,  /* hsluv */
        265.87432021817904, 197.49407415063706, 54.38132170924041,  /* hpluv */
    },
    {
        "#7777ee",
        0.4666666666666667, 0.4666666666666667, 0.9333333333333333,  /* rgb */
        0.29635089945990045, 0.23288121351809468, 0.8382524729812196,  /* xyz */
        55.3678819060931, -7.053749394083381, -97.79026695427457,  /* luv */
        55.3678819060931, 98.04433533612647, 265.8743202181788,  /* lch */
        265.8743202181788, 86.5809092876847, 55.3678819060931,  /* hsluv */
        265.8743202181788, 224.70044022714424, 55.3678819060931,  /* hpluv */
    },
    {
        "#7777ff",
        0.4666666666666667, 0.4666666666666667, 1.0,  /* rgb */
        0.3225219478697319, 0.24334963288202738, 0.9760866612730015,  /* xyz */
        56.421617615377116, -7.98655981550332, -110.72236519480329,  /* luv */
        56.421617615377116, 111.01003239355441, 265.8743202181787,  /* lch */
        265.8743202181787, 99.99999999999892, 56.421617615377116,  /* hsluv */
        265.8743202181787, 249.6640565250235, 56.421617615377116,  /* hpluv */
    },
    {
        "#778800",
        0.4666666666666667, 0.5333333333333333, 0.0,  /* rgb */
        0.1641135291928723, 0.21530205697123592, 0.032911965598331414,  /* xyz */
        53.52495486156873, -6.862547716192022, 60.20397459104976,  /* luv */
        53.52495486156873, 60.593837291566025, 96.50297936559473,  /* lch */
        96.50297936559473, 100.00000000000237, 53.52495486156873,  /* hsluv */
        96.50297936559473, 143.6519326392509, 53.52495486156873,  /* hpluv */
    },
    {
        "#778811",
        0.4666666666666667, 0.5333333333333333, 0.06666666666666667,  /* rgb */
        0.16512519469250944, 0.21570672317109077, 0.03824007056308704,  /* xyz */
        53.56848562883103, -6.925376630346989, 58.439190619624014,  /* luv */
        53.56848562883103, 58.84810822574424, 96.75835630962611,  /* lch */
        96.75835630962611, 96.9357421545617, 53.56848562883103,  /* hsluv */
        96.75835630962611, 139.399900460742, 53.56848562883103,  /* hpluv */
    },
    {
        "#778822",
        0.4666666666666667, 0.5333333333333333, 0.13333333333333333,  /* rgb */
        0.16700055283098644, 0.2164568664264816, 0.04811695675906624,  /* xyz */
        53.64903628205414, -7.04010577997538, 55.222098613307715,  /* luv */
        53.64903628205414, 55.66905122822846, 97.2652817371477,  /* lch */
        97.2652817371477, 91.36050665170033, 53.64903628205414,  /* hsluv */
        97.2652817371477, 131.67132964917664, 53.64903628205414,  /* hpluv */
    },
    {
        "#778833",
        0.4666666666666667, 0.5333333333333333, 0.2,  /* rgb */
        0.17008830356344418, 0.2176919667194647, 0.06437911061667739,  /* xyz */
        53.7812573057213, -7.2242644145066635, 50.07331954489454,  /* luv */
        53.7812573057213, 50.591771332656705, 98.20962751650399,  /* lch */
        98.20962751650399, 82.46722627161375, 53.7812573057213,  /* hsluv */
        98.20962751650399, 119.36809440216014, 53.7812573057213,  /* hpluv */
    },
    {
        "#778844",
        0.4666666666666667, 0.5333333333333333, 0.26666666666666666,  /* rgb */
        0.17454629880766306, 0.2194751648171523, 0.08785788556956403,  /* xyz */
        53.971274394724716, -7.480324917122594, 42.946295424163836,  /* luv */
        53.971274394724716, 43.59288418452352, 99.88057396192218,  /* lch */
        99.88057396192218, 70.21958077921457, 53.971274394724716,  /* hsluv */
        99.88057396192218, 102.49254027672212, 53.971274394724716,  /* hpluv */
    },
    {
        "#778855",
        0.4666666666666667, 0.5333333333333333, 0.3333333333333333,  /* rgb */
        0.18050871284702508, 0.22186013043289712, 0.11925993284353793,  /* xyz */
        54.2238135722873, -7.806066785793863, 33.93589030046662,  /* luv */
        54.2238135722873, 34.82210977453231, 102.95406659719825,  /* lch */
        102.95406659719825, 54.845413487870964, 54.2238135722873,  /* hsluv */
        102.95406659719825, 81.49000574956926, 54.2238135722873,  /* hpluv */
    },
    {
        "#778866",
        0.4666666666666667, 0.5333333333333333, 0.4,  /* rgb */
        0.18809370862053323, 0.22489412874230041, 0.1592075772506819,  /* xyz */
        54.54247534978826, -8.195525690017442, 23.249743881255444,  /* luv */
        54.54247534978826, 24.651921464253267, 109.41753435199068,  /* lch */
        109.41753435199068, 36.783040833421516, 54.54247534978826,  /* hsluv */
        109.41753435199068, 57.35288355368742, 54.54247534978826,  /* hpluv */
    },
    {
        "#778877",
        0.4666666666666667, 0.5333333333333333, 0.4666666666666667,  /* rgb */
        0.19740772164073517, 0.22861973395038124, 0.20826137915707982,  /* xyz */
        54.92988040200467, -8.640131486956083, 11.172972030085878,  /* luv */
        54.92988040200467, 14.123992923283815, 127.71501294923117,  /* lch */
        127.71501294923117, 16.61337990528797, 54.92988040200467,  /* hsluv */
        127.71501294923117, 32.627828010752104, 54.92988040200467,  /* hpluv */
    },
    {
        "#778888",
        0.4666666666666667, 0.5333333333333333, 0.5333333333333333,  /* rgb */
        0.20854813874267897, 0.23307590079115884, 0.26693424256065196,  /* xyz */
        55.38776407122086, -9.129932582208054, -1.970133758785146,  /* luv */
        55.38776407122086, 9.340080084408758, 192.17705063005937,  /* lch */
        192.17705063005937, 21.314384753629547, 55.38776407122086,  /* hsluv */
        192.17705063005937, 21.3981433643613, 55.38776407122086,  /* hpluv */
    },
    {
        "#778899",
        0.4666666666666667, 0.5333333333333333, 0.6,  /* rgb */
        0.2216051028517517, 0.238298686434788, 0.3357009202017699,  /* xyz */
        55.91705123743867, -9.654729765013256, -15.851640655596027,  /* luv */
        55.91705123743867, 18.560396501949462, 238.6557361697948,  /* lch */
        238.6557361697948, 26.191272981807305, 55.91705123743867,  /* hsluv */
        238.6557361697948, 42.11941351012427, 55.91705123743867,  /* hpluv */
    },
    {
        "#7788aa",
        0.4666666666666667, 0.5333333333333333, 0.6666666666666666,  /* rgb */
        0.23666279581700422, 0.2443217636208891, 0.4150047698187685,  /* xyz */
        56.51792587568637, -10.20497299277179, -30.168026009587653,  /* luv */
        56.51792587568637, 31.847311771927608, 251.31080478432239,  /* lch */
        251.31080478432239, 31.114940539286724, 56.51792587568637,  /* hsluv */
        251.31080478432239, 71.50326785909837, 56.51792587568637,  /* hpluv */
    },
    {
        "#7788bb",
        0.4666666666666667, 0.5333333333333333, 0.7333333333333333,  /* rgb */
        0.2538003879243409, 0.25117680046382385, 0.5052627549174102,  /* xyz */
        57.189901705533885, -10.772349907810204, -44.65845653197684,  /* luv */
        57.189901705533885, 45.93932152693119, 256.43838879429467,  /* lch */
        256.43838879429467, 41.43576472351806, 57.189901705533885,  /* hsluv */
        256.43838879429467, 101.9305935767153, 57.189901705533885,  /* hpluv */
    },
    {
        "#7788cc",
        0.4666666666666667, 0.5333333333333333, 0.8,  /* rgb */
        0.27309276336806265, 0.25889375064131265, 0.6068692655876804,  /* xyz */
        57.931896180422655, -11.350071384924949, -59.11345135957642,  /* luv */
        57.931896180422655, 60.19322430376944, 259.1312047635866,  /* lch */
        259.1312047635866, 55.502625572276166, 57.931896180422655,  /* hsluv */
        259.1312047635866, 131.8466774878151, 57.931896180422655,  /* hpluv */
    },
    {
        "#7788dd",
        0.4666666666666667, 0.5333333333333333, 0.8666666666666667,  /* rgb */
        0.29461108891869614, 0.2675010808615662, 0.7201991134876864,  /* xyz */
        58.74230773519267, -11.932911564615297, -73.37574973270603,  /* luv */
        58.74230773519267, 74.33972711306949, 260.7629990438978,  /* lch */
        260.7629990438978, 69.94891432410806, 58.74230773519267,  /* hsluv */
        260.7629990438978, 160.5865932741968, 58.74230773519267,  /* hpluv */
    },
    {
        "#7788ee",
        0.4666666666666667, 0.5333333333333333, 0.9333333333333333,  /* rgb */
        0.3184232691848709, 0.2770259529680362, 0.8456099295562096,  /* xyz */
        59.61909492910641, -12.517081206792477, -87.33588803183183,  /* luv */
        59.61909492910641, 88.22830985713205, 261.8438445678181,  /* lch */
        261.8438445678181, 84.76894844157432, 59.61909492910641,  /* hsluv */
        261.8438445678181, 187.78543629066345, 59.61909492910641,  /* hpluv */
    },
    {
        "#7788ff",
        0.4666666666666667, 0.5333333333333333, 1.0,  /* rgb */
        0.34459431759470227, 0.28749437233196895, 0.9834441178479915,  /* xyz */
        60.55985551741054, -13.100010263005288, -100.9249010083543,  /* luv */
        60.55985551741054, 101.77153783075579, 262.604380260147,  /* lch */
        262.604380260147, 99.99999999999879, 60.55985551741054,  /* hsluv */
        262.604380260147, 213.24597035285694, 60.55985551741054,  /* hpluv */
    },
    {
        "#779900",
        0.4666666666666667, 0.6, 0.0,  /* rgb */
        0.18998312964533978, 0.2670412578761716, 0.04153516574915367,  /* xyz */
        58.69945688975042, -16.733216597780032, 67.14396683841359,  /* luv */
        58.69945688975042, 69.19763594593536, 103.9938502769753,  /* lch */
        103.9938502769753, 100.00000000000244, 58.69945688975042,  /* hsluv */
        103.9938502769753, 149.58791230535172, 58.69945688975042,  /* hpluv */
    },
    {
        "#779911",
        0.4666666666666667, 0.6, 0.06666666666666667,  /* rgb */
        0.19099479514497691, 0.26744592407602646, 0.0468632707139093,  /* xyz */
        58.73717027455885, -16.745846005892883, 65.5714600214076,  /* luv */
        58.73717027455885, 67.67599077806052, 104.32616249833204,  /* lch */
        104.32616249833204, 97.5197891999702, 58.73717027455885,  /* hsluv */
        104.32616249833204, 146.20456366036808, 58.73717027455885,  /* hpluv */
    },
    {
        "#779922",
        0.4666666666666667, 0.6, 0.13333333333333333,  /* rgb */
        0.19287015328345392, 0.26819606733141726, 0.0567401569098885,  /* xyz */
        58.80698033610062, -16.769182958882766, 62.695857892075146,  /* luv */
        58.80698033610062, 64.8997387816913, 104.97431376012679,  /* lch */
        104.97431376012679, 92.99113960418947, 58.80698033610062,  /* hsluv */
        104.97431376012679, 140.04041716275114, 58.80698033610062,  /* hpluv */
    },
    {
        "#779933",
        0.4666666666666667, 0.6, 0.2,  /* rgb */
        0.19595790401591168, 0.2694311676244004, 0.07300231076749963,  /* xyz */
        58.92163855913881, -16.807400084980358, 58.06938555981414,  /* luv */
        58.92163855913881, 60.45281000012281, 106.14237332279157,  /* lch */
        106.14237332279157, 85.72411566104495, 58.92163855913881,  /* hsluv */
        106.14237332279157, 130.19101222108515, 58.92163855913881,  /* hpluv */
    },
    {
        "#779944",
        0.4666666666666667, 0.6, 0.26666666666666666,  /* rgb */
        0.20041589926013054, 0.27121436572208796, 0.09648108572038627,  /* xyz */
        59.086561898254075, -16.86213696833662, 51.616197453475635,  /* luv */
        59.086561898254075, 54.300676816179084, 108.09133770496877,  /* lch */
        108.09133770496877, 75.62823320913094, 59.086561898254075,  /* hsluv */
        108.09133770496877, 116.61538464505963, 59.086561898254075,  /* hpluv */
    },
    {
        "#779955",
        0.4666666666666667, 0.6, 0.3333333333333333,  /* rgb */
        0.20637831329949252, 0.2735993313378328, 0.1278831329943602,  /* xyz */
        59.306014996503706, -16.93456852217479, 43.37625322031804,  /* luv */
        59.306014996503706, 46.564782341007295, 111.32622289935762,  /* lch */
        111.32622289935762, 62.80878263192838, 59.306014996503706,  /* hsluv */
        111.32622289935762, 99.63184224220004, 59.306014996503706,  /* hpluv */
    },
    {
        "#779966",
        0.4666666666666667, 0.6, 0.4,  /* rgb */
        0.2139633090730007, 0.27663332964723614, 0.16783077740150415,  /* xyz */
        59.58335356364333, -17.025496386721294, 33.486659182329696,  /* luv */
        59.58335356364333, 37.566259734072084, 116.94997859110872,  /* lch */
        116.94997859110872, 47.5357009492008, 59.58335356364333,  /* hsluv */
        116.94997859110872, 80.00411772093045, 59.58335356364333,  /* hpluv */
    },
    {
        "#779977",
        0.4666666666666667, 0.6, 0.4666666666666667,  /* rgb */
        0.2232773220932026, 0.28035893485531693, 0.21688457930790206,  /* xyz */
        59.921152065724, -17.135412286291018, 22.15863062821676,  /* luv */
        59.921152065724, 28.011198930765513, 127.71501294923614,  /* lch */
        127.71501294923614, 30.203738509136713, 59.921152065724,  /* hsluv */
        127.71501294923614, 59.31859687650023, 59.921152065724,  /* hpluv */
    },
    {
        "#779988",
        0.4666666666666667, 0.6, 0.5333333333333333,  /* rgb */
        0.23441773919514647, 0.28481510169609453, 0.2755574427114742,  /* xyz */
        60.32128261079066, -17.26455158751733, 9.650860594736763,  /* luv */
        60.32128261079066, 19.778873874341027, 150.7948696641617,  /* lch */
        150.7948696641617, 33.52781565650347, 60.32128261079066,  /* hsluv */
        150.7948696641617, 41.607375298145804, 60.32128261079066,  /* hpluv */
    },
    {
        "#779999",
        0.4666666666666667, 0.6, 0.6,  /* rgb */
        0.24747470330421917, 0.2900378873397237, 0.34432412035259213,  /* xyz */
        60.784972589042454, -17.41294123780113, -3.7575111386025166,  /* luv */
        60.784972589042454, 17.813742237605137, 192.1770506300603,  /* lch */
        192.1770506300603, 37.042046568548656, 60.784972589042454,  /* hsluv */
        192.1770506300603, 37.18760978302124, 60.784972589042454,  /* hpluv */
    },
    {
        "#7799aa",
        0.4666666666666667, 0.6, 0.6666666666666666,  /* rgb */
        0.2625323962694717, 0.2960609645258248, 0.42362796996959073,  /* xyz */
        61.31285404648979, -17.580441829549947, -17.790913195924308,  /* luv */
        61.31285404648979, 25.01176777573115, 225.34092498498575,  /* lch */
        225.34092498498575, 40.65993043842588, 61.31285404648979,  /* hsluv */
        225.34092498498575, 51.764518868212974, 61.31285404648979,  /* hpluv */
    },
    {
        "#7799bb",
        0.4666666666666667, 0.6, 0.7333333333333333,  /* rgb */
        0.27966998837680834, 0.30291600136875957, 0.5138859550682324,  /* xyz */
        61.90501119753321, -17.766782778670386, -32.1958942436537,  /* luv */
        61.90501119753321, 36.77273686378255, 241.10860139234288,  /* lch */
        241.10860139234288, 44.30268290480429, 61.90501119753321,  /* hsluv */
        241.10860139234288, 75.37710856774234, 61.90501119753321,  /* hpluv */
    },
    {
        "#7799cc",
        0.4666666666666667, 0.6, 0.8,  /* rgb */
        0.2989623638205301, 0.31063295154624837, 0.6154924657385026,  /* xyz */
        62.56102907100973, -17.971590279241223, -46.7531827927901,  /* luv */
        62.56102907100973, 50.08830360893611, 248.97359584438047,  /* lch */
        248.97359584438047, 49.58527588140301, 62.56102907100973,  /* hsluv */
        248.97359584438047, 101.59486695225264, 62.56102907100973,  /* hpluv */
    },
    {
        "#7799dd",
        0.4666666666666667, 0.6, 0.8666666666666667,  /* rgb */
        0.32048068937116364, 0.3192402817665019, 0.7288223136385086,  /* xyz */
        63.28004434120305, -18.19440865191951, -61.28352728292342,  /* luv */
        63.28004434120305, 63.927358950842496, 253.46442195017698,  /* lch */
        253.46442195017698, 65.78954719859274, 63.28004434120305,  /* hsluv */
        253.46442195017698, 128.1915250991136, 63.28004434120305,  /* hpluv */
    },
    {
        "#7799ee",
        0.4666666666666667, 0.6, 0.9333333333333333,  /* rgb */
        0.3442928696373384, 0.3287651538729719, 0.8542331297070318,  /* xyz */
        64.06079824232631, -18.434716379612933, -75.64845391484971,  /* luv */
        64.06079824232631, 77.86223312815983, 256.30456756412207,  /* lch */
        256.30456756412207, 82.58714595579781, 64.06079824232631,  /* hsluv */
        256.30456756412207, 154.23176758793156, 64.06079824232631,  /* hpluv */
    },
    {
        "#7799ff",
        0.4666666666666667, 0.6, 1.0,  /* rgb */
        0.37046391804716977, 0.3392335732369046, 0.9920673179988138,  /* xyz */
        64.9016907971027, -18.691938358633433, -89.74744603655719,  /* luv */
        64.9016907971027, 91.67329289213788, 258.23504341307023,  /* lch */
        258.23504341307023, 99.99999999999844, 64.9016907971027,  /* hsluv */
        258.23504341307023, 179.23637295501612, 64.9016907971027,  /* hpluv */
    },
    {
        "#77aa00",
        0.4666666666666667, 0.6666666666666666, 0.0,  /* rgb */
        0.21981674927490907, 0.326708497135311, 0.05147970562567648,  /* xyz */
        63.89350341598825, -25.86589384517836, 74.01588190672224,  /* luv */
        63.89350341598825, 78.40532659736766, 109.26268789966532,  /* lch */
        109.26268789966532, 100.00000000000213, 63.89350341598825,  /* hsluv */
        109.26268789966532, 155.71419060341216, 63.89350341598825,  /* hpluv */
    },
    {
        "#77aa11",
        0.4666666666666667, 0.6666666666666666, 0.06666666666666667,  /* rgb */
        0.2208284147745462, 0.3271131633351659, 0.05680781059043211,  /* xyz */
        63.926475582973566, -25.847585796554142, 72.60849528432475,  /* luv */
        63.926475582973566, 77.0719876411919, 109.59500216746763,  /* lch */
        109.59500216746763, 97.96671633478246, 63.926475582973566,  /* hsluv */
        109.59500216746763, 152.98720995680398, 63.926475582973566,  /* hpluv */
    },
    {
        "#77aa22",
        0.4666666666666667, 0.6666666666666666, 0.13333333333333333,  /* rgb */
        0.2227037729130232, 0.3278633065905567, 0.06668469678641131,  /* xyz */
        63.98752533634264, -25.81425613903275, 70.0286118796271,  /* luv */
        63.98752533634264, 74.63499381522746, 110.23511806408922,  /* lch */
        110.23511806408922, 94.24400538090134, 63.98752533634264,  /* hsluv */
        110.23511806408922, 148.00845088866345, 63.98752533634264,  /* hpluv */
    },
    {
        "#77aa33",
        0.4666666666666667, 0.6666666666666666, 0.2,  /* rgb */
        0.22579152364548094, 0.3290984068835398, 0.08294685064402246,  /* xyz */
        64.08784033392173, -25.761057391756076, 65.86100933400907,  /* luv */
        64.08784033392173, 70.7199026331045, 111.36259322980516,  /* lch */
        111.36259322980516, 88.2427941375042, 64.08784033392173,  /* hsluv */
        111.36259322980516, 140.02492342614542, 64.08784033392173,  /* hpluv */
    },
    {
        "#77aa44",
        0.4666666666666667, 0.6666666666666666, 0.26666666666666666,  /* rgb */
        0.23024951888969983, 0.3308816049812274, 0.1064256255969091,  /* xyz */
        64.23223009211746, -25.687786757992768, 60.013086957668946,  /* luv */
        64.23223009211746, 65.2796522257345, 113.17268826837423,  /* lch */
        113.17268826837423, 79.84883720152955, 64.23223009211746,  /* hsluv */
        113.17268826837423, 128.96271213922998, 64.23223009211746,  /* hpluv */
    },
    {
        "#77aa55",
        0.4666666666666667, 0.6666666666666666, 0.3333333333333333,  /* rgb */
        0.23621193292906184, 0.33326657059697223, 0.137827672870883,  /* xyz */
        64.42453774540483, -25.59595469476077, 52.48722571495249,  /* luv */
        64.42453774540483, 58.39573409067323, 115.99667028387228,  /* lch */
        115.99667028387228, 69.09440534710271, 64.42453774540483,  /* hsluv */
        115.99667028387228, 115.01888089677199, 64.42453774540483,  /* hpluv */
    },
    {
        "#77aa66",
        0.4666666666666667, 0.6666666666666666, 0.4,  /* rgb */
        0.24379692870257, 0.33630056890637555, 0.17777531727802698,  /* xyz */
        64.6678576456364, -25.48858774356486, 43.36801386261755,  /* luv */
        64.6678576456364, 50.303605552182766, 120.44393809328889,  /* lch */
        120.44393809328889, 56.13919962190077, 64.6678576456364,  /* hsluv */
        120.44393809328889, 98.70745794370973, 64.6678576456364,  /* hpluv */
    },
    {
        "#77aa77",
        0.4666666666666667, 0.6666666666666666, 0.4666666666666667,  /* rgb */
        0.25311094172277193, 0.34002617411445635, 0.2268291191844249,  /* xyz */
        64.964649263009, -25.36993998497199, 32.80709677681571,  /* luv */
        64.964649263009, 41.472152750543735, 127.71501294923786,  /* lch */
        127.71501294923786, 41.24664605129239, 64.964649263009,  /* hsluv */
        127.71501294923786, 81.00630221269611, 64.964649263009,  /* hpluv */
    },
    {
        "#77aa88",
        0.4666666666666667, 0.6666666666666666, 0.5333333333333333,  /* rgb */
        0.26425135882471573, 0.34448234095523395, 0.285501982587997,  /* xyz */
        65.31680573912634, -25.245120361384615, 21.004970679758074,  /* luv */
        65.31680573912634, 32.840902778673616, 140.23816157390405,  /* lch */
        140.23816157390405, 43.61996962057442, 65.31680573912634,  /* hsluv */
        140.23816157390405, 63.8012923553667, 65.31680573912634,  /* hpluv */
    },
    {
        "#77aa99",
        0.4666666666666667, 0.6666666666666666, 0.6,  /* rgb */
        0.2773083229337885, 0.3497051265988631, 0.35426866022911496,  /* xyz */
        65.7257012160132, -25.119678136709524, 8.19123245284666,  /* luv */
        65.7257012160132, 26.42147836114495, 161.93945990353262,  /* lch */
        161.93945990353262, 46.16856563564178, 65.7257012160132,  /* hsluv */
        161.93945990353262, 51.01069167422922, 65.7257012160132,  /* hpluv */
    },
    {
        "#77aaaa",
        0.4666666666666667, 0.6666666666666666, 0.6666666666666666,  /* rgb */
        0.292366015899041, 0.3557282037849642, 0.43357250984611356,  /* xyz */
        66.19222849151706, -24.99919854499538, -5.394537643361423,  /* luv */
        66.19222849151706, 25.57461562326485, 192.17705063006068,  /* lch */
        192.17705063006068, 48.83578208689431, 66.19222849151706,  /* hsluv */
        192.17705063006068, 49.02769085221313, 66.19222849151706,  /* hpluv */
    },
    {
        "#77aabb",
        0.4666666666666667, 0.6666666666666666, 0.7333333333333333,  /* rgb */
        0.30950360800637766, 0.362583240627899, 0.5238304949447553,  /* xyz */
        66.71683296850556, -24.888954105226134, -19.519287021925777,  /* luv */
        66.71683296850556, 31.63009014050344, 218.10549404569613,  /* lch */
        218.10549404569613, 51.56699221483656, 66.71683296850556,  /* hsluv */
        218.10549404569613, 60.15951603547389, 66.71683296850556,  /* hpluv */
    },
    {
        "#77aacc",
        0.4666666666666667, 0.6666666666666666, 0.8,  /* rgb */
        0.3287959834500994, 0.3703001908053878, 0.6254370056150255,  /* xyz */
        67.29954601652723, -24.793641092056205, -33.96910297905439,  /* luv */
        67.29954601652723, 42.05501867557902, 233.87474184337157,  /* lch */
        233.87474184337157, 54.31249637486704, 67.29954601652723,  /* hsluv */
        233.87474184337157, 79.29485733535671, 67.29954601652723,  /* hpluv */
    },
    {
        "#77aadd",
        0.4666666666666667, 0.6666666666666666, 0.8666666666666667,  /* rgb */
        0.3503143090007329, 0.3789075210256413, 0.7387668535150315,  /* xyz */
        67.9400192524912, -24.717212026771158, -48.55745604655416,  /* luv */
        67.9400192524912, 54.48639378862763, 243.02253134157468,  /* lch */
        243.02253134157468, 60.644615750636966, 67.9400192524912,  /* hsluv */
        243.02253134157468, 101.76577064784131, 67.9400192524912,  /* hpluv */
    },
    {
        "#77aaee",
        0.4666666666666667, 0.6666666666666666, 0.9333333333333333,  /* rgb */
        0.37412648926690767, 0.3884323931321113, 0.8641776695835547,  /* xyz */
        68.6375602707836, -24.662799054426888, -63.12931812560109,  /* luv */
        68.6375602707836, 67.77583982661068, 248.66084995370142,  /* lch */
        248.66084995370142, 79.87125663901485, 68.6375602707836,  /* hsluv */
        248.66084995370142, 125.30038233433747, 68.6375602707836,  /* hpluv */
    },
    {
        "#77aaff",
        0.4666666666666667, 0.6666666666666666, 1.0,  /* rgb */
        0.40029753767673903, 0.39890081249604403, 1.0020118578753365,  /* xyz */
        69.39116974652664, -24.632712501374055, -77.56187128787154,  /* luv */
        69.39116974652664, 81.37944705422679, 252.38078126005576,  /* lch */
        252.38078126005576, 99.99999999999805, 69.39116974652664,  /* hsluv */
        252.38078126005576, 148.81607728845123, 69.39116974652664,  /* hpluv */
    },
    {
        "#77bb00",
        0.4666666666666667, 0.7333333333333333, 0.0,  /* rgb */
        0.25377124718350785, 0.3946174929525096, 0.06279787159520911,  /* xyz */
        69.08443127448636, -34.36234396998375, 80.80695880584062,  /* luv */
        69.08443127448636, 87.80965365243335, 113.03713389310256,  /* lch */
        113.03713389310256, 100.00000000000233, 69.08443127448636,  /* hsluv */
        113.03713389310256, 161.28775763136687, 69.08443127448636,  /* hpluv */
    },
    {
        "#77bb11",
        0.4666666666666667, 0.7333333333333333, 0.06666666666666667,  /* rgb */
        0.25478291268314496, 0.39502215915236444, 0.06812597655996475,  /* xyz */
        69.11350502446882, -34.325291252926405, 79.54125509480433,  /* luv */
        69.11350502446882, 86.63161594738357, 113.34216503451793,  /* lch */
        113.34216503451793, 98.3127503818399, 69.11350502446882,  /* hsluv */
        113.34216503451793, 159.05701343364362, 69.11350502446882,  /* hpluv */
    },
    {
        "#77bb22",
        0.4666666666666667, 0.7333333333333333, 0.13333333333333333,  /* rgb */
        0.256658270821622, 0.39577230240775524, 0.07800286275594394,  /* xyz */
        69.16734753067907, -34.25744351267406, 77.21672099559342,  /* luv */
        69.16734753067907, 84.47481540278956, 113.9246196780295,  /* lch */
        113.9246196780295, 95.21707157166254, 69.16734753067907,  /* hsluv */
        113.9246196780295, 154.97636010777634, 69.16734753067907,  /* hpluv */
    },
    {
        "#77bb33",
        0.4666666666666667, 0.7333333333333333, 0.2,  /* rgb */
        0.2597460215540797, 0.39700740270073837, 0.09426501661355507,  /* xyz */
        69.25585042404053, -34.14805505595426, 73.44967496645717,  /* luv */
        69.25585042404053, 80.99965689299361, 114.93455112837418,  /* lch */
        114.93455112837418, 90.20884594818914, 69.25585042404053,  /* hsluv */
        114.93455112837418, 148.41098217561463, 69.25585042404053,  /* hpluv */
    },
    {
        "#77bb44",
        0.4666666666666667, 0.7333333333333333, 0.26666666666666666,  /* rgb */
        0.26420401679829864, 0.39879060079842593, 0.11774379156644171,  /* xyz */
        69.38330482343108, -33.995052067645105, 68.13896207774624,  /* luv */
        69.38330482343108, 76.14841901257334, 116.51496143373713,  /* lch */
        116.51496143373713, 83.16663488480384, 69.38330482343108,  /* hsluv */
        116.51496143373713, 139.26604280481757, 69.38330482343108,  /* hpluv */
    },
    {
        "#77bb55",
        0.4666666666666667, 0.7333333333333333, 0.3333333333333333,  /* rgb */
        0.2701664308376606, 0.4011755664141708, 0.14914583884041563,  /* xyz */
        69.55317813587108, -33.79909684324665, 61.26183393561217,  /* luv */
        69.55317813587108, 69.96707257398789, 118.88619768546121,  /* lch */
        118.88619768546121, 74.08016667319231, 69.55317813587108,  /* hsluv */
        118.88619768546121, 127.64859842656082, 69.55317813587108,  /* hpluv */
    },
    {
        "#77bb66",
        0.4666666666666667, 0.7333333333333333, 0.4,  /* rgb */
        0.2777514266111688, 0.4042095647235741, 0.1890934832475596,  /* xyz */
        69.76830970047376, -33.56330718024148, 52.8646424591145,  /* luv */
        69.76830970047376, 62.61921439306997, 122.41111305751139,  /* lch */
        122.41111305751139, 63.03779210912126, 69.76830970047376,  /* hsluv */
        122.41111305751139, 113.8908252780179, 69.76830970047376,  /* hpluv */
    },
    {
        "#77bb77",
        0.4666666666666667, 0.7333333333333333, 0.4666666666666667,  /* rgb */
        0.2870654396313707, 0.4079351699316549, 0.2381472851539575,  /* xyz */
        70.03101346774534, -33.29289915579245, 43.052658588542705,  /* luv */
        70.03101346774534, 54.42378658031234, 127.71501294923867,  /* lch */
        127.71501294923867, 50.211997907406236, 70.03101346774534,  /* hsluv */
        127.71501294923867, 98.61379449210335, 70.03101346774534,  /* hpluv */
    },
    {
        "#77bb88",
        0.4666666666666667, 0.7333333333333333, 0.5333333333333333,  /* rgb */
        0.2982058567333145, 0.4123913367724325, 0.2968201485575297,  /* xyz */
        70.34313906347924, -32.9947227526694, 31.977661096686386,  /* luv */
        70.34313906347924, 45.94804172911017, 135.89682073942384,  /* lch */
        135.89682073942384, 51.92684845536177, 70.34313906347924,  /* hsluv */
        135.89682073942384, 82.88665023927562, 70.34313906347924,  /* hpluv */
    },
    {
        "#77bb99",
        0.4666666666666667, 0.7333333333333333, 0.6,  /* rgb */
        0.3112628208423872, 0.41761412241606166, 0.3655868261986476,  /* xyz */
        70.70611247934326, -32.6767203094589, 19.823810077524133,  /* luv */
        70.70611247934326, 38.21977886085097, 148.75629343317604,  /* lch */
        148.75629343317604, 53.79218735512136, 70.70611247934326,  /* hsluv */
        148.75629343317604, 68.5915373148405, 70.70611247934326,  /* hpluv */
    },
    {
        "#77bbaa",
        0.4666666666666667, 0.7333333333333333, 0.6666666666666666,  /* rgb */
        0.32632051380763977, 0.4236371996021628, 0.4448906758156462,  /* xyz */
        71.12096663347546, -32.34736218360469, 6.793060784869287,  /* luv */
        71.12096663347546, 33.052950171871615, 168.14002625146887,  /* lch */
        168.14002625146887, 55.77132198765064, 71.12096663347546,  /* hsluv */
        168.14002625146887, 58.97282123705766, 71.12096663347546,  /* hpluv */
    },
    {
        "#77bbbb",
        0.4666666666666667, 0.7333333333333333, 0.7333333333333333,  /* rgb */
        0.34345810591497644, 0.43049223644509754, 0.5351486609142879,  /* xyz */
        71.58836721230207, -32.01511718078584, -6.908491665343961,  /* luv */
        71.58836721230207, 32.752022612192604, 192.17705063006088,  /* lch */
        192.17705063006088, 57.827138554386494, 71.58836721230207,  /* hsluv */
        192.17705063006088, 58.054380430888976, 71.58836721230207,  /* hpluv */
    },
    {
        "#77bbcc",
        0.4666666666666667, 0.7333333333333333, 0.8,  /* rgb */
        0.36275048135869814, 0.43820918662258634, 0.6367551715845581,  /* xyz */
        72.10863677538721, -31.68800444474586, -21.082192555175805,  /* luv */
        72.10863677538721, 38.06032670148463, 213.63602724892783,  /* lch */
        213.63602724892783, 59.92414195882183, 72.10863677538721,  /* hsluv */
        213.63602724892783, 66.97682452789428, 72.10863677538721,  /* hpluv */
    },
    {
        "#77bbdd",
        0.4666666666666667, 0.7333333333333333, 0.8666666666666667,  /* rgb */
        0.38426880690933174, 0.44681651684283985, 0.7500850194845641,  /* xyz */
        72.68177874874101, -31.373255275695428, -35.54563302497277,  /* luv */
        72.68177874874101, 47.410686282102965, 228.56776063043063,  /* lch */
        228.56776063043063, 62.030001565716745, 72.68177874874101,  /* hsluv */
        228.56776063043063, 82.77325256964794, 72.68177874874101,  /* hpluv */
    },
    {
        "#77bbee",
        0.4666666666666667, 0.7333333333333333, 0.9333333333333333,  /* rgb */
        0.40808098717550645, 0.45634138894930987, 0.8754958355530873,  /* xyz */
        73.30750211265898, -31.07709384883351, -50.13846355207353,  /* luv */
        73.30750211265898, 58.98856914226528, 238.20831334886813,  /* lch */
        238.20831334886813, 76.3238953534044, 73.30750211265898,  /* hsluv */
        238.20831334886813, 102.10776419928006, 73.30750211265898,  /* hpluv */
    },
    {
        "#77bbff",
        0.4666666666666667, 0.7333333333333333, 1.0,  /* rgb */
        0.43425203558533787, 0.4668098083132426, 1.013330023844869,  /* xyz */
        73.98524706974902, -30.80462950434534, -64.72540360239401,  /* luv */
        73.98524706974902, 71.68195777455288, 244.54891687262864,  /* lch */
        244.54891687262864, 99.9999999999974, 73.98524706974902,  /* hsluv */
        244.54891687262864, 122.9430707559308, 73.98524706974902,  /* hpluv */
    },
    {
        "#77cc00",
        0.4666666666666667, 0.8, 0.0,  /* rgb */
        0.2919949904931248, 0.4710649795717445, 0.07553911936508105,  /* xyz */
        74.25783849490469, -42.31729132493539, 87.51274354482382,  /* luv */
        74.25783849490469, 97.20716757431808, 115.8063563875807,  /* lch */
        115.8063563875807, 100.00000000000233, 74.25783849490469,  /* hsluv */
        115.8063563875807, 166.10982158326158, 74.25783849490469,  /* hpluv */
    },
    {
        "#77cc11",
        0.4666666666666667, 0.8, 0.06666666666666667,  /* rgb */
        0.2930066559927619, 0.47146964577159933, 0.08086722432983669,  /* xyz */
        74.28367629110878, -42.26922727666845, 86.36886989375851,  /* luv */
        74.28367629110878, 96.15752316533344, 116.07728772614288,  /* lch */
        116.07728772614288, 98.58402667132165, 74.28367629110878,  /* hsluv */
        116.07728772614288, 164.2590118749402, 74.28367629110878,  /* hpluv */
    },
    {
        "#77cc22",
        0.4666666666666667, 0.8, 0.13333333333333333,  /* rgb */
        0.29488201413123893, 0.47221978902699013, 0.09074411052581588,  /* xyz */
        74.33153359878153, -42.18099372486566, 84.26496998216035,  /* luv */
        74.33153359878153, 94.23280425473679, 116.59143182539434,  /* lch */
        116.59143182539434, 95.98177369994326, 74.33153359878153,  /* hsluv */
        116.59143182539434, 160.867513369155, 74.33153359878153,  /* hpluv */
    },
    {
        "#77cc33",
        0.4666666666666667, 0.8, 0.2,  /* rgb */
        0.29796976486369664, 0.47345488931997326, 0.10700626438342703,  /* xyz */
        74.41021968056941, -42.03812148472945, 80.84691829015271,  /* luv */
        74.41021968056941, 91.12314664770692, 117.47316192683408,  /* lch */
        117.47316192683408, 91.75999705150736, 74.41021968056941,  /* hsluv */
        117.47316192683408, 155.39443012396885, 74.41021968056941,  /* hpluv */
    },
    {
        "#77cc44",
        0.4666666666666667, 0.8, 0.26666666666666666,  /* rgb */
        0.30242776010791556, 0.4752380874176608, 0.13048503933631367,  /* xyz */
        74.52358306877134, -41.836975807417105, 76.01025133052327,  /* luv */
        74.52358306877134, 86.7634188586395, 118.82892644446079,  /* lch */
        118.82892644446079, 85.79878775804922, 74.52358306877134,  /* hsluv */
        118.82892644446079, 147.73461197865413, 74.52358306877134,  /* hpluv */
    },
    {
        "#77cc55",
        0.4666666666666667, 0.8, 0.3333333333333333,  /* rgb */
        0.30839017414727754, 0.4776230530334057, 0.16188708661028756,  /* xyz */
        74.6747602628398, -41.57705301596414, 69.71581569812206,  /* luv */
        74.6747602628398, 81.17232469226697, 120.8109655606336,  /* lch */
        120.8109655606336, 78.06389566643077, 74.6747602628398,  /* hsluv */
        120.8109655606336, 137.9346805461197, 74.6747602628398,  /* hpluv */
    },
    {
        "#77cc66",
        0.4666666666666667, 0.8, 0.4,  /* rgb */
        0.3159751699207857, 0.480657051342809, 0.20183473101743155,  /* xyz */
        74.86635249236332, -41.26068328228088, 61.982533464768764,  /* luv */
        74.86635249236332, 74.45991162788117, 123.65100861756437,  /* lch */
        123.65100861756437, 68.59784904323604, 74.86635249236332,  /* hsluv */
        123.65100861756437, 126.20459522458509, 74.86635249236332,  /* hpluv */
    },
    {
        "#77cc77",
        0.4666666666666667, 0.8, 0.4666666666666667,  /* rgb */
        0.32528918294098763, 0.4843826565508898, 0.25088853292382945,  /* xyz */
        75.10051892513715, -40.89269964599932, 52.88032827614832,  /* luv */
        75.10051892513715, 66.84715403763367, 127.71501294923905,  /* lch */
        127.71501294923905, 57.510764782403015, 75.10051892513715,  /* hsluv */
        127.71501294923905, 112.94819914941286, 75.10051892513715,  /* hpluv */
    },
    {
        "#77cc88",
        0.4666666666666667, 0.8, 0.5333333333333333,  /* rgb */
        0.33642960004293143, 0.4888388233916674, 0.3095613963274016,  /* xyz */
        75.3790318815133, -40.480010131341395, 42.521599268569695,  /* luv */
        75.3790318815133, 58.70875253818913, 133.59098082347745,  /* lch */
        133.59098082347745, 58.766023135931775, 75.3790318815133,  /* hsluv */
        133.59098082347745, 98.83064361043635, 75.3790318815133,  /* hpluv */
    },
    {
        "#77cc99",
        0.4666666666666667, 0.8, 0.6,  /* rgb */
        0.3494865641520042, 0.49406160903529656, 0.37832807396851953,  /* xyz */
        75.70331289375198, -40.03108041936003, 31.051203693832456,  /* luv */
        75.70331289375198, 50.662260612581676, 142.20007612941046,  /* lch */
        142.20007612941046, 60.14598487846728, 75.70331289375198,  /* hsluv */
        142.20007612941046, 84.91980844451038, 75.70331289375198,  /* hpluv */
    },
    {
        "#77ccaa",
        0.4666666666666667, 0.8, 0.6666666666666666,  /* rgb */
        0.3645442571172567, 0.5000846862213977, 0.45763192358551813,  /* xyz */
        76.0744587192654, -39.55536616002197, 18.63559289623224,  /* luv */
        76.0744587192654, 43.72541954798733, 154.7736188903868,  /* lch */
        154.7736188903868, 61.626981321881246, 76.0744587192654,  /* hsluv */
        154.7736188903868, 73.06731950155238, 76.0744587192654,  /* hpluv */
    },
    {
        "#77ccbb",
        0.4666666666666667, 0.8, 0.7333333333333333,  /* rgb */
        0.38168184922459336, 0.5069397230643324, 0.5478899086841599,  /* xyz */
        76.49326217188192, -39.06274540706937, 5.451999709689497,  /* luv */
        76.49326217188192, 39.441379027259856, 172.05453686579642,  /* lch */
        172.05453686579642, 63.18405530364157, 76.49326217188192,  /* hsluv */
        172.05453686579642, 67.33857291986757, 76.49326217188192,  /* hpluv */
    },
    {
        "#77cccc",
        0.4666666666666667, 0.8, 0.8,  /* rgb */
        0.4009742246683151, 0.5146566732418212, 0.64949641935443,  /* xyz */
        76.9602305249106, -38.562999296774436, -8.321448824567238,  /* luv */
        76.9602305249106, 39.450620087685785, 192.17705063006096,  /* lch */
        192.17705063006096, 64.79231669045932, 76.9602305249106,  /* hsluv */
        192.17705063006096, 69.01116264517013, 76.9602305249106,  /* hpluv */
    },
    {
        "#77ccdd",
        0.4666666666666667, 0.8, 0.8666666666666667,  /* rgb */
        0.4224925502189486, 0.5232640034620748, 0.762826267254436,  /* xyz */
        77.47560307724365, -38.065377782491936, -22.514020013929144,  /* luv */
        77.47560307724365, 44.225039094515594, 210.60247375727985,  /* lch */
        210.60247375727985, 66.42807702467032, 77.47560307724365,  /* hsluv */
        210.60247375727985, 79.50303223093314, 77.47560307724365,  /* hpluv */
    },
    {
        "#77ccee",
        0.4666666666666667, 0.8, 0.9333333333333333,  /* rgb */
        0.44630473048512337, 0.5327888755685448, 0.8882370833229593,  /* xyz */
        78.03936877872391, -37.57827168137805, -36.96867628371262,  /* luv */
        78.03936877872391, 52.714414809702625, 224.53148363592348,  /* lch */
        224.53148363592348, 71.37816419561773, 78.03936877872391,  /* hsluv */
        224.53148363592348, 97.69261381587476, 78.03936877872391,  /* hpluv */
    },
    {
        "#77ccff",
        0.4666666666666667, 0.8, 1.0,  /* rgb */
        0.47247577889495473, 0.5432572949324774, 1.026071271614741,  /* xyz */
        78.65128436924007, -37.108996615294025, -51.546288067938555,  /* luv */
        78.65128436924007, 63.514545132408905, 234.24928321690135,  /* lch */
        234.24928321690135, 99.99999999999682, 78.65128436924007,  /* hsluv */
        234.24928321690135, 121.74954640372582, 78.65128436924007,  /* hpluv */
    },
    {
        "#77dd00",
        0.4666666666666667, 0.8666666666666667, 0.0,  /* rgb */
        0.3346289810403, 0.556332960666096, 0.08975044954747237,  /* xyz */
        79.40465958031285, -49.81312682552503, 94.13320128260455,  /* luv */
        79.40465958031285, 106.50073796855675, 117.88676451029716,  /* lch */
        117.88676451029716, 100.00000000000229, 79.40465958031285,  /* hsluv */
        117.88676451029716, 213.04811455323164, 79.40465958031285,  /* hpluv */
    },
    {
        "#77dd11",
        0.4666666666666667, 0.8666666666666667, 0.06666666666666667,  /* rgb */
        0.3356406465399371, 0.556737626865951, 0.095078554512228,  /* xyz */
        79.42778582956194, -49.75897327324734, 93.09448061331328,  /* luv */
        79.42778582956194, 105.55821967933291, 118.12449099700417,  /* lch */
        118.12449099700417, 98.79934184716835, 79.42778582956194,  /* hsluv */
        118.12449099700417, 211.4436872176047, 79.42778582956194,  /* hpluv */
    },
    {
        "#77dd22",
        0.4666666666666667, 0.8666666666666667, 0.13333333333333333,  /* rgb */
        0.33751600467841414, 0.5574877701213418, 0.1049554407082072,  /* xyz */
        79.47062610700127, -49.659392639560025, 91.1817319993116,  /* luv */
        79.47062610700127, 103.82756631899002, 118.57359388187615,  /* lch */
        118.57359388187615, 96.5898934808467, 79.47062610700127,  /* hsluv */
        118.57359388187615, 208.4907107442417, 79.47062610700127,  /* hpluv */
    },
    {
        "#77dd33",
        0.4666666666666667, 0.8666666666666667, 0.2,  /* rgb */
        0.34060375541087184, 0.5587228704143249, 0.12121759456581835,  /* xyz */
        79.54107837027526, -49.49768038309951, 88.06800639952269,  /* luv */
        79.54107837027526, 101.02472031386101, 119.33769776743239,  /* lch */
        119.33769776743239, 92.99737860490963, 79.54107837027526,  /* hsluv */
        119.33769776743239, 203.68901272724588, 79.54107837027526,  /* hpluv */
    },
    {
        "#77dd44",
        0.4666666666666667, 0.8666666666666667, 0.26666666666666666,  /* rgb */
        0.34506175065509076, 0.5605060685120125, 0.144696369518705,  /* xyz */
        79.64261215477285, -49.26901910920902, 83.64881873239096,  /* luv */
        79.64261215477285, 97.08017881786171, 120.49801639863085,  /* lch */
        120.49801639863085, 87.90775515802211, 79.64261215477285,  /* hsluv */
        120.49801639863085, 196.89030323040726, 79.64261215477285,  /* hpluv */
    },
    {
        "#77dd55",
        0.4666666666666667, 0.8666666666666667, 0.3333333333333333,  /* rgb */
        0.35102416469445274, 0.5628910341277572, 0.1760984167926789,  /* xyz */
        79.77807400919107, -48.97178756224046, 77.87464170121923,  /* luv */
        79.77807400919107, 91.99291166788059, 122.163902680224,  /* lch */
        122.163902680224, 81.27403925789129, 79.77807400919107,  /* hsluv */
        122.163902680224, 188.049297266091, 79.77807400919107,  /* hpluv */
    },
    {
        "#77dd66",
        0.4666666666666667, 0.8666666666666667, 0.4,  /* rgb */
        0.35860916046796093, 0.5659250324371605, 0.21604606119982284,  /* xyz */
        79.94984791559918, -48.60726482536975, 70.7449403153661,  /* luv */
        79.94984791559918, 85.83421680209086, 124.49208623775326,  /* lch */
        124.49208623775326, 73.10956659876972, 79.94984791559918,  /* hsluv */
        124.49208623775326, 177.23376146747424, 79.94984791559918,  /* hpluv */
    },
    {
        "#77dd77",
        0.4666666666666667, 0.8666666666666667, 0.4666666666666667,  /* rgb */
        0.36792317348816284, 0.5696506376452414, 0.26509986310622075,  /* xyz */
        80.1599403321921, -48.17934695949002, 62.30304444078211,  /* luv */
        80.1599403321921, 78.75861108496639, 127.71501294923935,  /* lch */
        127.71501294923935, 63.481886167723665, 80.1599403321921,  /* hsluv */
        127.71501294923935, 164.65295443283281, 80.1599403321921,  /* hpluv */
    },
    {
        "#77dd88",
        0.4666666666666667, 0.8666666666666667, 0.5333333333333333,  /* rgb */
        0.37906359059010664, 0.5741068044860189, 0.32377272650979294,  /* xyz */
        80.41003058934938, -47.69419139775556, 52.63019599586076,  /* luv */
        80.41003058934938, 71.02586446956109, 132.18329341780318,  /* lch */
        132.18329341780318, 64.41299147809862, 80.41003058934938,  /* hsluv */
        132.18329341780318, 150.7164769162924, 80.41003058934938,  /* hpluv */
    },
    {
        "#77dd99",
        0.4666666666666667, 0.8666666666666667, 0.6,  /* rgb */
        0.3921205546991794, 0.5793295901296481, 0.3925394041509108,  /* xyz */
        80.70150346684498, -47.159777274010025, 41.83844326197153,  /* luv */
        80.70150346684498, 63.043635103945604, 138.42172491321847,  /* lch */
        138.42172491321847, 65.44559740502359, 80.70150346684498,  /* hsluv */
        138.42172491321847, 136.14961326250753, 80.70150346684498,  /* hpluv */
    },
    {
        "#77ddaa",
        0.4666666666666667, 0.8666666666666667, 0.6666666666666666,  /* rgb */
        0.4071782476644319, 0.5853526673157492, 0.4718432537679094,  /* xyz */
        81.03547209414519, -46.58540325582046, 30.06264758956073,  /* luv */
        81.03547209414519, 55.44332761118807, 147.16490311349432,  /* lch */
        147.16490311349432, 66.56443742689035, 81.03547209414519,  /* hsluv */
        147.16490311349432, 122.20441864317367, 81.03547209414519,  /* hpluv */
    },
    {
        "#77ddbb",
        0.4666666666666667, 0.8666666666666667, 0.7333333333333333,  /* rgb */
        0.42431583977176857, 0.592207704158684, 0.5621012388665512,  /* xyz */
        81.41279554339104, -45.98115993260928, 17.452140415923953,  /* luv */
        81.41279554339104, 49.181747364701465, 159.21575177548758,  /* lch */
        159.21575177548758, 67.75279739892385, 81.41279554339104,  /* hsluv */
        159.21575177548758, 110.97185492890964, 81.41279554339104,  /* hpluv */
    },
    {
        "#77ddcc",
        0.4666666666666667, 0.8666666666666667, 0.8,  /* rgb */
        0.4436082152154903, 0.5999246543361728, 0.6637077495368213,  /* xyz */
        81.83409362394643, -45.35741758404172, 4.162643040831469,  /* luv */
        81.83409362394643, 45.54802879355505, 174.7564112104559,  /* lch */
        174.7564112104559, 68.99339105237394, 81.83409362394643,  /* hsluv */
        174.7564112104559, 105.54602277980743, 81.83409362394643,  /* hpluv */
    },
    {
        "#77dddd",
        0.4666666666666667, 0.8666666666666667, 0.8666666666666667,  /* rgb */
        0.4651265407661238, 0.6085319845564263, 0.7770375974368273,  /* xyz */
        82.29976037359611, -44.72436560532319, -9.65100034703627,  /* luv */
        82.29976037359611, 45.75380515866533, 192.17705063006085,  /* lch */
        192.17705063006085, 70.26914712807896, 82.29976037359611,  /* hsluv */
        192.17705063006085, 109.25631869199803, 82.29976037359611,  /* hpluv */
    },
    {
        "#77ddee",
        0.4666666666666667, 0.8666666666666667, 0.9333333333333333,  /* rgb */
        0.4889387210322986, 0.6180568566628963, 0.9024484135053505,  /* xyz */
        82.80997714244482, -44.09163010903963, -23.840872276617237,  /* luv */
        82.80997714244482, 50.12443552382756, 208.40062020369575,  /* lch */
        208.40062020369575, 71.5638635335918, 82.80997714244482,  /* hsluv */
        208.40062020369575, 123.79468138219943, 82.80997714244482,  /* hpluv */
    },
    {
        "#77ddff",
        0.4666666666666667, 0.8666666666666667, 1.0,  /* rgb */
        0.5151097694421299, 0.6285252760268291, 1.0402826017971325,  /* xyz */
        83.36472578771537, -43.46798428855355, -38.27059219926555,  /* luv */
        83.36472578771537, 57.914625833138416, 221.36171459246202,  /* lch */
        221.36171459246202, 99.99999999999535, 83.36472578771537,  /* hsluv */
        221.36171459246202, 148.51713538969423, 83.36472578771537,  /* hpluv */
    },
    {
        "#77ee00",
        0.4666666666666667, 0.9333333333333333, 0.0,  /* rgb */
        0.3818077573808148, 0.650690513347127, 0.10547670832764355,  /* xyz */
        84.51930586339607, -56.9192667804191, 100.67057564975723,  /* luv */
        84.51930586339607, 115.64760149901083, 119.48387103559975,  /* lch */
        119.48387103559975, 100.00000000000236, 84.51930586339607,  /* hsluv */
        119.48387103559975, 321.86953860565274, 84.51930586339607,  /* hpluv */
    },
    {
        "#77ee11",
        0.4666666666666667, 0.9333333333333333, 0.06666666666666667,  /* rgb */
        0.3828194228804519, 0.6510951795469819, 0.11080481329239919,  /* xyz */
        84.54013928843374, -56.862163274863434, 99.72303297128221,  /* luv */
        84.54013928843374, 114.79542202234664, 119.69182747506497,  /* lch */
        119.69182747506497, 98.97227803947415, 84.54013928843374,  /* hsluv */
        119.69182747506497, 319.9853677904377, 84.54013928843374,  /* hpluv */
    },
    {
        "#77ee22",
        0.4666666666666667, 0.9333333333333333, 0.13333333333333333,  /* rgb */
        0.38469478101892896, 0.6518453228023727, 0.12068169948837838,  /* xyz */
        84.57873608351305, -56.757025654528164, 97.97652609341417,  /* luv */
        84.57873608351305, 113.22879327486554, 120.08337303916962,  /* lch */
        120.08337303916962, 97.0790709390529, 84.57873608351305,  /* hsluv */
        120.08337303916962, 316.5129496181864, 84.57873608351305,  /* hpluv */
    },
    {
        "#77ee33",
        0.4666666666666667, 0.9333333333333333, 0.2,  /* rgb */
        0.38778253175138666, 0.6530804230953559, 0.13694385334598952,  /* xyz */
        84.64222069925363, -56.585921413754825, 95.12882869462443,  /* luv */
        84.64222069925363, 110.68631600633765, 120.74564729395549,  /* lch */
        120.74564729395549, 93.99522500888881, 84.64222069925363,  /* hsluv */
        120.74564729395549, 310.8536104713048, 84.64222069925363,  /* hpluv */
    },
    {
        "#77ee44",
        0.4666666666666667, 0.9333333333333333, 0.26666666666666666,  /* rgb */
        0.3922405269956056, 0.6548636211930434, 0.16042262829887616,  /* xyz */
        84.73373669936815, -56.34319528482596, 91.07744227289234,  /* luv */
        84.73373669936815, 107.09648054850389, 121.74215873688384,  /* lch */
        121.74215873688384, 89.61447957117866, 84.73373669936815,  /* hsluv */
        121.74215873688384, 302.8116443105832, 84.73373669936815,  /* hpluv */
    },
    {
        "#77ee55",
        0.4666666666666667, 0.9333333333333333, 0.3333333333333333,  /* rgb */
        0.39820294103496756, 0.6572485868087882, 0.19182467557285007,  /* xyz */
        84.85587685489698, -56.02628795962166, 85.76660267852613,  /* luv */
        84.85587685489698, 102.44439993260058, 123.15422851133678,  /* lch */
        123.15422851133678, 83.88389101531176, 84.85587685489698,  /* hsluv */
        123.15422851133678, 292.2988811538113, 84.85587685489698,  /* hpluv */
    },
    {
        "#77ee66",
        0.4666666666666667, 0.9333333333333333, 0.4,  /* rgb */
        0.40578793680847575, 0.6602825851181915, 0.23177231997999403,  /* xyz */
        85.01082934500332, -55.63544444492682, 79.1821217654036,  /* luv */
        85.01082934500332, 96.7735040486586, 125.09288773482037,  /* lch */
        125.09288773482037, 76.79841530578794, 85.01082934500332,  /* hsluv */
        125.09288773482037, 279.3417169136362, 85.01082934500332,  /* hpluv */
    },
    {
        "#77ee77",
        0.4666666666666667, 0.9333333333333333, 0.4666666666666667,  /* rgb */
        0.41510194982867765, 0.6640081903262723, 0.28082612188639194,  /* xyz */
        85.20045567109308, -55.17347457043679, 71.34748922613123,  /* luv */
        85.20045567109308, 90.19188719085297, 127.71501294923965,  /* lch */
        127.71501294923965, 68.39663179420995, 85.20045567109308,  /* hsluv */
        127.71501294923965, 264.10535722236415, 85.20045567109308,  /* hpluv */
    },
    {
        "#77ee88",
        0.4666666666666667, 0.9333333333333333, 0.5333333333333333,  /* rgb */
        0.42624236693062145, 0.6684643571670499, 0.33949898528996414,  /* xyz */
        85.42633694427573, -54.64546887782242, 62.3196179848555,  /* luv */
        85.42633694427573, 82.88463099185145, 131.24616999926488,  /* lch */
        131.24616999926488, 69.09637986710324, 85.42633694427573,  /* hsluv */
        131.24616999926488, 246.9431078839764, 85.42633694427573,  /* hpluv */
    },
    {
        "#77ee99",
        0.4666666666666667, 0.9333333333333333, 0.6,  /* rgb */
        0.4392993310396942, 0.6736871428106791, 0.408265662931082,  /* xyz */
        85.6898036798217, -54.05844475131854, 52.18376821530165,  /* luv */
        85.6898036798217, 75.1362836057233, 136.01089675022305,  /* lch */
        136.01089675022305, 69.87806520000768, 85.6898036798217,  /* hsluv */
        136.01089675022305, 228.4892145499163, 85.6898036798217,  /* hpluv */
    },
    {
        "#77eeaa",
        0.4666666666666667, 0.9333333333333333, 0.6666666666666666,  /* rgb */
        0.4543570240049467, 0.6797102199967802, 0.4875695125480806,  /* xyz */
        85.99195641915486, -53.42093004514775, 41.047690489276455,  /* luv */
        85.99195641915486, 67.36993885548662, 142.46196664864038,  /* lch */
        142.46196664864038, 70.73182265949936, 85.99195641915486,  /* hsluv */
        142.46196664864038, 209.8261420715237, 85.99195641915486,  /* hpluv */
    },
    {
        "#77eebb",
        0.4666666666666667, 0.9333333333333333, 0.7333333333333333,  /* rgb */
        0.4714946161122834, 0.6865652568397149, 0.5778274976467224,  /* xyz */
        86.33368111630973, -52.74250800638625, 29.035281816342884,  /* luv */
        86.33368111630973, 60.206475905488524, 151.1667735438667,  /* lch */
        151.1667735438667, 71.64646280161459, 86.33368111630973,  /* hsluv */
        151.1667735438667, 192.75837882754507, 86.33368111630973,  /* hpluv */
    },
    {
        "#77eecc",
        0.4666666666666667, 0.9333333333333333, 0.8,  /* rgb */
        0.49078699155600514, 0.6942822070172038, 0.6794340083169925,  /* xyz */
        86.71566156577614, -52.03335430784631, 16.280157543825503,  /* luv */
        86.71566156577614, 54.52076201024383, 162.62618062516117,  /* lch */
        162.62618062516117, 72.61003006941901, 86.71566156577614,  /* hsluv */
        162.62618062516117, 180.15097433971854, 86.71566156577614,  /* hpluv */
    },
    {
        "#77eedd",
        0.4666666666666667, 0.9333333333333333, 0.8666666666666667,  /* rgb */
        0.5123053171066386, 0.7028895372374573, 0.7927638562169985,  /* xyz */
        87.13839025167574, -51.30379711881628, 2.9195508235076035,  /* luv */
        87.13839025167574, 51.38680157219075, 176.74297561453304,  /* lch */
        176.74297561453304, 73.61033284454443, 87.13839025167574,  /* hsluv */
        176.74297561453304, 175.99742916890284, 87.13839025167574,  /* hpluv */
    },
    {
        "#77eeee",
        0.4666666666666667, 0.9333333333333333, 0.9333333333333333,  /* rgb */
        0.5361174973728133, 0.7124144093439273, 0.9181746722855217,  /* xyz */
        87.60217847367083, -50.563926349103994, -10.911109954003342,  /* luv */
        87.60217847367083, 51.7277775307036, 192.17705063006107,  /* lch */
        192.17705063006107, 74.63541430532726, 87.60217847367083,  /* hsluv */
        192.17705063006107, 184.5038960168018, 87.60217847367083,  /* hpluv */
    },
    {
        "#77eeff",
        0.4666666666666667, 0.9333333333333333, 1.0,  /* rgb */
        0.5622885457826448, 0.72288282870786, 1.0560088605773035,  /* xyz */
        88.10716627740953, -49.823270490530334, -25.08269813975351,  /* luv */
        88.10716627740953, 55.78082133083507, 206.72221011389317,  /* lch */
        206.72221011389317, 99.99999999999288, 88.10716627740953,  /* hsluv */
        206.72221011389317, 208.278116369071, 88.10716627740953,  /* hpluv */
    },
    {
        "#77ff00",
        0.4666666666666667, 1.0, 0.0,  /* rgb */
        0.4336601298104886, 0.7543952582064761, 0.12276083247086766,  /* xyz */
        89.59847325692459, -63.69333788847134, 107.12821043859446,  /* luv */
        89.59847325692459, 124.63263923688193, 120.73370285175372,  /* lch */
        120.73370285175372, 100.00000000000236, 89.59847325692459,  /* hsluv */
        120.73370285175372, 538.6281622192611, 89.59847325692459,  /* hpluv */
    },
    {
        "#77ff11",
        0.4666666666666667, 1.0, 0.06666666666666667,  /* rgb */
        0.43467179531012573, 0.754799924406331, 0.1280889374356233,  /* xyz */
        89.61735128937391, -63.63528505062333, 106.26012384698615,  /* luv */
        89.61735128937391, 123.85743184585623, 120.91584285848174,  /* lch */
        120.91584285848174, 99.99999999999125, 89.61735128937391,  /* hsluv */
        120.91584285848174, 536.3335326169846, 89.61735128937391,  /* hpluv */
    },
    {
        "#77ff22",
        0.4666666666666667, 1.0, 0.13333333333333333,  /* rgb */
        0.4365471534486028, 0.7555500676617218, 0.13796582363160248,  /* xyz */
        89.65232828976471, -63.528294361482374, 104.65883286367976,  /* luv */
        89.65232828976471, 122.43086000215308, 121.25790391355928,  /* lch */
        121.25790391355928, 99.99999999999123, 89.65232828976471,  /* hsluv */
        121.25790391355928, 532.099457877515, 89.65232828976471,  /* hpluv */
    },
    {
        "#77ff33",
        0.4666666666666667, 1.0, 0.2,  /* rgb */
        0.4396349041810605, 0.756785167954705, 0.15422797748921363,  /* xyz */
        89.70986702297637, -63.353881619318756, 102.04447286000443,  /* luv */
        89.70986702297637, 120.1115679587559, 121.83390414425209,  /* lch */
        121.83390414425209, 99.99999999999119, 89.70986702297637,  /* hsluv */
        121.83390414425209, 525.1840154312002, 89.70986702297637,  /* hpluv */
    },
    {
        "#77ff44",
        0.4666666666666667, 1.0, 0.26666666666666666,  /* rgb */
        0.4440928994252794, 0.7585683660523925, 0.17770675244210027,  /* xyz */
        89.79282926070918, -63.10583553009398, 98.31771223009726,  /* luv */
        89.79282926070918, 116.82773222189793, 122.69462912797134,  /* lch */
        122.69462912797134, 99.99999999999123, 89.79282926070918,  /* hsluv */
        122.69462912797134, 515.3245408143723, 89.79282926070918,  /* hpluv */
    },
    {
        "#77ff55",
        0.4666666666666667, 1.0, 0.3333333333333333,  /* rgb */
        0.4500553134646414, 0.7609533316681373, 0.20910879971607418,  /* xyz */
        89.90358539298707, -62.78086482156995, 93.41937265036842,  /* luv */
        89.90358539298707, 112.55494735520354, 123.90238788493764,  /* lch */
        123.90238788493764, 99.99999999999115, 89.90358539298707,  /* hsluv */
        123.90238788493764, 502.37486363004695, 89.90358539298707,  /* hpluv */
    },
    {
        "#77ff66",
        0.4666666666666667, 1.0, 0.4,  /* rgb */
        0.4576403092381496, 0.7639873299775406, 0.24905644412321815,  /* xyz */
        90.04414819996332, -62.37830983189142, 87.32580995622347,  /* luv */
        90.04414819996332, 107.31659061857071, 125.53886439659641,  /* lch */
        125.53886439659641, 99.99999999999092, 90.04414819996332,  /* hsluv */
        125.53886439659641, 486.3103502681786, 90.04414819996332,  /* hpluv */
    },
    {
        "#77ff77",
        0.4666666666666667, 1.0, 0.4666666666666667,  /* rgb */
        0.4669543222583515, 0.7677129351856214, 0.29811024602961606,  /* xyz */
        90.2162444924982, -61.89993691124101, 80.04580310117647,  /* luv */
        90.2162444924982, 101.18761180958829, 127.71501294923978,  /* lch */
        127.71501294923978, 99.99999999999089, 90.2162444924982,  /* hsluv */
        127.71501294923978, 467.25218069524425, 90.2162444924982,  /* hpluv */
    },
    {
        "#77ff88",
        0.4666666666666667, 1.0, 0.5333333333333333,  /* rgb */
        0.4780947393602953, 0.772169102026399, 0.35678310943318825,  /* xyz */
        90.42135781952871, -61.34971336834867, 71.61742238865664,  /* luv */
        90.42135781952871, 94.30186912237633, 130.58438831892917,  /* lch */
        130.58438831892917, 99.99999999999083, 90.42135781952871,  /* hsluv */
        130.58438831892917, 445.5176913527449, 90.42135781952871,  /* hpluv */
    },
    {
        "#77ff99",
        0.4666666666666667, 1.0, 0.6,  /* rgb */
        0.491151703469368, 0.7773918876700282, 0.42554978707430613,  /* xyz */
        90.66075593680593, -60.73352971343137, 62.1043577106315,  /* luv */
        90.66075593680593, 86.8649116623181, 134.36062561756734,  /* lch */
        134.36062561756734, 99.99999999999046, 90.66075593680593,  /* hsluv */
        134.36062561756734, 421.7144128799723, 90.66075593680593,  /* hpluv */
    },
    {
        "#77ffaa",
        0.4666666666666667, 1.0, 0.6666666666666666,  /* rgb */
        0.5062093964346206, 0.7834149648561293, 0.5048536366913048,  /* xyz */
        90.93550965766799, -60.05886628257004, 51.591619734175595,  /* luv */
        90.93550965766799, 79.17551797079325, 139.3368430703715,  /* lch */
        139.3368430703715, 99.99999999999024, 90.93550965766799,  /* hsluv */
        139.3368430703715, 396.9094532295202, 90.93550965766799,  /* hpluv */
    },
    {
        "#77ffbb",
        0.4666666666666667, 1.0, 0.7333333333333333,  /* rgb */
        0.5233469885419572, 0.790270001699064, 0.5951116217899465,  /* xyz */
        91.24650664857295, -59.33441733474348, 40.18074987134882,  /* luv */
        91.24650664857295, 71.65937301342656, 145.89448536784303,  /* lch */
        145.89448536784303, 99.99999999999018, 91.24650664857295,  /* hsluv */
        145.89448536784303, 372.92076505584805, 91.24650664857295,  /* hpluv */
    },
    {
        "#77ffcc",
        0.4666666666666667, 1.0, 0.8,  /* rgb */
        0.5426393639856789, 0.7979869518765529, 0.6967181324602166,  /* xyz */
        91.59446223729016, -58.56969393228817, 27.98478875046047,  /* luv */
        91.59446223729016, 64.91192069820313, 154.4613784907186,  /* lch */
        154.4613784907186, 99