MODULE ALGFN;

% Author: James H. Davenport.

% Redistribution and use in source and binary forms, with or without
% modification, are permitted provided that the following conditions are met:
%
%    * Redistributions of source code must retain the relevant copyright
%      notice, this list of conditions and the following disclaimer.
%    * Redistributions in binary form must reproduce the above copyright
%      notice, this list of conditions and the following disclaimer in the
%      documentation and/or other materials provided with the distribution.
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
% AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
% THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
% PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNERS OR
% CONTRIBUTORS
% BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
% CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
% SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
% INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
% CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
% ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
% POSSIBILITY OF SUCH DAMAGE.
%


% Check if an expression is in a pure algebraic extension of
% Q(all "constants")(var).


EXPORTS ALGFNPL,ALGEBRAICSF;

IMPORTS SIMP,INTERR,DEPENDSP,DEPENDSPL;

SYMBOLIC PROCEDURE ALGFNP(PF,VAR);
   IF ATOM PF THEN T
    ELSE IF NOT ATOM CAR PF THEN INTERR "Not prefix form"
    ELSE IF CAR PF EQ '!*SQ THEN ALGFNSQ(CADR PF,VAR)
      ELSE IF CAR PF EQ 'EXPT
       THEN IF NOT algint!-RATNUMP CADDR PF
              THEN (NOT DEPENDSP(CADR PF,VAR))
                AND (NOT DEPENDSP(CADDR PF,VAR))
             ELSE ALGFNP(CADR PF,VAR)
    ELSE IF NOT MEMQ(CAR PF,'(MINUS PLUS TIMES QUOTIENT SQRT))
           % JPff fiddle
     THEN NOT DEPENDSPL(CDR PF,VAR)
    ELSE ALGFNPL(CDR PF,VAR);

SYMBOLIC PROCEDURE ALGFNPL(P!-LIST,VAR);
   NULL P!-LIST OR ALGFNP(CAR P!-LIST,VAR) AND ALGFNPL(CDR P!-LIST,VAR);

SYMBOLIC PROCEDURE ALGFNSQ(SQ,VAR);
   ALGFNSF(NUMR SQ,VAR) AND ALGFNSF(DENR SQ,VAR);

SYMBOLIC PROCEDURE ALGFNSF(SF,VAR);
   ATOM SF
 OR ALGFNP(MVAR SF,VAR) AND ALGFNSF(LC SF,VAR) AND ALGFNSF(RED SF,VAR);

SYMBOLIC PROCEDURE algint!-RATNUMP Q;
   IF ATOM Q THEN NUMBERP Q
    ELSE CAR Q EQ 'QUOTIENT AND (NUMBERP CADR Q) AND (NUMBERP CADDR Q);

SYMBOLIC PROCEDURE ALGEBRAICSF U;
   IF ATOM U THEN NIL
    ELSE ALGEBRAICP MVAR U OR ALGEBRAICSF LC U OR ALGEBRAICSF RED U;

SYMBOLIC PROCEDURE ALGEBRAICP U;
   IF ATOM U THEN NIL
    ELSE IF CAR U EQ 'EXPT THEN 1 NEQ DENR SIMP CADDR U
    ELSE CAR U EQ 'SQRT;

ENDMODULE;

END;

