#!/bin/bash

add_config_flag() { CONFIG_FLAGS+=("$@"); }
add_c_flag() { C_FLAGS="$C_FLAGS $@"; }
add_cxx_flag() { CXX_FLAGS="$CXX_FLAGS $@"; }
add_ld_flag() { LD_FLAGS="$LD_FLAGS $@"; }
add_flag() {
  add_c_flag "$@"
  add_cxx_flag "$@"
}

# Our own flags which we can insert in the correct place. We don't use CFLAGS
# and friends here (we unset them below), because they influence config tests
# such as ./configure and cmake tests. Our warning flags break those tests, so
# we can't add them globally here.
CONFIG_FLAGS=()
C_FLAGS=""
CXX_FLAGS=""
LD_FLAGS=""

unset CFLAGS
unset CXXFLAGS
unset CPPFLAGS
unset LDFLAGS

# Optimisation flags.
add_flag -O3 -march=native

# Warn on non-ISO C.
add_c_flag -pedantic
add_c_flag -std=c99
add_cxx_flag -std=c++11

add_flag -g3
add_flag -ftrapv
