/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "VectorEditor_p.h"

#include "ui_UiVectorEditor.h"

VectorEditor::VectorEditor(QWidget* parent, int number) : m_vectorEditor(new Ui_VectorEditor), m_number(number)
{
  m_vectorEditor->setupUi(this);
  switch(number)
  {
    case 2:
      m_vectorEditor->doubleSpinBox_3->setVisible(false);
    case 3:
      m_vectorEditor->doubleSpinBox_4->setVisible(false);
    default:
      break;
  }
  connect(m_vectorEditor->doubleSpinBox_1, SIGNAL(valueChanged(double)), SLOT(spinBoxChanged()));
  connect(m_vectorEditor->doubleSpinBox_2, SIGNAL(valueChanged(double)), SLOT(spinBoxChanged()));
  connect(m_vectorEditor->doubleSpinBox_3, SIGNAL(valueChanged(double)), SLOT(spinBoxChanged()));
  connect(m_vectorEditor->doubleSpinBox_4, SIGNAL(valueChanged(double)), SLOT(spinBoxChanged()));
}

VectorEditor::~VectorEditor()
{
  
}

void VectorEditor::setMaximum( const QList<double>& val)
{
  Q_ASSERT(m_number == val.size());
  switch(m_number)
  {
    case 4:
      m_vectorEditor->doubleSpinBox_4->setMaximum(val[3]);
    case 3:
      m_vectorEditor->doubleSpinBox_3->setMaximum(val[2]);
    case 2:
      m_vectorEditor->doubleSpinBox_2->setMaximum(val[1]);
      m_vectorEditor->doubleSpinBox_1->setMaximum(val[0]);
    default:
      break;
  }
}

void VectorEditor::setMinimum( const QList<double>& val)
{
  Q_ASSERT(m_number == val.size());
  switch(m_number)
  {
    case 4:
      m_vectorEditor->doubleSpinBox_4->setMinimum(val[3]);
    case 3:
      m_vectorEditor->doubleSpinBox_3->setMinimum(val[2]);
    case 2:
      m_vectorEditor->doubleSpinBox_2->setMinimum(val[1]);
      m_vectorEditor->doubleSpinBox_1->setMinimum(val[0]);
    default:
      break;
  }
}

void VectorEditor::setValues( const QList<double>& val)
{
  Q_ASSERT(m_number == val.size());
  switch(m_number)
  {
    case 4:
      m_vectorEditor->doubleSpinBox_4->setValue(val[3]);
    case 3:
      m_vectorEditor->doubleSpinBox_3->setValue(val[2]);
    case 2:
      m_vectorEditor->doubleSpinBox_2->setValue(val[1]);
      m_vectorEditor->doubleSpinBox_1->setValue(val[0]);
    default:
      break;
  }
}

void VectorEditor::spinBoxChanged()
{
  QList<double> vals;
  switch(m_number)
  {
    case 4:
      vals.push_front(m_vectorEditor->doubleSpinBox_4->value());
    case 3:
      vals.push_front(m_vectorEditor->doubleSpinBox_3->value());
    case 2:
      vals.push_front(m_vectorEditor->doubleSpinBox_2->value());
      vals.push_front(m_vectorEditor->doubleSpinBox_1->value());
  }
  emit(valuesChanged(vals));
}

#include "VectorEditor_p.moc"
