#include "osl/move_order/cheapPtype.h"
#include "osl/move_order/moveSorter.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;
using namespace osl::move_order;

class MoveOrderCheapPtypeTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(MoveOrderCheapPtypeTest);
  CPPUNIT_TEST(testSort);
  CPPUNIT_TEST_SUITE_END();
public:
  void testSort() 
  { 
    const Square from = Square(2,3);
    const Square to   = Square(2,2);
    
    const Move m1 = Move(from, to, ROOK, PTYPE_EMPTY, false, BLACK);
    const Move m2 = Move(from, to, SILVER, PTYPE_EMPTY, false, BLACK);
    MoveVector moves;
    moves.push_back(m1);
    moves.push_back(m2);
    MoveSorter::sort(moves, CheapPtype());
    CPPUNIT_ASSERT(moves[0] == m2); 
  }
};

CPPUNIT_TEST_SUITE_REGISTRATION(MoveOrderCheapPtypeTest);

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
