/*################################################################################
# Linux Management Providers (LMP), Provider Common Library
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
################################################################################*/

#ifndef _DATASTORE_H_
#define _DATASTORE_H_

#include "Common.h"

using namespace std;

#define _DATASTORE_PATH "/var/lib/OpenDRIM"

// Initialize a datastore
int DS_initDataStore(const string& nameSpace, const string& classname, const string& keys, const string& property_name, string& errorMessage);

// Delete the data of an instance in a datastore
int DS_deleteDataStore(const string& nameSpace, const string& classname, const string& keys, string& errorMessage);

// Set any property stored in local datastore to NULL
int DS_setPropertyNULL(const string& nameSpace, const string& classname, const string& keys, const string& property_name, string& errorMessage);

// Get the list of the entries of keys
int DS_getKeysEntries(const string& nameSpace, const string& classname, vector<string>& keys_entries, string& errorMessage);

// Check if an instance exists according to the values of its keys
bool DS_keysEntryExists(const string& nameSpace, const string& classname, const string& keys_entry, string& errorMessage);

#define _GETPROPERTY_INTEGER string property_file;\
	CF_assert(CF_readTextFile((string) _DATASTORE_PATH+"/"+nameSpace+"/"+classname+"/"+keys+"/"+CF_toLowCase(property_name), property_file, errorMessage));\
	vector<string> property_file_lines;\
	CF_splitText(property_file_lines, property_file, '\n');\
	property = atoll(property_file_lines[0].c_str());\
	return OK;

#define _SETPROPERTY_INTEGER_AND_REAL CF_assert(DS_initDataStore(nameSpace, classname, keys, errorMessage));\
	string property_file;\
	CF_assert(CF_writeTextFile((string) _DATASTORE_PATH+"/"+nameSpace+"/"+classname+"/"+keys+"/"+CF_toLowCase(property_name), CF_intToStr(property), errorMessage));\
	return OK;

#define _GETPROPERTY_REAL string property_file;\
	CF_assert(CF_readTextFile((string) _DATASTORE_PATH+"/"+nameSpace+"/"+classname+"/"+keys+"/"+CF_toLowCase(property_name), property_file, errorMessage));\
	vector<string> property_file_lines;\
	CF_splitText(property_file_lines, property_file, '\n');\
	property = atof(property_file_lines[0].c_str());\
	return OK;

#define _GETPROPERTY_INTEGERARRAY property.clear();\
	string property_file;\
	CF_assert(CF_readTextFile((string) _DATASTORE_PATH+"/"+nameSpace+"/"+classname+"/"+keys+"/"+CF_toLowCase(property_name), property_file, errorMessage));\
	vector<string> property_file_lines;\
	CF_splitText(property_file_lines, property_file, '\n');\
	for (size_t i=0; i<property_file_lines.size(); i++)\
		property.push_back(atoll(property_file_lines[i].c_str()));\
	return OK;

#define _SETPROPERTY_INTEGERARRAY CF_assert(DS_initDataStore(nameSpace, classname, keys, errorMessage));\
	string property_file;\
	for (size_t i=0; i<property.size(); i++) {\
		property_file += CF_intToStr(property[i]);\
		if (i < property.size()-1)\
			property_file += "\n";\
	}\
	CF_assert(CF_writeTextFile((string) _DATASTORE_PATH+"/"+nameSpace+"/"+classname+"/"+keys+"/"+CF_toLowCase(property_name), property_file, errorMessage));\
	return OK;

#define _GETPROPERTY_REALARRAY property.clear();\
	string property_file;\
	CF_assert(CF_readTextFile((string) _DATASTORE_PATH+"/"+nameSpace+"/"+classname+"/"+keys+"/"+CF_toLowCase(property_name), property_file, errorMessage));\
	vector<string> property_file_lines;\
	CF_splitText(property_file_lines, property_file, '\n');\
	for (size_t i=0; i<property_file_lines.size(); i++)\
		property.push_back(atof(property_file_lines[i].c_str()));\
	return OK;

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, bool& property, string& errorMessage);
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const bool& property, string& errorMessage);

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, unsigned char& property, string& errorMessage);
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const unsigned char& property, string& errorMessage);

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, unsigned short& property, string& errorMessage);
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const unsigned short& property, string& errorMessage);

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, unsigned long& property, string& errorMessage);
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const unsigned long& property, string& errorMessage);

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, unsigned long long& property, string& errorMessage);
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const unsigned long long& property, string& errorMessage);

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, signed char& property, string& errorMessage);
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const signed char& property, string& errorMessage);

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, short& property, string& errorMessage);
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const short& property, string& errorMessage);

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, long& property, string& errorMessage);
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const long& property, string& errorMessage);

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, long long& property, string& errorMessage);
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const long long& property, string& errorMessage);

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, float& property, string& errorMessage);
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const float& property, string& errorMessage);

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, double& property, string& errorMessage);
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const double& property, string& errorMessage);

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, string& property, string& errorMessage);
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const string& property, string& errorMessage);

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, vector<bool>& property, string& errorMessage);
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const vector<bool>& property, string& errorMessage);

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, vector<unsigned char>& property, string& errorMessage);
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const vector<unsigned char>& property, string& errorMessage);

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, vector<unsigned short>& property, string& errorMessage);
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const vector<unsigned short>& property, string& errorMessage);

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, vector<unsigned long>& property, string& errorMessage);
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const vector<unsigned long>& property, string& errorMessage);

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, vector<unsigned long long>& property, string& errorMessage);
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const vector<unsigned long long>& property, string& errorMessage);

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, vector<signed char>& property, string& errorMessage);
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const vector<signed char>& property, string& errorMessage);

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, vector<short>& property, string& errorMessage);
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const vector<short>& property, string& errorMessage);

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, vector<long>& property, string& errorMessage);
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const vector<long>& property, string& errorMessage);

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, vector<long long>& property, string& errorMessage);
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const vector<long long>& property, string& errorMessage);

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, vector<unsigned short>& property, string& errorMessage);
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const vector<unsigned short>& property, string& errorMessage);

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, vector<float>& property, string& errorMessage);
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const vector<float>& property, string& errorMessage);

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, vector<double>& property, string& errorMessage);
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const vector<double>& property, string& errorMessage);

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, vector<string>& property, string& errorMessage);
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const vector<string>& property, string& errorMessage);

#endif /*COMMON_H_*/
