#include <stdio.h>
#include "LoggerTester.h"
#include "GZFileLogger.h"

#include "TimeUtil.h"

#define LOOP_COUNT 1000000L

LoggerTester::LoggerTester() :BaseTest()
{
}

LoggerTester::~LoggerTester()
{
}

void LoggerTester::testMessages()
{
	testHeaderWithoutTime();
	testHeaderWithTime();
	testHeaderWithTimeCopy();
	testMethodsLoads();
}

void LoggerTester::testHeaderWithoutTime()
{
	startTest("testHeaderWithoutTime");
	GZFileLogger * logger = new GZFileLogger();
	if (assert(logger->openFile("file-test-header.gz")==FALSE,"can't open file"))
	{
		return;
	}
	jbyte tmpByte = 0;
	jlong tmpLong = 0;
	jlong tmpLong2 = 0;
	logger->writeMainHeader();
	for (long i=0;i<LOOP_COUNT;i++)
	{
		tmpLong=(jlong)i;
		logger->writeHeader(tmpByte, tmpLong, tmpLong2);
	}
	delete logger;
	
	stopTest();
}

void LoggerTester::testHeaderWithTime()
{
	startTest("testHeaderWithTime");
	GZFileLogger * logger = new GZFileLogger();
	if (assert(logger->openFile("file-test-header-time.gz")==FALSE,"can't open file"))
	{
		return;
	}
	jbyte tmpByte = 0;
	jlong tmpLong = 0;
	jlong tmpLong2 = 0;
	logger->writeMainHeader();
	for (long i=0;i<LOOP_COUNT;i++)
	{
		tmpLong2=(jlong)i;
		logger->getTimeUtil().sysTimeMillis(tmpLong);
		logger->writeHeader(tmpByte, tmpLong, tmpLong2);
	}
	delete logger;
	
	stopTest();
}

void LoggerTester::testHeaderWithTimeCopy()
{
	startTest("testHeaderWithTimeCopy");
	GZFileLogger * logger = new GZFileLogger();
	if (assert(logger->openFile("file-test-header-time-copy.gz")==FALSE,"can't open file"))
	{
		return;
	}
	jbyte tmpByte = 0;
	jlong tmpLong = 0;
	jlong tmpLong2 = 0;
	logger->writeMainHeader();
	for (long i=0;i<LOOP_COUNT;i++)
	{
		tmpLong2=(jlong)i;
		tmpLong=logger->getTimeUtil().sysTimeMillis();
		logger->writeHeader(tmpByte, tmpLong, tmpLong2);
	}
	delete logger;
	
	stopTest();
}
//

void LoggerTester::testMethodsLoads()
{
	startTest("testMethodsLoads");
	GZFileLogger * logger = new GZFileLogger();
	if (assert(logger->openFile("serverspy_1_main_1137089546857.log.gz")==FALSE,"can't open file"))
	{
		return;
	}
	logger->writeMainHeader();
	
	delete logger;
	
	logger = new GZFileLogger();
	if (assert(logger->openFile("serverspy_1_thread_1137037871436_32609794_2.log.gz")==FALSE,"can't open file"))
	{
		return;
	}	

	jlong time=0;
	jlong clockCPU=0;
	char * className = "Test";
	jint classId=1;
	jint numberOfMethods=1;
	
	logger->writeLoadClass(time,clockCPU,className,classId,numberOfMethods);
	logger->writeLoadMethod(time,clockCPU,classId,classId,className,className);
	
	logger->writeBeginThread(time,
		                      clockCPU, 
		                      classId,
		                      classId,
		                      className);
		                      
	for (long i=0;i<LOOP_COUNT;i++)
	{
		logger->writeEnterMethod(time,
		                         clockCPU, 
		                         classId,
		                         classId,
		                         classId,
		                         classId,
		                         classId);
	    logger->writeExitMethod(time,
		                      clockCPU, 
		                      classId,
		                      classId,
		                      classId);
	}
	                         
	
	logger->writeEndThread(time,
	                      clockCPU, 
	                      classId,
	                      classId);
	
	delete logger;
	
	stopTest();
}
