with Ada.Exceptions;         use Ada.Exceptions;
with Ada.Strings.Unbounded;  use Ada.Strings.Unbounded;
with GNATCOLL.SQL;           use GNATCOLL.SQL;
with Ada.Text_IO;            use Ada.Text_IO;
with Database;               use Database;
with GNATCOLL.SQL.Exec;      use GNATCOLL.SQL.Exec;
with GNATCOLL.SQL.Postgres;  use GNATCOLL.SQL.Postgres;
with Ada.Numerics.Generic_Elementary_Functions;

procedure Main is
   package Funcs is new Ada.Numerics.Generic_Elementary_Functions (Float);
   use Funcs;

   Zero : Float := 0.0;
   Nan  : constant Float := 0.0 / Zero;
   Inf  : constant Float := 1.0 / Zero;
   MInf : constant Float := -Inf;

   function Is_Nan (X : Float) return Boolean
      is (not (X = X));
   --  See a-numaux-x86.adb

   Val   : constant Float := Nan;
   Descr : constant Database_Description := Setup ("testdb");
   DB    : constant Database_Connection := Build_Connection (Descr);

   procedure Test (X : Float) is
      Q     : SQL_Query;
   begin
      Put_Line (Float'Image (X));
      Put_Line ("Is NAN ? " & Boolean'Image (Is_Nan (X)));
      Put_Line ("Is -inf ? " & Boolean'Image (X < Float'First));
      Put_Line ("Is +inf ? " & Boolean'Image (X > Float'Last));
      Q := SQL_Insert (Data.Value = X);
      Put_Line (To_String (To_String (Q, DB.all)));
      New_Line;
   exception
      when E : others =>
         Put_Line ("Exception " & Exception_Information (E));
   end Test;

begin
   Test (0.0);
   Test (Nan);
   Test (Inf);
   Test (-Inf);
end Main;
