------------------------------------------------------------------------------
--                                  G P S                                   --
--                                                                          --
--                     Copyright (C) 2010-2014, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

--  Support package to write tests

with Ada.Strings.Unbounded; use Ada.Strings.Unbounded;
with GNAT.Source_Info;      use GNAT.Source_Info;
with GNAT.Strings;          use GNAT.Strings;
with GNATCOLL.VFS;          use GNATCOLL.VFS;

package Asserts is

   procedure Set_Module (Name : String);
   --  Store the name of the module we are testing.
   --  This name is used in error messages

   procedure Assert (S1, S2 : String; Msg : String := "";
                     Loc : String := GNAT.Source_Info.Source_Location);
   procedure Assert (S1 : Unbounded_String; S2 : String; Msg : String := "";
                     Loc : String := GNAT.Source_Info.Source_Location);
   procedure Assert (S1, S2 : Integer; Msg : String := "";
                     Loc : String := GNAT.Source_Info.Source_Location);
   procedure Assert (S1, S2 : String_List; Msg : String := "";
                     Loc : String := GNAT.Source_Info.Source_Location);
   procedure Assert (S1, S2 : File_Array; Msg : String := "";
                     Loc : String := GNAT.Source_Info.Source_Location);
   procedure Assert (S1 : Boolean; Msg : String := "";
                     Loc : String := GNAT.Source_Info.Source_Location);
   --  Check that the two arguments are equal. If not, display an
   --  error message.
   --  First argument is the value we are testing, the second argument
   --  is the expected value.

end Asserts;
