# - Find opensc
# Find the native OPENSC includes
#
#  OPENSC_INCLUDE_DIR - where to find pkcs11.h
#  OPENSC_FOUND       - True if opensc found.


IF (OPENSC_INCLUDE_DIR)
  # Already in cache, be silent
  SET(OPENSC_FIND_QUIETLY TRUE)
ENDIF (OPENSC_INCLUDE_DIR)

FIND_PATH(OPENSC_INCLUDE_DIR opensc/pkcs11.h)

IF(WIN32 AND MSVC)
   SET(OPENSC_NAMES libpkcs11MD libpkcs11)
ELSE(WIN32 AND MSVC)
   SET(OPENSC_NAMES libpkcs11 libpkcs11MD)
ENDIF(WIN32 AND MSVC)

FIND_LIBRARY(OPENSC_LIBRARY NAMES ${OPENSC_NAMES} )

# handle the QUIETLY and REQUIRED arguments and set OPENSCSC_FOUND to TRUE if 
# all listed variables are TRUE
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(OpenSc DEFAULT_MSG OPENSC_LIBRARY OPENSC_INCLUDE_DIR)

IF(OPENSC_FOUND)
  SET( OPENSC_LIBRARIES ${OPENSC_LIBRARY} )
ELSE(OPENSC_FOUND)
  SET( OPENSC_LIBRARIES )
ENDIF(OPENSC_FOUND) 

MARK_AS_ADVANCED( OPENSC_LIBRARY OPENSC_INCLUDE_DIR )

