/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util.iterator;

import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.codehaus.janino.util.iterator.EnumerationIterator;

public class TraversingIterator
implements Iterator {
    private final Stack nest = new Stack();
    private Object nextElement = null;
    private boolean nextElementRead = false;

    public TraversingIterator(Iterator iterator) {
        this.nest.push(iterator);
    }

    public boolean hasNext() {
        return this.nextElementRead || this.readNext();
    }

    public Object next() {
        if (!this.nextElementRead && !this.readNext()) {
            throw new NoSuchElementException();
        }
        this.nextElementRead = false;
        return this.nextElement;
    }

    private boolean readNext() {
        while (!this.nest.empty()) {
            Iterator iterator = (Iterator)this.nest.peek();
            if (!iterator.hasNext()) {
                this.nest.pop();
                continue;
            }
            Object e = iterator.next();
            if (e instanceof Iterator) {
                this.nest.push(e);
                continue;
            }
            if (e instanceof Object[]) {
                this.nest.push(Arrays.asList((Object[])e).iterator());
                continue;
            }
            if (e instanceof Collection) {
                this.nest.push(((Collection)e).iterator());
                continue;
            }
            if (e instanceof Enumeration) {
                this.nest.push(new EnumerationIterator((Enumeration)e));
                continue;
            }
            this.nextElement = e;
            this.nextElementRead = true;
            return true;
        }
        return false;
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

