/*
 *  playlist.h
 *  mod_musicindex
 *
 *  $Id: playlist.h 1011 2012-08-07 20:23:39Z varenet $
 *
 *  Created by Thibaut VARENE on Thu Mar 20 2003.
 *  Copyright (c) 2003-2004 Regis BOUDIN
 *  Copyright (c) 2003-2004 Thibaut VARENE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version 2.1,
 *  as published by the Free Software Foundation.
 *
 */

#ifndef PLAYLIST_H
#define PLAYLIST_H

#include "mod_musicindex.h"

/**
 * Function pointer type, as we need it.
 *
 * Here comes the declaration of the funny part... We will (again) use
 * function pointers which will allocate a new entry  from the apache pool,
 * fill it, and close the "in" file if they recognise the file.
 */
typedef mu_ent* (*make_entry_ptr)(request_rec *, apr_pool_t *, FILE *const,
				const char *const);

/**
 * Enumerate handlers to access relevant data in struct filetype.
 * @a FT_MAX is the last element of the enum, it's a marker that gives
 * us the size of the corresponding array.
 *
 * @warning <b>BEWARE</b>: you must keep that in a coherent order wrt
 * struct #filetype[] !
 */
enum { FT_MP3, FT_OGG, FT_FLAC, FT_MP4, FT_MAX };

/**
 * struct used to associate a filetype name and its corresponding mimetype.
 */
struct ftype {
	const char *const nametype;	/**< Display name of the filetype */
	const char *const mimetype;	/**< Mime type associated to the filetype */
};
extern const struct ftype const filetype[];

/**
 * first struct to handle yet unparsed files.
 * DEV NOTE: filename is the path to the file on the filesystem,
 * while uri is the path to the file on the webserver.
 */
typedef struct mu_ent_names {
	char filename[MAX_STRING];	/**< file path without trailing '/' */
	char uri[MAX_STRING];		/**< file URI with trailing '/' */
} mu_ent_names;

#define NEW_ENT(pool) ((mu_ent *)apr_pcalloc(pool, sizeof(mu_ent)))

void make_music_entry(request_rec *, apr_pool_t *,
	mu_pack *const, mu_ent_names *, unsigned long);

void build_custom_list(request_rec *, mu_pack *const);

/** this is used in several places; make it a define to avoid duplicating code */
#define P_FLAGS_OPTIONS(p, soptions) \
	if (soptions & MI_ALLOWSTREAM) \
		p->flags |= EF_ALLOWSTREAM; \
	if (soptions & MI_ALLOWDWNLD) \
		p->flags |= EF_ALLOWDWNLD; \
	if (soptions & MI_ALLOWTARBALL) \
		p->flags |= EF_ALLOWTARBALL; \
	if (soptions & MI_ALLOWRSS) \
		p->flags |= EF_ALLOWRSS

#endif	/* PLAYLIST_H */
