import QtQuick 2.7
import QtQuick.Controls 2.2

import Common.Styles 1.0

// =============================================================================

BusyIndicator {
	id: busyIndicator
	
	// ---------------------------------------------------------------------------
	
	property color color: BusyIndicatorStyle.colorModel.color
	
	readonly property int _rotation: 360
	readonly property int _size: width < height ? width : height
	
	// ---------------------------------------------------------------------------
	
	visible: running
	
	contentItem: Item {
		x: parent.width / 2 - width / 2
		y: parent.height / 2 - height / 2
		
		height: _size
		width: _size
		
		Item {
			id: item
			
			height: parent.height
			width: parent.width
			opacity: busyIndicator.running ? 1 : 0
			// -----------------------------------------------------------------------
			// Animation.
			// -----------------------------------------------------------------------
			
			Behavior on opacity {
				OpacityAnimator {
					duration: 250
				}
			}
			
			RotationAnimator {
				duration: BusyIndicatorStyle.duration
				loops: Animation.Infinite
				running: busyIndicator.visible
				target: item
				
				from: 0
				to: busyIndicator._rotation
			}
			
			// -----------------------------------------------------------------------
			// Items to draw.
			// -----------------------------------------------------------------------
			
			Repeater {
				id: repeater
				
				model: BusyIndicatorStyle.nSpheres
				
				Rectangle {
					x: item.width / 2 - width / 2
					y: item.height / 2 - height / 2
					property real ratio : (3+index) / repeater.count
					
					height: item.height / 3 * ratio
					width: item.width / 3 * ratio
					opacity: ratio
					color: busyIndicator.color
					radius: (width > height ? width : height) / 2
					
					transform: [
						Translate {
							y: busyIndicator._size / 2
						},
						Rotation {
							angle: index / repeater.count * busyIndicator._rotation
							origin {
								x: width / 2
								y: height / 2
							}
						}
					]
				}
			}
		}
	}
}
