/***********************************************************************************

    Copyright (C) 2007-2011 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_PANEL_DIARY_HEADER
#define LIFEOGRAPH_PANEL_DIARY_HEADER


#include "diary.hpp"
#include "widget_entrylist.hpp"


namespace LIFEO
{

class PanelDiary
{
    public:
        static const int        MIN_WIDTH = 300; // pixels

                                PanelDiary();

        void                    update_entry_list();
        void                    update_entry_list_style();
        void                    update_calendar();

        void                    show( const DiaryElement* );
        void                    show_today();
        void                    present_current_row();
        void                    show_prev_session_elem();

        void                    handle_calendar_monthchanged();
        void                    handle_calendar_dayselected();
        void                    select_date_in_calendar( const Date& );

        void                    go_prev_match();
        void                    go_next_match();

        void                    handle_login();
        void                    handle_logout();

        void                    handle_entry_title_changed( DiaryElement* );

        Gtk::TreeRow            get_row( const Gtk::TreePath& );

        void                    handle_treeview_row_expanded( const Gtk::TreeIter&,
                                                              const Gtk::TreePath& );

        int                     get_entry_count() const
        { return m_entry_count; }

        void                    do_for_each_selected_entry( sigc::slot< void, Entry* >& slot )
        { m_TV_entries->do_for_each_selected_entry( slot ); }

        void                    revert_filter();
        void                    handle_filter_changed();
        void                    handle_search_string_changed(); // temporarily public

    protected:
        void                    handle_add_entry();
        void                    handle_add_group();
        void                    handle_add_topic();
        void                    handle_add_chapter();

        void                    replace_match();
        void                    replace_all_matches();

        void                    handle_disable_auto_logout_toggled();
        void                    update_disable_auto_logout_MI();

        WidgetEntryList*        m_TV_entries;

        Gtk::Button*            m_B_logout;
        Gtk::Calendar*          m_calendar;

        Gtk::RadioMenuItem*     m_MI_sort_by_date;
        Gtk::RadioMenuItem*     m_MI_sort_by_size;
        Gtk::RadioMenuItem*     m_MI_sort_by_change;

        Gtk::Grid*              m_G_elem_header;
        Gtk::Box*               m_Bx_new_elem;
        Gtk::MenuButton*        m_MB_logout;
        Gtk::Box*               m_Bx_logout;
        Gtk::MenuItem*          m_MI_logout_disable_auto;
        Gtk::MenuItem*          m_MI_logout_wo_saving;

        Gtk::MenuButton*        m_MB_add;
        Gtk::ImageMenuItem*     m_MI_add_entry;
        Gtk::ImageMenuItem*     m_MI_add_topic;
        Gtk::ImageMenuItem*     m_MI_add_group;
        Gtk::ImageMenuItem*     m_MI_add_chapter;
        Gtk::Separator*         m_sprt_tb1;

        Gtk::MenuButton*        m_B_tools;

        Gtk::Box*               m_Bx_search;
        Gtk::Popover*           m_Po_filter;
        Gtk::Button*            m_B_filter_revert;
        Gtk::SearchEntry*       m_E_search;
        EntryClear*             m_E_replace;
        Gtk::Button*            m_B_match_prev;
        Gtk::Button*            m_B_match_next;
        Gtk::Button*            m_B_replace;
        Gtk::Button*            m_B_replace_all;
        Gtk::Popover*           m_Po_replace;

        Glib::RefPtr< Gtk::Action > m_action_today;
        Glib::RefPtr< Gtk::Action > m_action_previous_list;
        Glib::RefPtr< Gtk::Action > m_action_next_list;
        Glib::RefPtr< Gtk::Action > m_action_jump2current;
        Glib::RefPtr< Gtk::Action > m_action_show_prev_session_elem;

        Glib::RefPtr< Gtk::Action > m_action_focusfilter;
        Glib::RefPtr< Gtk::Action > m_action_previous_match;
        Glib::RefPtr< Gtk::Action > m_action_next_match;

        // LISTING TMP VARIABLES
        void                    add_chapter_category_to_list( const CategoryChapters* );
        void                    fill_treepaths( const Gtk::TreeModel::Children& );
        Gtk::TreeRow            m_row_diary;
        int                     m_entry_count{ 0 };
        // following flag is set if a call to update_entry_list() also updates the calendar
        bool                    m_flag_calendar_updated{ false };

    friend class Lifeograph;
};

} // end of namespace LIFEO

#endif
