/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#ifndef LISTVIEWTOOLTIP_H
#define LISTVIEWTOOLTIP_H

#include <Qt3Support/Q3Header>
#include <Qt3Support/Q3ListView>
#include <QtGui/QListView>
#include <QtGui/QToolTip>

#include <klocale.h>

class ListViewToolTip : public QToolTip
{
public:
    ListViewToolTip(QListView* parent);

protected:
    void maybeTip(const QPoint& p);

private:
    Q3ListView* listView;
};

// inline ListViewToolTip::ListViewToolTip(QListView* parent) : QToolTip(parent->viewport()), listView(parent) {}
inline void ListViewToolTip::maybeTip(const QPoint& p)
{
    if (!listView)
        return;

    const Q3ListViewItem* item = listView->itemAt(p);
    if (!item)
        return;

    const QRect itemRect = listView->itemRect(item);
    if (!itemRect.isValid())
        return;

    const int col = listView->header()->sectionAt(p.x());
    const int row = listView->header()->sectionAt(p.y());
    if (col == -1 && row == -1)
        return;

    const QRect headerRect = listView->header()->sectionRect(col);
    if (!headerRect.isValid())
        return;

    // const QRect cellRect(headerRect.left(), itemRect.top(),
    //                      headerRect.width(), itemRect.height());
    const QRect cellRect(headerRect.left(), itemRect.top(), 400, 200);
    QString tipStr;
    tipStr = QString("<h2>" + item->text(0) + "</h2><ul><li>" + i18n("Path:") +
                     " " + item->text(5) + "</li><li>" + i18n("Usability:") +
                     " " + item->text(3) + "</li><li>" + i18n("Comment:") +
                     " " + item->text(6) + "</li></ul>");

    QToolTip::showText(p, tipStr, listView, cellRect);
}

#endif
