
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQXmlStreamReader.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QXmlStreamReader>
#include <QIODevice>
#include <QXmlStreamAttributes>
#include <QXmlStreamEntityDeclaration>
#include <QXmlStreamEntityResolver>
#include <QXmlStreamNamespaceDeclaration>
#include <QXmlStreamNotationDeclaration>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QXmlStreamReader

//  Constructor QXmlStreamReader::QXmlStreamReader()


static void _init_ctor_QXmlStreamReader_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QXmlStreamReader> ();
}

static void _call_ctor_QXmlStreamReader_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlStreamReader *> (new QXmlStreamReader ());
}


//  Constructor QXmlStreamReader::QXmlStreamReader(QIODevice *device)


static void _init_ctor_QXmlStreamReader_1447 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return_new<QXmlStreamReader> ();
}

static void _call_ctor_QXmlStreamReader_1447 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = gsi::arg_reader<QIODevice * >() (args, heap);
  ret.write<QXmlStreamReader *> (new QXmlStreamReader (arg1));
}


//  Constructor QXmlStreamReader::QXmlStreamReader(const QByteArray &data)


static void _init_ctor_QXmlStreamReader_2309 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return_new<QXmlStreamReader> ();
}

static void _call_ctor_QXmlStreamReader_2309 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = gsi::arg_reader<const QByteArray & >() (args, heap);
  ret.write<QXmlStreamReader *> (new QXmlStreamReader (arg1));
}


//  Constructor QXmlStreamReader::QXmlStreamReader(const QString &data)


static void _init_ctor_QXmlStreamReader_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return_new<QXmlStreamReader> ();
}

static void _call_ctor_QXmlStreamReader_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QXmlStreamReader *> (new QXmlStreamReader (arg1));
}


// void QXmlStreamReader::addData(const QByteArray &data)


static void _init_f_addData_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addData_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = gsi::arg_reader<const QByteArray & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlStreamReader *)cls)->addData (arg1);
}


// void QXmlStreamReader::addData(const QString &data)


static void _init_f_addData_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addData_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlStreamReader *)cls)->addData (arg1);
}


// void QXmlStreamReader::addExtraNamespaceDeclaration(const QXmlStreamNamespaceDeclaration &extraNamespaceDeclaraction)


static void _init_f_addExtraNamespaceDeclaration_4354 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("extraNamespaceDeclaraction");
  decl->add_arg<const QXmlStreamNamespaceDeclaration & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addExtraNamespaceDeclaration_4354 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QXmlStreamNamespaceDeclaration &arg1 = gsi::arg_reader<const QXmlStreamNamespaceDeclaration & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlStreamReader *)cls)->addExtraNamespaceDeclaration (arg1);
}


// void QXmlStreamReader::addExtraNamespaceDeclarations(const QList<QXmlStreamNamespaceDeclaration> &extraNamespaceDeclaractions)


static void _init_f_addExtraNamespaceDeclarations_4969 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("extraNamespaceDeclaractions");
  decl->add_arg<const QList<QXmlStreamNamespaceDeclaration> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addExtraNamespaceDeclarations_4969 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QXmlStreamNamespaceDeclaration> &arg1 = gsi::arg_reader<const QList<QXmlStreamNamespaceDeclaration> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlStreamReader *)cls)->addExtraNamespaceDeclarations (arg1);
}


// bool QXmlStreamReader::atEnd()


static void _init_f_atEnd_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_atEnd_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QXmlStreamReader *)cls)->atEnd ());
}


// QXmlStreamAttributes QXmlStreamReader::attributes()


static void _init_f_attributes_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlStreamAttributes > ();
}

static void _call_f_attributes_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlStreamAttributes > ((QXmlStreamAttributes)((QXmlStreamReader *)cls)->attributes ());
}


// qint64 QXmlStreamReader::characterOffset()


static void _init_f_characterOffset_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_characterOffset_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QXmlStreamReader *)cls)->characterOffset ());
}


// void QXmlStreamReader::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlStreamReader *)cls)->clear ();
}


// qint64 QXmlStreamReader::columnNumber()


static void _init_f_columnNumber_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_columnNumber_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QXmlStreamReader *)cls)->columnNumber ());
}


// QIODevice *QXmlStreamReader::device()


static void _init_f_device_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIODevice * > ();
}

static void _call_f_device_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QIODevice * > ((QIODevice *)((QXmlStreamReader *)cls)->device ());
}


// QList<QXmlStreamEntityDeclaration> QXmlStreamReader::entityDeclarations()


static void _init_f_entityDeclarations_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QXmlStreamEntityDeclaration> > ();
}

static void _call_f_entityDeclarations_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QXmlStreamEntityDeclaration> > ((QList<QXmlStreamEntityDeclaration>)((QXmlStreamReader *)cls)->entityDeclarations ());
}


// int QXmlStreamReader::entityExpansionLimit()


static void _init_f_entityExpansionLimit_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_entityExpansionLimit_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QXmlStreamReader *)cls)->entityExpansionLimit ());
}


// QXmlStreamEntityResolver *QXmlStreamReader::entityResolver()


static void _init_f_entityResolver_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlStreamEntityResolver * > ();
}

static void _call_f_entityResolver_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlStreamEntityResolver * > ((QXmlStreamEntityResolver *)((QXmlStreamReader *)cls)->entityResolver ());
}


// QXmlStreamReader::Error QXmlStreamReader::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QXmlStreamReader::Error>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QXmlStreamReader::Error>::target_type > ((qt_gsi::Converter<QXmlStreamReader::Error>::target_type)qt_gsi::CppToQtAdaptor<QXmlStreamReader::Error>(((QXmlStreamReader *)cls)->error ()));
}


// QString QXmlStreamReader::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QXmlStreamReader *)cls)->errorString ());
}


// bool QXmlStreamReader::hasError()


static void _init_f_hasError_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasError_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QXmlStreamReader *)cls)->hasError ());
}


// bool QXmlStreamReader::isCDATA()


static void _init_f_isCDATA_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isCDATA_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QXmlStreamReader *)cls)->isCDATA ());
}


// bool QXmlStreamReader::isCharacters()


static void _init_f_isCharacters_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isCharacters_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QXmlStreamReader *)cls)->isCharacters ());
}


// bool QXmlStreamReader::isComment()


static void _init_f_isComment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isComment_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QXmlStreamReader *)cls)->isComment ());
}


// bool QXmlStreamReader::isDTD()


static void _init_f_isDTD_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDTD_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QXmlStreamReader *)cls)->isDTD ());
}


// bool QXmlStreamReader::isEndDocument()


static void _init_f_isEndDocument_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEndDocument_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QXmlStreamReader *)cls)->isEndDocument ());
}


// bool QXmlStreamReader::isEndElement()


static void _init_f_isEndElement_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEndElement_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QXmlStreamReader *)cls)->isEndElement ());
}


// bool QXmlStreamReader::isEntityReference()


static void _init_f_isEntityReference_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEntityReference_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QXmlStreamReader *)cls)->isEntityReference ());
}


// bool QXmlStreamReader::isProcessingInstruction()


static void _init_f_isProcessingInstruction_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isProcessingInstruction_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QXmlStreamReader *)cls)->isProcessingInstruction ());
}


// bool QXmlStreamReader::isStandaloneDocument()


static void _init_f_isStandaloneDocument_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isStandaloneDocument_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QXmlStreamReader *)cls)->isStandaloneDocument ());
}


// bool QXmlStreamReader::isStartDocument()


static void _init_f_isStartDocument_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isStartDocument_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QXmlStreamReader *)cls)->isStartDocument ());
}


// bool QXmlStreamReader::isStartElement()


static void _init_f_isStartElement_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isStartElement_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QXmlStreamReader *)cls)->isStartElement ());
}


// bool QXmlStreamReader::isWhitespace()


static void _init_f_isWhitespace_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isWhitespace_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QXmlStreamReader *)cls)->isWhitespace ());
}


// qint64 QXmlStreamReader::lineNumber()


static void _init_f_lineNumber_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_lineNumber_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QXmlStreamReader *)cls)->lineNumber ());
}


// QList<QXmlStreamNamespaceDeclaration> QXmlStreamReader::namespaceDeclarations()


static void _init_f_namespaceDeclarations_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QXmlStreamNamespaceDeclaration> > ();
}

static void _call_f_namespaceDeclarations_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QXmlStreamNamespaceDeclaration> > ((QList<QXmlStreamNamespaceDeclaration>)((QXmlStreamReader *)cls)->namespaceDeclarations ());
}


// bool QXmlStreamReader::namespaceProcessing()


static void _init_f_namespaceProcessing_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_namespaceProcessing_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QXmlStreamReader *)cls)->namespaceProcessing ());
}


// QList<QXmlStreamNotationDeclaration> QXmlStreamReader::notationDeclarations()


static void _init_f_notationDeclarations_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QXmlStreamNotationDeclaration> > ();
}

static void _call_f_notationDeclarations_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QXmlStreamNotationDeclaration> > ((QList<QXmlStreamNotationDeclaration>)((QXmlStreamReader *)cls)->notationDeclarations ());
}


// void QXmlStreamReader::raiseError(const QString &message)


static void _init_f_raiseError_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("message", true, "QString()");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_raiseError_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlStreamReader *)cls)->raiseError (arg1);
}


// QString QXmlStreamReader::readElementText(QXmlStreamReader::ReadElementTextBehaviour behaviour)


static void _init_f_readElementText_4601 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("behaviour", true, "QXmlStreamReader::ErrorOnUnexpectedElement");
  decl->add_arg<const qt_gsi::Converter<QXmlStreamReader::ReadElementTextBehaviour>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_readElementText_4601 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QXmlStreamReader::ReadElementTextBehaviour>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<QXmlStreamReader::ReadElementTextBehaviour>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QXmlStreamReader::ReadElementTextBehaviour>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QXmlStreamReader::ReadElementTextBehaviour>(heap, QXmlStreamReader::ErrorOnUnexpectedElement), heap);
  ret.write<QString > ((QString)((QXmlStreamReader *)cls)->readElementText (qt_gsi::QtToCppAdaptor<QXmlStreamReader::ReadElementTextBehaviour>(arg1).cref()));
}


// QXmlStreamReader::TokenType QXmlStreamReader::readNext()


static void _init_f_readNext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QXmlStreamReader::TokenType>::target_type > ();
}

static void _call_f_readNext_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QXmlStreamReader::TokenType>::target_type > ((qt_gsi::Converter<QXmlStreamReader::TokenType>::target_type)qt_gsi::CppToQtAdaptor<QXmlStreamReader::TokenType>(((QXmlStreamReader *)cls)->readNext ()));
}


// bool QXmlStreamReader::readNextStartElement()


static void _init_f_readNextStartElement_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_readNextStartElement_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QXmlStreamReader *)cls)->readNextStartElement ());
}


// void QXmlStreamReader::setDevice(QIODevice *device)


static void _init_f_setDevice_1447 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDevice_1447 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = gsi::arg_reader<QIODevice * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlStreamReader *)cls)->setDevice (arg1);
}


// void QXmlStreamReader::setEntityExpansionLimit(int limit)


static void _init_f_setEntityExpansionLimit_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("limit");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEntityExpansionLimit_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlStreamReader *)cls)->setEntityExpansionLimit (arg1);
}


// void QXmlStreamReader::setEntityResolver(QXmlStreamEntityResolver *resolver)


static void _init_f_setEntityResolver_3115 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("resolver");
  decl->add_arg<QXmlStreamEntityResolver * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEntityResolver_3115 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlStreamEntityResolver *arg1 = gsi::arg_reader<QXmlStreamEntityResolver * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlStreamReader *)cls)->setEntityResolver (arg1);
}


// void QXmlStreamReader::setNamespaceProcessing(bool)


static void _init_f_setNamespaceProcessing_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNamespaceProcessing_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlStreamReader *)cls)->setNamespaceProcessing (arg1);
}


// void QXmlStreamReader::skipCurrentElement()


static void _init_f_skipCurrentElement_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_skipCurrentElement_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlStreamReader *)cls)->skipCurrentElement ();
}


// QString QXmlStreamReader::tokenString()


static void _init_f_tokenString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_tokenString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QXmlStreamReader *)cls)->tokenString ());
}


// QXmlStreamReader::TokenType QXmlStreamReader::tokenType()


static void _init_f_tokenType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QXmlStreamReader::TokenType>::target_type > ();
}

static void _call_f_tokenType_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QXmlStreamReader::TokenType>::target_type > ((qt_gsi::Converter<QXmlStreamReader::TokenType>::target_type)qt_gsi::CppToQtAdaptor<QXmlStreamReader::TokenType>(((QXmlStreamReader *)cls)->tokenType ()));
}



namespace gsi
{

static gsi::Methods methods_QXmlStreamReader () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QXmlStreamReader::QXmlStreamReader()\nThis method creates an object of class QXmlStreamReader.", &_init_ctor_QXmlStreamReader_0, &_call_ctor_QXmlStreamReader_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QXmlStreamReader::QXmlStreamReader(QIODevice *device)\nThis method creates an object of class QXmlStreamReader.", &_init_ctor_QXmlStreamReader_1447, &_call_ctor_QXmlStreamReader_1447);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QXmlStreamReader::QXmlStreamReader(const QByteArray &data)\nThis method creates an object of class QXmlStreamReader.", &_init_ctor_QXmlStreamReader_2309, &_call_ctor_QXmlStreamReader_2309);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QXmlStreamReader::QXmlStreamReader(const QString &data)\nThis method creates an object of class QXmlStreamReader.", &_init_ctor_QXmlStreamReader_2025, &_call_ctor_QXmlStreamReader_2025);
  methods += new qt_gsi::GenericMethod ("addData", "@brief Method void QXmlStreamReader::addData(const QByteArray &data)\n", false, &_init_f_addData_2309, &_call_f_addData_2309);
  methods += new qt_gsi::GenericMethod ("addData", "@brief Method void QXmlStreamReader::addData(const QString &data)\n", false, &_init_f_addData_2025, &_call_f_addData_2025);
  methods += new qt_gsi::GenericMethod ("addExtraNamespaceDeclaration", "@brief Method void QXmlStreamReader::addExtraNamespaceDeclaration(const QXmlStreamNamespaceDeclaration &extraNamespaceDeclaraction)\n", false, &_init_f_addExtraNamespaceDeclaration_4354, &_call_f_addExtraNamespaceDeclaration_4354);
  methods += new qt_gsi::GenericMethod ("addExtraNamespaceDeclarations", "@brief Method void QXmlStreamReader::addExtraNamespaceDeclarations(const QList<QXmlStreamNamespaceDeclaration> &extraNamespaceDeclaractions)\n", false, &_init_f_addExtraNamespaceDeclarations_4969, &_call_f_addExtraNamespaceDeclarations_4969);
  methods += new qt_gsi::GenericMethod ("atEnd", "@brief Method bool QXmlStreamReader::atEnd()\n", true, &_init_f_atEnd_c0, &_call_f_atEnd_c0);
  methods += new qt_gsi::GenericMethod ("attributes", "@brief Method QXmlStreamAttributes QXmlStreamReader::attributes()\n", true, &_init_f_attributes_c0, &_call_f_attributes_c0);
  methods += new qt_gsi::GenericMethod ("characterOffset", "@brief Method qint64 QXmlStreamReader::characterOffset()\n", true, &_init_f_characterOffset_c0, &_call_f_characterOffset_c0);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Method void QXmlStreamReader::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
  methods += new qt_gsi::GenericMethod ("columnNumber", "@brief Method qint64 QXmlStreamReader::columnNumber()\n", true, &_init_f_columnNumber_c0, &_call_f_columnNumber_c0);
  methods += new qt_gsi::GenericMethod (":device", "@brief Method QIODevice *QXmlStreamReader::device()\n", true, &_init_f_device_c0, &_call_f_device_c0);
  methods += new qt_gsi::GenericMethod ("entityDeclarations", "@brief Method QList<QXmlStreamEntityDeclaration> QXmlStreamReader::entityDeclarations()\n", true, &_init_f_entityDeclarations_c0, &_call_f_entityDeclarations_c0);
  methods += new qt_gsi::GenericMethod (":entityExpansionLimit", "@brief Method int QXmlStreamReader::entityExpansionLimit()\n", true, &_init_f_entityExpansionLimit_c0, &_call_f_entityExpansionLimit_c0);
  methods += new qt_gsi::GenericMethod (":entityResolver", "@brief Method QXmlStreamEntityResolver *QXmlStreamReader::entityResolver()\n", true, &_init_f_entityResolver_c0, &_call_f_entityResolver_c0);
  methods += new qt_gsi::GenericMethod ("error", "@brief Method QXmlStreamReader::Error QXmlStreamReader::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Method QString QXmlStreamReader::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod ("hasError", "@brief Method bool QXmlStreamReader::hasError()\n", true, &_init_f_hasError_c0, &_call_f_hasError_c0);
  methods += new qt_gsi::GenericMethod ("isCDATA?", "@brief Method bool QXmlStreamReader::isCDATA()\n", true, &_init_f_isCDATA_c0, &_call_f_isCDATA_c0);
  methods += new qt_gsi::GenericMethod ("isCharacters?", "@brief Method bool QXmlStreamReader::isCharacters()\n", true, &_init_f_isCharacters_c0, &_call_f_isCharacters_c0);
  methods += new qt_gsi::GenericMethod ("isComment?", "@brief Method bool QXmlStreamReader::isComment()\n", true, &_init_f_isComment_c0, &_call_f_isComment_c0);
  methods += new qt_gsi::GenericMethod ("isDTD?", "@brief Method bool QXmlStreamReader::isDTD()\n", true, &_init_f_isDTD_c0, &_call_f_isDTD_c0);
  methods += new qt_gsi::GenericMethod ("isEndDocument?", "@brief Method bool QXmlStreamReader::isEndDocument()\n", true, &_init_f_isEndDocument_c0, &_call_f_isEndDocument_c0);
  methods += new qt_gsi::GenericMethod ("isEndElement?", "@brief Method bool QXmlStreamReader::isEndElement()\n", true, &_init_f_isEndElement_c0, &_call_f_isEndElement_c0);
  methods += new qt_gsi::GenericMethod ("isEntityReference?", "@brief Method bool QXmlStreamReader::isEntityReference()\n", true, &_init_f_isEntityReference_c0, &_call_f_isEntityReference_c0);
  methods += new qt_gsi::GenericMethod ("isProcessingInstruction?", "@brief Method bool QXmlStreamReader::isProcessingInstruction()\n", true, &_init_f_isProcessingInstruction_c0, &_call_f_isProcessingInstruction_c0);
  methods += new qt_gsi::GenericMethod ("isStandaloneDocument?", "@brief Method bool QXmlStreamReader::isStandaloneDocument()\n", true, &_init_f_isStandaloneDocument_c0, &_call_f_isStandaloneDocument_c0);
  methods += new qt_gsi::GenericMethod ("isStartDocument?", "@brief Method bool QXmlStreamReader::isStartDocument()\n", true, &_init_f_isStartDocument_c0, &_call_f_isStartDocument_c0);
  methods += new qt_gsi::GenericMethod ("isStartElement?", "@brief Method bool QXmlStreamReader::isStartElement()\n", true, &_init_f_isStartElement_c0, &_call_f_isStartElement_c0);
  methods += new qt_gsi::GenericMethod ("isWhitespace?", "@brief Method bool QXmlStreamReader::isWhitespace()\n", true, &_init_f_isWhitespace_c0, &_call_f_isWhitespace_c0);
  methods += new qt_gsi::GenericMethod ("lineNumber", "@brief Method qint64 QXmlStreamReader::lineNumber()\n", true, &_init_f_lineNumber_c0, &_call_f_lineNumber_c0);
  methods += new qt_gsi::GenericMethod ("namespaceDeclarations", "@brief Method QList<QXmlStreamNamespaceDeclaration> QXmlStreamReader::namespaceDeclarations()\n", true, &_init_f_namespaceDeclarations_c0, &_call_f_namespaceDeclarations_c0);
  methods += new qt_gsi::GenericMethod (":namespaceProcessing", "@brief Method bool QXmlStreamReader::namespaceProcessing()\n", true, &_init_f_namespaceProcessing_c0, &_call_f_namespaceProcessing_c0);
  methods += new qt_gsi::GenericMethod ("notationDeclarations", "@brief Method QList<QXmlStreamNotationDeclaration> QXmlStreamReader::notationDeclarations()\n", true, &_init_f_notationDeclarations_c0, &_call_f_notationDeclarations_c0);
  methods += new qt_gsi::GenericMethod ("raiseError", "@brief Method void QXmlStreamReader::raiseError(const QString &message)\n", false, &_init_f_raiseError_2025, &_call_f_raiseError_2025);
  methods += new qt_gsi::GenericMethod ("readElementText", "@brief Method QString QXmlStreamReader::readElementText(QXmlStreamReader::ReadElementTextBehaviour behaviour)\n", false, &_init_f_readElementText_4601, &_call_f_readElementText_4601);
  methods += new qt_gsi::GenericMethod ("readNext", "@brief Method QXmlStreamReader::TokenType QXmlStreamReader::readNext()\n", false, &_init_f_readNext_0, &_call_f_readNext_0);
  methods += new qt_gsi::GenericMethod ("readNextStartElement", "@brief Method bool QXmlStreamReader::readNextStartElement()\n", false, &_init_f_readNextStartElement_0, &_call_f_readNextStartElement_0);
  methods += new qt_gsi::GenericMethod ("setDevice|device=", "@brief Method void QXmlStreamReader::setDevice(QIODevice *device)\n", false, &_init_f_setDevice_1447, &_call_f_setDevice_1447);
  methods += new qt_gsi::GenericMethod ("setEntityExpansionLimit|entityExpansionLimit=", "@brief Method void QXmlStreamReader::setEntityExpansionLimit(int limit)\n", false, &_init_f_setEntityExpansionLimit_767, &_call_f_setEntityExpansionLimit_767);
  methods += new qt_gsi::GenericMethod ("setEntityResolver|entityResolver=", "@brief Method void QXmlStreamReader::setEntityResolver(QXmlStreamEntityResolver *resolver)\n", false, &_init_f_setEntityResolver_3115, &_call_f_setEntityResolver_3115);
  methods += new qt_gsi::GenericMethod ("setNamespaceProcessing|namespaceProcessing=", "@brief Method void QXmlStreamReader::setNamespaceProcessing(bool)\n", false, &_init_f_setNamespaceProcessing_864, &_call_f_setNamespaceProcessing_864);
  methods += new qt_gsi::GenericMethod ("skipCurrentElement", "@brief Method void QXmlStreamReader::skipCurrentElement()\n", false, &_init_f_skipCurrentElement_0, &_call_f_skipCurrentElement_0);
  methods += new qt_gsi::GenericMethod ("tokenString", "@brief Method QString QXmlStreamReader::tokenString()\n", true, &_init_f_tokenString_c0, &_call_f_tokenString_c0);
  methods += new qt_gsi::GenericMethod ("tokenType", "@brief Method QXmlStreamReader::TokenType QXmlStreamReader::tokenType()\n", true, &_init_f_tokenType_c0, &_call_f_tokenType_c0);
  return methods;
}

gsi::Class<QXmlStreamReader> decl_QXmlStreamReader ("QtCore", "QXmlStreamReader",
  methods_QXmlStreamReader (),
  "@qt\n@brief Binding of QXmlStreamReader");


GSI_QTCORE_PUBLIC gsi::Class<QXmlStreamReader> &qtdecl_QXmlStreamReader () { return decl_QXmlStreamReader; }

}


//  Implementation of the enum wrapper class for QXmlStreamReader::Error
namespace qt_gsi
{

static gsi::Enum<QXmlStreamReader::Error> decl_QXmlStreamReader_Error_Enum ("QtCore", "QXmlStreamReader_Error",
    gsi::enum_const ("NoError", QXmlStreamReader::NoError, "@brief Enum constant QXmlStreamReader::NoError") +
    gsi::enum_const ("UnexpectedElementError", QXmlStreamReader::UnexpectedElementError, "@brief Enum constant QXmlStreamReader::UnexpectedElementError") +
    gsi::enum_const ("CustomError", QXmlStreamReader::CustomError, "@brief Enum constant QXmlStreamReader::CustomError") +
    gsi::enum_const ("NotWellFormedError", QXmlStreamReader::NotWellFormedError, "@brief Enum constant QXmlStreamReader::NotWellFormedError") +
    gsi::enum_const ("PrematureEndOfDocumentError", QXmlStreamReader::PrematureEndOfDocumentError, "@brief Enum constant QXmlStreamReader::PrematureEndOfDocumentError"),
  "@qt\n@brief This class represents the QXmlStreamReader::Error enum");

static gsi::QFlagsClass<QXmlStreamReader::Error > decl_QXmlStreamReader_Error_Enums ("QtCore", "QXmlStreamReader_QFlags_Error",
  "@qt\n@brief This class represents the QFlags<QXmlStreamReader::Error> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QXmlStreamReader> inject_QXmlStreamReader_Error_Enum_in_parent (decl_QXmlStreamReader_Error_Enum.defs ());
static gsi::ClassExt<QXmlStreamReader> decl_QXmlStreamReader_Error_Enum_as_child (decl_QXmlStreamReader_Error_Enum, "Error");
static gsi::ClassExt<QXmlStreamReader> decl_QXmlStreamReader_Error_Enums_as_child (decl_QXmlStreamReader_Error_Enums, "QFlags_Error");

}


//  Implementation of the enum wrapper class for QXmlStreamReader::ReadElementTextBehaviour
namespace qt_gsi
{

static gsi::Enum<QXmlStreamReader::ReadElementTextBehaviour> decl_QXmlStreamReader_ReadElementTextBehaviour_Enum ("QtCore", "QXmlStreamReader_ReadElementTextBehaviour",
    gsi::enum_const ("ErrorOnUnexpectedElement", QXmlStreamReader::ErrorOnUnexpectedElement, "@brief Enum constant QXmlStreamReader::ErrorOnUnexpectedElement") +
    gsi::enum_const ("IncludeChildElements", QXmlStreamReader::IncludeChildElements, "@brief Enum constant QXmlStreamReader::IncludeChildElements") +
    gsi::enum_const ("SkipChildElements", QXmlStreamReader::SkipChildElements, "@brief Enum constant QXmlStreamReader::SkipChildElements"),
  "@qt\n@brief This class represents the QXmlStreamReader::ReadElementTextBehaviour enum");

static gsi::QFlagsClass<QXmlStreamReader::ReadElementTextBehaviour > decl_QXmlStreamReader_ReadElementTextBehaviour_Enums ("QtCore", "QXmlStreamReader_QFlags_ReadElementTextBehaviour",
  "@qt\n@brief This class represents the QFlags<QXmlStreamReader::ReadElementTextBehaviour> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QXmlStreamReader> inject_QXmlStreamReader_ReadElementTextBehaviour_Enum_in_parent (decl_QXmlStreamReader_ReadElementTextBehaviour_Enum.defs ());
static gsi::ClassExt<QXmlStreamReader> decl_QXmlStreamReader_ReadElementTextBehaviour_Enum_as_child (decl_QXmlStreamReader_ReadElementTextBehaviour_Enum, "ReadElementTextBehaviour");
static gsi::ClassExt<QXmlStreamReader> decl_QXmlStreamReader_ReadElementTextBehaviour_Enums_as_child (decl_QXmlStreamReader_ReadElementTextBehaviour_Enums, "QFlags_ReadElementTextBehaviour");

}


//  Implementation of the enum wrapper class for QXmlStreamReader::TokenType
namespace qt_gsi
{

static gsi::Enum<QXmlStreamReader::TokenType> decl_QXmlStreamReader_TokenType_Enum ("QtCore", "QXmlStreamReader_TokenType",
    gsi::enum_const ("NoToken", QXmlStreamReader::NoToken, "@brief Enum constant QXmlStreamReader::NoToken") +
    gsi::enum_const ("Invalid", QXmlStreamReader::Invalid, "@brief Enum constant QXmlStreamReader::Invalid") +
    gsi::enum_const ("StartDocument", QXmlStreamReader::StartDocument, "@brief Enum constant QXmlStreamReader::StartDocument") +
    gsi::enum_const ("EndDocument", QXmlStreamReader::EndDocument, "@brief Enum constant QXmlStreamReader::EndDocument") +
    gsi::enum_const ("StartElement", QXmlStreamReader::StartElement, "@brief Enum constant QXmlStreamReader::StartElement") +
    gsi::enum_const ("EndElement", QXmlStreamReader::EndElement, "@brief Enum constant QXmlStreamReader::EndElement") +
    gsi::enum_const ("Characters", QXmlStreamReader::Characters, "@brief Enum constant QXmlStreamReader::Characters") +
    gsi::enum_const ("Comment", QXmlStreamReader::Comment, "@brief Enum constant QXmlStreamReader::Comment") +
    gsi::enum_const ("DTD", QXmlStreamReader::DTD, "@brief Enum constant QXmlStreamReader::DTD") +
    gsi::enum_const ("EntityReference", QXmlStreamReader::EntityReference, "@brief Enum constant QXmlStreamReader::EntityReference") +
    gsi::enum_const ("ProcessingInstruction", QXmlStreamReader::ProcessingInstruction, "@brief Enum constant QXmlStreamReader::ProcessingInstruction"),
  "@qt\n@brief This class represents the QXmlStreamReader::TokenType enum");

static gsi::QFlagsClass<QXmlStreamReader::TokenType > decl_QXmlStreamReader_TokenType_Enums ("QtCore", "QXmlStreamReader_QFlags_TokenType",
  "@qt\n@brief This class represents the QFlags<QXmlStreamReader::TokenType> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QXmlStreamReader> inject_QXmlStreamReader_TokenType_Enum_in_parent (decl_QXmlStreamReader_TokenType_Enum.defs ());
static gsi::ClassExt<QXmlStreamReader> decl_QXmlStreamReader_TokenType_Enum_as_child (decl_QXmlStreamReader_TokenType_Enum, "TokenType");
static gsi::ClassExt<QXmlStreamReader> decl_QXmlStreamReader_TokenType_Enums_as_child (decl_QXmlStreamReader_TokenType_Enums, "QFlags_TokenType");

}

