
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPropertyAnimation.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QPropertyAnimation>
#include <QAnimationGroup>
#include <QChildEvent>
#include <QEasingCurve>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPropertyAnimation

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QPropertyAnimation::staticMetaObject);
}


// QByteArray QPropertyAnimation::propertyName()


static void _init_f_propertyName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_propertyName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QByteArray > ((QByteArray)((QPropertyAnimation *)cls)->propertyName ());
}


// void QPropertyAnimation::setPropertyName(const QByteArray &propertyName)


static void _init_f_setPropertyName_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("propertyName");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPropertyName_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = gsi::arg_reader<const QByteArray & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPropertyAnimation *)cls)->setPropertyName (arg1);
}


// void QPropertyAnimation::setTargetObject(QObject *target)


static void _init_f_setTargetObject_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("target");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTargetObject_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPropertyAnimation *)cls)->setTargetObject (arg1);
}


// QObject *QPropertyAnimation::targetObject()


static void _init_f_targetObject_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_f_targetObject_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QPropertyAnimation *)cls)->targetObject ());
}


// static QString QPropertyAnimation::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QPropertyAnimation::tr (arg1, arg2, arg3));
}


// static QString QPropertyAnimation::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QPropertyAnimation::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QPropertyAnimation () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":propertyName", "@brief Method QByteArray QPropertyAnimation::propertyName()\n", true, &_init_f_propertyName_c0, &_call_f_propertyName_c0);
  methods += new qt_gsi::GenericMethod ("setPropertyName|propertyName=", "@brief Method void QPropertyAnimation::setPropertyName(const QByteArray &propertyName)\n", false, &_init_f_setPropertyName_2309, &_call_f_setPropertyName_2309);
  methods += new qt_gsi::GenericMethod ("setTargetObject|targetObject=", "@brief Method void QPropertyAnimation::setTargetObject(QObject *target)\n", false, &_init_f_setTargetObject_1302, &_call_f_setTargetObject_1302);
  methods += new qt_gsi::GenericMethod (":targetObject", "@brief Method QObject *QPropertyAnimation::targetObject()\n", true, &_init_f_targetObject_c0, &_call_f_targetObject_c0);
  methods += gsi::qt_signal<int > ("currentLoopChanged(int)", "currentLoopChanged", gsi::arg("currentLoop"), "@brief Signal declaration for QPropertyAnimation::currentLoopChanged(int currentLoop)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QPropertyAnimation::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & > ("directionChanged(QAbstractAnimation::Direction)", "directionChanged", gsi::arg("arg1"), "@brief Signal declaration for QPropertyAnimation::directionChanged(QAbstractAnimation::Direction)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("finished()", "finished", "@brief Signal declaration for QPropertyAnimation::finished()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QPropertyAnimation::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QAbstractAnimation::State>::target_type &, const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > ("stateChanged(QAbstractAnimation::State, QAbstractAnimation::State)", "stateChanged", gsi::arg("newState"), gsi::arg("oldState"), "@brief Signal declaration for QPropertyAnimation::stateChanged(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QVariant & > ("valueChanged(const QVariant &)", "valueChanged", gsi::arg("value"), "@brief Signal declaration for QPropertyAnimation::valueChanged(const QVariant &value)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QPropertyAnimation::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QPropertyAnimation::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QVariantAnimation> &qtdecl_QVariantAnimation ();

qt_gsi::QtNativeClass<QPropertyAnimation> decl_QPropertyAnimation (qtdecl_QVariantAnimation (), "QtCore", "QPropertyAnimation_Native",
  methods_QPropertyAnimation (),
  "@hide\n@alias QPropertyAnimation");

GSI_QTCORE_PUBLIC gsi::Class<QPropertyAnimation> &qtdecl_QPropertyAnimation () { return decl_QPropertyAnimation; }

}


class QPropertyAnimation_Adaptor : public QPropertyAnimation, public qt_gsi::QtObjectBase
{
public:

  virtual ~QPropertyAnimation_Adaptor();

  //  [adaptor ctor] QPropertyAnimation::QPropertyAnimation(QObject *parent)
  QPropertyAnimation_Adaptor() : QPropertyAnimation()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPropertyAnimation::QPropertyAnimation(QObject *parent)
  QPropertyAnimation_Adaptor(QObject *parent) : QPropertyAnimation(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPropertyAnimation::QPropertyAnimation(QObject *target, const QByteArray &propertyName, QObject *parent)
  QPropertyAnimation_Adaptor(QObject *target, const QByteArray &propertyName) : QPropertyAnimation(target, propertyName)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPropertyAnimation::QPropertyAnimation(QObject *target, const QByteArray &propertyName, QObject *parent)
  QPropertyAnimation_Adaptor(QObject *target, const QByteArray &propertyName, QObject *parent) : QPropertyAnimation(target, propertyName, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QPropertyAnimation::isSignalConnected(const QMetaMethod &signal)
  bool fp_QPropertyAnimation_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QPropertyAnimation::isSignalConnected(signal);
  }

  //  [expose] int QPropertyAnimation::receivers(const char *signal)
  int fp_QPropertyAnimation_receivers_c1731 (const char *signal) const {
    return QPropertyAnimation::receivers(signal);
  }

  //  [expose] QObject *QPropertyAnimation::sender()
  QObject * fp_QPropertyAnimation_sender_c0 () const {
    return QPropertyAnimation::sender();
  }

  //  [expose] int QPropertyAnimation::senderSignalIndex()
  int fp_QPropertyAnimation_senderSignalIndex_c0 () const {
    return QPropertyAnimation::senderSignalIndex();
  }

  //  [emitter impl] void QPropertyAnimation::currentLoopChanged(int currentLoop)
  void emitter_QPropertyAnimation_currentLoopChanged_767(int currentLoop)
  {
    emit QPropertyAnimation::currentLoopChanged(currentLoop);
  }

  //  [emitter impl] void QPropertyAnimation::destroyed(QObject *)
  void emitter_QPropertyAnimation_destroyed_1302(QObject *arg1)
  {
    emit QPropertyAnimation::destroyed(arg1);
  }

  //  [emitter impl] void QPropertyAnimation::directionChanged(QAbstractAnimation::Direction)
  void emitter_QPropertyAnimation_directionChanged_3310(QAbstractAnimation::Direction arg1)
  {
    emit QPropertyAnimation::directionChanged(arg1);
  }

  //  [adaptor impl] int QPropertyAnimation::duration()
  int cbs_duration_c0_0() const
  {
    return QPropertyAnimation::duration();
  }

  virtual int duration() const
  {
    if (cb_duration_c0_0.can_issue()) {
      return cb_duration_c0_0.issue<QPropertyAnimation_Adaptor, int>(&QPropertyAnimation_Adaptor::cbs_duration_c0_0);
    } else {
      return QPropertyAnimation::duration();
    }
  }

  //  [adaptor impl] bool QPropertyAnimation::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QPropertyAnimation::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QPropertyAnimation_Adaptor, bool, QObject *, QEvent *>(&QPropertyAnimation_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QPropertyAnimation::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QPropertyAnimation::finished()
  void emitter_QPropertyAnimation_finished_0()
  {
    emit QPropertyAnimation::finished();
  }

  //  [emitter impl] void QPropertyAnimation::objectNameChanged(const QString &objectName)
  void emitter_QPropertyAnimation_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QPropertyAnimation::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QPropertyAnimation::stateChanged(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)
  void emitter_QPropertyAnimation_stateChanged_5680(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)
  {
    emit QPropertyAnimation::stateChanged(newState, oldState);
  }

  //  [emitter impl] void QPropertyAnimation::valueChanged(const QVariant &value)
  void emitter_QPropertyAnimation_valueChanged_2119(const QVariant &value)
  {
    emit QPropertyAnimation::valueChanged(value);
  }

  //  [adaptor impl] void QPropertyAnimation::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QPropertyAnimation::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QPropertyAnimation_Adaptor, QChildEvent *>(&QPropertyAnimation_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QPropertyAnimation::childEvent(event);
    }
  }

  //  [adaptor impl] void QPropertyAnimation::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QPropertyAnimation::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QPropertyAnimation_Adaptor, QEvent *>(&QPropertyAnimation_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QPropertyAnimation::customEvent(event);
    }
  }

  //  [adaptor impl] void QPropertyAnimation::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QPropertyAnimation::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QPropertyAnimation_Adaptor, const QMetaMethod &>(&QPropertyAnimation_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QPropertyAnimation::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QPropertyAnimation::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QPropertyAnimation::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QPropertyAnimation_Adaptor, bool, QEvent *>(&QPropertyAnimation_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QPropertyAnimation::event(_event);
    }
  }

  //  [adaptor impl] QVariant QPropertyAnimation::interpolated(const QVariant &from, const QVariant &to, double progress)
  QVariant cbs_interpolated_c5093_0(const QVariant &from, const QVariant &to, double progress) const
  {
    return QPropertyAnimation::interpolated(from, to, progress);
  }

  virtual QVariant interpolated(const QVariant &from, const QVariant &to, double progress) const
  {
    if (cb_interpolated_c5093_0.can_issue()) {
      return cb_interpolated_c5093_0.issue<QPropertyAnimation_Adaptor, QVariant, const QVariant &, const QVariant &, double>(&QPropertyAnimation_Adaptor::cbs_interpolated_c5093_0, from, to, progress);
    } else {
      return QPropertyAnimation::interpolated(from, to, progress);
    }
  }

  //  [adaptor impl] void QPropertyAnimation::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QPropertyAnimation::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QPropertyAnimation_Adaptor, QTimerEvent *>(&QPropertyAnimation_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QPropertyAnimation::timerEvent(event);
    }
  }

  //  [adaptor impl] void QPropertyAnimation::updateCurrentTime(int)
  void cbs_updateCurrentTime_767_0(int arg1)
  {
    QPropertyAnimation::updateCurrentTime(arg1);
  }

  virtual void updateCurrentTime(int arg1)
  {
    if (cb_updateCurrentTime_767_0.can_issue()) {
      cb_updateCurrentTime_767_0.issue<QPropertyAnimation_Adaptor, int>(&QPropertyAnimation_Adaptor::cbs_updateCurrentTime_767_0, arg1);
    } else {
      QPropertyAnimation::updateCurrentTime(arg1);
    }
  }

  //  [adaptor impl] void QPropertyAnimation::updateCurrentValue(const QVariant &value)
  void cbs_updateCurrentValue_2119_0(const QVariant &value)
  {
    QPropertyAnimation::updateCurrentValue(value);
  }

  virtual void updateCurrentValue(const QVariant &value)
  {
    if (cb_updateCurrentValue_2119_0.can_issue()) {
      cb_updateCurrentValue_2119_0.issue<QPropertyAnimation_Adaptor, const QVariant &>(&QPropertyAnimation_Adaptor::cbs_updateCurrentValue_2119_0, value);
    } else {
      QPropertyAnimation::updateCurrentValue(value);
    }
  }

  //  [adaptor impl] void QPropertyAnimation::updateDirection(QAbstractAnimation::Direction direction)
  void cbs_updateDirection_3310_0(const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & direction)
  {
    QPropertyAnimation::updateDirection(qt_gsi::QtToCppAdaptor<QAbstractAnimation::Direction>(direction).cref());
  }

  virtual void updateDirection(QAbstractAnimation::Direction direction)
  {
    if (cb_updateDirection_3310_0.can_issue()) {
      cb_updateDirection_3310_0.issue<QPropertyAnimation_Adaptor, const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type &>(&QPropertyAnimation_Adaptor::cbs_updateDirection_3310_0, qt_gsi::CppToQtAdaptor<QAbstractAnimation::Direction>(direction));
    } else {
      QPropertyAnimation::updateDirection(direction);
    }
  }

  //  [adaptor impl] void QPropertyAnimation::updateState(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)
  void cbs_updateState_5680_0(const qt_gsi::Converter<QAbstractAnimation::State>::target_type & newState, const qt_gsi::Converter<QAbstractAnimation::State>::target_type & oldState)
  {
    QPropertyAnimation::updateState(qt_gsi::QtToCppAdaptor<QAbstractAnimation::State>(newState).cref(), qt_gsi::QtToCppAdaptor<QAbstractAnimation::State>(oldState).cref());
  }

  virtual void updateState(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)
  {
    if (cb_updateState_5680_0.can_issue()) {
      cb_updateState_5680_0.issue<QPropertyAnimation_Adaptor, const qt_gsi::Converter<QAbstractAnimation::State>::target_type &, const qt_gsi::Converter<QAbstractAnimation::State>::target_type &>(&QPropertyAnimation_Adaptor::cbs_updateState_5680_0, qt_gsi::CppToQtAdaptor<QAbstractAnimation::State>(newState), qt_gsi::CppToQtAdaptor<QAbstractAnimation::State>(oldState));
    } else {
      QPropertyAnimation::updateState(newState, oldState);
    }
  }

  gsi::Callback cb_duration_c0_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_interpolated_c5093_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_updateCurrentTime_767_0;
  gsi::Callback cb_updateCurrentValue_2119_0;
  gsi::Callback cb_updateDirection_3310_0;
  gsi::Callback cb_updateState_5680_0;
};

QPropertyAnimation_Adaptor::~QPropertyAnimation_Adaptor() { }

//  Constructor QPropertyAnimation::QPropertyAnimation(QObject *parent) (adaptor class)

static void _init_ctor_QPropertyAnimation_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QPropertyAnimation_Adaptor> ();
}

static void _call_ctor_QPropertyAnimation_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QPropertyAnimation_Adaptor *> (new QPropertyAnimation_Adaptor (arg1));
}


//  Constructor QPropertyAnimation::QPropertyAnimation(QObject *target, const QByteArray &propertyName, QObject *parent) (adaptor class)

static void _init_ctor_QPropertyAnimation_Adaptor_4697 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("target");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("propertyName");
  decl->add_arg<const QByteArray & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_2);
  decl->set_return_new<QPropertyAnimation_Adaptor> ();
}

static void _call_ctor_QPropertyAnimation_Adaptor_4697 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  const QByteArray &arg2 = gsi::arg_reader<const QByteArray & >() (args, heap);
  QObject *arg3 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QPropertyAnimation_Adaptor *> (new QPropertyAnimation_Adaptor (arg1, arg2, arg3));
}


// void QPropertyAnimation::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPropertyAnimation_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QPropertyAnimation_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QPropertyAnimation::currentLoopChanged(int currentLoop)

static void _init_emitter_currentLoopChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("currentLoop");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_currentLoopChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QPropertyAnimation_Adaptor *)cls)->emitter_QPropertyAnimation_currentLoopChanged_767 (arg1);
}


// void QPropertyAnimation::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPropertyAnimation_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPropertyAnimation_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QPropertyAnimation::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QPropertyAnimation_Adaptor *)cls)->emitter_QPropertyAnimation_destroyed_1302 (arg1);
}


// emitter void QPropertyAnimation::directionChanged(QAbstractAnimation::Direction)

static void _init_emitter_directionChanged_3310 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_directionChanged_3310 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & >() (args, heap);
  ((QPropertyAnimation_Adaptor *)cls)->emitter_QPropertyAnimation_directionChanged_3310 (arg1);
}


// void QPropertyAnimation::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPropertyAnimation_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QPropertyAnimation_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// int QPropertyAnimation::duration()

static void _init_cbs_duration_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_duration_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPropertyAnimation_Adaptor *)cls)->cbs_duration_c0_0 ());
}

static void _set_callback_cbs_duration_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPropertyAnimation_Adaptor *)cls)->cb_duration_c0_0 = cb;
}


// bool QPropertyAnimation::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QPropertyAnimation_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPropertyAnimation_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QPropertyAnimation::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QPropertyAnimation_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QPropertyAnimation_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QPropertyAnimation::finished()

static void _init_emitter_finished_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_finished_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QPropertyAnimation_Adaptor *)cls)->emitter_QPropertyAnimation_finished_0 ();
}


// QVariant QPropertyAnimation::interpolated(const QVariant &from, const QVariant &to, double progress)

static void _init_cbs_interpolated_c5093_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const QVariant & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("progress");
  decl->add_arg<double > (argspec_2);
  decl->set_return<QVariant > ();
}

static void _call_cbs_interpolated_c5093_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVariant &arg1 = args.read<const QVariant & > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  double arg3 = args.read<double > (heap);
  ret.write<QVariant > ((QVariant)((QPropertyAnimation_Adaptor *)cls)->cbs_interpolated_c5093_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_interpolated_c5093_0 (void *cls, const gsi::Callback &cb)
{
  ((QPropertyAnimation_Adaptor *)cls)->cb_interpolated_c5093_0 = cb;
}


// exposed bool QPropertyAnimation::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QPropertyAnimation_Adaptor *)cls)->fp_QPropertyAnimation_isSignalConnected_c2394 (arg1));
}


// emitter void QPropertyAnimation::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QPropertyAnimation_Adaptor *)cls)->emitter_QPropertyAnimation_objectNameChanged_4567 (arg1);
}


// exposed int QPropertyAnimation::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QPropertyAnimation_Adaptor *)cls)->fp_QPropertyAnimation_receivers_c1731 (arg1));
}


// exposed QObject *QPropertyAnimation::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QPropertyAnimation_Adaptor *)cls)->fp_QPropertyAnimation_sender_c0 ());
}


// exposed int QPropertyAnimation::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPropertyAnimation_Adaptor *)cls)->fp_QPropertyAnimation_senderSignalIndex_c0 ());
}


// emitter void QPropertyAnimation::stateChanged(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)

static void _init_emitter_stateChanged_5680 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newState");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("oldState");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_stateChanged_5680 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractAnimation::State>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & >() (args, heap);
  const qt_gsi::Converter<QAbstractAnimation::State>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & >() (args, heap);
  ((QPropertyAnimation_Adaptor *)cls)->emitter_QPropertyAnimation_stateChanged_5680 (arg1, arg2);
}


// void QPropertyAnimation::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPropertyAnimation_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QPropertyAnimation_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QPropertyAnimation::updateCurrentTime(int)

static void _init_cbs_updateCurrentTime_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_updateCurrentTime_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPropertyAnimation_Adaptor *)cls)->cbs_updateCurrentTime_767_0 (arg1);
}

static void _set_callback_cbs_updateCurrentTime_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QPropertyAnimation_Adaptor *)cls)->cb_updateCurrentTime_767_0 = cb;
}


// void QPropertyAnimation::updateCurrentValue(const QVariant &value)

static void _init_cbs_updateCurrentValue_2119_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<const QVariant & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_updateCurrentValue_2119_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVariant &arg1 = args.read<const QVariant & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPropertyAnimation_Adaptor *)cls)->cbs_updateCurrentValue_2119_0 (arg1);
}

static void _set_callback_cbs_updateCurrentValue_2119_0 (void *cls, const gsi::Callback &cb)
{
  ((QPropertyAnimation_Adaptor *)cls)->cb_updateCurrentValue_2119_0 = cb;
}


// void QPropertyAnimation::updateDirection(QAbstractAnimation::Direction direction)

static void _init_cbs_updateDirection_3310_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_updateDirection_3310_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & arg1 = args.read<const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPropertyAnimation_Adaptor *)cls)->cbs_updateDirection_3310_0 (arg1);
}

static void _set_callback_cbs_updateDirection_3310_0 (void *cls, const gsi::Callback &cb)
{
  ((QPropertyAnimation_Adaptor *)cls)->cb_updateDirection_3310_0 = cb;
}


// void QPropertyAnimation::updateState(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)

static void _init_cbs_updateState_5680_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newState");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("oldState");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_updateState_5680_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractAnimation::State>::target_type & arg1 = args.read<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (heap);
  const qt_gsi::Converter<QAbstractAnimation::State>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPropertyAnimation_Adaptor *)cls)->cbs_updateState_5680_0 (arg1, arg2);
}

static void _set_callback_cbs_updateState_5680_0 (void *cls, const gsi::Callback &cb)
{
  ((QPropertyAnimation_Adaptor *)cls)->cb_updateState_5680_0 = cb;
}


// emitter void QPropertyAnimation::valueChanged(const QVariant &value)

static void _init_emitter_valueChanged_2119 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<const QVariant & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_valueChanged_2119 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVariant &arg1 = gsi::arg_reader<const QVariant & >() (args, heap);
  ((QPropertyAnimation_Adaptor *)cls)->emitter_QPropertyAnimation_valueChanged_2119 (arg1);
}


namespace gsi
{

gsi::Class<QPropertyAnimation> &qtdecl_QPropertyAnimation ();

static gsi::Methods methods_QPropertyAnimation_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPropertyAnimation::QPropertyAnimation(QObject *parent)\nThis method creates an object of class QPropertyAnimation.", &_init_ctor_QPropertyAnimation_Adaptor_1302, &_call_ctor_QPropertyAnimation_Adaptor_1302);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPropertyAnimation::QPropertyAnimation(QObject *target, const QByteArray &propertyName, QObject *parent)\nThis method creates an object of class QPropertyAnimation.", &_init_ctor_QPropertyAnimation_Adaptor_4697, &_call_ctor_QPropertyAnimation_Adaptor_4697);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QPropertyAnimation::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_currentLoopChanged", "@brief Emitter for signal void QPropertyAnimation::currentLoopChanged(int currentLoop)\nCall this method to emit this signal.", false, &_init_emitter_currentLoopChanged_767, &_call_emitter_currentLoopChanged_767);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QPropertyAnimation::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QPropertyAnimation::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("emit_directionChanged", "@brief Emitter for signal void QPropertyAnimation::directionChanged(QAbstractAnimation::Direction)\nCall this method to emit this signal.", false, &_init_emitter_directionChanged_3310, &_call_emitter_directionChanged_3310);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QPropertyAnimation::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("duration", "@brief Virtual method int QPropertyAnimation::duration()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_duration_c0_0, &_call_cbs_duration_c0_0);
  methods += new qt_gsi::GenericMethod ("duration", "@hide", true, &_init_cbs_duration_c0_0, &_call_cbs_duration_c0_0, &_set_callback_cbs_duration_c0_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QPropertyAnimation::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QPropertyAnimation::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_finished", "@brief Emitter for signal void QPropertyAnimation::finished()\nCall this method to emit this signal.", false, &_init_emitter_finished_0, &_call_emitter_finished_0);
  methods += new qt_gsi::GenericMethod ("*interpolated", "@brief Virtual method QVariant QPropertyAnimation::interpolated(const QVariant &from, const QVariant &to, double progress)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_interpolated_c5093_0, &_call_cbs_interpolated_c5093_0);
  methods += new qt_gsi::GenericMethod ("*interpolated", "@hide", true, &_init_cbs_interpolated_c5093_0, &_call_cbs_interpolated_c5093_0, &_set_callback_cbs_interpolated_c5093_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QPropertyAnimation::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QPropertyAnimation::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QPropertyAnimation::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QPropertyAnimation::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QPropertyAnimation::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("emit_stateChanged", "@brief Emitter for signal void QPropertyAnimation::stateChanged(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)\nCall this method to emit this signal.", false, &_init_emitter_stateChanged_5680, &_call_emitter_stateChanged_5680);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QPropertyAnimation::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateCurrentTime", "@brief Virtual method void QPropertyAnimation::updateCurrentTime(int)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateCurrentTime_767_0, &_call_cbs_updateCurrentTime_767_0);
  methods += new qt_gsi::GenericMethod ("*updateCurrentTime", "@hide", false, &_init_cbs_updateCurrentTime_767_0, &_call_cbs_updateCurrentTime_767_0, &_set_callback_cbs_updateCurrentTime_767_0);
  methods += new qt_gsi::GenericMethod ("*updateCurrentValue", "@brief Virtual method void QPropertyAnimation::updateCurrentValue(const QVariant &value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateCurrentValue_2119_0, &_call_cbs_updateCurrentValue_2119_0);
  methods += new qt_gsi::GenericMethod ("*updateCurrentValue", "@hide", false, &_init_cbs_updateCurrentValue_2119_0, &_call_cbs_updateCurrentValue_2119_0, &_set_callback_cbs_updateCurrentValue_2119_0);
  methods += new qt_gsi::GenericMethod ("*updateDirection", "@brief Virtual method void QPropertyAnimation::updateDirection(QAbstractAnimation::Direction direction)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateDirection_3310_0, &_call_cbs_updateDirection_3310_0);
  methods += new qt_gsi::GenericMethod ("*updateDirection", "@hide", false, &_init_cbs_updateDirection_3310_0, &_call_cbs_updateDirection_3310_0, &_set_callback_cbs_updateDirection_3310_0);
  methods += new qt_gsi::GenericMethod ("*updateState", "@brief Virtual method void QPropertyAnimation::updateState(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateState_5680_0, &_call_cbs_updateState_5680_0);
  methods += new qt_gsi::GenericMethod ("*updateState", "@hide", false, &_init_cbs_updateState_5680_0, &_call_cbs_updateState_5680_0, &_set_callback_cbs_updateState_5680_0);
  methods += new qt_gsi::GenericMethod ("emit_valueChanged", "@brief Emitter for signal void QPropertyAnimation::valueChanged(const QVariant &value)\nCall this method to emit this signal.", false, &_init_emitter_valueChanged_2119, &_call_emitter_valueChanged_2119);
  return methods;
}

gsi::Class<QPropertyAnimation_Adaptor> decl_QPropertyAnimation_Adaptor (qtdecl_QPropertyAnimation (), "QtCore", "QPropertyAnimation",
  methods_QPropertyAnimation_Adaptor (),
  "@qt\n@brief Binding of QPropertyAnimation");

}

