/***************************************************************************
 *   Copyright (C) 2006-2007 by Julien Lemoine, Simon Viennot              *
 *   lapinot@tuxfamily.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "jeu.h"

//QObject utilis uniquement pour tr (traduction de chaines)
#include <QObject>

//lancement du calcul en tche de fond
void jeu::run() {
	etude_tirage();
}

//initialisation de la classe jeu  partir d'un tirage
void jeu::init(const tirage& t, const int &liminf, const int &limsup){
	
	// c'est ici que l'on rentre le tirage que l'on veut tudier.
	tirage_etudie=t;
	
	// le sous_tirage_etudie est un vecteur rpertoriant l'ensemble des sous-tirages du tirages, tris comme il faut
	sous_tirage_etudie=tirage_etudie.calcul_sous_tirages();
	
	// vecteur dans lequel on va stocker l'ensemble des calculs, tris selon les plaquettes qu'ils utilisent
	stock stock_vide;
	grande_base.clear();
	grande_base.assign(sous_tirage_etudie.size(), stock_vide);
	
	// init du compteur de calculs non retenus car non canoniques (25/5 etc)
	compteur_simplif=0;
	// init du compteur de calculs non retenus parce que leur valeur n'est pas dans la plage voulue
	compteur_simplif2=0;
	
	// init des limites utilises pour ne garder que les calculs dont les valeurs sont dans la plage voulue
	lim_inf_inf=0;		//varie entre 0 et 99
	lim_inf_sup=100000;	//varie entre 100 et 100000
	lim_sup_inf=0;		//varie entre 0 et 999
	lim_sup_sup=100000;	//varie entre 1000 et 100000
	
	lim_inf=liminf;
	lim_sup=limsup;
}

//tude d'un tirage
//la classe jeu doit tre initialise avec init avant d'appeler cette fonction
void jeu::etude_tirage(){
	int taille_sous_tirage=sous_tirage_etudie.size();
	
	int i;
	stock::iterator Cj, Ck, Ck_debut;
	
	//boucle principale
	for(stock_courant=1; stock_courant<taille_sous_tirage; stock_courant++){
		dernier_sous_tirage=(stock_courant==taille_sous_tirage-1);	//on indique si c'est le dernier sous_tirage ou pas
		
		if((sous_tirage_etudie[stock_courant]).taille()==1){		//cas o le sous_tirage ne comporte qu'une plaque
			map<plaque, int>::iterator it=sous_tirage_etudie[stock_courant].tab.begin();
			grande_base[stock_courant].insert(calcul(it->first));
		}
		else{	//cas o le sous_tirage comporte au moins 2 plaques
			vector<tirage> sous_sous_tirage=(sous_tirage_etudie[stock_courant]).calcul_sous_tirages();
			int sous_sous_taille=sous_sous_tirage.size();
			
			//boucle : si on remplit le sous-tirage 2;3;5, il faut utiliser 2 + 3;5 et 3 + 5;2 etc
			for(i=1; i<(sous_sous_taille+1)/2; i++) {
				int position1=(sous_sous_tirage[i]).trouve_dans(sous_tirage_etudie);
				int position2=(sous_sous_tirage[sous_sous_taille-1-i]).trouve_dans(sous_tirage_etudie);
				
				for (Cj=grande_base[position1].begin(); Cj!=grande_base[position1].end(); Cj++) {
					if (position1!=position2) {
						Ck_debut=grande_base[position2].begin();
					} 
					else {
						Ck_debut=Cj;
					}
					
					for (Ck=Ck_debut; Ck!=grande_base[position2].end(); Ck++) {
						combinaisons(*Cj, *Ck);
					}
				}
			}
		}
		
		degageNonCano();	//supprime les calculs non canoniques du stock courant
	}
	
	//suppression finale des positions hors plage
	degageHorsPlage();
}

// fonction qui renvoie true si le calcul est dans la bonne plage 
//(entre 100 et 999, et ventuellement <100 mais >=lim_inf_inf, de mme pour >999)
// cette fonction modifie galement les lim_x_x quand elle rencontre un calcul qui permet de les affiner
bool jeu::dans_la_bonne_plage(const calcul& C){
	compte valeur=C.valeur_calcul;
	if(valeur>=lim_inf && valeur<=lim_sup){		// cas 100<=valeur<=999
		if(lim_inf_sup>valeur){
			lim_inf_sup=valeur;
		}
		if(lim_sup_inf<valeur){
			lim_sup_inf=valeur;
		}
		return true;
	}
	else{
		if(valeur<lim_inf){				// cas valeur<100
			if(lim_inf_inf<=valeur){		//il faut mettre = sinon on risque de considrer certains calcs comme pas ds la bonne plage
				lim_inf_inf=valeur;
				return true;
			}
		}
		else{						// cas valeur>999
			if(lim_sup_sup>=valeur){
				lim_sup_sup=valeur;
				return true;
			}
		}
	}
	return false;
}

//ajoute dans la base un calcul en vrifiant qu'il remplit les conditions adquates
void jeu::ajouteBase(const calcul& A){
	if(!dernier_sous_tirage || dans_la_bonne_plage(A)){
		grande_base[stock_courant].insert(A);
	}
}

//calcule les combinaisons de A et B et demande leur ajout dans la base
void jeu::combinaisons(const calcul& A, const calcul& B){
	
	ajouteBase(A+B);						// prise en compte de l'addition
	
	if(A.valeur_calcul<B.valeur_calcul) {				// prise en compte de la soustraction
		ajouteBase(B-A);
	}
	else if(A.valeur_calcul>B.valeur_calcul) {
		ajouteBase(A-B);
	}
	
	if(A.valeur_calcul!=1 && B.valeur_calcul!=1) {			// prise en compte de la multiplication
		ajouteBase(A*B);
				
		if(A.valeur_calcul==B.valeur_calcul) {			// prise en compte de la division
			calcul C=A/B; calcul D=B/A;
			if(C < D) {
				ajouteBase(C);
			} else {
				ajouteBase(D);
			}
		}
		else {
			if (A.valeur_calcul % B.valeur_calcul==0){
				ajouteBase(A/B);
			}
			else if (B.valeur_calcul % A.valeur_calcul==0){
				ajouteBase(B/A);
			}
		}
	}
}

//fonction qui supprime du stock courant les calculs non canoniques
void jeu::degageNonCano(){
	stock::iterator Ci, Csuiv;
	
	for(Ci=grande_base[stock_courant].begin(); Ci!=grande_base[stock_courant].end(); Ci=Csuiv) {
		Csuiv=Ci; Csuiv++;
		if(! (Ci->est_cano())){
			compteur_simplif++;
			grande_base[stock_courant].erase(Ci);
		}
	}
}

//supprime de la base les positions en dehors de la plage
void jeu::degageHorsPlage() {
	int i;
	int taille_sous_tirage=sous_tirage_etudie.size();
	stock::iterator Cj;
	
	//boucle pour dterminer entre quels entiers on va garder les calculs (lim_inf_inf et lim_sup_sup)
	for(i=1;i<taille_sous_tirage-1;i++){
		for(Cj=grande_base[i].begin(); Cj!=grande_base[i].end(); Cj++){
			dans_la_bonne_plage(*Cj);
		}
		
	}
	
	//prise en compte du cas suivant : si on veut trouver le compte 100, et que l'on peut trouver 101,
	//alors il ne sert  rien de garder 98 qui est plus loign
	//Dtermination des lim_x_x finales
	
	if(lim_inf-lim_inf_inf>lim_inf_sup-lim_inf){
		lim_inf_inf=lim_inf;
	}
	
	if(lim_sup_sup-lim_sup>lim_sup-lim_sup_inf){
		lim_sup_sup=lim_sup;
	}
	
	//boucle pour virer toutes les positions qui ne sont pas entre les lim_inf_inf et lim_sup_sup finales
	stock::iterator Csuiv;
	
	for(i=1;i<taille_sous_tirage;i++){
		for(Cj=grande_base[i].begin();Cj!=grande_base[i].end();Cj=Csuiv){
			Csuiv=Cj; Csuiv++;
			if(Cj->valeur_calcul < lim_inf_inf || Cj->valeur_calcul > lim_sup_sup){
				compteur_simplif2++;
				grande_base[i].erase(Cj);
			}
		}
	}
}

//fonction donnant la distance  la solution : 0 si le problme est soluble, sinon la distance entre le compte et la meilleure solution
//bien sr, cette fonction n'est utile que si on tudie un seul compte, ie si lim_inf=lim_sup
int jeu::distance_a_la_solution() const{
	int resultat=1000;
	vector<stock>::const_iterator STi;
	stock::const_iterator Cj;
	for(STi=grande_base.begin(); STi!=grande_base.end(); STi++) {
		for(Cj=STi->begin(); Cj!=STi->end(); Cj++) {
			if((Cj->valeur_calcul)>=lim_inf){
				if((Cj->valeur_calcul -lim_inf)<resultat){
					resultat=(Cj->valeur_calcul -lim_inf);
				}
			}
			else{
				if((lim_inf- Cj->valeur_calcul)<resultat){
					resultat=(lim_inf- Cj->valeur_calcul);
				}
			}
		}
	}
	return resultat;
}

//affichage des solutions en affichant en priorit les calculs utilisant peu de plaques
//ne doit tre utilis que dans le cas de l'tude d'un unique compte
//dans le cas o le compte ne serait pas bon, il n'affiche que les solutions optimales
//note : tr n'a aucun effet quand l'appli Qt n'est pas lance
QString jeu::afficheBase() const {
	QString resultat;
	string str_temp;

	int i;
	int dist=distance_a_la_solution();
	stock stock_temp;
	vector<stock>::const_iterator STi;
	stock::const_iterator it;
	for(i=1;i<=tirage_etudie.taille();i++){
		stock_temp.clear();
		for(STi=grande_base.begin(); STi!=grande_base.end(); STi++) {
			for(it=STi->begin(); it!=STi->end(); it++) {
				if(it->longueur()==i && ((it->valeur_calcul -lim_inf)==dist || (lim_inf- it->valeur_calcul)==dist)){
					stock_temp.insert(*it);
				}
			}
		}
		if(!stock_temp.empty()){
			if(distance_a_la_solution()==0) {
				resultat.append(QObject::tr("Solutions utilisant %1 plaques:").arg(i));
			} else {
				resultat.append(QObject::tr("Approximations utilisant %1 plaques:").arg(i));
			}
			resultat.append("\n");
			for(it=stock_temp.begin(); it!=stock_temp.end(); it++) {
				stringstream ss2;
				ss2 << it->valeur_calcul;
				ss2 >> str_temp;
				resultat.append(QString::fromStdString(str_temp));
				resultat.append(".  ");
				resultat.append(QString::fromStdString(it->affiche_calcul()));
				resultat.append("\n");
			}
			resultat.append("\n");
		}
	}
	return resultat;
}

string jeu::afficheProbleme() const {
	string resultat;
	stringstream flux;
	//affichage du tirage dans la chaine resultat
	flux << tirage_etudie;
	flux >> resultat;
	return resultat;
}


//affichage d'informations sur l'tude ralise
void jeu::afficheInfo() const {
	cout << "tirage : " << tirage_etudie << endl
	     << "taille du tirage = " << tirage_etudie.taille() << endl
	     << "ensemble des sous tirages :" << endl << sous_tirage_etudie << endl
	     << "nombre de calculs stockes : " << nb_calculs_stockes() << endl
	     << "nombre de calculs simplifis (canonisation) : " << compteur_simplif << endl
	     << "nombre de calculs simplifis (pas la plage voulue) : " << compteur_simplif2 << endl
	     << "nombre de comptes ralisables (sur " << lim_sup-lim_inf+1 << " possibles) :" 
	     << nb_comptes_realises() << endl;
}

// renvoie le nombre de comptes faisables avec le tirage tudi
int jeu::nb_comptes_realises() const{
	set<compte> comptes_realises;		// ensemble des comptes entre 100 et 999 raliss par ce tirage
	vector<stock>::const_iterator STi;
	stock::iterator Cj;
	
	for(STi=grande_base.begin(); STi!=grande_base.end(); STi++) {
		for(Cj=STi->begin();Cj!=STi->end();Cj++){
			if(Cj->valeur_calcul>=lim_inf && Cj->valeur_calcul<=lim_sup){
				comptes_realises.insert(Cj->valeur_calcul);
			}
		}
	}
	return comptes_realises.size();
}

// renvoie le nombre de calculs stocks 
int jeu::nb_calculs_stockes() const{
	int total=0;				// nombre de calculs stocks.
	vector<stock>::const_iterator STi;
	
	for(STi=grande_base.begin(); STi!=grande_base.end(); STi++) {
		total=total+STi->size();
	}
	
	return total;
}

//renvoie un vecteur contenant 0 si le compte n'est pas ralis, 1 sinon
vector<bool> jeu::comptes_realises() const{
	vector<bool> resultat;
	resultat.assign(1000,false);
	vector<stock>::const_iterator STi;
	stock::iterator Cj;
	
	for(STi=grande_base.begin(); STi!=grande_base.end(); STi++) {
		for(Cj=STi->begin();Cj!=STi->end();Cj++){
			if(Cj->valeur_calcul>=lim_inf && Cj->valeur_calcul<=lim_sup){
				resultat[Cj->valeur_calcul]=true;
			}
		}
	}
	
	return resultat;
}

// partir d'ici, travail sur l'tude globale

void etude_globale::grosse_etude(const set<tirage> &st){
	tirages_etudies=st;
	
	//initialisation des variables qui vont contenir les rsultats
	nb_approch.assign(919,0);
	proba_approch.assign(919,0);
	nb_comptes.assign(1000,0);
	proba_comptes.assign(1000,0);
	nb_cpts_realises.assign(901,0);
	proba_cpts_realises.assign(901,0);
	nb_total_solutions=0;
	
	//variables d'avancement : nombre de tirages dj tudis, somme des coefficients des tirages dj tudis (pour les donnes partielles)
	int avancement_tirages=0;
	int avancement_coefs=0;
	
	//itrateurs
	set<tirage>::iterator TIR;
	set<compte>::iterator CPT;
	
	//fichier contenant les informations sur le nombre de solutions obtenues par tirage
	ofstream f_nb_solutions("nb_solutions.txt");
	f_nb_solutions.is_open();
	f_nb_solutions << "Tirage\tNombre de comptes raliss\tNombre de solutions" << endl;
	
	//boucle principale
	for(TIR=tirages_etudies.begin();TIR!=tirages_etudies.end();TIR++){
		jeu J;
		J.init(*TIR,100,999);
		J.etude_tirage();
		vector<bool> les_comptes_realises=J.comptes_realises();
		
		avancement_tirages++;
		int coef=TIR->coefficient();
		avancement_coefs+=coef;
		
		int i;
		
		//pour l'tude de la frquence de ralisation d'un problme  0,1,2...918 prs (nombre de problmes, probas)
		for(i=100;i<1000;i++){
			int ecart=0;
			if(!les_comptes_realises[i]){
				bool approx_trouvee=false;
				while(!approx_trouvee){
					ecart++;
					if(i-ecart>=100){
						if(les_comptes_realises[i-ecart]){
							approx_trouvee=true;
						}
					}
					else{
						if(J.lim_inf_inf==i-ecart){
							approx_trouvee=true;
						}
					}
					if(i+ecart<=999){
						if(les_comptes_realises[i+ecart]){
							approx_trouvee=true;
						}
					}
					else{
						if(J.lim_sup_sup==i+ecart){
							approx_trouvee=true;
						}
					}
				}
			}
			proba_approch[ecart]+=coef;
			nb_approch[ecart]++;
		}
		
		//pour l'tude de la frquence de ralisation de chaque compte (nombre de tirages, probas)
		for(i=100;i<1000;i++){
			if(les_comptes_realises[i]){
				nb_comptes[i]++;
				proba_comptes[i]+=coef;
			}
		}
		//pour l'tude du nombre de comptes raliss par chaque tirage
		int resultat=0;
		for(i=100;i<1000;i++){
			if(les_comptes_realises[i]){
				resultat++;
			}
		}
		nb_cpts_realises[resultat]++;
		proba_cpts_realises[resultat]+=coef;
		
		//pour l'tude du nombre total de solutions
		int ncs=J.nb_calculs_stockes();
		f_nb_solutions << *TIR << "\t" << resultat << "\t" << ncs << endl;
		nb_total_solutions+=ncs;
		
		//affichage de l'avancement de l'tude
		cout << "\r" << avancement_tirages << "/13243 tirages tudis" << flush;
	}
	
	cout << endl;  //retour  la ligne en fin de boucle
	
	//une fois le calcul termin, on stocke les rsultats dans des fichiers.
	
	f_nb_solutions << "# Nombre total de solutions\t" << nb_total_solutions;
	f_nb_solutions.close();
	
	ofstream f_approch("approch.txt");
	if (f_approch.is_open()){
		f_approch << "# total\t" << avancement_tirages*900 << "\t" << avancement_coefs*900 << endl;
		int i;
		for(i=0;i<=918;i++){
			f_approch << i << "\t" << nb_approch[i] << "\t" << proba_approch[i] << endl;
		}
		f_approch.close();
	}
	
	ofstream f_compte("compte.txt");
	if (f_compte.is_open()){
		f_compte << "# total\t" << avancement_tirages << "\t" << avancement_coefs << endl;
		int i;
		for(i=100;i<=999;i++){
			f_compte << i << "\t" << nb_comptes[i] << "\t" << proba_comptes[i] << endl;
		}
		f_compte.close();
	}
	
	ofstream f_tirage("tirage.txt");
	if (f_tirage.is_open()){
		f_tirage << "# total\t" << avancement_tirages << "\t" << avancement_coefs << endl;
		int i;
		for(i=0;i<=900;i++){
			f_tirage << i << "\t" << nb_cpts_realises[i] << "\t" << proba_cpts_realises[i] << endl;
		}
		f_tirage.close();
	}
	
	int proba_solub=proba_approch[0]/(avancement_coefs*9);
	int proba_solub_decim=(proba_approch[0]%(avancement_coefs*9))*100/(avancement_coefs*9);
	int proba_tir_ts=proba_cpts_realises[900]*100/avancement_coefs;
	int proba_tir_ts_decim=proba_cpts_realises[900]*10000/avancement_coefs-proba_tir_ts*100;
	
	ofstream f_resume("resume.txt");
	if (f_resume.is_open()){
	//Rsultats sur les problmes
		f_resume << "Nombre de problmes solubles   : " << nb_approch[0] << "/" << avancement_tirages*900 << endl;
		f_resume << "Nombre de problmes insolubles : " << (avancement_tirages*900-nb_approch[0]) << "/" << avancement_tirages*900 << endl;
		f_resume << "Proba qu'un pb soit soluble    : " << proba_approch[0] << "/" << avancement_coefs*900;
		f_resume << " soit environ " << proba_solub << ",";
		if(proba_solub_decim<10){
			f_resume << "0" ;
		}
		f_resume << proba_solub_decim << " %" << endl;
		f_resume << endl;
	//Rsultats sur les comptes
		int i;
		int nb_max=0;
		int proba_max=0;
		int nb_min=avancement_tirages;
		int proba_min=avancement_coefs;
		for(i=100;i<=999;i++){
			if(nb_comptes[i]>nb_max) nb_max=nb_comptes[i];
			if(proba_comptes[i]>proba_max) proba_max=proba_comptes[i];
			if(nb_comptes[i]<nb_min) nb_min=nb_comptes[i];
			if(proba_comptes[i]<proba_min) proba_min=proba_comptes[i];
		}
		f_resume << "Compte(s) obtenu(s) avec le plus de tirages : ";
		for(i=100;i<=999;i++){
			if(nb_comptes[i]==nb_max) f_resume << i << ".";
		}
		f_resume << endl << "(avec " << nb_max << " tirages)" << endl;
		f_resume << "Compte(s) obtenu(s) avec le moins de tirages : ";
		for(i=100;i<=999;i++){
			if(nb_comptes[i]==nb_min) f_resume << i << ".";
		}
		f_resume << endl << "(avec " << nb_min << " tirages)" << endl;
		f_resume << "Compte(s) obtenu(s) le plus frquemment : ";
		for(i=100;i<=999;i++){
			if(proba_comptes[i]==proba_max) f_resume << i << ".";
		}
		f_resume << endl << "(avec une proba de " << proba_max << "/" << avancement_coefs << " )" << endl;
		f_resume << "Compte(s) obtenu(s) le moins frquemment : ";
		for(i=100;i<=999;i++){
			if(proba_comptes[i]==proba_min) f_resume << i << ".";
		}
		f_resume << endl << "(avec une proba de " << proba_min << "/" << avancement_coefs << " )" << endl;
		f_resume << endl;
	//Rsultats sur les tirages
		f_resume << "Nb de tirages permettant d'obtenir tous les comptes    : " <<  nb_cpts_realises[900] << "/" << avancement_tirages;
		f_resume << endl;
		f_resume << "Proba qu'un tirage permette d'obtenir tous les comptes : " <<  proba_cpts_realises[900] << "/" << avancement_coefs;
		f_resume << " soit environ " << proba_tir_ts << ",";
		if(proba_tir_ts_decim<10){
			f_resume << "0" ;
		}
		f_resume << proba_tir_ts_decim << " %" << endl;
		f_resume.close();
	}
}

