/*
 * %kadu copyright begin%
 * Copyright 2016 Rafał Przemysław Malinowski (rafal.przemyslaw.malinowski@gmail.com)
 * %kadu copyright end%
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "open-chat-with-service.h"

#include "core/injected-factory.h"
#include "gui/windows/open-chat-with/open-chat-with.h"

OpenChatWithService::OpenChatWithService(QObject *parent) :
		QObject{parent}
{
}

OpenChatWithService::~OpenChatWithService()
{
}


void OpenChatWithService::setInjectedFactory(InjectedFactory *injectedFactory)
{
	m_injectedFactory = injectedFactory;
}

void OpenChatWithService::show()
{
	if (!m_openChatWithWindow)
		m_openChatWithWindow = m_injectedFactory->makeInjected<OpenChatWith>();

	m_openChatWithWindow->show();
}
