/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;

public class AttributeTable {
    private Hashtable attributes = new Hashtable();

    public AttributeTable(Hashtable hashtable) {
        this.attributes = this.copyTable(hashtable);
    }

    public AttributeTable(DEREncodableVector dEREncodableVector) {
        for (int i = 0; i != dEREncodableVector.size(); ++i) {
            Attribute attribute = Attribute.getInstance(dEREncodableVector.get(i));
            this.addAttribute(attribute.getAttrType(), attribute);
        }
    }

    public AttributeTable(ASN1Set aSN1Set) {
        for (int i = 0; i != aSN1Set.size(); ++i) {
            Attribute attribute = Attribute.getInstance(aSN1Set.getObjectAt(i));
            this.addAttribute(attribute.getAttrType(), attribute);
        }
    }

    private void addAttribute(DERObjectIdentifier dERObjectIdentifier, Attribute attribute) {
        Object v = this.attributes.get(dERObjectIdentifier);
        if (v == null) {
            this.attributes.put(dERObjectIdentifier, attribute);
        } else {
            Vector<Object> vector;
            if (v instanceof Attribute) {
                vector = new Vector<Object>();
                vector.addElement(v);
                vector.addElement(attribute);
            } else {
                vector = (Vector<Object>)v;
                vector.addElement(attribute);
            }
            this.attributes.put(dERObjectIdentifier, vector);
        }
    }

    public Attribute get(DERObjectIdentifier dERObjectIdentifier) {
        Object v = this.attributes.get(dERObjectIdentifier);
        if (v instanceof Vector) {
            return (Attribute)((Vector)v).elementAt(0);
        }
        return (Attribute)v;
    }

    public ASN1EncodableVector getAll(DERObjectIdentifier dERObjectIdentifier) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Object v = this.attributes.get(dERObjectIdentifier);
        if (v instanceof Vector) {
            Enumeration enumeration = ((Vector)v).elements();
            while (enumeration.hasMoreElements()) {
                aSN1EncodableVector.add((Attribute)enumeration.nextElement());
            }
        } else if (v != null) {
            aSN1EncodableVector.add((Attribute)v);
        }
        return aSN1EncodableVector;
    }

    public Hashtable toHashtable() {
        return this.copyTable(this.attributes);
    }

    public ASN1EncodableVector toASN1EncodableVector() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (v instanceof Vector) {
                Enumeration enumeration2 = ((Vector)v).elements();
                while (enumeration2.hasMoreElements()) {
                    aSN1EncodableVector.add(Attribute.getInstance(enumeration2.nextElement()));
                }
                continue;
            }
            aSN1EncodableVector.add(Attribute.getInstance(v));
        }
        return aSN1EncodableVector;
    }

    private Hashtable copyTable(Hashtable hashtable) {
        Hashtable hashtable2 = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            hashtable2.put(k, hashtable.get(k));
        }
        return hashtable2;
    }
}

