/*
 * Decompiled with CFR 0.152.
 */
package jonelo.jacksum.algorithm;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import jonelo.jacksum.adapt.com.bitzi.util.TigerTree;
import jonelo.jacksum.algorithm.AbstractChecksum;

public class MDTree
extends AbstractChecksum {
    private MessageDigest md = null;
    private boolean virgin = true;
    private byte[] digest = null;

    public MDTree(String string) throws NoSuchAlgorithmException {
        this.length = 0L;
        this.filename = null;
        this.separator = " ";
        this.encoding = "base32";
        this.virgin = true;
        this.md = new TigerTree(string);
    }

    public void reset() {
        this.md.reset();
        this.length = 0L;
        this.virgin = true;
    }

    public void update(byte[] byArray, int n, int n2) {
        this.md.update(byArray, n, n2);
        this.length += (long)n2;
    }

    public void update(byte by) {
        this.md.update(by);
        ++this.length;
    }

    public void update(int n) {
        this.update((byte)(n & 0xFF));
    }

    public String toString() {
        return this.getFormattedValue() + this.separator + (this.isTimestampWanted() ? this.getTimestampFormatted() + this.separator : "") + this.getFilename();
    }

    public byte[] getByteArray() {
        if (this.virgin) {
            this.digest = this.md.digest();
            this.virgin = false;
        }
        byte[] byArray = new byte[this.digest.length];
        System.arraycopy(this.digest, 0, byArray, 0, this.digest.length);
        return byArray;
    }
}

