/*
 * Decompiled with CFR 0.152.
 */
package jonelo.jacksum.adapt.gnu.crypto.hash;

import jonelo.jacksum.adapt.gnu.crypto.hash.BaseHash;
import jonelo.jacksum.adapt.gnu.crypto.util.Util;

public class Has160
extends BaseHash {
    private static final int BLOCK_SIZE = 64;
    private static final String DIGEST0 = "975E810488CF2A3D49838478124AFCE4B1C78804";
    private static final int[] w = new int[20];
    private static Boolean valid;
    private int h0;
    private int h1;
    private int h2;
    private int h3;
    private int h4;
    private static final int[] rot;
    private static final int[] tor;
    private static int[] ndx;

    public Has160() {
        super("has-160", 20, 64);
    }

    private Has160(Has160 has160) {
        this();
        this.h0 = has160.h0;
        this.h1 = has160.h1;
        this.h2 = has160.h2;
        this.h3 = has160.h3;
        this.h4 = has160.h4;
        this.count = has160.count;
        this.buffer = (byte[])has160.buffer.clone();
    }

    public static final int[] G(int n, int n2, int n3, int n4, int n5, byte[] byArray, int n6) {
        return Has160.has(n, n2, n3, n4, n5, byArray, n6);
    }

    public Object clone() {
        return new Has160(this);
    }

    protected void transform(byte[] byArray, int n) {
        int[] nArray = Has160.has(this.h0, this.h1, this.h2, this.h3, this.h4, byArray, n);
        this.h0 = nArray[0];
        this.h1 = nArray[1];
        this.h2 = nArray[2];
        this.h3 = nArray[3];
        this.h4 = nArray[4];
    }

    protected byte[] padBuffer() {
        int n = (int)(this.count % 64L);
        int n2 = n < 56 ? 56 - n : 120 - n;
        byte[] byArray = new byte[n2 + 8];
        byArray[0] = -128;
        long l = this.count << 3;
        byArray[n2++] = (byte)l;
        byArray[n2++] = (byte)(l >>> 8);
        byArray[n2++] = (byte)(l >>> 16);
        byArray[n2++] = (byte)(l >>> 24);
        byArray[n2++] = (byte)(l >>> 32);
        byArray[n2++] = (byte)(l >>> 40);
        byArray[n2++] = (byte)(l >>> 48);
        byArray[n2] = (byte)(l >>> 56);
        return byArray;
    }

    protected byte[] getResult() {
        byte[] byArray = new byte[]{(byte)this.h0, (byte)(this.h0 >>> 8), (byte)(this.h0 >>> 16), (byte)(this.h0 >>> 24), (byte)this.h1, (byte)(this.h1 >>> 8), (byte)(this.h1 >>> 16), (byte)(this.h1 >>> 24), (byte)this.h2, (byte)(this.h2 >>> 8), (byte)(this.h2 >>> 16), (byte)(this.h2 >>> 24), (byte)this.h3, (byte)(this.h3 >>> 8), (byte)(this.h3 >>> 16), (byte)(this.h3 >>> 24), (byte)this.h4, (byte)(this.h4 >>> 8), (byte)(this.h4 >>> 16), (byte)(this.h4 >>> 24)};
        return byArray;
    }

    protected void resetContext() {
        this.h0 = 1732584193;
        this.h1 = -271733879;
        this.h2 = -1732584194;
        this.h3 = 271733878;
        this.h4 = -1009589776;
    }

    public boolean selfTest() {
        if (valid == null) {
            Has160 has160 = new Has160();
            has160.update((byte)97);
            has160.update((byte)98);
            has160.update((byte)99);
            String string = Util.toString(has160.digest());
            valid = new Boolean(DIGEST0.equals(string));
        }
        return valid;
    }

    private static final synchronized int[] has(int n, int n2, int n3, int n4, int n5, byte[] byArray, int n6) {
        int n7;
        int n8;
        int n9 = n;
        int n10 = n2;
        int n11 = n3;
        int n12 = n4;
        int n13 = n5;
        for (n8 = 0; n8 < 16; ++n8) {
            Has160.w[n8] = byArray[n6 + 3] << 24 | (byArray[n6 + 2] & 0xFF) << 16 | (byArray[n6 + 1] & 0xFF) << 8 | byArray[n6] & 0xFF;
            n6 += 4;
        }
        Has160.w[16] = w[0] ^ w[1] ^ w[2] ^ w[3];
        Has160.w[17] = w[4] ^ w[5] ^ w[6] ^ w[7];
        Has160.w[18] = w[8] ^ w[9] ^ w[10] ^ w[11];
        Has160.w[19] = w[12] ^ w[13] ^ w[14] ^ w[15];
        for (n8 = 0; n8 < 20; ++n8) {
            n7 = (n9 << rot[n8] | n9 >>> tor[n8]) + (n10 & n11 | ~n10 & n12) + n13 + w[ndx[n8]];
            n13 = n12;
            n12 = n11;
            n11 = n10 << 10 | n10 >>> 22;
            n10 = n9;
            n9 = n7;
        }
        Has160.w[16] = w[3] ^ w[6] ^ w[9] ^ w[12];
        Has160.w[17] = w[2] ^ w[5] ^ w[8] ^ w[15];
        Has160.w[18] = w[1] ^ w[4] ^ w[11] ^ w[14];
        Has160.w[19] = w[0] ^ w[7] ^ w[10] ^ w[13];
        for (n8 = 20; n8 < 40; ++n8) {
            n7 = (n9 << rot[n8 - 20] | n9 >>> tor[n8 - 20]) + (n10 ^ n11 ^ n12) + n13 + w[ndx[n8]] + 1518500249;
            n13 = n12;
            n12 = n11;
            n11 = n10 << 17 | n10 >>> 15;
            n10 = n9;
            n9 = n7;
        }
        Has160.w[16] = w[5] ^ w[7] ^ w[12] ^ w[14];
        Has160.w[17] = w[0] ^ w[2] ^ w[9] ^ w[11];
        Has160.w[18] = w[4] ^ w[6] ^ w[13] ^ w[15];
        Has160.w[19] = w[1] ^ w[3] ^ w[8] ^ w[10];
        for (n8 = 40; n8 < 60; ++n8) {
            n7 = (n9 << rot[n8 - 40] | n9 >>> tor[n8 - 40]) + (n11 ^ (n10 | ~n12)) + n13 + w[ndx[n8]] + 1859775393;
            n13 = n12;
            n12 = n11;
            n11 = n10 << 25 | n10 >>> 7;
            n10 = n9;
            n9 = n7;
        }
        Has160.w[16] = w[2] ^ w[7] ^ w[8] ^ w[13];
        Has160.w[17] = w[3] ^ w[4] ^ w[9] ^ w[14];
        Has160.w[18] = w[0] ^ w[5] ^ w[10] ^ w[15];
        Has160.w[19] = w[1] ^ w[6] ^ w[11] ^ w[12];
        for (n8 = 60; n8 < 80; ++n8) {
            n7 = (n9 << rot[n8 - 60] | n9 >>> tor[n8 - 60]) + (n10 ^ n11 ^ n12) + n13 + w[ndx[n8]] + -1894007588;
            n13 = n12;
            n12 = n11;
            n11 = n10 << 30 | n10 >>> 2;
            n10 = n9;
            n9 = n7;
        }
        return new int[]{n + n9, n2 + n10, n3 + n11, n4 + n12, n5 + n13};
    }

    static {
        rot = new int[]{5, 11, 7, 15, 6, 13, 8, 14, 7, 12, 9, 11, 8, 15, 6, 12, 9, 14, 5, 13};
        tor = new int[]{27, 21, 25, 17, 26, 19, 24, 18, 25, 20, 23, 21, 24, 17, 26, 20, 23, 18, 27, 19};
        ndx = new int[]{18, 0, 1, 2, 3, 19, 4, 5, 6, 7, 16, 8, 9, 10, 11, 17, 12, 13, 14, 15, 18, 3, 6, 9, 12, 19, 15, 2, 5, 8, 16, 11, 14, 1, 4, 17, 7, 10, 13, 0, 18, 12, 5, 14, 7, 19, 0, 9, 2, 11, 16, 4, 13, 6, 15, 17, 8, 1, 10, 3, 18, 7, 2, 13, 8, 19, 3, 14, 9, 4, 16, 15, 10, 5, 0, 17, 11, 6, 1, 12};
    }
}

