# App QoS - proxy usage

App QoS allows only local API calls by design. For security reasons, it is only recommended to allow remote connections in trusted environments, and for purpose of evaluating the software. A reverse proxy can be used to enable remote connections from client software. Below is an example of HAProxy configuration, as it is available in most Linux distributions.

# Installation

Please refer to your's Linux distribution manual to install HAProxy from the system repository.

# Configuration

To establish connection to App QoS, you need to provide mTLS client's certificate. For testing you can use certificates generated by scripts from appqos/ca directory. An example HAProxy configuration of the backend server should look like this:
```
frontend main
        bind *:8080
        default_backend static

backend static
        server static 127.0.0.1:5000 ssl verify required crt /etc/ssl/certs/appqos/client_appqos.pem ca-file /etc/ssl/certs/appqos/ca.crt
```

The frontend here remains open to all connections. Please refer to HAProxy documentation to choose convenient method for controlling access to the service. 

Please refer to appqos/examples/haproxy/ directory for more detailed examples.
