ITK Release 3.16
================

This release covers the period May 28 2009 through September 15 2009

New Classes in this Release
---------------------------


    Code/Review/itkAggregateLabelMapFilter
    Code/Review/itkAutoCropLabelMapFilter
    Code/Review/itkBinaryImageToLabelMapFilter
    Code/Review/itkBinaryImageToShapeLabelMapFilter
    Code/Review/itkBinaryImageToStatisticsLabelMapFilter
    Code/Review/itkBinaryShapeKeepNObjectsImageFilter
    Code/Review/itkBinaryShapeOpeningImageFilter
    Code/Review/itkBinaryStatisticsKeepNObjectsImageFilter
    Code/Review/itkBinaryStatisticsOpeningImageFilter
    Code/Review/itkChangeLabelLabelMapFilter
    Code/Review/itkChangeRegionLabelMapFilter
    Code/Review/itkCropLabelMapFilter
    Code/Review/itkInPlaceLabelMapFilter
    Code/Review/itkLabelImageToShapeLabelMapFilter
    Code/Review/itkLabelImageToStatisticsLabelMapFilter
    Code/Review/itkLabelMapToBinaryImageFilter
    Code/Review/itkLabelObjectAccessors
    Code/Review/itkLabelPerimeterEstimationCalculator
    Code/Review/itkLabelShapeKeepNObjectsImageFilter
    Code/Review/itkLabelShapeOpeningImageFilter
    Code/Review/itkLabelStatisticsKeepNObjectsImageFilter
    Code/Review/itkLabelStatisticsOpeningImageFilter
    Code/Review/itkMergeLabelMapFilter
    Code/Review/itkPadLabelMapFilter
    Code/Review/itkRegionFromReferenceLabelMapFilter
    Code/Review/itkRelabelLabelMapFilter
    Code/Review/itkScaleVersor3DTransform
    Code/Review/itkShapeKeepNObjectsLabelMapFilter
    Code/Review/itkShapeLabelMapFilter
    Code/Review/itkShapeLabelObject
    Code/Review/itkShapeLabelObjectAccessors
    Code/Review/itkShapeOpeningLabelMapFilter
    Code/Review/itkShapeRelabelImageFilter
    Code/Review/itkShapeRelabelLabelMapFilter
    Code/Review/itkShapeUniqueLabelMapFilter
    Code/Review/itkShiftScaleLabelMapFilter
    Code/Review/itkStatisticsKeepNObjectsLabelMapFilter
    Code/Review/itkStatisticsLabelMapFilter
    Code/Review/itkStatisticsLabelObject
    Code/Review/itkStatisticsLabelObjectAccessors
    Code/Review/itkStatisticsOpeningLabelMapFilter
    Code/Review/itkStatisticsRelabelImageFilter
    Code/Review/itkStatisticsRelabelLabelMapFilter
    Code/Review/itkStatisticsUniqueLabelMapFilter

New Tests in this Release
-------------------------

    Testing/Code/Common/itkImageFillBufferTest
    Testing/Code/Common/itkMathRoundTest

    Testing/Code/BasicFilters/itkCannyEdgeDetectionImageFilterTest2
    Testing/Code/BasicFilters/itkStreamingImageFilterTest3

    Testing/Code/IO/itkDICOMImageSeriesTest2
    Testing/Code/IO/itkFileFreeImageIO
    Testing/Code/IO/itkFileFreeImageIOFactory
    Testing/Code/IO/itkImageFileReaderDimensionsTest
    Testing/Code/IO/itkImageSeriesReaderDimensionsTest
    Testing/Code/IO/itkIOPluginTest
    Testing/Code/IO/itkLargeImageWriteConvertReadTest

    Testing/Code/Review/itkAggregateLabelMapFilterTest
    Testing/Code/Review/itkAutoCropLabelMapFilterTest1
    Testing/Code/Review/itkBinaryImageToLabelMapFilterTest
    Testing/Code/Review/itkBinaryImageToShapeLabelMapFilterTest1
    Testing/Code/Review/itkBinaryImageToStatisticsLabelMapFilterTest1
    Testing/Code/Review/itkBinaryShapeKeepNObjectsImageFilterTest1
    Testing/Code/Review/itkBinaryShapeOpeningImageFilterTest1
    Testing/Code/Review/itkBinaryStatisticsKeepNObjectsImageFilterTest1
    Testing/Code/Review/itkBinaryStatisticsOpeningImageFilterTest1
    Testing/Code/Review/itkChangeLabelLabelMapFilterTest
    Testing/Code/Review/itkChangeRegionLabelMapFilterTest1
    Testing/Code/Review/itkCropLabelMapFilterTest1
    Testing/Code/Review/itkLabelImageToShapeLabelMapFilterTest1
    Testing/Code/Review/itkLabelImageToStatisticsLabelMapFilterTest1
    Testing/Code/Review/itkLabelMapToBinaryImageFilterTest
    Testing/Code/Review/itkLabelShapeKeepNObjectsImageFilterTest1
    Testing/Code/Review/itkLabelShapeOpeningImageFilterTest1
    Testing/Code/Review/itkLabelStatisticsKeepNObjectsImageFilterTest1
    Testing/Code/Review/itkLabelStatisticsOpeningImageFilterTest1
    Testing/Code/Review/itkMergeLabelMapFilterTest1
    Testing/Code/Review/itkOptMattesMutualInformationImageToImageMetricThreadsTest1
    Testing/Code/Review/itkPadLabelMapFilterTest1
    Testing/Code/Review/itkRegionFromReferenceLabelMapFilterTest1
    Testing/Code/Review/itkRelabelLabelMapFilterTest1
    Testing/Code/Review/itkReviewTests4
    Testing/Code/Review/itkScaleVersor3DTransformTest
    Testing/Code/Review/itkShapeKeepNObjectsLabelMapFilterTest1
    Testing/Code/Review/itkShapeLabelObjectAccessorsTest1
    Testing/Code/Review/itkShapeOpeningLabelMapFilterTest1
    Testing/Code/Review/itkShapeRelabelImageFilterTest1
    Testing/Code/Review/itkShapeRelabelLabelMapFilterTest1
    Testing/Code/Review/itkShapeUniqueLabelMapFilterTest1
    Testing/Code/Review/itkShiftScaleLabelMapFilterTest1
    Testing/Code/Review/itkStatisticsKeepNObjectsLabelMapFilterTest1
    Testing/Code/Review/itkStatisticsOpeningLabelMapFilterTest1
    Testing/Code/Review/itkStatisticsRelabelImageFilterTest1
    Testing/Code/Review/itkStatisticsRelabelLabelMapFilterTest1
    Testing/Code/Review/itkStatisticsUniqueLabelMapFilterTest1

New Examples in this Release
----------------------------


    Examples/Filtering/GrayscaleFunctionDilateImageFilter

    Examples/IO/DicomSeriesReadGaussianImageWrite
    Examples/IO/IOExamples
    Examples/IO/VisibleHumanPasteWrite
    Examples/IO/VisibleHumanStreamReadWrite

New Utilities in this Release
-----------------------------

    Utilities/vxl/core/vnl/Templates/vnl_matrix_fixed+double.5.5-

This release covers the period May 28 2009 through September 15 2009

Changes in this Release
-----------------------


    CMakeLists.txt
        ENH: Increasing minor version number, in preparation for the release of ITK 3.16.
        COMP: To silence linker warnings on cygwin and mingw, added -Wl,--enable-auto-import to linker commands. Also, added CMAKE_SHARED_LIBRARY_CREATE_CXX_FLAGS for mingw.
        STYLE: type Optimizer to Optimized
        ENH: Removed unnecessary ITK_USE_PORTABLE_ROUND cmake variable and added Floor and Ceil functions to itk::Math namespace

    CTestConfig.cmake

    DartConfig.cmake

    itkConfigure.h.in
        ENH: Removed unnecessary ITK_USE_PORTABLE_ROUND cmake variable and added Floor and Ceil functions to itk::Math namespace

    CMake/itkSampleBuildTest.cmake.in
        ENH: Removed unnecessary ITK_USE_PORTABLE_ROUND cmake variable and added Floor and Ceil functions to itk::Math namespace

    Code/Algorithms/itkBinaryMask3DMeshSource
        COMP: Empty instantiation of itk::Image< unsigned short, 3 > trigger a duplicated symbol error during linking several .o files where this file has been included. It doesn't seem to be still needed, maybe since the input image type can be specified.

    Code/Algorithms/itkBioCellularAggregate
        COMP: fix some unitialized points which create a warning with gcc-4.4.0

    Code/Algorithms/itkCurvatureFlowFunction
        BUG: 7567. Should use PixelRealType for intermediate computations.

    Code/Algorithms/itkCurvatureRegistrationFilter
        COMP: fix warnings about unused method parameters, and shadowed declarations of variable.

    Code/Algorithms/itkDeformableSimplexMesh3DGradientConstraintForceFilter
        BUG: Fixing API for setting the input image. It should use the itkSetConstObjectMacro().

    Code/Algorithms/itkFEMRegistrationFilter
        COMP: fix some uninitialized variables for gcc-4.4.0. and return value in operator = for QuadEdgeMeshFrontIterator

    Code/Algorithms/itkFastMarchingUpwindGradientImageFilter
        ENH: for consistency with the other TargetReachedModes, make m_TargetValue reflect the last (largest) value of the Eikonal solution generated while fast marching, instead of keeping it set to zero

    Code/Algorithms/itkFastMarchingUpwindGradientImageFilter
        ENH: for consistency with the other TargetReachedModes, make m_TargetValue reflect the last (largest) value of the Eikonal solution generated while fast marching, instead of keeping it set to zero

    Code/Algorithms/itkImageKmeansModelEstimator
        COMP: Per cppcheck, free locally allocated memory before possibly throwing an exception

    Code/Algorithms/itkImageToImageMetric
        BUG: Fixed a discrepency in the API of the optimized and standard image to image metric. This implies deprecating the use of volatile image masks.

    Code/Algorithms/itkLevelSetMotionRegistrationFilter
        STYLE: Fix the warnings produced by doxygen during WrapITK build.

    Code/Algorithms/itkMRFImageFilter
        ENH: Removed unnecessary ITK_USE_PORTABLE_ROUND cmake variable and added Floor and Ceil functions to itk::Math namespace

    Code/Algorithms/itkMattesMutualInformationImageToImageMetr
        ENH: The test for samples mapping outside of the moving image buffer was too stringent. In the future a method will be added to set this parameter. For now, it is changed from 4 to 16 as suggested by Simon Warfield.

    Code/Algorithms/itkMeanSquaresImageToImageMetric
        STYLE: Improved documentation, MeanSquaresImageToImageMetric really computes the mean of squared differences and not its sum. Thanks to Ramón Casero Cañas for the feedback.

    Code/Algorithms/itkMinMaxCurvatureFlowFunction
        ENH: Removed unnecessary ITK_USE_PORTABLE_ROUND cmake variable and added Floor and Ceil functions to itk::Math namespace

    Code/Algorithms/itkMultiResolutionPyramidImageFilter

    Code/Algorithms/itkRGBGibbsPriorFilter
        COMP: possibly uninitialized variable warning.

    Code/Algorithms/itkRecursiveMultiResolutionPyramidImageFilter

    Code/Algorithms/itkSimplexMeshVolumeCalculator
        COMP: suppress possible uninitialized variable warning.

    Code/Algorithms/itkVoronoiSegmentationImageFilterBase
        COMP: The SetSeeds() method makes wrapitk produce invalid instantiation of std::_Vector_iterator with msvc8 - provide another method which take a whole vector of points, and hide this one when building wrapitk.

    Code/BasicFilters/itkAnisotropicDiffusionImageFilter

    Code/BasicFilters/itkBilateralImageFilter
        STYLE: Changed raw numbers to use vnl's numeric constants
        BUG:2078 and 5692. Removed incorrect floor function and replaced it by itk::Math::Floor

    Code/BasicFilters/itkCannyEdgeDetectionImageFilter
        BUG: 9431 Fix to enable the canny edge detector to produce the correct results when called multiple times. Due to grafting the mini pipeline would be execute correctlya second time. Also the edge list would not always remove elements. STYLE: replaced numeric constants with numeric traits.

    Code/BasicFilters/itkConnectedComponentImageFilter
        BUG: #7739. Output pixel type must be an integer.

    Code/BasicFilters/itkConnectedThresholdImageFilter
        COMP: fixed gcc compiler warning, see bug 4618

    Code/BasicFilters/itkDiscreteGaussianImageFilter
        BUG: the header file was not included

    Code/BasicFilters/itkGaussianImageSource

    Code/BasicFilters/itkGaussianImageSource

    Code/BasicFilters/itkHMaximaImageFilter
        BUG: dynamic cast failure if input and output types for the filter were different. Inserted a CastImageFilter prior to the Graft().

    Code/BasicFilters/itkHMinimaImageFilter
        BUG: dynamic cast failure if input and output types for the filter were different. Inserted a CastImageFilter prior to the Graft().

    Code/BasicFilters/itkNarrowBand
        COMP: Try to resolve type conflict between .h and .txx uncovered by ICC compiler.

    Code/BasicFilters/itkNarrowBand
        COMP: Remove commented code.

    Code/BasicFilters/itkPadImageFilter

    Code/BasicFilters/itkPasteImageFilter

    Code/BasicFilters/itkPasteImageFilter

    Code/BasicFilters/itkRandomImageSource

    Code/BasicFilters/itkRandomImageSource

    Code/BasicFilters/itkRecursiveSeparableImageFilter
        BUG: filter does not manages regions correctly for pipelined streaming. The RecursiveSeparableImageFilter only needs the entire image in the direction that it is separated into. The GenerateInputRequesed region was removed, since the default works, and the EnlargeOutputRequestedRegion was modified to only set the "Direction" dimension to the largest.

    Code/BasicFilters/itkRecursiveSeparableImageFilter
        BUG: filter does not manages regions correctly for pipelined streaming. The RecursiveSeparableImageFilter only needs the entire image in the direction that it is separated into. The GenerateInputRequesed region was removed, since the default works, and the EnlargeOutputRequestedRegion was modified to only set the "Direction" dimension to the largest.

    Code/BasicFilters/itkScalarConnectedComponentImageFilter

    Code/BasicFilters/itkShrinkImageFilter
        BUG: With centered pixels, cygwin was crashing. The input requested region may require an edge to edge sampling.
        STYLE: Changed raw numbers to use vnl's numeric constants

    Code/BasicFilters/itkSignedMaurerDistanceMapImageFilter
        STYLE: Fix the warnings produced by doxygen during WrapITK build.

    Code/BasicFilters/itkSimplexMeshAdaptTopologyFilter
        COMP: fix some uninitialized points. fix shadowed declaration.

    Code/BasicFilters/itkSimplexMeshAdaptTopologyFilter
        COMP: fix some unitialized points which create a warning with gcc-4.4.0

    Code/BasicFilters/itkSimplexMeshToTriangleMeshFilter
        COMP: fix some uninitialized points. fix shadowed declaration.

    Code/BasicFilters/itkVectorGradientMagnitudeImageFilter
        STYLE: Changed raw numbers to use vnl's numeric constants

    Code/Common/itkAffineTransform
        STYLE: Fixed documentation about the parameters of AffineTransform and Rigid3DTransform. The first parameters are the matrix elements in row-major order an not column-major.

    Code/Common/itkAutoPointer
        COMP: operator= is not const in AutoPointer

    Code/Common/itkBSplineInterpolationWeightFunction
        BUG:2078 and 5692. Removed incorrect floor function and replaced it by itk::Math::Floor

    Code/Common/itkCellInterface
        COMP: Try to fix the error about the member functions not declared in the class header while running gccxml.
        COMP: Fix compiler warning about double semicolon.
        COMP: Comment the declaration of GetNextUserCellId - it is not implemented.

    Code/Common/itkCellInterface

    Code/Common/itkCenteredTransformInitializer

    Code/Common/itkCenteredTransformInitializer

    Code/Common/itkCenteredVersorTransformInitializer

    Code/Common/itkCenteredVersorTransformInitializer

    Code/Common/itkCorrespondingMedialNodeClique
        COMP: internal variables were not initialized (it was generating warnings on gcc-4.4.0)

    Code/Common/itkElasticBodySplineKernelTransform
        STYLE: Fix the warnings produced by doxygen during WrapITK build.

    Code/Common/itkFixedArray
        ENH: Added copy constructor for ConstReverseIterator(const ReverseIterator&).
        BUG: Lack of a cast form ReverseIterator to ConstReverseIterator did not allow operator != comparision.

    Code/Common/itkGaussianBlurImageFunction

    Code/Common/itkGaussianDerivativeSpatialFunction
        STYLE: Changed raw numbers to use vnl's numeric constants

    Code/Common/itkIdentityTransform

    Code/Common/itkImage
        COMP: SizeValueType must be declared in itk::Image.

    Code/Common/itkImage

    Code/Common/itkImageBase

    Code/Common/itkImageBase
        COMP: Don't use vxl_uint_64: it is broken on vc60. Remove the check for image size as well for no, as I can't find a portable int 64 type..
        COMP: long long is not portable - using ITK_UINT64 instead.

    Code/Common/itkImageFunction

    Code/Common/itkImageRegion

    Code/Common/itkImageRegion

    Code/Common/itkImageRegionMultidimensionalSplitter
        BUG: 8524 Updated documentation to reflect required usage, note ImageRegionMultidimensionalSplitter is non-functional under many cases

    Code/Common/itkImageRegionSplitter
        BUG: 8524 Updated documentation to reflect required usage, note ImageRegionMultidimensionalSplitter is non-functional under many cases

    Code/Common/itkImageSliceConstIteratorWithIndex
        ENH: Added method to go to the first pixel of the current slice.

    Code/Common/itkImageSliceConstIteratorWithIndex
        ENH: Added method to go to the first pixel of the current slice.

    Code/Common/itkImageSource
        ENH: if Hessian and scales output are not requested, don't initialize the iterators to avoid an exception.  Post a warning if ImageSource's dynamic_cast fails to help others who may have abused the output

    Code/Common/itkIndex
        ENH: Removed unnecessary ITK_USE_PORTABLE_ROUND cmake variable and added Floor and Ceil functions to itk::Math namespace

    Code/Common/itkLineConstIterator

    Code/Common/itkLinearInterpolateImageFunction
        ENH: Re-enable (and fix) optimized linear interpolation when ITK_USE_OPTIMIZED_REGISTRATION_METHODS is turned on

    Code/Common/itkLinearInterpolateImageFunction
        ENH: Re-enable (and fix) optimized linear interpolation when ITK_USE_OPTIMIZED_REGISTRATION_METHODS is turned on

    Code/Common/itkMacro
        ENH: Removed unnecessary ITK_USE_PORTABLE_ROUND cmake variable and added Floor and Ceil functions to itk::Math namespace

    Code/Common/itkMersenneTwisterRandomVariateGenerator
        STYLE: Changed raw numbers to use vnl's numeric constants

    Code/Common/itkMesh

    Code/Common/itkMe

    Code/Common/itkMetaDataObject
        STYLE: Fix missing parameters in docstrings

    Code/Common/itkMultiThreader

    Code/Common/itkNearestNeighborExtrapolateImageFunction
        BUG: changed to compare the clamping values from continuous index type to discrete, to revome extraineous int to double conversion
        BUG: Rounding should be performed before range check on index. Otherwise an index outside of range may be generated. This resulted in numercial exceptioons on Borland and probably produced unreliable results on other platforms.

    Code/Common/itkNumericTraits
        STYLE: Doxygen thinks that <numeric_limits> is a html tags - drop the <> to fix the warning.

    Code/Common/itkNumericTraitsRGBAPixel
        BUG: Use Self instead of RealType for the type returned by max(Self) and min(Self).

    Code/Common/itkNumericTraitsRGBPixel
        BUG: Use Self instead of RealType for the type returned by max(Self) and min(Self).

    Code/Common/itkNumericTraitsVariableLengthVectorPixel
        BUG: Use Self instead of RealType for the type returned by max(Self) and min(Self).

    Code/Common/itkObjectFactoryBase
        COMP: cygwin crashing on dl_close().

    Code/Common/itkPathConstIterator

    Code/Common/itkPoint
        STYLE: parameter must be cited with the exact same in docstring - \alpha is not alpha.

    Code/Common/itkPointSet

    Code/Common/itkRGBAPixel
        BUG: Changed copy constructor to templated copy constuctor like all other ITK array type classes

    Code/Common/itkRigid3DTransform
        STYLE: Fixed documentation about the parameters of AffineTransform and Rigid3DTransform. The first parameters are the matrix elements in row-major order an not column-major.

    Code/Common/itkSimplexMesh

    Code/Common/itkSimplexMe
        COMP: fix some uninitialized points. fix shadowed declaration.

    Code/Common/itkTransform
        COMP: Masked unused param
        BUG: Work-around for visual 6 bug was used for all visual c++ version

    Code/Common/itkTreeIteratorBase
        COMP: Fix build with explicit instantions activated.

    Code/Common/itkTreeIteratorBase
        COMP: Fix build with explicit instantions activated.

    Code/Common/itkVersor
        STYLE: Latex formulae must be enclosed in \f$ tags

    Code/Common/itkVersorTransform
        STYLE: Fix the warnings produced by doxygen during WrapITK build.

    Code/Common/itk_hashtable

    Code/IO/itkBMPImageIO
        ENH: Removed unnecessary ITK_USE_PORTABLE_ROUND cmake variable and added Floor and Ceil functions to itk::Math namespace

    Code/IO/itkConvertPixelBuffer

    Code/IO/itkConvertPixelBuffer

    Code/IO/itkDICOMSeriesFileNames

    Code/IO/itkDICOMSeriesFileNames

    Code/IO/itkGDCMImageIO

    Code/IO/itkGE4ImageIO
        STYLE: Fix the warnings produced by doxygen during WrapITK build.

    Code/IO/itkGE5ImageIO
        STYLE: Fix the warnings produced by doxygen during WrapITK build.

    Code/IO/itkGEAdwImageIO
        STYLE: Fix the warnings produced by doxygen during WrapITK build.

    Code/IO/itkImageFileReader

    Code/IO/itkImageFileReader

        BUG: 9212 When reading a 3D file into a 2D image we must read the first slice. This is the fix to enable this reading by creating a temporary buffer and then copying a subregion into the image output's buffer. Also corrected the size of the temporary buffer for when streaming is occouring, by using the size of the IORegion.

    Code/IO/itkImageFileWriter
        BUG: progress never reached 1.0, this fix does not result in a divide by zero
        BUG: progress never reached 1.0, off by one error on the denominator

    Code/IO/itkImageIOBase
        BUG: 9212 When reading a 3D file into a 2D image we must read the first slice. Added ImageIORegion::GetNumberOfPixels methods, and change the member access control of ImageIOBase::GetComponentSize() from protected to public. This enables the calculation of the size of the ImageIORegion in bytes.

    Code/IO/itkImageIORegion
        BUG: replaced unsigned long with size_t
        BUG: 9212 When reading a 3D file into a 2D image we must read the first slice. Added ImageIORegion::GetNumberOfPixels methods, and change the member access control of ImageIOBase::GetComponentSize() from protected to public. This enables the calculation of the size of the ImageIORegion in bytes.

    Code/IO/itkImageIORegion
        BUG: 9212 When reading a 3D file into a 2D image we must read the first slice. Added ImageIORegion::GetNumberOfPixels methods, and change the member access control of ImageIOBase::GetComponentSize() from protected to public. This enables the calculation of the size of the ImageIORegion in bytes.

    Code/IO/itkImageSeriesReader
        BUG: 9205 and 9149 Added checking when io dimension is greater than the templated dimension, enabled reading on a single ND file to an ND image, adding test to verify most combinations of input file dimensions to output image dimensions, enabled throwing of an exception when reading a series of ND+ files to an ND image

    Code/IO/itkImageSeriesReader
        BUG: 9205 and 9149 Added checking when io dimension is greater than the templated dimension, enabled reading on a single ND file to an ND image, adding test to verify most combinations of input file dimensions to output image dimensions, enabled throwing of an exception when reading a series of ND+ files to an ND image

    Code/IO/itkMetaImageIO
        BUG: When streaming MetaImage::ElementByteOrder would over run buffer, added parameter to tell the library the correct size of the buffer

    Code/IO/itkMetaImageIO
        STYLE: Fix the warnings produced by doxygen during WrapITK build.

    Code/IO/itkNiftiImageIO
        COMP: Fixed compiler error due to inconsistent const correctness.

    Code/IO/itkSiemensVisionImageIO
        STYLE: Fix the warnings produced by doxygen during WrapITK build.

    Code/IO/itkTIFFImageIO
        COMP: Oops. Added fix twice brainless.

    Code/IO/itkTestDriver
        BUG: itkTestDriver must set both LD_LIBRARY_PATH and LD_LIBRARY_PATH_64 to avoid loading unwanted libraries with 64 bit programs.

    Code/Numerics/itkAmoebaOptimizer
        BUG: 0009400. Cost function not set correctly in itkAmoebaOptimizer superclass.

    Code/Numerics/itkAmoebaOptimizer
        ENH: New method for Optimizers, GetStopConditionDescription() returns the reason for the optiimizer termination.

    Code/Numerics/itkCumulativeGaussianOptimizer
        STYLE: Changed raw numbers to use vnl's numeric constants

    Code/Numerics/itkCumulativeGaussianOptimizer
        ENH: New method for Optimizers, GetStopConditionDescription() returns the reason for the optiimizer termination.

    Code/Numerics/itkExhaustiveOptimizer
        ENH: Added GetStopConditionDescription().

    Code/Numerics/itkExhaustiveOptimizer
        ENH: Added GetStopConditionDescription().

    Code/Numerics/itkGradientDescentOptimizer
        ENH: New method for Optimizers, GetStopConditionDescription() returns the reason for the optiimizer termination.

    Code/Numerics/itkGradientDescentOptimizer
        ENH: New method for Optimizers, GetStopConditionDescription() returns the reason for the optiimizer termination.

    Code/Numerics/itkLBFGSBOptimizer
        ENH: New method for Optimizers, GetStopConditionDescription() returns the reason for the optiimizer termination.

    Code/Numerics/itkLBFGSBOptimizer
        ENH: New method for Optimizers, GetStopConditionDescription() returns the reason for the optiimizer termination.

    Code/Numerics/itkLBFGSOptimizer
        ENH: New method for Optimizers, GetStopConditionDescription() returns the reason for the optiimizer termination.

    Code/Numerics/itkLBFGSOptimizer
        ENH: New method for Optimizers, GetStopConditionDescription() returns the reason for the optiimizer termination.

    Code/Numerics/itkLevenbergMarquardtOptimizer
        ENH: New method for Optimizers, GetStopConditionDescription() returns the reason for the optiimizer termination.

    Code/Numerics/itkLevenbergMarquardtOptimizer
        ENH: New method for Optimizers, GetStopConditionDescription() returns the reason for the optiimizer termination.

    Code/Numerics/itkOnePlusOneEvolutionaryOptimizer
        ENH: New method for Optimizers, GetStopConditionDescription() returns the reason for the optiimizer termination.

    Code/Numerics/itkOnePlusOneEvolutionaryOptimizer
        ENH: New method for Optimizers, GetStopConditionDescription() returns the reason for the optiimizer termination.

    Code/Numerics/itkOptimizer
        ENH: New method for Optimizers, GetStopConditionDescription() returns the reason for the optiimizer termination.

    Code/Numerics/itkOptimizer
        ENH: New method for Optimizers, GetStopConditionDescription() returns the reason for the optiimizer termination.

    Code/Numerics/itkPowellOptimizer
        ENH: New method for Optimizers, GetStopConditionDescription() returns the reason for the optiimizer termination.

    Code/Numerics/itkPowellOptimizer
        ENH: New method for Optimizers, GetStopConditionDescription() returns the reason for the optiimizer termination.

    Code/Numerics/itkRegularStepGradientDescentBaseOptimizer
        ENH: New method for Optimizers, GetStopConditionDescription() returns the reason for the optiimizer termination.

    Code/Numerics/itkRegularStepGradientDescentBaseOptimizer
        ENH: New method for Optimizers, GetStopConditionDescription() returns the reason for the optiimizer termination.

    Code/Numerics/itkSPSAOptimizer
        ENH: New method for Optimizers, GetStopConditionDescription() returns the reason for the optiimizer termination.

    Code/Numerics/itkSPSAOptimizer
        ENH: New method for Optimizers, GetStopConditionDescription() returns the reason for the optiimizer termination.

    Code/Numerics/FEM/CMakeLists.txt
    view.php?id=9527 .

    Code/Numerics/Statistics/itkDenseFrequencyContainer

    Code/Numerics/Statistics/itkGaussianDistribution
        STYLE: Changed raw numbers to use vnl's numeric constants

    Code/Numerics/Statistics/itkListSampleToHistogramGenerator
        STYLE:  Fixed spelling errors.

    Code/Numerics/Statistics/itkSparseFrequencyContainer
        COMP: Copy pasting is Evil !,     Evil I tell you...

    Code/Review/itkAggregateLabelMapFilter
        STYLE: Adding reference to the Insight Journal paper.

    Code/Review/itkAggregateLabelMapFilter

    Code/Review/itkAnchorErodeDilateImageFilter
        STYLE: method names should begin with uppercase.

    Code/Review/itkAnchorOpenCloseImageFilter
        STYLE: method names should begin with uppercase.

    Code/Review/itkAreaOpeningImageFilter
        ENH: Adding reference to the Insight Journal paper.

    Code/Review/itkAutoCropLabelMapFilter

    Code/Review/itkAutoCropLabelMapFilter

    Code/Review/itkBinaryImageToLabelMapFilter
        ENH: Replacing instances of evil "long" type with corresponding SizeValueType and OffsetValueType.

    Code/Review/itkBinaryImageToLabelMapFilter
        STYLE: use this to call member functions
        BUG: Last change should have rermoved the NeighIdx >= 0 test completely.
        ENH: Replacing instances of evil "long" type with corresponding SizeValueType and OffsetValueType.
        COMP: VC6 doesn't have std::min. Replaced now with vnl_math_min().

    Code/Review/itkBinaryImageToShapeLabelMapFilter
        STYLE: Line style modifications.

    Code/Review/itkBinaryImageToShapeLabelMapFilter

    Code/Review/itkBinaryImageToStatisticsLabelMapFilter
        COMP: warnings and style. itk:: prefix not required while inside itk namespace. typename not needed when templates are present in typedef.
    584.

    Code/Review/itkBinaryImageToStatisticsLabelMapFilter
    584.

    Code/Review/itkBinaryShapeKeepNObjectsImageFilter
        COMP: numerous Borland compiler issues. Many regarding default template parameters.
    584.

    Code/Review/itkBinaryShapeKeepNObjectsImageFilter

    Code/Review/itkBinaryShapeOpeningImageFilter

        COMP: Issues with Borland compiler and default template  parameters.

    Code/Review/itkBinaryShapeOpeningImageFilter

    Code/Review/itkBinaryStatisticsKeepNObjectsImageFilter
        COMP: numerous Borland compiler issues. Many regarding default template parameters.
    584.

    Code/Review/itkBinaryStatisticsKeepNObjectsImageFilter
    584.

    Code/Review/itkBinaryStatisticsOpeningImageFilter
        COMP: Fix wrong image type. STYLE: Align typedefs.
    584.

    Code/Review/itkBinaryStatisticsOpeningImageFilter

    Code/Review/itkBoxUtilities

    Code/Review/itkBresenhamLine
        STYLE: method names should begin with uppercase.

    Code/Review/itkBresenhamLine
        STYLE: method names should begin with uppercase.

    Code/Review/itkChangeLabelLabelMapFilter
        ENH: Removing unnecessary declartions of TemplatedGenerateData().
        STYLE: Fixing misspelled method name: RestoreLabeObjectsAndChangeLabels().

    Code/Review/itkChangeLabelLabelMapFilter
        STYLE: Fixing misspelled method name: RestoreLabeObjectsAndChangeLabels().
        COMP: On VS6, error C2899: typename cannot be used outside a template declaration

    Code/Review/itkChangeRegionLabelMapFilter
        STYLE: Changes in formatting, remove debug outputs, grammar.

    Code/Review/itkChangeRegionLabelMapFilter
        STYLE: Changes in formatting, remove debug outputs, grammar.

    Code/Review/itkConformalFlatteningMeshFilter
        COMP: Use vcl_sqrt rather than sqrt to avoid  Error: The function "sqrt" must have a prototype on SunOS,

    Code/Review/itkCropLabelMapFilter

    Code/Review/itkCropLabelMapFilter

    Code/Review/itkFFTWComplexToComplexImageFilter
        COMP: removed dummy PrintSelf's.

    Code/Review/itkFFTWComplexToComplexImageFilter
        COMP: removed dummy PrintSelf's.

    Code/Review/itkGeometricalQuadEdge
        COMP: Fix warnings in documentation of QuadEdgeMesh classes

    Code/Review/itkGridForwardWarpImageFilter
        ENH: Removed unnecessary ITK_USE_PORTABLE_ROUND cmake variable and added Floor and Ceil functions to itk::Math namespace

    Code/Review/itkHessianToObjectnessMeasureImageFilter
        BUG: fixed typo in documentation that caused Doxygen to create two entries in the class list.

    Code/Review/itkInPlaceLabelMapFilter
        COMP: PrintSelfI() method was duplicated.

    Code/Review/itkInPlaceLabelMapFilter
        COMP: PrintSelfI() method was duplicated.

    Code/Review/itkLabelContourImageFilter
        ENH: Replace use of "long" with the proper types "SizeValueType" and "OffsetValueType".

    Code/Review/itkLabelContourImageFilter
        BUG: Fix wrong boundary check introduced during the convertion of long to SizeValueType and OffsetValueType and the following warning fixes.
        COMP: warning: comparison of unsigned expression >= 0 is always true

    Code/Review/itkLabelImageToLabelMapFilter
        STYLE: It was missing reference to the Insight Journal paper from which the code was taken.

    Code/Review/itkLabelImageToShapeLabelMapFilter
        COMP: warnings and style. itk:: prefix not required while inside itk namespace. typename not needed when templates are present in typedef.
        COMP: Issues with Borland compiler and default template  parameters.

    Code/Review/itkLabelImageToShapeLabelMapFilter
        ENH: Use method names consitent with LabelImageToLabelMapFilter.

    Code/Review/itkLabelImageToStatisticsLabelMapFilter
        COMP: VS6 issue with using typename outside a template.
    584.

    Code/Review/itkLabelImageToStatisticsLabelMapFilter
    584.

    Code/Review/itkLabelMap
        ENH: Removing std::cout statements that were commented out.

    Code/Review/itkLabelMapFilter
        COMP: Fix missing include

    Code/Review/itkLabelMapFilter

    Code/Review/itkLabelMapToBinaryImageFilter

    Code/Review/itkLabelMapToBinaryImageFilter

    Code/Review/itkLabelMapToLabelImageFilter
        STYLE: Concatenated some lines.

    Code/Review/itkLabelObject
        COMP: enum -> StaticConstMacro
        STYLE: Doxygen expects the "\brief" description to end up in a ".".

    Code/Review/itkLabelObject
        COMP: itk exceptions are preferred over runtime_error. Exception text made more descriptive.
        BUG: CopyAttributesFrom() failed to copt m_Label.

    Code/Review/itkLabelObjectAccessors
        COMP: comparators need both a default constructor and a copy constructor to avoid uninitialized warnings.
        COMP: Fix warning: type qualifiers ignored on function return type with gcc 4.3.
        COMP: Fixed const-correctness of the operator() methods.

    Code/Review/itkLabelObjectLine

    Code/Review/itkLabelObjectLine

    Code/Review/itkLabelOverlayFunctor
        STYLE: Fixed problem with comment.
        ENH: Let the user set its own colors. Patch provided by Martin Kavec.

    Code/Review/itkLabelOverlayImageFilter
        ENH: Let the user set its own colors. Patch provided by Martin Kavec.

    Code/Review/itkLabelOverlayImageFilter
        ENH: Let the user set its own colors. Patch provided by Martin Kavec.

    Code/Review/itkLabelPerimeterEstimationCalculator

    Code/Review/itkLabelPerimeterEstimationCalculator

    Code/Review/itkLabelShapeKeepNObjectsImageFilter
        COMP: numerous Borland compiler issues. Many regarding default template parameters.
    584.

    Code/Review/itkLabelShapeKeepNObjectsImageFilter
    584.

    Code/Review/itkLabelShapeOpeningImageFilter
        COMP: numerous Borland compiler issues. Many regarding default template parameters.
    584.

    Code/Review/itkLabelShapeOpeningImageFilter
    584.

    Code/Review/itkLabelStatisticsKeepNObjectsImageFilter
        COMP: warnings and style. itk:: prefix not required while inside itk namespace. typename not needed when templates are present in typedef.
        COMP: Fix const correctness.

    Code/Review/itkLabelStatisticsKeepNObjectsImageFilter
    584.

    Code/Review/itkLabelStatisticsOpeningImageFilter
        COMP: warnings and style. itk:: prefix not required while inside itk namespace. typename not needed when templates are present in typedef.
    584.

    Code/Review/itkLabelStatisticsOpeningImageFilter
    584.

    Code/Review/itkLabelToRGBFunctor
        ENH: Let the user set its own colors. Patch provided by Martin Kavec.

    Code/Review/itkLabelToRGBImageFilter
        ENH: Let the user set its own colors. Patch provided by Martin Kavec.

    Code/Review/itkLabelToRGBImageFilter
        ENH: Let the user set its own colors. Patch provided by Martin Kavec.

    Code/Review/itkMaskedRankImageFilter
        STYLE: method names should begin with uppercase.

    Code/Review/itkMaskedRankImageFilter
        STYLE: method names should begin with uppercase.

    Code/Review/itkMergeLabelMapFilter
        STYLE: Edited style and spacing in header file.
        COMP: STRICT is defined on some systems (e.g. Borland). Must undef it before use in enum.

    Code/Review/itkMergeLabelMapFilter

    Code/Review/itkMovingHistogramImageFilter
        STYLE: method names should begin with uppercase.

    Code/Review/itkMovingHistogramImageFilter
        STYLE: method names should begin with uppercase.

    Code/Review/itkMovingHistogramMorphologicalGradientImageFilter
        STYLE: method names should begin with uppercase.

    Code/Review/itkMovingHistogramMorphologyImageFilter
        STYLE: method names should begin with uppercase.

    Code/Review/itkMultiScaleHessianBasedMeasureImageFilter
        ENH: if Hessian and scales output are not requested, don't initialize the iterators to avoid an exception.  Post a warning if ImageSource's dynamic_cast fails to help others who may have abused the output

    Code/Review/itkMultiphaseDenseFiniteDifferenceImageFilter
        ENH: Pass TInputImage as template parameters to the parents class. Allows FeatureImage and OutputImage to be unsigned char. Reduces memory usage.

    Code/Review/itkMultiphaseDenseFiniteDifferenceImageFilter
        ENH: Pass TInputImage as template parameters to the parents class. Allows FeatureImage and OutputImage to be unsigned char. Reduces memory usage.

    Code/Review/itkMultiphaseFiniteDifferenceImageFilter
        ENH: Pass TInputImage as template parameters to the parents class. Allows FeatureImage and OutputImage to be unsigned char. Reduces memory usage.

    Code/Review/itkMultiphaseFiniteDifferenceImageFilter
        ENH: Computing the RMS change values after reinitialization to signed distance functions
        ENH: Eliminated AllocateUpdateBuffer() method, simplified some code and added comments
        PERF: Corrected initialization statements in constructor and Removed redundant initialization statements

    Code/Review/itkMultiphaseSparseFiniteDifferenceImageFilter
        ENH: Computing the RMS change values after reinitialization to signed distance functions
        ENH: Eliminated the usage of m_ShiftedImage. Reduces memory footprint.
        ENH: Updating non-sparse field layer pixels to get re-assigned to BackgroundValue
        STYLE: Made some simple changes including variable renaming and adding comments

    Code/Review/itkMultiphaseSparseFiniteDifferenceImageFilter
        BUG: m_PixelDistance subscript out of bounds
        ENH: Comparison between unsigned char and double
        BUG: container issues. Accessing containers outside of their size.
        ENH: gradientMagnitude initialized but never used
        BUG: Sparse-field pixels being added multiple times to the lists. Added more code comments.
        ENH: Correct sparse initialization to take into account image spacing
        BUG: m_RMSChange being re-initialized to 0 in derived class constructor

    Code/Review/itkOptImageToImageMetric
        BUG: Fixed a discrepency in the API of the optimized and standard image to image metric. This implies deprecating the use of volatile image masks.
        BUG: 0009398 removed boolean value that caused backwards compatibility issues.
        COMP: Used itkNotUsed to eliminate unused var (param) warnings
        STYLE: itkSingleValuedCostFunction.h was included twice
        BUG:0009139: Fixed a test that fails because the number of samples is internally reduced when the fixed image mask is smaller than the number of samples requested.  This leads to an inconsistent initialization of several variables.  The solution listed in bug 0009139 ensures that all internal arrays are re-initialized to the correct length if this internal reduction in samples occurs.

    Code/Review/itkOptImageToImageMetr
        BUG: If user called "UseAllSamples" and then called "SetNumberOfSamples(N)" and passed a value for N that is less than the total number of pixels in the image, the metric would use the first N pixels (in order) from the image.  That is not expected behavior and has been changed to use random sampling if N is less than the total number of pixels in the image
        BUG: 0009398 removed boolean value that caused backwards compatibility issues.
        COMP: Removed debugging cout statements that were accidentally left-in
        BUG: SetNumberOfThreads must check to see if the multithreader accepts the number of threads. For example, on mingw, the maximum number of threads is 1.

    Code/Review/itkOptLinearInterpolateImageFunction
        ENH: Re-enable (and fix) optimized linear interpolation when ITK_USE_OPTIMIZED_REGISTRATION_METHODS is turned on

    Code/Review/itkOptLinearInterpolateImageFunction
        ENH: Re-enable (and fix) optimized linear interpolation when ITK_USE_OPTIMIZED_REGISTRATION_METHODS is turned on

    Code/Review/itkOptMattesMutualInformationImageToImageMetric

    Code/Review/itkOptMattesMutualInformationImageToImageMetr
        ENH: The test for samples mapping outside of the moving image buffer was too stringent. In the future a method will be added to set this parameter. For now, it is changed from 4 to 16 as suggested by Simon Warfield.

    Code/Review/itkOptMeanSquaresImageToImageMetr
        BUG: If user called "UseAllSamples" and then called "SetNumberOfSamples(N)" and passed a value for N that is less than the total number of pixels in the image, the metric would use the first N pixels (in order) from the image.  That is not expected behavior and has been changed to use random sampling if N is less than the total number of pixels in the image

    Code/Review/itkOptResampleImageFilter
        BUG: the input largest possible region should not be set in GenerateInputRequestedRegion, simplified methods to call SetRequestedRegionToLargestPossible

    Code/Review/itkPadLabelMapFilter

    Code/Review/itkPadLabelMapFilter

    Code/Review/itkQuadEdge
        COMP: Fix warnings in documentation of QuadEdgeMesh classes

    Code/Review/itkQuadEdgeCellTraitsInfo
        ENH: Provide some default values to make the wrapping easier.

    Code/Review/itkQuadEdgeMesh
        COMP: Fix warnings in documentation of QuadEdgeMesh classes
        COMP: Hide the method which are exposing BoundaryAssignmentsContainer to avoid building that broken type. BoundaryAssignmentsContainer::Reserve() won't build with a non numeric type used as key type.

    Code/Review/itkQuadEdgeMe

    Code/Review/itkQuadEdgeMeshFrontIterator
        COMP: Add missing GetMesh()
        COMP: missing return this at the end of the method.

    Code/Review/itkQuadEdgeMeshLineCell
        COMP: Drop the broken New() method

    Code/Review/itkQuadEdgeMeshLineCell
        COMP: Drop the broken New() method

    Code/Review/itkQuadEdgeMeshPoint
        COMP: Fix warnings in documentation of QuadEdgeMesh classes
        COMP: QuadEdgeMeshPoint is not limited to dimension 3.

    Code/Review/itkQuadEdgeMeshScalarDataVTKPolyDataWriter

    Code/Review/itkQuadEdgeMeshScalarDataVTKPolyDataWriter

    Code/Review/itkQuadEdgeMeshToQuadEdgeMeshFilter

    Code/Review/itkQuadEdgeMeshToQuadEdgeMeshFilter
        COMP: remove unnecessary ';' at the end of line 197

    Code/Review/itkRankImageFilter
        STYLE: method names should begin with uppercase.

    Code/Review/itkRankImageFilter
        STYLE: method names should begin with uppercase.

    Code/Review/itkRegionBasedLevelSetFunction
        ENH: Added advection term to the update
        ENH: Corrected curvature regularization formula and reinitialization formula
        STYLE: Added documentation, reference and some notes
        STYLE: Added a few comments and deleted unnecessary lines

    Code/Review/itkRegionBasedLevelSetFunction
        ENH: Included m_AdvectionChange update
        ENH: Added advection term to support geodesic active contours
        ENH: Used image spacing in computing derivatives
        STYLE: Added a few comments and deleted unnecessary lines

    Code/Review/itkRegionBasedLevelSetFunctionData
        STYLE: Added a few comments and deleted unnecessary lines

    Code/Review/itkRegionBasedLevelSetFunctionData

    Code/Review/itkRegionFromReferenceLabelMapFilter
        COMP: Addressing compilation error in Borland, regarding use of ImageDimension without the itkGetStaticConstMacro().

    Code/Review/itkRegionFromReferenceLabelMapFilter

    Code/Review/itkRelabelLabelMapFilter
        COMP: shadowed type warning for LabelObjectContainerType.

    Code/Review/itkRelabelLabelMapFilter
        COMP: shadowed type warning for LabelObjectContainerType.

    Code/Review/itkScalarChanAndVeseDenseLevelSetImageFilter
        ENH: Pass TInputImage as template parameters to the parents class. Allows FeatureImage and OutputImage to be unsigned char. Reduces memory usage.

    Code/Review/itkScalarChanAndVeseDenseLevelSetImageFilter
        ENH: Added advection term to the update
        STYLE: Made some simple changes including variable renaming and adding comments

    Code/Review/itkScalarChanAndVeseLevelSetFunction
        STYLE: Added documentation, reference and some notes

    Code/Review/itkScalarChanAndVeseLevelSetFunction
        STYLE: Added documentation, reference and some notes
        BUG: Corrected formula for computing product term in ComputeOverlapTerms()
        BUG: in the foreground constant calculation.

    Code/Review/itkScalarChanAndVeseSparseLevelSetImageFilter
        ENH: Pass TInputImage as template parameters to the parents class. Allows FeatureImage and OutputImage to be unsigned char. Reduces memory usage.
        STYLE: Made some simple changes including variable renaming and adding comments

    Code/Review/itkScalarChanAndVeseSparseLevelSetImageFilter
        ENH: Added advection term to the update
        BUG: Sparse-field pixels being added multiple times to the lists. Added more code comments.
        STYLE: fix inconsistency in the template argument name as mentionned by Sgouritsa Eleni.

    Code/Review/itkScalarRegionBasedLevelSetFunction
        STYLE: Added documentation, reference and some notes

    Code/Review/itkScalarRegionBasedLevelSetFunction
        BUG: Sparse-field pixels being added multiple times to the lists. Added more code comments.
        STYLE: Added documentation, reference and some notes
        BUG: Corrected formula for computing product term in ComputeOverlapTerms()

    Code/Review/itkScaleVersor3DTransform

    Code/Review/itkScaleVersor3DTransform

    Code/Review/itkShapeKeepNObjectsLabelMapFilter
        COMP: shadowed variable warnings resolved.

    Code/Review/itkShapeKeepNObjectsLabelMapFilter

    Code/Review/itkShapeLabelMapFilter
        COMP: warnings and style. itk:: prefix not required while inside itk namespace. typename not needed when templates are present in typedef.
        STYLE: Several style issues. Member functions should start with upper case. Utility functions moved to private area. Reformatted comments to fit lines. PI replaced with vnl_math::pi.

    Code/Review/itkShapeLabelMapFilter
        STYLE: Several style issues. Member functions should start with upper case. Utility functions moved to private area. Reformatted comments to fit lines. PI replaced with vnl_math::pi.
        COMP: std::min and std::max are not present on all itk supported compilers. Use vnl_math_min() and vnl_math_max() instead.

    Code/Review/itkShapeLabelObject
        COMP: warnings and style. itk:: prefix not required while inside itk namespace. typename not needed when templates are present in typedef.
        COMP:   static const AttributeType BINARY_FLATNESS=117 is not portable across ITK supported comppilers. Instead use itkStaticConstMacro(BINARY_FLATNESS, AttributeType, 117).

    Code/Review/itkShapeLabelObjectAccessors
        COMP: Fix warning: type qualifiers ignored on function return type with gcc 4.3.
        ENH: Missing accessor for Region added.

    Code/Review/itkShapeOpeningLabelMapFilter
        COMP: LabelObjectType definition shadowed the same one in this.

    Code/Review/itkShapeOpeningLabelMapFilter
        COMP: It was missing the ShapeLabelObjectAccessors header.

    Code/Review/itkShapeRelabelImageFilter
        COMP: numerous Borland compiler issues. Many regarding default template parameters.
    584.

    Code/Review/itkShapeRelabelImageFilter
    584.

    Code/Review/itkShapeRelabelLabelMapFilter
        COMP: shadowed variable warnings.
        COMP: Fixing typename issue in VS60.
        STYLE: Adjusted indents for variables.

    Code/Review/itkShapeRelabelLabelMapFilter

    Code/Review/itkShapeUniqueLabelMapFilter
        COMP: warnings and style. itk:: prefix not required while inside itk namespace. typename not needed when templates are present in typedef.
        COMP: Fix wrong type used - AttributeType instead of AttributeValueType.
    584.

    Code/Review/itkShapeUniqueLabelMapFilter
    584.

    Code/Review/itkShiftScaleLabelMapFilter
        ENH: Removing unnecessary declartions of TemplatedGenerateData().
        COMP: shadowed type warning for LabelObjectContainerType.

    Code/Review/itkShiftScaleLabelMapFilter
        COMP: shadowed type warning for LabelObjectContainerType.

    Code/Review/itkSinRegularizedHeavisideStepFunction
        PERF: Corrected the if statement operator from > to >=

    Code/Review/itkSliceBySliceImageFilter
        ENH: There's no need to know the input type of the output filter, so use ImageSource as output filter type.

    Code/Review/itkStatisticsKeepNObjectsLabelMapFilter
        COMP: Accessors should be included there.

    Code/Review/itkStatisticsKeepNObjectsLabelMapFilter
    584.

    Code/Review/itkStatisticsLabelMapFilter
        COMP: numerous Borland compiler issues. Many regarding default template parameters.

    Code/Review/itkStatisticsLabelMapFilter
        BUG: for the new statistics framework, you MUST set the size of the measurement vector.
        ENH: Added code to work with new statistics classes.

    Code/Review/itkStatisticsLabelObject
        COMP: numerous Borland compiler issues. Many regarding default template parameters.

    Code/Review/itkStatisticsLabelObjectAccessors
        COMP: Fix warning: type qualifiers ignored on function return type with gcc 4.3.
        COMP: Accessors functions must be const.

    Code/Review/itkStatisticsOpeningLabelMapFilter
        COMP: Accessors should be included there.

    Code/Review/itkStatisticsOpeningLabelMapFilter
    584.

    Code/Review/itkStatisticsRelabelImageFilter
        COMP: warnings and style. itk:: prefix not required while inside itk namespace. typename not needed when templates are present in typedef.
    584.

    Code/Review/itkStatisticsRelabelImageFilter
    584.

    Code/Review/itkStatisticsRelabelLabelMapFilter
        COMP: Accessors should be included there.

    Code/Review/itkStatisticsRelabelLabelMapFilter
    584.

    Code/Review/itkStatisticsUniqueLabelMapFilter
    584.

    Code/Review/itkStatisticsUniqueLabelMapFilter
    584.

    Code/Review/itkTransformFileWriterWithFactory
        BUG: Append Mode wasn't being propogated to the TransformIO classes

    Code/Review/itkVTKPolyDataReader
        ENH: Better error checking. If EOF is reached after POINT_DATA keyword, an exception is thrown.

    Code/Review/itkVanHerkGilWermanErodeDilateImageFilter
        STYLE: method names should begin with uppercase.

    Code/Review/Statistics/CMakeLists.txt

    Code/Review/Statistics/itkChiSquareDistribution
        COMP: Use vcl_ versions of pow, sqrt, log and exp to fix build with sun studio

    Code/Review/Statistics/itkGaussianDistribution
        COMP: Use vcl_ versions of pow, sqrt, log and exp to fix build with sun studio

    Code/Review/Statistics/itkGaussianMembershipFunction
        COMP: Use vcl_ versions of pqrt, nd  fabsto fix build with sun studio

    Code/Review/Statistics/itkImageClassifierFilter
        BUG: wrong Superclass or itkTypeMacro superclass.

    Code/Review/Statistics/itkImageToHistogramFilter
        BUG: 6840 Adding test which runs ImageFileReader::DoConvertBuffer with the number of pixel > INT_MAX

    Code/Review/Statistics/itkKdTreeBasedKmeansEstimator
        BUG: wrong Superclass or itkTypeMacro superclass.

    Code/Review/Statistics/itkManhattanDistanceMetr
        COMP: Use vcl_ versions of pqrt, nd  fabsto fix build with sun studio

    Code/Review/Statistics/itkMaximumDecisionRule2
        BUG: wrong Superclass or itkTypeMacro superclass.

    Code/Review/Statistics/itkMeasurementVectorTraits

    Code/Review/Statistics/itkMinimumDecisionRule2
        BUG: wrong Superclass or itkTypeMacro superclass.

    Code/Review/Statistics/itkScalarImageToHistogramGenerator

    Code/Review/Statistics/itkScalarImageToHistogramGenerator
        COMP: accomodate some API drift in the Review directory

    Code/Review/Statistics/itkScalarImageToTextureFeaturesFilter
        BUG: wrong Superclass or itkTypeMacro superclass.

    Code/Review/Statistics/itkSubsample
        BUG: wrong Superclass or itkTypeMacro superclass.

    Code/Review/Statistics/itkTDistribution
        COMP: Use vcl_ versions of pow, sqrt, log and exp to fix build with sun studio

    Documentation/Doxygen/DoxygenStyle.css

    Examples/CMakeLists.txt
        ENH: added examples for chan and vesse in the not-empty-anymore Review Subdir.

    Examples/Filtering/CMakeLists.txt
        COMP: ResampleImageFilter7Test  --compareNumberOfPixelsTolerance 1
        BUG: 6558. Fix to CMakeLists.txt addresses failing test ResampleImageFilter3Test1. Mistype of regression data for pixel-centered coordinates case.

    Examples/Filtering/GrayscaleFunctionDilateImageFilter
        ENH: Adding an example on the user of the itkGrayscaleFunctionDilateImageFilter.

    Examples/IO/CMakeLists.txt
        ENH: enabled the VisibleHuman IO examples to be tests

    Examples/IO/DicomSeriesReadGaussianImageWrite

    Examples/IO/IOExamples
        ENH: enabled the VisibleHuman IO examples to be tests

    Examples/IO/ImageReadExtractFilterInsertWrite

    Examples/IO/VisibleHumanPasteWrite
        ENH: enabled the VisibleHuman IO examples to be tests
        COMP: fixed unused parameter compiler warning

    Examples/IO/VisibleHumanStreamReadWrite
        ENH: enabled the VisibleHuman IO examples to be tests
        ENH: adding examples for IO streaming VisibleHumanStreamReadWrite.cxx: This illustrates how to read the Visible Male, and how to use IO streaming to process a 16GB data set using only 50MB of memory. VisibleHumanPasteWrite.cxx: Which primarily show how to utilized pasting streaming to an output image. Also added another CMake variable will be need to point to this data: ITK_VISIBLEHUMAN_DATA_ROOT

    Examples/Iterators/ImageRegionIterator
        ENH: Replacing overcrowded "for" loop with a clearer verbose "while" loop.

    Examples/Registration/CMakeLists.txt
        COMP: For ImageRegistration12Test, increase pixel compare tolerance to 2. Needed after bug fix to optimized metric.

    Examples/Registration/DeformableRegistration12
        ENH: Added GetStopConditionDescription().

    Examples/Registration/DeformableRegistration13
        ENH: Added GetStopConditionDescription().

    Examples/Registration/DeformableRegistration14
        ENH: Added GetStopConditionDescription().

    Examples/Registration/DeformableRegistration15
        ENH: Added GetStopConditionDescription().

    Examples/Registration/DeformableRegistration4
        ENH: Added GetStopConditionDescription().

    Examples/Registration/DeformableRegistration6
        ENH: Added GetStopConditionDescription().

    Examples/Registration/DeformableRegistration7
        ENH: Added GetStopConditionDescription().

    Examples/Registration/DeformableRegistration8
        ENH: Added GetStopConditionDescription().

    Examples/Registration/ImageRegistration10
        ENH: Added GetStopConditionDescription().

    Examples/Registration/ImageRegistration11
        ENH: Added GetStopConditionDescription().

    Examples/Registration/ImageRegistration12
        ENH: Added GetStopConditionDescription().

    Examples/Registration/ImageRegistration13
        ENH: Added GetStopConditionDescription().

    Examples/Registration/ImageRegistration14
        ENH: Added GetStopConditionDescription().

    Examples/Registration/ImageRegistration15
        ENH: Added GetStopConditionDescription().

    Examples/Registration/ImageRegistration16
        ENH: Added GetStopConditionDescription().

    Examples/Registration/ImageRegistration17
        ENH: Added GetStopConditionDescription().

    Examples/Registration/ImageRegistration18
        ENH: Added GetStopConditionDescription().

    Examples/Registration/ImageRegistration2
        ENH: Added GetStopConditionDescription().

    Examples/Registration/ImageRegistration2o
        ENH: Added GetStopConditionDescription().

    Examples/Registration/ImageRegistration3
        ENH: Added GetStopConditionDescription().

    Examples/Registration/ImageRegistration3o
        ENH: Added GetStopConditionDescription().

    Examples/Registration/ImageRegistration4
        ENH: Added GetStopConditionDescription().

    Examples/Registration/ImageRegistration4o
        ENH: Added GetStopConditionDescription().

    Examples/Registration/ImageRegistration5
        ENH: Added GetStopConditionDescription().

    Examples/Registration/ImageRegistration5o
        ENH: Added GetStopConditionDescription().

    Examples/Registration/ImageRegistration6
        ENH: Added GetStopConditionDescription().

    Examples/Registration/ImageRegistration6o
        ENH: Added GetStopConditionDescription().

    Examples/Registration/ImageRegistration7
        ENH: Added GetStopConditionDescription().

    Examples/Registration/ImageRegistration7o
        ENH: Added GetStopConditionDescription().

    Examples/Registration/ImageRegistration8
        ENH: Added GetStopConditionDescription().

    Examples/Registration/ImageRegistration9
        ENH: Added GetStopConditionDescription().

    Examples/Registration/ImageRegistrationHistogramPlotter
        ENH: Added GetStopConditionDescription().

    Examples/Registration/ModelToImageRegistration1
        ENH: Added GetStopConditionDescription().

    Examples/Registration/ModelToImageRegistration2
        ENH: Added GetStopConditionDescription().

    Examples/Registration/MultiResImageRegistration1
        ENH: Added GetStopConditionDescription().

    Examples/Registration/MultiResImageRegistration2
        ENH: Added GetStopConditionDescription().

    Examples/Registration/MultiResImageRegistration3
        ENH: Added GetStopConditionDescription().

    Examples/Review/CMakeLists.txt
        ENH: added examples for chan and vesse in the not-empty-anymore Review Subdir. Tested under Mac, see corresponding experimental submission.

    Examples/Review/itkScalarSinglePhaseDense2DTest
        ENH: added examples for chan and vesse in the not-empty-anymore Review Subdir. Tested under Mac, see corresponding experimental submission.

    Examples/Review/itkScalarSinglePhaseSparse2DTest
        ENH: added examples for chan and vesse in the not-empty-anymore Review Subdir. Tested under Mac, see corresponding experimental submission.

    Examples/Segmentation/ThresholdSegmentationLevelSetImageFilter

    Examples/SpatialObjects/SpatialObjectToImageStatisticsCalculator

    Examples/Statistics/ImageToListAdaptor

    Testing/Code/Algorithms/CMakeLists.txt

    Testing/Code/Algorithms/itkCompareHistogramImageToImageMetricTest

    Testing/Code/Algorithms/itkCorrelationCoefficientHistogramImageToImageMetricTest

    Testing/Code/Algorithms/itkCurvatureFlowTest

    Testing/Code/Algorithms/itkCurvatureRegistrationFilterTest

    Testing/Code/Algorithms/itkDemonsRegistrationFilterTest

    Testing/Code/Algorithms/itkFEMRegistrationFilterTest

    Testing/Code/Algorithms/itkFFTTest

    Testing/Code/Algorithms/itkGradientDifferenceImageToImageMetricTest

    Testing/Code/Algorithms/itkHistogramImageToImageMetricTest

    Testing/Code/Algorithms/itkImageRegistrationMethodTest_13
        COMP: Adjust parameters to get a portable solution.

    Testing/Code/Algorithms/itkMIRegistrationFunctionTest

    Testing/Code/Algorithms/itkMattesMutualInformationImageToImageMetricTest
        BUG: Fixed a discrepency in the API of the optimized and standard image to image metric. This implies deprecating the use of volatile image masks.
        BUG:0009139: Added a test that fails because the number of samples is internally reduced when the fixed image mask is smaller than the number of samples requested.  This leads to an inconsistent initialization of several variables.  The solution listed in bug 0009139 ensures that all internal arrays are re-initialized to the correct length if this internal reduction in samples occurs.
        BUG: GetNumberOfMovingImageSamples() is only available if  ITK_USE_OPTIMIZED_REGISTRATION_METHODS is defined.

    Testing/Code/Algorithms/itkMeanReciprocalSquareDifferenceImageMetricTest

    Testing/Code/Algorithms/itkMeanReciprocalSquareDifferencePointSetToImageMetricTest

    Testing/Code/Algorithms/itkMeanSquaresHistogramImageToImageMetricTest

    Testing/Code/Algorithms/itkMeanSquaresImageMetricTest

    Testing/Code/Algorithms/itkMeanSquaresPointSetToImageMetricTest

    Testing/Code/Algorithms/itkMultiResolutionPDEDeformableRegistrationTest
        BUG: Pyramid should use ShrinkimageFilter.

    Testing/Code/Algorithms/itkMutualInformationHistogramImageToImageMetricTest

    Testing/Code/Algorithms/itkNormalizedCorrelationImageMetricTest

    Testing/Code/Algorithms/itkNormalizedCorrelationPointSetToImageMetricTest

    Testing/Code/Algorithms/itkNormalizedMutualInformationHistogramImageToImageMetricTest

    Testing/Code/Algorithms/itkRegularSphereMeshSourceTest
        COMP: fix some unitialized points which create a warning with gcc-4.4.0

    Testing/Code/Algorithms/itkSymmetricForcesDemonsRegistrationFilterTest

    Testing/Code/BasicFilters/CMakeLists.txt
        BUG: 9431 adding test for the canny edge filter which runs the filter multiple times and expects the same output
        BUG: itkStreamingImageFilterTest3_2 was refering to the wrong test image

    Testing/Code/BasicFilters/itkBSplineDecompositionImageFilterTest

    Testing/Code/BasicFilters/itkBSplineResampleImageFunctionTest

    Testing/Code/BasicFilters/itkBasicFiltersTests
        BUG: 9431 adding test for the canny edge filter which runs the filter multiple times and expects the same output

    Testing/Code/BasicFilters/itkBasicFiltersTests2
        BUG: 8524 adding test to reproduce, this test illustrates problems with itkImageRegionMultidimensionalSplitter, specifically GetNumberOfSplits not returning the correct value add the latter splitting not being performed with the same number of splits

    Testing/Code/BasicFilters/itkBinaryMedianImageFilterTest

    Testing/Code/BasicFilters/itkBinaryThresholdImageFilterTest

    Testing/Code/BasicFilters/itkBloxBoundaryPointImageTest

    Testing/Code/BasicFilters/itkBloxBoundaryPointImageToBloxBoundaryProfileImageFilterTest

    Testing/Code/BasicFilters/itkBloxBoundaryProfileImageToBloxCoreAtomImageFilterTest

    Testing/Code/BasicFilters/itkBloxCoreAtomTest

    Testing/Code/BasicFilters/itkCannyEdgeDetectionImageFilterTest2
        BUG: 9431 adding test for the canny edge filter which runs the filter multiple times and expects the same output

    Testing/Code/BasicFilters/itkChangeLabelImageFilterTest

    Testing/Code/BasicFilters/itkCheckerBoardImageFilterTest
        ENH: reduced output of test.

    Testing/Code/BasicFilters/itkConstantPadImageTest

    Testing/Code/BasicFilters/itkDifferenceOfGaussiansGradientTest

    Testing/Code/BasicFilters/itkFlipImageFilterTest
        ENH: Removed unnecessary ITK_USE_PORTABLE_ROUND cmake variable and added Floor and Ceil functions to itk::Math namespace

    Testing/Code/BasicFilters/itkFloodFillIteratorTest

    Testing/Code/BasicFilters/itkGaussianImageSourceTest

    Testing/Code/BasicFilters/itkHMaximaMinimaImageFilterTest
        ENH: Changed test so that HMaxima and HMinima have input image types that differ from the output image types.

    Testing/Code/BasicFilters/itkImportImageTest
        BUG: 6558. Correct previous commit, which had a mistype in ITK_USE_CENTERED_PIXEL_COORDINATES_CONSISTENTLY off section.

    Testing/Code/BasicFilters/itkIntensityWindowingImageFilterTest

    Testing/Code/BasicFilters/itkInterpolateImagePointsFilterTest

    Testing/Code/BasicFilters/itkMeanImageFilterTest

    Testing/Code/BasicFilters/itkMedianImageFilterTest

    Testing/Code/BasicFilters/itkMirrorPadImageTest

    Testing/Code/BasicFilters/itkNarrowBandImageFilterBaseTest

    Testing/Code/BasicFilters/itkNormalizeImageFilterTest

    Testing/Code/BasicFilters/itkReleaseDataFilterTest

    Testing/Code/BasicFilters/itkRescaleIntensityImageFilterTest

    Testing/Code/BasicFilters/itkShiftScaleImageFilterTest

    Testing/Code/BasicFilters/itkShiftScaleInPlaceImageFilterTest

    Testing/Code/BasicFilters/itkShrinkImagePreserveObjectPhysicalLocations

    Testing/Code/BasicFilters/itkSpatialFunctionImageEvaluatorFilterTest

    Testing/Code/BasicFilters/itkStatisticsImageFilterTest

    Testing/Code/BasicFilters/itkStreamingImageFilterTest2
        STYLE: 6558. Commented out section, mistakenly left in, taken out completely.

    Testing/Code/BasicFilters/itkStreamingImageFilterTest3
        BUG: 8524 adding test to reproduce, this test illustrates problems with itkImageRegionMultidimensionalSplitter, specifically GetNumberOfSplits not returning the correct value add the latter splitting not being performed with the same number of splits

    Testing/Code/BasicFilters/itkThresholdImageFilterTest

    Testing/Code/BasicFilters/itkTwoOutputExampleImageFilterTest

    Testing/Code/BasicFilters/itkVotingBinaryHoleFillingImageFilterTest

    Testing/Code/BasicFilters/itkVotingBinaryImageFilterTest

    Testing/Code/BasicFilters/itkVotingBinaryIterativeHoleFillingImageFilterTest

    Testing/Code/BasicFilters/itkWarpImageFilterTest
        COMP:  Removed compiler warnings.
        COMP: unused parameter warnings,

    Testing/Code/BasicFilters/itkWarpVectorImageFilterTest
        COMP:  Removed compiler warnings.
        BUG: 6558. Previous commit had a build warning. Now taken care of.

    Testing/Code/BasicFilters/itkWrapPadImageTest

    Testing/Code/Common/CMakeLists.txt
        ENH: Added a unit test for portable rounding functions

    Testing/Code/Common/itkBSplineInterpolationWeightFunctionTest

    Testing/Code/Common/itkCenteredVersorTransformInitializerTest
        ENH: Updating the test, now that we actually compute the rotation from the image moments.

    Testing/Code/Common/itkCommonTests2
        ENH: Added a unit test for portable rounding functions

    Testing/Code/Common/itkFixedArrayTest
        ENH: cover the reverse iteartors.
        ENH: Added tests for reverse iterators.

    Testing/Code/Common/itkFloodFilledSpatialFunctionTest

    Testing/Code/Common/itkImageFillBufferTest
        COMP: Don't use vxl_uint_64: it is broken on vc60. Remove the check for image size as well for no, as I can't find a portable int 64 type..
        COMP: long long is not portable - using ITK_UINT64 instead.

    Testing/Code/Common/itkMathRoundProfileTest1
        BUG: 6558. New itkMathRoundProfileTest1.cxx that accounts for changes in rounding due to  ITK_USE_PORTABLE_ROUND flag.

    Testing/Code/Common/itkMathRoundTest
        STYLE: Some debug information that was printed out in MathRoundTest was wrong. The test itself is not changed.
        ENH: Added a unit test for portable rounding functions

    Testing/Code/Common/itkMatrixTest
        ENH: change matrix inverse calculation from float to double.

    Testing/Code/Common/itkMedialNodeCorrespondencesTest
        BUG: correctDistance(7,7) was undefined.

    Testing/Code/Common/itkNearestNeighborExtrapolateImageFunctionTest
        ENH: Removed unnecessary ITK_USE_PORTABLE_ROUND cmake variable and added Floor and Ceil functions to itk::Math namespace

    Testing/Code/Common/itkSplineKernelTransformTest
        ENH: Added VolumeSplineKernelTransform to test.

    Testing/Code/IO/CMakeLists.txt
        BUG: 6840 Adding test which runs ImageFileReader::DoConvertBuffer with the number of pixel > INT_MAX
        BUG: 9205 and 9149 Added checking when io dimension is greater than the templated dimension, enabled reading on a single ND file to an ND image, adding test to verify most combinations of input file dimensions to output image dimensions, enabled throwing of an exception when reading a series of ND+ files to an ND image
        ENH: Add a test for itk IO plugins. This plugin illustrates an ImageIO that does not have a physical file. The "file" is genearted form a text description.
        ENH: new test for 16 bit signed 3D tiff.

    Testing/Code/IO/itkDICOMImageSeriesTest
        STYLE: Fixing coding style: brackets location.

    Testing/Code/IO/itkDICOMImageSeriesTest2

    Testing/Code/IO/itkFileFreeImageIO
        COMP: stdlib.h seems to be a better option to get atoi and atof than cstdlib - I'm not sure why...
        COMP: Need to incllude cstdlib to access atoi and atof on some platforms (e.g. Sun CC).

    Testing/Code/IO/itkFileFreeImageIO
        ENH: Add a test for itk IO plugins. This plugin illustrates an ImageIO that does not have a physical file. The "file" is genearted form a text description.

    Testing/Code/IO/itkFileFreeImageIOFactory
        ENH: Add a test for itk IO plugins. This plugin illustrates an ImageIO that does not have a physical file. The "file" is genearted form a text description.

    Testing/Code/IO/itkFileFreeImageIOFactory
        ENH: Add a test for itk IO plugins. This plugin illustrates an ImageIO that does not have a physical file. The "file" is genearted form a text description.

    Testing/Code/IO/itkIOPluginTest
        ENH: Add a test for itk IO plugins. This plugin illustrates an ImageIO that does not have a physical file. The "file" is genearted form a text description.

    Testing/Code/IO/itkIOTests
        BUG: 6840 Adding test which runs ImageFileReader::DoConvertBuffer with the number of pixel > INT_MAX
        ENH: Add a test for itk IO plugins. This plugin illustrates an ImageIO that does not have a physical file. The "file" is genearted form a text description.

    Testing/Code/IO/itkImageFileReaderDimensionsTest
        STYLE: renamed name of cxx file to match name of test - completed commit

    Testing/Code/IO/Attic/itkImageFileReaderTest2
        STYLE: renamed name of cxx file to match name of test

    Testing/Code/IO/itkImageSeriesReaderDimensionsTest
        BUG: 9205 and 9149 Added checking when io dimension is greater than the templated dimension, enabled reading on a single ND file to an ND image, adding test to verify most combinations of input file dimensions to output image dimensions, enabled throwing of an exception when reading a series of ND+ files to an ND image

    Testing/Code/IO/itkLargeImageWriteConvertReadTest
        BUG: 6840 Adding test which runs ImageFileReader::DoConvertBuffer with the number of pixel > INT_MAX

    Testing/Code/IO/itkLargeImageWriteReadTest

    Testing/Code/IO/itkNrrdImageIOTest

    Testing/Code/IO/itkPipelineMonitorImageFilter
        ENH: improved warning messaged when streaming does not execute as expected

    Testing/Code/IO/itkRawImageIOTest

    Testing/Code/IO/itkStimulateImageIOTest

    Testing/Code/IO/itkTIFFImageIOTest
        ENH: Refactored TIFFImageIOTest.

    Testing/Code/IO/itkVTKImageIOTest

    Testing/Code/Numerics/itkAmoebaOptimizerTest
        BUG: 0009400. Cost function not set correctly in itkAmoebaOptimizer superclass.

    Testing/Code/Numerics/itkConjugateGradientOptimizerTest
        ENH: New method for Optimizers, GetStopConditionDescription() returns the reason for the optiimizer termination.

    Testing/Code/Numerics/itkCumulativeGaussianOptimizerTest
        ENH: New method for Optimizers, GetStopConditionDescription() returns the reason for the optiimizer termination.

    Testing/Code/Numerics/itkFRPROptimizerTest
        BUG: Due to an early return EXIT_SUCCESS, the Polake Ribiere test was never performed

    Testing/Code/Numerics/itkGradientDescentOptimizerTest
        ENH: New method for Optimizers, GetStopConditionDescription() returns the reason for the optiimizer termination.

    Testing/Code/Numerics/itkLBFGSBOptimizerTest
        ENH: New method for Optimizers, GetStopConditionDescription() returns the reason for the optiimizer termination.

    Testing/Code/Numerics/itkLBFGSOptimizerTest
        ENH: New method for Optimizers, GetStopConditionDescription() returns the reason for the optiimizer termination.

    Testing/Code/Numerics/itkLevenbergMarquardtOptimizerTest
        ENH: New method for Optimizers, GetStopConditionDescription() returns the reason for the optiimizer termination.

    Testing/Code/Numerics/itkSPSAOptimizerTest
        ENH: New method for Optimizers, GetStopConditionDescription() returns the reason for the optiimizer termination.

    Testing/Code/Numerics/Statistics/CMakeLists.txt
        BUG: 6558. New regression data & CMakeLists.txt for pixel-centered coordinates, for failing test itkSampleSelectiveMeanShiftBlurringFilterTest.

    Testing/Code/Numerics/Statistics/itkImageToListAdaptorTest

    Testing/Code/Numerics/Statistics/itkMembershipSampleTest

    Testing/Code/Numerics/Statistics/itkScalarImageToHistogramGeneratorTest
        STYLE: Improving formating.

    Testing/Code/Numerics/Statistics/itkSubsampleTest

    Testing/Code/Review/CMakeLists.txt
        COMP: On Borland do not build or run itkReviewTests4. These tests currently cause the following linker failure on Borland. Fatal: illegal VIRDEF fixup index in module. If this issue is resolved, this restriction will be removed.
        COMP: Moving tests that have Borland linker issues into their own test driver.
    584.
    584.
    584.
    584.
    584.
    584.
    584.
    584.
        COMP: Attribute cannot compare to bool.
        BUG: Fixing the input of the itkLabelImageToShapeLabelMapFilterTest1.
        BUG: Adding missing command line arguments  to the itkBinaryImageToShapeLabelMapFilterTest1.
        ENH: Adding more test for itkMergeLabelMapFilter.h
        ENH: Selecting a more interesting region for the ChangeRegionLabelMap filter test.
        ENH: Adding the input image background as a command line argument.
        BUG: Fixed usage of ChangeBackgroundValue and clarified its use as a boolean.
        ENH: Adding verbose command line option to the Mattes MI multi-threads test.

    Testing/Code/Review/itkAddConstantToImageFilterTest
        COMP: Cover operator == and !=.

    Testing/Code/Review/itkAggregateLabelMapFilterTest
        ENH: Introducing return and try-exception macros.

    Testing/Code/Review/itkAutoCropLabelMapFilterTest1
        ENH: Increase code coverage.
        ENH: Improving code coverage.
        ENH: Adding the input image background as a command line argument.
        COMP: Renaming incorrect test filename itkAutoCropMapFilterTest1 to itkAutoCropLabelMapFilterTest1.

    Testing/Code/Review/Attic/itkAutoCropMapFilterTest1
        COMP: Renaming incorrect test filename itkAutoCropMapFilterTest1 to itkAutoCropLabelMapFilterTest1.

    Testing/Code/Review/itkBinaryImageToLabelMapFilterTest
        STYLE: Return should use the EXIT_SUCCESS macro.

    Testing/Code/Review/itkBinaryImageToShapeLabelMapFilterTest1
        ENH: Add a couple of filter watchers.
        ENH: Better error message formatting.

    Testing/Code/Review/itkBinaryImageToStatisticsLabelMapFilterTest1

    Testing/Code/Review/itkBinaryShapeKeepNObjectsImageFilterTest1
        COMP: warning converting double to unsigned int.
    584.

    Testing/Code/Review/itkBinaryShapeOpeningImageFilterTest1

    Testing/Code/Review/itkBinaryStatisticsKeepNObjectsImageFilterTest1
        COMP: warning converting double to unsigned int.

    Testing/Code/Review/itkBinaryStatisticsOpeningImageFilterTest1

    Testing/Code/Review/itkBoxMeanImageFilterTest
        COMP: remove warnings invalid multibyte character sequence

    Testing/Code/Review/itkBoxSigmaImageFilterTest
        COMP: remove warnings invalid multibyte character sequence

    Testing/Code/Review/itkChangeLabelLabelMapFilterTest

    Testing/Code/Review/itkChangeRegionLabelMapFilterTest1
        BUG: Included logic for expect exception test.
        ENH: Improving code coverage.

    Testing/Code/Review/itkCropLabelMapFilterTest1
        ENH: Adding test code coverage.
        ENH: Improving code coverage.

    Testing/Code/Review/itkDiffeomorphicDemonsRegistrationFilterTest

    Testing/Code/Review/itkDivideByConstantImageFilterTest
        COMP: Cover operator == and !=.

    Testing/Code/Review/itkFastApproximateRankImageFilterTest
        COMP: remove warnings invalid multibyte character sequence

    Testing/Code/Review/itkFastSymmetricForcesDemonsRegistrationFilterTest

    Testing/Code/Review/itkKappaSigmaThresholdImageCalculatorTest
        BUG: mask should be unsigned char.

    Testing/Code/Review/itkLabelContourImageFilterTest
        ENH: Better coverage.

    Testing/Code/Review/itkLabelImageToShapeLabelMapFilterTest1
        ENH: Use method names consitent with LabelImageToLabelMapFilter.

    Testing/Code/Review/itkLabelImageToStatisticsLabelMapFilterTest1

    Testing/Code/Review/itkLabelMapToBinaryImageFilterTest

    Testing/Code/Review/itkLabelObjectTest
        COMP: Fixed unsigned and signed int comparison warning.

    Testing/Code/Review/itkLabelOverlayImageFilterTest
        ENH: Let the user set its own colors. Patch provided by Martin Kavec.

    Testing/Code/Review/itkLabelShapeKeepNObjectsImageFilterTest1
        COMP: warning converting double to unsigned int.

    Testing/Code/Review/itkLabelShapeOpeningImageFilterTest1
    584.

    Testing/Code/Review/itkLabelStatisticsKeepNObjectsImageFilterTest1
        COMP: warning converting double to unsigned int.

    Testing/Code/Review/itkLabelStatisticsOpeningImageFilterTest1
    584.

    Testing/Code/Review/itkLabelToRGBImageFilterTest
        ENH: Let the user set its own colors. Patch provided by Martin Kavec.

    Testing/Code/Review/itkMapMaskedRankImageFilterTest
        COMP: remove warnings invalid multibyte character sequence

    Testing/Code/Review/itkMapRankImageFilterTest
        COMP: remove warnings invalid multibyte character sequence

    Testing/Code/Review/itkMaskedRankImageFilterTest
        COMP: remove warnings invalid multibyte character sequence

    Testing/Code/Review/itkMergeLabelMapFilterTest1
        ENH: Raising code coverage by calling GetMethod().

    Testing/Code/Review/itkMultiScaleHessianBasedMeasureImageFilterTest
        BUG: Fix for when NumberOfSigmaStep is set to 0 or 1. Before the fix the filter would run forever in these cases. Also appended these cases to the test.

    Testing/Code/Review/itkMultiphaseDenseFiniteDifferenceImageFilterTest
        ENH: remove default template arguments in TestHelper classes.

    Testing/Code/Review/itkMultiphaseFiniteDifferenceImageFilterTest
        ENH: remove default template arguments in TestHelper classes.

    Testing/Code/Review/itkMultiphaseSparseFiniteDifferenceImageFilterTest
        ENH: remove default template arguments in TestHelper classes.

    Testing/Code/Review/itkMultiplyByConstantImageFilterTest
        COMP: Cover operator == and !=.

    Testing/Code/Review/itkOptImageToImageMetricsTest

    Testing/Code/Review/itkOptMattesMutualInformationImageToImageMetricThreadsTest1
        COMP: Fixed to compile with and without ITK_USE_OPTIMIZED_REGISTRATION_METHODS flag.
        ENH: Comparisons are only needed with larger number of threads.
        ENH: Adding verbose command line option to the Mattes MI multi-threads test.

    Testing/Code/Review/itkPadLabelMapFilterTest1
        BUG: Included logic for testing exception expected conditions.

    Testing/Code/Review/itkQuadEdgeMeshScalarDataVTKPolyDataWriterTest1
        COMP: initialize point coordinates

    Testing/Code/Review/itkRankImageFilterTest
        COMP: remove warnings invalid multibyte character sequence

    Testing/Code/Review/itkRegionFromReferenceLabelMapFilterTest1

    Testing/Code/Review/itkRegularSphereQuadEdgeMeshSourceTest
        COMP: initialize point coordinates

    Testing/Code/Review/itkRelabelLabelMapFilterTest1
        ENH: Enabling compression in the writer.

    Testing/Code/Review/itkReviewTests

    Testing/Code/Review/itkReviewTests3
        COMP: Moving tests that have Borland linker issues into their own test driver.
    584.
    584.
    584.
    584.
    584.
    584.
    584.
        ENH: Added itkShapeLabelObjectAccessorsTest1
        ENH: Adding CMake and itkReviewTest files for itkBinaryImageToShapeLabelMapFilter.

    Testing/Code/Review/itkReviewTests4
        COMP: Moving tests that have Borland linker issues into their own test driver.

    Testing/Code/Review/itkScalarChanAndVeseDenseLevelSetImageFilterTest2
        ENH: Corrected method name for setting reinitialization weight

    Testing/Code/Review/itkScalarRegionBasedLevelSetFunctionTest
        ENH: Changed the API of the methods UpdateSharedDataInsideParameters() and UpdateSharedDataOutsideParameters()

    Testing/Code/Review/itkScaleVersor3DTransformTest

    Testing/Code/Review/itkShapeKeepNObjectsLabelMapFilterTest1
        BUG: wrong argv selected for attribute.

    Testing/Code/Review/itkShapeLabelObjectAccessorsTest1
        ENH: Cover the rest.
        ENH: Added itkShapeLabelObjectAccessorsTest1

    Testing/Code/Review/itkShapeOpeningLabelMapFilterTest1
        COMP: Attribute is not a bool. Warning removed.

    Testing/Code/Review/itkShapeRelabelImageFilterTest1
    584.

    Testing/Code/Review/itkShapeRelabelLabelMapFilterTest1

    Testing/Code/Review/itkShapeUniqueLabelMapFilterTest1
        COMP: Attribute is not a bool. Warning removed.

    Testing/Code/Review/itkShiftScaleLabelMapFilterTest1
        COMP: should not compare a bool with an int.

        ENH: Adding test code coverage.

    Testing/Code/Review/itkStatisticsKeepNObjectsLabelMapFilterTest1
        COMP: Attribute is not a bool. Warning removed.

    Testing/Code/Review/itkStatisticsOpeningLabelMapFilterTest1
        COMP: Attribute is not a bool. Warning removed.
    584.

    Testing/Code/Review/itkStatisticsRelabelImageFilterTest1
    584.

    Testing/Code/Review/itkStatisticsRelabelLabelMapFilterTest1
    584.

    Testing/Code/Review/itkStatisticsUniqueLabelMapFilterTest1
        COMP: warnings.

    Testing/Code/Review/itkSubtractConstantFromImageFilterTest
        COMP: Cover operator == and !=.

    Testing/Code/Review/itkTestingMacros
        ENH: Improving error reporting in the TEST_SET_GET_VALUE() macro.

    Testing/Code/Review/itkVTKPolyDataIOQuadEdgeMeshTest
        BUG: Test should fail if an unexpected exception occurs.

    Testing/Code/Review/itkVTKPolyDataWriterTest2
        COMP: initialize point coordinates

    Testing/Code/Review/Statistics/itkChiSquareDistributionTest
        COMP: Use vcl_ versions of pqrt, nd  fabsto fix build with sun studio

    Testing/Code/Review/Statistics/itkCovarianceSampleFilterTest
        COMP: Use vcl_ versions of pqrt, nd  fabsto fix build with sun studio

    Testing/Code/Review/Statistics/itkCovarianceSampleFilterTest2
        COMP: Use vcl_ versions of pqrt, nd  fabsto fix build with sun studio

    Testing/Code/Review/Statistics/itkCovarianceSampleFilterTest3
        COMP: Use vcl_ versions of pqrt, nd  fabsto fix build with sun studio

    Testing/Code/Review/Statistics/itkDistanceToCentroidMembershipFunctionTest
        COMP: Use vcl_ versions of pqrt, nd  fabsto fix build with sun studio

    Testing/Code/Review/Statistics/itkEuclideanDistanceMetricTest
        COMP: Use vcl_ versions of pqrt, nd  fabsto fix build with sun studio

    Testing/Code/Review/Statistics/itkEuclideanSquareDistanceMetricTest
        COMP: Use vcl_ versions of pqrt, nd  fabsto fix build with sun studio

    Testing/Code/Review/Statistics/itkExpectationMaximizationMixtureModelEstimatorTest
        COMP: Use vcl_ versions of pqrt, nd  fabsto fix build with sun studio

    Testing/Code/Review/Statistics/itkGaussianMembershipFunctionTest
        COMP: Use vcl_ versions of pqrt, nd  fabsto fix build with sun studio

    Testing/Code/Review/Statistics/itkImageToListSampleFilterTest3
        COMP: Use vcl_ versions of pqrt, nd  fabsto fix build with sun studio

    Testing/Code/Review/Statistics/itkJointDomainImageToListSampleAdaptorTest
        COMP: Use vcl_ versions of pqrt, nd  fabsto fix build with sun studio

    Testing/Code/Review/Statistics/itkKdTreeBasedKmeansEstimatorTest
        COMP: Use vcl_ versions of pqrt, nd  fabsto fix build with sun studio

    Testing/Code/Review/Statistics/itkKdTreeTest1
        COMP: Use vcl_ versions of pqrt, nd  fabsto fix build with sun studio

    Testing/Code/Review/Statistics/itkKdTreeTestSamplePoints
        COMP: Use vcl_ versions of pqrt, nd  fabsto fix build with sun studio

    Testing/Code/Review/Statistics/itkMahalanobisDistanceMetricTest
        COMP: Use vcl_ versions of pqrt, nd  fabsto fix build with sun studio

    Testing/Code/Review/Statistics/itkManhattanDistanceMetricTest
        COMP: Use vcl_ versions of pqrt, nd  fabsto fix build with sun studio

    Testing/Code/Review/Statistics/itkMeanSampleFilterTest
        COMP: Use vcl_ versions of pqrt, nd  fabsto fix build with sun studio

    Testing/Code/Review/Statistics/itkSampleClassifierFilterTest7
        COMP: Use vcl_ versions of pqrt, nd  fabsto fix build with sun studio

    Testing/Code/Review/Statistics/itkSubsampleTest3
        COMP: Use vcl_ versions of pqrt, nd  fabsto fix build with sun studio

    Testing/Code/Review/Statistics/itkTDistributionTest
        COMP: Use vcl_ versions of pqrt, nd  fabsto fix build with sun studio

    Testing/Code/Review/Statistics/itkWeightedCentroidKdTreeGeneratorTest1
        COMP: Use vcl_ versions of pqrt, nd  fabsto fix build with sun studio

    Testing/Code/Review/Statistics/itkWeightedCentroidKdTreeGeneratorTest8
        COMP: Use vcl_ versions of pqrt, nd  fabsto fix build with sun studio

    Testing/Code/Review/Statistics/itkWeightedCentroidKdTreeGeneratorTest9
        COMP: Use vcl_ versions of pqrt, nd  fabsto fix build with sun studio

    Testing/Code/Review/Statistics/itkWeightedCovarianceSampleFilterTest
        COMP: Use vcl_ versions of pqrt, nd  fabsto fix build with sun studio

    Testing/Code/Review/Statistics/itkWeightedMeanSampleFilterTest
        COMP: Use vcl_ versions of pqrt, nd  fabsto fix build with sun studio

    Testing/Data/Baseline/Algorithms/itkMultiResolutionPDEDeformableRegistrationTestPixelCentered.png
        BUG: Pyramid should use ShrinkimageFilter. New baseline.

    Testing/Data/Baseline/Filtering/ResampleImageFilter6PixelCentered.png

    Testing/Data/Baseline/Filtering/ResampleImageFilter7PixelCentered.png
        BUG: 6558. Updated regression data for remaining failing tests.

    Testing/Data/Baseline/Filtering/ResampleImageFilter9TestPixelCentered.1.png
        COMP: Additional baseline needed after bug fix in NearestNeighborInterpolateImageFunction.

    Testing/Data/Baseline/Filtering/ResampleImageFilter9TestPixelCentered.2.png
        COMP: Additional baseline needed to deal with differences in floating point precision.

    Testing/Data/Baseline/Filtering/ResampleImageFilter9TestPixelCentered.png
        ENH: New base line for the NearestNeighbor interpolation, when Centered Pixel is ON.

    Testing/Data/Baseline/IO/rampShort.tif
        ENH: new input and baseline for 16 bit signed 3D tif image.

    Testing/Data/Baseline/Registration/ImageRegistration17TestPixelCentered.1.png
        ENH: Baseline for windows platforms.

    Testing/Data/Baseline/Registration/ImageRegistration8RegisteredSlice.png
        COMP: New baseline for centered pixels.

    Testing/Data/Baseline/Registration/MultiResImageRegistration1Test.2.png
        COMP: additional baseline for some gcc 4.x platforms.

    Testing/Data/Baseline/Review/Spots-binaryimage-to-shapelabel.mha

    Testing/Data/Baseline/Review/Spots-binaryimage-to-statisticslabel.mha
        COMP: Fix compilation error in Borland related to ImageDimension. ENH: add some tests.

    Testing/Data/Baseline/Review/cthead1-binary-shape-opening.mha

    Testing/Data/Baseline/Review/cthead1-keep-n-objects.mha
        BUG: Updating version of baseline test for updated ShapeKeepNObjects filter test.

    Testing/Data/Baseline/Review/cthead1-label-autocrop.mha
        ENH: Adding baseline for the itkAutoCropLabeMapFilter.

    Testing/Data/Baseline/Review/cthead1-label-binary.mha

    Testing/Data/Baseline/Review/cthead1-label-changed.mha

    Testing/Data/Baseline/Review/cthead1-label-changed2.mha

    Testing/Data/Baseline/Review/cthead1-label-changeregion.mha
        ENH: Adding baseline image for the ChangeRegionLabelMapFilter test.

    Testing/Data/Baseline/Review/cthead1-label-crop.mha

    Testing/Data/Baseline/Review/Attic/cthead1-label-merge_keep.mha

    Testing/Data/Baseline/Review/cthead1-label-pad.mha

    Testing/Data/Baseline/Review/cthead1-label-regionreference.mha

    Testing/Data/Baseline/Review/cthead1-label-relabeled.mha
        ENH: Baseline image for the RelabelLabelMapFilter.

    Testing/Data/Baseline/Review/cthead1-label-shiftscaled.mha
        ENH: Baseline image for the itkShiftScaleLabelMapFilterTest1.

    Testing/Data/Baseline/Review/cthead1-labelAggregate.mha
        ENH: Baseline image for the test itkAggregateLabelMapFilterTest.

    Testing/Data/Baseline/Review/cthead1-labeled.mha

    Testing/Data/Baseline/Review/cthead1-shape-opening.mha

    Testing/Data/Baseline/Review/cthead1-shape-relabel-labelmap.mha

    Testing/Data/Baseline/Review/itkLabelContourImageFilterTest0.png
        BUG: Revert to original baseline.

    Testing/Data/Baseline/Review/itkLabelContourImageFilterTest1.png
        BUG: Revert to original baseline.

    Testing/Data/Baseline/Review/simple-label-merge-aggregate.mha
        ENH: Adding baseline image for test file of itkMergeLabelMap.

    Testing/Data/Baseline/Review/simple-label-merge-keep.mha
        ENH: Adding baseline image for test file of itkMergeLabelMap.

    Testing/Data/Baseline/Review/simple-label-merge-pack.mha
        ENH: Adding baseline image for test file of itkMergeLabelMap.

    Testing/Data/Baseline/Review/simple-label-merge-strict.mha
        ENH: Adding baseline image for test file of itkMergeLabelMap.

    Testing/Data/Baseline/Review/simple-label-to-shapelabelmap.mha
        COMP: Correcting incorrect baseline image due to test image change.

    Testing/Data/Baseline/Statistics/itkSampleSelectiveMeanShiftBlurringFilterTestPixelCentered.png
        BUG: 6558. New regression data & CMakeLists.txt for pixel-centered coordinates, for failing test itkSampleSelectiveMeanShiftBlurringFilterTest.

    Testing/Data/Input/genusZeroSurface01.vtk
        BUG: Dta file had POINT_DATA keyword but no point data.

    Testing/Data/Input/mushroom.vtk
        BUG: Dta file had POINT_DATA keyword but no point data.

    Testing/Data/Input/rampShort.tif
        ENH: new input and baseline for 16 bit signed 3D tif image.

    Testing/Data/Input/simple-label-a.png
        ENH: Images intended for testing the different modes of operation of the  itkMergeLabelMapFilter.

    Testing/Data/Input/simple-label-b.png
        ENH: Images intended for testing the different modes of operation of the  itkMergeLabelMapFilter.

    Testing/Data/Input/simple-label-c.png

    Testing/Data/Input/simple-label-d.png

    Testing/Data/Input/simple-label-e.png

    Utilities/MetaIO/.svnrev
        ENH: subversion revision 855 commited to CVS
        ENH: subversion revision 840 commited to CVS
        ENH: subversion revision 838 commited to CVS
        ENH: subversion revision 836 commited to CVS

    Utilities/MetaIO/CMakeLists.txt

    Utilities/MetaIO/localMetaConfiguration

    Utilities/MetaIO/metaArray

    Utilities/MetaIO/metaCommand

    Utilities/MetaIO/metaForm

    Utilities/MetaIO/metaImage

    Utilities/MetaIO/metaImage

    Utilities/MetaIO/metaImageUtils

    Utilities/MetaIO/metaOutput

    Utilities/MetaIO/metaUtils

    Utilities/MetaIO/metaUtils

    Utilities/NrrdIO/read
        BUG: Windows filenames with backslash separators were not handled properly.

    Utilities/NrrdIO/reorder
        COMP: gcc 4.4 is producing bogus array bounds warnings. Try to suppress them with a #pragma.

    Utilities/NrrdIO/subset
        COMP: gcc 4.4 is producing bogus array bounds warnings. Try to suppress them with a #pragma.

    Utilities/expat/expat

    Utilities/gdcm/src/CMakeLists.txt
        COMP: suppress GCC warnings regarding type punned pointers and uninitialized variable.

    Utilities/kwsys/CMakeLists.txt

    Utilities/kwsys/Configure.h.in

    Utilities/kwsys/Configure.hxx.in

    Utilities/kwsys/Glob
        Fix for Bug #9190, -U did not work on case insensitive file systems because of call to glob convert to regex that expected to work with files.

    Utilities/kwsys/Glob.hxx.in
        Fix for Bug #9190, -U did not work on case insensitive file systems because of call to glob convert to regex that expected to work with files.

    Utilities/kwsys/MD5
        COMP: Eliminate "conversion may change sign of result" warnings by using size_t where appropriate. (Missed one warning with last commit: add a cast to md5_word_t.)

    Utilities/kwsys/ProcessUNIX
        COMP:Fixed warning with gcc 4.3.3: passing argument 1 of kwsysProcessSetVMSFeature discards qualifiers from pointer target type.

    Utilities/kwsys/ProcessWin32
        ENH: first pass at VS 10, can bootstrap CMake, but many tests still fail

    Utilities/kwsys/RegularExpression.hxx.in

    Utilities/kwsys/SharedForward.h.in

    Utilities/kwsys/String

    Utilities/kwsys/System

    Utilities/kwsys/System.h.in

    Utilities/kwsys/SystemTools
        COMP: attempt to fix more 'hidden by' warnings.
        ENH: use .exe on vms
        ENH: fix warning on borland

    Utilities/kwsys/SystemTools.hxx.in
        ENH: move PutEnv to SystemTools

    Utilities/kwsys/hashtable.hxx.in
        STYLE: suppress warnings for borland

    Utilities/kwsys/kwsysDateStamp.cmake
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp
        STYLE: Nightly Date Stamp

    Utilities/kwsys/kwsysPlatformTestsCXX

    Utilities/kwsys/kwsysPrivate

    Utilities/kwsys/testAutoPtr
        STYLE: suppress warnings for borland

    Utilities/kwsys/testIOS

    Utilities/netlib/slatec/CMakeLists.txt
        BUG: Slatec lib is not versioned.

    Utilities/nifti/CMakeLists.txt

    Utilities/nifti/Updates.txt
        COMP:  Syncronized with nifti main source tree.

    Utilities/nifti/Testing/CMakeLists.txt

    Utilities/nifti/Testing/nifti_regress_test/CMakeLists.txt

    Utilities/nifti/Testing/niftilib/CMakeLists.txt

    Utilities/nifti/examples/CMakeLists.txt

    Utilities/nifti/examples/Makefile
        COMP:  Syncronized with nifti main source tree.

    Utilities/nifti/fsliolib/CMakeLists.txt

    Utilities/nifti/nifticdf/CMakeLists.txt

    Utilities/nifti/niftilib/CMakeLists.txt

    Utilities/nifti/niftilib/nifti1_io
        COMP:  Removed compiler warnings, and did some more const-correctness fixes.
        COMP:  Suppressed compiler warning by making types consistently defined.
        COMP:  Syncronized with nifti main source tree.

    Utilities/nifti/niftilib/nifti1_io
        COMP:  Removed compiler warnings, and did some more const-correctness fixes.

    Utilities/nifti/utils/CMakeLists.txt
        COMP:  Removed compiler warnings, and did some more const-correctness fixes.
        COMP:  Syncronized with nifti main source tree.

    Utilities/nifti/znzlib/CMakeLists.txt
        COMP:  Syncronized with nifti main source tree.

    Utilities/vxl/core/testlib/tests/CMakeLists.txt

    Utilities/vxl/core/vnl/CMakeLists.txt
        ENH: If there is no hardware sse2 support, make sure to disable VNL_CONFIG_ENABLE_SSE2_ROUNDING in the cmake cache

    Utilities/vxl/core/vnl/vnl_diag_matrix
        COMP:  Removed compiler warnings.

    Utilities/vxl/core/vnl/vnl_ma
        BUG: VNL did not define vnl_math::two_over_sqrt2pi in a cxx file

    Utilities/vxl/core/vnl/vnl_math
        COMP: Fixed universal binary compilation issues related to sse2 by conditionning the sse2 code by defined(__SSE2__). This preprocessor define seems to be supported by gcc, icc and msvc.

    Utilities/vxl/core/vnl/vnl_sse
        COMP:  Removed 100's of compiler warning messages about unused variables n and size.

    Utilities/vxl/core/vnl/Templates/vnl_matrix_fixed+double.5.5-
        COMP: Fix build with explicit instantions activated.

    Utilities/vxl/core/vnl/tests/test_ma
        COMP: Trying to resolve static const issue on Intel 10.0 compiler.

    Utilities/vxl/core/vnl/tests/test_numeric_traits
        COMP: Trying to resolve static const issue on Intel 10.0 compiler.

    Utilities/vxl/v3p/netlib/v3p_f2c_mangle
        COMP: Fix Attempt to redefine c_abs without using #undef warning with Sun Studio

    Utilities/vxl/v3p/netlib/tests/CMakeLists.txt

    Utilities/vxl/vcl/tests/CMakeLists.txt

    Wrapping/CSwig/pythonfiles_install.cmake.in

    Wrapping/ExplicitITK/Modules/Common/wrap_itkConstNeighborhoodIterator.cmake
        COMP: Fix build with explicit instantions activated.

    Wrapping/ExplicitITK/Modules/Common/wrap_itkMatrix.cmake
        COMP: Fix build with explicit instantions activated.

    Wrapping/WrapITK/ExternalProjects/PyBuffer/itkPyBuffer
    insight-users/2009-May/030625.html

    Wrapping/WrapITK/Modules/VXLNumerics/CMakeLists.txt
        COMP: #0009137: ITK links against itkvnl with USE_WRAP_ITK despite ITK_USE_SYSTEM_VXL. Fixed by linking to ITKCommon, which is always available.

    Wrapping/WrapITK/Modules/VXLNumerics/wrap_vnl_matrix_fixed.cmake
