# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
DEBIAN_RELEASES += 10
DEBIAN_10_CODENAME = buster

.PHONY: all
all:: debian-cloud-10.$(GARDEN_ARCH).qcow2 debian-cloud-10.$(GARDEN_ARCH).run

.PHONY: fetch
fetch: $(GARDEN_DL_DIR)/debian/debian-10-generic-$(call map_to_debian_arch,$(GARDEN_ARCH))-daily.qcow2

$(GARDEN_DL_DIR)/debian/debian-10-generic-amd64-daily.qcow2 $(GARDEN_DL_DIR)/debian/debian-10-generic-arm64-daily.qcow2: $(GARDEN_DL_DIR)/debian/debian-10-generic-%-daily.qcow2: | $(GARDEN_DL_DIR)/debian
	$(strip $(WGET) \
		--no-clobber \
		--directory-prefix=$(firstword $|)/ \
		https://cloud.debian.org/images/cloud/$(DEBIAN_10_CODENAME)/daily/latest/debian-10-generic-$*-daily.qcow2)

$(GARDEN_DL_DIR)/debian/debian-cloud-10.x86_64.qcow2: | $(GARDEN_DL_DIR)/debian/ $(GARDEN_DL_DIR)/debian/debian-10-generic-amd64-daily.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

$(GARDEN_DL_DIR)/debian/debian-cloud-10.aarch64.qcow2: | $(GARDEN_DL_DIR)/debian/ $(GARDEN_DL_DIR)/debian/debian-10-generic-arm64-daily.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

.PHONY: clean
clean::
	rm -f $(GARDEN_DL_DIR)/debian/debian-cloud-10.*.qcow2

.PHONY: distclean
distclean::
	rm -f $(GARDEN_DL_DIR)/debian/debian-10-generic-*.qcow2
