/*
    HOTKEYS - use keys on your multimedia keyboard to control your computer
    Copyright (C) 2000,2001  Anthony Y P Wong <ypwong@ypwong.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    $Id: hotkeys.h,v 1.9 2002/11/27 19:33:50 ypwong Exp $
*/

#ifndef __HOTKEYS_H
#define	__HOTKEYS_H

#include "kbddef.h"

#include <stdio.h>  /* somehow XKBfile.h needs it, but it doesn't include it */
#include <X11/Xlib.h>
#include <X11/XKBlib.h>
#include <X11/extensions/XKBfile.h>
#include <X11/extensions/XKBbells.h>

/* Function prototypes */
void initializeX(char* prg);
void usage(int argc, char* argv[]);
void showKbdList(int argc, char *argv[]);
void setCDROMDevice(char* optarg);
Bool setKbdType(const char* prog, const char* type);
void setLoglevel(int level);
Bool parseArgs(int argc, char* argv[]);
Display* GetDisplay(char* program, char* dpyName, int* opcodeRtrn, int* evBaseRtrn);
void bailout(void);
int doMute(void);
void ejectDisc(void);
int launchApp(int keycode);
void uError(char* s,...);
void uInfo(char* s,...);
void uInternalError(char* s,...);
int testReadable(const char* filename);

extern	Display *       dpy;
extern	int             xkbOpcode;
extern	int             xkbEventCode;
extern	XkbDescPtr      xkb;

extern  keyboard        kbd;
extern  int             loglevel;
extern  int             volUpAdj;
extern  int             volDownAdj;
extern  int             backlightUpAdj;
extern  int             backlightDownAdj;

void fixVMware(char* time);
int fork2(void);

#ifdef HAVE_XOSD
extern  xosd*           osd;
#endif

#define SPLASH_IMAGE    SHAREDIR"/splash.png"

#ifdef DUMMY_MIXER
#define SOUND_IOCTL(a,b,c)      dummy_ioctl(a,b,c)
#else
#if defined (__NetBSD__) || defined (__OpenBSD__)
#define SOUND_IOCTL(a,b,c)      _oss_ioctl(a,b,c)
#else
#define SOUND_IOCTL(a,b,c)      ioctl(a,b,c)
#endif                          /* defined (__NetBSD__) || defined (__OpenBSD__) */
#endif                          /* DUMMY_MIXER */

#define MIXER_DEV       "/dev/mixer"
#define CDROM_DEV       "/dev/cdrom"
#define MAXLEVEL        100     /* highest level permitted by OSS drivers */

#endif /* __HOTKEYS_H */
