/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.Hashtable;

public class NamedTheorem {
    public static int proofcounter;
    public static Hashtable table;

    public static String skipSpace(String w) {
        for (int i = 0; i < w.length(); ++i) {
            if (w.charAt(i) == ' ') continue;
            return w.substring(i);
        }
        return "";
    }

    public static String readWord(String w) {
        for (int i = 0; i < w.length(); ++i) {
            char c = w.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || i > 0 && c >= '0' && c <= '9') continue;
            return w.substring(0, i);
        }
        return w;
    }

    public static String[] filter(String line) {
        String l = NamedTheorem.readWord(line = NamedTheorem.skipSpace(line));
        if (l.equals("let")) {
            line = line.substring(l.length());
            line = NamedTheorem.skipSpace(line);
            String w = NamedTheorem.readWord(line);
            if ((line = NamedTheorem.skipSpace(line.substring(w.length()))).length() > 1 && line.charAt(0) == '=') {
                line = NamedTheorem.skipSpace(line.substring(1));
                String p = NamedTheorem.readWord(line);
                line = line.substring(p.length());
                if (p.equals("prove") && (line.equals("") || line.startsWith(" ") || line.startsWith("("))) {
                    return new String[]{w, line};
                }
            }
        }
        return null;
    }

    public static boolean ignore(String x) {
        return x.startsWith("pth") || x.startsWith("bth") || x.startsWith("nth") || x.startsWith("tth") || x.startsWith("lem") || x.startsWith("thm") || x.startsWith("rthm");
    }

    public static void convert(String filename) throws IOException {
        String line;
        File f = new File(filename);
        File fnew = new File(filename + ".old");
        f.renameTo(fnew);
        LineNumberReader reader = new LineNumberReader(new FileReader(fnew));
        PrintWriter writer = new PrintWriter(new FileWriter(f));
        while ((line = reader.readLine()) != null) {
            String[] proofinfo = NamedTheorem.filter(line);
            if (proofinfo == null) {
                writer.println(line);
                continue;
            }
            String proofname = proofinfo[0];
            ++proofcounter;
            if (NamedTheorem.ignore(proofname)) {
                System.out.println("warning: ignoring '" + proofname + "' in " + filename);
                writer.println(line);
                continue;
            }
            if (table.get(proofname) != null) {
                System.out.println("warning: duplicate '" + proofname + "' in " + filename);
                writer.println(line);
                continue;
            }
            writer.println("let " + proofname + " = nprove \"" + proofname + "\"" + proofinfo[1]);
            table.put(proofname, proofname);
        }
        reader.close();
        writer.close();
    }

    public static void main(String[] args) throws IOException {
        proofcounter = 0;
        for (int i = 0; i < args.length; ++i) {
            System.out.println("convert " + args[i] + " ...");
            NamedTheorem.convert(args[i]);
        }
        System.out.println("done. " + proofcounter + " named proofs found.");
    }

    static {
        table = new Hashtable(1000, 0.3f);
    }
}

