{- This module was generated from data in the Kate syntax
   highlighting file pure.xml, version 1.2, by  -}

module Text.Highlighting.Kate.Syntax.Pure
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Pure"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.pure"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Pure","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("Pure","Normal") -> return ()
      ("Pure","String") -> (popContext) >> pEndLine
      ("Pure","Region Marker") -> (popContext) >> pEndLine
      ("Pure","Comment1") -> return ()
      ("Pure","Comment2") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_blockstarters = Set.fromList $ words $ "case when with"
list_blockenders = Set.fromList $ words $ "end"
list_keywords = Set.fromList $ words $ "const def else extern if infix infixl infixr interface let namespace nonfix of otherwise outfix postfix prefix private public then type using"
list_special = Set.fromList $ words $ "catch throw __break__ __trace__"
list_types = Set.fromList $ words $ "bigint bool char float double expr short int long string pointer void int8 int16 int32 int64 matrix dmatrix cmatrix imatrix smatrix nmatrix"

regex_'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a = compileRegex True "[A-Za-z_][A-Za-z0-9_]*"
regex_0x'5bA'2dZa'2dz0'2d9'5d'2b = compileRegex True "0x[A-Za-z0-9]+"

parseRules ("Pure","Normal") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_blockstarters >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_blockenders >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_special >>= withAttribute FunctionTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_0x'5bA'2dZa'2dz0'2d9'5d'2b >>= withAttribute DecValTok))
   <|>
   ((pFloat >>= withAttribute DecValTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pHlCChar >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("Pure","String"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("Pure","Comment1"))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("Pure","Comment2"))
   <|>
   (currentContext >>= \x -> guard (x == ("Pure","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Pure","String") =
  (((pLineContinue >>= withAttribute StringTok))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Pure","String")) >> pDefault >>= withAttribute StringTok))

parseRules ("Pure","Region Marker") =
  (currentContext >>= \x -> guard (x == ("Pure","Region Marker")) >> pDefault >>= withAttribute NormalTok)

parseRules ("Pure","Comment1") =
  (((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Pure","Comment1")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Pure","Comment2") =
  (currentContext >>= \x -> guard (x == ("Pure","Comment2")) >> pDefault >>= withAttribute CommentTok)


parseRules x = parseRules ("Pure","Normal") <|> fail ("Unknown context" ++ show x)
