<?php
$arr = array(
0x00C4 => array(0x80, "LATIN CAPITAL LETTER A WITH DIAERESIS"),
0x00C5 => array(0x81, "LATIN CAPITAL LETTER A WITH RING ABOVE"),
0x00C7 => array(0x82, "LATIN CAPITAL LETTER C WITH CEDILLA"),
0x00C9 => array(0x83, "LATIN CAPITAL LETTER E WITH ACUTE"),
0x00D1 => array(0x84, "LATIN CAPITAL LETTER N WITH TILDE"),
0x00D6 => array(0x85, "LATIN CAPITAL LETTER O WITH DIAERESIS"),
0x00DC => array(0x86, "LATIN CAPITAL LETTER U WITH DIAERESIS"),
0x00E1 => array(0x87, "LATIN SMALL LETTER A WITH ACUTE"),
0x00E0 => array(0x88, "LATIN SMALL LETTER A WITH GRAVE"),
0x00E2 => array(0x89, "LATIN SMALL LETTER A WITH CIRCUMFLEX"),
0x00E4 => array(0x8A, "LATIN SMALL LETTER A WITH DIAERESIS"),
0x00E3 => array(0x8B, "LATIN SMALL LETTER A WITH TILDE"),
0x00E5 => array(0x8C, "LATIN SMALL LETTER A WITH RING ABOVE"),
0x00E7 => array(0x8D, "LATIN SMALL LETTER C WITH CEDILLA"),
0x00E9 => array(0x8E, "LATIN SMALL LETTER E WITH ACUTE"),
0x00E8 => array(0x8F, "LATIN SMALL LETTER E WITH GRAVE"),
0x00EA => array(0x90, "LATIN SMALL LETTER E WITH CIRCUMFLEX"),
0x00EB => array(0x91, "LATIN SMALL LETTER E WITH DIAERESIS"),
0x00ED => array(0x92, "LATIN SMALL LETTER I WITH ACUTE"),
0x00EC => array(0x93, "LATIN SMALL LETTER I WITH GRAVE"),
0x00EE => array(0x94, "LATIN SMALL LETTER I WITH CIRCUMFLEX"),
0x00EF => array(0x95, "LATIN SMALL LETTER I WITH DIAERESIS"),
0x00F1 => array(0x96, "LATIN SMALL LETTER N WITH TILDE"),
0x00F3 => array(0x97, "LATIN SMALL LETTER O WITH ACUTE"),
0x00F2 => array(0x98, "LATIN SMALL LETTER O WITH GRAVE"),
0x00F4 => array(0x99, "LATIN SMALL LETTER O WITH CIRCUMFLEX"),
0x00F6 => array(0x9A, "LATIN SMALL LETTER O WITH DIAERESIS"),
0x00F5 => array(0x9B, "LATIN SMALL LETTER O WITH TILDE"),
0x00FA => array(0x9C, "LATIN SMALL LETTER U WITH ACUTE"),
0x00F9 => array(0x9D, "LATIN SMALL LETTER U WITH GRAVE"),
0x00FB => array(0x9E, "LATIN SMALL LETTER U WITH CIRCUMFLEX"),
0x00FC => array(0x9F, "LATIN SMALL LETTER U WITH DIAERESIS"),
0x2020 => array(0xA0, "DAGGER"),
0x00B0 => array(0xA1, "DEGREE SIGN"),
0x00A2 => array(0xA2, "CENT SIGN"),
0x00A3 => array(0xA3, "POUND SIGN"),
0x00A7 => array(0xA4, "SECTION SIGN"),
0x2022 => array(0xA5, "BULLET"),
0x00B6 => array(0xA6, "PILCROW SIGN"),
0x00DF => array(0xA7, "LATIN SMALL LETTER SHARP S"),
0x00AE => array(0xA8, "REGISTERED SIGN"),
0x00A9 => array(0xA9, "COPYRIGHT SIGN"),
0x2122 => array(0xAA, "TRADE MARK SIGN"),
0x00B4 => array(0xAB, "ACUTE ACCENT"),
0x00A8 => array(0xAC, "DIAERESIS"),
0x2260 => array(0xAD, "NOT EQUAL TO"),
0x00C6 => array(0xAE, "LATIN CAPITAL LETTER AE"),
0x00D8 => array(0xAF, "LATIN CAPITAL LETTER O WITH STROKE"),
0x221E => array(0xB0, "INFINITY"),
0x00B1 => array(0xB1, "PLUS-MINUS SIGN"),
0x2264 => array(0xB2, "LESS-THAN OR EQUAL TO"),
0x2265 => array(0xB3, "GREATER-THAN OR EQUAL TO"),
0x00A5 => array(0xB4, "YEN SIGN"),
0x00B5 => array(0xB5, "MICRO SIGN"),
0x2202 => array(0xB6, "PARTIAL DIFFERENTIAL"),
0x2211 => array(0xB7, "N-ARY SUMMATION"),
0x220F => array(0xB8, "N-ARY PRODUCT"),
0x03C0 => array(0xB9, "GREEK SMALL LETTER PI"),
0x222B => array(0xBA, "INTEGRAL"),
0x00AA => array(0xBB, "FEMININE ORDINAL INDICATOR"),
0x00BA => array(0xBC, "MASCULINE ORDINAL INDICATOR"),
0x03A9 => array(0xBD, "GREEK CAPITAL LETTER OMEGA"),
0x00E6 => array(0xBE, "LATIN SMALL LETTER AE"),
0x00F8 => array(0xBF, "LATIN SMALL LETTER O WITH STROKE"),
0x00BF => array(0xC0, "INVERTED QUESTION MARK"),
0x00A1 => array(0xC1, "INVERTED EXCLAMATION MARK"),
0x00AC => array(0xC2, "NOT SIGN"),
0x221A => array(0xC3, "SQUARE ROOT"),
0x0192 => array(0xC4, "LATIN SMALL LETTER F WITH HOOK"),
0x2248 => array(0xC5, "ALMOST EQUAL TO"),
0x2206 => array(0xC6, "INCREMENT"),
0x00AB => array(0xC7, "LEFT-POINTING DOUBLE ANGLE QUOTATION MARK"),
0x00BB => array(0xC8, "RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK"),
0x2026 => array(0xC9, "HORIZONTAL ELLIPSIS"),
0x00A0 => array(0xCA, "NO-BREAK SPACE"),
0x00C0 => array(0xCB, "LATIN CAPITAL LETTER A WITH GRAVE"),
0x00C3 => array(0xCC, "LATIN CAPITAL LETTER A WITH TILDE"),
0x00D5 => array(0xCD, "LATIN CAPITAL LETTER O WITH TILDE"),
0x0152 => array(0xCE, "LATIN CAPITAL LIGATURE OE"),
0x0153 => array(0xCF, "LATIN SMALL LIGATURE OE"),
0x2013 => array(0xD0, "EN DASH"),
0x2014 => array(0xD1, "EM DASH"),
0x201C => array(0xD2, "LEFT DOUBLE QUOTATION MARK"),
0x201D => array(0xD3, "RIGHT DOUBLE QUOTATION MARK"),
0x2018 => array(0xD4, "LEFT SINGLE QUOTATION MARK"),
0x2019 => array(0xD5, "RIGHT SINGLE QUOTATION MARK"),
0x00F7 => array(0xD6, "DIVISION SIGN"),
0x25CA => array(0xD7, "LOZENGE"),
0x00FF => array(0xD8, "LATIN SMALL LETTER Y WITH DIAERESIS"),
0x0178 => array(0xD9, "LATIN CAPITAL LETTER Y WITH DIAERESIS"),
0x2044 => array(0xDA, "FRACTION SLASH"),
0x20AC => array(0xDB, "EURO SIGN"),
0x2039 => array(0xDC, "SINGLE LEFT-POINTING ANGLE QUOTATION MARK"),
0x203A => array(0xDD, "SINGLE RIGHT-POINTING ANGLE QUOTATION MARK"),
0xFB01 => array(0xDE, "LATIN SMALL LIGATURE FI"),
0xFB02 => array(0xDF, "LATIN SMALL LIGATURE FL"),
0x2021 => array(0xE0, "DOUBLE DAGGER"),
0x00B7 => array(0xE1, "MIDDLE DOT"),
0x201A => array(0xE2, "SINGLE LOW-9 QUOTATION MARK"),
0x201E => array(0xE3, "DOUBLE LOW-9 QUOTATION MARK"),
0x2030 => array(0xE4, "PER MILLE SIGN"),
0x00C2 => array(0xE5, "LATIN CAPITAL LETTER A WITH CIRCUMFLEX"),
0x00CA => array(0xE6, "LATIN CAPITAL LETTER E WITH CIRCUMFLEX"),
0x00C1 => array(0xE7, "LATIN CAPITAL LETTER A WITH ACUTE"),
0x00CB => array(0xE8, "LATIN CAPITAL LETTER E WITH DIAERESIS"),
0x00C8 => array(0xE9, "LATIN CAPITAL LETTER E WITH GRAVE"),
0x00CD => array(0xEA, "LATIN CAPITAL LETTER I WITH ACUTE"),
0x00CE => array(0xEB, "LATIN CAPITAL LETTER I WITH CIRCUMFLEX"),
0x00CF => array(0xEC, "LATIN CAPITAL LETTER I WITH DIAERESIS"),
0x00CC => array(0xED, "LATIN CAPITAL LETTER I WITH GRAVE"),
0x00D3 => array(0xEE, "LATIN CAPITAL LETTER O WITH ACUTE"),
0x00D4 => array(0xEF, "LATIN CAPITAL LETTER O WITH CIRCUMFLEX"),
0xF8FF => array(0xF0, "Apple logo"),
0x00D2 => array(0xF1, "LATIN CAPITAL LETTER O WITH GRAVE"),
0x00DA => array(0xF2, "LATIN CAPITAL LETTER U WITH ACUTE"),
0x00DB => array(0xF3, "LATIN CAPITAL LETTER U WITH CIRCUMFLEX"),
0x00D9 => array(0xF4, "LATIN CAPITAL LETTER U WITH GRAVE"),
0x0131 => array(0xF5, "LATIN SMALL LETTER DOTLESS I"),
0x02C6 => array(0xF6, "MODIFIER LETTER CIRCUMFLEX ACCENT"),
0x02DC => array(0xF7, "SMALL TILDE"),
0x00AF => array(0xF8, "MACRON"),
0x02D8 => array(0xF9, "BREVE"),
0x02D9 => array(0xFA, "DOT ABOVE"),
0x02DA => array(0xFB, "RING ABOVE"),
0x00B8 => array(0xFC, "CEDILLA"),
0x02DD => array(0xFD, "DOUBLE ACUTE ACCENT"),
0x02DB => array(0xFE, "OGONEK"),
0x02C7 => array(0xFF, "CARON"),
);

$res = html_entity_decode("&#x7F;", ENT_QUOTES, 'MacRoman');
echo "Special test for &#x7F; (shouldn't decode):\n";
echo $res,"\n\n";

foreach ($arr as $u => $v) {
    $ent = sprintf("&#x%X;", $u);
    $res = html_entity_decode($ent, ENT_QUOTES, 'MacRoman');
    $d = unpack("H*", $res);
    echo sprintf("%s: %s => %s\n", $v[1], $ent, $d[1]);
    
    $ent = sprintf("&#x%X;", $v[0]);
    $res = html_entity_decode($ent, ENT_QUOTES, 'MacRoman');
    if ($res[0] != "&" || $res[1] != "#")
        $res = unpack("H*", $res)[1];
    echo sprintf("%s => %s\n\n", $ent, $res);
}
