<?php

require_once 'base.php';

$filename = $argv[1];
$lines = explode("\n", file_get_contents($filename));

$sig = '// This doc comment block generated by idl/sysdoc.php';

$file = '';
$class = 'function';
for ($i = 0; $i < count($lines) - 1; $i++) {
  $line = $lines[$i];

  if (preg_match("#$sig#", $line)) {
    while (!preg_match('#^ +\*/$#', $line)) {
      $line = $lines[++$i];
    }
    $line = $lines[++$i];
  }

  if (preg_match('/^\s*(?:abstract\s+)?(?:class|interface)\s+(\w+)/',
                 $line, $m)) {
    $class = $m[1];
    $info['name'] = $class;
    $doc = phpnet_get_class_desc($class);

    if (empty($doc)) {
      echo "Can't connect to php.net for class description for '$class'\n";
      echo "Stopping...\n";
      exit(1);
    }

    $info['desc'] = $doc;
    $info['flags'] = 0;
    $file .= "$sig\n";
    $file .= get_class_doc_comments($info)."\n";
  } else if (preg_match('/function /', $line)) {
    while (!preg_match('/function\s+(\w+)\s*\(([^\)]*)\)/s', $line, $m)) {
      $line .= "\n".$lines[++$i];
    }
    $func = $m[1];
    $args = $m[2];

    preg_match_all('/(\&?\$\w+)/', $args, $m);
    $argdefs = $m[1];

    $doc = phpnet_get_function_info($func, $class);
    if (empty($doc)) {
      $class_msg = ($class !== 'function' ? "in class '$class'\n" : "\n");
      echo "Can't connect to php.net for function info for '$func' $class_msg";
      echo "Stopping...\n";
      exit(1);
    }

    $info['name'] = $func;
    $info['desc'] = isset($doc['desc']) ? $doc['desc'] : '';
    if (isset($doc['ret'])) {
      $info['ret_desc'] = $doc['ret'];
    }
    $args = array();
    if (!empty($argdefs)) {
      $index = 0;
      foreach ($argdefs as $name) {
        if (!isset($doc['params'][$index])) {
          print "ERROR: The docs don't have param number $index ".
                "(which you named $name) for $class::$func\n";
          continue;
        }
        $args[] = array('name' => preg_replace('/[\&\$]/', '', $name),
                        'desc' => $doc['params'][$index++],
                        'ref'  => preg_match('/&/', $name));
      }
    }
    $info['args'] = $args;
    $info['return'] = null;
    if ($class) {
      $file .= '  ';
    }
    $file .= "$sig\n";
    $file .= get_function_doc_comments($info, $class)."\n";
  }

  $file .= "$line\n";
}

file_put_contents($filename, $file);
