/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.renderers.OnTheFlyRenderer;
import net.sourceforge.pmd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVRenderer
extends OnTheFlyRenderer {
    private int violationCount = 1;

    @Override
    public void start() throws IOException {
        StringBuffer buf = new StringBuffer(300);
        this.quoteAndCommify(buf, "Problem");
        this.quoteAndCommify(buf, "Package");
        this.quoteAndCommify(buf, "File");
        this.quoteAndCommify(buf, "Priority");
        this.quoteAndCommify(buf, "Line");
        this.quoteAndCommify(buf, "Description");
        this.quoteAndCommify(buf, "Rule set");
        this.quote(buf, "Rule");
        buf.append(PMD.EOL);
        this.getWriter().write(buf.toString());
    }

    @Override
    public void renderFileViolations(Iterator<IRuleViolation> violations) throws IOException {
        StringBuffer buf = new StringBuffer(300);
        Writer writer = this.getWriter();
        while (violations.hasNext()) {
            buf.setLength(0);
            IRuleViolation rv = violations.next();
            this.quoteAndCommify(buf, Integer.toString(this.violationCount));
            this.quoteAndCommify(buf, rv.getPackageName());
            this.quoteAndCommify(buf, rv.getFilename());
            this.quoteAndCommify(buf, Integer.toString(rv.getRule().getPriority()));
            this.quoteAndCommify(buf, Integer.toString(rv.getBeginLine()));
            this.quoteAndCommify(buf, StringUtil.replaceString(rv.getDescription(), '\"', "'"));
            this.quoteAndCommify(buf, rv.getRule().getRuleSetName());
            this.quote(buf, rv.getRule().getName());
            buf.append(PMD.EOL);
            writer.write(buf.toString());
            ++this.violationCount;
        }
    }

    @Override
    public void end() throws IOException {
    }

    private void quote(StringBuffer sb, String d) {
        sb.append('\"').append(d).append('\"');
    }

    private void quoteAndCommify(StringBuffer sb, String d) {
        this.quote(sb, d);
        sb.append(',');
    }
}

