#completion for port
set -l subcommands activate archive build cat cd checksum clean configure \
    contents deactivate dependents deps destroot dir distcheck dmg echo \
    edit extract fetch file gohome info install installed lint list \
    livecheck location load log logfile mirror mdmg mpkg notes outdated \
    patch pkg provides rdependents rdeps reload rev search select \
    selfupdate setrequested setunrequested sync test unarchive uninstall \
    unload unsetrequested upgrade url usage variants version work
complete port -f -n "__fish_seen_subcommand_from $subcommands" -a '(__fish_print_port_packages)' -d Package

complete port -f -n __fish_use_subcommand -a activate -d 'Set  version of a port to active'
complete port -f -n __fish_use_subcommand -a archive -d "Create image for port without installing"
complete port -f -n __fish_use_subcommand -a build -d 'Run build phase of a port'
complete port -f -n __fish_use_subcommand -a cat -d 'Print the Portfile of the given port(s)'
complete port -f -n __fish_use_subcommand -a cd -d 'Change directory to that containing portname'
complete port -f -n __fish_use_subcommand -a checksum -d 'Compute checksums of distribution files'
complete port -f -n __fish_use_subcommand -a clean -d 'Remove temporary files used to build a port'
complete port -f -n __fish_use_subcommand -a configure -d 'Run configure phase of a port'
complete port -f -n __fish_use_subcommand -a contents -d 'List the files installed by a given port'
complete port -f -n __fish_use_subcommand -a deactivate -d 'Set the status of a port to inactive'
complete port -f -n __fish_use_subcommand -a dependents -d 'List ports that depend on a given port'
complete port -f -n __fish_use_subcommand -a deps -d 'Display a dependency listing for given port(s)'
complete port -f -n __fish_use_subcommand -a destroot -d 'Run destroot phase of a port'
complete port -f -n __fish_use_subcommand -a dir -d 'print directory with Portfile for port expression'
complete port -f -n __fish_use_subcommand -a distcheck -d 'Check if port can be fetched from all mirrors'
complete port -f -n __fish_use_subcommand -a dmg -d 'Create binary archives of a port'
complete port -f -n __fish_use_subcommand -a echo -d 'Print the list of ports the argument expands to'
complete port -f -n __fish_use_subcommand -a edit -d 'Open the Portfile in an editor'
complete port -f -n __fish_use_subcommand -a extract -d 'Run extract phase of a port'
complete port -f -n __fish_use_subcommand -a fetch -d 'Run fetch phase of a port'
complete port -f -n __fish_use_subcommand -a file -d 'Display the path to the Portfile for portname'
complete port -f -n __fish_use_subcommand -a help -d 'Get help on MacPorts commands'
complete port -f -n __fish_use_subcommand -a gohome -d 'Load home page for given portname in web browser'
complete port -f -n __fish_use_subcommand -a info -d 'Return information about the given ports'
complete port -f -n __fish_use_subcommand -a install -d 'Install a new port'
complete port -f -n __fish_use_subcommand -a installed -d 'List installed versions (of port)'
complete port -f -n __fish_use_subcommand -a lint -d 'Verifies Portfile for portname'
complete port -f -n __fish_use_subcommand -a list -d 'List latest available version for given ports'
complete port -f -n __fish_use_subcommand -a livecheck -d 'Check if new version of software is available'
complete port -f -n __fish_use_subcommand -a location -d 'Print location of archive used for (de)activation'
complete port -f -n __fish_use_subcommand -a load -d "load a port's daemon"
complete port -f -n __fish_use_subcommand -a log -d 'Parse and show log files for portname'
complete port -f -n __fish_use_subcommand -a logfile -d 'Display the path to the log file for portname'
complete port -f -n __fish_use_subcommand -a mirror -d 'Create/update local mirror of distfiles'
complete port -f -n __fish_use_subcommand -a mdmg -d 'Create disk image of portname and dependencies'
complete port -f -n __fish_use_subcommand -a mpkg -d 'Create binary archives of a port'
complete port -f -n __fish_use_subcommand -a notes -d 'Displays notes for portname'
complete port -f -n __fish_use_subcommand -a outdated -d 'List outdated ports'
complete port -f -n __fish_use_subcommand -a patch -d 'Run patch phase of a port'
complete port -f -n __fish_use_subcommand -a pkg -d 'Create binary archives of a port'
complete port -f -n __fish_use_subcommand -a provides -d 'Find the port that installed a file'
complete port -f -n __fish_use_subcommand -a rdependents -d 'Recursively list ports depending on given port'
complete port -f -n __fish_use_subcommand -a rdeps -d 'Display a recursive dependency listing of port(s)'
complete port -f -n __fish_use_subcommand -a reload -d "reload a port's daemon"
complete port -f -n __fish_use_subcommand -a rev-upgrade -d 'Rebuild ports containing broken binaries'
complete port -f -n __fish_use_subcommand -a search -d 'Search for a port using keywords'
complete port -f -n __fish_use_subcommand -a select -d 'Selects a version to be the default'
complete port -f -n __fish_use_subcommand -a selfupdate -d 'Upgrade MacPorts and update list of ports'
complete port -f -n __fish_use_subcommand -a setrequested -d 'Mark portname as requested'
complete port -f -n __fish_use_subcommand -a setunrequested -d 'Mark portname as unrequested'
complete port -f -n __fish_use_subcommand -a sync -d 'Update the port definition files'
complete port -f -n __fish_use_subcommand -a test -d 'Run test phase of a port'
complete port -f -n __fish_use_subcommand -a unarchive -d 'Extract destroot of given ports from archive'
complete port -f -n __fish_use_subcommand -a uninstall -d 'Remove a previously installed port'
complete port -f -n __fish_use_subcommand -a unload -d "Unload a port's daemon"
complete port -f -n __fish_use_subcommand -a unsetrequested -d 'Mark portname as unrequested'
complete port -f -n __fish_use_subcommand -a upgrade -d 'Upgrade a port to the latest version'
complete port -f -n __fish_use_subcommand -a url -d 'Display URL for path of given portname'
complete port -f -n __fish_use_subcommand -a usage -d 'Displays a condensed usage summary'
complete port -f -n __fish_use_subcommand -a variants -d 'Print list of variants with descriptions'
complete port -f -n __fish_use_subcommand -a version -d 'Print the MacPorts version'
complete port -f -n __fish_use_subcommand -a work -d 'Displays path to work directory for portname'

complete -c port -s v -d 'Verbose mode, generates verbose messages'
complete -c port -s d -d 'Debug mode, implies -v'
complete -c port -s q -d 'Quiet mode, implies -N'
complete -c port -s N -d 'Non-interactive mode'
complete -c port -s n -d "Don't follow dependencies in upgrade"
complete -c port -s R -d 'Also upgrade dependents (only for upgrade)'
complete -c port -s u -d 'Uninstall inactive ports'
complete -c port -s y -d 'Perform a dry run'
complete -c port -s s -d 'Source-only mode'
complete -c port -s b -d 'Binary-only mode, abort if no archive available'
complete -c port -s c -d 'Autoclean mode, execute clean after install'
complete -c port -s k -d 'Keep mode, do not autoclean after install'
complete -c port -s p -d 'Proceed to process despite any errors'
complete -c port -s o -d 'Honor state files even if Portfile was modified'
complete -c port -s t -d 'Enable trace mode debug facilities'
complete -c port -s f -d 'Force mode, ignore state file'
complete -c port -s D -d 'Specify portdir'
complete -c port -s F -d 'Read and process file of commands'
