/*******************************************************************
 * Fritz Fun                                                       *
 * Created by Jan-Michael Brummer                                  *
 * All parts are distributed under the terms of GPLv2. See COPYING *
 *******************************************************************/

/**
 * \file llevel.c
 * \brief Line-level functions
 */

#include <ffgtk.h>
#include <faxophone/faxophone.h>
#include <faxophone/isdn-convert.h>

struct sHistory {
	double fValue;
	struct sHistory *psNext;
};

/**
 * \brief Create new history
 * \return history structure
 */
static struct sHistory *historyNew( void ) {
	struct sHistory *psRoot = NULL;
	struct sHistory *psTemp;
	int nIndex;

	for ( nIndex = 0; nIndex < 10; nIndex++ ) {
		psTemp = psRoot;
		psRoot = ( struct sHistory * ) malloc( sizeof( struct sHistory ) );
		psRoot -> fValue = 0.0f;
		psRoot -> psNext= psTemp;
	}

	return psRoot;
}

/**
 * \brief Append data to history
 * \param psHistory history structure
 * \param fX new data
 * \return result
 */
static double historyAppend( struct sHistory **ppsHistory, double fX ) {
	double fResult = fX;
	struct sHistory **ppsHist = &( *ppsHistory ) -> psNext;

	/* get new maximum */
	while ( *ppsHist != NULL ) {
		if ( ( *ppsHist ) -> fValue > fResult ) {
			fResult = ( *ppsHist ) -> fValue;
		}
		ppsHist = &( *ppsHist ) -> psNext;
	}

	/* append */
	*ppsHist = *ppsHistory;
	*ppsHistory = ( *ppsHistory ) -> psNext;
	( *ppsHist ) -> psNext = NULL;
	( *ppsHist ) -> fValue = fX;

	return fResult;
}

/**
 * \brief Create line level bar
 * \param nWidth width
 * \param nHeight height
 * \return new line level bar widget
 */
GtkWidget *lineLevelBarNew( gint nWidth, gint nHeight ) {
	GtkWidget *psBar;
	GtkWidget *psProgressBar;

	/* create box which contains our progress bars */
	psBar = gtk_hbox_new( FALSE, 0 );
	gtk_widget_set_size_request( psBar, nWidth, nHeight );
	g_object_set_data( G_OBJECT( psBar ), "width", GINT_TO_POINTER( nWidth ) );

	/* progress bar: fast/slow relation progressbar */
	psProgressBar = gtk_progress_bar_new();

	//gtk_progress_set_percentage( GTK_PROGRESS( psProgressBar ), 0.0 );
	gtk_progress_bar_set_fraction( GTK_PROGRESS_BAR( psProgressBar ), 0.0 );
	g_object_set_data( G_OBJECT( psBar ), "pbar1", psProgressBar );
	gtk_widget_set_size_request( psProgressBar, 1, -1 );
	gtk_box_pack_start( GTK_BOX( psBar ), psProgressBar, TRUE, TRUE, 0 );
	gtk_widget_show( psProgressBar );

	/* Rest */
	//psProgressBar = gtk_progress_bar_new();

	//gtk_progress_bar_set_fraction( GTK_PROGRESS_BAR( psProgressBar ), 0.0 );
	//gtk_widget_set_size_request( psProgressBar, nWidth - 1, -1 );
	//g_object_set_data( G_OBJECT( psBar ), "pbar2", psProgressBar );
	g_object_set_data( G_OBJECT( psBar ), "history", historyNew() );
	//gtk_box_pack_start( GTK_BOX( psBar ), psProgressBar, TRUE, TRUE, 0 );
	//gtk_widget_show( psProgressBar );

	return psBar;
}

/**
 * \brief Set progress of line level bar
 * \param psBar line level bar
 * \param fMax maximum progress
 */
void lineLevelSet( GtkWidget *psBar, double fMax ) {
	GtkWidget *psBar1 = g_object_get_data( G_OBJECT( psBar ), "pbar1" );
	//GtkWidget *psBar2 = g_object_get_data( G_OBJECT( psBar ), "pbar2" );
	GtkWidget *psRelated = g_object_get_data( G_OBJECT( psBar ), "bar" );
	struct sHistory *psHistory = g_object_get_data( G_OBJECT( psBar ), "history" );
	double fMaxMax = psHistory ? historyAppend( &psHistory, fMax ) : fMax;
	//int nWidth = GPOINTER_TO_INT( g_object_get_data( G_OBJECT( psBar ), "width" ) );
	//int nBar1Size;
	double fPercentage;

	g_object_set_data( G_OBJECT( psBar ), "history", psHistory );

	//nBar1Size = fMaxMax * ( nWidth - 2 ) + 1;
	//Debug( KERN_DEBUG, "nSize: %d %d\n", nBar1Size, nWidth - nBar1Size );
	//gtk_widget_set_size_request( psBar1, nBar1Size, -1 );
	//gtk_widget_set_size_request( psBar2, nWidth - nBar1Size, -1 );
	fPercentage = fMaxMax > 0.0 ? fMax / fMaxMax : 0.0;
	gtk_progress_bar_set_fraction( GTK_PROGRESS_BAR( psBar1 ), fPercentage );

	if ( psRelated ) {
		//Debug( KERN_DEBUG, "Set related!!\n" );
		lineLevelSet( psRelated, fMax );
	}
}
