/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.Delaunay;
import visad.ErrorEstimate;
import visad.Irregular1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.MathType;
import visad.SetType;
import visad.Unit;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryCoordinateSystem;
import visad.data.visad.object.BinaryDelaunay;
import visad.data.visad.object.BinaryErrorEstimate;
import visad.data.visad.object.BinaryFloatMatrix;
import visad.data.visad.object.BinaryIntegerArray;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinarySerializedObject;
import visad.data.visad.object.BinarySetType;
import visad.data.visad.object.BinaryUnit;
import visad.data.visad.object.BinaryUnknown;

public class BinaryIrregularSet
implements BinaryObject {
    public static final int computeBytes(float[][] samples, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Delaunay delaunay) {
        int unitsLen = BinaryUnit.computeBytes(units);
        int errorsLen = BinaryErrorEstimate.computeBytes(errors);
        return 11 + BinaryFloatMatrix.computeBytes(samples) + (cs == null ? 0 : 5) + (unitsLen == 0 ? 0 : unitsLen + 1) + (errorsLen == 0 ? 0 : errorsLen + 1) + (delaunay == null ? 0 : BinaryDelaunay.computeBytes(delaunay)) + 1;
    }

    public static final IrregularSet read(BinaryReader reader, byte dataType) throws IOException, VisADException {
        int dim;
        BinaryObjectCache cSysCache = reader.getCoordinateSystemCache();
        BinaryObjectCache typeCache = reader.getTypeCache();
        DataInput file = reader.getInput();
        int typeIndex = file.readInt();
        SetType st = (SetType)typeCache.get(typeIndex);
        float[][] samples = null;
        CoordinateSystem cs = null;
        Unit[] units = null;
        ErrorEstimate[] errs = null;
        Delaunay delaunay = null;
        boolean reading = true;
        block23: while (reading) {
            byte directive;
            try {
                directive = file.readByte();
            }
            catch (EOFException eofe) {
                return null;
            }
            switch (directive) {
                case 6: {
                    samples = BinaryFloatMatrix.read(reader);
                    continue block23;
                }
                case 32: {
                    int index = file.readInt();
                    cs = (CoordinateSystem)cSysCache.get(index);
                    continue block23;
                }
                case 40: {
                    units = BinaryUnit.readList(reader);
                    continue block23;
                }
                case 41: {
                    errs = BinaryErrorEstimate.readList(reader);
                    continue block23;
                }
                case 21: {
                    delaunay = (Delaunay)BinarySerializedObject.read(file);
                    continue block23;
                }
                case 60: {
                    delaunay = BinaryDelaunay.read(file);
                    continue block23;
                }
                case 80: {
                    reading = false;
                    continue block23;
                }
            }
            throw new IOException("Unknown IrregularSet directive " + directive);
        }
        if (st == null) {
            throw new IOException("No SetType found for IrregularSet");
        }
        switch (dataType) {
            case 40: {
                dim = 1;
                break;
            }
            case 41: {
                dim = 2;
                break;
            }
            case 42: {
                dim = 3;
                break;
            }
            case 39: {
                dim = -1;
                break;
            }
            default: {
                throw new IOException("Unknown IrregularSet type " + dataType);
            }
        }
        if (dim > 0 && samples.length != dim) {
            throw new VisADException("Expected " + dim + "D sample array, not " + samples.length + "D");
        }
        if (dataType == 40 && delaunay != null) {
            System.err.println("Delaunay ignored for Irregular1DSet");
        }
        switch (dataType) {
            case 40: {
                return new Irregular1DSet((MathType)st, samples, cs, units, errs);
            }
            case 41: {
                return new Irregular2DSet(st, samples, cs, units, errs, delaunay);
            }
            case 42: {
                return new Irregular3DSet(st, samples, cs, units, errs, delaunay);
            }
            case 39: {
                return new IrregularSet(st, samples, cs, units, errs, delaunay);
            }
        }
        throw new IOException("Unknown IrregularSet type " + dataType);
    }

    public static final void writeDependentData(BinaryWriter writer, SetType type, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, IrregularSet set, Class canonicalClass, Object token) throws IOException {
        if (!(set.getClass().equals(canonicalClass) || set instanceof IrregularSet && set instanceof Saveable)) {
            return;
        }
        BinarySetType.write(writer, type, set, SAVE_DATA);
        if (cs != null) {
            BinaryCoordinateSystem.write(writer, cs, SAVE_DATA);
        }
        if (units != null) {
            BinaryUnit.writeList(writer, units, SAVE_DATA);
        }
        if (errors != null) {
            BinaryErrorEstimate.writeList(writer, errors, SAVE_DATA);
        }
    }

    public static final void write(BinaryWriter writer, SetType type, float[][] samples, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Delaunay delaunay, IrregularSet set, Class canonicalClass, byte dataType, Object token) throws IOException {
        int validLen;
        BinaryIrregularSet.writeDependentData(writer, type, cs, units, errors, set, canonicalClass, token);
        if (token == SAVE_DEPEND || token == SAVE_DEPEND_BIG) {
            return;
        }
        if (!(set.getClass().equals(canonicalClass) || set instanceof IrregularSet && set instanceof Saveable)) {
            BinaryUnknown.write(writer, set, token);
            return;
        }
        if (samples == null) {
            throw new IOException("Null " + canonicalClass.getName() + " samples");
        }
        switch (dataType) {
            case 40: {
                validLen = 1;
                break;
            }
            case 41: {
                validLen = 2;
                break;
            }
            case 42: {
                validLen = 3;
                break;
            }
            case 39: {
                validLen = -1;
                break;
            }
            default: {
                throw new IOException("Invalid type " + dataType);
            }
        }
        if (validLen > 0 && samples.length != validLen) {
            throw new IOException("Expected " + validLen + " sample list" + (validLen > 1 ? "s" : "") + ", not " + samples.length);
        }
        int typeIndex = writer.getTypeCache().getIndex(type);
        if (typeIndex < 0) {
            throw new IOException("SetType " + type + " not cached");
        }
        int csIndex = -1;
        if (cs != null && (csIndex = writer.getCoordinateSystemCache().getIndex(cs)) < 0) {
            throw new IOException("CoordinateSystem " + cs + " not cached");
        }
        int[] unitsIndex = null;
        if (units != null) {
            unitsIndex = BinaryUnit.lookupList(writer.getUnitCache(), units);
        }
        int[] errorsIndex = null;
        if (errors != null) {
            errorsIndex = BinaryErrorEstimate.lookupList(writer.getErrorEstimateCache(), errors);
        }
        int objLen = BinaryIrregularSet.computeBytes(samples, cs, units, errors, delaunay);
        DataOutput file = writer.getOutput();
        file.writeByte(2);
        file.writeInt(objLen);
        file.writeByte(dataType);
        file.writeInt(typeIndex);
        file.writeByte(6);
        BinaryFloatMatrix.write(writer, samples, token);
        if (csIndex >= 0) {
            file.writeByte(32);
            file.writeInt(csIndex);
        }
        if (unitsIndex != null) {
            file.writeByte(40);
            BinaryIntegerArray.write(writer, unitsIndex, token);
        }
        if (errorsIndex != null) {
            file.writeByte(41);
            BinaryIntegerArray.write(writer, errorsIndex, token);
        }
        if (delaunay != null) {
            BinaryDelaunay.write(writer, delaunay, token);
        }
        file.writeByte(80);
    }
}

