#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core.i18n import _
from fenrirscreenreader.utils import mark_utils


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("Reads from the top of the screen to the cursor position")

    def run(self):
        # Prefer review cursor over text cursor
        if self.env["screen"]["newCursorReview"]:
            cursor_pos = self.env["screen"]["newCursorReview"].copy()
        else:
            cursor_pos = self.env["screen"]["new_cursor"].copy()

        text_before_cursor = mark_utils.get_text_before_mark(
            cursor_pos, self.env["screen"]["new_content_text"]
        )

        if text_before_cursor.isspace():
            self.env["runtime"]["OutputManager"].present_text(
                _("blank"), sound_icon="EmptyLine", interrupt=True
            )
        else:
            self.env["runtime"]["OutputManager"].present_text(
                text_before_cursor, interrupt=True
            )

    def set_callback(self, callback):
        pass
