#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core.i18n import _
from fenrirscreenreader.utils import screen_utils


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("Reads attributes of current cursor position")

    def run(self):
        cursor_pos = self.env["runtime"][
            "CursorManager"
        ].get_review_or_text_cursor()
        try:
            attributes = self.env["runtime"][
                "AttributeManager"
            ].get_attribute_by_xy(cursor_pos["x"], cursor_pos["y"])
        except Exception as e:
            print(e)
        attribute_format_string = self.env["runtime"][
            "SettingsManager"
        ].get_setting("general", "attribute_format_string")
        attribute_format_string = self.env["runtime"][
            "AttributeManager"
        ].format_attributes(attributes, attribute_format_string)

        self.env["runtime"]["OutputManager"].present_text(
            attribute_format_string, sound_icon="", interrupt=True
        )

    def set_callback(self, callback):
        pass
