/*
 * $Id: conn_eth.c,v 1.10 2012-02-22 09:27:20 siflkres Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "conn_eth.h"

#define CHIP_(x) conn_eth_ ## x

struct cpssp {
	struct sig_eth *port_board;
	struct sig_eth *port_eth;
};

static void
CHIP_(out_recv)(void *_cpssp, const void *buf, unsigned int buflen)
{
	struct cpssp *cpssp = _cpssp;

	sig_eth_send(cpssp->port_eth, cpssp, buf, buflen);
}

static void
CHIP_(in_recv)(void *_cpssp, const void *buf, unsigned int buflen)
{
	struct cpssp *cpssp = _cpssp;

	sig_eth_send(cpssp->port_board, cpssp, buf, buflen);
}

void *
CHIP_(create)(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_eth *port_board,
	struct sig_eth *port_eth
)
{
	static const struct sig_eth_funcs board_funcs = {
		.recv = CHIP_(out_recv),
	};
	static const struct sig_eth_funcs eth_funcs = {
		.recv = CHIP_(in_recv),
	};
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	/* Call */
	cpssp->port_board = port_board;
	sig_eth_connect(port_board, cpssp, &board_funcs);

	cpssp->port_eth = port_eth;
	sig_eth_connect(port_eth, cpssp, &eth_funcs);

	/* Out */
	/* In */

	return cpssp;
}

void
CHIP_(destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
CHIP_(suspend)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
CHIP_(resume)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_resume(cpssp, sizeof(*cpssp), fComp);
}
