/* $Id: arch_gen_cpu_x86_kernel_fast.c,v 1.6 2009-01-28 12:59:15 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#if USE_KFAUM

#include "../../modopt-linux/kfaum/kfaum.h"

int NAME_(kfaum_enabled) = 0;
static int kfaum_fd;
static struct kfaum_cpu_state cpu_state;
static struct kfaum_flush flush_map;
static struct kfaum_flush flush_dirty;

static struct kfaum_fpstate fpstate;
// static struct kfaum_fpxstate fpxstate __attribute__((aligned(16)));

int
NAME_(kfaum_init)(void)
{
	int version;
	struct kfaum_init init;
	int ret;

	kfaum_fd = open("/dev/kfaum", O_RDWR, 0);
	if (kfaum_fd < 0) {
		fprintf(stderr, "%s: can't open %s: errno=%d.\n", "FAUmachine",
				"/dev/kfaum", errno);
		return -1;
	}

	ret = ioctl(kfaum_fd, KFAUM_GETVERSION, &version);
	if (version != KFAUM_VERSION) {
		fprintf(stderr, "%s: kernel module version mismatch:\n",
				"FAUmachine");
		fprintf(stderr, "\tmodule version: %d.%d.%d\n",
				(version >> 16) & 0xff,
				(version >>  8) & 0xff,
				(version >>  0) & 0xff);
		fprintf(stderr, "\tsimulator version: %d.%d.%d\n",
				(KFAUM_VERSION >> 16) & 0xff,
				(KFAUM_VERSION >>  8) & 0xff,
				(KFAUM_VERSION >>  0) & 0xff);
		ret = close(kfaum_fd);
		assert(0 <= ret);
		return -1;
	}

	init.phys = NAME_(mmu_l1_phys_map);
	init.cpu_state = &cpu_state;
	init.flush_map = &flush_map;
	init.flush_dirty = &flush_dirty;
	ret = ioctl(kfaum_fd, KFAUM_INIT, &init);
	assert(0 <= ret);

	fprintf(stderr, "Using kfaum accelerator.\n");
	NAME_(kfaum_enabled) = 1;
	return 0;
}

int
NAME_(kfaum_protect_page)(uint64_t page)
{
	if (flush_dirty.npages < sizeof(flush_dirty.page) / sizeof(flush_dirty.page[0])) {
		flush_dirty.page[flush_dirty.npages++] = page >> 12;
	} else {
		flush_dirty.npages = 0xffffffff;
	}

	return 0;
}

int
NAME_(kfaum_flush_page)(unsigned long page)
{
	if (flush_map.npages < sizeof(flush_map.page) / sizeof(flush_map.page[0])) {
		flush_map.page[flush_map.npages++] = page;
	} else {
		flush_map.npages = 0xffffffff;
	}

	return 0;
}

int
NAME_(kfaum_flush_all)(int global)
{
	flush_map.npages = 0xffffffff;

	return 0;
}

#if 1
static void
kfaum_dump(struct CPUState *s)
{
	unsigned long addr;
	unsigned long p0;
	unsigned long p1;

	fprintf(stderr, "eip=%08lx, eflags=%08lx\n",
			(unsigned long) s->eip, (unsigned long) s->eflags);
	fprintf(stderr, "eax=%08lx, ebx=%08lx, ecx=%08lx, edx=%08lx\n",
			(unsigned long) s->regs[0], (unsigned long) s->regs[3],
			(unsigned long) s->regs[1], (unsigned long) s->regs[2]);
	fprintf(stderr, "edi=%08lx, esi=%08lx, ebp=%08lx, esp=%08lx\n",
			(unsigned long) s->regs[7], (unsigned long) s->regs[6],
			(unsigned long) s->regs[5], (unsigned long) s->regs[4]);
	fprintf(stderr, "cr0=%08lx, cr2=%08lx, cr3=%08lx, cr4=%08lx\n",
			(unsigned long) s->cr[0], (unsigned long) s->cr[2],
			(unsigned long) s->cr[3], (unsigned long) s->cr[4]);
	fprintf(stderr, "cs=%04x, ss=%04x, ldt=%04x, tr=%04x\n",
			(unsigned short) s->segs[1].selector,
			(unsigned short) s->segs[2].selector,
			(unsigned short) s->ldt.selector,
			(unsigned short) s->tr.selector);
	fprintf(stderr, "ds=%04x, es=%04x, fs=%04x, gs=%04x\n",
			(unsigned short) s->segs[3].selector,
			(unsigned short) s->segs[0].selector,
			(unsigned short) s->segs[4].selector,
			(unsigned short) s->segs[5].selector);
	fprintf(stderr, "gdt=%04x:%08lx, idt=%04x:%08lx\n",
			(unsigned short) s->gdt.limit,
			(unsigned long) s->gdt.base,
			(unsigned short) s->idt.limit,
			(unsigned long) s->idt.base);
	fprintf(stderr, "intno=%d, errno=%04x, isint=%d, next_eip=%08lx\n",
			s->exception_index, s->error_code, s->exception_is_int,
			(unsigned long) s->exception_next_eip);

	addr = 0;
	do {
		p0 = (unsigned long) NAME_(mmu_l1_phys_map)[addr >> 22];
		if (p0 != 0) {
			p1 = *((unsigned long *) p0 + ((addr >> 12) & 0x3ff));
			fprintf(stderr, "%08lx: %08lx %08lx\n", addr, p0, p1);
		}
		addr += 4096;
	} while (addr != 0);
}
#endif

int
NAME_(kfaum_exec)(struct CPUState *s)
{
	struct kfaum_cpu_state *ks = &cpu_state;
	int i;
	int j;
	int retval;
	int ret;

#if 0
	fprintf(stderr, "Starting kfaum simulation\n");
	kfaum_dump(s);
#endif

	/*
	 * Copy state.
	 */
	for (i = 0; i < 8; i++) {
		ks->regs[i] = s->regs[i];
	}
	ks->eip = s->eip;
	ks->eflags = s->eflags;

	for (i = 0; i < 5; i++) {
		ks->cr[i] = s->cr[i];
	}
	for (i = 0; i < 8; i++) {
		ks->dr[i] = s->dr[i];
	}

	/* Segment registers */
	for (i = 0; i < 6; i++) {
		ks->segs[i].selector = s->segs[i].selector;
		ks->segs[i].base = (unsigned long) s->segs[i].base;
		ks->segs[i].limit = s->segs[i].limit;
		ks->segs[i].flags = s->segs[i].flags;
	}

	ks->ldt.selector = s->ldt.selector;
	ks->ldt.base = (unsigned long) s->ldt.base;
	ks->ldt.limit = s->ldt.limit;
	ks->ldt.flags = s->ldt.flags;

	ks->tr.selector = s->tr.selector;
	ks->tr.base = (unsigned long) s->tr.base;
	ks->tr.limit = s->tr.limit;
	ks->tr.flags = s->tr.flags;

	ks->gdt.base = (unsigned long) s->gdt.base;
	ks->gdt.limit = s->gdt.limit;

	ks->idt.base = (unsigned long) s->idt.base;
	ks->idt.limit = s->idt.limit;

	/* MSRs */
#if CONFIG_CPU >= 80486 && CONFIG_CPU_SEP_SUPPORT
	ks->sysenter_cs = s->sysenter_cs;
	ks->sysenter_esp = s->sysenter_esp;
	ks->sysenter_eip = s->sysenter_eip;
#endif

	/* Interrupt/exception/syscall info */
	/* ks->exception_index = 0; */
	/* ks->error_code = 0; */
	/* ks->interrupt_request = 0; */

	/* FPU */
	if (! (s->cr[0] & CPU_CR0_TS_MASK)) {
		if (0) {	/* FIXME VOSSI */
			/* fxrstor */
		} else {
			/* frstor */
			struct kfaum_fpstate *fp = &ks->fpstate;
			int fptag;

			asm volatile (
				"fsave %0\n\t"
				: "=m" (fpstate)
			);

			fp->fpuc = s->fpuc;
			fp->fpus = (s->fpus & ~0x3800) | (s->fpstt & 0x7) << 11;
			fptag = 0;
			for (i = 7; 0 <= i; i--) {
				fptag <<= 2;
				if (s->fptags[i]) {
					fptag |= 3;
				} else {
					/* the FPU automatically computes it */
				}
			}
			fp->fptag = fptag;
			j = s->fpstt;
			for (i = 0; i < 8; i++) {
				memcpy(&fp->fpregs1[i * 10], &s->fpregs[j],
						sizeof(fp->fpregs1[i * 10]));
				j = (j + 1) & 7;
			}

			asm volatile (
				"frstor %0\n\t"
				: "=m" (*fp)
			);
		}
	}

	/* Misc */
	ks->a20 = (s->a20_mask >> 20) & 1;

	/*
	 * Do simulation.
	 */
	ret = ioctl(kfaum_fd, KFAUM_EXEC, &retval);
	if (ret < 0) {
		kfaum_dump(s);
	}
	assert(ret == 0 || (ret == 1 && ks->exception_index == -1));

	/*
	 * Copy back state.
	 */
	/* Misc */
	/* s->a20_mask = 0xffefffff & (ks->a20 << 20); */

	/* FPU */
	if (! (s->cr[0] & CPU_CR0_TS_MASK)) {
		if (0) {	/* FIXME VOSSI */
			/* fxsave */
		} else {
			/* fsave */
			struct kfaum_fpstate *fp = &ks->fpstate;
			int fptag;

			asm volatile (
				"fsave %0\n\t"
				: "=m" (*fp)
			);

			s->fpuc = fp->fpuc;
			s->fpstt = (fp->fpus >> 11) & 7;
			s->fpus = fp->fpus & ~0x3800;
			fptag = fp->fptag;
			for (i = 0; i < 8; i++) {
				s->fptags[i] = ((fptag & 3) == 3);
				fptag >>= 2;
			}
			j = s->fpstt;
			for (i = 0; i < 8; i++) {
				memcpy(&s->fpregs[j], &fp->fpregs1[i * 10],
						sizeof(s->fpregs[j]));
				j = (j + 1) & 7;
			}

			asm volatile (
				"frstor %0\n\t"
				: "=m" (fpstate)
			);
		}
	}

	/* Interrupt/exception/syscall info */
	s->exception_index = ks->exception_index;
	s->error_code = ks->error_code;
	s->exception_is_int = ks->exception_is_int;
	s->exception_next_eip = ks->exception_next_eip;

	/* MSRs */
#if CONFIG_CPU >= 80486 && CONFIG_CPU_SEP_SUPPORT
	/* s->sysenter_cs = ...; */
	/* s->sysenter_esp = ...; */
	/* s->sysenter_eip = ...; */
#endif

	/* Segment registers */
	/* s->idt.base = ks->idt.base; */
	/* s->idt.limit = ks->idt.limit; */

	/* s->gdt.base = ks->gdt.base; */
	/* s->gdt.limit = ks->gdt.limit; */

	/* s->tr.selector = ks->tr.selector; */
	/* s->tr.base = ks->tr.base; */
	/* s->tr.limit = ks->tr.limit; */
	/* s->tr.flags = ks->tr.flags; */

	/* s->ldt.selector = ks->ldt.selector; */
	/* s->ldt.base = ks->ldt.base; */
	/* s->ldt.limit = ks->ldt.limit; */
	/* s->ldt.flags = ks->ldt.flags; */

	for (i = 0; i < 6; i++) {
		s->segs[i].selector = ks->segs[i].selector;
		s->segs[i].base = ks->segs[i].base;
		s->segs[i].limit = ks->segs[i].limit;
		s->segs[i].flags = ks->segs[i].flags;
	}

	s->dr[6] = ks->dr[6];
	s->cr[2] = ks->cr[2];

	s->eflags = ks->eflags;
	s->eip = ks->eip;
	for (i = 0; i < 8; i++) {
		s->regs[i] = ks->regs[i];
	}

	if (flush_dirty.npages == 0xffffffff) {
		assert(0); /* FIXME */
	} else for (i = 0; i < flush_dirty.npages; i++) {
		NAME_(tb_invalidate_phys_page_fast)(
				flush_dirty.page[i] << 12, 4096);
	}
	flush_dirty.npages = 0;

#if 0
	fprintf(stderr, "Stopping kfaum simulation\n");
	kfaum_dump(s);
#endif

	return retval;
}

#endif /* USE_KFAUM */
