/* $Id: UnconstrainedArrayType.hpp 4850 2009-12-02 16:35:02Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __UNCONSTRAINED_ARRAY_TYPE_HPP_INCLUDED
#define __UNCONSTRAINED_ARRAY_TYPE_HPP_INCLUDED

#include "frontend/ast/TypeDeclaration.hpp"
#include "frontend/ast/SubtypeIndication.hpp"

namespace ast {

//! a VHDL array type.
/** This class represents a VHDL unconstrained array type declaration.
 */
class UnconstrainedArrayType : public TypeDeclaration {
public:
	//! c'tor
	/** @param declName name of the declaration.
          * @param indexTs list of index type marks.
          * @param elementT type mark of array elements.
          * @param loc location of the declaration.
          */
	UnconstrainedArrayType(
		std::string *declName,
		std::list<TypeDeclaration*> *indexTs,
		TypeDeclaration *elementT,
		Location loc
		) : 	TypeDeclaration(declName, loc, BASE_TYPE_ARRAY),
			indexTypes(indexTs),
			elementType(elementT),
			numIndices(indexTs->size()) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor &visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		assert(this->name != NULL);

		stream << *this->name << ": ARRAY<>(";
		util::MiscUtil::listPut(this->indexTypes, stream, ", ");
		stream << ") OF " << this->elementType;
	}


	/** one type mark for each index. */
	std::list<TypeDeclaration*> *indexTypes;

	/** type mark of array elements */
	TypeDeclaration *elementType;

	/** number of indices */
	size_t numIndices;

protected:
	/** Destructor */
	virtual ~UnconstrainedArrayType() {
		util::MiscUtil::lterminate(indexTypes);
	}
};

}; /* namespace ast */

#endif /* __UNCONSTRAINED_ARRAY_TYPE_HPP_INCLUDED */
