# Existing plugins

EZTrace ships several plugins for the main parallel programming libraries.

### MPI

The MPI plugin traces MPI communications (including non-blocking
collectives), and supports MPI communicators. It supports the C and
Fortran interfaces.

It does not support (yet) MPI-IO primitives.

### OpenMP

EZTrace ships two plugins for OpenMP:
- `ompt` uses the OMPT interface to trace OpenMP parallel regions, loops, task, etc.

- `openmp` intercepts calls to the GNU OpenMP runtime system. It can
  only trace parallel region with GNU OpenMP. You can also instrument
  your OpenMP application with Opari to collect more events (including
  loops, tasks, ...), and to make it work with any OpenMP implementation

### Pthread

EZTrace traces pthread creation/destruction. You can also use the
`pthread` plugin to trace pthread synchronization functions
(eg. `pthread_mutex_*`, `pthread_cond_*`.

### PosixIO

EZTrace `posixio` plugin traces calls to PosixIO functions (`open`,
`read`, `write`, `dup`, `fread`, `fwrite`, ...

### Memory

EZTrace `memory` plugin traces calls to dynamic memory allocation functions (`malloc`,
`realloc`, `calloc`, `free`,  ...


### IOTracer

EZTrace `iotracer` plugin uses IOTracer to trace IO events that happen
within the Linux kernel. See [EZIOTracer webpage](https://gitlab.com/idiom1/eziotrace)
for instructions.


### CUDA

EZTrace `cuda` plugin traces CUDA events (memory copy, kernel
invocation, etc.) By default, the plugin captures events located on
the GPU (using the CUPTI interface), as well as calls to the CUDA
runtime API happening on the CPU.

#### Available options

Several options are availble for the `cuda` module. They can be specified using environment variables:

- `EZTRACE_CUDA_DRIVER`: enable tracing of the CUDA driver API, set 
- `EZTRACE_CUDA_BUFFER_SIZE=x`: set the size of the CUDA event buffer (default value: `2097152` bytes)


### NETCDF

EZTrace `netcdf` plugin traces calls to the [NetCDF](https://www.unidata.ucar.edu/software/netcdf/) library.

### PNETCDF

EZTrace `pnetcdf` plugin traces calls to the [PNetCDF](https://parallel-netcdf.github.io/) library.

### StarPU

EZTrace `starpu` plugin traces [StarPU](https://starpu.gitlabpages.inria.fr/)
events (task creation, task execution, etc.)

### Compiler_instrumentation

Module for tracing compiler-instrumented functions.

### PAPI (currently not supported)

EZTrace `papi` plugin collect harware counters using the PAPI library.
This plugin is currently not supported (we need to
port it to use the OTF2 trace format)


# Generating custom plugins

EZTrace supports user-defined plugins. The easiest way to create a new
plugin is probably to use [EZTrace's plugin
generator](https://gitlab.com/eztrace/eztrace-plugin-generator).

Once the plugin is installed in `<PLUGIN_DIRECTORY>` created, set
`EZTRACE_LIBRARY_PATH` accordingly, and check that the plugin is detected:

```
$ export EZTRACE_LIBRARY_PATH=<PLUGIN_DIRECTORY>
$ eztrace_avail
Available modules:
[...]
libstencil      "Module for the libstencil library"
```


[This
tutorial](https://gitlab.com/eztrace/tutorials/compas-2025#creating-an-eztrace-plugin)
illustrates the creation of user-defined plugins.
