/*
 * --- GSMP-COPYRIGHT-NOTE-BEGIN ---
 * 
 * This copyright note is auto-generated by ./scripts/Create-CopyPatch.
 * Please add additional copyright information _after_ the line containing
 * the GSMP-COPYRIGHT-NOTE-END tag. Otherwise it might get removed by
 * the ./scripts/Create-CopyPatch script. Do not edit this copyright text!
 * 
 * GSMP: utility/include/SplitStreamBuffer.hh
 * General Sound Manipulation Program is Copyright (C) 2000 - 2004
 *   Valentin Ziegler and Ren Rebe
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2. A copy of the GNU General
 * Public License can be found in the file LICENSE.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT-
 * ABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 * 
 * --- GSMP-COPYRIGHT-NOTE-END ---
 */
#ifndef UTILITY__SPLITSTREAMBUFFER_HH__
#define UTILITY__SPLITSTREAMBUFFER_HH__

#include <ostream>

namespace Utility
{
  // a std::streambuffer implementation that forwards output to two
  // std::ostreams. Usage example (w.o. namespaces): 
  //
  // ostream (new SplitStreamBuffer (cout, logfile)) logstream;
  // logstream << "Hello world" << endl;

  class SplitStreamBuffer : public std::streambuf
  {
  public:
    SplitStreamBuffer (std::ostream& forward1, std::ostream& forward2)
      : fw1(forward1), fw2(forward2) { }

  protected:
    virtual int_type overflow (int_type c);

    std::ostream& fw1;
    std::ostream& fw2;
  };

} // end namespace Utility

#define UTILITY__SPLITSTREAMBUFFER_TMPL__
#include "template/SplitStreamBuffer.tcc"
#undef UTILITY__SPLITSTREAMBUFFER_TMPL__

#endif // UTILITY__SPLITSTREAMBUFFER_HH__
