/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.SequenceI;
import jalview.io.JPredFile;

public class JnetAnnotationMaker {
    public static void add_annotation(JPredFile prediction, AlignmentI al, int firstSeq, boolean noMsa) throws Exception {
        JnetAnnotationMaker.add_annotation(prediction, al, firstSeq, noMsa, null);
    }

    public static void add_annotation(JPredFile prediction, AlignmentI al, int firstSeq, boolean noMsa, int[] delMap) throws Exception {
        int i = 0;
        SequenceI[] preds = prediction.getSeqsAsArray();
        SequenceI seqRef = al.getSequenceAt(firstSeq);
        int width = preds[0].getSequence().length;
        int[] gapmap = al.getSequenceAt(firstSeq).gapMap();
        if (delMap != null && delMap.length > width || delMap == null && gapmap.length != width) {
            throw new Exception("Number of residues in " + (delMap == null ? "" : " mapped ") + "supposed query sequence ('" + al.getSequenceAt(firstSeq).getName() + "'\n" + al.getSequenceAt(firstSeq).getSequenceAsString() + ")\ndiffer from number of prediction sites in prediction (" + width + ")");
        }
        Annotation[] annotations = null;
        int existingAnnotations = 0;
        if (al.getAlignmentAnnotation() != null) {
            existingAnnotations = al.getAlignmentAnnotation().length;
        }
        while (i < preds.length) {
            String id = preds[i].getName().toUpperCase();
            if (id.startsWith("LUPAS") || id.startsWith("JNET") || id.startsWith("JPRED")) {
                int j;
                annotations = new Annotation[al.getWidth()];
                if (id.equals("JNETPRED") || id.equals("JNETPSSM") || id.equals("JNETFREQ") || id.equals("JNETHMM") || id.equals("JNETALIGN") || id.equals("JPRED")) {
                    if (delMap == null) {
                        for (j = 0; j < width; ++j) {
                            annotations[gapmap[j]] = new Annotation("", "", preds[i].getCharAt(j), 0.0f);
                        }
                    } else {
                        for (j = 0; j < width; ++j) {
                            annotations[gapmap[delMap[j]]] = new Annotation("", "", preds[i].getCharAt(j), 0.0f);
                        }
                    }
                } else if (id.equals("JNETCONF")) {
                    float value;
                    if (delMap == null) {
                        for (j = 0; j < width; ++j) {
                            value = new Float(preds[i].getCharAt(j) + "").floatValue();
                            annotations[gapmap[j]] = new Annotation(preds[i].getCharAt(j) + "", "", preds[i].getCharAt(j), value);
                        }
                    } else {
                        for (j = 0; j < width; ++j) {
                            value = new Float(preds[i].getCharAt(j) + "").floatValue();
                            annotations[gapmap[delMap[j]]] = new Annotation(preds[i].getCharAt(j) + "", "", preds[i].getCharAt(j), value);
                        }
                    }
                } else if (delMap == null) {
                    for (j = 0; j < width; ++j) {
                        annotations[gapmap[j]] = new Annotation(preds[i].getCharAt(j) + "", "", ' ', 0.0f);
                    }
                } else {
                    for (j = 0; j < width; ++j) {
                        annotations[gapmap[delMap[j]]] = new Annotation(preds[i].getCharAt(j) + "", "", ' ', 0.0f);
                    }
                }
                AlignmentAnnotation annot = id.equals("JNETCONF") ? new AlignmentAnnotation(preds[i].getName(), "JNet Output", annotations, 0.0f, 10.0f, 1) : new AlignmentAnnotation(preds[i].getName(), "JNet Output", annotations);
                if (seqRef != null) {
                    annot.createSequenceMapping(seqRef, 1, true);
                    seqRef.addAlignmentAnnotation(annot);
                }
                al.addAnnotation(annot);
                al.setAnnotationIndex(annot, al.getAlignmentAnnotation().length - existingAnnotations - 1);
                if (noMsa) {
                    al.deleteSequence(preds[i]);
                }
            }
            ++i;
        }
    }
}

