/*******************************************************************************
 * Copyright (c) 2003, 2015 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Thibault Le Ouay <thibaultleouay@gmail.com> - Bug 457870
 *******************************************************************************/
package org.eclipse.ui.tests.navigator;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.internal.navigator.filters.UpdateActiveFiltersOperation;
import org.junit.Test;

public class OpenTest extends NavigatorTestBase {

	public OpenTest()
	{
		_navigatorInstanceId = TEST_VIEWER;
	}

	@Test
	public void testNavigatorRootContents() throws Exception {

		_contentService.getActivationService().activateExtensions(
				new String[] { COMMON_NAVIGATOR_RESOURCE_EXT }, true);

		// Remove all of the filters
		IUndoableOperation updateFilters = new UpdateActiveFiltersOperation(
				_viewer, new String[0]);
		updateFilters.execute(null, null);

		refreshViewer();
		_viewer.expandAll();

		TreeItem[] items = _viewer.getTree().getItems();

		assertTrue("There should be some items.", items.length > 0); //$NON-NLS-1$

		assertEquals(_project, items[_projectInd].getData());

		// we do this to force the rendering of the children of items[0]
		_viewer
				.setSelection(new StructuredSelection(_project
						.getFile(".project"))); //$NON-NLS-1$

		TreeItem[] children = items[_projectInd].getItems();

		assertEquals(_expectedChildren.size(), children.length);
		for (int i = 0; i < children.length; i++) {
			assertTrue(_expectedChildren.contains(children[i].getData()));
		}

	}

	@Test
	public void testNavigatorExtensionEnablement() throws Exception {

		_contentService.getActivationService().activateExtensions(new String[] {}, true);

		refreshViewer();
		_viewer.expandAll();

		TreeItem[] items = _viewer.getTree().getItems();

		assertTrue("There should be NO items.", items.length == 0); //$NON-NLS-1$

		_contentService.getActivationService().deactivateExtensions(new String[] {}, true);

		_viewer.expandToLevel(2);

		items = _viewer.getTree().getItems();

		assertTrue("There should be some items.", items.length > 0); //$NON-NLS-1$

	}

}
