# Contributing to django-distill

Thank you for showing an interest in contributing to `django-distill`!


## Code of Conduct

This project and everyone participating in it is governed by the [CONTRIBUTING.md Code of Conduct](blob/master/CODE_OF_CONDUCT.md). By participating, you are expected to uphold this code.


## Questions

> If you want to ask a question, we assume that you have read the available [Documentation](blob/master/README.md).

Before you ask a question please look for existing [Issues](/issues) that might help you. In case you have found a suitable issue and still need clarification you can ask your question in the existing issue.

If you then still feel the need to ask a question and need clarification please:

- Open an [Issue](/issues/new).
- Provide as much context as you can about what you're running into.
- Provide project and platform versions (Python, Django, etc), depending on what seems relevant.

We review issues regularly.


## Contributing

> ### Legal Notice 
> When contributing to this project you must agree that you have authored all of the content of your contribution, that you have the necessary rights to the content and that the content you contribute may be provided under the project license (MIT).


### Reporting Bugs


#### Before Submitting a Bug Report

A good bug report shouldn't leave others needing to chase you up for more information. We ask you to investigate carefully, collect information and describe the issue in detail in your report.

- Make sure that you are using the latest version.
- Determine if your bug is really a bug and not an error on your side (for example using incompatible environment components/versions).
- Make sure that you have read the [documentation](blob/master/README.md).
- To see if other users have experienced (and potentially already solved) the same issue you are having, check if there is not already a bug report existing for your bug or error in the [issues](issues).
- Also make sure to search the internet to see if users outside of the GitHub community have discussed the issue.
- Collect information about the bug such as stack traces, OS and platform version, versions of Python and Django:
- Can you reliably reproduce the issue? Can you reproduce this issue with the previous version?


#### Submitting a Bug Report

> You must never report security related issues which contain sensitive information, vulnerabilities or bugs including sensitive information to the issue tracker, or elsewhere in public.
> In the extremely unlikely event you do find a critical security issue with a static site generator you can send an email to <meeb@meeb.org> with the details


We use GitHub issues to track bugs and features. If you run into an issue with the project:

- Open an [Issue](/issues/new).
- Explain the behavior you would expect and the actual behavior.
- Please provide as much context as possible and describe the *reproduction steps* that someone else can follow to recreate the issue on their own. This may include a bare bones example of your code.
- Provide the information you collected in the previous section.

Once the issue is created:

- The project team will label the issue accordingly.
- A team member will try to reproduce the issue with your provided steps.
- If the team is able to reproduce the issue the issue will be left to be implemented or resolved


### Suggesting Enhancements

This section guides you through submitting an enhancement suggestion for CONTRIBUTING.md, **including completely new features and minor improvements to existing functionality**. Following these guidelines will help maintainers and the community to understand your suggestion and find related suggestions.


#### Before Submitting an Enhancement

- Make sure that you are using the latest version.
- Read the [documentation](blob/master/README.md) carefully and find out if the functionality is already covered.
- Perform a [search](/issues) to see if the enhancement has already been suggested. If it has, add a comment to the existing issue instead of opening a new one.
- Find out whether your idea fits with the scope and aims of the project. It's up to you to make a strong case to convince the project's developers of the merits of this feature. Keep in mind that we want features that will be useful to the majority of people using `django-distill` and not just a small subset.


#### Submitting an Enhancement Suggestion

Enhancement suggestions are tracked as [GitHub issues](/issues).

- Use a **clear and descriptive title** for the issue to identify the suggestion.
- Provide a **step-by-step description of the suggested enhancement** in as many details as possible.
- **Describe the current behavior** and **explain which behavior you expected to see instead** and why. At this point you can also tell which alternatives do not work for you.
- **Explain why this enhancement would be useful** to most CONTRIBUTING.md users.


### Code Contribution

Sensible and well formatted, easy to follow and concise pull requests are welcome. We may not merge your requested feature but it will be reviewed and discussed.



### Improving The Documentation

Sensible and well formatted, easy to follow and concise amendments to the documentation submitted as pull requests are welcome.



## Maintainers

`django-distill` is not currently looking for additional maintainers or administrators, however contributions are welcome.
