/*

   Derby - Class org.apache.derby.impl.jdbc.EmbedPreparedStatement20

   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to you under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 */

package org.apache.derby.impl.jdbc;

import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.Util;

import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.error.StandardException;

import org.apache.derby.iapi.reference.SQLState;

import java.io.InputStream;

import java.math.BigDecimal;
import java.math.BigInteger;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;


/* ---- New jdbc 2.0 types ----- */
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Ref;
import java.sql.Types;

/**
 * This class extends the EmbedPreparedStatement class in order to support new
 * methods and classes that come with JDBC 2.0.
  <P><B>Supports</B>
   <UL>
   <LI> JDBC 2.0
   </UL>
 *	@see org.apache.derby.impl.jdbc.EmbedPreparedStatement
 *
 */
public abstract class EmbedPreparedStatement20
	extends org.apache.derby.impl.jdbc.EmbedPreparedStatement {

	//////////////////////////////////////////////////////////////
	//
	// CONSTRUCTORS
	//
	//////////////////////////////////////////////////////////////
	/*
		Constructor assumes caller will setup context stack
		and restore it.
	    @exception SQLException on error
	 */
	public EmbedPreparedStatement20 (EmbedConnection conn, String sql, boolean forMetaData,
									  int resultSetType,
									  int resultSetConcurrency,
									  int resultSetHoldability,
									  int autoGeneratedKeys,
									  int[] columnIndexes,
									  String[] columnNames)
		throws SQLException {

		super(conn, sql, forMetaData, resultSetType, resultSetConcurrency, resultSetHoldability,
		autoGeneratedKeys, columnIndexes, columnNames);
	}

    /**
     * JDBC 2.0
     *
     * Set a REF(&lt;structured-type&gt;) parameter.
     *
     * @param i the first parameter is 1, the second is 2, ...
     * @param x an object representing data of an SQL REF Type
     * @exception SQLException Feature not implemented for now.
     */
    public void setRef (int i, Ref x) throws SQLException {
		throw Util.notImplemented();
	}




    /**
     * JDBC 2.0
     *
     * Set an Array parameter.
     *
     * @param i the first parameter is 1, the second is 2, ...
     * @param x an object representing an SQL array
     * @exception SQLException Feature not implemented for now.
     */
    public void setArray (int i, Array x) throws SQLException {
		throw Util.notImplemented();
	}

}

