/*
  xmms - DBMix output plugin

   Description: 
   ============
   This program is an output plugin for xmms v0.9 or greater.
   The plugin allows a data stream to be generated using xmms,
   an to be sent to the DBMix sound daemon for 
   Fourier/Additive Synthesis.  This allows a user may output multiple
   audio streams concurrently to the same audio device.
  

   Original Output Plugin code: (C) 1998-1999 Mikael Alm, Olle Hallnas,
                                Thomas Nillson and 4Front Technologies

   Modifications by Robert Michael S Dean, (c) 1999-2000

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public Licensse as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "dbmixout.h"

#include <dbaudiolib.h>
#include <dbchannel.h>

#ifdef DBMIX_DYNAMIC_LIBRARY
extern local_channel* dbmix_ch;
extern DBAudioLibFunctions *dbaudiofxns;
#endif

void dbmix_get_volume(int *l, int *r)
{
#ifdef DBMIX_DYNAMIC_LIBRARY
	dbaudiofxns->DBAudio_Get_Volume(l,r);
#else
	DBAudio_Get_Volume(l,r);
#endif
}

void dbmix_set_volume(int l, int r)
{
#ifdef DBMIX_DYNAMIC_LIBRARY
	dbaudiofxns->DBAudio_Set_Volume(l,r);
#else
	DBAudio_Set_Volume(l,r);
#endif
}
