#ifndef _PARSE_H
#define _PARSE_H

// Various routines that deal with parsing; both HTTP requests and more generic text.

#include <stddef.h>
#include <string>
#include <vector>

// Split a line on whitespace, e.g. "foo  bar baz" -> {"foo", "bar", "baz"}.
std::vector<std::string> split_tokens(const std::string &line);

// Split a string on \n or \r\n, e.g. "foo\nbar\r\n\nbaz\r\n\r\n" -> {"foo", "bar", "baz"}.
std::vector<std::string> split_lines(const std::string &str);

// Add the new data to an existing string, looking for \r\n\r\n
// (typical of HTTP requests and/or responses). Will return one
// of the given statuses.
//
// Note that if you give too much data in new_data_size, you could
// get an RP_OUT_OF_SPACE even if you expected RP_EXTRA_DATA.
// Be careful about how large reads you give in.
enum RequestParseStatus {
	RP_OUT_OF_SPACE,       // If larger than 16 kB.
	RP_NOT_FINISHED_YET,   // Did not get \r\n\r\n yet. 
	RP_EXTRA_DATA,         // Got \r\n\r\n, but there was extra data behind it.
	RP_FINISHED,           // Ended exactly in \r\n\r\n.
};
RequestParseStatus wait_for_double_newline(std::string *existing_data, const char *new_data, size_t new_data_size);

#endif  // !defined(_PARSE_H)
