require "spec"
require "crypto/blowfish"

describe "Crypto::Blowfish" do
  vectors = [
    {UInt8[0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00], UInt32[0x00000000, 0x00000000], UInt32[0x4EF99745, 0x6198DD78]},
    {UInt8[0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF], UInt32[0xFFFFFFFF, 0xFFFFFFFF], UInt32[0x51866FD5, 0xB85ECB8A]},
    {UInt8[0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00], UInt32[0x10000000, 0x00000001], UInt32[0x7D856F9A, 0x613063F2]},
    {UInt8[0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11], UInt32[0x11111111, 0x11111111], UInt32[0x2466DD87, 0x8B963C9D]},
    {UInt8[0x01, 0x23, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xEF], UInt32[0x11111111, 0x11111111], UInt32[0x61F9C380, 0x2281B096]},
    {UInt8[0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11], UInt32[0x01234567, 0x89ABCDEF], UInt32[0x7D0CC630, 0xAFDA1EC7]},
    {UInt8[0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00], UInt32[0x00000000, 0x00000000], UInt32[0x4EF99745, 0x6198DD78]},
    {UInt8[0xFE, 0xDC, 0xBA, 0x98, 0x76, 0x54, 0x32, 0x10], UInt32[0x01234567, 0x89ABCDEF], UInt32[0x0ACEAB0F, 0xC6A0A28D]},
    {UInt8[0x7C, 0xA1, 0x10, 0x45, 0x4A, 0x1A, 0x6E, 0x57], UInt32[0x01A1D6D0, 0x39776742], UInt32[0x59C68245, 0xEB05282B]},
    {UInt8[0x01, 0x31, 0xD9, 0x61, 0x9D, 0xC1, 0x37, 0x6E], UInt32[0x5CD54CA8, 0x3DEF57DA], UInt32[0xB1B8CC0B, 0x250F09A0]},
    {UInt8[0x07, 0xA1, 0x13, 0x3E, 0x4A, 0x0B, 0x26, 0x86], UInt32[0x0248D438, 0x06F67172], UInt32[0x1730E577, 0x8BEA1DA4]},
    {UInt8[0x38, 0x49, 0x67, 0x4C, 0x26, 0x02, 0x31, 0x9E], UInt32[0x51454B58, 0x2DDF440A], UInt32[0xA25E7856, 0xCF2651EB]},
    {UInt8[0x04, 0xB9, 0x15, 0xBA, 0x43, 0xFE, 0xB5, 0xB6], UInt32[0x42FD4430, 0x59577FA2], UInt32[0x353882B1, 0x09CE8F1A]},
    {UInt8[0x01, 0x13, 0xB9, 0x70, 0xFD, 0x34, 0xF2, 0xCE], UInt32[0x059B5E08, 0x51CF143A], UInt32[0x48F4D088, 0x4C379918]},
    {UInt8[0x01, 0x70, 0xF1, 0x75, 0x46, 0x8F, 0xB5, 0xE6], UInt32[0x0756D8E0, 0x774761D2], UInt32[0x432193B7, 0x8951FC98]},
    {UInt8[0x43, 0x29, 0x7F, 0xAD, 0x38, 0xE3, 0x73, 0xFE], UInt32[0x762514B8, 0x29BF486A], UInt32[0x13F04154, 0xD69D1AE5]},
    {UInt8[0x07, 0xA7, 0x13, 0x70, 0x45, 0xDA, 0x2A, 0x16], UInt32[0x3BDD1190, 0x49372802], UInt32[0x2EEDDA93, 0xFFD39C79]},
    {UInt8[0x04, 0x68, 0x91, 0x04, 0xC2, 0xFD, 0x3B, 0x2F], UInt32[0x26955F68, 0x35AF609A], UInt32[0xD887E039, 0x3C2DA6E3]},
    {UInt8[0x37, 0xD0, 0x6B, 0xB5, 0x16, 0xCB, 0x75, 0x46], UInt32[0x164D5E40, 0x4F275232], UInt32[0x5F99D04F, 0x5B163969]},
    {UInt8[0x1F, 0x08, 0x26, 0x0D, 0x1A, 0xC2, 0x46, 0x5E], UInt32[0x6B056E18, 0x759F5CCA], UInt32[0x4A057A3B, 0x24D3977B]},
    {UInt8[0x58, 0x40, 0x23, 0x64, 0x1A, 0xBA, 0x61, 0x76], UInt32[0x004BD6EF, 0x09176062], UInt32[0x452031C1, 0xE4FADA8E]},
    {UInt8[0x02, 0x58, 0x16, 0x16, 0x46, 0x29, 0xB0, 0x07], UInt32[0x480D3900, 0x6EE762F2], UInt32[0x7555AE39, 0xF59B87BD]},
    {UInt8[0x49, 0x79, 0x3E, 0xBC, 0x79, 0xB3, 0x25, 0x8F], UInt32[0x437540C8, 0x698F3CFA], UInt32[0x53C55F9C, 0xB49FC019]},
    {UInt8[0x4F, 0xB0, 0x5E, 0x15, 0x15, 0xAB, 0x73, 0xA7], UInt32[0x072D43A0, 0x77075292], UInt32[0x7A8E7BFA, 0x937E89A3]},
    {UInt8[0x49, 0xE9, 0x5D, 0x6D, 0x4C, 0xA2, 0x29, 0xBF], UInt32[0x02FE5577, 0x8117F12A], UInt32[0xCF9C5D7A, 0x4986ADB5]},
    {UInt8[0x01, 0x83, 0x10, 0xDC, 0x40, 0x9B, 0x26, 0xD6], UInt32[0x1D9D5C50, 0x18F728C2], UInt32[0xD1ABB290, 0x658BC778]},
    {UInt8[0x1C, 0x58, 0x7F, 0x1C, 0x13, 0x92, 0x4F, 0xEF], UInt32[0x30553228, 0x6D6F295A], UInt32[0x55CB3774, 0xD13EF201]},
    {UInt8[0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01], UInt32[0x01234567, 0x89ABCDEF], UInt32[0xFA34EC48, 0x47B268B2]},
    {UInt8[0x1F, 0x1F, 0x1F, 0x1F, 0x0E, 0x0E, 0x0E, 0x0E], UInt32[0x01234567, 0x89ABCDEF], UInt32[0xA7907951, 0x08EA3CAE]},
    {UInt8[0xE0, 0xFE, 0xE0, 0xFE, 0xF1, 0xFE, 0xF1, 0xFE], UInt32[0x01234567, 0x89ABCDEF], UInt32[0xC39E072D, 0x9FAC631D]},
    {UInt8[0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00], UInt32[0xFFFFFFFF, 0xFFFFFFFF], UInt32[0x014933E0, 0xCDAFF6E4]},
    {UInt8[0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF], UInt32[0x00000000, 0x00000000], UInt32[0xF21E9A77, 0xB71C49BC]},
    {UInt8[0x01, 0x23, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xEF], UInt32[0x00000000, 0x00000000], UInt32[0x24594688, 0x5754369A]},
    {UInt8[0xFE, 0xDC, 0xBA, 0x98, 0x76, 0x54, 0x32, 0x10], UInt32[0xFFFFFFFF, 0xFFFFFFFF], UInt32[0x6B5C5A9C, 0x5D9E0A5A]},
  ]

  it "encrypt and decrypt pair" do
    vectors.each_with_index do |(key, text, cipher), index|
      bf = Crypto::Blowfish.new(16)
      bf.expand_key(key)

      # encrypt_pair
      lr = bf.encrypt_pair(text[0], text[1])
      lr.to_a.should eq(cipher)

      # decrypt_pair
      lr = bf.decrypt_pair(lr[0], lr[1])
      lr.to_a.should eq(text)
    end
  end
end
