/*
 * CRRCsim - the Charles River Radio Control Club Flight Simulator Project
 *
 * Copyright (C) 2012 Luca Gasparini (original author)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
  

// puaImageFrame.h - a frame housing a texture (image).

#ifndef __PUAIMAGEFRAME_H
#define __PUAIMAGEFRAME_H

// Include config file generated by configure
#ifdef HAVE_CONFIG_H
#  include <crrc_config.h>
#endif

#include <plib/pu.h>
#include <plib/ssg.h>


/**
 * Frame housing a texture (image)
 */
class puaImageFrame : public puFrame
{
  public:
    puaImageFrame (int minx, int miny, int maxx, int maxy, ssgTexture *image = NULL);
    void setTexture(ssgTexture *image) {_image = image;};
    // getTexture() must be public to be accessible from the
    // renderCallback function, but it is not really needed outside
    ssgTexture* getTexture() {return _image;};
  
  private:
    ssgTexture *_image;
    
    static void puaImageFrameRenderCallback(puObject *obj, int x0, int y0, void *dlg);
};

#endif // __PUAIMAGEFRAME_H
