/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.CurrentItemExpression;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.GeneralComparison10;
import net.sf.saxon.expr.LazyExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.QuantifiedExpression;
import net.sf.saxon.expr.RangeVariableDeclaration;
import net.sf.saxon.expr.SimpleMappingExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.functions.ExtensionFunctionCall;
import net.sf.saxon.instruct.AnalyzeString;
import net.sf.saxon.instruct.ApplyTemplates;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.ForEach;
import net.sf.saxon.instruct.ForEachGroup;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.instruct.While;
import net.sf.saxon.instruct.WithParam;
import net.sf.saxon.om.Axis;
import net.sf.saxon.om.GroundedIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.sort.SortExpression;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.ShareableSequence;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class ExpressionTool {
    public static final int UNDECIDED = -1;
    public static final int NO_EVALUATION_NEEDED = 0;
    public static final int EVALUATE_VARIABLE = 1;
    public static final int MAKE_CLOSURE = 3;
    public static final int MAKE_MEMO_CLOSURE = 4;
    public static final int RETURN_EMPTY_SEQUENCE = 5;
    public static final int EVALUATE_AND_MATERIALIZE_VARIABLE = 6;
    public static final int CALL_EVALUATE_ITEM = 7;
    public static final int ITERATE_AND_MATERIALIZE = 8;
    public static final int PROCESS = 9;
    public static final int LAZY_TAIL_EXPRESSION = 10;
    public static final int SHARED_APPEND_EXPRESSION = 11;

    private ExpressionTool() {
    }

    public static Expression make(String string, StaticContext staticContext, int n, int n2, int n3) throws XPathException {
        ExpressionParser expressionParser = new ExpressionParser();
        if (n2 == -1) {
            n2 = 0;
        }
        Expression expression = expressionParser.parse(string, n, n2, n3, staticContext);
        expression = expression.simplify(staticContext);
        ExpressionTool.makeParentReferences(expression);
        return expression;
    }

    public static void copyLocationInfo(Expression expression, Expression expression2) {
        if (expression instanceof ComputedExpression && expression2 instanceof ComputedExpression) {
            ((ComputedExpression)expression2).setLocationId(((ComputedExpression)expression).getLocationId());
        }
    }

    public static void makeParentReferences(Expression expression) {
    }

    public static SourceLocator getLocator(Expression expression) {
        if (expression instanceof ComputedExpression) {
            return (ComputedExpression)expression;
        }
        return null;
    }

    public static boolean isRepeatedSubexpression(Expression expression, Expression expression2, StaticContext staticContext) {
        if (expression instanceof PathExpression) {
            return expression2 == ((PathExpression)expression).getStepExpression();
        }
        if (expression instanceof FilterExpression) {
            TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
            return expression2 == ((FilterExpression)expression).getFilter() && !typeHierarchy.isSubType(expression2.getItemType(typeHierarchy), Type.NUMBER_TYPE);
        }
        if (expression instanceof ForExpression) {
            return expression2 == ((ForExpression)expression).getAction();
        }
        if (expression instanceof QuantifiedExpression) {
            return expression2 == ((QuantifiedExpression)expression).getAction();
        }
        if (expression instanceof SimpleMappingExpression) {
            return expression2 == ((SimpleMappingExpression)expression).getStepExpression();
        }
        if (expression instanceof SortExpression) {
            return ((SortExpression)expression).isSortKey(expression2);
        }
        if (expression instanceof AnalyzeString) {
            return expression2 == ((AnalyzeString)expression).getMatchingExpression() || expression2 == ((AnalyzeString)expression).getNonMatchingExpression();
        }
        if (expression instanceof ForEach) {
            return expression2 == ((ForEach)expression).getActionExpression();
        }
        if (expression instanceof ForEachGroup) {
            return expression2 == ((ForEachGroup)expression).getActionExpression();
        }
        if (expression instanceof While) {
            return expression2 == ((While)expression).getActionExpression();
        }
        if (expression instanceof GeneralComparison) {
            return expression2 == ((GeneralComparison)expression).getOperands()[1];
        }
        if (expression instanceof GeneralComparison10) {
            Expression[] expressionArray = ((GeneralComparison10)expression).getOperands();
            return expression2 == expressionArray[0] || expression2 == expressionArray[1];
        }
        if (expression instanceof ApplyTemplates) {
            return expression2 instanceof WithParam;
        }
        return false;
    }

    public static Expression unsorted(Optimizer optimizer, Expression expression, boolean bl) throws XPathException {
        if (expression instanceof Value) {
            return expression;
        }
        PromotionOffer promotionOffer = new PromotionOffer(optimizer);
        promotionOffer.action = 13;
        promotionOffer.mustEliminateDuplicates = bl;
        Expression expression2 = expression.promote(promotionOffer);
        if (expression2 != expression) {
            ComputedExpression.setParentExpression(expression2, expression.getParentExpression());
            return expression2;
        }
        return expression;
    }

    public static Expression unsortedIfHomogeneous(Optimizer optimizer, Expression expression, boolean bl) throws XPathException {
        if (expression instanceof Value) {
            return expression;
        }
        if (expression.getItemType(optimizer.getConfiguration().getTypeHierarchy()) instanceof AnyItemType) {
            return expression;
        }
        PromotionOffer promotionOffer = new PromotionOffer(optimizer);
        promotionOffer.action = 13;
        promotionOffer.mustEliminateDuplicates = bl;
        return expression.promote(promotionOffer);
    }

    public static int lazyEvaluationMode(Expression expression) {
        if (expression instanceof Value) {
            return 0;
        }
        if (expression instanceof VariableReference) {
            return 1;
        }
        if ((expression.getDependencies() & 0x6D) != 0) {
            return ExpressionTool.eagerEvaluationMode(expression);
        }
        if (expression instanceof ErrorExpression) {
            return 7;
        }
        if (expression instanceof LazyExpression) {
            return 4;
        }
        if (!Cardinality.allowsMany(expression.getCardinality())) {
            return ExpressionTool.eagerEvaluationMode(expression);
        }
        if (expression instanceof TailExpression) {
            TailExpression tailExpression = (TailExpression)expression;
            Expression expression2 = tailExpression.getBaseExpression();
            if (expression2 instanceof VariableReference) {
                return 10;
            }
            return 3;
        }
        if (expression instanceof Block && ((Block)expression).getChildren().length == 2 && (((Block)expression).getChildren()[0] instanceof VariableReference || ((Block)expression).getChildren()[0] instanceof Value)) {
            return 11;
        }
        return 3;
    }

    public static int eagerEvaluationMode(Expression expression) {
        if (expression instanceof Value && !(expression instanceof Closure)) {
            return 0;
        }
        if (expression instanceof VariableReference) {
            return 6;
        }
        int n = expression.getImplementationMethod();
        if ((n & 1) != 0) {
            return 7;
        }
        if ((n & 2) != 0) {
            return 8;
        }
        return 9;
    }

    public static ValueRepresentation evaluate(Expression expression, int n, XPathContext xPathContext, int n2) throws XPathException {
        switch (n) {
            case 0: {
                return (Value)expression;
            }
            case 1: {
                return ((VariableReference)expression).evaluateVariable(xPathContext);
            }
            case 3: {
                return Closure.make(expression, xPathContext, n2);
            }
            case 4: {
                return Closure.make(expression, xPathContext, n2 == 1 ? 10 : n2);
            }
            case 5: {
                return EmptySequence.getInstance();
            }
            case 6: {
                ValueRepresentation valueRepresentation = ((VariableReference)expression).evaluateVariable(xPathContext);
                if (valueRepresentation instanceof Closure) {
                    return SequenceExtent.makeSequenceExtent(((Closure)valueRepresentation).iterate(xPathContext));
                }
                return valueRepresentation;
            }
            case 7: {
                Item item = expression.evaluateItem(xPathContext);
                if (item == null) {
                    return EmptySequence.getInstance();
                }
                return item;
            }
            case -1: 
            case 8: {
                return SequenceExtent.makeSequenceExtent(expression.iterate(xPathContext));
            }
            case 9: {
                Controller controller = xPathContext.getController();
                XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
                xPathContextMinor.setOrigin((InstructionInfoProvider)((Object)expression));
                SequenceOutputter sequenceOutputter = controller.allocateSequenceOutputter(20);
                PipelineConfiguration pipelineConfiguration = controller.makePipelineConfiguration();
                pipelineConfiguration.setHostLanguage(expression instanceof ComputedExpression ? ((ComputedExpression)expression).getHostLanguage() : controller.getExecutable().getHostLanguage());
                sequenceOutputter.setPipelineConfiguration(pipelineConfiguration);
                xPathContextMinor.setTemporaryReceiver(sequenceOutputter);
                sequenceOutputter.open();
                expression.process(xPathContextMinor);
                sequenceOutputter.close();
                ValueRepresentation valueRepresentation = sequenceOutputter.getSequence();
                sequenceOutputter.reset();
                return valueRepresentation;
            }
            case 10: {
                TailExpression tailExpression = (TailExpression)expression;
                VariableReference variableReference = (VariableReference)tailExpression.getBaseExpression();
                ValueRepresentation valueRepresentation = ExpressionTool.evaluate(variableReference, 1, xPathContext, n2);
                if (valueRepresentation instanceof MemoClosure) {
                    SequenceIterator sequenceIterator = ((MemoClosure)valueRepresentation).iterate(null);
                    valueRepresentation = ((GroundedIterator)sequenceIterator).materialize();
                }
                if (valueRepresentation instanceof IntegerRange) {
                    long l;
                    long l2 = ((IntegerRange)valueRepresentation).getStart() + 1L;
                    if (l2 == (l = ((IntegerRange)valueRepresentation).getEnd())) {
                        return new IntegerValue(l);
                    }
                    return new IntegerRange(l2, l);
                }
                if (valueRepresentation instanceof SequenceExtent) {
                    return new SequenceExtent((SequenceExtent)valueRepresentation, tailExpression.getStart() - 1, ((SequenceExtent)valueRepresentation).getLength() - tailExpression.getStart() + 1);
                }
                return Closure.make(tailExpression, xPathContext, n2);
            }
            case 11: {
                Item item;
                Block block = (Block)expression;
                Expression expression2 = block.getChildren()[0];
                if (expression2 instanceof VariableReference && (expression2 = Value.asValue(ExpressionTool.evaluate(expression2, 1, xPathContext, n2))) instanceof MemoClosure && ((MemoClosure)expression2).isFullyRead()) {
                    expression2 = ((MemoClosure)expression2).materialize();
                }
                if (expression2 instanceof ShareableSequence && ((ShareableSequence)expression2).isShareable()) {
                    Item item2;
                    List list = ((ShareableSequence)expression2).getList();
                    SequenceIterator sequenceIterator = block.getChildren()[1].iterate(xPathContext);
                    while ((item2 = sequenceIterator.next()) != null) {
                        list.add(item2);
                    }
                    return new ShareableSequence(list);
                }
                if (!(expression2 instanceof Value)) break;
                ArrayList<Item> arrayList = new ArrayList<Item>(20);
                SequenceIterator sequenceIterator = expression2.iterate(xPathContext);
                while ((item = sequenceIterator.next()) != null) {
                    arrayList.add(item);
                }
                sequenceIterator = block.getChildren()[1].iterate(xPathContext);
                while ((item = sequenceIterator.next()) != null) {
                    arrayList.add(item);
                }
                return new ShareableSequence(arrayList);
            }
        }
        throw new IllegalArgumentException("Unknown evaluation mode " + n);
    }

    public static ValueRepresentation lazyEvaluate(Expression expression, XPathContext xPathContext, int n) throws XPathException {
        int n2 = ExpressionTool.lazyEvaluationMode(expression);
        return ExpressionTool.evaluate(expression, n2, xPathContext, n);
    }

    public static ValueRepresentation eagerEvaluate(Expression expression, XPathContext xPathContext) throws XPathException {
        int n = ExpressionTool.eagerEvaluationMode(expression);
        return ExpressionTool.evaluate(expression, n, xPathContext, 10);
    }

    public static boolean markTailFunctionCalls(Expression expression, int n, int n2) {
        if (expression instanceof ComputedExpression) {
            return ((ComputedExpression)expression).markTailFunctionCalls(n, n2);
        }
        return false;
    }

    public static String indent(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "  ";
        }
        return string;
    }

    public static int allocateSlots(Expression expression, int n, SlotManager slotManager) {
        return ExpressionTool.allocateSlots(expression, n, slotManager, true);
    }

    private static int allocateSlots(Expression expression, int n, SlotManager slotManager, boolean bl) {
        Expression expression2;
        if (expression instanceof Assignation) {
            ((Assignation)expression).setSlotNumber(n);
            int n2 = ((Assignation)expression).getRequiredSlots();
            n += n2;
            if (slotManager != null) {
                slotManager.allocateSlotNumber(((Assignation)expression).getVariableFingerprint());
                if (n2 == 2) {
                    slotManager.allocateSlotNumber(((ForExpression)expression).getPositionVariableNameCode() & 0xFFFFF);
                }
            }
        }
        Iterator iterator = expression.iterateSubExpressions();
        while (iterator.hasNext()) {
            expression2 = (Expression)iterator.next();
            n = ExpressionTool.allocateSlots(expression2, n, slotManager, false);
        }
        if (bl) {
            iterator = expression.iterateSubExpressions();
            while (iterator.hasNext()) {
                expression2 = (Expression)iterator.next();
                ExpressionTool.refineVariableReference(expression2);
            }
        }
        return n;
    }

    private static void refineVariableReference(Expression expression) {
        if (expression instanceof VariableReference) {
            ((VariableReference)expression).refineVariableReference();
        } else {
            Iterator iterator = expression.iterateSubExpressions();
            while (iterator.hasNext()) {
                Expression expression2 = (Expression)iterator.next();
                ExpressionTool.refineVariableReference(expression2);
            }
        }
    }

    public static boolean effectiveBooleanValue(SequenceIterator sequenceIterator) throws XPathException {
        Item item = sequenceIterator.next();
        if (item == null) {
            return false;
        }
        if (item instanceof NodeInfo) {
            return true;
        }
        if ((item = ((AtomicValue)item).getPrimitiveValue()) instanceof BooleanValue) {
            if (sequenceIterator.next() != null) {
                ExpressionTool.ebvError("sequence of two or more items starting with a boolean");
            }
            return ((BooleanValue)item).getBooleanValue();
        }
        if (item instanceof StringValue) {
            if (sequenceIterator.next() != null) {
                ExpressionTool.ebvError("sequence of two or more items starting with a string");
            }
            return item.getStringValueCS().length() != 0;
        }
        if (item instanceof NumericValue) {
            NumericValue numericValue;
            if (sequenceIterator.next() != null) {
                ExpressionTool.ebvError("sequence of two or more items starting with a numeric value");
            }
            return (numericValue = (NumericValue)item).compareTo(0L) != 0 && !numericValue.isNaN();
        }
        if (item instanceof ObjectValue) {
            if (sequenceIterator.next() != null) {
                ExpressionTool.ebvError("sequence of two or more items starting with a numeric value");
            }
            return ((ObjectValue)item).getObject() != null;
        }
        ExpressionTool.ebvError("sequence starting with an atomic value other than a boolean, number, string, or URI");
        return false;
    }

    public static void ebvError(String string) throws XPathException {
        DynamicError dynamicError = new DynamicError("Effective boolean value is not defined for a " + string);
        dynamicError.setErrorCode("FORG0006");
        dynamicError.setIsTypeError(true);
        throw dynamicError;
    }

    public static boolean dependsOnVariable(Expression expression, Binding[] bindingArray) {
        if (expression instanceof VariableReference) {
            for (int i = 0; i < bindingArray.length; ++i) {
                if (((VariableReference)expression).getBinding() != bindingArray[i]) continue;
                return true;
            }
            return false;
        }
        Iterator iterator = expression.iterateSubExpressions();
        while (iterator.hasNext()) {
            Expression expression2 = (Expression)iterator.next();
            if (!ExpressionTool.dependsOnVariable(expression2, bindingArray)) continue;
            return true;
        }
        return false;
    }

    public static void gatherReferencedVariables(Expression expression, List list) {
        if (expression instanceof VariableReference) {
            Binding binding = ((VariableReference)expression).getBinding();
            if (!list.contains(binding)) {
                list.add(binding);
            }
        } else {
            Iterator iterator = expression.iterateSubExpressions();
            while (iterator.hasNext()) {
                Expression expression2 = (Expression)iterator.next();
                ExpressionTool.gatherReferencedVariables(expression2, list);
            }
        }
    }

    public static boolean callsFunction(Expression expression, int n) {
        if (expression instanceof FunctionCall && (((FunctionCall)expression).getFunctionNameCode() & 0xFFFFF) == n) {
            return true;
        }
        Iterator iterator = expression.iterateSubExpressions();
        while (iterator.hasNext()) {
            Expression expression2 = (Expression)iterator.next();
            if (!ExpressionTool.callsFunction(expression2, n)) continue;
            return true;
        }
        return false;
    }

    public static void gatherCalledFunctions(Expression expression, List list) {
        if (expression instanceof UserFunctionCall) {
            UserFunction userFunction = ((UserFunctionCall)expression).getFunction();
            if (!list.contains(userFunction)) {
                list.add(userFunction);
            }
        } else {
            Iterator iterator = expression.iterateSubExpressions();
            while (iterator.hasNext()) {
                Expression expression2 = (Expression)iterator.next();
                ExpressionTool.gatherCalledFunctions(expression2, list);
            }
        }
    }

    public static Expression resolveCallsToCurrentFunction(Expression expression, Configuration configuration) throws XPathException {
        int n = configuration.getNamePool().getFingerprint("http://www.w3.org/2005/xpath-functions", "current");
        if (n == -1) {
            return expression;
        }
        if (ExpressionTool.callsFunction(expression, n)) {
            RangeVariableDeclaration rangeVariableDeclaration = new RangeVariableDeclaration();
            rangeVariableDeclaration.setNameCode(configuration.getNamePool().allocate("saxon", "http://saxon.sf.net/", "current" + expression.hashCode()));
            rangeVariableDeclaration.setVariableName("saxon:current");
            rangeVariableDeclaration.setRequiredType(SequenceType.SINGLE_ITEM);
            LetExpression letExpression = new LetExpression();
            letExpression.setSequence(new CurrentItemExpression());
            letExpression.setVariableDeclaration(rangeVariableDeclaration);
            PromotionOffer promotionOffer = new PromotionOffer(configuration.getOptimizer());
            promotionOffer.action = 14;
            promotionOffer.containingExpression = letExpression;
            expression = expression.promote(promotionOffer);
            letExpression.setAction(expression);
            return letExpression;
        }
        return expression;
    }

    public static boolean isVariableReplaceableByDot(Expression expression, Binding[] bindingArray) {
        if (expression instanceof ComputedExpression) {
            if (expression instanceof FilterExpression) {
                Expression expression2 = ((FilterExpression)expression).getBaseExpression();
                Expression expression3 = ((FilterExpression)expression).getFilter();
                return ExpressionTool.isVariableReplaceableByDot(expression2, bindingArray) && !ExpressionTool.dependsOnVariable(expression3, bindingArray);
            }
            if (expression instanceof PathExpression) {
                Expression expression4 = ((PathExpression)expression).getFirstStep();
                Expression expression5 = ((PathExpression)expression).getRemainingSteps();
                return ExpressionTool.isVariableReplaceableByDot(expression4, bindingArray) && !ExpressionTool.dependsOnVariable(expression5, bindingArray);
            }
            Iterator iterator = expression.iterateSubExpressions();
            while (iterator.hasNext()) {
                Expression expression6 = (Expression)iterator.next();
                if (ExpressionTool.isVariableReplaceableByDot(expression6, bindingArray)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean isSubtreeExpression(Expression expression) {
        if (expression instanceof Value) {
            return true;
        }
        if ((expression.getDependencies() & 0x1E) != 0) {
            if (expression instanceof ComputedExpression) {
                if (expression instanceof ContextItemExpression) {
                    return true;
                }
                if (expression instanceof AxisExpression) {
                    return Axis.isSubtreeAxis[((AxisExpression)expression).getAxis()];
                }
                if ((((ComputedExpression)expression).getIntrinsicDependencies() & 0x1E) != 0) {
                    return false;
                }
                if (expression instanceof ExtensionFunctionCall) {
                    return false;
                }
                Iterator iterator = expression.iterateSubExpressions();
                while (iterator.hasNext()) {
                    Expression expression2 = (Expression)iterator.next();
                    if (ExpressionTool.isSubtreeExpression(expression2)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return true;
    }
}

